// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_PIXBUF_H
#define _GDKMM_PIXBUF_H

#include <glibmm.h>

/* $Id: pixbuf.hg,v 1.9 2004/11/24 21:08:58 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/drawable.h>
#include <gdkmm/image.h>
#include <gdkmm/pixmap.h>
#include <gdkmm/bitmap.h>
#include <gdkmm/pixbufformat.h>
#include <gdkmm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkPixbuf GdkPixbuf;
typedef struct _GdkPixbufClass GdkPixbufClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Pixbuf_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum Colorspace
{
  COLORSPACE_RGB
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Colorspace> : public Glib::Value_Enum<Gdk::Colorspace>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum InterpType
{
  INTERP_NEAREST,
  INTERP_TILES,
  INTERP_BILINEAR,
  INTERP_HYPER
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InterpType> : public Glib::Value_Enum<Gdk::InterpType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum PixbufAlphaMode
{
  PIXBUF_ALPHA_BILEVEL,
  PIXBUF_ALPHA_FULL
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufAlphaMode> : public Glib::Value_Enum<Gdk::PixbufAlphaMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** Exception class for Gdk::Pixbuf errors.
 */
class PixbufError : public Glib::Error
{
public:
  enum Code
  {
    CORRUPT_IMAGE,
    INSUFFICIENT_MEMORY,
    BAD_OPTION,
    UNKNOWN_TYPE,
    UNSUPPORTED_OPERATION,
    FAILED
  };

  PixbufError(Code error_code, const Glib::ustring& error_message);
  explicit PixbufError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  static void throw_func(GError* gobject);
  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufError::Code> : public Glib::Value_Enum<Gdk::PixbufError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct PixbufFormatTraits
{
  typedef PixbufFormat  CppType;
  typedef const GdkPixbufFormat*      CType;
  typedef GdkPixbufFormat*            CTypeNonConst;

  static CType   to_c_type      (const CppType& obj) { return obj.gobj();     }
  static CType   to_c_type      (CType          ptr) { return ptr;                   }
  static CppType to_cpp_type    (CType          ptr) { return PixbufFormat(ptr); /* Does not take ownership */ }
  static void    release_c_type (CType          /* ptr */) { /* Doesn't happen */ }
};
#endif //DOXYGEN_SHOULD_SKIP_THIS
  

class Pixbuf : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pixbuf CppObjectType;
  typedef Pixbuf_Class CppClassType;
  typedef GdkPixbuf BaseObjectType;
  typedef GdkPixbufClass BaseClassType;

private:  friend class Pixbuf_Class;
  static CppClassType pixbuf_class_;

private:
  // noncopyable
  Pixbuf(const Pixbuf&);
  Pixbuf& operator=(const Pixbuf&);

protected:
  explicit Pixbuf(const Glib::ConstructParams& construct_params);
  explicit Pixbuf(GdkPixbuf* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pixbuf();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkPixbuf*       gobj()       { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkPixbuf* gobj() const { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkPixbuf* gobj_copy();

private:

  
protected:

  Pixbuf(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int dest_x, int dest_y, int width, int height);
  Pixbuf(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int dest_x, int dest_y, int width, int height);

public:
  typedef sigc::slot<void, const guint8*> SlotDestroyData;

  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);

  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);


  Glib::RefPtr<Pixbuf> copy() const;

  
  static Glib::RefPtr<Pixbuf> create(
                   Colorspace colorspace, bool has_alpha,
                   int bits_per_sample, int width, int height);

  
  /** 
   * @param src_pixbuf A Gdk::Pixbuf.
   * @param src_x X coord in @a src_pixbuf .
   * @param src_y Y coord in @a src_pixbuf .
   * @param width Width of region in @a src_pixbuf .
   * @param height Height of region in @a src_pixbuf .
   */
  static Glib::RefPtr<Pixbuf> create_subpixbuf(
                  const Glib::RefPtr<Pixbuf>& src_pixbuf,
                  int src_x, int src_y, int width, int height);

  /** Load an image file.
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename);

  /** Creates a new Gdk::Pixbuf out of in-memory image data.
   * Currently only RGB images with 8 bits per sample are supported.
   *
   * @param data %Image data in 8-bit/sample packed format.
   * @param colorspace Colorspace for the image data.
   * @param has_alpha Whether the data has an opacity channel.
   * @param bits_per_sample Number of bits per sample.
   * @param width Width of the image in pixels.
   * @param height Height of the image in pixels.
   * @param rowstride Distance in bytes between rows.
   * @return A newly-created Gdk::Pixbuf object.
   */
  static Glib::RefPtr<Pixbuf> create_from_data(const guint8* data, Colorspace colorspace,
                                               bool has_alpha, int bits_per_sample,
                                               int width, int height, int rowstride);

  /** Creates a new Gdk::Pixbuf out of in-memory image data.
   * Currently only RGB images with 8 bits per sample are supported.
   *
   * @param data %Image data in 8-bit/sample packed format.
   * @param colorspace Colorspace for the image data.
   * @param has_alpha Whether the data has an opacity channel.
   * @param bits_per_sample Number of bits per sample.
   * @param width Width of the image in pixels.
   * @param height Height of the image in pixels.
   * @param rowstride Distance in bytes between rows.
   * @param destroy_slot Slot used to free the data when the pixbuf's
   * reference count drops to zero.
   * @return A newly-created Gdk::Pixbuf object.
   */
  static Glib::RefPtr<Pixbuf> create_from_data(const guint8* data, Colorspace colorspace,
                                               bool has_alpha, int bits_per_sample,
                                               int width, int height, int rowstride,
                                               const SlotDestroyData& destroy_slot);

  
  static Glib::RefPtr<Pixbuf> create_from_xpm_data(const char *const * data);

  /** Create a Gdk::Pixbuf from a flat representation that is suitable for
   * storing as inline data in a program.  This is useful if you want to ship a
   * program with images, but don't want to depend on any external files.
   *
   * GTK+ ships with a program called <tt>gdk-pixbuf-csource</tt> which allows
   * for conversion of GdkPixbufs into such a inline representation. In almost
   * all cases, you should pass the <tt>--raw</tt> flag to
   * <tt>gdk-pixbuf-csource</tt>. A sample invocation would be:
   *
   * <tt>gdk-pixbuf-csource --raw --name=myimage_inline myimage.png</tt>
   *
   * For the typical case where the inline pixbuf is read-only static data, you
   * don't need to copy the pixel data unless you intend to write to it, so you
   * can pass <tt>false</tt> for @a copy_pixels. (If you pass <tt>--rle</tt> to
   * <tt>gdk-pixbuf-csource</tt>, a copy will be made even if @a copy_pixels is
   * <tt>false</tt>, so using this option is generally a bad idea.)
   *
   * If you create a pixbuf from const inline data compiled into your program,
   * it's probably safe to ignore errors, since things will always succeed. For
   * non-const inline data, you could get out of memory. For untrusted inline
   * data located at runtime, you could have corrupt inline data in addition.
   *
   * @param data_length Length in bytes of the @a data argument.
   * @param data Byte data containing a serialized GdkPixdata structure.
   * @param copy_pixels Whether to copy the pixel data, or use direct pointers
   * to @a data for the resulting pixbuf.
   * @throw Gdk::PixbufError
   */
  static Glib::RefPtr<Pixbuf> create_from_inline(int data_length, const guint8* data,
                                                 bool copy_pixels = false);

  
  Colorspace get_colorspace() const;

  
  int get_n_channels() const;
  
  bool get_has_alpha() const;
  
  int get_bits_per_sample() const;
  
  guint8* get_pixels() const;
  
  int get_width() const;
  
  int get_height() const;
  
  int get_rowstride() const;

  
  void fill(guint32 pixel);

  /** Save an image file.
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save(const std::string& filename, const Glib::ustring& type);
  

  /** Save an image file.
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save(const std::string& filename, const Glib::ustring& type,
            const Glib::StringArrayHandle& option_keys,
            const Glib::StringArrayHandle& option_values);
  

  Glib::RefPtr<Gdk::Pixbuf> add_alpha(
                   bool substitute_color, guint8 r, guint8 g, guint8 b) const;

  
  void copy_area(
                   int src_x, int src_y, int width, int height,
                   const Glib::RefPtr<Gdk::Pixbuf>& dest_pixbuf,
                   int dest_x, int dest_y) const;

  
  void saturate_and_pixelate(
                   const Glib::RefPtr<Gdk::Pixbuf>& dest,
                   float saturation, bool pixelate) const;


  void scale(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                          int    dest_x,      int    dest_y,
                          int    dest_width,  int    dest_height,
                          double offset_x,    double offset_y,
                          double scale_x,     double scale_y,
                          InterpType interp_type) const;

  
  void composite(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                              int    dest_x,      int    dest_y,
                              int    dest_width,  int    dest_height,
                              double offset_x,    double offset_y,
                              double scale_x,     double scale_y,
                              InterpType interp_type,
                              int overall_alpha) const;

  
  void composite_color(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                                    int    dest_x,      int    dest_y,
                                    int    dest_width,  int    dest_height,
                                    double offset_x,    double offset_y,
                                    double scale_x,     double scale_y,
                                    InterpType interp_type,
                                    int overall_alpha,
                                    int check_x, int check_y,
                                    int check_size,
                                    guint32 color1, guint32 color2) const;

  
  Glib::RefPtr<Gdk::Pixbuf> scale_simple(
                   int dest_width, int dest_height,
                   InterpType interp_type) const;

  
  Glib::RefPtr<Gdk::Pixbuf> composite_color_simple(
                   int dest_width, int dest_height,
                   InterpType interp_type,
                   int overall_alpha, int check_size,
                   guint32 color1, guint32 color2) const;


  /** Takes the opacity values in a rectangular portion of a pixbuf and thresholds
   * them to produce a bi-level alpha mask that can be used as a clipping mask for
   * a drawable.
   * @param bitmap Bitmap where the bilevel mask will be painted to.
   * @param src_x Source X coordinate.
   * @param src_y Source Y coordinate.
   * @param dest_x Destination X coordinate.
   * @param dest_y Destination Y coordinate.
   * @param width Width of region to threshold, or -1 to use pixbuf width.
   * @param height Height of region to threshold, or -1 to use pixbuf height.
   * @param alpha_threshold Opacity values below this will be painted as zero; all
   * other values will be painted as one.
   */
  void render_threshold_alpha(const Glib::RefPtr<Gdk::Bitmap>& bitmap,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height,
                                          int alpha_threshold);

  
  /** Renders a rectangular portion of a pixbuf to a drawable while using the
   * specified GC.  This is done using GdkRGB, so the specified drawable must have
   * the GdkRGB visual and colormap.  Note that this function will ignore the
   * opacity information for images with an alpha channel; the GC must already
   * have the clipping mask set if you want transparent regions to show through.
   * 
   * For an explanation of dither offsets, see the GdkRGB documentation.  In
   * brief, the dither offset is important when re-rendering partial regions of an
   * image to a rendered version of the full image, or for when the offsets to a
   * base position change, as in scrolling.  The dither matrix has to be shifted
   * for consistent visual results.  If you do not have any of these cases, the
   * dither offsets can be both zero.
   * 
   * Deprecated: This function is obsolete. Use gdk_draw_pixbuf() instead.
   * @param drawable Destination drawable.
   * @param gc GC used for rendering.
   * @param src_x Source X coordinate within pixbuf.
   * @param src_y Source Y coordinate within pixbuf.
   * @param dest_x Destination X coordinate within drawable.
   * @param dest_y Destination Y coordinate within drawable.
   * @param width Width of region to render, in pixels, or -1 to use pixbuf width.
   * @param height Height of region to render, in pixels, or -1 to use pixbuf height.
   * @param dither Dithering mode for GdkRGB.
   * @param x_dither X offset for dither.
   * @param y_dither Y offset for dither.
   */
  void render_to_drawable(const Glib::RefPtr<Drawable>& drawable,
                                          const Glib::RefPtr<Gdk::GC>& gc,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height,
                                          RgbDither dither,
                                          int x_dither, int y_dither);
  
  /** Renders a rectangular portion of a pixbuf to a drawable.  The destination
   * drawable must have a colormap. All windows have a colormap, however, pixmaps
   * only have colormap by default if they were created with a non-<tt>0</tt> window argument.
   * Otherwise a colormap must be set on them with gdk_drawable_set_colormap.
   * 
   * On older X servers, rendering pixbufs with an alpha channel involves round trips
   * to the X server, and may be somewhat slow.
   * 
   * Deprecated: This function is obsolete. Use gdk_draw_pixbuf() instead.
   * @param drawable Destination drawable.
   * @param src_x Source X coordinate within pixbuf.
   * @param src_y Source Y coordinates within pixbuf.
   * @param dest_x Destination X coordinate within drawable.
   * @param dest_y Destination Y coordinate within drawable.
   * @param width Width of region to render, in pixels, or -1 to use pixbuf width.
   * @param height Height of region to render, in pixels, or -1 to use pixbuf height.
   * @param alpha_mode Ignored. Present for backwards compatibility.
   * @param alpha_threshold Ignored. Present for backwards compatibility.
   * @param dither Dithering mode for GdkRGB.
   * @param x_dither X offset for dither.
   * @param y_dither Y offset for dither.
   */
  void render_to_drawable_alpha(const Glib::RefPtr<Drawable>& drawable,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height,
                                          PixbufAlphaMode alpha_mode,
                                          int alpha_threshold,
                                          RgbDither dither,
                                          int x_dither, int y_dither);

  void render_pixmap_and_mask_for_colormap(const Glib::RefPtr<Colormap>& colormap,
                                           Glib::RefPtr<Pixmap>& pixmap_return,
                                           Glib::RefPtr<Bitmap>& mask_return,
                                           int alpha_threshold);

  void render_pixmap_and_mask(Glib::RefPtr<Pixmap>& pixmap_return,
                              Glib::RefPtr<Bitmap>& mask_return, int alpha_threshold);

  
  Glib::ustring get_option(const Glib::ustring& key) const;


  typedef Glib::SListHandle< Glib::RefPtr<PixbufFormat>, PixbufFormatTraits > SListHandle_PixbufFormat;
  static SListHandle_PixbufFormat get_formats();
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::Pixbuf
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gdk::Pixbuf> wrap(GdkPixbuf* object, bool take_copy = false);
}


#endif /* _GDKMM_PIXBUF_H */

