// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DISPLAY_H
#define _GDKMM_DISPLAY_H

#include <glibmm.h>

/* $Id: display.hg,v 1.20 2005/04/07 08:46:44 murrayc Exp $ */

/* display.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/screen.h>
#include <gdkmm/device.h>
#include <gdkmm/types.h> //For ModifierType


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDisplay GdkDisplay;
typedef struct _GdkDisplayClass GdkDisplayClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Display_Class; } // namespace Gdk
namespace Gdk
{


class Drawable;

 /** Gdk::Display object's purpose is two fold:
 *   To grab/ungrab keyboard focus and mouse pointer
 *   To manage and provide information about the Gdk::Screen(s) available for this Gdk::Display
 *
 * Gdk::Display objects are the GDK representation of the X Display which can be described as a workstation consisting
 * of a keyboard a pointing device (such as a mouse) and one or more screens. It is used to open and keep track of
 * various Gdk::Screen objects currently instantiated by the application. It is also used to grab and release the keyboard
 * and the mouse pointer.
 */

class Display : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Display CppObjectType;
  typedef Display_Class CppClassType;
  typedef GdkDisplay BaseObjectType;
  typedef GdkDisplayClass BaseClassType;

private:  friend class Display_Class;
  static CppClassType display_class_;

private:
  // noncopyable
  Display(const Display&);
  Display& operator=(const Display&);

protected:
  explicit Display(const Glib::ConstructParams& construct_params);
  explicit Display(GdkDisplay* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Display();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDisplay*       gobj()       { return reinterpret_cast<GdkDisplay*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDisplay* gobj() const { return reinterpret_cast<GdkDisplay*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDisplay* gobj_copy();

private:

protected:
  Display();

public:
  
  /** Opens a display.
   * 
   * Since: 2.2
   * @param display_name The name of the display to open.
   * @return A Gdk::Display, or <tt>0</tt> if the display
   * could not be opened.
   */
  static Glib::RefPtr<Display> open(const Glib::ustring& display_name);

  
  /** Gets the name of the display.
   * @return A string representing the display name. This string is owned
   * by GDK and should not be modified or freed.
   * 
   * Since: 2.2.
   */
  Glib::ustring get_name() const;

  
  /** Gets the number of screen managed by the @a display .
   * @return Number of screens.
   * 
   * Since: 2.2.
   */
  int get_n_screens() const;
  
  /** Returns a screen object for one of the screens of the display.
   * @param screen_num The screen number.
   * @return The Gdk::Screen object
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Screen> get_screen(int screen_num);
  
  /** Returns a screen object for one of the screens of the display.
   * @param screen_num The screen number.
   * @return The Gdk::Screen object
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Screen> get_screen(int screen_num) const;
  
  
  /** Get the default Gdk::Screen for @a display .
   * @return The default Gdk::Screen object for @a display 
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Screen> get_default_screen();
  
  /** Get the default Gdk::Screen for @a display .
   * @return The default Gdk::Screen object for @a display 
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Screen> get_default_screen() const;
  
  
  /** Release any pointer grab.
   * 
   * Since: 2.2
   * @param timestamp A timestap (e.g. GDK_CURRENT_TIME).
   */
  void pointer_ungrab(guint32 timestamp);
  
  /** Release any keyboard grab
   * 
   * Since: 2.2
   * @param timestamp A timestap (e.g Gdk::CURRENT_TIME).
   */
  void keyboard_ungrab(guint32 timestamp);
  
  /** Test if the pointer is grabbed.
   * @return <tt>true</tt> if an active X pointer grab is in effect
   * 
   * Since: 2.2.
   */
  bool pointer_is_grabbed() const;
  
  /** Emits a short beep on @a display 
   * 
   * Since: 2.2
   */
  void beep();
  
  /** Flushes any requests queued for the windowing system and waits until all
   * requests have been handled. This is often used for making sure that the
   * display is synchronized with the current state of the program. Calling
   * sync() before gdk_error_trap_pop() makes sure that any errors
   * generated from earlier requests are handled before the error trap is 
   * removed.
   * 
   * This is most useful for X11. On windowing systems where requests are
   * handled synchronously, this function will do nothing.
   * 
   * Since: 2.2
   */
  void sync();
  
  /** Closes the connection to the windowing system for the given display,
   * and cleans up associated resources.
   * 
   * Since: 2.2
   */
  void	close();

  
  /** Returns the list of available input devices attached to @a display .
   * The list is statically allocated and should not be freed.
   * @return A list of Gdk::Device
   * 
   * Since: 2.2.
   */
  Glib::ListHandle< Glib::RefPtr<Device> > list_devices();
  
  /** Returns the list of available input devices attached to @a display .
   * The list is statically allocated and should not be freed.
   * @return A list of Gdk::Device
   * 
   * Since: 2.2.
   */
  Glib::ListHandle< Glib::RefPtr<const Device> > list_devices() const;
  
  //TODO: Use C++ Gdk::Event:
  //TODO: get_event() might remove the event - if so, then there should not be a const version:
  
  /** Gets the next Gdk::Event to be processed for @a display , fetching events from the
   * windowing system if necessary.
   * @return The next Gdk::Event to be processed, or <tt>0</tt> if no events
   * are pending. The returned Gdk::Event should be freed with gdk_event_free().
   * 
   * Since: 2.2.
   */
  GdkEvent* get_event();
  
  /** Gets the next Gdk::Event to be processed for @a display , fetching events from the
   * windowing system if necessary.
   * @return The next Gdk::Event to be processed, or <tt>0</tt> if no events
   * are pending. The returned Gdk::Event should be freed with gdk_event_free().
   * 
   * Since: 2.2.
   */
  const GdkEvent* get_event() const;
  
  
  /** Gets a copy of the first Gdk::Event in the @a display 's event queue, without
   * removing the event from the queue.  (Note that this function will
   * not get more events from the windowing system.  It only checks the events
   * that have already been moved to the GDK event queue.)
   * @return A copy of the first Gdk::Event on the event queue, or <tt>0</tt> 
   * if no events are in the queue. The returned Gdk::Event should be freed with
   * gdk_event_free().
   * 
   * Since: 2.2.
   */
  GdkEvent* peek_event();
  
  /** Gets a copy of the first Gdk::Event in the @a display 's event queue, without
   * removing the event from the queue.  (Note that this function will
   * not get more events from the windowing system.  It only checks the events
   * that have already been moved to the GDK event queue.)
   * @return A copy of the first Gdk::Event on the event queue, or <tt>0</tt> 
   * if no events are in the queue. The returned Gdk::Event should be freed with
   * gdk_event_free().
   * 
   * Since: 2.2.
   */
  GdkEvent* peek_event() const;
  
  /** Appends a copy of the given event onto the front of the event
   * queue for @a display .
   * 
   * Since: 2.2
   * @param event A Gdk::Event.
   */
  void put_event(GdkEvent* event);

  //TODO: Use a slot here, though this is probably never used anyway:
  //Find out whether we can use a string representation for the atom - look for examples of this function's use.
  
  /** Adds a filter to be called when X ClientMessage events are received.
   * 
   * Since: 2.2
   * @param message_type The type of ClientMessage events to receive.
   * This will be checked against the @a message_type  field 
   * of the XClientMessage event struct.
   * @param func The function to call to process the event.
   * @param data User data to pass to @a func .
   */
  void add_client_message_filter(Glib::ustring& message_type, GdkFilterFunc func, gpointer data);

  
  /** Sets the double click time (two clicks within this time interval
   * count as a double click and result in a Gdk::2BUTTON_PRESS event).
   * Applications should <em>not</em> set this, it is a global 
   * user-configured setting.
   * 
   * Since: 2.2
   * @param msec Double click time in milliseconds (thousandths of a second).
   */
  void set_double_click_time(guint msec);
  
  /** Sets the double click distance (two clicks within this distance
   * count as a double click and result in a Gdk::2BUTTON_PRESS event).
   * See also set_double_click_time().
   * Applications should <em>not</em> set this, it is a global 
   * user-configured setting.
   * 
   * Since: 2.4
   * @param distance Distance in pixels.
   */
  void set_double_click_distance(guint distance);


  /** Gets the default Gdk::Display. This is a convenience
   * function for:
   * 
   * gdk_display_manager_get_default_display (manager_get())
   * 
   * @return A Gdk::Display, or <tt>0</tt> if there is no default
   * display.
   * 
   * Since: 2.2.
   */
  static Glib::RefPtr<Display> get_default();

  
  /** Returns the core pointer device for the given display
   * @return The core pointer device; this is owned by the
   * display and should not be freed.
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Device> get_core_pointer();
  
  /** Returns the core pointer device for the given display
   * @return The core pointer device; this is owned by the
   * display and should not be freed.
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Device> get_core_pointer() const;

  /** Gets the current location of the pointer and the current modifier
   * mask for a given display.
   *
   * @param screen location to store the screen that the cursor is on.
   * @param x location to store root window X coordinate of pointer.
   * @param y location to store root window Y coordinate of pointer.
   * @param mask location to store current modifier mask.
   *
   **/
  void get_pointer(Glib::RefPtr<Screen>& screen, int& x, int& y, ModifierType& mask);

  // In fact, any one of these gdk_display_get_pointer() args can be NULL, but we don't need so many overloads.
  /**
   * Gets the current location of the pointer and the current modifier
   * mask for a given display.
   *
   * @param x location to store root window X coordinate of pointer.
   * @param y location to store root window Y coordinate of pointer.
   * @param mask location to store current modifier mask.
   *
   **/
  void get_pointer(int& x, int& y, ModifierType& mask); 
  
  
  /** Obtains the window underneath the mouse pointer, returning the location
   * of that window in @a win_x , @a win_y  for @a screen . Returns <tt>0</tt> if the window 
   * under the mouse pointer is not known to GDK (for example, belongs to
   * another application).
   * @param win_x Return location for origin of the window under the pointer.
   * @param win_y Return location for origin of the window under the pointer.
   * @return The window under the mouse pointer, or <tt>0</tt>
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Window> get_window_at_pointer(int& win_x, int& win_y);
  
  /** Obtains the window underneath the mouse pointer, returning the location
   * of that window in @a win_x , @a win_y  for @a screen . Returns <tt>0</tt> if the window 
   * under the mouse pointer is not known to GDK (for example, belongs to
   * another application).
   * @param win_x Return location for origin of the window under the pointer.
   * @param win_y Return location for origin of the window under the pointer.
   * @return The window under the mouse pointer, or <tt>0</tt>
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Window> get_window_at_pointer(int& win_x, int& win_y) const;

  /** Obtains the window underneath the mouse pointer. Returns a null RefPtr if the window
   * under the mouse pointer is not known to GDK (for example, belongs to
   * another application).
   * @result The window underneath the mouse pointer.
   */
  Glib::RefPtr<Window> get_window_at_pointer();

  /** Obtains the window underneath the mouse pointer. Returns a null RefPtr if the window
   * under the mouse pointer is not known to GDK (for example, belongs to
   * another application).
   * @result The window underneath the mouse pointer.
   */
  Glib::RefPtr<const Window> get_window_at_pointer() const;

  
  /** This function allows for hooking into the operation
   * of getting the current location of the pointer on a particular
   * display. This is only useful for such low-level tools as an
   * event recorder. Applications should never have any
   * reason to use this facility.
   * @param new_hooks A table of pointers to functions for getting
   * quantities related to the current pointer position.
   * @return The previous pointer hook table
   * 
   * Since: 2.2.
   */
  GdkDisplayPointerHooks* set_pointer_hooks(const GdkDisplayPointerHooks* new_hooks);
  GdkDisplayPointerHooks* unset_pointer_hooks();
  
  
  /** Opens the default display specified by command line arguments or
   * environment variables, sets it as the default display, and returns
   * it.  gdk_parse_args must have been called first. If the default
   * display has previously been set, simply returns that. An internal
   * function that should not be used by applications.
   * @return The default display, if it could be opened,
   * otherwise <tt>0</tt>.
   */
  static Glib::RefPtr<Display> open_default_libgtk_only();

  
  /** Finds out the DND protocol supported by a window.
   * 
   * Since: 2.2
   * @param xid The X id of the destination window.
   * @param protocol Location where the supported DND protocol is returned.
   * @return The X id of the window where the drop should happen. This 
   * may be @a xid  or the X id of a proxy window, or None if @a xid  doesn't
   * support Drag and Drop.
   */
  guint32 get_drag_protocol(guint32 xid, GdkDragProtocol& protocol);

  
  /** 
   * @return The Gdk::Keymap attached to @a display .
   * the Gdk::Keymap attached to @a display .
   * 
   * Since: 2.2.
   */
  GdkKeymap* get_keymap();
  
  /** 
   * @return The Gdk::Keymap attached to @a display .
   * the Gdk::Keymap attached to @a display .
   * 
   * Since: 2.2.
   */
  const GdkKeymap* get_keymap() const;

  bool set_selection_owner(const Glib::RefPtr<Window>& owner, Glib::ustring& selection, guint32 time_, bool send_event);
  Glib::RefPtr<Window> get_selection_owner(const Glib::ustring& selection);
  void selection_send_notify(guint32 requestor, Glib::ustring& selection, Glib::ustring& target, Glib::ustring& property, guint32 time_);

  
  /** Looks up the Gdk::Pixmap that wraps the given native pixmap handle.
   * 
   * For example in the X backend, a native pixmap handle is an Xlib
   * &lt;type&gt;XID&lt;/type&gt;.
   * @param anid A native pixmap handle.
   * @return The Gdk::Pixmap wrapper for the native pixmap,
   * or <tt>0</tt> if there is none.
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Pixmap> lookup_pixmap(NativeWindow anid);
  
  /** Looks up the Gdk::Pixmap that wraps the given native pixmap handle.
   * 
   * For example in the X backend, a native pixmap handle is an Xlib
   * &lt;type&gt;XID&lt;/type&gt;.
   * @param anid A native pixmap handle.
   * @return The Gdk::Pixmap wrapper for the native pixmap,
   * or <tt>0</tt> if there is none.
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Pixmap> lookup_pixmap(NativeWindow anid) const;

  
  /** Flushes any requests queued for the windowing system; this happens automatically
   * when the main loop blocks waiting for new events, but if your application
   * is drawing without returning control to the main loop, you may need
   * to call this function explicitely. A common case where this function
   * needs to be called is when an application is executing drawing commands
   * from a thread other than the thread where the main loop is running.
   * 
   * This is most useful for X11. On windowing systems where requests are
   * handled synchronously, this function will do nothing.
   * 
   * Since: 2.4
   */
  void flush();
  
  /** Returns <tt>true</tt> if cursors can use an 8bit alpha channel 
   * on @a display . Otherwise, cursors are restricted to bilevel 
   * alpha (i.e. a mask).
   * @return Whether cursors can have alpha channels.
   * 
   * Since: 2.4.
   */
  bool supports_cursor_alpha() const;
  
  /** Returns <tt>true</tt> if multicolored cursors are supported
   * on @a display . Otherwise, cursors have only a forground
   * and a background color.
   * @return Whether cursors can have multiple colors.
   * 
   * Since: 2.4.
   */
  bool supports_cursor_color() const;
  
  /** Returns the default size to use for cursors on @a display .
   * @return The default cursor size.
   * 
   * Since: 2.4.
   */
  guint get_default_cursor_size() const;
  
  /** Gets the maximal size to use for cursors on @a display .
   * 
   * Since: 2.4
   * @param width The return location for the maximal cursor width.
   * @param height The return location for the maximal cursor height.
   */
  void get_maximal_cursor_size(guint& width, guint& height);

  
  /** Returns the default group leader window for all toplevel windows
   * on @a display . This window is implicitly created by GDK. 
   * See gdk_window_set_group().
   * @return The default group leader window for @a display 
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<Window> get_default_group(); 
  
  /** Returns the default group leader window for all toplevel windows
   * on @a display . This window is implicitly created by GDK. 
   * See gdk_window_set_group().
   * @return The default group leader window for @a display 
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<const Window> get_default_group() const;              
      
  //TODO: wrap the vfuncs, though they are not very useful because people will not derive from this class? murrayc.
  

  /** Returns whether Gdk::EventOwnerChange events will be 
   * sent when the owner of a selection changes.
   * @return Whether Gdk::EventOwnerChange events will 
   * be sent.
   * 
   * Since: 2.6.
   */
  bool supports_selection_notification() const;
  
  /** Request Gdk::EventOwnerChange events for ownership changes
   * of the selection named by the given atom.
   * @param selection The Gdk::Atom naming the selection for which
   * ownership change notification is requested.
   * @return Whether Gdk::EventOwnerChange events will 
   * be sent.
   * 
   * Since: 2.6.
   */
  bool request_selection_notification(const Glib::ustring& selection);

  
  /** Returns whether the speicifed display supports clipboard
   * persistance; i.e.\ if it's possible to store the clipboard data after an
   * application has quit. On X11 this checks if a clipboard daemon is
   * running.
   * @return <tt>true</tt> if the display supports clipboard persistance.
   * 
   * Since: 2.6.
   */
  bool supports_clipboard_persistence() const;

  //TODO: Documentation, based on C docs:
  void store_clipboard(const Glib::RefPtr<Gdk::Window>& clipboard_window, guint32 time_);
  
  void store_clipboard(const Glib::RefPtr<Gdk::Window>& clipboard_window, guint32 time_, const Glib::StringArrayHandle& targets);
                                                     
  
  /** The closed signal is emitted when the connection to the windowing
   * system for this display is closed.
   *
   * @param is_error true if the display was closed due to an error
   */  
  

  Glib::SignalProxy1< void,bool > signal_closed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_closed(bool is_error);


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Display
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gdk::Display> wrap(GdkDisplay* object, bool take_copy = false);
}


#endif /* _GDKMM_DISPLAY_H */

