// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/treeview.h>
#include <gtkmm/private/treeview_p.h>

#include <gtk/gtk.h>
// -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* $Id: treeview.ccg,v 1.24 2006/06/19 17:28:12 murrayc Exp $ */

/* Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeview_private.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/entry.h>
#include <gtk/gtk.h>

namespace
{

//This target name is used in the GTK+ implementation:
static const char treeview_target_row[]   = "GTK_TREE_MODEL_ROW";

} // anonymous namespace


static void SignalProxy_Mapping_gtk_callback(GtkTreeView* tree_view, GtkTreePath* path, void* data)
{
  Gtk::TreeView::SlotMapping* the_slot = static_cast<Gtk::TreeView::SlotMapping*>(data);

  try
  {
    (*the_slot)(Glib::wrap(tree_view), Gtk::TreePath(path, true));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

static gboolean SignalProxy_SearchEqual_gtk_callback(GtkTreeModel* model, int column, const char* key,
                                               GtkTreeIter* iter, void* data)
{
  Gtk::TreeView::SlotSearchEqual* the_slot = static_cast<Gtk::TreeView::SlotSearchEqual*>(data);

  try
  {
    return (*the_slot)(Glib::wrap(model, true), column, key, Gtk::TreeIter(model, iter));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0; // arbitrary value
}

static void SignalProxy_SearchEqual_gtk_callback_destroy(void* data)
{
  delete static_cast<Gtk::TreeView::SlotSearchEqual*>(data);
}

static gboolean SignalProxy_ColumnDrop_gtk_callback(GtkTreeView* tree_view, GtkTreeViewColumn* column,
                                              GtkTreeViewColumn* prev_column,
                                              GtkTreeViewColumn* next_column, void* data)
{
  Gtk::TreeView::SlotColumnDrop* the_slot = static_cast<Gtk::TreeView::SlotColumnDrop*>(data);

  try
  {
    return (*the_slot)(Glib::wrap(tree_view), Glib::wrap(column),
                         Glib::wrap(prev_column), Glib::wrap(next_column));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0; // arbitrary value
}

static void SignalProxy_ColumnDrop_gtk_callback_destroy(void* data)
{
  delete static_cast<Gtk::TreeView::SlotColumnDrop*>(data);
}


static void SignalProxy_SearchPosition_gtk_callback(GtkTreeView* /* tree_view */, GtkWidget* search_dialog, gpointer user_data)
{
  Gtk::TreeView::SlotSearchPosition* the_slot = static_cast<Gtk::TreeView::SlotSearchPosition*>(user_data);

  try
  {
    (*the_slot)(Glib::wrap(search_dialog));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

static void SignalProxy_SearchPosition_gtk_callback_destroy(void* data)
{
  delete static_cast<Gtk::TreeView::SlotSearchPosition*>(data);
}

namespace Gtk
{

void TreeView::unset_hadjustment()
{
  gtk_tree_view_set_hadjustment(gobj(), 0);
}

void TreeView::unset_vadjustment()
{
  gtk_tree_view_set_vadjustment(gobj(), 0);
}

int TreeView::insert_column_with_data_func(int position, const Glib::ustring& title, CellRenderer& cell, const SlotCellData& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when TreeView_Private::SignalProxy_CellData_gtk_callback_destroy() is called.
  SlotCellData* slot_copy = new SlotCellData(slot);

  return gtk_tree_view_insert_column_with_data_func(
      gobj(), position, title.c_str(), cell.gobj(),
      &TreeView_Private::SignalProxy_CellData_gtk_callback, slot_copy,
      &TreeView_Private::SignalProxy_CellData_gtk_callback_destroy);
}

void TreeView::set_cursor(const TreeModel::Path& path)
{
  gtk_tree_view_set_cursor(gobj(), const_cast<GtkTreePath*>(path.gobj()), 0, false);
}

void TreeView::get_cursor(TreeModel::Path& path, TreeViewColumn*& focus_column)
{
  GtkTreePath* pTreePath = 0;
  GtkTreeViewColumn* pTreeViewColumn = 0;
  gtk_tree_view_get_cursor(gobj(), &pTreePath, &pTreeViewColumn);

  path = TreeModel::Path(pTreePath, false); /* Use the existing underlying GtkTreePath instance without copying and freeing, because gtk_tree_view_get_cursor() gives us ownernship. */
  focus_column = Glib::wrap(pTreeViewColumn);
}


void TreeView::enable_model_drag_source(const ArrayHandle_TargetEntry& targets,
                              Gdk::ModifierType start_button_mask,
                              Gdk::DragAction actions)
{
  gtk_tree_view_enable_model_drag_source(
      gobj(), (GdkModifierType) start_button_mask,
      targets.data(), targets.size(), (GdkDragAction) actions);
}

void TreeView::enable_model_drag_source(Gdk::ModifierType start_button_mask, Gdk::DragAction actions)
{
  std::list<TargetEntry> listTargets;
  listTargets.push_back(TargetEntry(treeview_target_row));
  enable_model_drag_source(listTargets, start_button_mask, actions);
}    

void TreeView::enable_model_drag_dest(const ArrayHandle_TargetEntry& targets, Gdk::DragAction actions)
{
  gtk_tree_view_enable_model_drag_dest(
      gobj(), targets.data(), targets.size(), (GdkDragAction) actions);
}

void TreeView::enable_model_drag_dest(Gdk::DragAction actions)
{
  std::list<TargetEntry> listTargets;
  listTargets.push_back(TargetEntry(treeview_target_row));
  enable_model_drag_dest(listTargets, actions);
}

bool TreeView::get_path_at_pos(int x, int y, TreeModel::Path& path, TreeViewColumn*& column, int& cell_x, int& cell_y) const
{
  GtkTreePath* pTreePath = 0;
  GtkTreeViewColumn* pTreeViewColumn = 0;
  const bool result = gtk_tree_view_get_path_at_pos(const_cast<GtkTreeView*>(gobj()), x, y, &pTreePath, &pTreeViewColumn, &cell_x, &cell_y);

  path = TreeModel::Path(pTreePath, false /* don't take a copy, because the gtk_tree_view_get_path_at_pos() docs say that we must free the path */ );
  column = Glib::wrap(pTreeViewColumn);
  return result;
}

bool TreeView::get_path_at_pos(int x, int y, TreeModel::Path& path) const
{
  GtkTreePath* pTreePath = 0;
  const bool result = gtk_tree_view_get_path_at_pos(const_cast<GtkTreeView*>(gobj()), x, y, &pTreePath, 0, 0, 0);

  path = TreeModel::Path(pTreePath, false /* don't take a copy, because the gtk_tree_view_get_path_at_pos() docs say that we must free the path */ );
  return result;
}

int TreeView::insert_column(const Glib::ustring& title, CellRenderer& cell, int position)
{
  return gtk_tree_view_insert_column_with_attributes(
      gobj(), position, const_cast<char*>(title.c_str()), cell.gobj(), (void*)0); //Note that some compilers need the extra (void*) clue.
}

int TreeView::append_column(const Glib::ustring& title, CellRenderer& cell)
{
  return insert_column(title, cell, -1 /* at the end */);
}

void TreeView::get_drag_dest_row(TreeModel::Path& path, TreeViewDropPosition& pos) const
{
  GtkTreePath* pTreePath = 0;
  gtk_tree_view_get_drag_dest_row(const_cast<GtkTreeView*>(gobj()), &pTreePath, (GtkTreeViewDropPosition*) &pos);
  path = TreeModel::Path(pTreePath, true); //true = take_copy.
}

bool TreeView::get_dest_row_at_pos(int drag_x, int drag_y, TreeModel::Path& path, TreeViewDropPosition& pos) const
{
  GtkTreePath* pTreePath = 0;
  const bool bResult = gtk_tree_view_get_dest_row_at_pos(
      const_cast<GtkTreeView*>(gobj()), drag_x, drag_y, &pTreePath, (GtkTreeViewDropPosition*) &pos);

  path = TreeModel::Path(pTreePath, true); //true = take_copy.
  return bResult;
}

void TreeView::map_expanded_rows(const SlotMapping& slot)
{
  gtk_tree_view_map_expanded_rows(gobj(), &SignalProxy_Mapping_gtk_callback, const_cast<SlotMapping*>(&slot));
}

void TreeView::set_search_equal_func(const SlotSearchEqual& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_SearchEqual_gtk_callback_destroy() is called.
  SlotSearchEqual* slot_copy = new SlotSearchEqual(slot);

  gtk_tree_view_set_search_equal_func(gobj(),
      &SignalProxy_SearchEqual_gtk_callback, slot_copy,
      &SignalProxy_SearchEqual_gtk_callback_destroy);
}

void TreeView::set_column_drag_function(const SlotColumnDrop& slot)
{
  //Create a copt of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_ColumnDrop_gtk_callback_destroy() is called.
   SlotColumnDrop* slot_copy = new SlotColumnDrop(slot);

  gtk_tree_view_set_column_drag_function(gobj(),
      &SignalProxy_ColumnDrop_gtk_callback, slot_copy,
      &SignalProxy_ColumnDrop_gtk_callback_destroy);

}

void TreeView::unset_column_drag_function()
{
  gtk_tree_view_set_column_drag_function(gobj(),
      0, 0, 0); /* See GTK+ docs about the 0s. */
}

void TreeView::scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column, float row_align, float col_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), column.gobj(), TRUE, row_align, col_align);
}

void TreeView::scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), column.gobj(), FALSE, 0.0, 0.0);
}

void TreeView::scroll_to_row(const TreeModel::Path& path, float row_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), 0, TRUE, row_align, 0.0);
}

void TreeView::scroll_to_row(const TreeModel::Path& path)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), 0, FALSE, 0.0, 0.0);
}

void TreeView::scroll_to_column(TreeViewColumn& column, float col_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), 0, column.gobj(), TRUE, 0.0, col_align);
}

void TreeView::scroll_to_column(TreeViewColumn& column)
{
  gtk_tree_view_scroll_to_cell(gobj(), 0, column.gobj(), FALSE, 0.0, 0.0);
}

void TreeView::remove_all_columns()
{
  //This method is not in GTK+, but it seems useful.

  //Remove all View columns:
  typedef std::list< Gtk::TreeView::Column* > type_vecViewColumns;
  type_vecViewColumns vecViewColumns = get_columns();
  for(type_vecViewColumns::iterator iter = vecViewColumns.begin(); iter != vecViewColumns.end(); ++iter)
  {
    Gtk::TreeView::Column* pViewColumn = *iter;
    if(pViewColumn)
      remove_column(*pViewColumn);
  }
}


CellRenderer* TreeView::get_column_cell_renderer(int n)
{
  TreeViewColumn* pColumn = get_column(n);
  if(pColumn)
    return pColumn->get_first_cell();
  else
    return 0;
}


const CellRenderer* TreeView::get_column_cell_renderer(int n) const
{
   //Do some const_cast-ing to avoid repetition of code:
  CellRenderer* pRenderer = const_cast<TreeView*>(this)->get_column_cell_renderer(n);
  return pRenderer;
}

void TreeView::reset_expander_column()
{
  gtk_tree_view_set_expander_column(gobj(), 0 /* see C docs */);
}

Glib::RefPtr<Gtk::TreeModel> TreeView::_get_base_model()
{
  Glib::RefPtr<TreeModel> refModel = get_model();

  bool get_child = true;
  while(get_child && refModel)
  {
    Glib::RefPtr<Gtk::TreeModelFilter> refModelFilter = Glib::RefPtr<Gtk::TreeModelFilter>::cast_dynamic(refModel);
    if(refModelFilter)
      refModel = refModelFilter->get_model();
    else
      get_child = false;
  }

  return refModel;
}

void TreeView::_auto_store_on_cellrenderer_toggle_edited(const Glib::ustring& path_string,
                                                         int model_column)
{
  _auto_store_on_cellrenderer_toggle_edited_with_model(path_string, model_column, _get_base_model());
}

void TreeView::_auto_store_on_cellrenderer_toggle_edited_with_model(const Glib::ustring& path_string,
                                                         int model_column, const Glib::RefPtr<Gtk::TreeModel>& model)
{
  Gtk::TreePath path (path_string);

  //Get the row from the path:
  if(model)
  {
    Gtk::TreeModel::iterator iter = model->get_iter(path);
    if(iter)
    {
      Gtk::TreeRow row = *iter;

      //Get the new value:
      //This seems to get the old value, not the new one,
      //so we will just NOT the model value ourselves.
      //bool bActive = cell_renderer->get_active();
      bool bActive = false;
      row.get_value(model_column, bActive);
      bActive = !bActive;

      //Store the user's new text in the model:
      row.set_value(model_column, bActive);
    }
  }
}

void TreeView::move_column_to_start(TreeViewColumn& column)
{
  gtk_tree_view_move_column_after(gobj(), (column).gobj(), 0 /* See C docs */);
}

void TreeView::set_row_separator_func(const SlotRowSeparator& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_RowSeparator_gtk_callback_destroy() is called.
  SlotRowSeparator* slot_copy = new SlotRowSeparator(slot);

  gtk_tree_view_set_row_separator_func(gobj(),
      &TreeView_Private::SignalProxy_RowSeparator_gtk_callback, slot_copy,
      &TreeView_Private::SignalProxy_RowSeparator_gtk_callback_destroy);
}

void TreeView::set_search_position_func(const SlotSearchPosition& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_SearchPosition_gtk_callback_destroy() is called.
  SlotSearchPosition* slot_copy = new SlotSearchPosition(slot);

  gtk_tree_view_set_search_position_func(gobj(),
      &SignalProxy_SearchPosition_gtk_callback, slot_copy,
      &SignalProxy_SearchPosition_gtk_callback_destroy);
}

bool TreeView::get_visible_range(TreeModel::Path& start_path, TreeModel::Path& end_path) const
{
  GtkTreePath* pTreePathStart = 0;
  GtkTreePath* pTreePathEnd = 0;
  bool result = gtk_tree_view_get_visible_range(const_cast<GtkTreeView*>(gobj()), &pTreePathStart, &pTreePathEnd);

  start_path = TreeModel::Path(pTreePathStart, false /* don't take a copy, because the gtk_tree_view_get_visible_range() docs say that we must free the path */ );
  end_path = TreeModel::Path(pTreePathEnd, false /* don't take a copy, because the gtk_tree_view_get_visible_range() docs say that we must free the path */ );
  return result;
}

void TreeView::unset_model()
{
  gtk_tree_view_set_model(gobj(), 0);
}

bool
TreeView::get_tooltip_context_path(int& x, int& y,
                                   bool keyboard_tip,
                                   TreeModel::Path& path)
{
  //It's cleaner to use a temporary C++ object and get a C pointer to it,
  //because GtkTreePath is a simple struct, not a GtkObject, so
  //gtk_tree_path_new() would be necessary. markoa.
  TreeModel::Path tmp_path;
  GtkTreePath* cpath = tmp_path.gobj();

  gboolean result =
    gtk_tree_view_get_tooltip_context(gobj(),
                                      &x, &y,
                                      keyboard_tip,
                                      0,
                                      &cpath,
                                      0);

  path = Glib::wrap(cpath, false /* take_copy=false */);

  return result;
}

bool
TreeView::get_tooltip_context_iter(int& x, int& y,
                                   bool keyboard_tip,
                                   Gtk::TreeModel::iterator& iter)
{
  GtkTreeIter src_iter;

  gboolean result =
    gtk_tree_view_get_tooltip_context(gobj(),
                                      &x, &y,
                                      keyboard_tip,
                                      0,
                                      0,
                                      &src_iter);

  iter = TreeIter(gtk_tree_view_get_model(this->gobj()), &src_iter);

  return result;
}

} // namespace Gtk

namespace
{


static void TreeView_signal_set_scroll_adjustments_callback(GtkTreeView* self, GtkAdjustment* p0,GtkAdjustment* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,Adjustment*,Adjustment* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TreeView_signal_set_scroll_adjustments_info =
{
  "set-scroll-adjustments",
  (GCallback) &TreeView_signal_set_scroll_adjustments_callback,
  (GCallback) &TreeView_signal_set_scroll_adjustments_callback
};


static void TreeView_signal_row_activated_callback(GtkTreeView* self, GtkTreePath* p0,GtkTreeViewColumn* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::Path&,TreeViewColumn* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
, Glib::wrap(p1)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TreeView_signal_row_activated_info =
{
  "row-activated",
  (GCallback) &TreeView_signal_row_activated_callback,
  (GCallback) &TreeView_signal_row_activated_callback
};


static gboolean TreeView_signal_test_expand_row_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< bool,const TreeModel::iterator&,const TreeModel::Path& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean TreeView_signal_test_expand_row_notify_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::iterator&,const TreeModel::Path& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo TreeView_signal_test_expand_row_info =
{
  "test-expand-row",
  (GCallback) &TreeView_signal_test_expand_row_callback,
  (GCallback) &TreeView_signal_test_expand_row_notify_callback
};


static gboolean TreeView_signal_test_collapse_row_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< bool,const TreeModel::iterator&,const TreeModel::Path& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean TreeView_signal_test_collapse_row_notify_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::iterator&,const TreeModel::Path& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo TreeView_signal_test_collapse_row_info =
{
  "test-collapse-row",
  (GCallback) &TreeView_signal_test_collapse_row_callback,
  (GCallback) &TreeView_signal_test_collapse_row_notify_callback
};


static void TreeView_signal_row_expanded_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::iterator&,const TreeModel::Path& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TreeView_signal_row_expanded_info =
{
  "row-expanded",
  (GCallback) &TreeView_signal_row_expanded_callback,
  (GCallback) &TreeView_signal_row_expanded_callback
};


static void TreeView_signal_row_collapsed_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::iterator&,const TreeModel::Path& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TreeView_signal_row_collapsed_info =
{
  "row-collapsed",
  (GCallback) &TreeView_signal_row_collapsed_callback,
  (GCallback) &TreeView_signal_row_collapsed_callback
};


static const Glib::SignalProxyInfo TreeView_signal_cursor_changed_info =
{
  "cursor-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo TreeView_signal_columns_changed_info =
{
  "columns-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::TreeViewDropPosition>::value_type()
{
  return gtk_tree_view_drop_position_get_type();
}

// static
GType Glib::Value<Gtk::TreeViewGridLines>::value_type()
{
  return gtk_tree_view_grid_lines_get_type();
}


namespace Glib
{

Gtk::TreeView* wrap(GtkTreeView* object, bool take_copy)
{
  return dynamic_cast<Gtk::TreeView *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& TreeView_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &TreeView_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_tree_view_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void TreeView_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->set_scroll_adjustments = &set_scroll_adjustments_callback;
  klass->row_activated = &row_activated_callback;
  klass->test_expand_row = &test_expand_row_callback;
  klass->test_collapse_row = &test_collapse_row_callback;
  klass->row_expanded = &row_expanded_callback;
  klass->row_collapsed = &row_collapsed_callback;
  klass->cursor_changed = &cursor_changed_callback;
  klass->columns_changed = &columns_changed_callback;
}


void TreeView_Class::set_scroll_adjustments_callback(GtkTreeView* self, GtkAdjustment* p0, GtkAdjustment* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_set_scroll_adjustments(Glib::wrap(p0)
, Glib::wrap(p1)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->set_scroll_adjustments)
    (*base->set_scroll_adjustments)(self, p0, p1);
}
void TreeView_Class::row_activated_callback(GtkTreeView* self, GtkTreePath* p0, GtkTreeViewColumn* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_activated(Gtk::TreePath(p0, true)
, Glib::wrap(p1)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->row_activated)
    (*base->row_activated)(self, p0, p1);
}
gboolean TreeView_Class::test_expand_row_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_test_expand_row(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->test_expand_row)
    return (*base->test_expand_row)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
gboolean TreeView_Class::test_collapse_row_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_test_collapse_row(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->test_collapse_row)
    return (*base->test_collapse_row)(self, p0, p1);

  typedef gboolean RType;
  return RType();
}
void TreeView_Class::row_expanded_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_expanded(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->row_expanded)
    (*base->row_expanded)(self, p0, p1);
}
void TreeView_Class::row_collapsed_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_collapsed(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->row_collapsed)
    (*base->row_collapsed)(self, p0, p1);
}
void TreeView_Class::cursor_changed_callback(GtkTreeView* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_cursor_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->cursor_changed)
    (*base->cursor_changed)(self);
}
void TreeView_Class::columns_changed_callback(GtkTreeView* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_columns_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->columns_changed)
    (*base->columns_changed)(self);
}


Glib::ObjectBase* TreeView_Class::wrap_new(GObject* o)
{
  return manage(new TreeView((GtkTreeView*)(o)));

}


/* The implementation: */

TreeView::TreeView(const Glib::ConstructParams& construct_params)
:
  Gtk::Container(construct_params)
{
  }

TreeView::TreeView(GtkTreeView* castitem)
:
  Gtk::Container((GtkContainer*)(castitem))
{
  }

TreeView::~TreeView()
{
  destroy_();
}

TreeView::CppClassType TreeView::treeview_class_; // initialize static member

GType TreeView::get_type()
{
  return treeview_class_.init().get_type();
}


GType TreeView::get_base_type()
{
  return gtk_tree_view_get_type();
}


TreeView::TreeView()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::Container(Glib::ConstructParams(treeview_class_.init()))
{
  

}

TreeView::TreeView(const Glib::RefPtr<TreeModel>& model)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::Container(Glib::ConstructParams(treeview_class_.init(), "model", Glib::unwrap(model), static_cast<char*>(0)))
{
  

}

Glib::RefPtr<TreeModel> TreeView::get_model()
{

  Glib::RefPtr<TreeModel> retvalue = Glib::wrap(gtk_tree_view_get_model(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const TreeModel> TreeView::get_model() const
{

  Glib::RefPtr<const TreeModel> retvalue = Glib::wrap(gtk_tree_view_get_model(const_cast<GtkTreeView*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

void TreeView::set_model(const Glib::RefPtr<TreeModel>& model)
{
gtk_tree_view_set_model(gobj(), Glib::unwrap(model)); 
}

Glib::RefPtr<TreeSelection> TreeView::get_selection()
{

  Glib::RefPtr<TreeSelection> retvalue = Glib::wrap(gtk_tree_view_get_selection(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const TreeSelection> TreeView::get_selection() const
{
  return const_cast<TreeView*>(this)->get_selection();
}

Adjustment* TreeView::get_hadjustment()
{
  return Glib::wrap(gtk_tree_view_get_hadjustment(gobj()));
}

const Adjustment* TreeView::get_hadjustment() const
{
  return const_cast<TreeView*>(this)->get_hadjustment();
}

void TreeView::set_hadjustment(Adjustment& adjustment)
{
gtk_tree_view_set_hadjustment(gobj(), (adjustment).gobj()); 
}

Adjustment* TreeView::get_vadjustment()
{
  return Glib::wrap(gtk_tree_view_get_vadjustment(gobj()));
}

const Adjustment* TreeView::get_vadjustment() const
{
  return const_cast<TreeView*>(this)->get_vadjustment();
}

void TreeView::set_vadjustment(Adjustment& adjustment)
{
gtk_tree_view_set_vadjustment(gobj(), (adjustment).gobj()); 
}

bool TreeView::get_headers_visible() const
{
  return gtk_tree_view_get_headers_visible(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_headers_visible(bool headers_visible)
{
gtk_tree_view_set_headers_visible(gobj(), static_cast<int>(headers_visible)); 
}

void TreeView::columns_autosize()
{
gtk_tree_view_columns_autosize(gobj()); 
}

bool TreeView::get_headers_clickable() const
{
  return gtk_tree_view_get_headers_clickable(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_headers_clickable(bool setting)
{
gtk_tree_view_set_headers_clickable(gobj(), static_cast<int>(setting)); 
}

void TreeView::set_rules_hint(bool setting)
{
gtk_tree_view_set_rules_hint(gobj(), static_cast<int>(setting)); 
}

bool TreeView::get_rules_hint() const
{
  return gtk_tree_view_get_rules_hint(const_cast<GtkTreeView*>(gobj()));
}

int TreeView::append_column(TreeViewColumn& column)
{
  return gtk_tree_view_append_column(gobj(), (column).gobj());
}

int TreeView::remove_column(TreeViewColumn& column)
{
  return gtk_tree_view_remove_column(gobj(), (column).gobj());
}

int TreeView::insert_column(TreeViewColumn& column, int position)
{
  return gtk_tree_view_insert_column(gobj(), (column).gobj(), position);
}

TreeViewColumn* TreeView::get_column(int n)
{
  return Glib::wrap(gtk_tree_view_get_column(gobj(), n));
}

const TreeViewColumn* TreeView::get_column(int n) const
{
  return const_cast<TreeView*>(this)->get_column(n);
}

Glib::ListHandle<TreeViewColumn*> TreeView::get_columns()
{
  return Glib::ListHandle<TreeViewColumn*>(gtk_tree_view_get_columns(gobj()), Glib::OWNERSHIP_SHALLOW);
}

Glib::ListHandle<const TreeViewColumn*> TreeView::get_columns() const
{
  return Glib::ListHandle<const TreeViewColumn*>(gtk_tree_view_get_columns(const_cast<GtkTreeView*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void TreeView::move_column_after(TreeViewColumn& column, TreeViewColumn& base_column)
{
gtk_tree_view_move_column_after(gobj(), (column).gobj(), (base_column).gobj()); 
}

void TreeView::set_expander_column(TreeViewColumn& column)
{
gtk_tree_view_set_expander_column(gobj(), (column).gobj()); 
}

TreeViewColumn* TreeView::get_expander_column()
{
  return Glib::wrap(gtk_tree_view_get_expander_column(gobj()));
}

const TreeViewColumn* TreeView::get_expander_column() const
{
  return const_cast<TreeView*>(this)->get_expander_column();
}

void TreeView::scroll_to_point(int tree_x, int tree_y)
{
gtk_tree_view_scroll_to_point(gobj(), tree_x, tree_y); 
}

void TreeView::row_activated(const TreeModel::Path& path, TreeViewColumn& column)
{
gtk_tree_view_row_activated(gobj(), const_cast<GtkTreePath*>((path).gobj()), (column).gobj()); 
}

void TreeView::expand_all()
{
gtk_tree_view_expand_all(gobj()); 
}

void TreeView::collapse_all()
{
gtk_tree_view_collapse_all(gobj()); 
}

void TreeView::expand_to_path(const TreeModel::Path& path)
{
gtk_tree_view_expand_to_path(gobj(), const_cast<GtkTreePath*>((path).gobj())); 
}

bool TreeView::expand_row(const TreeModel::Path& path, bool open_all)
{
  return gtk_tree_view_expand_row(gobj(), const_cast<GtkTreePath*>((path).gobj()), static_cast<int>(open_all));
}

bool TreeView::collapse_row(const TreeModel::Path& path)
{
  return gtk_tree_view_collapse_row(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

bool TreeView::row_expanded(const TreeModel::Path& path)
{
  return gtk_tree_view_row_expanded(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeView::set_reorderable(bool reorderable)
{
gtk_tree_view_set_reorderable(gobj(), static_cast<int>(reorderable)); 
}

bool TreeView::get_reorderable() const
{
  return gtk_tree_view_get_reorderable(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, bool start_editing)
{
gtk_tree_view_set_cursor(gobj(), const_cast<GtkTreePath*>((path).gobj()), (focus_column).gobj(), static_cast<int>(start_editing)); 
}

void TreeView::set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, CellRenderer& focus_cell, bool start_editing)
{
gtk_tree_view_set_cursor_on_cell(gobj(), const_cast<GtkTreePath*>((path).gobj()), (focus_column).gobj(), (focus_cell).gobj(), static_cast<int>(start_editing)); 
}

Glib::RefPtr<Gdk::Window> TreeView::get_bin_window()
{

  Glib::RefPtr<Gdk::Window> retvalue = Glib::wrap((GdkWindowObject*)(gtk_tree_view_get_bin_window(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Gdk::Window> TreeView::get_bin_window() const
{
  return const_cast<TreeView*>(this)->get_bin_window();
}

void TreeView::get_cell_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect) const
{
gtk_tree_view_get_cell_area(const_cast<GtkTreeView*>(gobj()), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), (rect).gobj()); 
}

void TreeView::get_background_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect) const
{
gtk_tree_view_get_background_area(const_cast<GtkTreeView*>(gobj()), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), (rect).gobj()); 
}

void TreeView::get_visible_rect(Gdk::Rectangle& visible_rect) const
{
gtk_tree_view_get_visible_rect(const_cast<GtkTreeView*>(gobj()), (visible_rect).gobj()); 
}

void TreeView::unset_rows_drag_source()
{
gtk_tree_view_unset_rows_drag_source(gobj()); 
}

void TreeView::unset_rows_drag_dest()
{
gtk_tree_view_unset_rows_drag_dest(gobj()); 
}

void TreeView::set_drag_dest_row(const TreeModel::Path& path, TreeViewDropPosition pos)
{
gtk_tree_view_set_drag_dest_row(gobj(), const_cast<GtkTreePath*>((path).gobj()), ((GtkTreeViewDropPosition)(pos))); 
}

Glib::RefPtr<Gdk::Pixmap> TreeView::create_row_drag_icon(const TreeModel::Path& path)
{
  return Glib::wrap((GdkPixmapObject*)(gtk_tree_view_create_row_drag_icon(gobj(), const_cast<GtkTreePath*>((path).gobj()))));
}

void TreeView::set_enable_search(bool enable_search)
{
gtk_tree_view_set_enable_search(gobj(), static_cast<int>(enable_search)); 
}

bool TreeView::get_enable_search() const
{
  return gtk_tree_view_get_enable_search(const_cast<GtkTreeView*>(gobj()));
}

int TreeView::get_search_column() const
{
  return gtk_tree_view_get_search_column(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_search_column(const TreeModelColumnBase& column)
{
gtk_tree_view_set_search_column(gobj(), (column).index()); 
}

void TreeView::set_search_column(int column)
{
gtk_tree_view_set_search_column(gobj(), column); 
}

Entry* TreeView::get_search_entry()
{
  return Glib::wrap(gtk_tree_view_get_search_entry(gobj()));
}

const Entry* TreeView::get_search_entry() const
{
  return const_cast<TreeView*>(this)->get_search_entry();
}

void TreeView::set_search_entry(Entry& entry)
{
gtk_tree_view_set_search_entry(gobj(), (entry).gobj()); 
}

void TreeView::convert_widget_to_tree_coords(int wx, int wy, int& tx, int& ty) const
{
gtk_tree_view_convert_widget_to_tree_coords(const_cast<GtkTreeView*>(gobj()), wx, wy, &tx, &ty); 
}

void TreeView::convert_tree_to_widget_coords(int tx, int ty, int& wx, int& wy) const
{
gtk_tree_view_convert_tree_to_widget_coords(const_cast<GtkTreeView*>(gobj()), tx, ty, &wx, &wy); 
}

void TreeView::convert_widget_to_bin_window_coords(int wx, int wy, int& bx, int& by) const
{
gtk_tree_view_convert_widget_to_bin_window_coords(const_cast<GtkTreeView*>(gobj()), wx, wy, &bx, &by); 
}

void TreeView::convert_bin_window_to_widget_coords(int bx, int by, int& wx, int& wy) const
{
gtk_tree_view_convert_bin_window_to_widget_coords(const_cast<GtkTreeView*>(gobj()), bx, by, &wx, &wy); 
}

void TreeView::convert_tree_to_bin_window_coords(int tx, int ty, int& bx, int& by) const
{
gtk_tree_view_convert_tree_to_bin_window_coords(const_cast<GtkTreeView*>(gobj()), tx, ty, &bx, &by); 
}

void TreeView::convert_bin_window_to_tree_coords(int bx, int by, int& tx, int& ty) const
{
gtk_tree_view_convert_bin_window_to_tree_coords(const_cast<GtkTreeView*>(gobj()), bx, by, &tx, &ty); 
}

void TreeView::set_fixed_height_mode(bool enable)
{
gtk_tree_view_set_fixed_height_mode(gobj(), static_cast<int>(enable)); 
}

bool TreeView::get_fixed_height_mode() const
{
  return gtk_tree_view_get_fixed_height_mode(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_hover_selection(bool hover)
{
gtk_tree_view_set_hover_selection(gobj(), static_cast<int>(hover)); 
}

bool TreeView::get_hover_selection() const
{
  return gtk_tree_view_get_hover_selection(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_hover_expand(bool expand)
{
gtk_tree_view_set_hover_expand(gobj(), static_cast<int>(expand)); 
}

bool TreeView::get_hover_expand() const
{
  return gtk_tree_view_get_hover_expand(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_rubber_banding(bool enable)
{
gtk_tree_view_set_rubber_banding(gobj(), static_cast<int>(enable)); 
}

bool TreeView::get_rubber_banding() const
{
  return gtk_tree_view_get_rubber_banding(const_cast<GtkTreeView*>(gobj()));
}

bool TreeView::is_rubber_banding_active() const
{
  return gtk_tree_view_is_rubber_banding_active(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_grid_lines(TreeViewGridLines grid_lines)
{
gtk_tree_view_set_grid_lines(gobj(), ((GtkTreeViewGridLines)(grid_lines))); 
}

TreeViewGridLines TreeView::get_grid_lines() const
{
  return ((TreeViewGridLines)(gtk_tree_view_get_grid_lines(const_cast<GtkTreeView*>(gobj()))));
}

void TreeView::set_enable_tree_lines(bool enable)
{
gtk_tree_view_set_enable_tree_lines(gobj(), static_cast<int>(enable)); 
}

bool TreeView::get_enable_tree_lines() const
{
  return gtk_tree_view_get_enable_tree_lines(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_show_expanders(bool enabled)
{
gtk_tree_view_set_show_expanders(gobj(), static_cast<int>(enabled)); 
}

bool TreeView::get_show_expanders() const
{
  return gtk_tree_view_get_show_expanders(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_level_indentation(int indentation)
{
gtk_tree_view_set_level_indentation(gobj(), indentation); 
}

int TreeView::get_level_indentation() const
{
  return gtk_tree_view_get_level_indentation(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_tooltip_row(const Glib::RefPtr<Tooltip>& tooltip, const TreePath& path)
{
gtk_tree_view_set_tooltip_row(gobj(), Glib::unwrap(tooltip), const_cast<GtkTreePath*>((path).gobj())); 
}

void TreeView::set_tooltip_cell(const Glib::RefPtr<Tooltip>& tooltip, const TreeModel::Path* path, TreeViewColumn* column, CellRenderer* cell)
{
gtk_tree_view_set_tooltip_cell(gobj(), Glib::unwrap(tooltip), ((path) ? const_cast<GtkTreePath*>((path)->gobj()) : 0), (GtkTreeViewColumn*)Glib::unwrap(column), (GtkCellRenderer*)Glib::unwrap(cell)); 
}

void TreeView::set_tooltip_column(int column)
{
gtk_tree_view_set_tooltip_column(gobj(), column); 
}

int TreeView::get_tooltip_column() const
{
  return gtk_tree_view_get_tooltip_column(const_cast<GtkTreeView*>(gobj()));
}


Glib::SignalProxy2< void,Adjustment*,Adjustment* > TreeView::signal_set_scroll_adjustments()
{
  return Glib::SignalProxy2< void,Adjustment*,Adjustment* >(this, &TreeView_signal_set_scroll_adjustments_info);
}


Glib::SignalProxy2< void,const TreeModel::Path&,TreeViewColumn* > TreeView::signal_row_activated()
{
  return Glib::SignalProxy2< void,const TreeModel::Path&,TreeViewColumn* >(this, &TreeView_signal_row_activated_info);
}


Glib::SignalProxy2< bool,const TreeModel::iterator&,const TreeModel::Path& > TreeView::signal_test_expand_row()
{
  return Glib::SignalProxy2< bool,const TreeModel::iterator&,const TreeModel::Path& >(this, &TreeView_signal_test_expand_row_info);
}


Glib::SignalProxy2< bool,const TreeModel::iterator&,const TreeModel::Path& > TreeView::signal_test_collapse_row()
{
  return Glib::SignalProxy2< bool,const TreeModel::iterator&,const TreeModel::Path& >(this, &TreeView_signal_test_collapse_row_info);
}


Glib::SignalProxy2< void,const TreeModel::iterator&,const TreeModel::Path& > TreeView::signal_row_expanded()
{
  return Glib::SignalProxy2< void,const TreeModel::iterator&,const TreeModel::Path& >(this, &TreeView_signal_row_expanded_info);
}


Glib::SignalProxy2< void,const TreeModel::iterator&,const TreeModel::Path& > TreeView::signal_row_collapsed()
{
  return Glib::SignalProxy2< void,const TreeModel::iterator&,const TreeModel::Path& >(this, &TreeView_signal_row_collapsed_info);
}


Glib::SignalProxy0< void > TreeView::signal_cursor_changed()
{
  return Glib::SignalProxy0< void >(this, &TreeView_signal_cursor_changed_info);
}


Glib::SignalProxy0< void > TreeView::signal_columns_changed()
{
  return Glib::SignalProxy0< void >(this, &TreeView_signal_columns_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<TreeModel> > TreeView::property_model() 
{
  return Glib::PropertyProxy< Glib::RefPtr<TreeModel> >(this, "model");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TreeModel> > TreeView::property_model() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TreeModel> >(this, "model");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Adjustment*> TreeView::property_hadjustment() 
{
  return Glib::PropertyProxy<Adjustment*>(this, "hadjustment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Adjustment*> TreeView::property_hadjustment() const
{
  return Glib::PropertyProxy_ReadOnly<Adjustment*>(this, "hadjustment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Adjustment*> TreeView::property_vadjustment() 
{
  return Glib::PropertyProxy<Adjustment*>(this, "vadjustment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Adjustment*> TreeView::property_vadjustment() const
{
  return Glib::PropertyProxy_ReadOnly<Adjustment*>(this, "vadjustment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_headers_visible() 
{
  return Glib::PropertyProxy<bool>(this, "headers-visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_headers_visible() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "headers-visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_headers_clickable() 
{
  return Glib::PropertyProxy<bool>(this, "headers-clickable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_headers_clickable() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "headers-clickable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TreeViewColumn*> TreeView::property_expander_column() 
{
  return Glib::PropertyProxy<TreeViewColumn*>(this, "expander-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TreeViewColumn*> TreeView::property_expander_column() const
{
  return Glib::PropertyProxy_ReadOnly<TreeViewColumn*>(this, "expander-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_reorderable() 
{
  return Glib::PropertyProxy<bool>(this, "reorderable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_reorderable() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "reorderable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_rules_hint() 
{
  return Glib::PropertyProxy<bool>(this, "rules-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_rules_hint() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "rules-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_enable_search() 
{
  return Glib::PropertyProxy<bool>(this, "enable-search");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_enable_search() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "enable-search");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> TreeView::property_search_column() 
{
  return Glib::PropertyProxy<int>(this, "search-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> TreeView::property_search_column() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "search-column");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_fixed_height_mode() 
{
  return Glib::PropertyProxy<bool>(this, "fixed-height-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_fixed_height_mode() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "fixed-height-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_hover_selection() 
{
  return Glib::PropertyProxy<bool>(this, "hover-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_hover_selection() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "hover-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_hover_expand() 
{
  return Glib::PropertyProxy<bool>(this, "hover-expand");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_hover_expand() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "hover-expand");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_show_expanders() 
{
  return Glib::PropertyProxy<bool>(this, "show-expanders");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_show_expanders() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "show-expanders");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_level_indentation() 
{
  return Glib::PropertyProxy<bool>(this, "level-indentation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_level_indentation() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "level-indentation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_rubber_banding() 
{
  return Glib::PropertyProxy<bool>(this, "rubber-banding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_rubber_banding() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "rubber-banding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_enable_grid_lines() 
{
  return Glib::PropertyProxy<bool>(this, "enable-grid-lines");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_enable_grid_lines() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "enable-grid-lines");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> TreeView::property_enable_tree_lines() 
{
  return Glib::PropertyProxy<bool>(this, "enable-tree-lines");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TreeView::property_enable_tree_lines() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "enable-tree-lines");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gtk::TreeView::on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_scroll_adjustments)
    (*base->set_scroll_adjustments)(gobj(),(GtkAdjustment*)Glib::unwrap(hadjustment),(GtkAdjustment*)Glib::unwrap(vadjustment));
}
void Gtk::TreeView::on_row_activated(const TreeModel::Path& path, TreeViewColumn* column)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->row_activated)
    (*base->row_activated)(gobj(),const_cast<GtkTreePath*>((path).gobj()),(GtkTreeViewColumn*)Glib::unwrap(column));
}
bool Gtk::TreeView::on_test_expand_row(const TreeModel::iterator& iter, const TreeModel::Path& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->test_expand_row)
    return (*base->test_expand_row)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));

  typedef bool RType;
  return RType();
}
bool Gtk::TreeView::on_test_collapse_row(const TreeModel::iterator& iter, const TreeModel::Path& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->test_collapse_row)
    return (*base->test_collapse_row)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));

  typedef bool RType;
  return RType();
}
void Gtk::TreeView::on_row_expanded(const TreeModel::iterator& iter, const TreeModel::Path& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->row_expanded)
    (*base->row_expanded)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));
}
void Gtk::TreeView::on_row_collapsed(const TreeModel::iterator& iter, const TreeModel::Path& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->row_collapsed)
    (*base->row_collapsed)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));
}
void Gtk::TreeView::on_cursor_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->cursor_changed)
    (*base->cursor_changed)(gobj());
}
void Gtk::TreeView::on_columns_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->columns_changed)
    (*base->columns_changed)(gobj());
}


} // namespace Gtk


