// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_APPLICATION_H
#define _GTKMM_APPLICATION_H

#include <gtkmmconfig.h>


#include <glibmm.h>

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <giomm/application.h>
#include <gtkmm/window.h>
#include <gtkmm/actiongroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkApplication GtkApplication;
typedef struct _GtkApplicationClass GtkApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Application_Class; } // namespace Gtk
namespace Gtk
{

/** TODO
 */

class Application
  : public Gio::Application
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GtkApplication BaseObjectType;
  typedef GtkApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GtkApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkApplication*       gobj()       { return reinterpret_cast<GtkApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkApplication* gobj() const { return reinterpret_cast<GtkApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkApplication* gobj_copy();

private:


  //TODO: Constructor?
public:

 
  /** Create a new Gtk::Application, or if one has already been initialized
   * in this process, return the existing instance. This function will as
   * a side effect initialize the display system; see gtk_init().
   * 
   * For the behavior if this application is running in another process,
   * see Glib::application_new().
   * 
   * @newin{3,0}
   * @param appid System-dependent application identifier.
   * @param argc System argument count.
   * @param argv System argument vector.
   * @return A newly-referenced Gtk::Application.
   */
  static Glib::RefPtr<Application> create(const Glib::ustring& appid, Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);

 
  /** Retrieves the list of windows previously registered with
   * gtk_application_create_window() or add_window().
   * 
   * @newin{3,0}
   * @return A pointer
   * to the list of Gtk::Window<!-- -->s registered by this application,
   * or <tt>0</tt>. The returned SList is owned by the Gtk::Application
   * and it should not be modified or freed directly.
   */
  Glib::ListHandle<Window*> get_windows();

 
  /** Retrieves the list of windows previously registered with
   * gtk_application_create_window() or add_window().
   * 
   * @newin{3,0}
   * @return A pointer
   * to the list of Gtk::Window<!-- -->s registered by this application,
   * or <tt>0</tt>. The returned SList is owned by the Gtk::Application
   * and it should not be modified or freed directly.
   */
  Glib::ListHandle<const Window*> get_windows() const;

  
  /** Adds a window to the Gtk::Application.
   * 
   * If all the windows managed by Gtk::Application are closed, the
   * Gtk::Application will call gtk_application_quit(), and quit
   * the application.
   * 
   * If your application uses only a single toplevel window, you can
   * use gtk_application_get_window(). If you are using a sub-class
   * of Gtk::Application you should call gtk_application_create_window()
   * to let the Gtk::Application instance create a Gtk::Window and add
   * it to the list of toplevels of the application. You should call
   * this function only to add Gtk::Window<!-- -->s that you created
   * directly using Gtk::Window::new().
   * 
   * @newin{3,0}
   * @param window A toplevel window to add to @a app.
   */
  void add_window(Window& window);
  
  void remove_window(Window& window);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Application
   */
  Glib::RefPtr<Gtk::Application> wrap(GtkApplication* object, bool take_copy = false);
}


#endif /* _GTKMM_APPLICATION_H */

