// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gdkmm/rgba.h>
#include <gdkmm/private/rgba_p.h>

/*
 *
 * Copyright 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>

namespace Gdk
{

RGBA::RGBA()
{
  GdkRGBA tmp = { 0, 0, 0, 0, };
  gobject_ = gdk_rgba_copy(&tmp);
}

RGBA::RGBA(const Glib::ustring& value)
{
  GdkRGBA tmp = { 0, 0, 0, 0, };
  gobject_ = gdk_rgba_copy(&tmp);

  set(value);
}

void RGBA::set_grey(gushort value)
{
  gobject_->red = gobject_->green = gobject_->blue = value;
}

void RGBA::set_grey_p(double g)
{
 gobject_->red = gobject_->green = gobject_->blue = (gushort)(g * 65535.0);
}

void RGBA::set_rgb(gushort red_, gushort green_, gushort blue_)
{
  gobject_->red = red_;
  gobject_->green = green_;
  gobject_->blue = blue_;
}

void RGBA::set_rgb_p(double red_, double green_, double blue_)
{
  gobject_->red = (gushort)(red_ * 65535.0);
  gobject_->green = (gushort)(green_ * 65535.0);
  gobject_->blue = (gushort)(blue_ * 65535.0);
}

void RGBA::set_hsv(double h, double s, double v)
{
  //TODO: Comments/Documentation. I have no idea what this code does. murrayc.

  h /= 60.0;
  int i = (int)h;
  double p = v * (1 - s);
  double q = v * (1 - s * (h - i));
  double t = v * (1 - s * (1 - h + i));

  switch(i)
  {
    case 0:
      set_rgb_p(v, t, p);
      break;
    case 1:
      set_rgb_p(q, v, p);
      break;
    case 2:
      set_rgb_p(p, v, t);
      break;
    case 3:
      set_rgb_p(p, q, v);
      break;
    case 4:
      set_rgb_p(t, p, v);
      break;
    default:
      set_rgb_p(v, p, q);
  }
}

void RGBA::set_hsl(double h, double s, double l)
{
  //TODO: Comments/Documentation. I have no idea what this code does. murrayc.

  if(s == 0.0)
    set_grey_p(l);
  else
  {
    double t2 = (l < 0.5) ? l * (1.0 + s) : l + s - l * s;
    double t1 = 2*l-t2;
    h /= 360.0;

    double tr = h + 1.0/3.0;
    double tg = h;
    double tb = h - 1.0/3.0;
    if (tb < 0) tb += 1.0;

    double r = 0.0, g = 0.0, b = 0.0;

    if (tr < 1.0/6.0)
      r = t1 +(t2-t1) * 6 * tr;
    else if (tr < 1.0/2.0)
      r = t2;
    else if (tr < 2.0/3.0)
      r = t1+(t2-t1)*(2.0/3.0 - tr) * 6.0;

    if (tg < 1.0/6.0)
      g = t1 + (t2 - t1) * 6 * tg;
    else if (tg < 1.0/2.0)
      g = t2;
    else if (tg < 2.0/3.0)
      g = t1+(t2-t1)*(2.0/3.0 - tg) * 6.0;

    if (tb < 1.0/6.0)
      b = t1 +(t2-t1) * 6 * tb;
    else if (tb < 1.0/2.0)
      b = t2;
    else if (tb < 2.0/3.0)
      b = t1+(t2-t1)*(2.0/3.0 - tb) * 6.0;

    set_rgb_p(r, g, b);
  }
}

gushort RGBA::get_red() const
{
  return gobject_->red;
}

gushort RGBA::get_green() const
{
  return gobject_->green;

}
gushort RGBA::get_blue() const
{
 return gobject_->blue;
}

void RGBA::set_red(gushort value)
{
  gobject_->red = value;
}

void RGBA::set_green(gushort value)
{
  gobject_->green = value;
}

void RGBA::set_blue(gushort value)
{
  gobject_->blue = value;
}

double RGBA::get_red_p() const
{
  return gobject_->red / 65535.0;
}

double RGBA::get_green_p() const
{
  return gobject_->green / 65535.0;
}

double RGBA::get_blue_p() const
{
  return gobject_->blue / 65535.0;
}


} //namespace Gdk

namespace
{
} // anonymous namespace


namespace Glib
{

Gdk::RGBA wrap(GdkRGBA* object, bool take_copy)
{
  return Gdk::RGBA(object, take_copy);
}

} // namespace Glib


namespace Gdk
{


// static
GType RGBA::get_type()
{
  return gdk_rgba_get_type();
}


RGBA::RGBA(const RGBA& other)
:
  gobject_ ((other.gobject_) ? gdk_rgba_copy(other.gobject_) : 0)
{}

RGBA::RGBA(GdkRGBA* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gdk_rgba_copy(gobject) : gobject)
{}

RGBA& RGBA::operator=(const RGBA& other)
{
  RGBA temp (other);
  swap(temp);
  return *this;
}

RGBA::~RGBA()
{
  if(gobject_)
    gdk_rgba_free(gobject_);
}

void RGBA::swap(RGBA& other)
{
  GdkRGBA *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GdkRGBA* RGBA::gobj_copy() const
{
  return gdk_rgba_copy(gobject_);
}


bool RGBA::set(const Glib::ustring& value)
{
  return gdk_rgba_parse(gobj(), value.c_str());
}

Glib::ustring RGBA::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gdk_rgba_to_string(const_cast<GdkRGBA*>(gobj())));
}


bool operator==(const RGBA& lhs, const RGBA& rhs)
{
  return (gdk_rgba_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const RGBA& lhs, const RGBA& rhs)
{
  return (gdk_rgba_equal(lhs.gobj(), rhs.gobj()) == 0);
}


} // namespace Gdk


