// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_WIDGETPATH_H
#define _GTKMM_WIDGETPATH_H


#include <glibmm.h>

/* Copyright 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GtkWidgetPath GtkWidgetPath; }
#endif

namespace Gtk
{

//TODO: Add all of the C documentation, including translating the code examples to C++.
/** This represents a widget hierarchy from the topmost widget, typically a toplevel, to any child. 
 * This widget path abstraction is used in StyleContext on behalf of the real
 * widget in order to query style information.
 *
 * If you are using gtkmm widgets, you probably will not need to use
 * this API directly, as there is Widget::get_path(), and the style
 * context returned by Widget::get_style_context() will be automatically
 * updated on widget hierarchy changes.
 *
 * @newin{3,0}
 */
class WidgetPath
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef WidgetPath CppObjectType;
  typedef GtkWidgetPath BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  WidgetPath();

  explicit WidgetPath(GtkWidgetPath* gobject, bool make_a_copy = true);

  WidgetPath(const WidgetPath& other);
  WidgetPath& operator=(const WidgetPath& other);

  ~WidgetPath();

  void swap(WidgetPath& other);

  ///Provides access to the underlying C instance.
  GtkWidgetPath*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GtkWidgetPath* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GtkWidgetPath* gobj_copy() const;

protected:
  GtkWidgetPath* gobject_;

private:

  
public:

  
  int path_length() const;

  
  int path_append_type(GType type);
  
  void prepend_type(GType type);

  
  GType iter_get_object_type(int pos) const;
  
  void iter_set_object_type(int pos, GType type);

  
  Glib::ustring iter_get_name(int pos) const;
  
  void iter_set_name(int pos, const Glib::ustring& name);
  
  bool iter_has_name(int pos, const Glib::ustring& name) const;
  //TODO: _WRAP_METHOD(bool iter_has_qname(int pos, GQuark qname) const, gtk_widget_path_iter_has_qname)

  
  void iter_add_class(int pos, const Glib::ustring& name);
  
  void iter_remove_class(int pos, const Glib::ustring& name);
  
  void iter_clear_classes(int pos);
  //TODO: _WRAP_METHOD(GSList * gtk_widget_path_iter_list_classes(const GtkWidgetPath *path, int pos), gtk_widget_path_iter_list_classes)
  
  bool iter_has_class(int pos, const Glib::ustring& name) const;
  //TODOL_WRAP_METHOD(bool iter_has_qclass(int pos, GQuark qname) const, gtk_widget_path_iter_has_qclass)

  
  void iter_add_region(int  pos, const Glib::ustring& name,  RegionFlags flags);
  
  void iter_remove_region(int pos, const Glib::ustring& name);
  
  void iter_clear_regions(int pos);

  //TODO: _WRAP_METHOD(GSList* iter_list_regions(int pos), gtk_widget_path_iter_list_regions)

  
  bool iter_has_region(int pos, const Glib::ustring& name, RegionFlags& flags) const;
  //TODO: _WRAP_METHOD(bool iter_has_qregion(int pos, GQuark qname,  RegionFlags& flags), gtk_widget_path_iter_has_qregion)

  
  GType get_object_type() const;

  
  bool is_type(GType type) const;
  
  bool has_parent(GType type) const;


};

} /* namespace Gtk */


namespace Gtk
{

/** @relates Gtk::WidgetPath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(WidgetPath& lhs, WidgetPath& rhs)
  { lhs.swap(rhs); }

} // namespace Gtk

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gtk::WidgetPath
 */
Gtk::WidgetPath wrap(GtkWidgetPath* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gtk::WidgetPath> : public Glib::Value_Boxed<Gtk::WidgetPath>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GTKMM_WIDGETPATH_H */

