// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FONTCHOOSER_H
#define _GTKMM_FONTCHOOSER_H


#include <glibmm.h>

/* Copyright (C) 2011 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFontChooser GtkFontChooser;
typedef struct _GtkFontChooserClass GtkFontChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FontChooser_Class; } // namespace Gtk
namespace Gtk
{

/** A widget for selecting fonts.
 *
 * The Gtk::FontChooser widget lists the available fonts, styles and
 * sizes, allowing the user to select a font. It is used in the
 * Gtk::FontChooserDialog widget to provide a dialog box for selecting
 * fonts.
 *
 * To set the font which is initially selected, use set_font_name().
 *
 * To get the selected font use get_font_name().
 *
 * To change the text which is shown in the preview area, use set_preview_text().
 * 
 * @ingroup Widgets
 * @newin{3,2}
 */

class FontChooser : public Box
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FontChooser CppObjectType;
  typedef FontChooser_Class CppClassType;
  typedef GtkFontChooser BaseObjectType;
  typedef GtkFontChooserClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FontChooser();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FontChooser_Class;
  static CppClassType fontchooser_class_;

  // noncopyable
  FontChooser(const FontChooser&);
  FontChooser& operator=(const FontChooser&);

protected:
  explicit FontChooser(const Glib::ConstructParams& construct_params);
  explicit FontChooser(GtkFontChooser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkFontChooser*       gobj()       { return reinterpret_cast<GtkFontChooser*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkFontChooser* gobj() const { return reinterpret_cast<GtkFontChooser*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

   //deprecated
public:
  FontChooser();

  
  Glib::RefPtr<Pango::FontFamily> get_family();
  
  Glib::RefPtr<const Pango::FontFamily> get_family() const;

  
  Glib::RefPtr<Pango::FontFace> get_face();
  
  Glib::RefPtr<const Pango::FontFace> get_face() const;

  
  int get_size() const;

  
  Glib::ustring get_font_name() const;
  
  bool set_font_name(const Glib::ustring& fontname);
  
  Glib::ustring get_preview_text() const;
  
  void set_preview_text(const Glib::ustring& fontname);
  
  
  bool get_show_preview_entry() const;
  
  void set_show_preview_entry(bool show_preview_entry =  true);


  //Note: The GdkFont "font" property is deprecated, or should be.
  //gtkmmproc error: font-name : property defs lookup failed.
  //gtkmmproc error: preview-text : property defs lookup failed.
  //gtkmmproc error: show-preview-entry : property defs lookup failed.


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FontChooser
   */
  Gtk::FontChooser* wrap(GtkFontChooser* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_FONTCHOOSER_H */

