// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEVIEW_H
#define _GTKMM_TREEVIEW_H

#include <gtkmmconfig.h>


#include <glibmm.h>

/* Copyright(C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

// This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <vector>

#include <gtkmm/container.h>
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeselection.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/cellrenderer.h>
#include <gtkmm/scrollable.h>
#include <gtkmm/targetentry.h>
#include <gtkmm/entry.h>
#include <gtkmm/tooltip.h>


#include <cstdlib>

using std::strtod;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeView GtkTreeView;
typedef struct _GtkTreeViewClass GtkTreeViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeView_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewDropPosition
{
  TREE_VIEW_DROP_BEFORE,
  TREE_VIEW_DROP_AFTER,
  TREE_VIEW_DROP_INTO_OR_BEFORE,
  TREE_VIEW_DROP_INTO_OR_AFTER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewDropPosition> : public Glib::Value_Enum<Gtk::TreeViewDropPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewGridLines
{
  TREE_VIEW_GRID_LINES_NONE,
  TREE_VIEW_GRID_LINES_HORIZONTAL,
  TREE_VIEW_GRID_LINES_VERTICAL,
  TREE_VIEW_GRID_LINES_BOTH
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewGridLines> : public Glib::Value_Enum<Gtk::TreeViewGridLines>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


#ifndef DOXYGEN_SHOULD_SKIP_THIS

class TreeView;

namespace TreeView_Private
{
/* This helper function is not a member of TreeView just for the reason that
 * there are compilers that have problems compiling it otherwise. E.g. in gcc
 * 2.95.3 a compiler bug prevents member functions from refering to specialized
 * member function templates and that's what we do here: In function
 * _connect_auto_store_editable_signal_handler we build a slot from
 * TreeView::_auto_store_on_cellrenderer_*_edited. (The latter must be member
 * functions of TreeView since we connect them to signals and we want the
 * connections to vanish when the TreeView dies, of course.)
 */
  template <class ColumnType> inline
  void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<ColumnType>& model_column);

  template<class ColumnType> inline
  void _auto_store_on_cellrenderer_text_edited_string(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);

  template <class ColumnType> inline
  void _auto_store_on_cellrenderer_text_edited_numerical(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);

  template <class ColumnType> inline
  void _auto_cell_data_func(Gtk::CellRenderer* cell, const Gtk::TreeModel::iterator& iter, int model_column, const Glib::ustring& format);
}

#endif //DOXYGEN_SHOULD_SKIP_THIS


//class TreeViewColumn;
class TreeModel;

/** @defgroup TreeView TreeView Classes
 * These classes are used with the Gtk::TreeView widget.
 */

/** The TreeView widget displays the model (Gtk::TreeModel) data and allows the user to interact with it.
 * The View can show all of the model's columns, or just some, and it can show them in various ways.
 * You must provide the TreeModel in the constructor, or with set_model().
 *
 * Add View columns with append_column(), append_column_editable(), insert_column(), or insert_column_editable().
 *
 * You can manipulate the selection by obtaining the @link Gtk::TreeSelection Gtk::TreeView::Selection@endlink from get_selection().
 *
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup TreeView
 */

class TreeView
 : public Container,
   public Scrollable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeView CppObjectType;
  typedef TreeView_Class CppClassType;
  typedef GtkTreeView BaseObjectType;
  typedef GtkTreeViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TreeView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TreeView_Class;
  static CppClassType treeview_class_;

  // noncopyable
  TreeView(const TreeView&);
  TreeView& operator=(const TreeView&);

protected:
  explicit TreeView(const Glib::ConstructParams& construct_params);
  explicit TreeView(GtkTreeView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkTreeView*       gobj()       { return reinterpret_cast<GtkTreeView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkTreeView* gobj() const { return reinterpret_cast<GtkTreeView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_row_activated(const TreeModel::Path& path, TreeViewColumn* column);
  virtual bool on_test_expand_row(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual bool on_test_collapse_row(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual void on_row_expanded(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual void on_row_collapsed(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual void on_cursor_changed();
  virtual void on_columns_changed();


private:

  
public:
  /**  A visible column in a Gtk::TreeView widget.
   */
  typedef TreeViewColumn Column;

  /** A selection object for Gtk::TreeView.
   */
  typedef TreeSelection Selection;

  /** Default constructor.
   */
  TreeView();

  /**
     Constructor that binds to a TreeModel.
   */
    explicit TreeView(const Glib::RefPtr<TreeModel>& model);


  /** Returns the model the Gtk::TreeView is based on.  Returns <tt>0</tt> if the
   * model is unset.
   * @return A Gtk::TreeModel, or <tt>0</tt> if none is currently being used.
   */
  Glib::RefPtr<TreeModel> get_model();
  
  /** Returns the model the Gtk::TreeView is based on.  Returns <tt>0</tt> if the
   * model is unset.
   * @return A Gtk::TreeModel, or <tt>0</tt> if none is currently being used.
   */
  Glib::RefPtr<const TreeModel> get_model() const;
  
  /** Sets the model for a Gtk::TreeView.  If the @a tree_view already has a model
   * set, it will remove it before setting the new model. Use unset_model() to
   * unset the old model.
   * @param model The model.
   */
  void set_model(const Glib::RefPtr<TreeModel>& model);

  /** Remove the model from the TreeView.
   *
   * @see set_model().
   *
   * @newin{2,8}
   */
  void unset_model();

  
  /** Gets the Gtk::TreeSelection associated with @a tree_view.
   * @return A Gtk::TreeSelection object.
   */
  Glib::RefPtr<TreeSelection> get_selection();
  
  /** Gets the Gtk::TreeSelection associated with @a tree_view.
   * @return A Gtk::TreeSelection object.
   */
  Glib::RefPtr<const TreeSelection> get_selection() const;
   //deprecated

  
  /** Returns <tt>true</tt> if the headers on the @a tree_view are visible.
   * @return Whether the headers are visible or not.
   */
  bool get_headers_visible() const;
  
  /** Sets the visibility state of the headers.
   * @param headers_visible <tt>true</tt> if the headers are visible.
   */
  void set_headers_visible(bool headers_visible =  true);
  
  /** Resizes all columns to their optimal width. Only works after the
   * treeview has been realized.
   */
  void columns_autosize();
  
  /** Returns whether all header columns are clickable.
   * 
   * @newin{2,10}
   * @return <tt>true</tt> if all header columns are clickable, otherwise <tt>false</tt>.
   */
  bool get_headers_clickable() const;
  
  /** Allow the column title buttons to be clicked.
   * @param setting <tt>true</tt> if the columns are clickable.
   */
  void set_headers_clickable(bool setting =  true);
  
  /** This function tells GTK+ that the user interface for your
   * application requires users to read across tree rows and associate
   * cells with one another. By default, GTK+ will then render the tree
   * with alternating row colors. Do <em>not</em> use it
   * just because you prefer the appearance of the ruled tree; that's a
   * question for the theme. Some themes will draw tree rows in
   * alternating colors even when rules are turned off, and users who
   * prefer that appearance all the time can choose those themes. You
   * should call this function only as a <em>semantic</em>
   * hint to the theme engine that your tree makes alternating colors
   * useful from a functional standpoint (since it has lots of columns,
   * generally).
   * @param setting <tt>true</tt> if the tree requires reading across rows.
   */
  void set_rules_hint(bool setting =  true);
  
  /** Gets the setting set by set_rules_hint().
   * @return <tt>true</tt> if rules are useful for the user of this tree.
   */
  bool get_rules_hint() const;

  
  /** Appends @a column to the list of columns. If @a tree_view has "fixed_height"
   * mode enabled, then @a column must have its "sizing" property set to be
   * GTK_TREE_VIEW_COLUMN_FIXED.
   * @param column The Gtk::TreeViewColumn to add.
   * @return The number of columns in @a tree_view after appending.
   */
  int append_column(TreeViewColumn& column);

  /** Appends a View column with the appropriate CellRenderer for the Model column.
   *
   * The CellRenderer can only be created automatically for some basic
   * column types, such as Glib::ustring, int, double, bool, and Gdk::Pixbuf.
   * If the type is not supported then the following warning will be shown:
   * GLib-GObject-WARNING **: unable to set property `text' of type
   * `gchararray' from value of type `glibmm__CustomBoxed_t'.
   *
   * If the default formatting is not sufficient, or the numeric type is
   * not supported, then you could use append_column_numeric(). Or you
   * could create the TreeView::Column and/or CellRenderer
   * manually and use TreeViewColumn::set_cell_data_func() to provide a callback
   * that converts the model value into a string representation with .
   *
   * @param title The text to be used in the title header of this column.
   * @param model_column The column in the TreeModel that will be rendered by this View column.
   * @result The number of columns in the View after appending.
   */
  template <class ColumnType> inline
  int append_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column);

  /** Like append_column(), but only for numeric types, which will be displayed in the specified format.
   * This convenience template uses TreeView::Column::set_cell_data_func(), so the numeric formatting will
   * be deactivated if you specify your own cell_data callback by calling set_cell_data_func() again.
   *
   * @param title The text to be used in the title header of this column.
   * @param model_column The column in the TreeModel that will be rendered by this View column.
   * @param format A printf-style format, such as "%d", used to create a text representation of the number.
   * @result The number of columns in the View after appending.
   */
  template <class ColumnType> inline
  int append_column_numeric(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, const Glib::ustring& format);

  //TODO: danielk suggested use of Glib::Value to simplify/improve this.
  /** Appends a View column with the appropriate CellRenderer for the Model
   * column.  The compiler will attempt to instantiate appropriate template
   * code to automatically store user changes in the model.  To intercept the
   * user's change and implement non-default logic, or if the compiler can't
   * instantiate appropriate code for your model type, you could use
   * append_column() and connect a signal handler to the CellRenderer.
   *
   * @see append_column_numeric_editable().
   *
   * @param title The text to be used in the title header of this column.
   * @param model_column The column in the TreeModel that will be rendered by this View column.
   * @result The number of columns in the View after appending.
   */
  template <class ColumnType> inline
  int append_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column);

  /** Like append_column_editable(), but only for numeric types, which will be displayed in the specified format.
   * This convenience template uses TreeView::Column::set_cell_data_func(), so the numeric formatting will
   * be deactivated if you specify your own cell_data callback by calling set_cell_data_func() again.
   *
   * Note that the user's input will be interpreted as decimal (base 10), regardless of the @a format.
   *
   * @param title The text to be used in the title header of this column.
   * @param model_column The column in the TreeModel that will be rendered by this View column.
   * @param format A printf-style format, such as "%d", used to create a text representation of the number.
   * @result The number of columns in the View after appending.
   */
  template <class ColumnType> inline
  int append_column_numeric_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, const Glib::ustring& format);


  /// Creates a View column containing the CellRenderer, and appends it.
  int append_column(const Glib::ustring& title, CellRenderer& cell);

  
  /** Removes @a column from @a tree_view.
   * @param column The Gtk::TreeViewColumn to remove.
   * @return The number of columns in @a tree_view after removing.
   */
  int remove_column(TreeViewColumn& column);

  /// Removes all View columns.
  void remove_all_columns();

  
  /** This inserts the @a column into the @a tree_view at @a position.  If @a position is
   * -1, then the column is inserted at the end. If @a tree_view has
   * "fixed_height" mode enabled, then @a column must have its "sizing" property
   * set to be GTK_TREE_VIEW_COLUMN_FIXED.
   * @param column The Gtk::TreeViewColumn to be inserted.
   * @param position The position to insert @a column in.
   * @return The number of columns in @a tree_view after insertion.
   */
  int insert_column(TreeViewColumn& column, int position);

  /** Creates a View column containing the CellRenderer, and inserts it.
   *
   * @param title The text to be used in the title header of this column.
   * @param cell The CellRenderer.
   * @param position The position at which the CellRenderer should be inserted.
   * @result The number of columns in the View after inserting.
   */
  int insert_column(const Glib::ustring& title, CellRenderer& cell, int position);

  
  /** Inserts a View column with the appropriate CellRenderer for the Model column.
   *
   * @param title The text to be used in the title header of this column.
   * @param model_column The column in the TreeModel that will be rendered by this View column.
   * @param position The position at which the CellRenderer should be inserted.
   * @result The number of columns in the View after inserting.
   */
  template <class ColumnType> inline
  int insert_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position);

  /** Inserts a View column with the appropriate CellRenderer for the Model
   * column.  The compiler will attempt to instantiate appropriate template
   * code to automatically store user changes in the model.  To intercept the
   * user's change and implement non-default logic, or if the compiler can't
   * instantiate appropriate code for your model type, you should use
   * append_column() and connect a signal handler to the CellRenderer.
   *
   * @param title The text to be used in the title header of this column.
   * @param model_column The column in the TreeModel that will be rendered by this View column.
   * @param position The position at which the CellRenderer should be inserted.
   * @result The number of columns in the View after inserting.
   */
  template <class ColumnType> inline
  int insert_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position);

  typedef TreeViewColumn::SlotCellData SlotCellData;

  /**
   * Inserts a new column into the TreeView with the given cell
   * renderer and a SlotCellData to set cell renderer attributes
   * (normally using data from the model).
   *
   * @param position Position to insert, -1 for append
   * @param title column title
   * @param cell cell renderer for column
   * @param slot function to set attributes of cell renderer
   * @return number of columns in the TreeView after the insert
   */
  int insert_column_with_data_func(int position, const Glib::ustring& title, CellRenderer& cell, const SlotCellData& slot);

  
  /** Gets the Gtk::TreeViewColumn at the given position in the #tree_view.
   * @param n The position of the column, counting from 0.
   * @return The Gtk::TreeViewColumn, or <tt>0</tt> if the position is outside the
   * range of columns.
   */
  TreeViewColumn* get_column(int n);
  
  /** Gets the Gtk::TreeViewColumn at the given position in the #tree_view.
   * @param n The position of the column, counting from 0.
   * @return The Gtk::TreeViewColumn, or <tt>0</tt> if the position is outside the
   * range of columns.
   */
  const TreeViewColumn* get_column(int n) const;

  //The column index is of the view, not the model, so we do not need TreeViewColumn* get_column(TreeViewColumn& base_column).

  /** Gets the CellRenderer for that column.
    * You should dynamic_cast<> to the expected derived CellRenderer type.
    * This assumes that the TreeViewColumn contains only one CellRenderer.
    *
    * @param n The position of the view column.
    * @result The CellRenderer.
    */
  CellRenderer* get_column_cell_renderer(int n);

 //TODO: Add TreeViewColumn* get_column_cell_renderer(TreeViewColumn& base_column); and a const one.


  /** Gets the CellRenderer for that column.
    * You should dynamic_cast<> to the expected derived CellRenderer type.
    * This assumes that the TreeViewColumn contains only one CellRenderer.
    *
    * @param n The position of the view column.
    * @result The CellRenderer.
    */
  const CellRenderer* get_column_cell_renderer(int n) const;

 
  /** Returns a list of all the Gtk::TreeViewColumn s currently in @a tree_view.
   * @return A list of Gtk::TreeViewColumn s.
   */
  std::vector<TreeViewColumn*> get_columns();
 

  /** Returns a list of all the Gtk::TreeViewColumn s currently in @a tree_view.
   * @return A list of Gtk::TreeViewColumn s.
   */
  std::vector<const TreeViewColumn*> get_columns() const;

  
  /** Moves @a column to be after to @a base_column.  See also move_column_to_start().
   * @param column The Gtk::TreeViewColumn to be moved.
   * @param base_column The Gtk::TreeViewColumn to be moved relative to.
   */
  void move_column_after(TreeViewColumn& column, TreeViewColumn& base_column);

  /** This method moves column to the first position in the view.
   *
   * @param column The view column that will be moved
   */
  void move_column_to_start(TreeViewColumn& column);

  
  /** Sets the column to draw the expander arrow at. It must be in the TreeView.  See also reset_expander_column().
   * @param column The column to draw the expander arrow at.
   */
  void set_expander_column(TreeViewColumn& column);

  /** This method resets the expander arrow to the default - the first visible column.
   * @see set_expander_column().
   */
  void reset_expander_column();

  
  /** Returns the column that is the current expander column.  This
   * column has the expander arrow drawn next to it.
   * @return The expander column.
   */
  TreeViewColumn* get_expander_column();
  
  /** Returns the column that is the current expander column.  This
   * column has the expander arrow drawn next to it.
   * @return The expander column.
   */
  const TreeViewColumn* get_expander_column() const;

  /** For instance,
   * bool on_column_drop(TreeView*, tree_view, TreeViewColumn* column, TreeViewColumn* prev_column, TreeViewColumn* next_column)
   *
   * This function is called on every column pair in turn at the beginning of a column drag to determine where a
   * drop can take place. The arguments passed to the function are: the tree_view, the view Column being dragged,
   * and the two view Columns determining the drop spot. If either of the view Column arguments for the drop spot
   * are 0, then they indicate an edge.
   */
  typedef sigc::slot<bool, TreeView*, TreeViewColumn*,  TreeViewColumn*, TreeViewColumn*> SlotColumnDrop;

  /** Sets a callback slot for determining where a column may be dropped when dragged.
   * This function is called on every column pair in turn at the beginning of a column drag to determine where a
   * drop can take place. The arguments passed to the function are: the tree_view, the view Column being dragged,
   * and the two view Columns determining the drop spot. If either of the view Column arguments for the drop spot
   * are 0, then they indicate an edge.
   *
   * See unset_column_drag_function().
   *
   * @param slot A callback function to determine which columns are reorderable.
   */
  void set_column_drag_function(const SlotColumnDrop& slot);
  

  /** See set_column_drag_function(). After this method has been called, the TreeView reverts to the default behavior of
  * allowing all columns to be dropped everywhere.
  */
  void unset_column_drag_function();

  
  /** Scrolls the tree view such that the top-left corner of the visible
   * area is @a tree_x, @a tree_y, where @a tree_x and @a tree_y are specified
   * in tree coordinates.  The @a tree_view must be realized before
   * this function is called.  If it isn't, you probably want to be
   * using scroll_to_cell().
   * 
   * If either @a tree_x or @a tree_y are -1, then that direction isn't scrolled.
   * @param tree_x X coordinate of new top-left pixel of visible area, or -1.
   * @param tree_y Y coordinate of new top-left pixel of visible area, or -1.
   */
  void scroll_to_point(int tree_x, int tree_y);

  /** Moves the alignments of tree view to the position specified by @a column and @a path.
   * @a row_align determines where the row is placed, and @a col_align determines where
   * column is placed. Both are expected to be between 0.0 and 1.0. 0.0 means left/top
   * alignment, 1.0 means right/bottom alignment, 0.5 means center.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree view is realized, the centered path will be
   * modified to reflect this change.
   *
   * @param path The path of the row to move to.
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   * @param row_align The vertical alignment of the row specified by @a path.
   * @param col_align The horizontal alignment of the column specified by @a column.
   */
  void scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column, float row_align, float col_align);
  

  /** Moves the alignments of tree view to the position specified by @a column and @a path.
   * The tree does the minimum amount of work to scroll the cell onto the screen. This means
   * that the cell will be scrolled to the edge closest to it's current position. If the cell
   * is currently visible on the screen, nothing is done.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree_view is realized, the centered path will be modified
   * to reflect this change.
   *
   * @param path The path of the row to move to.
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   */
  void scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column);

  /** Moves the alignments of tree view to the position specified by @a path.
   * @a row_align determines where the row is placed, and is expected to be between 0.0
   * and 1.0.  0.0 means top alignment, 1.0 means bottom alignment, 0.5 means center.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree view is realized, the centered path will be
   * modified to reflect this change.
   *
   * @param path The path of the row to move to.
   * @param row_align The vertical alignment of the row specified by @a path.
   */
  void scroll_to_row(const TreeModel::Path& path, float row_align);

  /** Moves the alignments of tree view to the position specified by @a path.
   * The tree does the minimum amount of work to scroll the row onto the screen. This means
   * that the row will be scrolled to the edge closest to it's current position. If the row
   * is currently visible on the screen, nothing is done.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree view is realized, the centered path will be
   * modified to reflect this change.
   *
   * @param path The path of the row to move to.
   */
  void scroll_to_row(const TreeModel::Path& path);

  /** Moves the alignments of tree view to the position specified by @a column.
   * @a col_align determines where the column is placed, and is expected to be between 0.0
   * and 1.0.  0.0 means left alignment, 1.0 means right alignment, 0.5 means center.
   *
   * This function only works if the model is set.  If the model changes before the tree
   * view is realized, the centered path will be modified to reflect this change.
   *
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   * @param col_align The horizontal alignment of the column specified by @a column.
   */
  void scroll_to_column(TreeViewColumn& column, float col_align);

  /** Moves the alignments of tree view to the position specified by @a column.
   * The tree does the minimum amount of work to scroll the column onto the screen. This means
   * that the column will be scrolled to the edge closest to it's current position. If the column
   * is currently visible on the screen, nothing is done.
   *
   * This function only works if the model is set.  If the model changes before the
   * tree view is realized, the centered path will be modified to reflect this change.
   *
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   */
  void scroll_to_column(TreeViewColumn& column);

  
  /** Activates the cell determined by @a path and @a column.
   * @param path The Gtk::TreePath to be activated.
   * @param column The Gtk::TreeViewColumn to be activated.
   */
  void row_activated(const TreeModel::Path& path, TreeViewColumn& column);
  
  /** Recursively expands all nodes in the @a tree_view.
   */
  void expand_all();
  
  /** Recursively collapses all visible, expanded nodes in @a tree_view.
   */
  void collapse_all();
  
  /** Expands the row at @a path. This will also expand all parent rows of
   *  @a path as necessary.
   * 
   * @newin{2,2}
   * @param path Path to a row.
   */
  void expand_to_path(const TreeModel::Path& path);
  
  /** Opens the row so its children are visible.
   * @param path Path to a row.
   * @param open_all Whether to recursively expand, or just expand immediate children.
   * @return <tt>true</tt> if the row existed and had children.
   */
  bool expand_row(const TreeModel::Path& path, bool open_all);
  
  /** Collapses a row (hides its child rows, if they exist).
   * @param path Path to a row in the @a tree_view.
   * @return <tt>true</tt> if the row was collapsed.
   */
  bool collapse_row(const TreeModel::Path& path);

  /** For example,
   * void on_map_expanded_rows(TreeView* tree_view, const TreeModel::Path& path);
   */
  typedef sigc::slot<void, TreeView*, const TreeModel::Path&> SlotMapping;

  /** Calls the callback slot on all expanded rows.
   * @param slot A callback function to be called.
   */
  void map_expanded_rows(const SlotMapping& slot);
  

  /** Returns <tt>true</tt> if the node pointed to by @a path is expanded in @a tree_view.
   * @param path A Gtk::TreePath to test expansion state.
   * @return <tt>true</tt> if #path is expanded.
   */
  bool row_expanded(const TreeModel::Path& path);
  
  /** This function is a convenience function to allow you to reorder
   * models that support the Gtk::DragSourceIface and the
   * Gtk::DragDestIface.  Both Gtk::TreeStore and Gtk::ListStore support
   * these.  If @a reorderable is <tt>true</tt>, then the user can reorder the
   * model by dragging and dropping rows. The developer can listen to
   * these changes by connecting to the model's row_inserted and
   * row_deleted signals. The reordering is implemented by setting up
   * the tree view as a drag source and destination. Therefore, drag and
   * drop can not be used in a reorderable view for any other purpose.
   * 
   * This function does not give you any degree of control over the order -- any
   * reordering is allowed.  If more control is needed, you should probably
   * handle drag and drop manually.
   * @param reorderable <tt>true</tt>, if the tree can be reordered.
   */
  void set_reorderable(bool reorderable =  true);
  
  /** Retrieves whether the user can reorder the tree via drag-and-drop. See
   * set_reorderable().
   * @return <tt>true</tt> if the tree can be reordered.
   */
  bool get_reorderable() const;

  //TODO: Add set_cursor(path, ModelColumnBase&, start_editing)?
  
  /** Sets the current keyboard focus to be at @a path, and selects it.  This is
   * useful when you want to focus the user's attention on a particular row. Focus is given to the column specified.
   * Additionally, if @a start_editing is
   * <tt>true</tt>, then editing should be started in the specified cell.
   * This function is often followed by Gtk::Widget::grab_focus( @a tree_view)
   * in order to give keyboard focus to the widget.  Please note that editing
   * can only happen when the widget is realized.
   * @param path A Gtk::TreePath.
   * @param focus_column A Gtk::TreeViewColumn.
   * @param start_editing <tt>true</tt> if the specified cell should start being edited.
   */
  void set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, bool start_editing =  false);

  
  /** Sets the current keyboard focus to be at @a path, and selects it.  This is
   * useful when you want to focus the user's attention on a particular row.  If
   *  @a focus_column is not <tt>0</tt>, then focus is given to the column specified by
   * it. If @a focus_column and @a focus_cell are not <tt>0</tt>, and @a focus_column
   * contains 2 or more editable or activatable cells, then focus is given to
   * the cell specified by @a focus_cell. Additionally, if @a focus_column is
   * specified, and @a start_editing is <tt>true</tt>, then editing should be started in
   * the specified cell.  This function is often followed by
   *  @a gtk_widget_grab_focus ( @a tree_view) in order to give keyboard focus to the
   * widget.  Please note that editing can only happen when the widget is
   * realized.
   * 
   * If @a path is invalid for @a model, the current cursor (if any) will be unset
   * and the function will return without failing.
   * 
   * @newin{2,2}
   * @param path A Gtk::TreePath.
   * @param focus_column A Gtk::TreeViewColumn, or <tt>0</tt>.
   * @param focus_cell A Gtk::CellRenderer, or <tt>0</tt>.
   * @param start_editing <tt>true</tt> if the specified cell should start being edited.
   */
  void set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, CellRenderer& focus_cell, bool start_editing =  false);


  /** Sets the current keyboard focus to be at path , and selects it.
   * This is useful when you want to focus the user's attention on a particular row.
   * This function is often followed by Gtk::widget::grab_focus(tree_view)
   * in order to give keyboard focus to the widget.
   *
   *  @param path A reference to cursor path.
   */
  void set_cursor(const TreeModel::Path& path);

  /**  Fills in path and focus_column with the current path and focus column.
   *
   *  @param path A reference to be filled with the current cursor path
   *  @param focus_column A reference to be filled with the current focus column
   */
  void get_cursor(TreeModel::Path& path, TreeViewColumn*& focus_column);

/* Layout information */
  
  /** Returns the window that @a tree_view renders to.  This is used primarily to
   * compare to <tt>event->window</tt> to confirm that the event on
   *  @a tree_view is on the right window.
   * @return A Gdk::Window, or <tt>0</tt> when @a tree_view hasn't been realized yet.
   */
  Glib::RefPtr<Gdk::Window> get_bin_window();
  
  /** Returns the window that @a tree_view renders to.  This is used primarily to
   * compare to <tt>event->window</tt> to confirm that the event on
   *  @a tree_view is on the right window.
   * @return A Gdk::Window, or <tt>0</tt> when @a tree_view hasn't been realized yet.
   */
  Glib::RefPtr<const Gdk::Window> get_bin_window() const;

  /** Finds the path at the point (@a x, @a y), relative to bin_window coordinates
   * (please get_bin_window()).
   * That is, @a x and @a y are relative to an events coordinates. @a x and @a y must
   * come from an event on the TreeView only where <literal>event->window ==
   * gtk_tree_view_get_bin_window (<!-- -->)</literal>. It is primarily for
   * things like popup menus. @a path will be filled
   * with the TreeModel::Path at that point. @a column will be filled
   * with the column at that point.  @a cell_x and @a cell_y return the coordinates
   * relative to the cell background (i.e. the background_area passed to
   * Gtk::CellRenderer::render()).  This method is only meaningful if
   * the TreeView is realized.
   *
   * For converting widget coordinates (eg. the ones you get from
   * Widget::property_query_tooltip()), please see
   * convert_widget_to_bin_window_coords().
   *
   * @param x The x position to be identified (relative to bin_window).
   * @param y The y position to be identified (relative to bin_window).
   * @param path A reference to a TreeModel::Path to be filled in
   * @param column A reference to a TreeViewColumn pointer to be filled in
   * @param cell_x A reference where the X coordinate relative to the cell
   *   can be placed
   * @param cell_y A reference where the Y coordinate relative to the cell
   *   can be placed
   * @return true if a row exists at that coordinate.
   *
   * @newin{2,8}
   */
  bool get_path_at_pos(int x, int y, TreeModel::Path& path, TreeViewColumn*& column, int& cell_x, int& cell_y) const;

  /** Finds the path at the point (@a x, @a y), relative to bin_window coordinates
   * (please get_bin_window()).
   * That is, @a x and @a y are relative to an events coordinates. @a x and @a y must
   * come from an event on the TreeView only where event->window ==
   * get_bin_window(). It is primarily for
   * things like popup menus. @a path will be filled
   * with the TreeModel::Path at that point.
   * This method is only meaningful if the TreeView is realized.
   *
   * For converting widget coordinates (eg. the ones you get from
   * Widget::property_query_tooltip()), please see
   * convert_widget_to_bin_window_coords().
   *
   * @param x The x position to be identified (relative to bin_window).
   * @param y The y position to be identified (relative to bin_window).
   * @param path A reference to a TreeModel::Path to be filled in
   * @return true if a row exists at that coordinate.
   *
   * newin{2,16}
   */
  bool get_path_at_pos(int x, int y, TreeModel::Path& path) const;

  //We ignore the fact that one of the arguments can be 0 - it does not seem useful.
  
  /** Fills the bounding rectangle in tree window coordinates for the cell at the
   * row specified by @a path and the column specified by @a column.  If @a path points to a path not currently displayed, the @a y and @a height fields
   * of the rectangle will be filled with 0.  The sum of all cell rects does not cover the
   * entire tree; there are extra pixels in between rows, for example. The
   * returned rectangle is equivalent to the @a cell_area passed to
   * Gtk::CellRenderer::render().  This function is only valid if #tree_view is
   * realized.
   * @param path A Gtk::TreePath for the row.
   * @param column A Gtk::TreeViewColumn for the column.
   * @param rect Rectangle to fill with cell rect.
   */
  void get_cell_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect) const;

  
  /** Fills the bounding rectangle in tree window coordinates for the cell at the
   * row specified by @a path and the column specified by @a column.  The returned rectangle is equivalent to the
   *  @a background_area passed to Gtk::CellRenderer::render().  These background
   * areas tile to cover the entire tree window (except for the area used for
   * header buttons). Contrast with the @a cell_area, returned by
   * get_cell_area(), which returns only the cell itself, excluding
   * surrounding borders and the tree expander area.
   * @param path A Gtk::TreePath for the row.
   * @param column A Gtk::TreeViewColumn for the column.
   * @param rect Rectangle to fill with cell background rect.
   */
  void get_background_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect) const;
  //We ignore the fact that one of the arguments can be 0 - it does not seem useful.

  
  /** Fills @a visible_rect with the currently-visible region of the
   * buffer, in tree coordinates. Convert to bin_window coordinates with
   * convert_tree_to_bin_window_coords().
   * Tree coordinates start at 0,0 for row 0 of the tree, and cover the entire
   * scrollable area of the tree.
   * @param visible_rect Rectangle to fill.
   */
  void get_visible_rect(Gdk::Rectangle& visible_rect) const;

   //deprecated

   bool get_visible_range(TreeModel::Path& start_path, TreeModel::Path& end_path) const;
  

  //TODO: Documentation
  bool is_blank_at_pos(int x, int y, TreePath& path, TreeViewColumn*& column, int& cell_x, int& cell_y) const;
  

  //TODO: Documentation
  bool is_blank_at_pos(int x, int y) const;


/* Drag-and-Drop support */
  

  /**
   * Turns the TreeView into a drag source for automatic DND.
   *
   * @param targets Standard container of targets that the drag will support.
   * @param start_button_mask Mask of allowed buttons to start drag.
   * @param actions The bitmask of possible actions for a drag from this widget.
   */
  void enable_model_drag_source(const std::vector<TargetEntry>& targets,
                                Gdk::ModifierType start_button_mask = Gdk::MODIFIER_MASK,
                                Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

  // Uses the default "GTK_TREE_MODEL_ROW" target, which the TreeView can handle automatically.

  /** Turns the TreeView into a drag source for automatic DND.
   *
   * @param start_button_mask Mask of allowed buttons to start drag.
   * @param actions The bitmask of possible actions for a drag from this widget.
   */
  void enable_model_drag_source(Gdk::ModifierType start_button_mask = Gdk::MODIFIER_MASK,
                                Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

  
  /** Turns the TreeView into a drop destination for automatic DND.
   *
   * @param targets The table of targets that the drag will support.
   * @param actions The bitmask of possible actions for a drag from this widget.
   */
  void enable_model_drag_dest(const std::vector<TargetEntry>& targets, Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

  /** Turns the TreeView into a drop destination for automatic DND.  This uses the default
    *  "GTK_TREE_MODEL_ROW" target, which the TreeView can handle automatically.
    *
    * @param actions The bitmask of possible actions for a drag from this widget.
   */
  void enable_model_drag_dest(Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

  
  /** Undoes the effect of enable_model_drag_source()
   */
  void unset_rows_drag_source();

  
  /** Undoes the effect of enable_model_drag_source()
   */
  void unset_rows_drag_dest();


  /* These are useful to implement your own custom stuff. */

  
  /** Sets the row that is highlighted for feedback.
   *
   * @param path The path of the row to highlight
   * @param pos Specifies whether to drop before, after or into the row
   */
  void set_drag_dest_row(const TreeModel::Path& path, TreeViewDropPosition pos);

  /** Gets information about the row that is highlighted for feedback.
   *
   * @param path Return location for the path of the highlighted row
   * @param pos Return location for the drop position
   */
  void get_drag_dest_row(TreeModel::Path& path, TreeViewDropPosition& pos) const;

  /** Determines the destination row for a given position.
   *
   * @param drag_x The x position to determine the destination row for
   * @param drag_y The y position to determine the destination row for
   * @param path Return location for the path of the highlighted row
   * @param pos Return location for the drop position
   */
  bool get_dest_row_at_pos(int drag_x, int drag_y, TreeModel::Path& path, TreeViewDropPosition& pos) const;

 
  /** Creates a Gdk::Pixmap representation of the row at @a path.  
   * This image is used for a drag icon.
   * @param path A Gtk::TreePath in @a tree_view.
   * @return A newly-allocated pixmap of the drag icon.
   */
  Cairo::RefPtr<Cairo::Surface> create_row_drag_icon(const TreeModel::Path& path) const;

/* Interactive search */
  
  /** If @a enable_search is set, then the user can type in text to search through
   * the tree interactively (this is sometimes called "typeahead find").
   * 
   * Note that even if this is <tt>false</tt>, the user can still initiate a search 
   * using the "start-interactive-search" key binding.
   * @param enable_search <tt>true</tt>, if the user can search interactively.
   */
  void set_enable_search(bool enable_search =  true);
  
  /** Returns whether or not the tree allows to start interactive searching 
   * by typing in text.
   * @return Whether or not to let the user search interactively.
   */
  bool get_enable_search() const;
  
  /** Gets the column searched on by the interactive search code.
   * @return The column the interactive search code searches in.
   */
  int get_search_column() const;
  
  /** Sets @a column as the column where the interactive search code should
   * search in for the current model. 
   * 
   * If the search column is set, users can use the "start-interactive-search"
   * key binding to bring up search popup. The enable-search property controls
   * whether simply typing text will also start an interactive search.
   * 
   * Note that @a column refers to a column of the current model. The search 
   * column is reset to -1 when the model is changed.
   * @param column The column of the model to search in, or -1 to disable searching.
   */
  void set_search_column(const TreeModelColumnBase& column);
  
  /** Sets @a column as the column where the interactive search code should
   * search in for the current model. 
   * 
   * If the search column is set, users can use the "start-interactive-search"
   * key binding to bring up search popup. The enable-search property controls
   * whether simply typing text will also start an interactive search.
   * 
   * Note that @a column refers to a column of the current model. The search 
   * column is reset to -1 when the model is changed.
   * @param column The column of the model to search in, or -1 to disable searching.
   */
  void set_search_column(int column);

  ///void on_search_equal(const Glib::RefPtr<TreeModel>& model, int column, const Glib::ustring& key, const TreeModel::iterator& iter)
  typedef sigc::slot<bool, const Glib::RefPtr<TreeModel>&, int, const Glib::ustring&, const TreeModel::iterator&> SlotSearchEqual;
  //SlotSearchEqual get_search_equal_func();
  

  /** Sets the compare function for the interactive search capabilities.
   *
   * @param slot The compare function to use during the search
   */
  void set_search_equal_func(const SlotSearchEqual& slot);
  

  /** Returns the Gtk::Entry which is currently in use as interactive search
   * entry for @a tree_view.  In case the built-in entry is being used, <tt>0</tt>
   * will be returned.
   * 
   * @newin{2,10}
   * @return The entry currently in use as search entry.
   */
  Entry* get_search_entry();
  
  /** Returns the Gtk::Entry which is currently in use as interactive search
   * entry for @a tree_view.  In case the built-in entry is being used, <tt>0</tt>
   * will be returned.
   * 
   * @newin{2,10}
   * @return The entry currently in use as search entry.
   */
  const Entry* get_search_entry() const;
  
  /** Sets the entry which the interactive search code will use for this
   *  @a tree_view.  This is useful when you want to provide a search entry
   * in our interface at all time at a fixed position.  Passing <tt>0</tt> for
   *  @a entry will make the interactive search code use the built-in popup
   * entry again.
   * 
   * @newin{2,10}
   * @param entry The entry the interactive search code of @a tree_view should use or <tt>0</tt>.
   */
  void set_search_entry(Entry& entry);

  ///void on_search_position(Gtk::Widget* search_dialog)
  typedef sigc::slot<void, Gtk::Widget* /* search_dialog */> SlotSearchPosition;
  void set_search_position_func(const SlotSearchPosition& slot);
  

  /** Converts widget coordinates to coordinates for the
   * tree (the full scrollable area of the tree).
   * 
   * @newin{2,12}
   * @param wx X coordinate relative to the widget.
   * @param wy Y coordinate relative to the widget.
   * @param tx Return location for tree X coordinate.
   * @param ty Return location for tree Y coordinate.
   */
  void convert_widget_to_tree_coords(int wx, int wy, int& tx, int& ty) const;
  
  /** Converts tree coordinates (coordinates in full scrollable area of the tree)
   * to widget coordinates.
   * 
   * @newin{2,12}
   * @param tx X coordinate relative to the tree.
   * @param ty Y coordinate relative to the tree.
   * @param wx Return location for widget X coordinate.
   * @param wy Return location for widget Y coordinate.
   */
  void convert_tree_to_widget_coords(int tx, int ty, int& wx, int& wy) const;
  
  /** Converts widget coordinates to coordinates for the bin_window
   * (see get_bin_window()).
   * 
   * @newin{2,12}
   * @param wx X coordinate relative to the widget.
   * @param wy Y coordinate relative to the widget.
   * @param bx Return location for bin_window X coordinate.
   * @param by Return location for bin_window Y coordinate.
   */
  void convert_widget_to_bin_window_coords(int wx, int wy, int& bx, int& by) const;
  
  /** Converts bin_window coordinates (see get_bin_window())
   * to widget relative coordinates.
   * 
   * @newin{2,12}
   * @param bx Bin_window X coordinate.
   * @param by Bin_window Y coordinate.
   * @param wx Return location for widget X coordinate.
   * @param wy Return location for widget Y coordinate.
   */
  void convert_bin_window_to_widget_coords(int bx, int by, int& wx, int& wy) const;
  
  /** Converts tree coordinates (coordinates in full scrollable area of the tree)
   * to bin_window coordinates.
   * 
   * @newin{2,12}
   * @param tx Tree X coordinate.
   * @param ty Tree Y coordinate.
   * @param bx Return location for X coordinate relative to bin_window.
   * @param by Return location for Y coordinate relative to bin_window.
   */
  void convert_tree_to_bin_window_coords(int tx, int ty, int& bx, int& by) const;
  
  /** Converts bin_window coordinates to coordinates for the
   * tree (the full scrollable area of the tree).
   * 
   * @newin{2,12}
   * @param bx X coordinate relative to bin_window.
   * @param by Y coordinate relative to bin_window.
   * @param tx Return location for tree X coordinate.
   * @param ty Return location for tree Y coordinate.
   */
  void convert_bin_window_to_tree_coords(int bx, int by, int& tx, int& ty) const;


  /** Enables or disables the fixed height mode of @a tree_view. 
   * Fixed height mode speeds up Gtk::TreeView by assuming that all 
   * rows have the same height. 
   * Only enable this option if all rows are the same height and all
   * columns are of type Gtk::TREE_VIEW_COLUMN_FIXED.
   * 
   * @newin{2,6}
   * @param enable <tt>true</tt> to enable fixed height mode.
   */
  void set_fixed_height_mode(bool enable =  true);
  
  /** Returns whether fixed height mode is turned on for @a tree_view.
   * 
   * @newin{2,6}
   * @return <tt>true</tt> if @a tree_view is in fixed height mode.
   */
  bool get_fixed_height_mode() const;
  
  /** Enables of disables the hover selection mode of @a tree_view.
   * Hover selection makes the selected row follow the pointer.
   * Currently, this works only for the selection modes 
   * Gtk::SELECTION_SINGLE and Gtk::SELECTION_BROWSE.
   * 
   * @newin{2,6}
   * @param hover <tt>true</tt> to enable hover selection mode.
   */
  void set_hover_selection(bool hover =  true);
  
  /** Returns whether hover selection mode is turned on for @a tree_view.
   * 
   * @newin{2,6}
   * @return <tt>true</tt> if @a tree_view is in hover selection mode.
   */
  bool get_hover_selection() const;
  
  /** Enables of disables the hover expansion mode of @a tree_view.
   * Hover expansion makes rows expand or collapse if the pointer 
   * moves over them.
   * 
   * @newin{2,6}
   * @param expand <tt>true</tt> to enable hover selection mode.
   */
  void set_hover_expand(bool expand =  true);
  
  /** Returns whether hover expansion mode is turned on for @a tree_view.
   * 
   * @newin{2,6}
   * @return <tt>true</tt> if @a tree_view is in hover expansion mode.
   */
  bool get_hover_expand() const;
  
  /** Enables or disables rubber banding in @a tree_view.  If the selection mode
   * is Gtk::SELECTION_MULTIPLE, rubber banding will allow the user to select
   * multiple rows by dragging the mouse.
   * 
   * @newin{2,10}
   * @param enable <tt>true</tt> to enable rubber banding.
   */
  void set_rubber_banding(bool enable =  true);
  
  /** Returns whether rubber banding is turned on for @a tree_view.  If the
   * selection mode is Gtk::SELECTION_MULTIPLE, rubber banding will allow the
   * user to select multiple rows by dragging the mouse.
   * 
   * @newin{2,10}
   * @return <tt>true</tt> if rubber banding in @a tree_view is enabled.
   */
  bool get_rubber_banding() const;

  //TODO: Rename to get_is?
  
  /** Returns whether a rubber banding operation is currently being done
   * in @a tree_view.
   * 
   * @newin{2,12}
   * @return <tt>true</tt> if a rubber banding operation is currently being
   * done in @a tree_view.
   */
  bool is_rubber_banding_active() const;

  /** For instance,
   * void on_row_separator(const Gtk::TreeModel& model, const Gtk::TreeModel::iterator& iter);
   */
  typedef sigc::slot<bool, const Glib::RefPtr<TreeModel>&, const TreeModel::iterator&> SlotRowSeparator;

  void set_row_separator_func(const SlotRowSeparator& slot);
  

  /** Sets which grid lines to draw in @a tree_view.
   * 
   * @newin{2,10}
   * @param grid_lines A Gtk::TreeViewGridLines value indicating which grid lines to
   * enable.
   */
  void set_grid_lines(TreeViewGridLines grid_lines);
  
  /** Returns which grid lines are enabled in @a tree_view.
   * 
   * @newin{2,10}
   * @return A Gtk::TreeViewGridLines value indicating which grid lines
   * are enabled.
   */
  TreeViewGridLines get_grid_lines() const;

  
  /** Sets whether to draw lines interconnecting the expanders in @a tree_view.
   * This does not have any visible effects for lists.
   * 
   * @newin{2,10}
   * @param enabled <tt>true</tt> to enable tree line drawing, <tt>false</tt> otherwise.
   */
  void set_enable_tree_lines(bool enable =  true);
  
  /** Returns whether or not tree lines are drawn in @a tree_view.
   * 
   * @newin{2,10}
   * @return <tt>true</tt> if tree lines are drawn in @a tree_view, <tt>false</tt>
   * otherwise.
   */
  bool get_enable_tree_lines() const;

  
  /** Sets whether to draw and enable expanders and indent child rows in
   *  @a tree_view.  When disabled there will be no expanders visible in trees
   * and there will be no way to expand and collapse rows by default.  Also
   * note that hiding the expanders will disable the default indentation.  You
   * can set a custom indentation in this case using
   * set_level_indentation().
   * This does not have any visible effects for lists.
   * 
   * @newin{2,12}
   * @param enabled <tt>true</tt> to enable expander drawing, <tt>false</tt> otherwise.
   */
  void set_show_expanders(bool enabled =  true);
  
  /** Returns whether or not expanders are drawn in @a tree_view.
   * 
   * @newin{2,12}
   * @return <tt>true</tt> if expanders are drawn in @a tree_view, <tt>false</tt>
   * otherwise.
   */
  bool get_show_expanders() const;
  
  /** Sets the amount of extra indentation for child levels to use in @a tree_view
   * in addition to the default indentation.  The value should be specified in
   * pixels, a value of 0 disables this feature and in this case only the default
   * indentation will be used.
   * This does not have any visible effects for lists.
   * 
   * @newin{2,12}
   * @param indentation The amount, in pixels, of extra indentation in @a tree_view.
   */
  void set_level_indentation(int indentation);
  
  /** Returns the amount, in pixels, of extra indentation for child levels
   * in @a tree_view.
   * 
   * @newin{2,12}
   * @return The amount of extra indentation for child levels in
   *  @a tree_view.  A return value of 0 means that this feature is disabled.
   */
  int get_level_indentation() const;

  
  /** Sets the tip area of tooltip to be the area covered by the row at path.
   * See also set_tooltip_column() for a simpler alternative.
   * 
   * See also Tooltip::set_tip_area().
   * @param path A Gtk::TreePath.
   */
  void set_tooltip_row(const Glib::RefPtr<Tooltip>& tooltip, const TreePath& path);

  //Note that we use pointers instead of references because any one of the 3 arguments may be NULL, and we don't want that many method overloads:
 

  /** Sets the tip area of @a tooltip to the area @a path, @a column and @a cell have
   * in common.  For example if @a path is <tt>0</tt> and @a column is set, the tip
   * area will be set to the full area covered by @a column.  See also
   * Gtk::Tooltip::set_tip_area().
   * 
   * Note that if @a path is not specified and @a cell is set and part of a column
   * containing the expander, the tooltip might not show and hide at the correct
   * position.  In such cases @a path must be set to the current node under the
   * mouse cursor for this function to operate correctly.
   * 
   * See also set_tooltip_column() for a simpler alternative.
   * 
   * @newin{2,12}
   * @param tooltip A Gtk::Tooltip.
   * @param path A Gtk::TreePath or <tt>0</tt>.
   * @param column A Gtk::TreeViewColumn or <tt>0</tt>.
   * @param cell A Gtk::CellRenderer or <tt>0</tt>.
   */
  void set_tooltip_cell(const Glib::RefPtr<Tooltip>& tooltip, const TreeModel::Path* path, TreeViewColumn* column, CellRenderer* cell);

  
  /**
   * @param x: the x coordinate (relative to widget coordinates)
   * @param y: the y coordinate (relative to widget coordinates)
   * @param keyboard_tip: whether this is a keyboard tooltip or not
   * @param path: a reference to receive a Gtk::TreePath
   *
   * This function is supposed to be used in a Gtk::Widget::query-tooltip
   * signal handler for Gtk::TreeView. The x, y and keyboard_tip values
   * which are received in the signal handler, should be passed to this
   * function without modification.
   *
   * The return value indicates whether there is an tree view row at the given
   * coordinates (true) or not (false) for mouse tooltips. For keyboard
   * tooltips the row returned will be the cursor item. When true, then the
   * path which has been provided will be set to point to
   * that row and the corresponding model. x and y will always be converted
   * to be relative to Gtk::TreeView's bin_window if keyboard_tooltip is false.
   *
   * Return value: whether or not the given tooltip context points to a row.
   *
   * @newin{2,12}
   */
  bool get_tooltip_context_path(int& x, int& y,
                                bool keyboard_tip,
                                TreeModel::Path& path);

  /**
   * @param x: the x coordinate (relative to widget coordinates)
   * @param y: the y coordinate (relative to widget coordinates)
   * @param keyboard_tip: whether this is a keyboard tooltip or not
   * @param iter: a pointer to receive a Gtk::TreeIter
   *
   * This function is supposed to be used in a Gtk::Widget::query-tooltip
   * signal handler for Gtk::TreeView. The x, y and keyboard_tip values
   * which are received in the signal handler, should be passed to this
   * function without modification.
   *
   * The return value indicates whether there is an tree view row at the given
   * coordinates (true) or not (false) for mouse tooltips. For keyboard
   * tooltips the row returned will be the cursor item. When true, then the
   * iter which has been provided will be set to point to
   * that row and the corresponding model. x and y will always be converted
   * to be relative to Gtk::TreeView's bin_window if keyboard_tooltip is false.
   *
   * Return value: whether or not the given tooltip context points to a row.
   *
   * @newin{2,12}
   */
  bool get_tooltip_context_iter(int& x, int& y,
                                bool keyboard_tip,
                                Gtk::TreeModel::iterator& iter);

  
  /** If you only plan to have simple (text-only) tooltips on full rows, you
   * can use this function to have Gtk::TreeView handle these automatically
   * for you. @a column should be set to the column in @a tree_view's model
   * containing the tooltip texts, or -1 to disable this feature.
   * 
   * When enabled, Gtk::Widget::has-tooltip will be set to <tt>true</tt> and
   *  @a tree_view will connect a Gtk::Widget::query-tooltip signal handler.
   * 
   * Note that the signal handler sets the text with Gtk::Tooltip::set_markup(),
   * so &, <, etc have to be escaped in the text.
   * 
   * @newin{2,12}
   * @param column An integer, which is a valid column number for @a tree_view's model.
   */
  void set_tooltip_column(int column);
  
  /** Returns the column of @a tree_view's model which is being used for
   * displaying tooltips on @a tree_view's rows.
   * 
   * @newin{2,12}
   * @return The index of the tooltip column that is currently being
   * used, or -1 if this is disabled.
   */
  int get_tooltip_column() const;


  /**
   * @par Prototype:
   * <tt>void on_my_%row_activated(const TreeModel::Path& path, TreeViewColumn* column)</tt>
   */

  Glib::SignalProxy2< void,const TreeModel::Path&,TreeViewColumn* > signal_row_activated();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%test_expand_row(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */

  Glib::SignalProxy2< bool,const TreeModel::iterator&,const TreeModel::Path& > signal_test_expand_row();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%test_collapse_row(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */

  Glib::SignalProxy2< bool,const TreeModel::iterator&,const TreeModel::Path& > signal_test_collapse_row();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%row_expanded(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */

  Glib::SignalProxy2< void,const TreeModel::iterator&,const TreeModel::Path& > signal_row_expanded();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%row_collapsed(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */

  Glib::SignalProxy2< void,const TreeModel::iterator&,const TreeModel::Path& > signal_row_collapsed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%cursor_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_cursor_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%columns_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_columns_changed();


  //Don't wrap these. They are keybinding signals, and their API broke for GTK+ 2.2.
  
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The model for the tree view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<TreeModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The model for the tree view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TreeModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Show the column header buttons.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_headers_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Show the column header buttons.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_headers_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Column headers respond to click events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_headers_clickable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Column headers respond to click events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_headers_clickable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the column for the expander column.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TreeViewColumn*> property_expander_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the column for the expander column.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TreeViewColumn*> property_expander_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** View is reorderable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_reorderable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** View is reorderable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_reorderable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set a hint to the theme engine to draw rows in alternating colors.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_rules_hint() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set a hint to the theme engine to draw rows in alternating colors.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_rules_hint() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** View allows user to search through columns interactively.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enable_search() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** View allows user to search through columns interactively.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enable_search() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Model column to search through during interactive search.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_search_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Model column to search through during interactive search.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_search_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Speeds up GtkTreeView by assuming that all rows have the same height.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fixed_height_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Speeds up GtkTreeView by assuming that all rows have the same height.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fixed_height_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the selection should follow the pointer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_hover_selection() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the selection should follow the pointer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_hover_selection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether rows should be expanded/collapsed when the pointer moves over them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_hover_expand() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether rows should be expanded/collapsed when the pointer moves over them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_hover_expand() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** View has expanders.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_expanders() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** View has expanders.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_expanders() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Extra indentation for each level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_level_indentation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Extra indentation for each level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_level_indentation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable selection of multiple items by dragging the mouse pointer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_rubber_banding() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable selection of multiple items by dragging the mouse pointer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_rubber_banding() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether grid lines should be drawn in the tree view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enable_grid_lines() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether grid lines should be drawn in the tree view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enable_grid_lines() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether tree lines should be drawn in the tree view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enable_tree_lines() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether tree lines should be drawn in the tree view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enable_tree_lines() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The column in the model containing the tooltip texts for the rows.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_tooltip_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The column in the model containing the tooltip texts for the rows.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_tooltip_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  template<class ColumnType> friend
  void _auto_store_on_cellrenderer_text_edited_string(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);

  template <class ColumnType> friend
  void _auto_store_on_cellrenderer_text_edited_numerical(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);

  void _auto_store_on_cellrenderer_toggle_edited_with_model(const Glib::ustring& path_string, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);

  // This is no longer used, but we must keep it to prevent linker errors with already-compiled applications,
  // For instance, applications that were compiled with the older versions of the templates that did use this method.
  // TODO: Remove this when we can break API.
  void _auto_store_on_cellrenderer_toggle_edited(const Glib::ustring& path_string, int model_column);

  template<class ColumnType> friend
  void TreeView_Private::_connect_auto_store_editable_signal_handler(TreeView*, CellRenderer*, const TreeModelColumn<ColumnType>&);

#endif //DOXYGEN_SHOULD_SKIP_THIS


};


template <class ColumnType> inline
int TreeView::append_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column)
{
  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

  return append_column(*pViewColumn);
}

//This is here because sigc::bind once did not work on all platforms, but now it does..
#define GTKMM_HAVE_SIGC_BIND 1

#ifdef GTKMM_HAVE_SIGC_BIND

template <class ColumnType> inline
int TreeView::append_column_numeric(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, const Glib::ustring& format)
{
  TreeViewColumn* const pViewColumn = Gtk::manage( new TreeViewColumn(title) );

  //Use a CellRendererText:
  //We don't use TreeView::Column::append_column(model_column) to generate an appropriate CellRenderer,
  //because that uses set_renderer(), which renders the model value using the automatic glib "transformations" (number-string conversions). As well as being unnecessary here, those automatic conversions can't handle all numeric types.
  CellRenderer* pCellRenderer = manage( new CellRendererText() );
  pViewColumn->pack_start(*pCellRenderer);


  //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
  typedef void (*type_fptr)(Gtk::CellRenderer* cell, const Gtk::TreeModel::iterator& iter, int model_column, const Glib::ustring& format);
  type_fptr fptr = TreeView_Private::_auto_cell_data_func<ColumnType>;

  //Connect a cell_data callback, to show the number's text representation in the specified format:
  //We use sigc::bind<-1> twice here, instead of sigc::bind() once, because some compilers need the extra hint.
  Gtk::TreeViewColumn::SlotCellData slot = sigc::bind<-1>(
    sigc::bind<-1>( sigc::ptr_fun(fptr), format),
    model_column.index()
  );

  pViewColumn->set_cell_data_func(*pCellRenderer, slot);

  return append_column(*pViewColumn);
}

#endif //GTKMM_HAVE_SIGC_BIND

template <class ColumnType> inline
int TreeView::append_column_numeric_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, const Glib::ustring& format)
{
  int cols_count = append_column_numeric(title, model_column, format);

  //connect signal handlers for auto-storing of edited cell data
  //Note: This will only work for base-10 (decimal) formatted numbers:
  CellRenderer *const cell = get_column_cell_renderer(cols_count - 1);
  if(cell)
  {
    TreeView_Private::_connect_auto_store_editable_signal_handler<ColumnType>(this, cell, model_column);
  }

  return cols_count;
}

template <class ColumnType> inline
int TreeView::append_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column)
{
  //Don't use this in a header, because it gives warnings when disabled: g_assert(model_column.type() != 0);

  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

  //connect signal handlers for auto-storing of edited cell data
  CellRenderer* pCellRender = pViewColumn->get_first_cell();
  TreeView_Private::_connect_auto_store_editable_signal_handler<ColumnType>(this, pCellRender, model_column);

  return append_column(*pViewColumn);
}

template <class ColumnType> inline
int TreeView::insert_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position)
{
  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

  return insert_column(*pViewColumn, position);
}

template <class ColumnType> inline
int TreeView::insert_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position)
{
  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

   //connect signal handlers for auto-storing of edited cell data
  CellRenderer* pCellRender = pViewColumn->get_first_cell();
  TreeView_Private::_connect_auto_store_editable_signal_handler(this, pCellRender, model_column);

  return insert_column(*pViewColumn, position);
}


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace TreeView_Private
{

//Template specializations, for different model column types:
//TODO: Move these specializations into the .ccg file - I tried, but the int specialization was not used by the compiler. murrayc.

#ifdef GTKMM_HAVE_SIGC_BIND

//bool specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<bool>& model_column)
{
  Gtk::CellRendererToggle* pCellToggle = dynamic_cast<Gtk::CellRendererToggle*>(pCellRenderer);
  if(pCellToggle)
  {
    //Set the appropriate property,
    pCellToggle->property_activatable() = true;

    //Connect to the appropriate signal, sending the model_column too

    sigc::slot<void, const Glib::ustring&, int> slot_temp =
      sigc::bind<-1>(
        sigc::mem_fun(*this_p, &Gtk::TreeView::_auto_store_on_cellrenderer_toggle_edited_with_model),
        this_p->get_model()
      );

    pCellToggle->signal_toggled().connect(
      sigc::bind<-1>(
        slot_temp,
        model_column.index()
      )
    );

    //We use bind<1> instead of bind because some compilers need the extra hint.
  }
}

//int specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<int>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_fptr)(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);
    type_fptr fptr = _auto_store_on_cellrenderer_text_edited_numerical<int>;

    //Connect to the appropriate signal, sending the model_column too,
    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>(
          sigc::ptr_fun(fptr),
          this_p->get_model() ),
        model_column.index()
      )
    );

  }
}

//unsigned int specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<unsigned int>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_fptr)(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);
    type_fptr fptr = _auto_store_on_cellrenderer_text_edited_numerical<unsigned int>;

    //Connect to the appropriate signal, sending the model_column too,
    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>(
          sigc::ptr_fun(fptr),
          this_p->get_model() ),
        model_column.index()
      )
    );

  }
}

//long specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<long>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_fptr)(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);
    type_fptr fptr = _auto_store_on_cellrenderer_text_edited_numerical<long>;

    //Connect to the appropriate signal, sending the model_column too,
    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>(
          sigc::ptr_fun(fptr),
          this_p->get_model() ),
        model_column.index()
      )
    );

  }
}

//unsigned long specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<unsigned long>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_fptr)(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);
    type_fptr fptr = _auto_store_on_cellrenderer_text_edited_numerical<unsigned long>;

    //Connect to the appropriate signal, sending the model_column too,
    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>(
          sigc::ptr_fun(fptr),
          this_p->get_model() ),
        model_column.index()
      )
    );

  }
}

//float specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<float>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_fptr)(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);
    type_fptr fptr = _auto_store_on_cellrenderer_text_edited_numerical<float>;

    //Connect to the appropriate signal, sending the model_column too,
    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>(
          sigc::ptr_fun(fptr),
          this_p->get_model() ),
        model_column.index()
      )
    );
  }
}

//double specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<double>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Some compilers don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_fptr)(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model);
    type_fptr fptr = _auto_store_on_cellrenderer_text_edited_numerical<double>;

    //Connect to the appropriate signal, sending the model_column too,
    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>(
          sigc::ptr_fun(fptr),
          this_p->get_model() ),
        model_column.index()
      )
    );
  }
}

#endif //GTKMM_HAVE_SIGC_BIND

} // namespace TreeView_Private
#endif //DOXYGEN_SHOULD_SKIP_THIS


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace TreeView_Private
{

#ifdef GTKMM_HAVE_SIGC_BIND

template <class ColumnType> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<ColumnType>& model_column)
{
  //Don't use this in a header, because it gives warnings when disabled: g_assert(model_column.type() != 0);

  //The different CellRenderers have different "edited" signals,
  //and numerical values need to convert the text value to a number,
  //so there are specializations for this tempate.

  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);

  //Set the appropriate property,
  //and connect to the appropriate signal, sending the model_column too,
  if(pCellText)
  {
    pCellText->property_editable() = true;

    //Some compilers (IRIX MipsPro) don't like us to give the pointer to a template function directly to sigc::ptr_fun():
    typedef void (*type_func)(const Glib::ustring&, const Glib::ustring&, int, const Glib::RefPtr<Gtk::TreeModel>&);
    type_func func = &(_auto_store_on_cellrenderer_text_edited_string<ColumnType>);
    sigc::slot<void, const Glib::ustring&, const Glib::ustring&, int, const Glib::RefPtr<Gtk::TreeModel>&> theslot  =
      sigc::ptr_fun(func);

    //We use bind<-1> twice here, instead of using bind() once, because some compilers need the extra hint.
    pCellText->signal_edited().connect(
      sigc::bind<-1>(
        sigc::bind<-1>( theslot, this_p->get_model()),
        model_column.index()
      )
    );
  }
}

#endif //GTKMM_HAVE_SIGC_BIND

template <class ColumnType> inline
void _auto_store_on_cellrenderer_text_edited_string(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model)
{
  Gtk::TreePath path(path_string);

  //Get the row from the path:
  if(model)
  {
    Gtk::TreeModel::iterator iter = model->get_iter(path);
    if(iter)
    {
        //Store the user's new text in the model:
        Gtk::TreeRow row = *iter;
        row.set_value(model_column, (ColumnType)new_text);
    }
  }
}

template <class ColumnType> inline
void _auto_store_on_cellrenderer_text_edited_numerical(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, const Glib::RefPtr<Gtk::TreeModel>& model)
{
  //This is used on numerical model columns:

  Gtk::TreePath path(path_string);

  //Get the row from the path:
  if(model)
  {
    Gtk::TreeModel::iterator iter = model->get_iter(path);
    if(iter)
    {
      //std::istringstream astream(new_text); //Put it in a stream.
      //ColumnType new_value = ColumnType();
      //new_value << astream; //Get it out of the stream as the numerical type.

      //Convert the text to a number, using the same logic used by GtkCellRendererText when it stores numbers.
      char* pchEnd = 0;
      ColumnType new_value = static_cast<ColumnType>( strtod(new_text.c_str(), &pchEnd) );

      //Store the user's new text in the model:
      Gtk::TreeRow row = *iter;
      row.set_value(model_column, (ColumnType)new_value);
    }
  }
}

template <class ColumnType> inline
void _auto_cell_data_func(Gtk::CellRenderer* cell, const Gtk::TreeModel::iterator& iter, int model_column, const Glib::ustring& format)
{
  Gtk::CellRendererText* pTextRenderer = dynamic_cast<Gtk::CellRendererText*>(cell);
  if(!pTextRenderer)
  {
    g_warning("gtkmm: TextView: append_column_numeric() was used with a non-numeric type.");
  }
  else
  {
    if(iter)
    {
      //Get the value from the model.
      Gtk::TreeModel::Row row = *iter;
      ColumnType value = ColumnType();
      row.get_value(model_column, value);

      //Convert it to a string representation:
      char buff[20];
      int used = g_snprintf(buff, sizeof(buff), format.c_str(), value); //value must be a numeric type.
      if(used > 0)
      {
        //Show the text representation in the view:
        pTextRenderer->property_text() = buff;
      }
    }
  }
}

} // namespace TreeView_Private
#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TreeView
   */
  Gtk::TreeView* wrap(GtkTreeView* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TREEVIEW_H */

