// Generated by gmmproc 2.47.6 -- DO NOT MODIFY!
#ifndef _GTKMM_BUTTONBOX_H
#define _GTKMM_BUTTONBOX_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkButtonBox GtkButtonBox;
typedef struct _GtkButtonBoxClass GtkButtonBoxClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class ButtonBox_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

// This is a #define in GTK+, and unrelated to the GtkButtonBoxStyle enum.
/** @ingroup gtkmmEnums */
enum { BUTTONBOX_DEFAULT_SPACING = -1 };


/** A container for arranging buttons.
 *
 * A button box should be used to provide a consistent layout of buttons
 * throughout your application. The layout/spacing can be altered by the
 * programmer, or if desired, by the user to alter the 'feel' of a
 * program to a small degree.
 *
 * get_layout() et_layout() retrieve and
 * alter the method used to spread the buttons in a button box across the
 * container, respectively.
 *
 * The main purpose of ButtonBox is to make sure the children have all the
 * same size. ButtonBox gives all children the same size, but it does allow
 * 'outliers' to keep their own larger size. To force all children to be
 * strictly the same size without exceptions, you can set the
 * homogeneous property to true.
 *
 * To excempt individual children from homogeneous sizing regardless of their
 * 'outlier' status, you can set the non-homogeneous child
 * property.
 */

class ButtonBox
  : public Box
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ButtonBox CppObjectType;
  typedef ButtonBox_Class CppClassType;
  typedef GtkButtonBox BaseObjectType;
  typedef GtkButtonBoxClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ButtonBox(ButtonBox&& src) noexcept;
  ButtonBox& operator=(ButtonBox&& src) noexcept;

  // noncopyable
  ButtonBox(const ButtonBox&) = delete;
  ButtonBox& operator=(const ButtonBox&) = delete;

  ~ButtonBox() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ButtonBox_Class;
  static CppClassType buttonbox_class_;

protected:
  explicit ButtonBox(const Glib::ConstructParams& construct_params);
  explicit ButtonBox(GtkButtonBox* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkButtonBox*       gobj()       { return reinterpret_cast<GtkButtonBox*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkButtonBox* gobj() const { return reinterpret_cast<GtkButtonBox*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  //Note that we try to use the same defaul parameter value as the default property value.
    explicit ButtonBox(Orientation orientation =  ORIENTATION_HORIZONTAL);


  /** Retrieves the method being used to arrange the buttons in a button box.
   * 
   * @return The method used to lay out buttons in @a widget.
   */
  ButtonBoxStyle get_layout() const;
  
  /** Changes the way buttons are arranged in their container.
   * 
   * @param layout_style The new layout style.
   */
  void set_layout(ButtonBoxStyle layout_style);

  
  /** Sets whether @a child should appear in a secondary group of children.
   * A typical use of a secondary child is the help button in a dialog.
   * 
   * This group appears after the other children if the style
   * is Gtk::BUTTONBOX_START, Gtk::BUTTONBOX_SPREAD or
   * Gtk::BUTTONBOX_EDGE, and before the other children if the style
   * is Gtk::BUTTONBOX_END. For horizontal button boxes, the definition
   * of before/after depends on direction of the widget (see
   * Gtk::Widget::set_direction()). If the style is Gtk::BUTTONBOX_START
   * or Gtk::BUTTONBOX_END, then the secondary children are aligned at
   * the other end of the button box from the main children. For the
   * other styles, they appear immediately next to the main children.
   * 
   * @param child A child of @a widget.
   * @param is_secondary If <tt>true</tt>, the @a child appears in a secondary group of the
   * button box.
   */
  void set_child_secondary(Widget& child, bool is_secondary =  true);
  
  /** Returns whether @a child should appear in a secondary group of children.
   * 
   * @newin{2,4}
   * 
   * @param child A child of @a widget.
   * @return Whether @a child should appear in a secondary group of children.
   */
  bool get_child_secondary(const Gtk::Widget& child) const;

  
  /** Returns whether the child is exempted from homogenous
   * sizing.
   * 
   * @newin{3,2}
   * 
   * @param child A child of @a widget.
   * @return <tt>true</tt> if the child is not subject to homogenous sizing.
   */
  bool get_child_non_homogeneous(const Gtk::Widget& child) const;

  
  /** Sets whether the child is exempted from homogeous sizing.
   * 
   * @newin{3,2}
   * 
   * @param child A child of @a widget.
   * @param non_homogeneous The new value.
   */
  void set_child_non_homogeneous(Gtk::Widget& child, bool non_homogeneous =  true);

  /** How to lay out the buttons in the box. Possible values are: spread, edge, start and end.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ButtonBoxStyle > property_layout_style() ;

/** How to lay out the buttons in the box. Possible values are: spread, edge, start and end.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ButtonBoxStyle > property_layout_style() const;


};

} // namespace Gtk

//Include the deprecated header,
//whose classes were previously in this header,
//to preserve the "API" of the includes.
#include <gtkmm/hvbuttonbox.h>


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ButtonBox
   */
  Gtk::ButtonBox* wrap(GtkButtonBox* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_BUTTONBOX_H */

