// Generated by gmmproc 2.47.3.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/scale.h>
#include <gtkmm/private/scale_p.h>


/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/adjustment.h>

#include <gtk/gtk.h>
#include <math.h>
#include <cstring> //For strlen()
#include <memory>

using std::strlen;

namespace Gtk
{

Scale::Scale(Orientation orientation)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Range(Glib::ConstructParams(scale_class_.init(), "orientation",(GtkOrientation)(orientation), nullptr))
{
}

Scale::Scale(const Glib::RefPtr<Adjustment>& adjustment, Orientation orientation)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Range(Glib::ConstructParams(scale_class_.init(), "adjustment",Glib::unwrap(adjustment),"orientation",(GtkOrientation)(orientation), nullptr))
{
}

int Scale::calc_digits_(double step) const
{
  int digits = 0;

  //Copied from gtk_[h|v]scale_new_with_range():
  if (fabs (step) >= 1.0 || step == 0.0)
     digits = 0;
  else {
    digits = abs ((int) floor (log10 (fabs (step))));
    if (digits > 5)
      digits = 5;
  }

  return digits;
}

} // namespace Gtk

namespace
{


static gchar* Scale_signal_format_value_callback(GtkScale* self, gdouble p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< Glib::ustring,double > SlotType;

  auto obj = dynamic_cast<Scale*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return (strlen((*static_cast<SlotType*>(slot))(p0
).c_str()) ? g_strdup((*static_cast<SlotType*>(slot))(p0
).c_str()) : nullptr);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  typedef gchar* RType;
  return RType();
}

static gchar* Scale_signal_format_value_notify_callback(GtkScale* self, gdouble p0, void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,double > SlotType;

  auto obj = dynamic_cast<Scale*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gchar* RType;
  return RType();
}

static const Glib::SignalProxyInfo Scale_signal_format_value_info =
{
  "format_value",
  (GCallback) &Scale_signal_format_value_callback,
  (GCallback) &Scale_signal_format_value_notify_callback
};


} // anonymous namespace


namespace Glib
{

Gtk::Scale* wrap(GtkScale* object, bool take_copy)
{
  return dynamic_cast<Gtk::Scale *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Scale_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Scale_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_scale_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Scale_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->draw_value = &draw_value_vfunc_callback;

  klass->format_value = &format_value_callback;
}

void Scale_Class::draw_value_vfunc_callback(GtkScale* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->draw_value_vfunc();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->draw_value)
  {
    (*base->draw_value)(self);
  }

}

gchar* Scale_Class::format_value_callback(GtkScale* self, gdouble p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return (strlen(obj->on_format_value(p0
).c_str()) ? g_strdup(obj->on_format_value(p0
).c_str()) : nullptr);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->format_value)
    return (*base->format_value)(self, p0);

  typedef gchar* RType;
  return RType();
}


Glib::ObjectBase* Scale_Class::wrap_new(GObject* o)
{
  return manage(new Scale((GtkScale*)(o)));

}


/* The implementation: */

Scale::Scale(const Glib::ConstructParams& construct_params)
:
  Gtk::Range(construct_params)
{
  }

Scale::Scale(GtkScale* castitem)
:
  Gtk::Range((GtkRange*)(castitem))
{
  }


Scale::Scale(Scale&& src) noexcept
: Gtk::Range(std::move(src))
{}

Scale& Scale::operator=(Scale&& src) noexcept
{
  Gtk::Range::operator=(std::move(src));
  return *this;
}

Scale::~Scale() noexcept
{
  destroy_();
}

Scale::CppClassType Scale::scale_class_; // initialize static member

GType Scale::get_type()
{
  return scale_class_.init().get_type();
}


GType Scale::get_base_type()
{
  return gtk_scale_get_type();
}


Scale::Scale()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Range(Glib::ConstructParams(scale_class_.init()))
{
  

}

void Scale::set_digits(int digits)
{
  gtk_scale_set_digits(gobj(), digits);
}

int Scale::get_digits() const
{
  return gtk_scale_get_digits(const_cast<GtkScale*>(gobj()));
}

void Scale::set_draw_value(bool draw_value)
{
  gtk_scale_set_draw_value(gobj(), static_cast<int>(draw_value));
}

bool Scale::get_draw_value() const
{
  return gtk_scale_get_draw_value(const_cast<GtkScale*>(gobj()));
}

void Scale::set_value_pos(PositionType pos)
{
  gtk_scale_set_value_pos(gobj(), ((GtkPositionType)(pos)));
}

PositionType Scale::get_value_pos() const
{
  return ((PositionType)(gtk_scale_get_value_pos(const_cast<GtkScale*>(gobj()))));
}

void Scale::set_has_origin(bool has_origin)
{
  gtk_scale_set_has_origin(gobj(), static_cast<int>(has_origin));
}

bool Scale::get_has_origin() const
{
  return gtk_scale_get_has_origin(const_cast<GtkScale*>(gobj()));
}

Glib::RefPtr<Pango::Layout> Scale::get_layout()
{
  Glib::RefPtr<Pango::Layout> retvalue = Glib::wrap(gtk_scale_get_layout(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Pango::Layout> Scale::get_layout() const
{
  return const_cast<Scale*>(this)->get_layout();
}

void Scale::get_layout_offsets(int& x, int& y) const
{
  gtk_scale_get_layout_offsets(const_cast<GtkScale*>(gobj()), &(x), &(y));
}

void Scale::add_mark(double value, PositionType position, const Glib::ustring& markup)
{
  gtk_scale_add_mark(gobj(), value, ((GtkPositionType)(position)), markup.c_str());
}

void Scale::clear_marks()
{
  gtk_scale_clear_marks(gobj());
}


Glib::SignalProxy1< Glib::ustring,double > Scale::signal_format_value()
{
  return Glib::SignalProxy1< Glib::ustring,double >(this, &Scale_signal_format_value_info);
}


Glib::PropertyProxy< int > Scale::property_digits() 
{
  return Glib::PropertyProxy< int >(this, "digits");
}

Glib::PropertyProxy_ReadOnly< int > Scale::property_digits() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "digits");
}

Glib::PropertyProxy< bool > Scale::property_draw_value() 
{
  return Glib::PropertyProxy< bool >(this, "draw-value");
}

Glib::PropertyProxy_ReadOnly< bool > Scale::property_draw_value() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "draw-value");
}

Glib::PropertyProxy< PositionType > Scale::property_value_pos() 
{
  return Glib::PropertyProxy< PositionType >(this, "value-pos");
}

Glib::PropertyProxy_ReadOnly< PositionType > Scale::property_value_pos() const
{
  return Glib::PropertyProxy_ReadOnly< PositionType >(this, "value-pos");
}

Glib::PropertyProxy< bool > Scale::property_has_origin() 
{
  return Glib::PropertyProxy< bool >(this, "has-origin");
}

Glib::PropertyProxy_ReadOnly< bool > Scale::property_has_origin() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-origin");
}


Glib::ustring Gtk::Scale::on_format_value(double value)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->format_value)
    return Glib::convert_const_gchar_ptr_to_ustring((*base->format_value)(gobj(),value));

  typedef Glib::ustring RType;
  return RType();
}

void Gtk::Scale::draw_value_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_value)
  {
    (*base->draw_value)(gobj());
  }
}


} // namespace Gtk


