// Generated by gmmproc 2.49.2 -- DO NOT MODIFY!
#ifndef _GTKMM_APPCHOOSERBUTTON_H
#define _GTKMM_APPCHOOSERBUTTON_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2011 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/appchooser.h>
#include <gtkmm/combobox.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkAppChooserButton = struct _GtkAppChooserButton;
using GtkAppChooserButtonClass = struct _GtkAppChooserButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class AppChooserButton_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A button to launch an application chooser dialog.
 *
 * This widget lets the user select an application. See the AppChooser base class API.
 *
 * Initially, an AppChooserButton selects the first application
 * in its list, which will either be the most-recently used application
 * or, if property_show_default_item() is <tt>true</tt>, the
 * default application.
 *
 * The list of applications shown in an AppChooserButton includes
 * the recommended applications for the given content type. When
 * property_show_default_item() is set, the default application
 * is also included. To let the user choose other applications,
 * you can set property_show_dialog_item(),
 * which allows to open a full AppChooserDialog.
 *
 * It is possible to add custom items to the list, using append_custom_item().
 * These items cause signal_custom_item_activated() to be
 * emitted when they are selected.
 *
 * To track changes in the selected application, use ComboBox::signal_changed().
 *
 * The AppChooserButton widget looks like this:
 * @image html appchooserbutton1.png
 *
 * @ingroup Widgets
 *
 * @newin{3,0}
 */

class AppChooserButton
  : public ComboBox,
    public AppChooser
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AppChooserButton CppObjectType;
  typedef AppChooserButton_Class CppClassType;
  typedef GtkAppChooserButton BaseObjectType;
  typedef GtkAppChooserButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  AppChooserButton(AppChooserButton&& src) noexcept;
  AppChooserButton& operator=(AppChooserButton&& src) noexcept;

  // noncopyable
  AppChooserButton(const AppChooserButton&) = delete;
  AppChooserButton& operator=(const AppChooserButton&) = delete;

  ~AppChooserButton() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AppChooserButton_Class;
  static CppClassType appchooserbutton_class_;

protected:
  explicit AppChooserButton(const Glib::ConstructParams& construct_params);
  explicit AppChooserButton(GtkAppChooserButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkAppChooserButton*       gobj()       { return reinterpret_cast<GtkAppChooserButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkAppChooserButton* gobj() const { return reinterpret_cast<GtkAppChooserButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_custom_item_activated().
  virtual void on_custom_item_activated(const Glib::ustring& item_name);


private:

  
public:

  /** Creates a new app-chooser button for applications that can handle content of the given type.
   *
   * See @ref giommContentType in glibmm for more information about content types.
   *
   * @param content_type The content type to show applications for
   */
    explicit AppChooserButton(const Glib::ustring& content_type);


  /** Appends a separator to the list of applications that is shown
   * in the popup.
   * 
   * @newin{3,0}
   */
  void append_separator();
  
  /** Appends a custom item to the list of applications that is shown
   * in the popup; the item name must be unique per-widget.
   * Clients can use the provided name as a detail for the
   * Gtk::AppChooserButton::signal_custom_item_activated() signal, to add a
   * callback for the activation of a particular custom item in the list.
   * See also append_separator().
   * 
   * @newin{3,0}
   * 
   * @param name The name of the custom item.
   * @param label The label for the custom item.
   * @param icon The icon for the custom item.
   */
  void append_custom_item(const Glib::ustring& name, const Glib::ustring& label, const Glib::RefPtr<Gio::Icon>& icon);
  
  /** Selects a custom item previously added with
   * append_custom_item().
   * 
   * Use refresh() to bring the selection
   * to its initial state.
   * 
   * @newin{3,0}
   * 
   * @param name The name of the custom item.
   */
  void set_active_custom_item(const Glib::ustring& name);
  
  /** Sets whether the dropdown menu of this button should show an
   * entry to trigger a Gtk::AppChooserDialog.
   * 
   * @newin{3,0}
   * 
   * @param setting The new value for Gtk::AppChooserButton::property_show_dialog_item().
   */
  void set_show_dialog_item(bool setting =  true);
  
  /** Returns the current value of the Gtk::AppChooserButton::property_show_dialog_item()
   * property.
   * 
   * @newin{3,0}
   * 
   * @return The value of Gtk::AppChooserButton::property_show_dialog_item().
   */
  bool get_show_dialog_item() const;
  
  /** Sets the text to display at the top of the dialog.
   * If the heading is not set, the dialog displays a default text.
   * 
   * @param heading A string containing Pango markup.
   */
  void set_heading(const Glib::ustring& heading);
  
  /** Returns the text to display at the top of the dialog.
   * 
   * @return The text to display at the top of the dialog,
   * or <tt>nullptr</tt>, in which case a default text is displayed.
   */
  Glib::ustring get_heading() const;
  
  /** Sets whether the dropdown menu of this button should show the
   * default application for the given content type at top.
   * 
   * @newin{3,2}
   * 
   * @param setting The new value for Gtk::AppChooserButton::property_show_default_item().
   */
  void set_show_default_item(bool setting =  true);
  
  /** Returns the current value of the Gtk::AppChooserButton::property_show_default_item()
   * property.
   * 
   * @newin{3,2}
   * 
   * @return The value of Gtk::AppChooserButton::property_show_default_item().
   */
  bool get_show_default_item() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%custom_item_activated(const Glib::ustring& item_name)</tt>
   *
   * Emitted when a custom item, previously added with
   * Gtk::AppChooserButton::append_custom_item(), is activated from the
   * dropdown menu.
   * 
   * @param item_name The name of the activated item.
   */

  Glib::SignalProxy< void,const Glib::ustring& > signal_custom_item_activated();


  /** The Gtk::AppChooserButton::property_show_dialog_item() property determines
   * whether the dropdown menu should show an item that triggers
   * a Gtk::AppChooserDialog when clicked.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_dialog_item() ;

/** The Gtk::AppChooserButton::property_show_dialog_item() property determines
   * whether the dropdown menu should show an item that triggers
   * a Gtk::AppChooserDialog when clicked.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_dialog_item() const;

  /** The text to show at the top of the dialog that can be
   * opened from the button. The string may contain Pango markup.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_heading() ;

/** The text to show at the top of the dialog that can be
   * opened from the button. The string may contain Pango markup.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_heading() const;

  /** The Gtk::AppChooserButton::property_show_default_item() property determines
   * whether the dropdown menu should show the default application
   * on top for the provided content type.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_default_item() ;

/** The Gtk::AppChooserButton::property_show_default_item() property determines
   * whether the dropdown menu should show the default application
   * on top for the provided content type.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_default_item() const;


};


} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::AppChooserButton
   */
  Gtk::AppChooserButton* wrap(GtkAppChooserButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_APPCHOOSERBUTTON_H */

