// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/application.h>
#include <gtkmm/private/application_p.h>


// -*- c++ -*-
/* $Id: action.ccg,v 1.11 2006/05/10 20:59:27 murrayc Exp $ */

/* Copyright 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/vectorutils.h>

#include <gtk/gtk.h>
#include <gtkmm/window.h>
#include <glibmm/init.h>
#include <giomm/init.h>
#include <pangomm/wrap_init.h>
#ifdef GTKMM_ATKMM_ENABLED
#include <atkmm/wrap_init.h>
#endif //GTKMM_ATKMM_ENABLED
#include <gdkmm/wrap_init.h>
#include <gtkmm/wrap_init.h>

namespace
{

static void init_gtkmm_internals()
{
  static bool init_done = false;

  if(!init_done)
  {
    Glib::init();
    Gio::init();

    // Populate the map of GTypes to C++ wrap_new() functions.
    Pango::wrap_init();
#ifdef GTKMM_ATKMM_ENABLED
    Atk::wrap_init();
#endif //GTKMM_ATKMM_ENABLED
    Gdk::wrap_init();
    Gtk::wrap_init();

    init_done = true;
  }
}

} // anonymous namespace

namespace Gtk
{

const Glib::Class& Application::custom_class_init()
{
  init_gtkmm_internals();
  return application_class_.init();
}

Application::Application(const Glib::ustring& application_id, Gio::ApplicationFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gio::Application(Glib::ConstructParams(custom_class_init(), "application_id", application_id.c_str(), "flags", GApplicationFlags(flags), static_cast<char*>(0))),
  m_main_window(0),
  m_argc(0),
  m_argv(0)
{
}

Application::Application(int& argc, char**& argv, const Glib::ustring& application_id, Gio::ApplicationFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gio::Application(Glib::ConstructParams(custom_class_init(), "application_id", application_id.c_str(), "flags", GApplicationFlags(flags), static_cast<char*>(0))),
  m_main_window(0),
  m_argc(argc),
  m_argv(argv)
{
  gtk_init(&argc, &argv);
}

Glib::RefPtr<Application> Application::create(const Glib::ustring& application_id, Gio::ApplicationFlags flags)
{
  return Glib::RefPtr<Application>( new Application(application_id, flags) );
}

Glib::RefPtr<Application> Application::create(int& argc, char**& argv, const Glib::ustring& application_id, Gio::ApplicationFlags flags)
{
  return Glib::RefPtr<Application>( new Application(argc, argv, application_id, flags) );
}

void Application::on_activate_showwindow()
{
  if(m_main_window)
    m_main_window->show();
  
  m_main_window = 0; //We don't need to remember this anymore.
}

void Application::on_window_hide(Window* window)
{
  //Tell GtkApplication to forget the window.
  //This can cause run() to return, if it is the last window.
  //Otherwise, GtkApplication waits for the window to be _destroyed_,
  //which is just not something that it should care about:
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639931
  if(window && window->get_application()) //We check that it's still in an application anyway.
    remove_window(*window);
}

void Application::add_window(Window& window)
{
  //Respond to window hiding, not destruction:
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639931
  window.signal_hide().connect(
    sigc::bind(
      sigc::mem_fun(*this, &Application::on_window_hide),
      &window));
    
  gtk_application_add_window(gobj(), (window).gobj()); 
}

int Application::run(int argc, char** argv)
{
  return Gio::Application::run(argc, argv);
}

int Application::run(Window& window, int argc, char** argv)
{
  add_window(window);
  
  //Show the window when the application starts.
  //We could just call show() now,
  //but GApplication currently warns if we don't connect to the activate signal,
  //which seems very C-centric. See https://bugzilla.gnome.org/show_bug.cgi?id=640042
  m_main_window = &window;
  signal_activate().connect(
    sigc::mem_fun(*this, &Application::on_activate_showwindow));

  const int result = Gio::Application::run(argc, argv);
  init_gtkmm_internals(); //TODO: This is too late. We want to do this as soon as possible, but it can't be done before gtk_init(argc, argv).
  return result;
}

int Application::run(Window& window)
{
  g_assert(m_argc);
  g_assert(m_argv);

  add_window(window);
  
  //Show the window when the application starts.
  //We could just call show() now,
  //but GApplication currently warns if we don't connect to the activate signal,
  //which seems very C-centric. See https://bugzilla.gnome.org/show_bug.cgi?id=640042
  m_main_window = &window;
  signal_activate().connect(
    sigc::mem_fun(*this, &Application::on_activate_showwindow));

  const int result = Gio::Application::run(m_argc, m_argv);
  init_gtkmm_internals();  //TODO: This is too late. We want to do this as soon as possible, but it can't be done before gtk_init(argc, argv).
  return result;
}

int Application::run()
{
  g_assert(m_argc);
  g_assert(m_argv);

  const int result = Gio::Application::run(m_argc, m_argv);
  init_gtkmm_internals();  //TODO: This is too late. We want to do this as soon as possible, but it can't be done before gtk_init(argc, argv).
  return result;
}


} // namespace Gtk

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::Application> wrap(GtkApplication* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::Application>( dynamic_cast<Gtk::Application*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Application_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Application_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_application_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Application_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Application_Class::wrap_new(GObject* object)
{
  return new Application((GtkApplication*)object);
}


/* The implementation: */

GtkApplication* Application::gobj_copy()
{
  reference();
  return gobj();
}

Application::Application(const Glib::ConstructParams& construct_params)
:
  Gio::Application(construct_params)
{

}

Application::Application(GtkApplication* castitem)
:
  Gio::Application((GApplication*)(castitem))
{}


Application::~Application()
{}


Application::CppClassType Application::application_class_; // initialize static member

GType Application::get_type()
{
  return application_class_.init().get_type();
}


GType Application::get_base_type()
{
  return gtk_application_get_type();
}


std::vector<Window*> Application::get_windows()
{
  return Glib::ListHandler<Window*>::list_to_vector(gtk_application_get_windows(gobj()), Glib::OWNERSHIP_NONE);
}

std::vector<const Window*> Application::get_windows() const
{
  return Glib::ListHandler<const Window*>::list_to_vector(gtk_application_get_windows(const_cast<GtkApplication*>(gobj())), Glib::OWNERSHIP_NONE);
}

void Application::remove_window(Window& window)
{
  gtk_application_remove_window(gobj(), (window).gobj()); 
}


} // namespace Gtk


