// Generated by gmmproc 2.51.5 -- DO NOT MODIFY!
#ifndef _GTKMM_COLORBUTTON_H
#define _GTKMM_COLORBUTTON_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/button.h>
#include <gtkmm/colorchooser.h>
#include <gdkmm/rgba.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkColorButton = struct _GtkColorButton;
using GtkColorButtonClass = struct _GtkColorButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class ColorButton_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A button to launch a color selection dialog.
 *
 * The GtkColorButton is a button which displays the currently selected color an allows to
 * open a color selection dialog to change the color. It is suitable widget for selecting a
 * color in a preference dialog.
 *
 * The ColorButton widget looks like this:
 * @image html colorbutton1.png
 *
 * @ingroup Widgets
 */

class ColorButton
: public Button,
  public ColorChooser
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorButton CppObjectType;
  typedef ColorButton_Class CppClassType;
  typedef GtkColorButton BaseObjectType;
  typedef GtkColorButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ColorButton(ColorButton&& src) noexcept;
  ColorButton& operator=(ColorButton&& src) noexcept;

  // noncopyable
  ColorButton(const ColorButton&) = delete;
  ColorButton& operator=(const ColorButton&) = delete;

  ~ColorButton() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorButton_Class;
  static CppClassType colorbutton_class_;

protected:
  explicit ColorButton(const Glib::ConstructParams& construct_params);
  explicit ColorButton(GtkColorButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkColorButton*       gobj()       { return reinterpret_cast<GtkColorButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkColorButton* gobj() const { return reinterpret_cast<GtkColorButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_color_set().
  virtual void on_color_set();


private:

  
public:

  /** Creates a new color button.
   *
   * This creates a widget in the form of a small button containing a swatch representing
   * the current selected color. When the button is clicked, a color-selection dialog will
   * open, allowing the user to select a color. The swatch will be updated to reflect the
   * new color when the user finishes.
   *
   * @newin{2,4}
   */
  ColorButton();
  

  /** Creates a new color button with a predefined color.
   *
   * Same as Gtk::ColorButton::ColorButton(). Additionally takes a Gdk::RGBA and
   * initializes the button with this color. Equivalent to calling ColorChooser::set_rgba(@a rgba)
   * after the default constructor.
   *
   * @param rgba A Gdk::RGBA to set the current color with.
   *
   * @newin{3,0}
   */
    explicit ColorButton(const Gdk::RGBA& rgba);


  /** Sets the title for the color selection dialog.
   * 
   * @newin{2,4}
   * 
   * @param title String containing new window title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Gets the title of the color selection dialog.
   * 
   * @newin{2,4}
   * 
   * @return The title.
   */
  Glib::ustring get_title() const;

  /** If this property is set to <tt>true</tt>, the color swatch on the button is
   * rendered against a checkerboard background to show its opacity and
   * the opacity slider is displayed in the color selection dialog.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_alpha() ;

/** If this property is set to <tt>true</tt>, the color swatch on the button is
   * rendered against a checkerboard background to show its opacity and
   * the opacity slider is displayed in the color selection dialog.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_alpha() const;

  /** The title of the color selection dialog
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** The title of the color selection dialog
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** The RGBA color.
   * 
   * @newin{3,0}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_rgba() ;

/** The RGBA color.
   * 
   * @newin{3,0}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_rgba() const;

  /** Set this property to <tt>true</tt> to skip the palette
   * in the dialog and go directly to the color editor.
   * 
   * This property should be used in cases where the palette
   * in the editor would be redundant, such as when the color
   * button is already part of a palette.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_editor() ;

/** Set this property to <tt>true</tt> to skip the palette
   * in the dialog and go directly to the color editor.
   * 
   * This property should be used in cases where the palette
   * in the editor would be redundant, such as when the color
   * button is already part of a palette.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_editor() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%color_set()</tt>
   *
   * The signal_color_set() signal is emitted when the user selects a color.
   * When handling this signal, use gtk_color_button_get_rgba() to
   * find out which color was just selected.
   * 
   * Note that this signal is only emitted when the user
   * changes the color. If you need to react to programmatic color changes
   * as well, use the notify::color signal.
   * 
   * @newin{2,4}
   */

  Glib::SignalProxy<void()> signal_color_set();


};


} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ColorButton
   */
  Gtk::ColorButton* wrap(GtkColorButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_COLORBUTTON_H */

