/*
  gyrus-admin.h

  GYRUS -- GNOME Cyrus Administrator. Administrator Object.
  
  Copyright (C) 2004-2005 Claudio Saavedra V. <csaavedra@alumnos.utalca.cl>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef GYRUS_ADMIN_H
#define GYRUS_ADMIN_H

#include<gnet.h>
#include "gyrus-session.h"

#define GYRUS_TYPE_ADMIN            (gyrus_admin_get_type ())
#define GYRUS_ADMIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GYRUS_TYPE_ADMIN, GyrusAdmin))
#define GYRUS_ADMIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  GYRUS_TYPE_ADMIN, GyrusAdminClass))
#define GYRUS_IS_ADMIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GYRUS_TYPE_ADMIN))
#define GYRUS_IS_ADMIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GYRUS_TYPE_ADMIN))
#define GYRUS_ADMIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  GYRUS_TYPE_ADMIN, GyrusAdmin))

typedef struct _GyrusAdminPrivate GyrusAdminPrivate;
typedef struct _GyrusAdmin        GyrusAdmin;
typedef struct _GyrusAdminClass   GyrusAdminClass;


/*** Gyrus Administrator Private Data ***/
struct _GyrusAdminPrivate {
	GtkWidget *entry_host;
	GtkWidget *entry_admin;
	GtkWidget *entry_port;
	GtkWidget *entry_pass;
	GtkWidget *button_connect;

	GtkWidget *label_mailbox_owner;
	GtkWidget *label_quota_limit;
	GtkWidget *label_quota_free;
	GtkWidget *entry_quota_new;
	GtkWidget *button_quota_apply;
	
	GtkWidget *entry_find_account;
	GtkWidget *window_find_account;
	
	GtkWidget *button_acl_apply;
	GtkWidget *button_acl_add;
	GtkWidget *button_acl_remove;
	GtkWidget *button_close_page;
	
	GtkWidget *button_user_create;
	GtkWidget *button_user_remove;
       	
	GtkWidget *label_mailbox_name;
	GtkWidget *label_page;

	GtkWidget *expander_modify_quota;
	GtkWidget *expander_modify_acl;
	
	GtkTreeView *treeview_users;
	GtkTreeView *treeview_acl;

	GtkWidget *label_acl;
	GtkWidget *scrolled_acl;
	
	GIOChannel *iochannel;
	GTcpSocket *tcp_socket;

	GyrusSession *session;

	gpointer *parent_app;
};

/*** Gyrus Main Application Data ***/
struct _GyrusAdmin {
	GtkVBox vbox;
	GyrusAdminPrivate *priv;
};

/*** Gyrus Main Application Class Data ***/
/*** derived from GtkVboxClass ***/

struct _GyrusAdminClass {
	 GtkVBoxClass vbox_class;
};

typedef enum {
	COL_USERS_ICON,
	COL_USERS_MAILBOX,
	COL_USERS_MAILBOX_PATH,
	COL_USERS_NUMBER
} GyrusColumnMailboxs;

typedef enum {
	COL_ACL_IDENTIFIER,
	COL_ACL_RIGHT_L,
	COL_ACL_RIGHT_R,
	COL_ACL_RIGHT_S,
	COL_ACL_RIGHT_W,
	COL_ACL_RIGHT_I,
	COL_ACL_RIGHT_P,
	COL_ACL_RIGHT_C,
	COL_ACL_RIGHT_D,
	COL_ACL_RIGHT_A,
	COL_ACL_MODIFIED,
	COL_ACL_NUMBER
} GyrusColumnAcl;

typedef enum {
	GYRUS_IMAP_STATUS_BAD,
	GYRUS_IMAP_STATUS_BYE,
	GYRUS_IMAP_STATUS_NO,
	GYRUS_IMAP_STATUS_OK,
	GYRUS_IMAP_STATUS_LIST
} GyrusImapStatus;	

typedef enum {
	GYRUS_ADMIN_LOGIN_NO_PASS,    /* it is supposed this never happens */
	GYRUS_ADMIN_LOGIN_BAD_LOGIN,  /* wrong user or password            */
	GYRUS_ADMIN_LOGIN_NO_HOST,    /* Problems when connecting to host  */
	GYRUS_ADMIN_LOGIN_OK          /* logged in                         */
} GyrusAdminLoginError;	

GType gyrus_admin_get_type (void);
GtkWidget * gyrus_admin_new (GyrusSession *session);
void gyrus_admin_set_parent_app (GyrusAdmin *admin, gpointer app);
const gchar *gyrus_admin_get_current_host (GyrusAdmin *admin);
const gchar *gyrus_admin_get_current_user (GyrusAdmin *admin);
const gchar *gyrus_admin_get_current_session_name (GyrusAdmin *admin);
const gchar *gyrus_admin_get_current_passwd (GyrusAdmin *admin);
int gyrus_admin_get_current_port (GyrusAdmin *admin);

gboolean gyrus_admin_is_connected (GyrusAdmin *admin);

/**
 * Returns TRUE if the user that is connected has access to the
 * ACL of currently selected mailbox. If there is no mailbox
 * selected, then returns FALSE.
 */
gboolean gyrus_admin_has_current_acl_access (GyrusAdmin *admin);

void gyrus_admin_logged_out (GyrusAdmin *admin);
void gyrus_admin_refresh_users_list (GyrusAdmin *admin);
gchar *gyrus_admin_get_selected_mailbox (GyrusAdmin *admin);
void gyrus_admin_select_mailbox (GyrusAdmin *admin, const gchar *mailbox);

GyrusImapStatus gyrus_admin_listen_channel (GyrusAdmin *admin, gchar **message,
					    gint *msg_len);
GIOError gyrus_admin_write_channel (GyrusAdmin *admin, gchar *message);


#endif /* GYRUS_ADMIN_H */

