/*
 * Copyright (C) 2009, 2010, 2011 Openismus GmbH
 *
 * This file is part of Java-libglom.
 *
 * Java-libglom is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * Java-libglom is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Java-libglom.  If not, see <http://www.gnu.org/licenses/>.
 */

%module Glom
%{

// Stick to the client-only API for swig, for now.
// TODO: Watch out if some of these are virtual.
#define GLOM_ENABLE_CLIENT_ONLY 1

#include <libglom/init.h>
#include <libglom/document/document.h>
#include <libglom/data_structure/glomconversions.h>
#include <libglom/utils.h>
using namespace Glom;
%}

// Ignore methods that use Gnome::Gda since we're not wrapping it
%ignore Glom::Document::set_layout_record_viewed(const Glib::ustring& table_name, const Glib::ustring& layout_name, const Gnome::Gda::Value& primary_key_value);
%ignore Glom::Document::get_layout_record_viewed(const Glib::ustring& table_name, const Glib::ustring& layout_name) const;
%ignore Glom::Document::set_table_example_data(const Glib::ustring& table_name, const type_example_rows& rows);
%ignore Glom::Document::get_table_example_data(const Glib::ustring& table_name) const;
%ignore Glom::Field::get_default_value() const;
%ignore Glom::Field::set_default_value(const Gnome::Gda::Value& value);
%ignore Glom::Field::get_holder(const Gnome::Gda::Value& value, const Glib::ustring& name = Glib::ustring()) const;
%ignore Glom::Field::sql(const Gnome::Gda::Value& value, const Glib::RefPtr<Gnome::Gda::Connection>& connection) const;
%ignore Glom::Field::sql(const Gnome::Gda::Value& value) const;
%ignore Glom::Field::to_file_format(const Gnome::Gda::Value& value) const;
%ignore Glom::Field::to_file_format(const Gnome::Gda::Value& value, glom_field_type glom_type);
%ignore Glom::Field::from_file_format(const Glib::ustring& str, bool& success) const;
%ignore Glom::Field::from_file_format(const Glib::ustring& str, glom_field_type glom_type, bool& success);
%ignore Glom::Field::sql_find(const Gnome::Gda::Value& value) const;
%ignore Glom::Field::sql_find_operator() const;
%ignore Glom::Field::get_glom_type_for_gda_type(GType gda_type);
%ignore Glom::Field::get_gda_type_for_glom_type(Field::glom_field_type glom_type);
%ignore Glom::Field::field_info_from_database_is_equal(const Glib::RefPtr<const Gnome::Gda::Column>& field);
%ignore Glom::Field::get_field_info();
%ignore Glom::Field::get_field_info() const;
%ignore Glom::Field::set_field_info(const Glib::RefPtr<Gnome::Gda::Column>& fieldInfo);
%ignore Glom::FieldFormatting::get_text_format_color_foreground_to_use(const Gnome::Gda::Value& value) const;
%ignore Glom::FieldFormatting::get_choices_custom() const;
%ignore Glom::FieldFormatting::set_choices_custom(const type_list_values& choices);
%ignore Glom::FoundSet::m_where_clause;

// Wrap C++ enum as proper Java enums by default as recommended in the
// Swig documentation. Some C++ enums won't work as Java enuns in which case
// they will need to be special cased with '%javacont(0) Class::enum;'
%include "enums.swg"
%javaconst(1);

// Ignore all methods with these signatures.
%ignore *::operator =;
%ignore *::operator !=;

// Rename overloaded operator == to .equals()
%rename(equals) *::operator ==;

// Allows us to use std::string, std::vector, std::map and std::pair
%include <stl.i>

// Include typemap.i so that we can use %apply.
%include <typemaps.i>
%apply unsigned int { guint };
// enable method parameters that require the address of a variable
%apply int &INPUT { int& };
%apply double &INPUT { double& };
%apply bool &INPUT { bool& };

// This is a nasty copy/paste because I can't get it to work with apply instead:
%include "glib_ustring.i"
%template(StringVector) std::vector< Glib::ustring >;

// Typemaps for transparently using Glom::sharedptr.
// This defines the %glom_sharedptr macro used below.
%include "glom_sharedptr.i"

// These macros allow us to transparently use Glom::sharedptr for
// the given class.
%glom_sharedptr(Glom::TranslatableItem);
%glom_sharedptr(Glom::HasTitleSingular);
%glom_sharedptr(Glom::PrintLayout);
%glom_sharedptr(Glom::Report);
%glom_sharedptr(Glom::TableInfo);
%glom_sharedptr(Glom::LayoutItem);
%glom_sharedptr(Glom::Field);
%glom_sharedptr(Glom::Relationship);
%glom_sharedptr(Glom::LayoutGroup);
%glom_sharedptr(Glom::LayoutItem_Portal);
%glom_sharedptr(Glom::LayoutItem_WithFormatting);
%glom_sharedptr(Glom::LayoutItem_Field);
%glom_sharedptr(Glom::LayoutItem_Text);
%glom_sharedptr(Glom::CustomTitle);

// Wrap classes for getting Field formatting information.
// These classes don't work with the sharedptr macro.
// Ignoring UsesRelationship because we not going to use it. See the comment
// about UsesRelationship in the '%extend Glom::LayoutItem_Field' section below.
%ignore Glom::UsesRelationship;
%include <libglom/data_structure/numeric_format.h>
// TODO enable FieldFormatting::get_choices_related() by adding support for 'Glib::ustring&' (not const) to glib_ustring.i
%ignore Glom::FieldFormatting::get_choices_related(sharedptr<const Relationship>& relationship, Glib::ustring& field, Glib::ustring& field_second, bool& show_all) const;
%include <libglom/data_structure/layout/fieldformatting.h>

// Classes that use Glom::sharedptr, put base classes before subclasses.
// top level base classes
%include <libglom/data_structure/translatable_item.h>
%include <libglom/data_structure/has_title_singular.h>

// subclasses of TranslatableItem
%include <libglom/data_structure/layout/layoutitem.h>
// the %rename makes the getter and setter look better
%rename(_default_formatting) Glom::Field::m_default_formatting;
%include <libglom/data_structure/field.h>
%include <libglom/data_structure/relationship.h>
%include <libglom/data_structure/layout/custom_title.h>
// the %rename makes the getters and setters look better
%rename(_sequence) Glom::FieldInfo::m_sequence;
%rename(_hidden) Glom::FieldInfo::m_hidden;
%rename(_default) Glom::FieldInfo::m_default;
%include <libglom/data_structure/tableinfo.h>
%include <libglom/data_structure/print_layout.h>
%include <libglom/data_structure/report.h>

// subclasses of LayoutItem
// Ignore const method
%ignore Glom::LayoutGroup::get_items() const;
%include <libglom/data_structure/layout/layoutgroup.h>
// Ignored so that getters and setters aren't generated for the m_formatting field.
// This can be enabled if it's required.
%ignore Glom::LayoutItem_WithFormatting::m_formatting;
%include <libglom/data_structure/layout/layoutitem_withformatting.h>

// subclasses of LayoutGroup
// Ignored because we're not wrapping sharedptr<UsesReleationship>.
// TODO enable LayoutItem_Portal.get/set_navigation_relationship_specific()
// A work-around will have to be found because the glom_sharedptr macro has trouble with UsesRelationship.
%ignore Glom::LayoutItem_Portal::set_navigation_relationship_specific(const sharedptr<UsesRelationship>& relationship);
%ignore Glom::LayoutItem_Portal::get_navigation_relationship_specific();
// Ignore const method
%ignore Glom::LayoutItem_Portal::get_navigation_relationship_specific() const;
%include <libglom/data_structure/layout/layoutitem_portal.h>

// subclasses of LayoutItem_WithFormatting
%ignore Glom::LayoutItem_Field::get_title_custom() const;
%include <libglom/data_structure/layout/layoutitem_field.h>
// This %rename makes the getter and setter look better.
// Get/set_text() is already used in LayoutItem_Text so we're using
// get/set_translatable_item.
%rename(_translatable_item) Glom::LayoutItem_Text::m_text;
%include <libglom/data_structure/layout/layoutitem_text.h>

// wrap the vectors
%template(FieldVector) std::vector< Glom::sharedptr<Glom::Field> >;
%template(LayoutGroupVector) std::vector< Glom::sharedptr<LayoutGroup> >;
%template(RelationshipVector) std::vector< Glom::sharedptr<Relationship> >;
%template(LayoutItemVector) std::vector< Glom::sharedptr<LayoutItem> >;
%template(LayoutFieldVector) std::vector< Glom::sharedptr<LayoutItem_Field> >;

//wrap the maps
%template(TypeNameMap) std::map< Glom::Field::glom_field_type, Glib::ustring >;
%template(LocalToTranslationMap) std::map< Glib::ustring, Glib::ustring >;

// Constants are in a separate .i file to make it easy to set
// values at build time.
%include glom_constants.i

// Wrap the libglom initialization methods.
%include <libglom/init.h>

// Wrap Glom::Document and include required base classes.
// Ignored to avoid wrapping signals
%ignore GlomBakery::Document::signal_modified();
%ignore GlomBakery::Document::signal_forget();
// If this method is needed, we'll need to support guchar* - %apply could help here.
%ignore GlomBakery::Document::load_from_data(const guchar* data, std::size_t length, int& failure_code);
%rename(BakeryDocument) GlomBakery::Document;
%rename(BakeryDocumentXML) GlomBakery::Document_XML;
%ignore GlomBakery::Document::set_view;
%ignore GlomBakery::Document::get_view;
%javaconst(0) Glom::Document::LOAD_FAILURE_CODE_FILE_VERSION_TOO_NEW;
%include <libglom/document/bakery/document.h>
%include <libglom/document/bakery/document_xml.h>
%include <libglom/data_structure/foundset.h>
// Ignore the GroupInfo class and methods for now because the shareptr macro
// is causing problems. These are only used for recreating a database from an
// example file so we shouldn't need them for now.
%ignore Glom::GroupInfo;
%ignore Glom::Document::set_group;
%ignore Glom::Document::get_groups;
%ignore Glom::Document::remove_group;
%include <libglom/document/document.h>

// Wrap classes required to setup a sort clause
%import <libglom/utils.h>
%template(SortFieldPair) std::pair< Glom::sharedptr<const LayoutItem_Field>, bool>;
// Include our custom interface file for std::list. It's incomplete but it works for what we need.
%include std_list.i
%template(SortClause) std::list<std::pair< Glom::sharedptr<const LayoutItem_Field>, bool> >;

// Wrap some other lists
%template(StringList) std::list< Glib::ustring >;
%template(TranslatableItemList) std::list< Glom::sharedptr<TranslatableItem> >;
%template(TableInfoList) std::list< Glom::sharedptr<TableInfo> >;

// Various methods for building sql queries without directly exposing libgda.
%inline %{
namespace Glom {
namespace Utils {

/* Return a query string for the given parameters */
std::string build_sql_select_simple(const Glib::ustring& table_name,
                                    const type_vecLayoutFields& fieldsToGet,
                                    const Glom::type_sort_clause sort_clause = type_sort_clause(),
                                    guint limit = 0)
{
  const Gnome::Gda::SqlExpr where_clause; //Ignored.
  const Glom::sharedptr<const Glom::Relationship> extra_join; //Ignored.
  const Glib::RefPtr<Gnome::Gda::SqlBuilder> builder =
    Glom::Utils::build_sql_select_with_where_clause(table_name, fieldsToGet, where_clause, extra_join, sort_clause, limit);
  return Glom::Utils::sqlbuilder_get_full_query(builder);
}

/* Return a count query string for the given parameters. The method
 * build_sql_select_count_rows is not wrapped directly to avoid having to do
 * multiple JNI method calls. */
std::string build_sql_select_count_simple(const Glib::ustring& table_name, const type_vecLayoutFields& fieldsToGet)
{
  const Glib::RefPtr<Gnome::Gda::SqlBuilder> builder = Glom::Utils::build_sql_select_with_where_clause(table_name, fieldsToGet);
  const Glib::RefPtr<Gnome::Gda::SqlBuilder> count_builder = Glom::Utils::build_sql_select_count_rows(builder);
  return Glom::Utils::sqlbuilder_get_full_query(count_builder);
}

/*
 * Return a query string for the given paramters. This method avoids having
 * to wrap Gnome::Gda::Value.
 *
 * @param key_value If this is empty then all records in the tables will be retrieved.
 */
std::string build_sql_select_with_key(const Glib::ustring& table_name,
                                      const type_vecLayoutFields& fieldsToGet,
                                      const sharedptr<const Field>& key_field,
                                      const Glib::ustring& key_value)
{
   bool success = false;
   Gnome::Gda::Value gda_key_value = Conversions::parse_value(key_field->get_glom_type(), key_value, success, true);
   if (!success)
     return "java-libglom error: key_value not parsed";

   Glib::RefPtr<Gnome::Gda::SqlBuilder> builder =
     Glom::Utils::build_sql_select_with_key(table_name, fieldsToGet, key_field, gda_key_value);
  return Glom::Utils::sqlbuilder_get_full_query(builder);

}

} // namespace Utils
} // namespace Glom
%}

// cast_dynamic methods: The code for cast_dynamic methods have been taken from the
// template code in sharedptr::cast_dynamic with appropriate classes filled in.
// You can safely add more cast_dynamic methods here as needed.
%extend Glom::LayoutGroup {
static Glom::sharedptr<Glom::LayoutGroup> cast_dynamic(const Glom::sharedptr<Glom::LayoutItem>& src)
{
  Glom::LayoutGroup *const pCppObject = dynamic_cast<Glom::LayoutGroup*>(src.operator->());

  if(pCppObject)
    return Glom::sharedptr<Glom::LayoutGroup>(pCppObject, src._get_refcount());
  else
    return Glom::sharedptr<Glom::LayoutGroup>();
}
};

%extend Glom::LayoutItem_Field {
static Glom::sharedptr<Glom::LayoutItem_Field> cast_dynamic(const Glom::sharedptr<Glom::LayoutItem>& src)
{
  Glom::LayoutItem_Field *const pCppObject = dynamic_cast<Glom::LayoutItem_Field*>(src.operator->());

  if(pCppObject)
    return Glom::sharedptr<Glom::LayoutItem_Field>(pCppObject, src._get_refcount());
  else
    return Glom::sharedptr<Glom::LayoutItem_Field>();
}
};

%extend Glom::LayoutItem_Text {
static Glom::sharedptr<Glom::LayoutItem_Text> cast_dynamic(const Glom::sharedptr<Glom::LayoutItem>& src)
{
  Glom::LayoutItem_Text *const pCppObject = dynamic_cast<Glom::LayoutItem_Text*>(src.operator->());

  if(pCppObject)
    return Glom::sharedptr<Glom::LayoutItem_Text>(pCppObject, src._get_refcount());
  else
    return Glom::sharedptr<Glom::LayoutItem_Text>();
}
};

%extend Glom::LayoutItem_Portal {
static Glom::sharedptr<Glom::LayoutItem_Portal> cast_dynamic(const Glom::sharedptr<Glom::LayoutItem>& src)
{
  Glom::LayoutItem_Portal *const pCppObject = dynamic_cast<Glom::LayoutItem_Portal*>(src.operator->());

  if(pCppObject)
    return Glom::sharedptr<Glom::LayoutItem_Portal>(pCppObject, src._get_refcount());
  else
    return Glom::sharedptr<Glom::LayoutItem_Portal>();
}
};

// Add methods to access methods from Glom::UsesRelationship. This is needed
// because Java doesn't support multiple inheritance and the glom_sharedptr macro
// has trouble with UsesRelationship. It's safe to add more methods here. Adding
// these methods automatically with a python or shell script might be an option
// we want complete bindings.
%extend Glom::LayoutItem_Field {

bool get_has_relationship_name()
{
  return self->get_has_relationship_name();
}

Glib::ustring get_table_used(const Glib::ustring& parent_table) {
  return self->get_table_used(parent_table);
}

};
