/* main_window.c generated by valac 0.10.2, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksourceview.h>
#include <config.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_CUSTOM_STATUSBAR (custom_statusbar_get_type ())
#define CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbar))
#define CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))
#define IS_CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_STATUSBAR))
#define IS_CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_STATUSBAR))
#define CUSTOM_STATUSBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))

typedef struct _CustomStatusbar CustomStatusbar;
typedef struct _CustomStatusbarClass CustomStatusbarClass;

#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_SIDE_PANEL (side_panel_get_type ())
#define SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIDE_PANEL, SidePanel))
#define SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIDE_PANEL, SidePanelClass))
#define IS_SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIDE_PANEL))
#define IS_SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIDE_PANEL))
#define SIDE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIDE_PANEL, SidePanelClass))

typedef struct _SidePanel SidePanel;
typedef struct _SidePanelClass SidePanelClass;

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_BUILD_TOOL_PROCESS (build_tool_process_get_type ())
#define BUILD_TOOL_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_PROCESS, BuildToolProcess))
#define BUILD_TOOL_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_PROCESS, BuildToolProcessClass))
#define IS_BUILD_TOOL_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_PROCESS))
#define IS_BUILD_TOOL_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_PROCESS))
#define BUILD_TOOL_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_PROCESS, BuildToolProcessClass))

typedef struct _BuildToolProcess BuildToolProcess;
typedef struct _BuildToolProcessClass BuildToolProcessClass;

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
typedef struct _Block7Data Block7Data;

#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _MainWindowPrivate {
	char* file_chooser_current_folder;
	DocumentsPanel* documents_panel;
	CustomStatusbar* statusbar;
	GotoLine* goto_line;
	SearchAndReplace* search_and_replace;
	BuildView* build_view;
	GtkToolbar* edit_toolbar;
	SidePanel* side_panel;
	Symbols* symbols;
	FileBrowser* file_browser;
	GtkHPaned* main_hpaned;
	GtkVPaned* vpaned;
	GtkUIManager* ui_manager;
	GtkActionGroup* action_group;
	GtkActionGroup* latex_action_group;
	GtkActionGroup* documents_list_action_group;
	GtkActionGroup* build_tools_action_group;
	guint documents_list_menu_ui_id;
	guint build_tools_menu_ui_id;
	BuildToolRunner* build_tool_runner;
	GtkAction* action_stop_exec;
	guint tip_message_cid;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	MainWindow * self;
	DocumentTab* tab;
	GtkInfoBar* infobar;
};

struct _Block6Data {
	int _ref_count_;
	MainWindow * self;
	DocumentTab* tab;
};

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};

struct _Block7Data {
	int _ref_count_;
	MainWindow * self;
	GFile* main_file;
};


static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType documents_panel_get_type (void) G_GNUC_CONST;
GType custom_statusbar_get_type (void) G_GNUC_CONST;
GType goto_line_get_type (void) G_GNUC_CONST;
GType search_and_replace_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType side_panel_get_type (void) G_GNUC_CONST;
GType symbols_get_type (void) G_GNUC_CONST;
GType file_browser_get_type (void) G_GNUC_CONST;
GType build_tool_process_get_type (void) G_GNUC_CONST;
GType build_tool_runner_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB,
	MAIN_WINDOW_ACTIVE_VIEW,
	MAIN_WINDOW_ACTIVE_DOCUMENT
};
void main_window_on_file_new (MainWindow* self);
static void _main_window_on_file_new_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_new_window (MainWindow* self);
static void _main_window_on_new_window_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_open (MainWindow* self);
static void _main_window_on_file_open_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_save (MainWindow* self);
static void _main_window_on_file_save_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_save_as (MainWindow* self);
static void _main_window_on_file_save_as_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_create_template (MainWindow* self);
static void _main_window_on_create_template_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_delete_template (MainWindow* self);
static void _main_window_on_delete_template_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_close (MainWindow* self);
static void _main_window_on_file_close_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_quit (MainWindow* self);
static void _main_window_on_quit_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_undo (MainWindow* self);
static void _main_window_on_edit_undo_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_redo (MainWindow* self);
static void _main_window_on_edit_redo_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_cut (MainWindow* self);
static void _main_window_on_edit_cut_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_copy (MainWindow* self);
static void _main_window_on_edit_copy_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_paste (MainWindow* self);
static void _main_window_on_edit_paste_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_delete (MainWindow* self);
static void _main_window_on_edit_delete_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_select_all (MainWindow* self);
static void _main_window_on_edit_select_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_comment (MainWindow* self);
static void _main_window_on_edit_comment_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_uncomment (MainWindow* self);
static void _main_window_on_edit_uncomment_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_open_preferences (MainWindow* self);
static void _main_window_on_open_preferences_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_goto_line (MainWindow* self);
static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_clean (MainWindow* self);
static void _main_window_on_build_clean_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_stop_execution (MainWindow* self);
static void _main_window_on_build_stop_execution_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_view_log (MainWindow* self);
static void _main_window_on_build_view_log_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_save_all (MainWindow* self);
static void _main_window_on_documents_save_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_close_all (MainWindow* self);
static void _main_window_on_documents_close_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_previous (MainWindow* self);
static void _main_window_on_documents_previous_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_next (MainWindow* self);
static void _main_window_on_documents_next_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_move_to_new_window (MainWindow* self);
static void _main_window_on_documents_move_to_new_window_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_about_dialog (MainWindow* self);
static void _main_window_on_about_dialog_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_side_panel (MainWindow* self, GtkAction* action);
static void _main_window_on_show_side_panel_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_bottom_panel (MainWindow* self, GtkAction* action);
static void _main_window_on_show_bottom_panel_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_edit_toolbar (MainWindow* self, GtkAction* action);
static void _main_window_on_show_edit_toolbar_gtk_action_callback (GtkAction* action, gpointer self);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static void main_window_initialize_menubar_and_toolbar (MainWindow* self);
static void main_window_setup_toolbar_open_button (MainWindow* self, GtkToolbar* toolbar);
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type, MainWindow* main_window);
static void _lambda72_ (GdkEventButton* event, MainWindow* self);
static void __lambda72__documents_panel_right_click (DocumentsPanel* _sender, GdkEventButton* event, gpointer self);
CustomStatusbar* custom_statusbar_new (void);
CustomStatusbar* custom_statusbar_construct (GType object_type);
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
SidePanel* side_panel_new (MainWindow* main_window, GtkToggleAction* action_view_side_panel);
SidePanel* side_panel_construct (GType object_type, MainWindow* main_window, GtkToggleAction* action_view_side_panel);
Symbols* symbols_new (MainWindow* main_window);
Symbols* symbols_construct (GType object_type, MainWindow* main_window);
void side_panel_add_component (SidePanel* self, const char* name, const char* stock_id, GtkVBox* component);
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
void side_panel_restore_state (SidePanel* self);
static gboolean _lambda73_ (MainWindow* self);
static gboolean __lambda73__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _lambda74_ (MainWindow* self);
static void main_window_set_file_actions_sensitivity (MainWindow* self, gboolean sensitive);
static void main_window_set_documents_move_to_new_window_sensitivity (MainWindow* self, gboolean sensitive);
static void main_window_update_documents_list_menu (MainWindow* self);
static void __lambda74__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda75_ (MainWindow* self);
void custom_statusbar_set_cursor_position (CustomStatusbar* self, gint line, gint col);
void search_and_replace_hide (SearchAndReplace* self);
static void main_window_my_set_title (MainWindow* self);
static void __lambda75__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda76_ (GtkNotebookPage* pg, guint page_num, MainWindow* self);
static void main_window_set_undo_sensitivity (MainWindow* self);
static void main_window_set_redo_sensitivity (MainWindow* self);
static void main_window_update_next_prev_doc_sensitivity (MainWindow* self);
static void main_window_update_build_tools_sensitivity (MainWindow* self);
static void main_window_update_cursor_position_statusbar (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gint document_get_project_id (Document* self);
static void __lambda76__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self);
static void _lambda77_ (MainWindow* self);
static void __lambda77__gtk_notebook_page_reordered (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda78_ (MainWindow* self);
GType completion_provider_get_type (void) G_GNUC_CONST;
CompletionProvider* completion_provider_get_default (void);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void __lambda78__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda79_ (MainWindow* self);
static gboolean __lambda79__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
GList* main_window_get_documents (MainWindow* self);
Document* document_tab_get_document (DocumentTab* self);
static void _g_list_free_g_object_unref (GList* self);
GList* main_window_get_unsaved_documents (MainWindow* self);
gboolean document_get_modified (Document* self);
GType document_view_get_type (void) G_GNUC_CONST;
GList* main_window_get_views (MainWindow* self);
DocumentView* document_tab_get_view (DocumentTab* self);
static void main_window_configure_recent_chooser (MainWindow* self, GtkRecentChooser* recent_chooser);
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type, MainWindow* main_window);
GType latex_menu_get_type (void) G_GNUC_CONST;
static void _lambda69_ (GtkAction* action, GtkWidget* p, MainWindow* self);
static void main_window_on_menu_item_select (MainWindow* self, GtkItem* proxy);
static void _main_window_on_menu_item_select_gtk_item_select (GtkItem* _sender, gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self, GtkItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_item_deselect (GtkItem* _sender, gpointer self);
static void __lambda69__gtk_ui_manager_connect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self);
static void _lambda70_ (GtkAction* action, GtkWidget* p, MainWindow* self);
static void __lambda70__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self);
void main_window_update_build_tools_menu (MainWindow* self);
BuildView* main_window_get_build_view (MainWindow* self);
CustomStatusbar* main_window_get_statusbar (MainWindow* self);
Symbols* main_window_get_symbols (MainWindow* self);
FileBrowser* main_window_get_file_browser (MainWindow* self);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GList* application_get_windows (Application* self);
GFile* document_get_location (Document* self);
void main_window_set_active_tab (MainWindow* self, DocumentTab* value);
DocumentTab* main_window_create_tab_from_location (MainWindow* self, GFile* location, gboolean jump_to);
void document_set_readonly (Document* self, gboolean value);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
static void _lambda44_ (gint response_id, Block5Data* _data5_);
static void __lambda44__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
GList* application_get_documents (Application* self);
guint document_get_unsaved_document_n (Document* self);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
void document_set_unsaved_document_n (Document* self, guint value);
static DocumentTab* main_window_process_create_tab (MainWindow* self, DocumentTab* tab, gboolean jump_to);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location);
void main_window_create_tab_with_view (MainWindow* self, DocumentView* view);
DocumentTab* document_tab_new_with_view (DocumentView* view);
DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view);
static void _lambda37_ (Block6Data* _data6_);
gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close);
static void __lambda37__document_tab_close_document (DocumentTab* _sender, gpointer self);
static void _lambda38_ (Block6Data* _data6_);
static void __lambda38__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda39_ (Block6Data* _data6_);
static void __lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda40_ (Block6Data* _data6_);
static void main_window_selection_changed (MainWindow* self);
static void __lambda40__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda41_ (Block6Data* _data6_);
static void main_window_sync_name (MainWindow* self, DocumentTab* tab);
static void __lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda42_ (Block6Data* _data6_);
static void __lambda42__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void _lambda43_ (Block6Data* _data6_);
static void __lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _main_window_update_cursor_position_statusbar_document_cursor_moved (Document* _sender, gpointer self);
void documents_panel_add_tab (DocumentsPanel* self, DocumentTab* tab, gint position, gboolean jump_to);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
const char* document_tab_get_label_text (DocumentTab* self);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
void documents_panel_remove_tab (DocumentsPanel* self, DocumentTab* tab);
DocumentTab* main_window_get_tab_from_location (MainWindow* self, GFile* location);
gboolean main_window_is_on_workspace_screen (MainWindow* self, GdkScreen* screen, guint workspace);
guint utils_get_window_workspace (GtkWindow* gtkwindow);
#define UTILS_ALL_WORKSPACES ((guint) 0xffffff)
char* document_tab_get_name (DocumentTab* self);
char* document_tab_get_menu_tip (DocumentTab* self);
char* document_get_short_name_for_display (Document* self);
char* utils_str_middle_truncate (const char* str, guint max_length);
char* utils_get_dirname_for_display (GFile* location);
gboolean document_get_readonly (Document* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
void document_set_location (Document* self, GFile* value);
static gboolean main_window_close_all_documents (MainWindow* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
void dialogs_close_several_unsaved_documents (MainWindow* window, GList* unsaved_docs);
void main_window_remove_all_tabs (MainWindow* self);
DocumentView* main_window_get_active_view (MainWindow* self);
guint document_view_my_get_visual_column (DocumentView* self, GtkTextIter* iter);
static void _lambda68_ (GtkRecentChooser* chooser, MainWindow* self);
static void __lambda68__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender, gpointer self);
void main_window_save_state (MainWindow* self, gboolean sync);
gint side_panel_get_active_component (SidePanel* self);
static void main_window_move_tab_to_new_window (MainWindow* self, DocumentTab* tab);
MainWindow* application_create_window (Application* self, GdkScreen* screen);
static void main_window_build_tools_menu_activate (MainWindow* self, GtkAction* action);
static void _main_window_build_tools_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeLinkedList* app_settings_get_build_tools (AppSettings* self);
void build_view_show (BuildView* self);
GFile* document_get_main_file (Document* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
static void _lambda71_ (Block7Data* _data7_);
void file_browser_refresh_if_in_dir (FileBrowser* self, GFile* dir);
static void __lambda71__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
GtkAction* main_window_get_action_stop_exec (MainWindow* self);
static void main_window_documents_list_menu_activate (MainWindow* self, GtkAction* action);
static void _main_window_documents_list_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self);
gboolean document_is_tex_document (Document* self);
char* utils_get_extension (const char* path);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
GType templates_get_type (void) G_GNUC_CONST;
Templates* templates_get_default (void);
void templates_show_dialog_new (Templates* self, MainWindow* parent);
static void _g_slist_free_g_object_unref (GSList* self);
void templates_show_dialog_create (Templates* self, MainWindow* parent);
void templates_show_dialog_delete (Templates* self, MainWindow* parent);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
void document_view_scroll_to_cursor (DocumentView* self, double margin);
void document_view_cut_selection (DocumentView* self);
void document_view_copy_selection (DocumentView* self);
void document_view_my_paste_clipboard (DocumentView* self);
void document_view_delete_selection (DocumentView* self);
void document_view_my_select_all (DocumentView* self);
void document_comment_selected_lines (Document* self);
void document_uncomment_selected_lines (Document* self);
void preferences_dialog_show_me (MainWindow* parent);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
void document_view_set_font_from_settings (DocumentView* self);
void search_and_replace_show_search (SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
void goto_line_show (GotoLine* self);
void build_tool_process_abort (BuildToolProcess* self);
gboolean document_clean_build_files (Document* self, MainWindow* window);
char* utils_get_shortname (const char* path);
void projects_new_project (MainWindow* main_window);
gboolean projects_configure_project (GtkWindow* main_window, gint project_id);
void projects_manage_projects (MainWindow* main_window);
BuildToolRunner* build_tool_runner_new_web_browser (GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct_web_browser (GType object_type, GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec);
DocumentTab* documents_panel_get_active_tab (DocumentsPanel* self);
static void main_window_finalize (GObject* obj);
static void main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkActionEntry MAIN_WINDOW_action_entries[46] = {{"File", NULL, N_ ("_File")}, {"FileNew", GTK_STOCK_NEW, NULL, NULL, N_ ("New file"), (GCallback) _main_window_on_file_new_gtk_action_callback}, {"FileNewWindow", NULL, N_ ("New _Window"), NULL, N_ ("Create a new window"), (GCallback) _main_window_on_new_window_gtk_action_callback}, {"FileOpen", GTK_STOCK_OPEN, NULL, NULL, N_ ("Open a file"), (GCallback) _main_window_on_file_open_gtk_action_callback}, {"FileSave", GTK_STOCK_SAVE, NULL, NULL, N_ ("Save the current file"), (GCallback) _main_window_on_file_save_gtk_action_callback}, {"FileSaveAs", GTK_STOCK_SAVE_AS, NULL, NULL, N_ ("Save the current file with a different name"), (GCallback) _main_window_on_file_save_as_gtk_action_callback}, {"FileCreateTemplate", NULL, N_ ("Create _Template From Document..."), NULL, N_ ("Create a new template from the current document"), (GCallback) _main_window_on_create_template_gtk_action_callback}, {"FileDeleteTemplate", NULL, N_ ("_Delete Template..."), NULL, N_ ("Delete personnal template(s)"), (GCallback) _main_window_on_delete_template_gtk_action_callback}, {"FileClose", GTK_STOCK_CLOSE, NULL, NULL, N_ ("Close the current file"), (GCallback) _main_window_on_file_close_gtk_action_callback}, {"FileQuit", GTK_STOCK_QUIT, NULL, NULL, N_ ("Quit the program"), (GCallback) _main_window_on_quit_gtk_action_callback}, {"Edit", NULL, N_ ("_Edit")}, {"EditUndo", GTK_STOCK_UNDO, NULL, "<Control>Z", N_ ("Undo the last action"), (GCallback) _main_window_on_edit_undo_gtk_action_callback}, {"EditRedo", GTK_STOCK_REDO, NULL, "<Shift><Control>Z", N_ ("Redo the last undone action"), (GCallback) _main_window_on_edit_redo_gtk_action_callback}, {"EditCut", GTK_STOCK_CUT, NULL, NULL, N_ ("Cut the selection"), (GCallback) _main_window_on_edit_cut_gtk_action_callback}, {"EditCopy", GTK_STOCK_COPY, NULL, NULL, N_ ("Copy the selection"), (GCallback) _main_window_on_edit_copy_gtk_action_callback}, {"EditPaste", GTK_STOCK_PASTE, NULL, NULL, N_ ("Paste the clipboard"), (GCallback) _main_window_on_edit_paste_gtk_action_callback}, {"EditDelete", GTK_STOCK_DELETE, NULL, NULL, N_ ("Delete the selected text"), (GCallback) _main_window_on_edit_delete_gtk_action_callback}, {"EditSelectAll", GTK_STOCK_SELECT_ALL, NULL, "<Control>A", N_ ("Select the entire document"), (GCallback) _main_window_on_edit_select_all_gtk_action_callback}, {"EditComment", NULL, N_ ("_Comment"), "<Control>M", N_ ("Comment the selected lines (add the character \"%\")"), (GCallback) _main_window_on_edit_comment_gtk_action_callback}, {"EditUncomment", NULL, N_ ("_Uncomment"), "<Shift><Control>M", N_ ("Uncomment the selected lines (remove the character \"%\")"), (GCallback) _main_window_on_edit_uncomment_gtk_action_callback}, {"EditPreferences", GTK_STOCK_PREFERENCES, NULL, NULL, N_ ("Configure the application"), (GCallback) _main_window_on_open_preferences_gtk_action_callback}, {"View", NULL, N_ ("_View")}, {"ViewZoomIn", GTK_STOCK_ZOOM_IN, N_ ("Zoom _In"), "<Control>plus", N_ ("Enlarge the font"), (GCallback) _main_window_on_view_zoom_in_gtk_action_callback}, {"ViewZoomOut", GTK_STOCK_ZOOM_OUT, N_ ("Zoom _Out"), "<Control>minus", N_ ("Shrink the font"), (GCallback) _main_window_on_view_zoom_out_gtk_action_callback}, {"ViewZoomReset", GTK_STOCK_ZOOM_100, N_ ("_Reset Zoom"), "<Control>0", N_ ("Reset the size of the font"), (GCallback) _main_window_on_view_zoom_reset_gtk_action_callback}, {"Search", NULL, N_ ("_Search")}, {"SearchFind", GTK_STOCK_FIND, NULL, NULL, N_ ("Search for text"), (GCallback) _main_window_on_search_find_gtk_action_callback}, {"SearchReplace", GTK_STOCK_FIND_AND_REPLACE, NULL, NULL, N_ ("Search for and replace text"), (GCallback) _main_window_on_search_replace_gtk_action_callback}, {"SearchGoToLine", GTK_STOCK_JUMP_TO, N_ ("_Go to Line..."), "<Control>G", N_ ("Go to a specific line"), (GCallback) _main_window_on_search_goto_line_gtk_action_callback}, {"Build", NULL, N_ ("_Build")}, {"BuildClean", GTK_STOCK_CLEAR, N_ ("Cleanup Build _Files"), NULL, N_ ("Clean-up build files (*.aux, *.log, *.out, *.toc, etc)"), (GCallback) _main_window_on_build_clean_gtk_action_callback}, {"BuildStopExecution", GTK_STOCK_STOP, N_ ("_Stop Execution"), "<Release>F12", N_ ("Stop Execution"), (GCallback) _main_window_on_build_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", N_ ("View _Log"), NULL, N_ ("View Log"), (GCallback) _main_window_on_build_view_log_gtk_action_callback}, {"Documents", NULL, N_ ("_Documents")}, {"DocumentsSaveAll", GTK_STOCK_SAVE, N_ ("_Save All"), "<Shift><Control>L", N_ ("Save all open files"), (GCallback) _main_window_on_documents_save_all_gtk_action_callback}, {"DocumentsCloseAll", GTK_STOCK_CLOSE, N_ ("_Close All"), "<Shift><Control>W", N_ ("Close all open files"), (GCallback) _main_window_on_documents_close_all_gtk_action_callback}, {"DocumentsPrevious", GTK_STOCK_GO_BACK, N_ ("_Previous Document"), "<Control><Alt>Page_Up", N_ ("Activate previous document"), (GCallback) _main_window_on_documents_previous_gtk_action_callback}, {"DocumentsNext", GTK_STOCK_GO_FORWARD, N_ ("_Next Document"), "<Control><Alt>Page_Down", N_ ("Activate next document"), (GCallback) _main_window_on_documents_next_gtk_action_callback}, {"DocumentsMoveToNewWindow", NULL, N_ ("_Move to New Window"), NULL, N_ ("Move the current document to a new window"), (GCallback) _main_window_on_documents_move_to_new_window_gtk_action_callback}, {"Projects", NULL, N_ ("_Projects")}, {"ProjectsNew", GTK_STOCK_NEW, N_ ("_New Project"), NULL, N_ ("Create a new project"), (GCallback) _main_window_on_projects_new_gtk_action_callback}, {"ProjectsConfigCurrent", GTK_STOCK_PROPERTIES, N_ ("_Configure Current Project"), NULL, N_ ("Change the main file of the current project"), (GCallback) _main_window_on_projects_config_current_gtk_action_callback}, {"ProjectsManage", GTK_STOCK_PREFERENCES, N_ ("_Manage Projects"), NULL, N_ ("Manage Projects"), (GCallback) _main_window_on_projects_manage_gtk_action_callback}, {"Help", NULL, N_ ("_Help")}, {"HelpLatexReference", GTK_STOCK_HELP, N_ ("_LaTeX Reference"), "<Release>F1", N_ ("The Kile LaTeX Reference"), (GCallback) _main_window_on_help_latex_reference_gtk_action_callback}, {"HelpAbout", GTK_STOCK_ABOUT, NULL, NULL, N_ ("About LaTeXila"), (GCallback) _main_window_on_about_dialog_gtk_action_callback}};
static const GtkToggleActionEntry MAIN_WINDOW_toggle_action_entries[3] = {{"ViewSidePanel", NULL, N_ ("_Side panel"), NULL, N_ ("Show or hide the side panel"), (GCallback) _main_window_on_show_side_panel_gtk_action_callback}, {"ViewBottomPanel", NULL, N_ ("_Bottom panel"), NULL, N_ ("Show or hide the bottom panel"), (GCallback) _main_window_on_show_bottom_panel_gtk_action_callback}, {"ViewEditToolbar", NULL, N_ ("_Edit Toolbar"), NULL, N_ ("Show or hide the edit toolbar"), (GCallback) _main_window_on_show_edit_toolbar_gtk_action_callback}};


static void _main_window_on_file_new_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_new (self);
}


static void _main_window_on_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_new_window (self);
}


static void _main_window_on_file_open_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_open (self);
}


static void _main_window_on_file_save_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_save (self);
}


static void _main_window_on_file_save_as_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_save_as (self);
}


static void _main_window_on_create_template_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_create_template (self);
}


static void _main_window_on_delete_template_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_delete_template (self);
}


static void _main_window_on_file_close_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_close (self);
}


static void _main_window_on_quit_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_quit (self);
}


static void _main_window_on_edit_undo_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_undo (self);
}


static void _main_window_on_edit_redo_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_redo (self);
}


static void _main_window_on_edit_cut_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_cut (self);
}


static void _main_window_on_edit_copy_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_copy (self);
}


static void _main_window_on_edit_paste_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_paste (self);
}


static void _main_window_on_edit_delete_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_delete (self);
}


static void _main_window_on_edit_select_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_select_all (self);
}


static void _main_window_on_edit_comment_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_comment (self);
}


static void _main_window_on_edit_uncomment_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_uncomment (self);
}


static void _main_window_on_open_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_open_preferences (self);
}


static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_in (self);
}


static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_out (self);
}


static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_reset (self);
}


static void _main_window_on_search_find_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_find (self);
}


static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_replace (self);
}


static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_goto_line (self);
}


static void _main_window_on_build_clean_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_clean (self);
}


static void _main_window_on_build_stop_execution_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_stop_execution (self);
}


static void _main_window_on_build_view_log_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_view_log (self);
}


static void _main_window_on_documents_save_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_save_all (self);
}


static void _main_window_on_documents_close_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_close_all (self);
}


static void _main_window_on_documents_previous_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_previous (self);
}


static void _main_window_on_documents_next_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_next (self);
}


static void _main_window_on_documents_move_to_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_move_to_new_window (self);
}


static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_new (self);
}


static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_config_current (self);
}


static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_manage (self);
}


static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_help_latex_reference (self);
}


static void _main_window_on_about_dialog_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_about_dialog (self);
}


static void _main_window_on_show_side_panel_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_side_panel (self, action);
}


static void _main_window_on_show_bottom_panel_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_bottom_panel (self, action);
}


static void _main_window_on_show_edit_toolbar_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_edit_toolbar (self, action);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda72_ (GdkEventButton* event, MainWindow* self) {
	GtkMenu* popup_menu;
	popup_menu = _g_object_ref0 (GTK_MENU (gtk_ui_manager_get_widget (self->priv->ui_manager, "/NotebookPopup")));
	gtk_menu_popup (popup_menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
	_g_object_unref0 (popup_menu);
}


static void __lambda72__documents_panel_right_click (DocumentsPanel* _sender, GdkEventButton* event, gpointer self) {
	_lambda72_ (event, self);
}


static gboolean _lambda73_ (MainWindow* self) {
	gboolean result = FALSE;
	main_window_on_quit (self);
	result = TRUE;
	return result;
}


static gboolean __lambda73__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = _lambda73_ (self);
	return result;
}


static void _lambda74_ (MainWindow* self) {
	gint nb_pages;
	nb_pages = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	if (nb_pages == 1) {
		main_window_set_file_actions_sensitivity (self, TRUE);
	} else {
		if (nb_pages == 2) {
			main_window_set_documents_move_to_new_window_sensitivity (self, TRUE);
		}
	}
	main_window_update_documents_list_menu (self);
}


static void __lambda74__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda74_ (self);
}


static void _lambda75_ (MainWindow* self) {
	gint nb_pages;
	nb_pages = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	if (nb_pages == 0) {
		custom_statusbar_set_cursor_position (self->priv->statusbar, -1, -1);
		main_window_set_file_actions_sensitivity (self, FALSE);
		gtk_widget_hide ((GtkWidget*) self->priv->goto_line);
		search_and_replace_hide (self->priv->search_and_replace);
		g_object_notify ((GObject*) self, "active-tab");
		g_object_notify ((GObject*) self, "active-document");
		g_object_notify ((GObject*) self, "active-view");
	} else {
		if (nb_pages == 1) {
			main_window_set_documents_move_to_new_window_sensitivity (self, FALSE);
		}
	}
	main_window_my_set_title (self);
	main_window_update_documents_list_menu (self);
}


static void __lambda75__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda75_ (self);
}


static void _lambda76_ (GtkNotebookPage* pg, guint page_num, MainWindow* self) {
	char* action_name;
	GtkRadioAction* action;
	GtkAction* action2;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (pg != NULL);
	main_window_set_undo_sensitivity (self);
	main_window_set_redo_sensitivity (self);
	main_window_update_next_prev_doc_sensitivity (self);
	main_window_update_build_tools_sensitivity (self);
	main_window_my_set_title (self);
	main_window_update_cursor_position_statusbar (self);
	action_name = g_strdup_printf ("Tab_%u", page_num);
	action = _g_object_ref0 (GTK_RADIO_ACTION (gtk_action_group_get_action (self->priv->documents_list_action_group, action_name)));
	if (action != NULL) {
		gtk_toggle_action_set_active ((GtkToggleAction*) action, TRUE);
	}
	action2 = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "ProjectsConfigCurrent"));
	if (main_window_get_active_tab (self) != NULL) {
		_tmp0_ = document_get_project_id (main_window_get_active_document (self)) != (-1);
	} else {
		_tmp0_ = FALSE;
	}
	gtk_action_set_sensitive (action2, _tmp0_);
	g_object_notify ((GObject*) self, "active-tab");
	g_object_notify ((GObject*) self, "active-document");
	g_object_notify ((GObject*) self, "active-view");
	_g_object_unref0 (action2);
	_g_object_unref0 (action);
	_g_free0 (action_name);
}


static void __lambda76__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self) {
	_lambda76_ (page, page_num, self);
}


static void _lambda77_ (MainWindow* self) {
	main_window_update_next_prev_doc_sensitivity (self);
	main_window_update_documents_list_menu (self);
}


static void __lambda77__gtk_notebook_page_reordered (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda77_ (self);
}


static void _lambda78_ (MainWindow* self) {
	CompletionProvider* provider;
	provider = completion_provider_get_default ();
	completion_provider_hide_calltip_window (provider);
	_g_object_unref0 (provider);
}


static void __lambda78__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda78_ (self);
}


static gboolean _lambda79_ (MainWindow* self) {
	gboolean result = FALSE;
	CompletionProvider* provider;
	provider = completion_provider_get_default ();
	completion_provider_hide_calltip_window (provider);
	result = FALSE;
	_g_object_unref0 (provider);
	return result;
}


static gboolean __lambda79__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda79_ (self);
	return result;
}


MainWindow* main_window_construct (GType object_type) {
	MainWindow * self;
	GSettings* settings;
	gint w = 0;
	gint h = 0;
	GdkWindowState state;
	GtkWidget* menu;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp0_;
	GtkToolbar* build_toolbar;
	DocumentsPanel* _tmp1_;
	CustomStatusbar* _tmp2_;
	GotoLine* _tmp3_;
	SearchAndReplace* _tmp4_;
	GtkAction* _tmp5_;
	GtkToggleAction* action_view_bottom_panel;
	BuildView* _tmp6_;
	GtkToggleAction* action_view_side_panel;
	SidePanel* _tmp7_;
	Symbols* _tmp8_;
	FileBrowser* _tmp9_;
	GtkVBox* main_vbox;
	GtkHPaned* _tmp10_;
	GtkVBox* vbox_source_view;
	GtkWidget* _tmp11_;
	GtkVPaned* _tmp12_;
	self = g_object_newv (object_type, 0, NULL);
	gtk_window_set_title ((GtkWindow*) self, "LaTeXila");
	settings = g_settings_new ("org.gnome.latexila.state.window");
	g_settings_get (settings, "size", "(ii)", &w, &h);
	gtk_window_set_default_size ((GtkWindow*) self, w, h);
	state = (GdkWindowState) g_settings_get_int (settings, "state");
	if ((state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gtk_window_unmaximize ((GtkWindow*) self);
	}
	if ((state & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	main_window_initialize_menubar_and_toolbar (self);
	menu = _g_object_ref0 (gtk_ui_manager_get_widget (self->priv->ui_manager, "/MainMenu"));
	toolbar = _g_object_ref0 (GTK_TOOLBAR (gtk_ui_manager_get_widget (self->priv->ui_manager, "/MainToolbar")));
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
	main_window_setup_toolbar_open_button (self, toolbar);
	self->priv->edit_toolbar = (_tmp0_ = _g_object_ref0 (GTK_TOOLBAR (gtk_ui_manager_get_widget (self->priv->ui_manager, "/EditToolbar"))), _g_object_unref0 (self->priv->edit_toolbar), _tmp0_);
	gtk_toolbar_set_style (self->priv->edit_toolbar, GTK_TOOLBAR_ICONS);
	build_toolbar = _g_object_ref0 (GTK_TOOLBAR (gtk_ui_manager_get_widget (self->priv->ui_manager, "/BuildToolbar")));
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
	self->priv->documents_panel = (_tmp1_ = g_object_ref_sink (documents_panel_new (self)), _g_object_unref0 (self->priv->documents_panel), _tmp1_);
	g_signal_connect_object (self->priv->documents_panel, "right-click", (GCallback) __lambda72__documents_panel_right_click, self, 0);
	self->priv->statusbar = (_tmp2_ = g_object_ref_sink (custom_statusbar_new ()), _g_object_unref0 (self->priv->statusbar), _tmp2_);
	self->priv->tip_message_cid = gtk_statusbar_get_context_id ((GtkStatusbar*) self->priv->statusbar, "tip_message");
	self->priv->goto_line = (_tmp3_ = g_object_ref_sink (goto_line_new (self)), _g_object_unref0 (self->priv->goto_line), _tmp3_);
	self->priv->search_and_replace = (_tmp4_ = search_and_replace_new (self), _g_object_unref0 (self->priv->search_and_replace), _tmp4_);
	self->priv->action_stop_exec = (_tmp5_ = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "BuildStopExecution")), _g_object_unref0 (self->priv->action_stop_exec), _tmp5_);
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
	action_view_bottom_panel = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewBottomPanel")));
	self->priv->build_view = (_tmp6_ = g_object_ref_sink (build_view_new (self, build_toolbar, action_view_bottom_panel)), _g_object_unref0 (self->priv->build_view), _tmp6_);
	action_view_side_panel = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewSidePanel")));
	self->priv->side_panel = (_tmp7_ = g_object_ref_sink (side_panel_new (self, action_view_side_panel)), _g_object_unref0 (self->priv->side_panel), _tmp7_);
	self->priv->symbols = (_tmp8_ = g_object_ref_sink (symbols_new (self)), _g_object_unref0 (self->priv->symbols), _tmp8_);
	side_panel_add_component (self->priv->side_panel, _ ("Symbols"), "symbol_alpha", (GtkVBox*) self->priv->symbols);
	self->priv->file_browser = (_tmp9_ = g_object_ref_sink (file_browser_new (self)), _g_object_unref0 (self->priv->file_browser), _tmp9_);
	side_panel_add_component (self->priv->side_panel, _ ("File Browser"), GTK_STOCK_OPEN, (GtkVBox*) self->priv->file_browser);
	side_panel_restore_state (self->priv->side_panel);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda73__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "page-added", (GCallback) __lambda74__gtk_notebook_page_added, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "page-removed", (GCallback) __lambda75__gtk_notebook_page_removed, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "switch-page", (GCallback) __lambda76__gtk_notebook_switch_page, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "page-reordered", (GCallback) __lambda77__gtk_notebook_page_reordered, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::active-tab", (GCallback) __lambda78__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __lambda79__gtk_widget_focus_out_event, self, 0);
	main_window_set_file_actions_sensitivity (self, FALSE);
	main_window_set_documents_move_to_new_window_sensitivity (self, FALSE);
	main_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_pack_start ((GtkBox*) main_vbox, menu, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) toolbar, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) self->priv->edit_toolbar, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) main_vbox);
	gtk_widget_show_all (menu);
	gtk_widget_show_all ((GtkWidget*) toolbar);
	self->priv->main_hpaned = (_tmp10_ = g_object_ref_sink ((GtkHPaned*) gtk_hpaned_new ()), _g_object_unref0 (self->priv->main_hpaned), _tmp10_);
	gtk_paned_set_position ((GtkPaned*) self->priv->main_hpaned, g_settings_get_int (settings, "side-panel-size"));
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) self->priv->main_hpaned, TRUE, TRUE, 0);
	gtk_widget_show ((GtkWidget*) self->priv->main_hpaned);
	vbox_source_view = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 2));
	gtk_box_pack_start ((GtkBox*) vbox_source_view, (GtkWidget*) self->priv->documents_panel, TRUE, TRUE, 0);
	gtk_box_pack_start ((GtkBox*) vbox_source_view, (GtkWidget*) self->priv->goto_line, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox_source_view, _tmp11_ = search_and_replace_get_widget (self->priv->search_and_replace), FALSE, FALSE, 0);
	_g_object_unref0 (_tmp11_);
	gtk_widget_show ((GtkWidget*) vbox_source_view);
	gtk_widget_show_all ((GtkWidget*) self->priv->documents_panel);
	self->priv->vpaned = (_tmp12_ = g_object_ref_sink ((GtkVPaned*) gtk_vpaned_new ()), _g_object_unref0 (self->priv->vpaned), _tmp12_);
	gtk_paned_set_position ((GtkPaned*) self->priv->vpaned, g_settings_get_int (settings, "vertical-paned-position"));
	gtk_paned_pack1 ((GtkPaned*) self->priv->vpaned, (GtkWidget*) vbox_source_view, TRUE, TRUE);
	gtk_paned_pack2 ((GtkPaned*) self->priv->vpaned, (GtkWidget*) self->priv->build_view, FALSE, TRUE);
	gtk_paned_add1 ((GtkPaned*) self->priv->main_hpaned, (GtkWidget*) self->priv->side_panel);
	gtk_paned_add2 ((GtkPaned*) self->priv->main_hpaned, (GtkWidget*) self->priv->vpaned);
	gtk_widget_show ((GtkWidget*) self->priv->side_panel);
	gtk_widget_show ((GtkWidget*) self->priv->vpaned);
	gtk_box_pack_end ((GtkBox*) main_vbox, (GtkWidget*) self->priv->statusbar, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->statusbar);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vbox);
	gtk_widget_show ((GtkWidget*) self);
	main_window_show_or_hide_widgets (self);
	_g_object_unref0 (vbox_source_view);
	_g_object_unref0 (main_vbox);
	_g_object_unref0 (action_view_side_panel);
	_g_object_unref0 (action_view_bottom_panel);
	_g_object_unref0 (build_toolbar);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (menu);
	_g_object_unref0 (settings);
	return self;
}


MainWindow* main_window_new (void) {
	return main_window_construct (TYPE_MAIN_WINDOW);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


GList* main_window_get_documents (MainWindow* self) {
	GList* result = NULL;
	GList* res;
	gint nb;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	nb = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				DocumentTab* tab;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < nb)) {
					break;
				}
				tab = _g_object_ref0 (DOCUMENT_TAB (gtk_notebook_get_nth_page ((GtkNotebook*) self->priv->documents_panel, i)));
				res = g_list_append (res, _g_object_ref0 (document_tab_get_document (tab)));
				_g_object_unref0 (tab);
			}
		}
	}
	result = res;
	return result;
}


GList* main_window_get_unsaved_documents (MainWindow* self) {
	GList* result = NULL;
	GList* list;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = main_window_get_documents (self);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (document_get_modified (doc)) {
					list = g_list_append (list, _g_object_ref0 (doc));
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
	result = list;
	return result;
}


GList* main_window_get_views (MainWindow* self) {
	GList* result = NULL;
	GList* res;
	gint nb;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	nb = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				DocumentTab* tab;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < nb)) {
					break;
				}
				tab = _g_object_ref0 (DOCUMENT_TAB (gtk_notebook_get_nth_page ((GtkNotebook*) self->priv->documents_panel, i)));
				res = g_list_append (res, _g_object_ref0 (document_tab_get_view (tab)));
				_g_object_unref0 (tab);
			}
		}
	}
	result = res;
	return result;
}


static void _main_window_on_menu_item_select_gtk_item_select (GtkItem* _sender, gpointer self) {
	main_window_on_menu_item_select (self, _sender);
}


static void _main_window_on_menu_item_deselect_gtk_item_deselect (GtkItem* _sender, gpointer self) {
	main_window_on_menu_item_deselect (self, _sender);
}


static void _lambda69_ (GtkAction* action, GtkWidget* p, MainWindow* self) {
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	if (GTK_IS_MENU_ITEM (p)) {
		GtkMenuItem* proxy;
		proxy = _g_object_ref0 (GTK_MENU_ITEM (p));
		g_signal_connect_object ((GtkItem*) proxy, "select", (GCallback) _main_window_on_menu_item_select_gtk_item_select, self, 0);
		g_signal_connect_object ((GtkItem*) proxy, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_item_deselect, self, 0);
		_g_object_unref0 (proxy);
	}
}


static void __lambda69__gtk_ui_manager_connect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self) {
	_lambda69_ (action, proxy, self);
}


static void _lambda70_ (GtkAction* action, GtkWidget* p, MainWindow* self) {
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	if (GTK_IS_MENU_ITEM (p)) {
		GtkMenuItem* proxy;
		guint _tmp0_;
		guint _tmp1_;
		proxy = _g_object_ref0 (GTK_MENU_ITEM (p));
		g_signal_parse_name ("select", GTK_TYPE_ITEM, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkItem*) proxy, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_item_select, self);
		g_signal_parse_name ("deselect", GTK_TYPE_ITEM, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkItem*) proxy, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_item_deselect, self);
		_g_object_unref0 (proxy);
	}
}


static void __lambda70__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self) {
	_lambda70_ (action, proxy, self);
}


static void main_window_initialize_menubar_and_toolbar (MainWindow* self) {
	GtkAction* recent_action;
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkUIManager* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	recent_action = (GtkAction*) ((GtkRecentAction*) gtk_recent_action_new ("FileOpenRecent", _ ("Open _Recent"), _ ("Open recently used files"), ""));
	main_window_configure_recent_chooser (self, GTK_RECENT_CHOOSER (recent_action));
	self->priv->action_group = (_tmp0_ = gtk_action_group_new ("ActionGroup"), _g_object_unref0 (self->priv->action_group), _tmp0_);
	gtk_action_group_set_translation_domain (self->priv->action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (self->priv->action_group, MAIN_WINDOW_action_entries, G_N_ELEMENTS (MAIN_WINDOW_action_entries), self);
	gtk_action_group_add_action (self->priv->action_group, recent_action);
	gtk_action_group_add_toggle_actions (self->priv->action_group, MAIN_WINDOW_toggle_action_entries, G_N_ELEMENTS (MAIN_WINDOW_toggle_action_entries), self);
	self->priv->latex_action_group = (_tmp1_ = (GtkActionGroup*) latex_menu_new (self), _g_object_unref0 (self->priv->latex_action_group), _tmp1_);
	self->priv->ui_manager = (_tmp2_ = gtk_ui_manager_new (), _g_object_unref0 (self->priv->ui_manager), _tmp2_);
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->action_group, 0);
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->latex_action_group, 0);
	{
		char* path;
		path = g_build_filename (DATA_DIR, "ui", "ui.xml", NULL);
		gtk_ui_manager_add_ui_from_file (self->priv->ui_manager, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			goto __catch4_g_error;
		}
		_g_free0 (path);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("main_window.vala:504: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (recent_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_window_add_accel_group ((GtkWindow*) self, gtk_ui_manager_get_accel_group (self->priv->ui_manager));
	g_signal_connect_object (self->priv->ui_manager, "connect-proxy", (GCallback) __lambda69__gtk_ui_manager_connect_proxy, self, 0);
	g_signal_connect_object (self->priv->ui_manager, "disconnect-proxy", (GCallback) __lambda70__gtk_ui_manager_disconnect_proxy, self, 0);
	self->priv->documents_list_action_group = (_tmp3_ = gtk_action_group_new ("DocumentsListActions"), _g_object_unref0 (self->priv->documents_list_action_group), _tmp3_);
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->documents_list_action_group, 0);
	self->priv->build_tools_action_group = (_tmp4_ = gtk_action_group_new ("BuildToolsActions"), _g_object_unref0 (self->priv->build_tools_action_group), _tmp4_);
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->build_tools_action_group, 0);
	main_window_update_build_tools_menu (self);
	_g_object_unref0 (recent_action);
}


static void main_window_on_menu_item_select (MainWindow* self, GtkItem* proxy) {
	GtkAction* action;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	action = _g_object_ref0 (gtk_activatable_get_related_action ((GtkActivatable*) GTK_MENU_ITEM (proxy)));
	g_return_if_fail (action != NULL);
	if (gtk_action_get_tooltip (action) != NULL) {
		gtk_statusbar_push ((GtkStatusbar*) self->priv->statusbar, self->priv->tip_message_cid, gtk_action_get_tooltip (action));
	}
	_g_object_unref0 (action);
}


static void main_window_on_menu_item_deselect (MainWindow* self, GtkItem* proxy) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	gtk_statusbar_pop ((GtkStatusbar*) self->priv->statusbar, self->priv->tip_message_cid);
}


static void main_window_show_or_hide_widgets (MainWindow* self) {
	GSettings* settings;
	gboolean show;
	GtkToggleAction* action;
	GtkToggleAction* _tmp0_;
	GtkToggleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	settings = g_settings_new ("org.gnome.latexila.preferences.ui");
	show = g_settings_get_boolean (settings, "edit-toolbar-visible");
	if (!show) {
		gtk_widget_hide ((GtkWidget*) self->priv->edit_toolbar);
	}
	action = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewEditToolbar")));
	gtk_toggle_action_set_active (action, show);
	show = g_settings_get_boolean (settings, "side-panel-visible");
	if (!show) {
		gtk_widget_hide ((GtkWidget*) self->priv->side_panel);
	}
	action = (_tmp0_ = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewSidePanel"))), _g_object_unref0 (action), _tmp0_);
	gtk_toggle_action_set_active (action, show);
	show = g_settings_get_boolean (settings, "bottom-panel-visible");
	if (!show) {
		gtk_widget_hide ((GtkWidget*) self->priv->build_view);
	}
	action = (_tmp1_ = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewBottomPanel"))), _g_object_unref0 (action), _tmp1_);
	gtk_toggle_action_set_active (action, show);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


BuildView* main_window_get_build_view (MainWindow* self) {
	BuildView* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (self->priv->build_view);
	return result;
}


CustomStatusbar* main_window_get_statusbar (MainWindow* self) {
	CustomStatusbar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (self->priv->statusbar);
	return result;
}


Symbols* main_window_get_symbols (MainWindow* self) {
	Symbols* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (self->priv->symbols);
	return result;
}


FileBrowser* main_window_get_file_browser (MainWindow* self) {
	FileBrowser* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (self->priv->file_browser);
	return result;
}


static void _lambda44_ (gint response_id, Block5Data* _data5_) {
	MainWindow * self;
	self = _data5_->self;
	if (response_id == GTK_RESPONSE_YES) {
		document_set_readonly (document_tab_get_document (_data5_->tab), FALSE);
	}
	gtk_object_destroy ((GtkObject*) _data5_->infobar);
	gtk_widget_grab_focus ((GtkWidget*) document_tab_get_view (_data5_->tab));
}


static void __lambda44__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda44_ (response_id, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->infobar);
		_g_object_unref0 (_data5_->tab);
		g_slice_free (Block5Data, _data5_);
	}
}


DocumentTab* main_window_open_document (MainWindow* self, GFile* location) {
	DocumentTab* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* w_collection;
		GList* w_it;
		w_collection = (_tmp1_ = application_get_windows (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MainWindow* w;
			w = _g_object_ref0 ((MainWindow*) w_it->data);
			{
				{
					GList* doc_collection;
					GList* doc_it;
					doc_collection = main_window_get_documents (w);
					for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
						Document* doc;
						doc = _g_object_ref0 ((Document*) doc_it->data);
						{
							gboolean _tmp2_ = FALSE;
							if (document_get_location (doc) != NULL) {
								_tmp2_ = g_file_equal (location, document_get_location (doc));
							} else {
								_tmp2_ = FALSE;
							}
							if (_tmp2_) {
								Block5Data* _data5_;
								char* _tmp3_;
								char* _tmp4_;
								char* primary_msg;
								char* secondary_msg;
								_data5_ = g_slice_new0 (Block5Data);
								_data5_->_ref_count_ = 1;
								_data5_->self = g_object_ref (self);
								if (self == w) {
									main_window_set_active_tab (self, doc->tab);
									result = _g_object_ref0 (doc->tab);
									block5_data_unref (_data5_);
									_g_object_unref0 (doc);
									__g_list_free_g_object_unref0 (doc_collection);
									_g_object_unref0 (w);
									return result;
								}
								_data5_->tab = main_window_create_tab_from_location (self, location, TRUE);
								document_set_readonly (document_tab_get_document (_data5_->tab), TRUE);
								primary_msg = (_tmp4_ = g_strdup_printf (_ ("This file (%s) is already opened in another LaTeXila window."), _tmp3_ = g_file_get_parse_name (location)), _g_free0 (_tmp3_), _tmp4_);
								secondary_msg = g_strdup (_ ("LaTeXila opened this instance of the file in a non-editable way. Do yo" \
"u want to edit it anyway?"));
								_data5_->infobar = (GtkInfoBar*) document_tab_add_message (_data5_->tab, primary_msg, secondary_msg, GTK_MESSAGE_WARNING);
								gtk_info_bar_add_button (_data5_->infobar, _ ("Edit Anyway"), (gint) GTK_RESPONSE_YES);
								gtk_info_bar_add_button (_data5_->infobar, _ ("Don't Edit"), (gint) GTK_RESPONSE_NO);
								g_signal_connect_data (_data5_->infobar, "response", (GCallback) __lambda44__gtk_info_bar_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
								result = _g_object_ref0 (_data5_->tab);
								_g_free0 (secondary_msg);
								_g_free0 (primary_msg);
								block5_data_unref (_data5_);
								_g_object_unref0 (doc);
								__g_list_free_g_object_unref0 (doc_collection);
								_g_object_unref0 (w);
								return result;
							}
							_g_object_unref0 (doc);
						}
					}
					__g_list_free_g_object_unref0 (doc_collection);
				}
				_g_object_unref0 (w);
			}
		}
	}
	result = main_window_create_tab_from_location (self, location, TRUE);
	return result;
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to) {
	DocumentTab* result = NULL;
	DocumentTab* tab;
	gint all_nums_length1;
	gint _all_nums_size_;
	guint* _tmp1_;
	guint* _tmp0_ = NULL;
	guint* all_nums;
	guint num = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	tab = g_object_ref_sink (document_tab_new ());
	all_nums = (_tmp1_ = (_tmp0_ = g_new0 (guint, 0), _tmp0_), all_nums_length1 = 0, _all_nums_size_ = all_nums_length1, _tmp1_);
	{
		Application* _tmp2_;
		GList* _tmp3_;
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (_tmp3_ = application_get_documents (_tmp2_ = application_get_default ()), _g_object_unref0 (_tmp2_), _tmp3_);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (document_get_location (doc) == NULL) {
					_vala_array_add1 (&all_nums, &all_nums_length1, &_all_nums_size_, document_get_unsaved_document_n (doc));
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
	{
		gboolean _tmp4_;
		num = (guint) 1;
		_tmp4_ = TRUE;
		while (TRUE) {
			if (!_tmp4_) {
				num++;
			}
			_tmp4_ = FALSE;
			if (!_vala_uint_array_contains (all_nums, all_nums_length1, num)) {
				break;
			}
			;
		}
	}
	document_set_unsaved_document_n (document_tab_get_document (tab), num);
	result = main_window_process_create_tab (self, tab, jump_to);
	all_nums = (g_free (all_nums), NULL);
	_g_object_unref0 (tab);
	return result;
}


DocumentTab* main_window_create_tab_from_location (MainWindow* self, GFile* location, gboolean jump_to) {
	DocumentTab* result = NULL;
	DocumentTab* tab;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	tab = g_object_ref_sink (document_tab_new_from_location (location));
	result = main_window_process_create_tab (self, tab, jump_to);
	_g_object_unref0 (tab);
	return result;
}


void main_window_create_tab_with_view (MainWindow* self, DocumentView* view) {
	DocumentTab* tab;
	DocumentTab* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	tab = g_object_ref_sink (document_tab_new_with_view (view));
	_tmp0_ = main_window_process_create_tab (self, tab, TRUE);
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (tab);
}


static void _lambda37_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	main_window_close_tab (self, _data6_->tab, FALSE);
}


static void __lambda37__document_tab_close_document (DocumentTab* _sender, gpointer self) {
	_lambda37_ (self);
}


static void _lambda38_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	if (_data6_->tab != main_window_get_active_tab (self)) {
		return;
	}
	main_window_set_undo_sensitivity (self);
}


static void __lambda38__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda38_ (self);
}


static void _lambda39_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	if (_data6_->tab != main_window_get_active_tab (self)) {
		return;
	}
	main_window_set_redo_sensitivity (self);
}


static void __lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda39_ (self);
}


static void _lambda40_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	if (_data6_->tab != main_window_get_active_tab (self)) {
		return;
	}
	main_window_selection_changed (self);
}


static void __lambda40__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda40_ (self);
}


static void _lambda41_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	main_window_sync_name (self, _data6_->tab);
	main_window_update_build_tools_sensitivity (self);
}


static void __lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda41_ (self);
}


static void _lambda42_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	main_window_sync_name (self, _data6_->tab);
}


static void __lambda42__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda42_ (self);
}


static void _lambda43_ (Block6Data* _data6_) {
	MainWindow * self;
	self = _data6_->self;
	main_window_sync_name (self, _data6_->tab);
}


static void __lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda43_ (self);
}


static void _main_window_update_cursor_position_statusbar_document_cursor_moved (Document* _sender, gpointer self) {
	main_window_update_cursor_position_statusbar (self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->tab);
		g_slice_free (Block6Data, _data6_);
	}
}


static DocumentTab* main_window_process_create_tab (MainWindow* self, DocumentTab* tab, gboolean jump_to) {
	DocumentTab* result = NULL;
	Block6Data* _data6_;
	g_return_val_if_fail (self != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->tab = _g_object_ref0 (tab);
	if (_data6_->tab == NULL) {
		result = NULL;
		block6_data_unref (_data6_);
		return result;
	}
	g_signal_connect_data (_data6_->tab, "close-document", (GCallback) __lambda37__document_tab_close_document, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_data ((GObject*) document_tab_get_document (_data6_->tab), "notify::can-undo", (GCallback) __lambda38__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_data ((GObject*) document_tab_get_document (_data6_->tab), "notify::can-redo", (GCallback) __lambda39__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_data ((GObject*) document_tab_get_document (_data6_->tab), "notify::has-selection", (GCallback) __lambda40__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_data ((GObject*) document_tab_get_document (_data6_->tab), "notify::location", (GCallback) __lambda41__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_data ((GtkTextBuffer*) document_tab_get_document (_data6_->tab), "modified-changed", (GCallback) __lambda42__gtk_text_buffer_modified_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_data ((GObject*) document_tab_get_document (_data6_->tab), "notify::readonly", (GCallback) __lambda43__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	g_signal_connect_object (document_tab_get_document (_data6_->tab), "cursor-moved", (GCallback) _main_window_update_cursor_position_statusbar_document_cursor_moved, self, 0);
	gtk_widget_show ((GtkWidget*) _data6_->tab);
	documents_panel_add_tab (self->priv->documents_panel, _data6_->tab, -1, jump_to);
	main_window_set_undo_sensitivity (self);
	main_window_set_redo_sensitivity (self);
	main_window_selection_changed (self);
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
		gtk_window_present ((GtkWindow*) self);
	}
	result = _g_object_ref0 (_data6_->tab);
	block6_data_unref (_data6_);
	return result;
}


gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tab != NULL, FALSE);
	if (!force_close) {
		_tmp0_ = document_get_modified (document_tab_get_document (tab));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMessageDialog* dialog;
		dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Save changes to document \"%s\" before closing?"), document_tab_get_label_text (tab)));
		gtk_dialog_add_buttons ((GtkDialog*) dialog, _ ("Close without Saving"), GTK_RESPONSE_CLOSE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
		if (document_get_location (document_tab_get_document (tab)) == NULL) {
			gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_SAVE_AS, (gint) GTK_RESPONSE_ACCEPT);
		} else {
			gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_ACCEPT);
		}
		while (TRUE) {
			gint res;
			res = gtk_dialog_run ((GtkDialog*) dialog);
			if (res == GTK_RESPONSE_CLOSE) {
				break;
			} else {
				if (res == GTK_RESPONSE_ACCEPT) {
					if (main_window_save_document (self, document_tab_get_document (tab), FALSE)) {
						break;
					}
					continue;
				} else {
					gtk_object_destroy ((GtkObject*) dialog);
					result = FALSE;
					_g_object_unref0 (dialog);
					return result;
				}
			}
		}
		gtk_object_destroy ((GtkObject*) dialog);
		_g_object_unref0 (dialog);
	}
	documents_panel_remove_tab (self->priv->documents_panel, tab);
	result = TRUE;
	return result;
}


DocumentTab* main_window_get_tab_from_location (MainWindow* self, GFile* location) {
	DocumentTab* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = main_window_get_documents (self);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (g_file_equal (location, document_get_location (doc))) {
					result = _g_object_ref0 (doc->tab);
					_g_object_unref0 (doc);
					__g_list_free_g_object_unref0 (doc_collection);
					return result;
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
	result = NULL;
	return result;
}


gboolean main_window_is_on_workspace_screen (MainWindow* self, GdkScreen* screen, guint workspace) {
	gboolean result = FALSE;
	guint ws;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (screen != NULL) {
		char* cur_name;
		gint cur_n;
		GdkScreen* s;
		char* name;
		gint n;
		gboolean _tmp0_ = FALSE;
		cur_name = g_strdup (gdk_display_get_name (gdk_screen_get_display (screen)));
		cur_n = gdk_screen_get_number (screen);
		s = _g_object_ref0 (gtk_window_get_screen ((GtkWindow*) self));
		name = g_strdup (gdk_display_get_name (gdk_screen_get_display (s)));
		n = gdk_screen_get_number (s);
		if (_vala_strcmp0 (cur_name, name) != 0) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = cur_n != n;
		}
		if (_tmp0_) {
			result = FALSE;
			_g_free0 (name);
			_g_object_unref0 (s);
			_g_free0 (cur_name);
			return result;
		}
		_g_free0 (name);
		_g_object_unref0 (s);
		_g_free0 (cur_name);
	}
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		gtk_widget_realize ((GtkWidget*) self);
	}
	ws = utils_get_window_workspace ((GtkWindow*) self);
	if (ws == workspace) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ws == UTILS_ALL_WORKSPACES;
	}
	result = _tmp1_;
	return result;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void main_window_sync_name (MainWindow* self, DocumentTab* tab) {
	gint page_num;
	char* action_name;
	GtkAction* action;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	if (tab == main_window_get_active_tab (self)) {
		main_window_my_set_title (self);
	}
	page_num = gtk_notebook_page_num ((GtkNotebook*) self->priv->documents_panel, (GtkWidget*) tab);
	action_name = g_strdup_printf ("Tab_%d", page_num);
	action = _g_object_ref0 (gtk_action_group_get_action (self->priv->documents_list_action_group, action_name));
	g_return_if_fail (action != NULL);
	gtk_action_set_label (action, _tmp1_ = string_replace (_tmp0_ = document_tab_get_name (tab), "_", "__"));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	gtk_action_set_tooltip (action, _tmp2_ = document_tab_get_menu_tip (tab));
	_g_free0 (_tmp2_);
	_g_object_unref0 (action);
	_g_free0 (action_name);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static void main_window_my_set_title (MainWindow* self) {
	guint max_title_length;
	char* title;
	char* dirname;
	GFile* loc;
	const char* _tmp5_;
	char* _tmp6_;
	char* _tmp10_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	g_return_if_fail (self != NULL);
	if (main_window_get_active_tab (self) == NULL) {
		gtk_window_set_title ((GtkWindow*) self, "LaTeXila");
		return;
	}
	max_title_length = (guint) 100;
	title = NULL;
	dirname = NULL;
	loc = _g_object_ref0 (document_get_location (main_window_get_active_document (self)));
	if (loc == NULL) {
		char* _tmp0_;
		title = (_tmp0_ = document_get_short_name_for_display (main_window_get_active_document (self)), _g_free0 (title), _tmp0_);
	} else {
		char* basename;
		basename = g_file_get_basename (loc);
		if (string_get_length (basename) > max_title_length) {
			char* _tmp1_;
			title = (_tmp1_ = utils_str_middle_truncate (basename, max_title_length), _g_free0 (title), _tmp1_);
		} else {
			char* _tmp2_;
			char* _tmp3_;
			char* _tmp4_;
			title = (_tmp2_ = g_strdup (basename), _g_free0 (title), _tmp2_);
			dirname = (_tmp4_ = utils_str_middle_truncate (_tmp3_ = utils_get_dirname_for_display (loc), (guint) MAX ((glong) 20, max_title_length - string_get_length (basename))), _g_free0 (dirname), _tmp4_);
			_g_free0 (_tmp3_);
		}
		_g_free0 (basename);
	}
	_tmp5_ = NULL;
	if (document_get_modified (main_window_get_active_document (self))) {
		_tmp5_ = "*";
	} else {
		_tmp5_ = "";
	}
	_tmp6_ = NULL;
	if (document_get_readonly (main_window_get_active_document (self))) {
		char* _tmp7_;
		char* _tmp8_;
		_tmp6_ = (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (" [", _ ("Read-Only"), NULL), "]", NULL), _g_free0 (_tmp6_), _tmp8_);
		_g_free0 (_tmp7_);
	} else {
		char* _tmp9_;
		_tmp6_ = (_tmp9_ = g_strdup (""), _g_free0 (_tmp6_), _tmp9_);
	}
	_tmp10_ = NULL;
	if (dirname != NULL) {
		char* _tmp11_;
		char* _tmp12_;
		_tmp10_ = (_tmp12_ = g_strconcat (_tmp11_ = g_strconcat (" (", dirname, NULL), ")", NULL), _g_free0 (_tmp10_), _tmp12_);
		_g_free0 (_tmp11_);
	} else {
		char* _tmp13_;
		_tmp10_ = (_tmp13_ = g_strdup (""), _g_free0 (_tmp10_), _tmp13_);
	}
	gtk_window_set_title ((GtkWindow*) self, _tmp17_ = g_strconcat (_tmp16_ = g_strconcat (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat (_tmp5_, title, NULL), _tmp6_, NULL), _tmp10_, NULL), " - LaTeXila", NULL));
	_g_free0 (_tmp17_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (loc);
	_g_free0 (dirname);
	_g_free0 (title);
}


gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkFileChooserDialog* file_chooser;
	char* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (doc != NULL, FALSE);
	if (!force_save_as) {
		_tmp0_ = document_get_location (doc) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_save (doc, TRUE, FALSE);
		result = TRUE;
		return result;
	}
	file_chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL));
	if (document_get_location (doc) == NULL) {
		char* _tmp1_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) file_chooser, _tmp1_ = g_strconcat (document_tab_get_label_text (doc->tab), ".tex", NULL));
		_g_free0 (_tmp1_);
	} else {
		gtk_file_chooser_set_current_name ((GtkFileChooser*) file_chooser, document_tab_get_label_text (doc->tab));
	}
	if (self->priv->file_chooser_current_folder != NULL) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) file_chooser, self->priv->file_chooser_current_folder);
	}
	if (document_get_location (doc) != NULL) {
		{
			gtk_file_chooser_set_file ((GtkFileChooser*) file_chooser, document_get_location (doc), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_chooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	while (TRUE) {
		GFile* file;
		if (!(gtk_dialog_run ((GtkDialog*) file_chooser) == GTK_RESPONSE_ACCEPT)) {
			break;
		}
		file = _g_object_ref0 (gtk_file_chooser_get_file ((GtkFileChooser*) file_chooser));
		if (g_file_query_exists (file, NULL)) {
			char* _tmp2_;
			GtkMessageDialog* _tmp3_;
			GtkMessageDialog* confirmation;
			GtkButton* button_replace;
			GtkImage* icon;
			gint response;
			confirmation = (_tmp3_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("A file named \"%s\" already exists. Do you want to replace it?"), _tmp2_ = g_file_get_basename (file))), _g_free0 (_tmp2_), _tmp3_);
			gtk_dialog_add_button ((GtkDialog*) confirmation, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
			button_replace = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Replace")));
			icon = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_SAVE_AS, GTK_ICON_SIZE_BUTTON));
			gtk_button_set_image (button_replace, (GtkWidget*) icon);
			gtk_dialog_add_action_widget ((GtkDialog*) confirmation, (GtkWidget*) button_replace, (gint) GTK_RESPONSE_YES);
			gtk_widget_show ((GtkWidget*) button_replace);
			response = gtk_dialog_run ((GtkDialog*) confirmation);
			gtk_object_destroy ((GtkObject*) confirmation);
			if (response != GTK_RESPONSE_YES) {
				_g_object_unref0 (icon);
				_g_object_unref0 (button_replace);
				_g_object_unref0 (confirmation);
				_g_object_unref0 (file);
				continue;
			}
			_g_object_unref0 (icon);
			_g_object_unref0 (button_replace);
			_g_object_unref0 (confirmation);
		}
		document_set_location (doc, file);
		_g_object_unref0 (file);
		break;
	}
	self->priv->file_chooser_current_folder = (_tmp4_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) file_chooser), _g_free0 (self->priv->file_chooser_current_folder), _tmp4_);
	gtk_object_destroy ((GtkObject*) file_chooser);
	if (document_get_location (doc) != NULL) {
		document_save (doc, FALSE, TRUE);
		result = TRUE;
		_g_object_unref0 (file_chooser);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (file_chooser);
	return result;
}


static gboolean main_window_close_all_documents (MainWindow* self) {
	gboolean result = FALSE;
	GList* unsaved_documents;
	g_return_val_if_fail (self != NULL, FALSE);
	unsaved_documents = main_window_get_unsaved_documents (self);
	if (unsaved_documents == NULL) {
		documents_panel_remove_all_tabs (self->priv->documents_panel);
		result = TRUE;
		__g_list_free_g_object_unref0 (unsaved_documents);
		return result;
	} else {
		if (unsaved_documents->next == NULL) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) unsaved_documents->data);
			main_window_set_active_tab (self, doc->tab);
			if (main_window_close_tab (self, doc->tab, FALSE)) {
				documents_panel_remove_all_tabs (self->priv->documents_panel);
				result = TRUE;
				_g_object_unref0 (doc);
				__g_list_free_g_object_unref0 (unsaved_documents);
				return result;
			}
			_g_object_unref0 (doc);
		} else {
			dialogs_close_several_unsaved_documents (self, unsaved_documents);
			if (gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel) == 0) {
				result = TRUE;
				__g_list_free_g_object_unref0 (unsaved_documents);
				return result;
			}
		}
	}
	result = FALSE;
	__g_list_free_g_object_unref0 (unsaved_documents);
	return result;
}


void main_window_remove_all_tabs (MainWindow* self) {
	g_return_if_fail (self != NULL);
	documents_panel_remove_all_tabs (self->priv->documents_panel);
}


static void main_window_update_cursor_position_statusbar (MainWindow* self) {
	GtkTextIter iter = {0};
	gint row;
	gint col;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) main_window_get_active_document (self), &iter, gtk_text_buffer_get_insert ((GtkTextBuffer*) main_window_get_active_document (self)));
	row = (gint) gtk_text_iter_get_line (&iter);
	col = (gint) document_view_my_get_visual_column (main_window_get_active_view (self), &iter);
	custom_statusbar_set_cursor_position (self->priv->statusbar, row + 1, col + 1);
}


static void main_window_setup_toolbar_open_button (MainWindow* self, GtkToolbar* toolbar) {
	GtkRecentManager* recent_manager;
	GtkWidget* toolbar_recent_menu;
	GtkMenuToolButton* open_button;
	GtkAction* action;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toolbar != NULL);
	recent_manager = _g_object_ref0 (gtk_recent_manager_get_default ());
	toolbar_recent_menu = (GtkWidget*) g_object_ref_sink ((GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recent_manager));
	main_window_configure_recent_chooser (self, GTK_RECENT_CHOOSER (toolbar_recent_menu));
	open_button = g_object_ref_sink ((GtkMenuToolButton*) gtk_menu_tool_button_new_from_stock (GTK_STOCK_OPEN));
	gtk_menu_tool_button_set_menu (open_button, toolbar_recent_menu);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) open_button, _ ("Open a file"));
	gtk_menu_tool_button_set_arrow_tooltip_text (open_button, _ ("Open a recently used file"));
	action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "FileOpen"));
	gtk_activatable_set_related_action ((GtkActivatable*) open_button, action);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) open_button, 1);
	_g_object_unref0 (action);
	_g_object_unref0 (open_button);
	_g_object_unref0 (toolbar_recent_menu);
	_g_object_unref0 (recent_manager);
}


static void _lambda68_ (GtkRecentChooser* chooser, MainWindow* self) {
	char* uri;
	GFile* _tmp0_;
	DocumentTab* _tmp1_;
	g_return_if_fail (chooser != NULL);
	uri = g_strdup (gtk_recent_chooser_get_current_uri (chooser));
	_tmp1_ = main_window_open_document (self, _tmp0_ = g_file_new_for_uri (uri));
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
	_g_free0 (uri);
}


static void __lambda68__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender, gpointer self) {
	_lambda68_ (_sender, self);
}


static void main_window_configure_recent_chooser (MainWindow* self, GtkRecentChooser* recent_chooser) {
	GtkRecentFilter* filter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recent_chooser != NULL);
	gtk_recent_chooser_set_local_only (recent_chooser, FALSE);
	gtk_recent_chooser_set_sort_type (recent_chooser, GTK_RECENT_SORT_MRU);
	filter = g_object_ref_sink (gtk_recent_filter_new ());
	gtk_recent_filter_add_application (filter, "latexila");
	gtk_recent_chooser_set_filter (recent_chooser, filter);
	g_signal_connect_object (recent_chooser, "item-activated", (GCallback) __lambda68__gtk_recent_chooser_item_activated, self, 0);
	_g_object_unref0 (filter);
}


void main_window_save_state (MainWindow* self, gboolean sync) {
	GSettings* settings_window;
	GdkWindowState state;
	gint w = 0;
	gint h = 0;
	GSettings* settings_ui;
	GtkToggleAction* action;
	GtkToggleAction* _tmp0_;
	GtkToggleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	settings_window = g_settings_new ("org.gnome.latexila.state.window");
	state = gdk_window_get_state (gtk_widget_get_window ((GtkWidget*) self));
	g_settings_set_int (settings_window, "state", (gint) state);
	gtk_window_get_size ((GtkWindow*) self, &w, &h);
	if ((state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		w = w - 100;
		h = h - 100;
	}
	g_settings_set (settings_window, "size", "(ii)", w, h);
	g_settings_set_int (settings_window, "side-panel-size", gtk_paned_get_position ((GtkPaned*) self->priv->main_hpaned));
	g_settings_set_int (settings_window, "vertical-paned-position", gtk_paned_get_position ((GtkPaned*) self->priv->vpaned));
	settings_ui = g_settings_new ("org.gnome.latexila.preferences.ui");
	action = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewEditToolbar")));
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", gtk_toggle_action_get_active (action));
	action = (_tmp0_ = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewSidePanel"))), _g_object_unref0 (action), _tmp0_);
	g_settings_set_boolean (settings_ui, "side-panel-visible", gtk_toggle_action_get_active (action));
	action = (_tmp1_ = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_action_group_get_action (self->priv->action_group, "ViewBottomPanel"))), _g_object_unref0 (action), _tmp1_);
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", gtk_toggle_action_get_active (action));
	g_settings_set_int (settings_ui, "side-panel-component", side_panel_get_active_component (self->priv->side_panel));
	if (sync) {
		g_settings_sync ();
		g_settings_sync ();
	}
	_g_object_unref0 (action);
	_g_object_unref0 (settings_ui);
	_g_object_unref0 (settings_window);
}


static void main_window_move_tab_to_new_window (MainWindow* self, DocumentTab* tab) {
	Application* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* new_window;
	DocumentView* view;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	new_window = (_tmp1_ = application_create_window (_tmp0_ = application_get_default (), NULL), _g_object_unref0 (_tmp0_), _tmp1_);
	view = _g_object_ref0 (document_tab_get_view (tab));
	documents_panel_remove_tab (self->priv->documents_panel, tab);
	main_window_create_tab_with_view (new_window, view);
	_g_object_unref0 (view);
	_g_object_unref0 (new_window);
}


static void _main_window_build_tools_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_build_tools_menu_activate (self, _sender);
}


void main_window_update_build_tools_menu (MainWindow* self) {
	AppSettings* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* build_tools;
	guint _tmp3_ = 0U;
	guint id;
	gint i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools_action_group != NULL);
	if (self->priv->build_tools_menu_ui_id != 0) {
		gtk_ui_manager_remove_ui (self->priv->ui_manager, self->priv->build_tools_menu_ui_id);
	}
	{
		GList* action_collection;
		GList* action_it;
		action_collection = gtk_action_group_list_actions (self->priv->build_tools_action_group);
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* action;
			action = _g_object_ref0 ((GtkAction*) action_it->data);
			{
				guint _tmp0_;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp0_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (action, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _main_window_build_tools_menu_activate_gtk_action_activate, self);
				gtk_action_group_remove_action (self->priv->build_tools_action_group, action);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	build_tools = (_tmp2_ = app_settings_get_build_tools (_tmp1_ = app_settings_get_default ()), _g_object_unref0 (_tmp1_), _tmp2_);
	if (gee_collection_get_size ((GeeCollection*) build_tools) > 0) {
		_tmp3_ = gtk_ui_manager_new_merge_id (self->priv->ui_manager);
	} else {
		_tmp3_ = (guint) 0;
	}
	id = _tmp3_;
	i = 0;
	{
		GeeIterator* _build_tool_it;
		_build_tool_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) build_tools);
		while (TRUE) {
			BuildTool* _tmp4_;
			BuildTool _tmp5_ = {0};
			BuildTool _tmp6_;
			BuildTool build_tool;
			char* _tmp7_;
			char* _tmp8_;
			char* action_name;
			GtkAction* action;
			char* _tmp9_;
			char* accel;
			if (!gee_iterator_next (_build_tool_it)) {
				break;
			}
			build_tool = (_tmp6_ = (build_tool_copy (_tmp4_ = (BuildTool*) gee_iterator_get (_build_tool_it), &_tmp5_), _tmp5_), _build_tool_free0 (_tmp4_), _tmp6_);
			action_name = (_tmp8_ = g_strconcat ("BuildTool_", _tmp7_ = g_strdup_printf ("%i", i), NULL), _g_free0 (_tmp7_), _tmp8_);
			action = gtk_action_new (action_name, build_tool.label, build_tool.description, build_tool.icon);
			_tmp9_ = NULL;
			if (i < 10) {
				char* _tmp10_;
				_tmp9_ = (_tmp10_ = g_strdup_printf ("<Release>F%d", i + 2), _g_free0 (_tmp9_), _tmp10_);
			} else {
				char* _tmp11_;
				_tmp9_ = (_tmp11_ = NULL, _g_free0 (_tmp9_), _tmp11_);
			}
			accel = g_strdup (_tmp9_);
			gtk_action_group_add_action_with_accel (self->priv->build_tools_action_group, action, accel);
			g_signal_connect_object (action, "activate", (GCallback) _main_window_build_tools_menu_activate_gtk_action_activate, self, 0);
			gtk_ui_manager_add_ui (self->priv->ui_manager, id, "/MainMenu/BuildMenu/BuildToolsPlaceholder", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
			gtk_ui_manager_add_ui (self->priv->ui_manager, id, "/MainToolbar/BuildToolsPlaceholder2", action_name, action_name, GTK_UI_MANAGER_TOOLITEM, FALSE);
			i++;
			_g_free0 (accel);
			_g_free0 (_tmp9_);
			_g_object_unref0 (action);
			_g_free0 (action_name);
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_it);
	}
	self->priv->build_tools_menu_ui_id = id;
}


static void _lambda71_ (Block7Data* _data7_) {
	MainWindow * self;
	GFile* _tmp0_;
	self = _data7_->self;
	file_browser_refresh_if_in_dir (self->priv->file_browser, _tmp0_ = g_file_get_parent (_data7_->main_file));
	_g_object_unref0 (_tmp0_);
}


static void __lambda71__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self) {
	_lambda71_ (self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->main_file);
		g_slice_free (Block7Data, _data7_);
	}
}


static void main_window_build_tools_menu_activate (MainWindow* self, GtkAction* action) {
	Block7Data* _data7_;
	gint _name_length1;
	gint __name_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** _name;
	gint i;
	AppSettings* _tmp2_;
	GeeLinkedList* _tmp3_;
	GeeLinkedList* build_tools;
	BuildTool* _tmp4_;
	BuildTool _tmp5_ = {0};
	BuildTool _tmp6_;
	BuildTool tool;
	BuildToolRunner* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	g_return_if_fail (document_get_location (main_window_get_active_document (self)) != NULL);
	_name = (_tmp1_ = _tmp0_ = g_strsplit (gtk_action_get_name (action), "_", 0), _name_length1 = _vala_array_length (_tmp0_), __name_size_ = _name_length1, _tmp1_);
	i = atoi (_name[1]);
	build_tools = (_tmp3_ = app_settings_get_build_tools (_tmp2_ = app_settings_get_default ()), _g_object_unref0 (_tmp2_), _tmp3_);
	tool = (_tmp6_ = (build_tool_copy (_tmp4_ = (BuildTool*) gee_abstract_list_get ((GeeAbstractList*) build_tools, i), &_tmp5_), _tmp5_), _build_tool_free0 (_tmp4_), _tmp6_);
	build_view_show (self->priv->build_view);
	if (tool.compilation) {
		gint num;
		num = document_get_project_id (main_window_get_active_document (self));
		if (num == (-1)) {
			document_save (main_window_get_active_document (self), TRUE, FALSE);
		} else {
			Application* _tmp7_;
			GList* _tmp8_;
			GList* docs;
			docs = (_tmp8_ = application_get_documents (_tmp7_ = application_get_default ()), _g_object_unref0 (_tmp7_), _tmp8_);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = docs;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* doc;
					doc = _g_object_ref0 ((Document*) doc_it->data);
					{
						if (document_get_project_id (doc) == num) {
							document_save (doc, TRUE, FALSE);
						}
						_g_object_unref0 (doc);
					}
				}
			}
			__g_list_free_g_object_unref0 (docs);
		}
	}
	_data7_->main_file = document_get_main_file (main_window_get_active_document (self));
	self->priv->build_tool_runner = (_tmp9_ = build_tool_runner_new (_data7_->main_file, &tool, self->priv->build_view, self->priv->action_stop_exec), _g_object_unref0 (self->priv->build_tool_runner), _tmp9_);
	if (tool.compilation) {
		g_signal_connect_data (self->priv->build_tool_runner, "finished", (GCallback) __lambda71__build_tool_runner_finished, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	}
	build_tool_destroy (&tool);
	_name = (_vala_array_free (_name, _name_length1, (GDestroyNotify) g_free), NULL);
	block7_data_unref (_data7_);
}


GtkAction* main_window_get_action_stop_exec (MainWindow* self) {
	GtkAction* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (self->priv->action_stop_exec);
	return result;
}


static void _main_window_documents_list_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_documents_list_menu_activate (self, _sender);
}


static void main_window_update_documents_list_menu (MainWindow* self) {
	gint n;
	guint _tmp1_ = 0U;
	guint id;
	GSList* group;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->documents_list_action_group != NULL);
	if (self->priv->documents_list_menu_ui_id != 0) {
		gtk_ui_manager_remove_ui (self->priv->ui_manager, self->priv->documents_list_menu_ui_id);
	}
	{
		GList* action_collection;
		GList* action_it;
		action_collection = gtk_action_group_list_actions (self->priv->documents_list_action_group);
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* action;
			action = _g_object_ref0 ((GtkAction*) action_it->data);
			{
				guint _tmp0_;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp0_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (action, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _main_window_documents_list_menu_activate_gtk_action_activate, self);
				gtk_action_group_remove_action (self->priv->documents_list_action_group, action);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	n = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	if (n > 0) {
		_tmp1_ = gtk_ui_manager_new_merge_id (self->priv->ui_manager);
	} else {
		_tmp1_ = (guint) 0;
	}
	id = _tmp1_;
	group = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				DocumentTab* tab;
				char* action_name;
				char* _tmp3_;
				char* _tmp4_;
				char* name;
				char* tip;
				char* _tmp5_;
				char* accel;
				GtkRadioAction* action;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < n)) {
					break;
				}
				tab = _g_object_ref0 (DOCUMENT_TAB (gtk_notebook_get_nth_page ((GtkNotebook*) self->priv->documents_panel, i)));
				action_name = g_strdup_printf ("Tab_%d", i);
				name = (_tmp4_ = string_replace (_tmp3_ = document_tab_get_name (tab), "_", "__"), _g_free0 (_tmp3_), _tmp4_);
				tip = document_tab_get_menu_tip (tab);
				_tmp5_ = NULL;
				if (i < 10) {
					char* _tmp6_;
					_tmp5_ = (_tmp6_ = g_strdup_printf ("<alt>%d", (i + 1) % 10), _g_free0 (_tmp5_), _tmp6_);
				} else {
					char* _tmp7_;
					_tmp5_ = (_tmp7_ = NULL, _g_free0 (_tmp5_), _tmp7_);
				}
				accel = g_strdup (_tmp5_);
				action = gtk_radio_action_new (action_name, name, tip, NULL, i);
				if (group != NULL) {
					gtk_radio_action_set_group (action, group);
				}
				group = gtk_radio_action_get_group (action);
				gtk_action_group_add_action_with_accel (self->priv->documents_list_action_group, (GtkAction*) action, accel);
				g_signal_connect_object ((GtkAction*) action, "activate", (GCallback) _main_window_documents_list_menu_activate_gtk_action_activate, self, 0);
				gtk_ui_manager_add_ui (self->priv->ui_manager, id, "/MainMenu/DocumentsMenu/DocumentsListPlaceholder", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
				if (tab == main_window_get_active_tab (self)) {
					gtk_toggle_action_set_active ((GtkToggleAction*) action, TRUE);
				}
				_g_object_unref0 (action);
				_g_free0 (accel);
				_g_free0 (_tmp5_);
				_g_free0 (tip);
				_g_free0 (name);
				_g_free0 (action_name);
				_g_object_unref0 (tab);
			}
		}
	}
	self->priv->documents_list_menu_ui_id = id;
}


static void main_window_documents_list_menu_activate (MainWindow* self, GtkAction* action) {
	GtkRadioAction* radio_action;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	radio_action = _g_object_ref0 (GTK_RADIO_ACTION (action));
	if (!gtk_toggle_action_get_active ((GtkToggleAction*) radio_action)) {
		_g_object_unref0 (radio_action);
		return;
	}
	gtk_notebook_set_current_page ((GtkNotebook*) self->priv->documents_panel, gtk_radio_action_get_current_value (radio_action));
	_g_object_unref0 (radio_action);
}


/*****************************
     *    ACTIONS SENSITIVITY    *
     *****************************/
static void main_window_set_file_actions_sensitivity (MainWindow* self, gboolean sensitive) {
	gint file_actions_length1;
	gint _file_actions_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** file_actions;
	g_return_if_fail (self != NULL);
	file_actions = (_tmp1_ = (_tmp0_ = g_new0 (char*, 26 + 1), _tmp0_[0] = g_strdup ("FileSave"), _tmp0_[1] = g_strdup ("FileSaveAs"), _tmp0_[2] = g_strdup ("FileClose"), _tmp0_[3] = g_strdup ("EditUndo"), _tmp0_[4] = g_strdup ("EditRedo"), _tmp0_[5] = g_strdup ("EditCut"), _tmp0_[6] = g_strdup ("EditCopy"), _tmp0_[7] = g_strdup ("EditPaste"), _tmp0_[8] = g_strdup ("EditDelete"), _tmp0_[9] = g_strdup ("EditSelectAll"), _tmp0_[10] = g_strdup ("EditComment"), _tmp0_[11] = g_strdup ("EditUncomment"), _tmp0_[12] = g_strdup ("ViewZoomIn"), _tmp0_[13] = g_strdup ("ViewZoomOut"), _tmp0_[14] = g_strdup ("ViewZoomReset"), _tmp0_[15] = g_strdup ("DocumentsSaveAll"), _tmp0_[16] = g_strdup ("DocumentsCloseAll"), _tmp0_[17] = g_strdup ("DocumentsPrevious"), _tmp0_[18] = g_strdup ("DocumentsNext"), _tmp0_[19] = g_strdup ("SearchFind"), _tmp0_[20] = g_strdup ("SearchReplace"), _tmp0_[21] = g_strdup ("SearchGoToLine"), _tmp0_[22] = g_strdup ("BuildClean"), _tmp0_[23] = g_strdup ("BuildViewLog"), _tmp0_[24] = g_strdup ("ProjectsConfigCurrent"), _tmp0_[25] = g_strdup ("FileCreateTemplate"), _tmp0_), file_actions_length1 = 26, _file_actions_size_ = file_actions_length1, _tmp1_);
	{
		char** file_action_collection;
		int file_action_collection_length1;
		int file_action_it;
		file_action_collection = file_actions;
		file_action_collection_length1 = file_actions_length1;
		for (file_action_it = 0; file_action_it < file_actions_length1; file_action_it = file_action_it + 1) {
			char* file_action;
			file_action = g_strdup (file_action_collection[file_action_it]);
			{
				GtkAction* action;
				action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, file_action));
				gtk_action_set_sensitive (action, sensitive);
				_g_object_unref0 (action);
				_g_free0 (file_action);
			}
		}
	}
	gtk_action_group_set_sensitive (self->priv->latex_action_group, sensitive);
	gtk_action_group_set_sensitive (self->priv->build_tools_action_group, sensitive);
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
}


static void main_window_set_undo_sensitivity (MainWindow* self) {
	g_return_if_fail (self != NULL);
	if (main_window_get_active_tab (self) != NULL) {
		GtkAction* action;
		gboolean _tmp0_;
		action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "EditUndo"));
		gtk_action_set_sensitive (action, (g_object_get ((GtkSourceBuffer*) main_window_get_active_document (self), "can-undo", &_tmp0_, NULL), _tmp0_));
		_g_object_unref0 (action);
	}
}


static void main_window_set_redo_sensitivity (MainWindow* self) {
	g_return_if_fail (self != NULL);
	if (main_window_get_active_tab (self) != NULL) {
		GtkAction* action;
		gboolean _tmp0_;
		action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "EditRedo"));
		gtk_action_set_sensitive (action, (g_object_get ((GtkSourceBuffer*) main_window_get_active_document (self), "can-redo", &_tmp0_, NULL), _tmp0_));
		_g_object_unref0 (action);
	}
}


static void main_window_set_documents_move_to_new_window_sensitivity (MainWindow* self, gboolean sensitive) {
	GtkAction* action;
	g_return_if_fail (self != NULL);
	action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "DocumentsMoveToNewWindow"));
	gtk_action_set_sensitive (action, sensitive);
	_g_object_unref0 (action);
}


static void main_window_update_next_prev_doc_sensitivity (MainWindow* self) {
	g_return_if_fail (self != NULL);
	if (main_window_get_active_tab (self) != NULL) {
		GtkAction* action_previous;
		GtkAction* action_next;
		gint current_page;
		gint nb_pages;
		action_previous = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "DocumentsPrevious"));
		action_next = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "DocumentsNext"));
		current_page = gtk_notebook_page_num ((GtkNotebook*) self->priv->documents_panel, (GtkWidget*) main_window_get_active_tab (self));
		gtk_action_set_sensitive (action_previous, current_page > 0);
		nb_pages = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
		gtk_action_set_sensitive (action_next, current_page < (nb_pages - 1));
		_g_object_unref0 (action_next);
		_g_object_unref0 (action_previous);
	}
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void main_window_update_build_tools_sensitivity (MainWindow* self) {
	GtkAction* clean_action;
	GtkAction* view_log_action;
	gboolean _tmp0_ = FALSE;
	char* _tmp1_;
	char* _tmp2_;
	char* ext;
	AppSettings* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* tools;
	gint i;
	g_return_if_fail (self != NULL);
	clean_action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "BuildClean"));
	view_log_action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, "BuildViewLog"));
	if (main_window_get_active_tab (self) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = document_get_location (main_window_get_active_document (self)) == NULL;
	}
	if (_tmp0_) {
		gtk_action_group_set_sensitive (self->priv->build_tools_action_group, FALSE);
		gtk_action_set_sensitive (clean_action, FALSE);
		gtk_action_set_sensitive (view_log_action, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		return;
	} else {
		gboolean is_tex;
		gtk_action_group_set_sensitive (self->priv->build_tools_action_group, TRUE);
		is_tex = document_is_tex_document (main_window_get_active_document (self));
		gtk_action_set_sensitive (clean_action, is_tex);
		gtk_action_set_sensitive (view_log_action, is_tex);
	}
	ext = (_tmp2_ = utils_get_extension (_tmp1_ = g_file_get_parse_name (document_get_location (main_window_get_active_document (self)))), _g_free0 (_tmp1_), _tmp2_);
	tools = (_tmp4_ = app_settings_get_build_tools (_tmp3_ = app_settings_get_default ()), _g_object_unref0 (_tmp3_), _tmp4_);
	i = 0;
	{
		GeeIterator* _tool_it;
		_tool_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) tools);
		while (TRUE) {
			BuildTool* _tmp5_;
			BuildTool _tmp6_ = {0};
			BuildTool _tmp7_;
			BuildTool tool;
			gint extensions_length1;
			gint _extensions_size_;
			char** _tmp9_;
			char** _tmp8_;
			char** extensions;
			gboolean _tmp10_ = FALSE;
			gboolean sensitive;
			char* _tmp11_;
			char* _tmp12_;
			GtkAction* _tmp13_;
			GtkAction* action;
			if (!gee_iterator_next (_tool_it)) {
				break;
			}
			tool = (_tmp7_ = (build_tool_copy (_tmp5_ = (BuildTool*) gee_iterator_get (_tool_it), &_tmp6_), _tmp6_), _build_tool_free0 (_tmp5_), _tmp7_);
			extensions = (_tmp9_ = _tmp8_ = g_strsplit (tool.extensions, " ", 0), extensions_length1 = _vala_array_length (_tmp8_), _extensions_size_ = extensions_length1, _tmp9_);
			if (string_get_length (tool.extensions) == 0) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = _vala_string_array_contains (extensions, extensions_length1, ext);
			}
			sensitive = _tmp10_;
			action = (_tmp13_ = _g_object_ref0 (gtk_action_group_get_action (self->priv->build_tools_action_group, _tmp12_ = g_strconcat ("BuildTool_", _tmp11_ = g_strdup_printf ("%i", i), NULL))), _g_free0 (_tmp12_), _g_free0 (_tmp11_), _tmp13_);
			gtk_action_set_sensitive (action, sensitive);
			i++;
			_g_object_unref0 (action);
			extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	_g_free0 (ext);
	_g_object_unref0 (view_log_action);
	_g_object_unref0 (clean_action);
}


static void main_window_selection_changed (MainWindow* self) {
	g_return_if_fail (self != NULL);
	if (main_window_get_active_tab (self) != NULL) {
		gboolean has_selection;
		gint selection_actions_length1;
		gint _selection_actions_size_;
		char** _tmp1_;
		char** _tmp0_ = NULL;
		char** selection_actions;
		has_selection = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) main_window_get_active_document (self));
		selection_actions = (_tmp1_ = (_tmp0_ = g_new0 (char*, 3 + 1), _tmp0_[0] = g_strdup ("EditCut"), _tmp0_[1] = g_strdup ("EditCopy"), _tmp0_[2] = g_strdup ("EditDelete"), _tmp0_), selection_actions_length1 = 3, _selection_actions_size_ = selection_actions_length1, _tmp1_);
		{
			char** selection_action_collection;
			int selection_action_collection_length1;
			int selection_action_it;
			selection_action_collection = selection_actions;
			selection_action_collection_length1 = selection_actions_length1;
			for (selection_action_it = 0; selection_action_it < selection_actions_length1; selection_action_it = selection_action_it + 1) {
				char* selection_action;
				selection_action = g_strdup (selection_action_collection[selection_action_it]);
				{
					GtkAction* action;
					action = _g_object_ref0 (gtk_action_group_get_action (self->priv->action_group, selection_action));
					gtk_action_set_sensitive (action, has_selection);
					_g_object_unref0 (action);
					_g_free0 (selection_action);
				}
			}
		}
		selection_actions = (_vala_array_free (selection_actions, selection_actions_length1, (GDestroyNotify) g_free), NULL);
	}
}


/*******************
     *    CALLBACKS
     ******************/
void main_window_on_file_new (MainWindow* self) {
	Templates* _tmp0_;
	g_return_if_fail (self != NULL);
	templates_show_dialog_new (_tmp0_ = templates_get_default (), self);
	_g_object_unref0 (_tmp0_);
}


void main_window_on_new_window (MainWindow* self) {
	Application* _tmp0_;
	MainWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = application_create_window (_tmp0_ = application_get_default (), NULL);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


void main_window_on_file_open (MainWindow* self) {
	GtkFileChooserDialog* file_chooser;
	GSList* files_to_open;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	file_chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Open Files"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL));
	if (self->priv->file_chooser_current_folder != NULL) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) file_chooser, self->priv->file_chooser_current_folder);
	}
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) file_chooser, TRUE);
	files_to_open = NULL;
	if (gtk_dialog_run ((GtkDialog*) file_chooser) == GTK_RESPONSE_ACCEPT) {
		GSList* _tmp0_;
		files_to_open = (_tmp0_ = gtk_file_chooser_get_files ((GtkFileChooser*) file_chooser), __g_slist_free_g_object_unref0 (files_to_open), _tmp0_);
	}
	self->priv->file_chooser_current_folder = (_tmp1_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) file_chooser), _g_free0 (self->priv->file_chooser_current_folder), _tmp1_);
	gtk_object_destroy ((GtkObject*) file_chooser);
	{
		GSList* file_collection;
		GSList* file_it;
		file_collection = files_to_open;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* file;
			file = _g_object_ref0 ((GFile*) file_it->data);
			{
				DocumentTab* _tmp2_;
				_tmp2_ = main_window_open_document (self, file);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (file);
			}
		}
	}
	__g_slist_free_g_object_unref0 (files_to_open);
	_g_object_unref0 (file_chooser);
}


void main_window_on_file_save (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	main_window_save_document (self, main_window_get_active_document (self), FALSE);
}


void main_window_on_file_save_as (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	main_window_save_document (self, main_window_get_active_document (self), TRUE);
}


void main_window_on_create_template (MainWindow* self) {
	Templates* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	templates_show_dialog_create (_tmp0_ = templates_get_default (), self);
	_g_object_unref0 (_tmp0_);
}


void main_window_on_delete_template (MainWindow* self) {
	Templates* _tmp0_;
	g_return_if_fail (self != NULL);
	templates_show_dialog_delete (_tmp0_ = templates_get_default (), self);
	_g_object_unref0 (_tmp0_);
}


void main_window_on_file_close (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	main_window_close_tab (self, main_window_get_active_tab (self), FALSE);
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void main_window_on_quit (MainWindow* self) {
	gint list_uris_length1;
	gint _list_uris_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** list_uris;
	GSettings* settings;
	g_return_if_fail (self != NULL);
	list_uris = (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), list_uris_length1 = 0, _list_uris_size_ = list_uris_length1, _tmp1_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = main_window_get_documents (self);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (document_get_location (doc) != NULL) {
					_vala_array_add2 (&list_uris, &list_uris_length1, &_list_uris_size_, g_file_get_uri (document_get_location (doc)));
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
	settings = g_settings_new ("org.gnome.latexila.state.window");
	g_settings_set_strv (settings, "documents", list_uris);
	if (main_window_close_all_documents (self)) {
		main_window_save_state (self, FALSE);
		gtk_object_destroy ((GtkObject*) self);
	}
	_g_object_unref0 (settings);
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
}


void main_window_on_edit_undo (MainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	if ((g_object_get ((GtkSourceBuffer*) main_window_get_active_document (self), "can-undo", &_tmp0_, NULL), _tmp0_)) {
		gtk_source_buffer_undo ((GtkSourceBuffer*) main_window_get_active_document (self));
		document_view_scroll_to_cursor (main_window_get_active_view (self), 0.25);
		gtk_widget_grab_focus ((GtkWidget*) main_window_get_active_view (self));
	}
}


void main_window_on_edit_redo (MainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	if ((g_object_get ((GtkSourceBuffer*) main_window_get_active_document (self), "can-redo", &_tmp0_, NULL), _tmp0_)) {
		gtk_source_buffer_redo ((GtkSourceBuffer*) main_window_get_active_document (self));
		document_view_scroll_to_cursor (main_window_get_active_view (self), 0.25);
		gtk_widget_grab_focus ((GtkWidget*) main_window_get_active_view (self));
	}
}


void main_window_on_edit_cut (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_cut_selection (main_window_get_active_view (self));
}


void main_window_on_edit_copy (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_copy_selection (main_window_get_active_view (self));
}


void main_window_on_edit_paste (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_my_paste_clipboard (main_window_get_active_view (self));
}


void main_window_on_edit_delete (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_delete_selection (main_window_get_active_view (self));
}


void main_window_on_edit_select_all (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_my_select_all (main_window_get_active_view (self));
}


void main_window_on_edit_comment (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_comment_selected_lines (main_window_get_active_document (self));
}


void main_window_on_edit_uncomment (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_uncomment_selected_lines (main_window_get_active_document (self));
}


void main_window_on_open_preferences (MainWindow* self) {
	g_return_if_fail (self != NULL);
	preferences_dialog_show_me (self);
}


void main_window_on_show_side_panel (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	show = gtk_toggle_action_get_active ((_tmp0_ = action, GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL));
	if (show) {
		gtk_widget_show ((GtkWidget*) self->priv->side_panel);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->side_panel);
	}
}


void main_window_on_show_bottom_panel (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	show = gtk_toggle_action_get_active ((_tmp0_ = action, GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL));
	if (show) {
		gtk_widget_show_all ((GtkWidget*) self->priv->build_view);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->build_view);
	}
}


void main_window_on_show_edit_toolbar (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	show = gtk_toggle_action_get_active ((_tmp0_ = action, GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL));
	if (show) {
		gtk_widget_show_all ((GtkWidget*) self->priv->edit_toolbar);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->edit_toolbar);
	}
}


void main_window_on_view_zoom_in (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_enlarge_font (main_window_get_active_view (self));
}


void main_window_on_view_zoom_out (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_shrink_font (main_window_get_active_view (self));
}


void main_window_on_view_zoom_reset (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	document_view_set_font_from_settings (main_window_get_active_view (self));
}


void main_window_on_search_find (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	search_and_replace_show_search (self->priv->search_and_replace);
}


void main_window_on_search_replace (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	search_and_replace_show_search_and_replace (self->priv->search_and_replace);
}


void main_window_on_search_goto_line (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	goto_line_show (self->priv->goto_line);
}


void main_window_on_build_stop_execution (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tool_runner != NULL);
	build_tool_process_abort ((BuildToolProcess*) self->priv->build_tool_runner);
	build_view_show (self->priv->build_view);
}


void main_window_on_build_clean (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	if (document_clean_build_files (main_window_get_active_document (self), self)) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		file_browser_refresh_if_in_dir (self->priv->file_browser, _tmp1_ = g_file_get_parent (_tmp0_ = document_get_main_file (main_window_get_active_document (self))));
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (_tmp0_);
	}
}


void main_window_on_build_view_log (MainWindow* self) {
	GFile* mainfile;
	GFile* directory;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* basename;
	GFile* file;
	DocumentTab* tab;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	g_return_if_fail (document_is_tex_document (main_window_get_active_document (self)));
	mainfile = document_get_main_file (main_window_get_active_document (self));
	directory = g_file_get_parent (mainfile);
	basename = (_tmp2_ = g_strconcat (_tmp1_ = utils_get_shortname (_tmp0_ = g_file_get_basename (mainfile)), ".log", NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	file = g_file_get_child (directory, basename);
	tab = main_window_open_document (self, file);
	if (tab == NULL) {
		fprintf (stderr, "Warning: impossible to view log\n");
	} else {
		document_set_readonly (document_tab_get_document (tab), TRUE);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
}


void main_window_on_documents_save_all (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = main_window_get_unsaved_documents (self);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				main_window_set_active_tab (self, doc->tab);
				document_save (doc, TRUE, FALSE);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
}


void main_window_on_documents_close_all (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	main_window_close_all_documents (self);
}


void main_window_on_documents_previous (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	gtk_notebook_prev_page ((GtkNotebook*) self->priv->documents_panel);
}


void main_window_on_documents_next (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	gtk_notebook_next_page ((GtkNotebook*) self->priv->documents_panel);
}


void main_window_on_documents_move_to_new_window (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	main_window_move_tab_to_new_window (self, main_window_get_active_tab (self));
}


void main_window_on_projects_new (MainWindow* self) {
	g_return_if_fail (self != NULL);
	projects_new_project (self);
}


void main_window_on_projects_config_current (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self) != NULL);
	g_return_if_fail (document_get_project_id (main_window_get_active_document (self)) != (-1));
	projects_configure_project ((GtkWindow*) self, document_get_project_id (main_window_get_active_document (self)));
}


void main_window_on_projects_manage (MainWindow* self) {
	g_return_if_fail (self != NULL);
	projects_manage_projects (self);
}


void main_window_on_help_latex_reference (MainWindow* self) {
	GFile* file;
	BuildToolRunner* _tmp0_;
	g_return_if_fail (self != NULL);
	file = g_file_new_for_path (DATA_DIR "/latexhelp.html");
	_tmp0_ = build_tool_runner_new_web_browser (file, _ ("View LaTeX Reference"), self->priv->build_view, self->priv->action_stop_exec);
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (file);
}


void main_window_on_about_dialog (MainWindow* self) {
	char* comments;
	char* copyright;
	char* licence;
	char* website;
	gint authors_length1;
	gint _authors_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** authors;
	gint artists_length1;
	gint _artists_size_;
	char** _tmp3_;
	char** _tmp2_ = NULL;
	char** artists;
	GdkPixbuf* logo;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	comments = g_strdup (_ ("LaTeXila is an Integrated LaTeX Environment for the GNOME Desktop"));
	copyright = g_strdup ("Copyright (C) 2009-2011 Sébastien Wilmet");
	licence = g_strdup ("LaTeXila is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"LaTeXila is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.");
	website = g_strdup ("http://latexila.sourceforge.net/");
	authors = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("Sébastien Wilmet <sebastien.wilmet@gmail.com>"), _tmp0_[1] = NULL, _tmp0_), authors_length1 = 2, _authors_size_ = authors_length1, _tmp1_);
	artists = (_tmp3_ = (_tmp2_ = g_new0 (char*, 6 + 1), _tmp2_[0] = g_strdup ("Ann Melnichuk <melnichu@qtp.ufl.edu>"), _tmp2_[1] = g_strdup ("Eric Forgeot <e.forgeot@laposte.net>"), _tmp2_[2] = g_strdup ("Sébastien Wilmet <sebastien.wilmet@gmail.com>"), _tmp2_[3] = g_strdup ("The Kile Team: http://kile.sourceforge.net/"), _tmp2_[4] = g_strdup ("Gedit LaTeX Plugin: http://www.michaels-website.de/gedit-latex-plugin/"), _tmp2_[5] = NULL, _tmp2_), artists_length1 = 6, _artists_size_ = artists_length1, _tmp3_);
	logo = NULL;
	{
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = gdk_pixbuf_new_from_file (DATA_DIR "/images/app/logo.png", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		logo = (_tmp5_ = _tmp4_, _g_object_unref0 (logo), _tmp5_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Error with the logo: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (logo);
		artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
		authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (website);
		_g_free0 (licence);
		_g_free0 (copyright);
		_g_free0 (comments);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", "LaTeXila", "version", APP_VERSION, "authors", authors, "artists", artists, "comments", comments, "copyright", copyright, "license", licence, "title", _ ("About LaTeXila"), "translator-credits", _ ("translator-credits"), "website", website, "logo", logo, NULL, NULL);
	_g_object_unref0 (logo);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (website);
	_g_free0 (licence);
	_g_free0 (copyright);
	_g_free0 (comments);
}


DocumentTab* main_window_get_active_tab (MainWindow* self) {
	DocumentTab* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel) == 0) {
		result = NULL;
		return result;
	}
	result = documents_panel_get_active_tab (self->priv->documents_panel);
	return result;
}


void main_window_set_active_tab (MainWindow* self, DocumentTab* value) {
	gint n;
	g_return_if_fail (self != NULL);
	n = gtk_notebook_page_num ((GtkNotebook*) self->priv->documents_panel, (GtkWidget*) value);
	if (n != (-1)) {
		gtk_notebook_set_current_page ((GtkNotebook*) self->priv->documents_panel, n);
	}
	g_object_notify ((GObject *) self, "active-tab");
}


DocumentView* main_window_get_active_view (MainWindow* self) {
	DocumentView* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (main_window_get_active_tab (self) == NULL) {
		result = NULL;
		return result;
	}
	result = document_tab_get_view (main_window_get_active_tab (self));
	return result;
}


Document* main_window_get_active_document (MainWindow* self) {
	Document* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (main_window_get_active_tab (self) == NULL) {
		result = NULL;
		return result;
	}
	result = document_tab_get_document (main_window_get_active_tab (self));
	return result;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB, g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW, g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT, g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->file_chooser_current_folder = g_strdup (g_get_home_dir ());
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = MAIN_WINDOW (obj);
	_g_free0 (self->priv->file_chooser_current_folder);
	_g_object_unref0 (self->priv->documents_panel);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->goto_line);
	_g_object_unref0 (self->priv->search_and_replace);
	_g_object_unref0 (self->priv->build_view);
	_g_object_unref0 (self->priv->edit_toolbar);
	_g_object_unref0 (self->priv->side_panel);
	_g_object_unref0 (self->priv->symbols);
	_g_object_unref0 (self->priv->file_browser);
	_g_object_unref0 (self->priv->main_hpaned);
	_g_object_unref0 (self->priv->vpaned);
	_g_object_unref0 (self->priv->ui_manager);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->latex_action_group);
	_g_object_unref0 (self->priv->documents_list_action_group);
	_g_object_unref0 (self->priv->build_tools_action_group);
	_g_object_unref0 (self->priv->build_tool_runner);
	_g_object_unref0 (self->priv->action_stop_exec);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = MAIN_WINDOW (object);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB:
		g_value_set_object (value, main_window_get_active_tab (self));
		break;
		case MAIN_WINDOW_ACTIVE_VIEW:
		g_value_set_object (value, main_window_get_active_view (self));
		break;
		case MAIN_WINDOW_ACTIVE_DOCUMENT:
		g_value_set_object (value, main_window_get_active_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = MAIN_WINDOW (object);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB:
		main_window_set_active_tab (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




