/* build_tools.c generated by valac 0.10.2, the Vala compiler
 * generated from build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUILD_TOOL_PROCESS (build_tool_process_get_type ())
#define BUILD_TOOL_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_PROCESS, BuildToolProcess))
#define BUILD_TOOL_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_PROCESS, BuildToolProcessClass))
#define IS_BUILD_TOOL_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_PROCESS))
#define IS_BUILD_TOOL_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_PROCESS))
#define BUILD_TOOL_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_PROCESS, BuildToolProcessClass))

typedef struct _BuildToolProcess BuildToolProcess;
typedef struct _BuildToolProcessClass BuildToolProcessClass;
typedef struct _BuildToolProcessPrivate BuildToolProcessPrivate;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
typedef struct _BuildToolRunnerPrivate BuildToolRunnerPrivate;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_PARTITION_STATE (partition_state_get_type ())

#define TYPE_BUILD_ISSUE (build_issue_get_type ())

#define TYPE_BUILD_MESSAGE_TYPE (build_message_type_get_type ())
typedef struct _BuildIssue BuildIssue;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POST_PROCESSOR, PostProcessorIface))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorIface PostProcessorIface;

#define TYPE_GENERIC_POST_PROCESSOR (generic_post_processor_get_type ())
#define GENERIC_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERIC_POST_PROCESSOR, GenericPostProcessor))
#define GENERIC_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERIC_POST_PROCESSOR, GenericPostProcessorClass))
#define IS_GENERIC_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERIC_POST_PROCESSOR))
#define IS_GENERIC_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERIC_POST_PROCESSOR))
#define GENERIC_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERIC_POST_PROCESSOR, GenericPostProcessorClass))

typedef struct _GenericPostProcessor GenericPostProcessor;
typedef struct _GenericPostProcessorClass GenericPostProcessorClass;

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
typedef struct _GenericPostProcessorPrivate GenericPostProcessorPrivate;
typedef struct _RubberPostProcessorPrivate RubberPostProcessorPrivate;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

struct _BuildToolProcess {
	GObject parent_instance;
	BuildToolProcessPrivate * priv;
};

struct _BuildToolProcessClass {
	GObjectClass parent_class;
	void (*on_stdout) (BuildToolProcess* self, const char* text);
	void (*on_stderr) (BuildToolProcess* self, const char* text);
	void (*on_abort) (BuildToolProcess* self);
	void (*on_exit) (BuildToolProcess* self, gint status);
};

struct _BuildToolProcessPrivate {
	GPid* child_pid;
	guint* handlers;
	gint handlers_length1;
	gint _handlers_size_;
	GIOChannel* out_channel;
	GIOChannel* err_channel;
	gboolean read_output;
};

struct _BuildToolRunner {
	BuildToolProcess parent_instance;
	BuildToolRunnerPrivate * priv;
};

struct _BuildToolRunnerClass {
	BuildToolProcessClass parent_class;
};

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
};

struct _BuildToolRunnerPrivate {
	BuildView* view;
	gboolean compilation;
	char* document_view_program;
	GtkAction* action_stop_exec;
	GFile* file;
	char* filename;
	char* shortname;
	char* directory;
	char* stdout_text;
	char* stderr_text;
	GList* jobs;
	gint job_num;
	BuildJob current_job;
	GtkTreeIter root_partition;
	GtkTreeIter* job_partitions;
	gint job_partitions_length1;
	gint _job_partitions_size_;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MESSAGE_TYPE_ERROR,
	BUILD_MESSAGE_TYPE_WARNING,
	BUILD_MESSAGE_TYPE_BADBOX,
	BUILD_MESSAGE_TYPE_OTHER
} BuildMessageType;

struct _BuildIssue {
	char* message;
	BuildMessageType message_type;
	char* filename;
	gint start_line;
	gint end_line;
};

struct _PostProcessorIface {
	GTypeInterface parent_iface;
	void (*process) (PostProcessor* self, GFile* file, const char* stdout, const char* stderr, gint status);
	BuildIssue* (*get_issues) (PostProcessor* self, int* result_length1);
	gboolean (*get_successful) (PostProcessor* self);
	void (*set_successful) (PostProcessor* self, gboolean value);
};

struct _GenericPostProcessor {
	GObject parent_instance;
	GenericPostProcessorPrivate * priv;
};

struct _GenericPostProcessorClass {
	GObjectClass parent_class;
};

struct _GenericPostProcessorPrivate {
	gboolean _successful;
};

struct _RubberPostProcessor {
	GObject parent_instance;
	RubberPostProcessorPrivate * priv;
};

struct _RubberPostProcessorClass {
	GObjectClass parent_class;
};

struct _RubberPostProcessorPrivate {
	gboolean _successful;
	BuildIssue* issues;
	gint issues_length1;
	gint _issues_size_;
};


static gpointer build_tool_process_parent_class = NULL;
static gpointer build_tool_runner_parent_class = NULL;
static gpointer generic_post_processor_parent_class = NULL;
static PostProcessorIface* generic_post_processor_post_processor_parent_iface = NULL;
static GRegex* rubber_post_processor_pattern;
static GRegex* rubber_post_processor_pattern = NULL;
static gpointer rubber_post_processor_parent_class = NULL;
static PostProcessorIface* rubber_post_processor_post_processor_parent_iface = NULL;

GType build_tool_process_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_PROCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_PROCESS, BuildToolProcessPrivate))
enum  {
	BUILD_TOOL_PROCESS_DUMMY_PROPERTY
};
#define BUILD_TOOL_PROCESS_POLL_INTERVAL 250
void build_tool_process_execute (BuildToolProcess* self, char** command, int command_length1, const char* working_directory, GError** error);
static GPid* _g_pid_dup (GPid* self);
static void _build_tool_process_on_exit (BuildToolProcess* self, GPid pid, gint status);
static void __build_tool_process_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self);
static void _vala_array_add5 (guint** array, int* length, int* size, guint value);
static gboolean _build_tool_process_on_stdout (BuildToolProcess* self);
static gboolean __build_tool_process_on_stdout_gsource_func (gpointer self);
static void _vala_array_add6 (guint** array, int* length, int* size, guint value);
static gboolean _build_tool_process_on_stderr (BuildToolProcess* self);
static gboolean __build_tool_process_on_stderr_gsource_func (gpointer self);
static void _vala_array_add7 (guint** array, int* length, int* size, guint value);
void build_tool_process_execute_without_output (BuildToolProcess* self, char** command, int command_length1, const char* working_directory, GError** error);
static void _vala_array_add8 (guint** array, int* length, int* size, guint value);
void build_tool_process_abort (BuildToolProcess* self);
void build_tool_process_on_abort (BuildToolProcess* self);
void build_tool_process_on_stdout (BuildToolProcess* self, const char* text);
void build_tool_process_on_stderr (BuildToolProcess* self, const char* text);
void build_tool_process_on_exit (BuildToolProcess* self, gint status);
static void build_tool_process_real_on_stdout (BuildToolProcess* self, const char* text);
static void build_tool_process_real_on_stderr (BuildToolProcess* self, const char* text);
static void build_tool_process_real_on_abort (BuildToolProcess* self);
static void build_tool_process_real_on_exit (BuildToolProcess* self, gint status);
BuildToolProcess* build_tool_process_construct (GType object_type);
static void build_tool_process_finalize (GObject* obj);
GType build_tool_runner_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
#define BUILD_TOOL_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerPrivate))
enum  {
	BUILD_TOOL_RUNNER_DUMMY_PROPERTY
};
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
char* utils_get_shortname (const char* path);
char* utils_get_extension (const char* path);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
void build_view_clear (BuildView* self);
GType partition_state_get_type (void) G_GNUC_CONST;
void build_view_add_partition (BuildView* self, const char* msg, PartitionState state, GtkTreeIter* parent, GtkTreeIter* result);
static char** build_tool_runner_get_command (BuildToolRunner* self, BuildJob* build_job, gboolean basename, int* result_length1);
static void _vala_array_add9 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value);
static void build_tool_runner_proceed (BuildToolRunner* self);
BuildToolRunner* build_tool_runner_new_web_browser (GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct_web_browser (GType object_type, GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
GType build_issue_get_type (void) G_GNUC_CONST;
GType build_message_type_get_type (void) G_GNUC_CONST;
BuildIssue* build_issue_dup (const BuildIssue* self);
void build_issue_free (BuildIssue* self);
void build_issue_copy (const BuildIssue* self, BuildIssue* dest);
void build_issue_destroy (BuildIssue* self);
void build_view_append_issues (BuildView* self, GtkTreeIter* partition_id, BuildIssue* issues, int issues_length1);
static void _vala_BuildIssue_array_free (BuildIssue* array, gint array_length);
static void build_tool_runner_failed (BuildToolRunner* self);
static void build_tool_runner_real_on_stdout (BuildToolProcess* base, const char* text);
static void build_tool_runner_real_on_stderr (BuildToolProcess* base, const char* text);
static void build_tool_runner_real_on_abort (BuildToolProcess* base);
static void build_tool_runner_real_on_exit (BuildToolProcess* base, gint status);
GType post_processor_get_type (void) G_GNUC_CONST;
GenericPostProcessor* generic_post_processor_new (void);
GenericPostProcessor* generic_post_processor_construct (GType object_type);
GType generic_post_processor_get_type (void) G_GNUC_CONST;
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
void post_processor_process (PostProcessor* self, GFile* file, const char* stdout, const char* stderr, gint status);
BuildIssue* post_processor_get_issues (PostProcessor* self, int* result_length1);
gboolean post_processor_get_successful (PostProcessor* self);
static void build_tool_runner_finalize (GObject* obj);
void post_processor_set_successful (PostProcessor* self, gboolean value);
#define GENERIC_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GENERIC_POST_PROCESSOR, GenericPostProcessorPrivate))
enum  {
	GENERIC_POST_PROCESSOR_DUMMY_PROPERTY,
	GENERIC_POST_PROCESSOR_SUCCESSFUL
};
static void generic_post_processor_real_process (PostProcessor* base, GFile* file, const char* stdout, const char* stderr, gint status);
static BuildIssue* generic_post_processor_real_get_issues (PostProcessor* base, int* result_length1);
static void generic_post_processor_finalize (GObject* obj);
static void generic_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void generic_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RUBBER_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorPrivate))
enum  {
	RUBBER_POST_PROCESSOR_DUMMY_PROPERTY,
	RUBBER_POST_PROCESSOR_SUCCESSFUL
};
static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const char* stdout, const char* stderr, gint status);
static void _vala_array_add10 (BuildIssue** array, int* length, int* size, const BuildIssue* value);
static BuildIssue* rubber_post_processor_real_get_issues (PostProcessor* base, int* result_length1);
static BuildIssue* _vala_array_dup3 (BuildIssue* self, int length);
static void rubber_post_processor_finalize (GObject* obj);
static void rubber_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rubber_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GPid* _g_pid_dup (GPid* self) {
	GPid* dup;
	dup = g_new0 (GPid, 1);
	memcpy (dup, self, sizeof (GPid));
	return dup;
}


static gpointer __g_pid_dup0 (gpointer self) {
	return self ? _g_pid_dup (self) : NULL;
}


static void __build_tool_process_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self) {
	_build_tool_process_on_exit (self, pid, status);
}


static void _vala_array_add5 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean __build_tool_process_on_stdout_gsource_func (gpointer self) {
	gboolean result;
	result = _build_tool_process_on_stdout (self);
	return result;
}


static void _vala_array_add6 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean __build_tool_process_on_stderr_gsource_func (gpointer self) {
	gboolean result;
	result = _build_tool_process_on_stderr (self);
	return result;
}


static void _vala_array_add7 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void build_tool_process_execute (BuildToolProcess* self, char** command, int command_length1, const char* working_directory, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint std_out = 0;
		gint std_err = 0;
		GPid _tmp0_;
		GPid* _tmp1_;
		GIOChannel* _tmp2_;
		GIOChannel* _tmp3_;
		g_spawn_async_with_pipes (working_directory, command, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp0_, NULL, &std_out, &std_err, &_inner_error_);
		self->priv->child_pid = (_tmp1_ = __g_pid_dup0 (&_tmp0_), _g_free0 (self->priv->child_pid), _tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		_vala_array_add5 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *self->priv->child_pid, __build_tool_process_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref));
		self->priv->out_channel = (_tmp2_ = g_io_channel_unix_new (std_out), _g_io_channel_unref0 (self->priv->out_channel), _tmp2_);
		self->priv->err_channel = (_tmp3_ = g_io_channel_unix_new (std_err), _g_io_channel_unref0 (self->priv->err_channel), _tmp3_);
		g_io_channel_set_flags (self->priv->out_channel, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		g_io_channel_set_flags (self->priv->err_channel, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		_vala_array_add6 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUILD_TOOL_PROCESS_POLL_INTERVAL, __build_tool_process_on_stdout_gsource_func, g_object_ref (self), g_object_unref));
		_vala_array_add7 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUILD_TOOL_PROCESS_POLL_INTERVAL, __build_tool_process_on_stderr_gsource_func, g_object_ref (self), g_object_unref));
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (e);
			{
				_g_error_free0 (e);
				goto __finally26;
			}
			_g_error_free0 (e);
		}
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _vala_array_add8 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void build_tool_process_execute_without_output (BuildToolProcess* self, char** command, int command_length1, const char* working_directory, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->read_output = FALSE;
	{
		GPid _tmp0_;
		GPid* _tmp1_;
		g_spawn_async (working_directory, command, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp0_, &_inner_error_);
		self->priv->child_pid = (_tmp1_ = __g_pid_dup0 (&_tmp0_), _g_free0 (self->priv->child_pid), _tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		_vala_array_add8 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *self->priv->child_pid, __build_tool_process_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref));
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (e);
			{
				_g_error_free0 (e);
				goto __finally27;
			}
			_g_error_free0 (e);
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void build_tool_process_abort (BuildToolProcess* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->child_pid != NULL) {
		{
			guint* handler_collection;
			int handler_collection_length1;
			int handler_it;
			handler_collection = self->priv->handlers;
			handler_collection_length1 = self->priv->handlers_length1;
			for (handler_it = 0; handler_it < self->priv->handlers_length1; handler_it = handler_it + 1) {
				guint handler;
				handler = handler_collection[handler_it];
				{
					g_source_remove (handler);
				}
			}
		}
		kill (*self->priv->child_pid, SIGTERM);
		build_tool_process_on_abort (self);
	}
}


static gboolean _build_tool_process_on_stdout (BuildToolProcess* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->read_output, FALSE);
	{
		char* text;
		gsize length = 0UL;
		char* _tmp0_ = NULL;
		char* _tmp1_;
		text = NULL;
		g_io_channel_read_to_end (self->priv->out_channel, &_tmp0_, &length, &_inner_error_);
		text = (_tmp1_ = _tmp0_, _g_free0 (text), _tmp1_);
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			goto __catch28_g_error;
		}
		if (length > 0) {
			build_tool_process_on_stdout (self, text);
		}
		_g_free0 (text);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gboolean _build_tool_process_on_stderr (BuildToolProcess* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->read_output, FALSE);
	{
		char* text;
		gsize length = 0UL;
		char* _tmp0_ = NULL;
		char* _tmp1_;
		text = NULL;
		g_io_channel_read_to_end (self->priv->err_channel, &_tmp0_, &length, &_inner_error_);
		text = (_tmp1_ = _tmp0_, _g_free0 (text), _tmp1_);
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			goto __catch29_g_error;
		}
		if (length > 0) {
			build_tool_process_on_stderr (self, text);
		}
		_g_free0 (text);
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _build_tool_process_on_exit (BuildToolProcess* self, GPid pid, gint status) {
	g_return_if_fail (self != NULL);
	{
		guint* handler_collection;
		int handler_collection_length1;
		int handler_it;
		handler_collection = self->priv->handlers;
		handler_collection_length1 = self->priv->handlers_length1;
		for (handler_it = 0; handler_it < self->priv->handlers_length1; handler_it = handler_it + 1) {
			guint handler;
			handler = handler_collection[handler_it];
			{
				g_source_remove (handler);
			}
		}
	}
	if (self->priv->read_output) {
		_build_tool_process_on_stdout (self);
		_build_tool_process_on_stderr (self);
	}
	build_tool_process_on_exit (self, status);
}


static void build_tool_process_real_on_stdout (BuildToolProcess* self, const char* text) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `build_tool_process_on_stdout'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void build_tool_process_on_stdout (BuildToolProcess* self, const char* text) {
	BUILD_TOOL_PROCESS_GET_CLASS (self)->on_stdout (self, text);
}


static void build_tool_process_real_on_stderr (BuildToolProcess* self, const char* text) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `build_tool_process_on_stderr'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void build_tool_process_on_stderr (BuildToolProcess* self, const char* text) {
	BUILD_TOOL_PROCESS_GET_CLASS (self)->on_stderr (self, text);
}


static void build_tool_process_real_on_abort (BuildToolProcess* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `build_tool_process_on_abort'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void build_tool_process_on_abort (BuildToolProcess* self) {
	BUILD_TOOL_PROCESS_GET_CLASS (self)->on_abort (self);
}


static void build_tool_process_real_on_exit (BuildToolProcess* self, gint status) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `build_tool_process_on_exit'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void build_tool_process_on_exit (BuildToolProcess* self, gint status) {
	BUILD_TOOL_PROCESS_GET_CLASS (self)->on_exit (self, status);
}


BuildToolProcess* build_tool_process_construct (GType object_type) {
	BuildToolProcess * self = NULL;
	self = (BuildToolProcess*) g_object_new (object_type, NULL);
	return self;
}


static void build_tool_process_class_init (BuildToolProcessClass * klass) {
	build_tool_process_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolProcessPrivate));
	BUILD_TOOL_PROCESS_CLASS (klass)->on_stdout = build_tool_process_real_on_stdout;
	BUILD_TOOL_PROCESS_CLASS (klass)->on_stderr = build_tool_process_real_on_stderr;
	BUILD_TOOL_PROCESS_CLASS (klass)->on_abort = build_tool_process_real_on_abort;
	BUILD_TOOL_PROCESS_CLASS (klass)->on_exit = build_tool_process_real_on_exit;
	G_OBJECT_CLASS (klass)->finalize = build_tool_process_finalize;
}


static void build_tool_process_instance_init (BuildToolProcess * self) {
	guint* _tmp0_ = NULL;
	self->priv = BUILD_TOOL_PROCESS_GET_PRIVATE (self);
	self->priv->child_pid = NULL;
	self->priv->handlers = (_tmp0_ = g_new0 (guint, 0), _tmp0_);
	self->priv->handlers_length1 = 0;
	self->priv->_handlers_size_ = self->priv->handlers_length1;
	self->priv->read_output = TRUE;
}


static void build_tool_process_finalize (GObject* obj) {
	BuildToolProcess * self;
	self = BUILD_TOOL_PROCESS (obj);
	_g_free0 (self->priv->child_pid);
	self->priv->handlers = (g_free (self->priv->handlers), NULL);
	_g_io_channel_unref0 (self->priv->out_channel);
	_g_io_channel_unref0 (self->priv->err_channel);
	G_OBJECT_CLASS (build_tool_process_parent_class)->finalize (obj);
}


GType build_tool_process_get_type (void) {
	static volatile gsize build_tool_process_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_process_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolProcessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_process_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolProcess), 0, (GInstanceInitFunc) build_tool_process_instance_init, NULL };
		GType build_tool_process_type_id;
		build_tool_process_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolProcess", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&build_tool_process_type_id__volatile, build_tool_process_type_id);
	}
	return build_tool_process_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add9 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTreeIter, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	BuildToolRunner * self = NULL;
	GFile* _tmp0_;
	GtkAction* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	GFile* _tmp4_;
	char* _tmp5_;
	GSettings* settings;
	char* _tmp6_;
	gint extensions_length1;
	gint _extensions_size_;
	char** _tmp8_;
	char** _tmp7_;
	char** extensions;
	gboolean _tmp9_ = FALSE;
	BuildView* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	GtkTreeIter _tmp14_ = {0};
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (action_stop_exec != NULL, NULL);
	self = (BuildToolRunner*) build_tool_process_construct (object_type);
	self->priv->file = (_tmp0_ = _g_object_ref0 (file), _g_object_unref0 (self->priv->file), _tmp0_);
	self->priv->compilation = (*tool).compilation;
	self->priv->action_stop_exec = (_tmp1_ = _g_object_ref0 (action_stop_exec), _g_object_unref0 (self->priv->action_stop_exec), _tmp1_);
	self->priv->filename = (_tmp2_ = g_file_get_parse_name (file), _g_free0 (self->priv->filename), _tmp2_);
	self->priv->shortname = (_tmp3_ = utils_get_shortname (self->priv->filename), _g_free0 (self->priv->shortname), _tmp3_);
	self->priv->directory = (_tmp5_ = g_file_get_parse_name (_tmp4_ = g_file_get_parent (file)), _g_free0 (self->priv->directory), _tmp5_);
	_g_object_unref0 (_tmp4_);
	settings = g_settings_new ("org.gnome.latexila.preferences.latex");
	self->priv->document_view_program = (_tmp6_ = g_strdup (g_settings_get_string (settings, "document-view-program")), _g_free0 (self->priv->document_view_program), _tmp6_);
	extensions = (_tmp8_ = _tmp7_ = g_strsplit ((*tool).extensions, " ", 0), extensions_length1 = _vala_array_length (_tmp7_), _extensions_size_ = extensions_length1, _tmp8_);
	if (string_get_length ((*tool).extensions) > 0) {
		char* _tmp10_;
		_tmp9_ = !_vala_string_array_contains (extensions, extensions_length1, _tmp10_ = utils_get_extension (self->priv->filename));
		_g_free0 (_tmp10_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		fprintf (stderr, "Warning: bad file extension\n");
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		return self;
	}
	self->priv->jobs = (*tool).jobs;
	self->priv->view = (_tmp11_ = _g_object_ref0 (view), _g_object_unref0 (self->priv->view), _tmp11_);
	build_view_clear (view);
	self->priv->root_partition = (build_view_add_partition (view, _tmp13_ = g_strconcat (_tmp12_ = g_strconcat ("<b>", (*tool).label, NULL), "</b>", NULL), PARTITION_STATE_RUNNING, NULL, &_tmp14_), _tmp14_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp12_);
	{
		GList* job_collection;
		GList* job_it;
		job_collection = self->priv->jobs;
		for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
			BuildJob _tmp20_ = {0};
			BuildJob job;
			job = (build_job_copy ((BuildJob*) job_it->data, &_tmp20_), _tmp20_);
			{
				gint command_length1;
				gint _command_size_;
				char** _tmp16_;
				gint _tmp15_;
				char** command;
				char* _tmp17_;
				GtkTreeIter _tmp18_ = {0};
				GtkTreeIter _tmp19_;
				command = (_tmp16_ = build_tool_runner_get_command (self, &job, TRUE, &_tmp15_), command_length1 = _tmp15_, _command_size_ = command_length1, _tmp16_);
				_vala_array_add9 (&self->priv->job_partitions, &self->priv->job_partitions_length1, &self->priv->_job_partitions_size_, (_tmp19_ = (build_view_add_partition (view, _tmp17_ = g_strjoinv (" ", command), PARTITION_STATE_RUNNING, &self->priv->root_partition, &_tmp18_), _tmp18_), &_tmp19_));
				_g_free0 (_tmp17_);
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				build_job_destroy (&job);
			}
		}
	}
	gtk_action_set_sensitive (action_stop_exec, TRUE);
	build_tool_runner_proceed (self);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return self;
}


BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	return build_tool_runner_construct (TYPE_BUILD_TOOL_RUNNER, file, tool, view, action_stop_exec);
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


BuildToolRunner* build_tool_runner_construct_web_browser (GType object_type, GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec) {
	BuildToolRunner * self = NULL;
	GSettings* settings;
	BuildTool build_tool = {0};
	char* _tmp0_;
	char* _tmp1_;
	BuildJob build_job = {0};
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (action_stop_exec != NULL, NULL);
	settings = g_settings_new ("org.gnome.latexila.preferences.editor");
	memset (&build_tool, 0, sizeof (BuildTool));
	build_tool.extensions = (_tmp0_ = g_strdup (""), _g_free0 (build_tool.extensions), _tmp0_);
	build_tool.label = (_tmp1_ = g_strdup (label), _g_free0 (build_tool.label), _tmp1_);
	memset (&build_job, 0, sizeof (BuildJob));
	build_job.post_processor = (_tmp2_ = g_strdup ("generic"), _g_free0 (build_job.post_processor), _tmp2_);
	build_job.must_succeed = TRUE;
	build_job.command = (_tmp3_ = g_strdup_printf ("%s $filename", g_settings_get_string (settings, "web-browser")), _g_free0 (build_job.command), _tmp3_);
	build_tool.jobs = g_list_append (build_tool.jobs, _build_job_dup0 (&build_job));
	self = (BuildToolRunner*) build_tool_runner_construct (object_type, file, &build_tool, view, action_stop_exec);
	build_job_destroy (&build_job);
	build_tool_destroy (&build_tool);
	_g_object_unref0 (settings);
	return self;
}


BuildToolRunner* build_tool_runner_new_web_browser (GFile* file, const char* label, BuildView* view, GtkAction* action_stop_exec) {
	return build_tool_runner_construct_web_browser (TYPE_BUILD_TOOL_RUNNER, file, label, view, action_stop_exec);
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void _vala_BuildIssue_array_free (BuildIssue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			build_issue_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void build_tool_runner_proceed (BuildToolRunner* self) {
	gint command_length1;
	gint _command_size_;
	char** _tmp1_;
	gint _tmp0_;
	char** command;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->job_num >= g_list_length (self->priv->jobs)) {
		build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_SUCCEEDED);
		gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
		g_signal_emit_by_name (self, "finished");
		return;
	}
	self->priv->current_job = *((BuildJob*) g_list_nth_data (self->priv->jobs, (guint) self->priv->job_num));
	command = (_tmp1_ = build_tool_runner_get_command (self, &self->priv->current_job, FALSE, &_tmp0_), command_length1 = _tmp0_, _command_size_ = command_length1, _tmp1_);
	{
		if (_vala_strcmp0 (self->priv->current_job.post_processor, "generic") == 0) {
			build_tool_process_execute_without_output ((BuildToolProcess*) self, command, command_length1, self->priv->directory, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
		} else {
			if (string_contains (self->priv->filename, " ")) {
				gint issues_length1;
				gint _issues_size_;
				BuildIssue* _tmp2_;
				BuildIssue* issues;
				BuildIssue issue = {0};
				char* _tmp3_;
				char* _tmp4_;
				BuildIssue _tmp5_ = {0};
				BuildIssue _tmp6_;
				GtkTreeIter _tmp7_;
				issues = (_tmp2_ = g_new0 (BuildIssue, 1), issues_length1 = 1, _issues_size_ = issues_length1, _tmp2_);
				memset (&issue, 0, sizeof (BuildIssue));
				issue.message = (_tmp3_ = g_strdup (_ ("Rubber may not support filenames with spaces (even in a directory)")), _g_free0 (issue.message), _tmp3_);
				issue.message_type = BUILD_MESSAGE_TYPE_WARNING;
				issue.filename = (_tmp4_ = g_strdup (self->priv->filename), _g_free0 (issue.filename), _tmp4_);
				issues[0] = (_tmp6_ = (build_issue_copy (&issue, &_tmp5_), _tmp5_), build_issue_destroy (&issues[0]), _tmp6_);
				build_view_append_issues (self->priv->view, (_tmp7_ = self->priv->job_partitions[self->priv->job_num], &_tmp7_), issues, issues_length1);
				build_issue_destroy (&issue);
				issues = (_vala_BuildIssue_array_free (issues, issues_length1), NULL);
			}
			build_tool_process_execute ((BuildToolProcess*) self, command, command_length1, self->priv->directory, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
			GtkTreeIter _tmp10_ = {0};
			build_view_set_partition_state (self->priv->view, (_tmp8_ = self->priv->job_partitions[self->priv->job_num], &_tmp8_), PARTITION_STATE_FAILED);
			build_view_add_partition (self->priv->view, e->message, PARTITION_STATE_FAILED, (_tmp9_ = self->priv->job_partitions[self->priv->job_num], &_tmp9_), &_tmp10_);
			_tmp10_;
			if (self->priv->current_job.must_succeed) {
				build_tool_runner_failed (self);
			} else {
				self->priv->job_num++;
				build_tool_runner_proceed (self);
			}
			_g_error_free0 (e);
		}
	}
	__finally30:
	if (_inner_error_ != NULL) {
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char** build_tool_runner_get_command (BuildToolRunner* self, BuildJob* build_job, gboolean basename, int* result_length1) {
	char** result = NULL;
	char* base_filename;
	char* base_shortname;
	gint command_length1;
	gint _command_size_;
	char** _tmp3_;
	char** _tmp2_;
	char** command;
	char** _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	base_filename = NULL;
	base_shortname = NULL;
	if (basename) {
		char* _tmp0_;
		char* _tmp1_;
		base_filename = (_tmp0_ = g_file_get_basename (self->priv->file), _g_free0 (base_filename), _tmp0_);
		base_shortname = (_tmp1_ = utils_get_shortname (base_filename), _g_free0 (base_shortname), _tmp1_);
	}
	command = (_tmp3_ = _tmp2_ = g_strsplit ((*build_job).command, " ", 0), command_length1 = _vala_array_length (_tmp2_), _command_size_ = command_length1, _tmp3_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < command_length1)) {
					break;
				}
				if (string_contains (command[i], "$view")) {
					char* _tmp5_;
					command[i] = (_tmp5_ = string_replace (command[i], "$view", self->priv->document_view_program), _g_free0 (command[i]), _tmp5_);
					continue;
				}
				if (string_contains (command[i], "$filename")) {
					char* _tmp6_;
					char* _tmp8_;
					_tmp6_ = g_strdup (base_filename);
					if (_tmp6_ == NULL) {
						char* _tmp7_;
						_tmp6_ = (_tmp7_ = g_strdup (self->priv->filename), _g_free0 (_tmp6_), _tmp7_);
					}
					command[i] = (_tmp8_ = string_replace (command[i], "$filename", _tmp6_), _g_free0 (command[i]), _tmp8_);
					_g_free0 (_tmp6_);
					continue;
				}
				if (string_contains (command[i], "$shortname")) {
					char* _tmp9_;
					char* _tmp11_;
					_tmp9_ = g_strdup (base_shortname);
					if (_tmp9_ == NULL) {
						char* _tmp10_;
						_tmp9_ = (_tmp10_ = g_strdup (self->priv->shortname), _g_free0 (_tmp9_), _tmp10_);
					}
					command[i] = (_tmp11_ = string_replace (command[i], "$shortname", _tmp9_), _g_free0 (command[i]), _tmp11_);
					_g_free0 (_tmp9_);
					continue;
				}
			}
		}
	}
	result = (_tmp12_ = command, *result_length1 = command_length1, _tmp12_);
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
	return result;
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
}


static void build_tool_runner_real_on_stdout (BuildToolProcess* base, const char* text) {
	BuildToolRunner * self;
	char* _tmp0_;
	self = (BuildToolRunner*) base;
	g_return_if_fail (text != NULL);
	self->priv->stdout_text = (_tmp0_ = g_strconcat (self->priv->stdout_text, text, NULL), _g_free0 (self->priv->stdout_text), _tmp0_);
}


static void build_tool_runner_real_on_stderr (BuildToolProcess* base, const char* text) {
	BuildToolRunner * self;
	char* _tmp0_;
	self = (BuildToolRunner*) base;
	g_return_if_fail (text != NULL);
	self->priv->stderr_text = (_tmp0_ = g_strconcat (self->priv->stderr_text, text, NULL), _g_free0 (self->priv->stderr_text), _tmp0_);
}


static void build_tool_runner_real_on_abort (BuildToolProcess* base) {
	BuildToolRunner * self;
	self = (BuildToolRunner*) base;
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
	build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_ABORTED);
	{
		gint i;
		i = self->priv->job_num;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->job_partitions_length1)) {
					break;
				}
				build_view_set_partition_state (self->priv->view, (_tmp1_ = self->priv->job_partitions[i], &_tmp1_), PARTITION_STATE_ABORTED);
			}
		}
	}
}


static void build_tool_runner_real_on_exit (BuildToolProcess* base, gint status) {
	BuildToolRunner * self;
	PostProcessor* post_processor;
	const char* _tmp3_;
	GQuark _tmp4_;
	static GQuark _tmp4__label0 = 0;
	static GQuark _tmp4__label1 = 0;
	gint _tmp5_;
	BuildIssue* _tmp6_;
	gint _tmp6__length1;
	GtkTreeIter _tmp7_;
	BuildIssue* _tmp8_;
	self = (BuildToolRunner*) base;
	post_processor = NULL;
	_tmp3_ = self->priv->current_job.post_processor;
	_tmp4_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp4_ == ((0 != _tmp4__label0) ? _tmp4__label0 : (_tmp4__label0 = g_quark_from_static_string ("generic"))))
	switch (0) {
		default:
		{
			PostProcessor* _tmp0_;
			post_processor = (_tmp0_ = (PostProcessor*) generic_post_processor_new (), _g_object_unref0 (post_processor), _tmp0_);
			break;
		}
	} else if (_tmp4_ == ((0 != _tmp4__label1) ? _tmp4__label1 : (_tmp4__label1 = g_quark_from_static_string ("rubber"))))
	switch (0) {
		default:
		{
			PostProcessor* _tmp1_;
			post_processor = (_tmp1_ = (PostProcessor*) rubber_post_processor_new (), _g_object_unref0 (post_processor), _tmp1_);
			break;
		}
	} else
	switch (0) {
		default:
		{
			PostProcessor* _tmp2_;
			fprintf (stderr, "Warning: unknown post processor \"%s\". Use generic.", self->priv->current_job.post_processor);
			post_processor = (_tmp2_ = (PostProcessor*) generic_post_processor_new (), _g_object_unref0 (post_processor), _tmp2_);
			break;
		}
	}
	post_processor_process (post_processor, self->priv->file, self->priv->stdout_text, self->priv->stderr_text, status);
	_tmp8_ = (_tmp6_ = post_processor_get_issues (post_processor, &_tmp5_), _tmp6__length1 = _tmp5_, _tmp6_);
	build_view_append_issues (self->priv->view, (_tmp7_ = self->priv->job_partitions[self->priv->job_num], &_tmp7_), _tmp8_, _tmp5_);
	_tmp6_ = (_vala_BuildIssue_array_free (_tmp6_, _tmp6__length1), NULL);
	if (post_processor_get_successful (post_processor)) {
		GtkTreeIter _tmp9_;
		build_view_set_partition_state (self->priv->view, (_tmp9_ = self->priv->job_partitions[self->priv->job_num], &_tmp9_), PARTITION_STATE_SUCCEEDED);
		self->priv->job_num++;
		build_tool_runner_proceed (self);
	} else {
		GtkTreeIter _tmp10_;
		build_view_set_partition_state (self->priv->view, (_tmp10_ = self->priv->job_partitions[self->priv->job_num], &_tmp10_), PARTITION_STATE_FAILED);
		if (self->priv->current_job.must_succeed) {
			build_tool_runner_failed (self);
		} else {
			self->priv->job_num++;
			build_tool_runner_proceed (self);
		}
	}
	_g_object_unref0 (post_processor);
}


static void build_tool_runner_failed (BuildToolRunner* self) {
	g_return_if_fail (self != NULL);
	build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_FAILED);
	{
		gint i;
		i = self->priv->job_num + 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->job_partitions_length1)) {
					break;
				}
				build_view_set_partition_state (self->priv->view, (_tmp1_ = self->priv->job_partitions[i], &_tmp1_), PARTITION_STATE_ABORTED);
			}
		}
	}
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
}


static void build_tool_runner_class_init (BuildToolRunnerClass * klass) {
	build_tool_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolRunnerPrivate));
	BUILD_TOOL_PROCESS_CLASS (klass)->on_stdout = build_tool_runner_real_on_stdout;
	BUILD_TOOL_PROCESS_CLASS (klass)->on_stderr = build_tool_runner_real_on_stderr;
	BUILD_TOOL_PROCESS_CLASS (klass)->on_abort = build_tool_runner_real_on_abort;
	BUILD_TOOL_PROCESS_CLASS (klass)->on_exit = build_tool_runner_real_on_exit;
	G_OBJECT_CLASS (klass)->finalize = build_tool_runner_finalize;
	g_signal_new ("finished", TYPE_BUILD_TOOL_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void build_tool_runner_instance_init (BuildToolRunner * self) {
	self->priv = BUILD_TOOL_RUNNER_GET_PRIVATE (self);
	self->priv->stdout_text = g_strdup ("");
	self->priv->stderr_text = g_strdup ("");
	self->priv->job_num = 0;
}


static void build_tool_runner_finalize (GObject* obj) {
	BuildToolRunner * self;
	self = BUILD_TOOL_RUNNER (obj);
	_g_object_unref0 (self->priv->view);
	_g_free0 (self->priv->document_view_program);
	_g_object_unref0 (self->priv->action_stop_exec);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->filename);
	_g_free0 (self->priv->shortname);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->stdout_text);
	_g_free0 (self->priv->stderr_text);
	self->priv->job_partitions = (g_free (self->priv->job_partitions), NULL);
	G_OBJECT_CLASS (build_tool_runner_parent_class)->finalize (obj);
}


GType build_tool_runner_get_type (void) {
	static volatile gsize build_tool_runner_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolRunner), 0, (GInstanceInitFunc) build_tool_runner_instance_init, NULL };
		GType build_tool_runner_type_id;
		build_tool_runner_type_id = g_type_register_static (TYPE_BUILD_TOOL_PROCESS, "BuildToolRunner", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_runner_type_id__volatile, build_tool_runner_type_id);
	}
	return build_tool_runner_type_id__volatile;
}


void post_processor_process (PostProcessor* self, GFile* file, const char* stdout, const char* stderr, gint status) {
	POST_PROCESSOR_GET_INTERFACE (self)->process (self, file, stdout, stderr, status);
}


BuildIssue* post_processor_get_issues (PostProcessor* self, int* result_length1) {
	return POST_PROCESSOR_GET_INTERFACE (self)->get_issues (self, result_length1);
}


gboolean post_processor_get_successful (PostProcessor* self) {
	return POST_PROCESSOR_GET_INTERFACE (self)->get_successful (self);
}


void post_processor_set_successful (PostProcessor* self, gboolean value) {
	POST_PROCESSOR_GET_INTERFACE (self)->set_successful (self, value);
}


static void post_processor_base_init (PostProcessorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_boolean ("successful", "successful", "successful", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType post_processor_get_type (void) {
	static volatile gsize post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PostProcessorIface), (GBaseInitFunc) post_processor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType post_processor_type_id;
		post_processor_type_id = g_type_register_static (G_TYPE_INTERFACE, "PostProcessor", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (post_processor_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&post_processor_type_id__volatile, post_processor_type_id);
	}
	return post_processor_type_id__volatile;
}


static void generic_post_processor_real_process (PostProcessor* base, GFile* file, const char* stdout, const char* stderr, gint status) {
	GenericPostProcessor * self;
	self = (GenericPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (stdout != NULL);
	g_return_if_fail (stderr != NULL);
	post_processor_set_successful ((PostProcessor*) self, status == 0);
}


static BuildIssue* generic_post_processor_real_get_issues (PostProcessor* base, int* result_length1) {
	GenericPostProcessor * self;
	BuildIssue* result = NULL;
	gint issues_length1;
	gint _issues_size_;
	BuildIssue* _tmp1_;
	BuildIssue* _tmp0_ = NULL;
	BuildIssue* issues;
	BuildIssue* _tmp2_;
	self = (GenericPostProcessor*) base;
	issues = (_tmp1_ = (_tmp0_ = g_new0 (BuildIssue, 0), _tmp0_), issues_length1 = 0, _issues_size_ = issues_length1, _tmp1_);
	result = (_tmp2_ = issues, *result_length1 = issues_length1, _tmp2_);
	return result;
	issues = (_vala_BuildIssue_array_free (issues, issues_length1), NULL);
}


GenericPostProcessor* generic_post_processor_construct (GType object_type) {
	GenericPostProcessor * self = NULL;
	self = (GenericPostProcessor*) g_object_new (object_type, NULL);
	return self;
}


GenericPostProcessor* generic_post_processor_new (void) {
	return generic_post_processor_construct (TYPE_GENERIC_POST_PROCESSOR);
}


static gboolean generic_post_processor_real_get_successful (PostProcessor* base) {
	gboolean result;
	GenericPostProcessor* self;
	self = (GenericPostProcessor*) base;
	result = self->priv->_successful;
	return result;
}


static void generic_post_processor_real_set_successful (PostProcessor* base, gboolean value) {
	GenericPostProcessor* self;
	self = (GenericPostProcessor*) base;
	self->priv->_successful = value;
	g_object_notify ((GObject *) self, "successful");
}


static void generic_post_processor_class_init (GenericPostProcessorClass * klass) {
	generic_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GenericPostProcessorPrivate));
	G_OBJECT_CLASS (klass)->get_property = generic_post_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = generic_post_processor_set_property;
	G_OBJECT_CLASS (klass)->finalize = generic_post_processor_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GENERIC_POST_PROCESSOR_SUCCESSFUL, "successful");
}


static void generic_post_processor_post_processor_interface_init (PostProcessorIface * iface) {
	generic_post_processor_post_processor_parent_iface = g_type_interface_peek_parent (iface);
	iface->process = generic_post_processor_real_process;
	iface->get_issues = generic_post_processor_real_get_issues;
	iface->get_successful = generic_post_processor_real_get_successful;
	iface->set_successful = generic_post_processor_real_set_successful;
}


static void generic_post_processor_instance_init (GenericPostProcessor * self) {
	self->priv = GENERIC_POST_PROCESSOR_GET_PRIVATE (self);
}


static void generic_post_processor_finalize (GObject* obj) {
	GenericPostProcessor * self;
	self = GENERIC_POST_PROCESSOR (obj);
	G_OBJECT_CLASS (generic_post_processor_parent_class)->finalize (obj);
}


GType generic_post_processor_get_type (void) {
	static volatile gsize generic_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&generic_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GenericPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generic_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GenericPostProcessor), 0, (GInstanceInitFunc) generic_post_processor_instance_init, NULL };
		static const GInterfaceInfo post_processor_info = { (GInterfaceInitFunc) generic_post_processor_post_processor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType generic_post_processor_type_id;
		generic_post_processor_type_id = g_type_register_static (G_TYPE_OBJECT, "GenericPostProcessor", &g_define_type_info, 0);
		g_type_add_interface_static (generic_post_processor_type_id, TYPE_POST_PROCESSOR, &post_processor_info);
		g_once_init_leave (&generic_post_processor_type_id__volatile, generic_post_processor_type_id);
	}
	return generic_post_processor_type_id__volatile;
}


static void generic_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GenericPostProcessor * self;
	self = GENERIC_POST_PROCESSOR (object);
	switch (property_id) {
		case GENERIC_POST_PROCESSOR_SUCCESSFUL:
		g_value_set_boolean (value, post_processor_get_successful ((PostProcessor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void generic_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GenericPostProcessor * self;
	self = GENERIC_POST_PROCESSOR (object);
	switch (property_id) {
		case GENERIC_POST_PROCESSOR_SUCCESSFUL:
		post_processor_set_successful ((PostProcessor*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RubberPostProcessor* rubber_post_processor_construct (GType object_type) {
	RubberPostProcessor * self = NULL;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) g_object_new (object_type, NULL);
	if (rubber_post_processor_pattern == NULL) {
		{
			GRegex* _tmp0_;
			GRegex* _tmp1_;
			_tmp0_ = g_regex_new ("(?P<file>[^:\n]+)(:(?P<line>[0-9\\-]+))?:(?P<text>.+)$", G_REGEX_MULTILINE, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch32_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			rubber_post_processor_pattern = (_tmp1_ = _tmp0_, _g_regex_unref0 (rubber_post_processor_pattern), _tmp1_);
		}
		goto __finally32;
		__catch32_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "Warning in RubberPostProcessor: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally32:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


RubberPostProcessor* rubber_post_processor_new (void) {
	return rubber_post_processor_construct (TYPE_RUBBER_POST_PROCESSOR);
}


static void _vala_array_add10 (BuildIssue** array, int* length, int* size, const BuildIssue* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BuildIssue, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const char* stdout, const char* stderr, gint status) {
	RubberPostProcessor * self;
	GMatchInfo* match_info;
	GMatchInfo* _tmp0_ = NULL;
	GMatchInfo* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (stdout != NULL);
	g_return_if_fail (stderr != NULL);
	post_processor_set_successful ((PostProcessor*) self, status == 0);
	if (rubber_post_processor_pattern == NULL) {
		return;
	}
	match_info = NULL;
	g_regex_match (rubber_post_processor_pattern, stderr, 0, &_tmp0_);
	match_info = (_tmp1_ = _tmp0_, _g_match_info_free0 (match_info), _tmp1_);
	while (TRUE) {
		BuildIssue issue = {0};
		char* _tmp2_;
		char* text;
		gboolean _tmp3_ = FALSE;
		char* line;
		gboolean _tmp4_ = FALSE;
		char* _tmp9_;
		BuildIssue _tmp13_ = {0};
		BuildIssue _tmp14_;
		if (!g_match_info_matches (match_info)) {
			break;
		}
		memset (&issue, 0, sizeof (BuildIssue));
		text = g_strdup (issue.message = (_tmp2_ = g_match_info_fetch_named (match_info, "text"), _g_free0 (issue.message), _tmp2_));
		issue.message_type = BUILD_MESSAGE_TYPE_ERROR;
		if (string_contains (text, "Underfull")) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = string_contains (text, "Overfull");
		}
		if (_tmp3_) {
			issue.message_type = BUILD_MESSAGE_TYPE_BADBOX;
		}
		issue.start_line = issue.end_line = -1;
		line = g_match_info_fetch_named (match_info, "line");
		if (line != NULL) {
			_tmp4_ = string_get_length (line) > 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gint parts_length1;
			gint _parts_size_;
			char** _tmp6_;
			char** _tmp5_;
			char** parts;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			parts = (_tmp6_ = _tmp5_ = g_strsplit (line, "-", 0), parts_length1 = _vala_array_length (_tmp5_), _parts_size_ = parts_length1, _tmp6_);
			issue.start_line = atoi (parts[0]);
			if (parts_length1 > 1) {
				_tmp8_ = parts[1] != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_tmp7_ = string_get_length (parts[1]) > 0;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				issue.end_line = atoi (parts[1]);
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
		issue.filename = (_tmp9_ = g_match_info_fetch_named (match_info, "file"), _g_free0 (issue.filename), _tmp9_);
		if (g_utf8_get_char (g_utf8_offset_to_pointer (issue.filename, 0)) != '/') {
			GFile* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			issue.filename = (_tmp12_ = g_strdup_printf ("%s/%s", _tmp11_ = g_file_get_parse_name (_tmp10_ = g_file_get_parent (file)), issue.filename), _g_free0 (issue.filename), _tmp12_);
			_g_free0 (_tmp11_);
			_g_object_unref0 (_tmp10_);
		}
		_vala_array_add10 (&self->priv->issues, &self->priv->issues_length1, &self->priv->_issues_size_, (_tmp14_ = (build_issue_copy (&issue, &_tmp13_), _tmp13_), &_tmp14_));
		{
			g_match_info_next (match_info, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch33_g_regex_error;
				}
				_g_free0 (line);
				_g_free0 (text);
				build_issue_destroy (&issue);
				_g_match_info_free0 (match_info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally33;
		__catch33_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp15_;
				_tmp15_ = g_strdup_printf (stderr, "Warning: RubberPostProcessor: %s\n", e->message);
				_g_free0 (_tmp15_);
				_g_error_free0 (e);
				_g_free0 (line);
				_g_free0 (text);
				build_issue_destroy (&issue);
				break;
			}
		}
		__finally33:
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			_g_free0 (text);
			build_issue_destroy (&issue);
			_g_match_info_free0 (match_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (line);
		_g_free0 (text);
		build_issue_destroy (&issue);
	}
	_g_match_info_free0 (match_info);
}


static BuildIssue* _vala_array_dup3 (BuildIssue* self, int length) {
	BuildIssue* result;
	int i;
	BuildIssue _tmp0_ = {0};
	result = g_new0 (BuildIssue, length);
	for (i = 0; i < length; i++) {
		result[i] = (build_issue_copy (&self[i], &_tmp0_), _tmp0_);
	}
	return result;
}


static BuildIssue* rubber_post_processor_real_get_issues (PostProcessor* base, int* result_length1) {
	RubberPostProcessor * self;
	BuildIssue* result = NULL;
	BuildIssue* _tmp0_;
	BuildIssue* _tmp1_;
	self = (RubberPostProcessor*) base;
	result = (_tmp1_ = (_tmp0_ = self->priv->issues, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup3 (_tmp0_, self->priv->issues_length1)), *result_length1 = self->priv->issues_length1, _tmp1_);
	return result;
}


static gboolean rubber_post_processor_real_get_successful (PostProcessor* base) {
	gboolean result;
	RubberPostProcessor* self;
	self = (RubberPostProcessor*) base;
	result = self->priv->_successful;
	return result;
}


static void rubber_post_processor_real_set_successful (PostProcessor* base, gboolean value) {
	RubberPostProcessor* self;
	self = (RubberPostProcessor*) base;
	self->priv->_successful = value;
	g_object_notify ((GObject *) self, "successful");
}


static void rubber_post_processor_class_init (RubberPostProcessorClass * klass) {
	rubber_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RubberPostProcessorPrivate));
	G_OBJECT_CLASS (klass)->get_property = rubber_post_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = rubber_post_processor_set_property;
	G_OBJECT_CLASS (klass)->finalize = rubber_post_processor_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RUBBER_POST_PROCESSOR_SUCCESSFUL, "successful");
}


static void rubber_post_processor_post_processor_interface_init (PostProcessorIface * iface) {
	rubber_post_processor_post_processor_parent_iface = g_type_interface_peek_parent (iface);
	iface->process = rubber_post_processor_real_process;
	iface->get_issues = rubber_post_processor_real_get_issues;
	iface->get_successful = rubber_post_processor_real_get_successful;
	iface->set_successful = rubber_post_processor_real_set_successful;
}


static void rubber_post_processor_instance_init (RubberPostProcessor * self) {
	BuildIssue* _tmp0_ = NULL;
	self->priv = RUBBER_POST_PROCESSOR_GET_PRIVATE (self);
	self->priv->issues = (_tmp0_ = g_new0 (BuildIssue, 0), _tmp0_);
	self->priv->issues_length1 = 0;
	self->priv->_issues_size_ = self->priv->issues_length1;
}


static void rubber_post_processor_finalize (GObject* obj) {
	RubberPostProcessor * self;
	self = RUBBER_POST_PROCESSOR (obj);
	self->priv->issues = (_vala_BuildIssue_array_free (self->priv->issues, self->priv->issues_length1), NULL);
	G_OBJECT_CLASS (rubber_post_processor_parent_class)->finalize (obj);
}


GType rubber_post_processor_get_type (void) {
	static volatile gsize rubber_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&rubber_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RubberPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rubber_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RubberPostProcessor), 0, (GInstanceInitFunc) rubber_post_processor_instance_init, NULL };
		static const GInterfaceInfo post_processor_info = { (GInterfaceInitFunc) rubber_post_processor_post_processor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rubber_post_processor_type_id;
		rubber_post_processor_type_id = g_type_register_static (G_TYPE_OBJECT, "RubberPostProcessor", &g_define_type_info, 0);
		g_type_add_interface_static (rubber_post_processor_type_id, TYPE_POST_PROCESSOR, &post_processor_info);
		g_once_init_leave (&rubber_post_processor_type_id__volatile, rubber_post_processor_type_id);
	}
	return rubber_post_processor_type_id__volatile;
}


static void rubber_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RubberPostProcessor * self;
	self = RUBBER_POST_PROCESSOR (object);
	switch (property_id) {
		case RUBBER_POST_PROCESSOR_SUCCESSFUL:
		g_value_set_boolean (value, post_processor_get_successful ((PostProcessor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rubber_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RubberPostProcessor * self;
	self = RUBBER_POST_PROCESSOR (object);
	switch (property_id) {
		case RUBBER_POST_PROCESSOR_SUCCESSFUL:
		post_processor_set_successful ((PostProcessor*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




