/* document.c generated by valac 0.10.2, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksourceiter.h>
#include <pango/pango.h>


#define TYPE_SELECTION_TYPE (selection_type_get_type ())

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
typedef struct _Block14Data Block14Data;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block15Data Block15Data;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	guint _unsaved_document_n;
	gint _project_id;
	gboolean backup_made;
	char* _etag;
	char* encoding;
	gboolean new_file;
	GtkTextTag* found_tag;
	GtkTextTag* found_tag_selected;
	char* search_text;
	guint search_nb_matches;
	guint search_num_match;
	gboolean search_case_sensitive;
	gboolean search_entire_word;
	gboolean stop_cursor_moved_emission;
};

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
	gboolean locked;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _Block14Data {
	int _ref_count_;
	Document * self;
	CompletionProvider* provider;
};

struct _Block15Data {
	int _ref_count_;
	Document * self;
	TabInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};


static gpointer document_parent_class = NULL;

GType selection_type_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
#define DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT, DocumentPrivate))
enum  {
	DOCUMENT_DUMMY_PROPERTY,
	DOCUMENT_LOCATION,
	DOCUMENT_READONLY,
	DOCUMENT_UNSAVED_DOCUMENT_N,
	DOCUMENT_PROJECT_ID
};
Document* document_new (void);
Document* document_construct (GType object_type);
static void _lambda7_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda8_ (GtkTextIter* location, GtkTextMark* mark, Document* self);
static void document_emit_cursor_moved (Document* self);
static void __lambda8__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void _lambda9_ (Document* self);
static void __lambda9__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void document_sync_found_tags (Document* self);
static void _document_sync_found_tags_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean document_get_modified (Document* self);
void document_insert (Document* self, GtkTextIter* iter, const char* text, gint len);
GType completion_provider_get_type (void) G_GNUC_CONST;
CompletionProvider* completion_provider_get_default (void);
static gboolean _lambda10_ (Block14Data* _data14_);
static gboolean __lambda10__gsource_func (gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
void document_load (Document* self, GFile* location);
void document_set_location (Document* self, GFile* value);
void document_set_contents (Document* self, const char* contents);
static char* document_to_utf8 (Document* self, const char* text, GError** error);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GFile* document_get_location (Document* self);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const char* text, const char* stock_id, gint response_id);
static void _lambda12_ (gint response_id, Block15Data* _data15_);
static void __lambda12__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
void tab_info_bar_add_ok_button (TabInfoBar* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
GeeLinkedList* app_settings_get_projects (AppSettings* self);
void document_set_project_id (Document* self, gint value);
char* document_get_uri_for_display (Document* self);
static char* document_get_unsaved_document_name (Document* self);
char* utils_replace_home_dir_with_tilde (const char* uri);
char* document_get_short_name_for_display (Document* self);
guint document_get_unsaved_document_n (Document* self);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_set_style_scheme_from_string (Document* self, const char* scheme_id);
static void document_insert_text_at_beginning_of_selected_lines (Document* self, const char* text);
void document_comment_selected_lines (Document* self);
void document_uncomment_selected_lines (Document* self);
void document_select_lines (Document* self, gint start, gint end);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
void document_view_scroll_to_cursor (DocumentView* self, double margin);
SelectionType document_get_selection_type (Document* self);
gboolean document_is_tex_document (Document* self);
GType main_window_get_type (void) G_GNUC_CONST;
gboolean document_clean_build_files (Document* self, MainWindow* window);
GFile* document_get_main_file (Document* self);
char* utils_get_shortname (const char* path);
void utils_delete_file (GFile* file);
static void _vala_array_add12 (char*** array, int* length, int* size, char* value);
gboolean dialogs_confirm_clean_build_files (MainWindow* window, GFile* directory, char** basenames, int basenames_length1);
gboolean document_goto_line (Document* self, gint line);
gint document_get_project_id (Document* self);
Project* app_settings_get_project (AppSettings* self, gint id);
char* document_get_current_indentation (Document* self, gint line);
void document_set_search_text (Document* self, const char* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static void document_search_cursor_moved_handler (Document* self);
static void _document_search_cursor_moved_handler_document_cursor_moved (Document* _sender, gpointer self);
static void document_search_delete_range_before_handler (Document* self, GtkTextIter* start, GtkTextIter* end);
static void _document_search_delete_range_before_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
static void document_search_delete_range_after_handler (Document* self, GtkTextIter* location);
static void _document_search_delete_range_after_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
static void document_search_insert_text_before_handler (Document* self, GtkTextIter* location);
static void _document_search_insert_text_before_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self);
static void document_search_insert_text_after_handler (Document* self, GtkTextIter* location, const char* text, gint len);
static void _document_search_insert_text_after_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self);
static void document_invalidate_search_selected_marks (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
static gboolean document_iter_forward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end);
static void document_move_search_marks (Document* self, GtkTextIter* start, GtkTextIter* end, gboolean move_cursor);
static void document_clear_search_tags (Document* self);
void document_search_forward (Document* self);
static void document_replace_found_tag_selected (Document* self);
static void document_find_num_match (Document* self);
void document_search_backward (Document* self);
static gboolean document_iter_backward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end);
static GtkSourceSearchFlags document_get_search_flags (Document* self);
static void document_search_matches_between (Document* self, GtkTextIter* start_search, GtkTextIter* stop_search);
static void document_set_search_match_colors (Document* self, GtkTextTag* text_tag);
void document_replace (Document* self, const char* text);
gboolean document_get_readonly (Document* self);
void document_replace_all (Document* self, const char* text);
void document_set_readonly (Document* self, gboolean value);
void document_set_unsaved_document_n (Document* self, guint value);
static void document_finalize (GObject* obj);
static void document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

extern const char* ENCODINGS_CHARSETS[60];

static void g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType selection_type_get_type (void) {
	static volatile gsize selection_type_type_id__volatile = 0;
	if (g_once_init_enter (&selection_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SELECTION_TYPE_NO_SELECTION, "SELECTION_TYPE_NO_SELECTION", "no-selection"}, {SELECTION_TYPE_ONE_LINE, "SELECTION_TYPE_ONE_LINE", "one-line"}, {SELECTION_TYPE_MULTIPLE_LINES, "SELECTION_TYPE_MULTIPLE_LINES", "multiple-lines"}, {0, NULL, NULL}};
		GType selection_type_type_id;
		selection_type_type_id = g_enum_register_static ("SelectionType", values);
		g_once_init_leave (&selection_type_type_id__volatile, selection_type_type_id);
	}
	return selection_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda7_ (Document* self) {
	document_update_syntax_highlighting (self);
	document_update_project_id (self);
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (self);
}


static void _lambda8_ (GtkTextIter* location, GtkTextMark* mark, Document* self) {
	g_return_if_fail (mark != NULL);
	if (mark == gtk_text_buffer_get_insert ((GtkTextBuffer*) self)) {
		document_emit_cursor_moved (self);
	}
}


static void __lambda8__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	_lambda8_ (location, mark, self);
}


static void _lambda9_ (Document* self) {
	self->priv->new_file = FALSE;
	document_emit_cursor_moved (self);
}


static void __lambda9__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda9_ (self);
}


static void _document_sync_found_tags_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_sync_found_tags (self);
}


Document* document_construct (GType object_type) {
	Document * self;
	GtkSourceLanguageManager* lm;
	GtkTextTag* _tmp0_;
	GtkTextTag* _tmp1_;
	GtkTextTagTable* tag_table;
	GtkTextIter iter = {0};
	self = g_object_newv (object_type, 0, NULL);
	lm = _g_object_ref0 (gtk_source_language_manager_get_default ());
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, gtk_source_language_manager_get_language (lm, "latex"));
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) __lambda7__g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "mark-set", (GCallback) __lambda8__gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) __lambda9__gtk_text_buffer_changed, self, 0);
	self->priv->found_tag = (_tmp0_ = gtk_text_tag_new ("found"), _g_object_unref0 (self->priv->found_tag), _tmp0_);
	self->priv->found_tag_selected = (_tmp1_ = gtk_text_tag_new ("found_selected"), _g_object_unref0 (self->priv->found_tag_selected), _tmp1_);
	document_sync_found_tags (self);
	tag_table = _g_object_ref0 (gtk_text_buffer_get_tag_table ((GtkTextBuffer*) self));
	gtk_text_tag_table_add (tag_table, self->priv->found_tag);
	gtk_text_tag_table_add (tag_table, self->priv->found_tag_selected);
	g_signal_connect_object ((GObject*) self, "notify::style-scheme", (GCallback) _document_sync_found_tags_g_object_notify, self, 0);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &iter, 0);
	gtk_text_buffer_create_mark ((GtkTextBuffer*) self, "search_selected_start", &iter, TRUE);
	gtk_text_buffer_create_mark ((GtkTextBuffer*) self, "search_selected_end", &iter, TRUE);
	_g_object_unref0 (tag_table);
	_g_object_unref0 (lm);
	return self;
}


Document* document_new (void) {
	return document_construct (TYPE_DOCUMENT);
}


gboolean document_get_modified (Document* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->new_file) {
		result = FALSE;
		return result;
	}
	result = gtk_text_buffer_get_modified ((GtkTextBuffer*) GTK_SOURCE_BUFFER (self));
	return result;
}


static gboolean _lambda10_ (Block14Data* _data14_) {
	Document * self;
	gboolean result = FALSE;
	self = _data14_->self;
	_data14_->provider->locked = FALSE;
	result = FALSE;
	return result;
}


static gboolean __lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda10_ (self);
	return result;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->provider);
		g_slice_free (Block14Data, _data14_);
	}
}


void document_insert (Document* self, GtkTextIter* iter, const char* text, gint len) {
	Block14Data* _data14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_data14_->provider = completion_provider_get_default ();
	_data14_->provider->locked = TRUE;
	gtk_text_buffer_insert ((GtkTextBuffer*) GTK_SOURCE_BUFFER (self), iter, text, len);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda10__gsource_func, block14_data_ref (_data14_), block14_data_unref);
	block14_data_unref (_data14_);
}


void document_load (Document* self, GFile* location) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	document_set_location (self, location);
	{
		char* text;
		char* _tmp0_ = NULL;
		char* _tmp1_;
		char* _tmp2_ = NULL;
		char* _tmp3_;
		char* _tmp4_;
		text = NULL;
		(g_file_load_contents (location, NULL, &_tmp0_, NULL, &_tmp2_, &_inner_error_), text = (_tmp1_ = _tmp0_, _g_free0 (text), _tmp1_));
		self->priv->_etag = (_tmp3_ = _tmp2_, _g_free0 (self->priv->_etag), _tmp3_);
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			goto __catch35_g_error;
		}
		if (g_utf8_validate (text, -1, NULL)) {
			document_set_contents (self, text);
		} else {
			char* utf8_text;
			utf8_text = document_to_utf8 (self, text, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (text);
				goto __catch35_g_error;
			}
			document_set_contents (self, utf8_text);
			_g_free0 (utf8_text);
		}
		document_update_syntax_highlighting (self);
		gtk_recent_manager_add_item (gtk_recent_manager_get_default (), _tmp4_ = g_file_get_uri (location));
		_g_free0 (_tmp4_);
		_g_free0 (text);
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp5_;
			char* _tmp6_;
			char* primary_msg;
			TabInfoBar* _tmp7_;
			fprintf (stderr, "Error: %s\n", e->message);
			primary_msg = (_tmp6_ = g_strdup_printf (_ ("Impossible to load the file '%s'."), _tmp5_ = g_file_get_parse_name (location)), _g_free0 (_tmp5_), _tmp6_);
			_tmp7_ = document_tab_add_message (self->tab, primary_msg, e->message, GTK_MESSAGE_ERROR);
			_g_object_unref0 (_tmp7_);
			_g_free0 (primary_msg);
			_g_error_free0 (e);
		}
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


void document_set_contents (Document* self, const char* contents) {
	char* contents2;
	char* _tmp1_;
	GtkTextIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	contents2 = NULL;
	if (g_utf8_get_char (g_utf8_offset_to_pointer (contents, string_get_length (contents) - 1)) == '\n') {
		char* _tmp0_;
		contents2 = (_tmp0_ = string_slice (contents, (glong) 0, (glong) (-1)), _g_free0 (contents2), _tmp0_);
	}
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
	_tmp1_ = g_strdup (contents2);
	if (_tmp1_ == NULL) {
		char* _tmp2_;
		_tmp1_ = (_tmp2_ = g_strdup (contents), _g_free0 (_tmp1_), _tmp2_);
	}
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp1_, -1);
	self->priv->new_file = TRUE;
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &iter);
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &iter);
	_g_free0 (_tmp1_);
	_g_free0 (contents2);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _lambda12_ (gint response_id, Block15Data* _data15_) {
	Document * self;
	self = _data15_->self;
	if (response_id == GTK_RESPONSE_YES) {
		document_save (self, FALSE, FALSE);
	}
	gtk_object_destroy ((GtkObject*) _data15_->infobar);
}


static void __lambda12__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda12_ (response_id, self);
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->self);
		_g_object_unref0 (_data15_->infobar);
		g_slice_free (Block15Data, _data15_);
	}
}


void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	char* text;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_location != NULL);
	if (!force) {
		_tmp1_ = !self->priv->new_file;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !document_get_modified (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &start, &end);
	text = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &start, &end, FALSE);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (text, string_get_length (text) - 1)) != '\n') {
		char* _tmp2_;
		text = (_tmp2_ = g_strconcat (string_to_string (text), "\n", NULL), _g_free0 (text), _tmp2_);
	}
	{
		GSettings* settings;
		gboolean _tmp3_ = FALSE;
		gboolean make_backup;
		const char* _tmp4_;
		char* etag;
		GFile* parent;
		gboolean _tmp9_ = FALSE;
		char* _tmp10_ = NULL;
		char* _tmp11_;
		char* _tmp12_;
		settings = g_settings_new ("org.gnome.latexila.preferences.editor");
		if (!self->priv->backup_made) {
			_tmp3_ = g_settings_get_boolean (settings, "create-backup-copy");
		} else {
			_tmp3_ = FALSE;
		}
		make_backup = _tmp3_;
		_tmp4_ = NULL;
		if (check_file_changed_on_disk) {
			_tmp4_ = self->priv->_etag;
		} else {
			_tmp4_ = NULL;
		}
		etag = g_strdup (_tmp4_);
		if (self->priv->encoding != NULL) {
			char* _tmp5_;
			char* _tmp6_;
			_tmp5_ = g_convert (text, (gssize) strlen (text), self->priv->encoding, "UTF-8", NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch36_g_error;
			}
			text = (_tmp6_ = _tmp5_, _g_free0 (text), _tmp6_);
		} else {
			char* _tmp7_;
			char* _tmp8_;
			_tmp7_ = g_filename_from_utf8 (text, (gssize) strlen (text), NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch36_g_error;
			}
			text = (_tmp8_ = _tmp7_, _g_free0 (text), _tmp8_);
		}
		parent = g_file_get_parent (self->priv->_location);
		if (parent != NULL) {
			_tmp9_ = !g_file_query_exists (parent, NULL);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch36_g_error;
			}
		}
		g_file_replace_contents (self->priv->_location, text, strlen (text), etag, make_backup, G_FILE_CREATE_NONE, &_tmp10_, NULL, &_inner_error_);
		self->priv->_etag = (_tmp11_ = _tmp10_, _g_free0 (self->priv->_etag), _tmp11_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch36_g_error;
		}
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
		gtk_recent_manager_add_item (gtk_recent_manager_get_default (), _tmp12_ = g_file_get_uri (self->priv->_location));
		_g_free0 (_tmp12_);
		self->priv->backup_made = TRUE;
		_g_object_unref0 (parent);
		_g_free0 (etag);
		_g_object_unref0 (settings);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			if (g_error_matches (e, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
				Block15Data* _data15_;
				char* _tmp13_;
				char* _tmp14_;
				char* primary_msg;
				char* secondary_msg;
				_data15_ = g_slice_new0 (Block15Data);
				_data15_->_ref_count_ = 1;
				_data15_->self = g_object_ref (self);
				primary_msg = (_tmp14_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp13_ = g_file_get_parse_name (self->priv->_location)), _g_free0 (_tmp13_), _tmp14_);
				secondary_msg = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
				_data15_->infobar = document_tab_add_message (self->tab, primary_msg, secondary_msg, GTK_MESSAGE_WARNING);
				tab_info_bar_add_stock_button_with_text (_data15_->infobar, _ ("Save Anyway"), GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
				gtk_info_bar_add_button ((GtkInfoBar*) _data15_->infobar, _ ("Don't Save"), (gint) GTK_RESPONSE_CANCEL);
				g_signal_connect_data ((GtkInfoBar*) _data15_->infobar, "response", (GCallback) __lambda12__gtk_info_bar_response, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
				_g_free0 (secondary_msg);
				_g_free0 (primary_msg);
				block15_data_unref (_data15_);
			} else {
				char* primary_msg;
				TabInfoBar* infobar;
				fprintf (stderr, "Error: %s\n", e->message);
				primary_msg = g_strdup (_ ("Impossible to save the file."));
				infobar = document_tab_add_message (self->tab, primary_msg, e->message, GTK_MESSAGE_ERROR);
				tab_info_bar_add_ok_button (infobar);
				_g_object_unref0 (infobar);
				_g_free0 (primary_msg);
			}
			_g_error_free0 (e);
		}
	}
	__finally36:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (text);
}


static char* document_to_utf8 (Document* self, const char* text, GError** error) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		const char** charset_collection;
		int charset_collection_length1;
		int charset_it;
		charset_collection = ENCODINGS_CHARSETS;
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
		for (charset_it = 0; charset_it < G_N_ELEMENTS (ENCODINGS_CHARSETS); charset_it = charset_it + 1) {
			char* charset;
			charset = g_strdup (charset_collection[charset_it]);
			{
				{
					char* utf8_text;
					char* _tmp0_;
					utf8_text = g_convert (text, (gssize) strlen (text), "UTF-8", charset, NULL, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_CONVERT_ERROR) {
							goto __catch37_g_convert_error;
						}
						_g_free0 (charset);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					self->priv->encoding = (_tmp0_ = g_strdup (charset), _g_free0 (self->priv->encoding), _tmp0_);
					result = utf8_text;
					_g_free0 (charset);
					return result;
				}
				goto __finally37;
				__catch37_g_convert_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (e);
						_g_free0 (charset);
						continue;
					}
				}
				__finally37:
				{
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (charset);
						return NULL;
					} else {
						_g_free0 (charset);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (charset);
			}
		}
	}
	_inner_error_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
	{
		if (_inner_error_->domain == G_CONVERT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void document_update_syntax_highlighting (Document* self) {
	GtkSourceLanguageManager* lm;
	char* content_type;
	char* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	GtkSourceLanguage* lang;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	lm = _g_object_ref0 (gtk_source_language_manager_get_default ());
	content_type = NULL;
	{
		GFileInfo* info;
		char* _tmp0_;
		info = g_file_query_info (self->priv->_location, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
		}
		content_type = (_tmp0_ = g_strdup (g_file_info_get_content_type (info)), _g_free0 (content_type), _tmp0_);
		_g_object_unref0 (info);
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_free0 (content_type);
		_g_object_unref0 (lm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	lang = (_tmp2_ = _g_object_ref0 (gtk_source_language_manager_guess_language (lm, _tmp1_ = g_file_get_parse_name (self->priv->_location), content_type)), _g_free0 (_tmp1_), _tmp2_);
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
	_g_object_unref0 (lang);
	_g_free0 (content_type);
	_g_object_unref0 (lm);
}


static void document_update_project_id (Document* self) {
	AppSettings* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* projects;
	g_return_if_fail (self != NULL);
	projects = (_tmp1_ = app_settings_get_projects (_tmp0_ = app_settings_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				Project* _tmp3_;
				gboolean _tmp4_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < gee_collection_get_size ((GeeCollection*) projects))) {
					break;
				}
				if ((_tmp4_ = g_file_has_prefix (self->priv->_location, (*(_tmp3_ = (Project*) gee_abstract_list_get ((GeeAbstractList*) projects, i))).directory), _project_free0 (_tmp3_), _tmp4_)) {
					document_set_project_id (self, i);
					return;
				}
			}
		}
	}
}


char* document_get_uri_for_display (Document* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_location == NULL) {
		result = document_get_unsaved_document_name (self);
		return result;
	}
	result = (_tmp1_ = utils_replace_home_dir_with_tilde (_tmp0_ = g_file_get_parse_name (self->priv->_location)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


char* document_get_short_name_for_display (Document* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_location == NULL) {
		result = document_get_unsaved_document_name (self);
		return result;
	}
	result = g_file_get_basename (self->priv->_location);
	return result;
}


static char* document_get_unsaved_document_name (Document* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strconcat (_ ("Unsaved Document"), _tmp0_ = g_strdup_printf (" %u", self->priv->_unsaved_document_n), NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


gboolean document_is_local (Document* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_location == NULL) {
		result = FALSE;
		return result;
	}
	result = g_file_has_uri_scheme (self->priv->_location, "file");
	return result;
}


gboolean document_is_externally_modified (Document* self) {
	gboolean result = FALSE;
	char* current_etag;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_location == NULL) {
		result = FALSE;
		return result;
	}
	current_etag = NULL;
	{
		GFileInfo* file_info;
		char* _tmp0_;
		file_info = g_file_query_info (self->priv->_location, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch39_g_error;
		}
		current_etag = (_tmp0_ = g_strdup (g_file_info_get_etag (file_info)), _g_free0 (current_etag), _tmp0_);
		_g_object_unref0 (file_info);
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (current_etag);
			return result;
		}
	}
	__finally39:
	if (_inner_error_ != NULL) {
		_g_free0 (current_etag);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (current_etag != NULL) {
		_tmp1_ = _vala_strcmp0 (current_etag, self->priv->_etag) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_free0 (current_etag);
	return result;
}


void document_set_style_scheme_from_string (Document* self, const char* scheme_id) {
	GtkSourceStyleSchemeManager* manager;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scheme_id != NULL);
	manager = _g_object_ref0 (gtk_source_style_scheme_manager_get_default ());
	gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) self, gtk_source_style_scheme_manager_get_scheme (manager, scheme_id));
	_g_object_unref0 (manager);
}


static void document_emit_cursor_moved (Document* self) {
	g_return_if_fail (self != NULL);
	if (!self->priv->stop_cursor_moved_emission) {
		g_signal_emit_by_name (self, "cursor-moved");
	}
}


static void document_insert_text_at_beginning_of_selected_lines (Document* self, const char* text) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gint start_line;
	gint end_line;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &start, &end);
	start_line = gtk_text_iter_get_line (&start);
	end_line = gtk_text_iter_get_line (&end);
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i;
		i = start_line;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTextIter iter = {0};
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i <= end_line)) {
					break;
				}
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &iter, i);
				document_insert (self, &iter, text, -1);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_comment_selected_lines (Document* self) {
	g_return_if_fail (self != NULL);
	document_insert_text_at_beginning_of_selected_lines (self, "% ");
}


void document_uncomment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gint start_line;
	gint end_line;
	gint line_count;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &start, &end);
	start_line = gtk_text_iter_get_line (&start);
	end_line = gtk_text_iter_get_line (&end);
	line_count = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i;
		i = start_line;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* line;
				gint j;
				gint start_delete;
				gint stop_delete;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i <= end_line)) {
					break;
				}
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &start, i);
				if (i == (line_count - 1)) {
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &end);
				} else {
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &end, i + 1);
				}
				line = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &start, &end, FALSE);
				j = 0;
				start_delete = -1;
				stop_delete = -1;
				while (TRUE) {
					if (!(g_utf8_get_char (g_utf8_offset_to_pointer (line, j)) != '\0')) {
						break;
					}
					if (g_utf8_get_char (g_utf8_offset_to_pointer (line, j)) == '%') {
						start_delete = j;
						stop_delete = j + 1;
						if (g_utf8_get_char (g_utf8_offset_to_pointer (line, j + 1)) == ' ') {
							stop_delete++;
						}
						break;
					} else {
						gboolean _tmp1_ = FALSE;
						if (g_utf8_get_char (g_utf8_offset_to_pointer (line, j)) != ' ') {
							_tmp1_ = g_utf8_get_char (g_utf8_offset_to_pointer (line, j)) != '\t';
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							break;
						}
					}
					j++;
				}
				if (start_delete == (-1)) {
					_g_free0 (line);
					continue;
				}
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &start, i, start_delete);
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &end, i, stop_delete);
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
				_g_free0 (line);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_select_lines (Document* self, gint start, gint end) {
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &start_iter, start);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &end_iter, end);
	gtk_text_buffer_select_range ((GtkTextBuffer*) self, &start_iter, &end_iter);
	document_view_scroll_to_cursor (document_tab_get_view (self->tab), 0.25);
}


SelectionType document_get_selection_type (Document* self) {
	SelectionType result = 0;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	g_return_val_if_fail (self != NULL, 0);
	if (!gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self)) {
		result = SELECTION_TYPE_NO_SELECTION;
		return result;
	}
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &start, &end);
	if (gtk_text_iter_get_line (&start) == gtk_text_iter_get_line (&end)) {
		result = SELECTION_TYPE_ONE_LINE;
		return result;
	}
	result = SELECTION_TYPE_MULTIPLE_LINES;
	return result;
}


gboolean document_is_tex_document (Document* self) {
	gboolean result = FALSE;
	char* path;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_location == NULL) {
		result = FALSE;
		return result;
	}
	path = g_file_get_parse_name (self->priv->_location);
	result = g_str_has_suffix (path, ".tex");
	_g_free0 (path);
	return result;
}


static void _vala_array_add12 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gboolean document_clean_build_files (Document* self, MainWindow* window) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean ret;
	GSettings* settings;
	char* exts;
	gint extensions_length1;
	gint _extensions_size_;
	char** _tmp2_;
	char** _tmp1_;
	char** extensions;
	gboolean no_confirm;
	GFile* mainfile;
	GFile* directory;
	char* _tmp3_;
	char* _tmp4_;
	char* shortname;
	gint basenames_length1;
	gint _basenames_size_;
	char** _tmp6_;
	char** _tmp5_ = NULL;
	char** basenames;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	if (self->priv->_location == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !document_is_tex_document (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	ret = FALSE;
	settings = g_settings_new ("org.gnome.latexila.preferences.latex");
	exts = g_strdup (g_settings_get_string (settings, "clean-extensions"));
	extensions = (_tmp2_ = _tmp1_ = g_strsplit (exts, " ", 0), extensions_length1 = _vala_array_length (_tmp1_), _extensions_size_ = extensions_length1, _tmp2_);
	no_confirm = g_settings_get_boolean (settings, "no-confirm-clean");
	mainfile = document_get_main_file (self);
	directory = g_file_get_parent (mainfile);
	shortname = (_tmp4_ = utils_get_shortname (_tmp3_ = g_file_get_basename (mainfile)), _g_free0 (_tmp3_), _tmp4_);
	basenames = (_tmp6_ = (_tmp5_ = g_new0 (char*, 0 + 1), _tmp5_), basenames_length1 = 0, _basenames_size_ = basenames_length1, _tmp6_);
	{
		char** extension_collection;
		int extension_collection_length1;
		int extension_it;
		extension_collection = extensions;
		extension_collection_length1 = extensions_length1;
		for (extension_it = 0; extension_it < extensions_length1; extension_it = extension_it + 1) {
			char* extension;
			extension = g_strdup (extension_collection[extension_it]);
			{
				char* basename;
				GFile* file;
				basename = g_strconcat (shortname, extension, NULL);
				file = g_file_get_child (directory, basename);
				if (g_file_query_exists (file, NULL)) {
					ret = TRUE;
					if (no_confirm) {
						utils_delete_file (file);
					} else {
						_vala_array_add12 (&basenames, &basenames_length1, &_basenames_size_, g_strdup (basename));
					}
				}
				_g_object_unref0 (file);
				_g_free0 (basename);
				_g_free0 (extension);
			}
		}
	}
	if (no_confirm) {
		result = ret;
		basenames = (_vala_array_free (basenames, basenames_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (shortname);
		_g_object_unref0 (directory);
		_g_object_unref0 (mainfile);
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		_g_object_unref0 (settings);
		return result;
	} else {
		if (basenames_length1 > 0) {
			result = dialogs_confirm_clean_build_files (window, directory, basenames, basenames_length1);
			basenames = (_vala_array_free (basenames, basenames_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (shortname);
			_g_object_unref0 (directory);
			_g_object_unref0 (mainfile);
			extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			_g_object_unref0 (settings);
			return result;
		}
	}
	result = FALSE;
	basenames = (_vala_array_free (basenames, basenames_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (shortname);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (exts);
	_g_object_unref0 (settings);
	return result;
}


gboolean document_goto_line (Document* self, gint line) {
	gboolean result = FALSE;
	gboolean ret;
	GtkTextIter iter = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line >= (-1), FALSE);
	ret = TRUE;
	if (line >= gtk_text_buffer_get_line_count ((GtkTextBuffer*) self)) {
		ret = FALSE;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &iter);
	} else {
		gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &iter, line);
	}
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &iter);
	result = ret;
	return result;
}


GFile* document_get_main_file (Document* self) {
	GFile* result = NULL;
	AppSettings* _tmp0_;
	Project* _tmp1_;
	Project* project;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_location == NULL) {
		result = NULL;
		return result;
	}
	if (self->priv->_project_id == (-1)) {
		result = _g_object_ref0 (self->priv->_location);
		return result;
	}
	project = (_tmp1_ = app_settings_get_project (_tmp0_ = app_settings_get_default (), self->priv->_project_id), _g_object_unref0 (_tmp0_), _tmp1_);
	if (project == NULL) {
		result = _g_object_ref0 (self->priv->_location);
		_project_free0 (project);
		return result;
	}
	result = _g_object_ref0 ((*project).main_file);
	_project_free0 (project);
	return result;
}


static char* g_unichar_to_string (gunichar self) {
	char* result = NULL;
	char* str;
	str = (char*) g_new0 (gchar, 7);
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


char* document_get_current_indentation (Document* self, gint line) {
	char* result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	char* text;
	char* current_indent;
	g_return_val_if_fail (self != NULL, NULL);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &start_iter, line);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &end_iter, line + 1);
	text = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &start_iter, &end_iter, FALSE);
	current_indent = g_strdup ("");
	{
		glong i;
		i = (glong) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < string_get_length (text))) {
					break;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (text, i)) == ' ') {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = g_utf8_get_char (g_utf8_offset_to_pointer (text, i)) == '\t';
				}
				if (_tmp1_) {
					char* _tmp2_;
					char* _tmp3_;
					current_indent = (_tmp3_ = g_strconcat (current_indent, _tmp2_ = g_unichar_to_string (g_utf8_get_char (g_utf8_offset_to_pointer (text, i))), NULL), _g_free0 (current_indent), _tmp3_);
					_g_free0 (_tmp2_);
				} else {
					break;
				}
			}
		}
	}
	result = current_indent;
	_g_free0 (text);
	return result;
}


/***************
     *    SEARCH
     ***************/
static void _document_search_cursor_moved_handler_document_cursor_moved (Document* _sender, gpointer self) {
	document_search_cursor_moved_handler (self);
}


static void _document_search_delete_range_before_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	document_search_delete_range_before_handler (self, start, end);
}


static void _document_search_delete_range_after_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	document_search_delete_range_after_handler (self, start);
}


static void _document_search_insert_text_before_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self) {
	document_search_insert_text_before_handler (self, pos);
}


static void _document_search_insert_text_after_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self) {
	document_search_insert_text_after_handler (self, pos, text, length);
}


void document_set_search_text (Document* self, const char* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	char* _tmp2_;
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextIter insert = {0};
	gboolean next_match_after_cursor_found;
	guint i;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->search_text == NULL) {
		g_signal_connect_object (self, "cursor-moved", (GCallback) _document_search_cursor_moved_handler_document_cursor_moved, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "delete-range", (GCallback) _document_search_delete_range_before_handler_gtk_text_buffer_delete_range, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "delete-range", (GCallback) _document_search_delete_range_after_handler_gtk_text_buffer_delete_range, self, G_CONNECT_AFTER);
		g_signal_connect_object ((GtkTextBuffer*) self, "insert-text", (GCallback) _document_search_insert_text_before_handler_gtk_text_buffer_insert_text, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "insert-text", (GCallback) _document_search_insert_text_after_handler_gtk_text_buffer_insert_text, self, G_CONNECT_AFTER);
	}
	if (_vala_strcmp0 (self->priv->search_text, text) == 0) {
		_tmp1_ = self->priv->search_case_sensitive == case_sensitive;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->search_entire_word == entire_word;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		*nb_matches = self->priv->search_nb_matches;
		*num_match = self->priv->search_num_match;
		return;
	}
	document_invalidate_search_selected_marks (self);
	document_clear_search (self, FALSE);
	self->priv->search_text = (_tmp2_ = g_strdup (text), _g_free0 (self->priv->search_text), _tmp2_);
	self->priv->search_case_sensitive = case_sensitive;
	self->priv->search_entire_word = entire_word;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &start);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &insert, gtk_text_buffer_get_insert ((GtkTextBuffer*) self));
	next_match_after_cursor_found = !select;
	i = (guint) 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		if (!document_iter_forward_search (self, &start, NULL, &match_start, &match_end)) {
			break;
		}
		i++;
		if (!next_match_after_cursor_found) {
			_tmp3_ = gtk_text_iter_compare (&insert, &match_end) <= 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			next_match_after_cursor_found = TRUE;
			self->priv->search_num_match = *num_match = i;
			document_move_search_marks (self, &match_start, &match_end, TRUE);
		} else {
			gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
		}
		start = match_end;
	}
	if (!next_match_after_cursor_found) {
		_tmp4_ = i > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		self->priv->search_num_match = *num_match = i;
		document_move_search_marks (self, &match_start, &match_end, TRUE);
	}
	self->priv->search_nb_matches = *nb_matches = i;
	if (self->priv->search_nb_matches == 0) {
		document_clear_search_tags (self);
	}
}


void document_search_forward (Document* self) {
	GtkTextIter start_search = {0};
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	gboolean increment;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	if (self->priv->search_nb_matches == 0) {
		return;
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &start_search, gtk_text_buffer_get_insert ((GtkTextBuffer*) self));
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &start);
	increment = FALSE;
	if (gtk_text_iter_has_tag (&start_search, self->priv->found_tag_selected)) {
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &start_search, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end"));
		increment = TRUE;
	}
	document_replace_found_tag_selected (self);
	if (document_iter_forward_search (self, &start_search, NULL, &match_start, &match_end)) {
		document_move_search_marks (self, &match_start, &match_end, TRUE);
		if (increment) {
			self->priv->search_num_match++;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	} else {
		if (document_iter_forward_search (self, &start, NULL, &match_start, &match_end)) {
			document_move_search_marks (self, &match_start, &match_end, TRUE);
			self->priv->search_num_match = (guint) 1;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	}
	document_find_num_match (self);
}


void document_search_backward (Document* self) {
	GtkTextIter start_search = {0};
	GtkTextIter end = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	gboolean decrement;
	gboolean move_cursor;
	GtkTextIter start_prev;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	if (self->priv->search_nb_matches == 0) {
		return;
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &start_search, gtk_text_buffer_get_insert ((GtkTextBuffer*) self));
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &end);
	decrement = FALSE;
	move_cursor = TRUE;
	start_prev = start_search;
	gtk_text_iter_backward_char (&start_prev);
	if (gtk_text_iter_has_tag (&start_search, self->priv->found_tag_selected)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_text_iter_has_tag (&start_prev, self->priv->found_tag_selected);
	}
	if (_tmp0_) {
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &start_search, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start"));
		decrement = TRUE;
	} else {
		if (gtk_text_iter_has_tag (&start_search, self->priv->found_tag)) {
			move_cursor = FALSE;
			gtk_text_iter_forward_chars (&start_search, (gint) string_get_length (self->priv->search_text));
		} else {
			if (gtk_text_iter_has_tag (&start_prev, self->priv->found_tag)) {
				move_cursor = FALSE;
			}
		}
	}
	document_replace_found_tag_selected (self);
	if (document_iter_backward_search (self, &start_search, NULL, &match_start, &match_end)) {
		document_move_search_marks (self, &match_start, &match_end, move_cursor);
		if (decrement) {
			self->priv->search_num_match--;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	} else {
		if (document_iter_backward_search (self, &end, NULL, &match_start, &match_end)) {
			document_move_search_marks (self, &match_start, &match_end, TRUE);
			self->priv->search_num_match = self->priv->search_nb_matches;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	}
	document_find_num_match (self);
}


static gboolean document_iter_forward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(!found)) {
			break;
		}
		found = gtk_source_iter_forward_search (start, self->priv->search_text, document_get_search_flags (self), match_start, match_end, end);
		if (found) {
			_tmp0_ = self->priv->search_entire_word;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gboolean _tmp1_ = FALSE;
			if (gtk_text_iter_starts_word (match_start)) {
				_tmp1_ = gtk_text_iter_ends_word (match_end);
			} else {
				_tmp1_ = FALSE;
			}
			found = _tmp1_;
			if (!found) {
				*start = *match_end;
			}
		} else {
			break;
		}
	}
	result = found;
	return result;
}


static gboolean document_iter_backward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(!found)) {
			break;
		}
		found = gtk_source_iter_backward_search (start, self->priv->search_text, document_get_search_flags (self), match_start, match_end, end);
		if (found) {
			_tmp0_ = self->priv->search_entire_word;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gboolean _tmp1_ = FALSE;
			if (gtk_text_iter_starts_word (match_start)) {
				_tmp1_ = gtk_text_iter_ends_word (match_end);
			} else {
				_tmp1_ = FALSE;
			}
			found = _tmp1_;
			if (!found) {
				*start = *match_start;
			}
		} else {
			break;
		}
	}
	result = found;
	return result;
}


void document_clear_search (Document* self, gboolean disconnect_signals) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	document_clear_search_tags (self);
	self->priv->search_text = (_tmp0_ = NULL, _g_free0 (self->priv->search_text), _tmp0_);
	if (disconnect_signals) {
		guint _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		g_signal_parse_name ("cursor-moved", TYPE_DOCUMENT, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _document_search_cursor_moved_handler_document_cursor_moved, self);
		g_signal_parse_name ("delete-range", GTK_TYPE_TEXT_BUFFER, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _document_search_delete_range_before_handler_gtk_text_buffer_delete_range, self);
		g_signal_parse_name ("delete-range", GTK_TYPE_TEXT_BUFFER, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _document_search_delete_range_after_handler_gtk_text_buffer_delete_range, self);
		g_signal_parse_name ("insert-text", GTK_TYPE_TEXT_BUFFER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _document_search_insert_text_before_handler_gtk_text_buffer_insert_text, self);
		g_signal_parse_name ("insert-text", GTK_TYPE_TEXT_BUFFER, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _document_search_insert_text_after_handler_gtk_text_buffer_insert_text, self);
	}
}


static void document_clear_search_tags (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	g_return_if_fail (self != NULL);
	document_invalidate_search_selected_marks (self);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &start, &end);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &start, &end);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &start, &end);
}


static void document_search_cursor_moved_handler (Document* self) {
	GtkTextIter insert = {0};
	GtkTextIter insert_previous = {0};
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &insert, gtk_text_buffer_get_insert ((GtkTextBuffer*) self));
	insert_previous = insert;
	gtk_text_iter_backward_char (&insert_previous);
	if (gtk_text_iter_has_tag (&insert, self->priv->found_tag_selected)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_text_iter_has_tag (&insert_previous, self->priv->found_tag_selected);
	}
	if (_tmp0_) {
		return;
	}
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	if (gtk_text_iter_has_tag (&insert, self->priv->found_tag)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtk_text_iter_has_tag (&insert_previous, self->priv->found_tag);
	}
	if (_tmp1_) {
		document_search_backward (self);
	} else {
		g_signal_emit_by_name (self, "search-info-updated", FALSE, self->priv->search_nb_matches, (guint) 0);
	}
}


static void document_search_delete_range_before_handler (Document* self, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	g_return_if_fail (self != NULL);
	start_search = *start;
	gtk_text_iter_backward_chars (&start_search, ((gint) string_get_length (self->priv->search_text)) - 1);
	stop_search = *end;
	gtk_text_iter_forward_chars (&stop_search, ((gint) string_get_length (self->priv->search_text)) - 1);
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!document_iter_forward_search (self, &start_search, &stop_search, &match_start, &match_end)) {
			break;
		}
		if (gtk_text_iter_compare (&match_start, start) < 0) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = gtk_text_iter_compare (&match_end, end) > 0;
		}
		if (_tmp0_) {
			gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
			gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &match_start, &match_end);
		}
		self->priv->search_nb_matches--;
		start_search = match_end;
	}
}


static void document_search_delete_range_after_handler (Document* self, GtkTextIter* location) {
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	g_return_if_fail (self != NULL);
	start_search = stop_search = *location;
	gtk_text_iter_backward_chars (&start_search, ((gint) string_get_length (self->priv->search_text)) - 1);
	gtk_text_iter_forward_chars (&stop_search, ((gint) string_get_length (self->priv->search_text)) - 1);
	document_search_matches_between (self, &start_search, &stop_search);
}


static void document_search_insert_text_before_handler (Document* self, GtkTextIter* location) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (gtk_text_iter_has_tag (location, self->priv->found_tag)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_text_iter_has_tag (location, self->priv->found_tag_selected);
	}
	if (_tmp0_) {
		GtkTextIter start_search = {0};
		GtkTextIter match_start = {0};
		GtkTextIter match_end = {0};
		document_replace_found_tag_selected (self);
		document_invalidate_search_selected_marks (self);
		start_search = *location;
		gtk_text_iter_forward_chars (&start_search, ((gint) string_get_length (self->priv->search_text)) - 1);
		if (document_iter_backward_search (self, &start_search, NULL, &match_start, &match_end)) {
			if (gtk_text_iter_compare (location, &match_end) < 0) {
				gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
				gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &match_start, &match_end);
				self->priv->search_nb_matches--;
			}
		}
	}
}


static void document_search_insert_text_after_handler (Document* self, GtkTextIter* location, const char* text, gint len) {
	GtkTextIter left_text;
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	left_text = *location;
	gtk_text_iter_backward_chars (&left_text, len);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &left_text, location);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &left_text, location);
	start_search = stop_search = *location;
	gtk_text_iter_backward_chars (&start_search, (len + ((gint) string_get_length (self->priv->search_text))) - 1);
	gtk_text_iter_forward_chars (&stop_search, ((gint) string_get_length (self->priv->search_text)) - 1);
	document_search_matches_between (self, &start_search, &stop_search);
}


static void document_search_matches_between (Document* self, GtkTextIter* start_search, GtkTextIter* stop_search) {
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	g_return_if_fail (self != NULL);
	while (TRUE) {
		if (!document_iter_forward_search (self, start_search, stop_search, &match_start, &match_end)) {
			break;
		}
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
		self->priv->search_nb_matches++;
		*start_search = match_end;
	}
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	document_search_cursor_moved_handler (self);
}


static GtkSourceSearchFlags document_get_search_flags (Document* self) {
	GtkSourceSearchFlags result = 0;
	GtkSourceSearchFlags flags;
	g_return_val_if_fail (self != NULL, 0);
	flags = GTK_SOURCE_SEARCH_TEXT_ONLY | GTK_SOURCE_SEARCH_VISIBLE_ONLY;
	if (!self->priv->search_case_sensitive) {
		flags = flags | GTK_SOURCE_SEARCH_CASE_INSENSITIVE;
	}
	result = flags;
	return result;
}


static void document_move_search_marks (Document* self, GtkTextIter* start, GtkTextIter* end, gboolean move_cursor) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, start, end);
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, start, end);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_start", start);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_end", end);
	if (move_cursor) {
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, start);
		document_view_scroll_to_cursor (document_tab_get_view (self->tab), 0.25);
	}
}


static void document_replace_found_tag_selected (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &start, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start"));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &end, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end"));
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &start, &end);
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag, &start, &end);
}


static void document_find_num_match (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter stop = {0};
	GtkTextIter match_end = {0};
	guint i;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &start);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &stop, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start"));
	i = (guint) 0;
	while (TRUE) {
		if (!document_iter_forward_search (self, &start, &stop, NULL, &match_end)) {
			break;
		}
		i++;
		start = match_end;
	}
	self->priv->search_num_match = i + 1;
	g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
}


static void document_invalidate_search_selected_marks (Document* self) {
	GtkTextIter iter = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &iter);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_start", &iter);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_end", &iter);
}


static void document_set_search_match_colors (Document* self, GtkTextTag* text_tag) {
	GtkSourceStyleScheme* style_scheme;
	GtkSourceStyle* style;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	PangoWeight _tmp20_ = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_;
	PangoStyle _tmp24_ = 0;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	PangoUnderline _tmp28_ = 0;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text_tag != NULL);
	style_scheme = _g_object_ref0 (gtk_source_buffer_get_style_scheme ((GtkSourceBuffer*) self));
	style = NULL;
	if (style_scheme != NULL) {
		GtkSourceStyle* _tmp0_;
		style = (_tmp0_ = _g_object_ref0 (gtk_source_style_scheme_get_style (style_scheme, "search-match")), _g_object_unref0 (style), _tmp0_);
	}
	if (style_scheme == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = style == NULL;
	}
	if (_tmp1_) {
		g_object_set (text_tag, "background", "#FFFF78", NULL);
		_g_object_unref0 (style);
		_g_object_unref0 (style_scheme);
		return;
	}
	if ((g_object_get (style, "foreground-set", &_tmp3_, NULL), _tmp3_)) {
		char* _tmp4_ = NULL;
		char* _tmp5_;
		_tmp2_ = (_tmp5_ = (g_object_get (style, "foreground", &_tmp4_, NULL), _tmp4_)) != NULL;
		_g_free0 (_tmp5_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp6_ = NULL;
		char* _tmp7_;
		g_object_set (text_tag, "foreground", _tmp7_ = (g_object_get (style, "foreground", &_tmp6_, NULL), _tmp6_), NULL);
		_g_free0 (_tmp7_);
	} else {
		g_object_set (text_tag, "foreground", NULL, NULL);
	}
	if ((g_object_get (style, "background-set", &_tmp9_, NULL), _tmp9_)) {
		char* _tmp10_ = NULL;
		char* _tmp11_;
		_tmp8_ = (_tmp11_ = (g_object_get (style, "background", &_tmp10_, NULL), _tmp10_)) != NULL;
		_g_free0 (_tmp11_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		char* _tmp12_ = NULL;
		char* _tmp13_;
		g_object_set (text_tag, "background", _tmp13_ = (g_object_get (style, "background", &_tmp12_, NULL), _tmp12_), NULL);
		_g_free0 (_tmp13_);
	} else {
		g_object_set (text_tag, "background", NULL, NULL);
	}
	if ((g_object_get (style, "line-background-set", &_tmp15_, NULL), _tmp15_)) {
		char* _tmp16_ = NULL;
		char* _tmp17_;
		_tmp14_ = (_tmp17_ = (g_object_get (style, "line-background", &_tmp16_, NULL), _tmp16_)) != NULL;
		_g_free0 (_tmp17_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		char* _tmp18_ = NULL;
		char* _tmp19_;
		g_object_set (text_tag, "paragraph-background", _tmp19_ = (g_object_get (style, "line-background", &_tmp18_, NULL), _tmp18_), NULL);
		_g_free0 (_tmp19_);
	} else {
		g_object_set (text_tag, "paragraph-background", NULL, NULL);
	}
	if ((g_object_get (style, "bold-set", &_tmp22_, NULL), _tmp22_)) {
		gboolean _tmp23_;
		_tmp21_ = (g_object_get (style, "bold", &_tmp23_, NULL), _tmp23_);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = PANGO_WEIGHT_BOLD;
	} else {
		_tmp20_ = PANGO_WEIGHT_NORMAL;
	}
	g_object_set (text_tag, "weight", (gint) _tmp20_, NULL);
	if ((g_object_get (style, "italic-set", &_tmp26_, NULL), _tmp26_)) {
		gboolean _tmp27_;
		_tmp25_ = (g_object_get (style, "italic", &_tmp27_, NULL), _tmp27_);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		_tmp24_ = PANGO_STYLE_ITALIC;
	} else {
		_tmp24_ = PANGO_STYLE_NORMAL;
	}
	g_object_set (text_tag, "style", _tmp24_, NULL);
	if ((g_object_get (style, "underline-set", &_tmp30_, NULL), _tmp30_)) {
		gboolean _tmp31_;
		_tmp29_ = (g_object_get (style, "underline", &_tmp31_, NULL), _tmp31_);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		_tmp28_ = PANGO_UNDERLINE_SINGLE;
	} else {
		_tmp28_ = PANGO_UNDERLINE_NONE;
	}
	g_object_set (text_tag, "underline", _tmp28_, NULL);
	if ((g_object_get (style, "strikethrough-set", &_tmp33_, NULL), _tmp33_)) {
		gboolean _tmp34_;
		_tmp32_ = (g_object_get (style, "strikethrough", &_tmp34_, NULL), _tmp34_);
	} else {
		_tmp32_ = FALSE;
	}
	g_object_set (text_tag, "strikethrough", _tmp32_, NULL);
	_g_object_unref0 (style);
	_g_object_unref0 (style_scheme);
}


static void document_sync_found_tags (Document* self) {
	g_return_if_fail (self != NULL);
	document_set_search_match_colors (self, self->priv->found_tag);
	document_set_search_match_colors (self, self->priv->found_tag_selected);
	g_object_set (self->priv->found_tag_selected, "background", "#FF8C00", NULL);
}


/****************
     *    REPLACE
     ****************/
void document_replace (Document* self, const char* text) {
	GtkTextIter insert = {0};
	GtkTextIter insert_prev = {0};
	gboolean _tmp0_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	g_return_if_fail (!self->priv->_readonly);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &insert, gtk_text_buffer_get_insert ((GtkTextBuffer*) self));
	insert_prev = insert;
	gtk_text_iter_backward_char (&insert_prev);
	if (!gtk_text_iter_has_tag (&insert, self->priv->found_tag_selected)) {
		_tmp0_ = !gtk_text_iter_has_tag (&insert_prev, self->priv->found_tag_selected);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_search_forward (self);
		return;
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &start, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start"));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &end, gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end"));
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
	document_insert (self, &start, text, -1);
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
	if (!gtk_text_iter_has_tag (&start, self->priv->found_tag_selected)) {
		document_search_forward (self);
	}
}


void document_replace_all (Document* self, const char* text) {
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	g_return_if_fail (!self->priv->_readonly);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &start);
	self->priv->stop_cursor_moved_emission = TRUE;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	while (TRUE) {
		if (!document_iter_forward_search (self, &start, NULL, &match_start, &match_end)) {
			break;
		}
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &match_start, &match_end);
		document_insert (self, &match_start, text, -1);
		start = match_start;
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
	self->priv->stop_cursor_moved_emission = FALSE;
	document_emit_cursor_moved (self);
}


GFile* document_get_location (Document* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_location;
	return result;
}


void document_set_location (Document* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_location = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_location), _tmp0_);
	g_object_notify ((GObject *) self, "location");
}


gboolean document_get_readonly (Document* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readonly;
	return result;
}


void document_set_readonly (Document* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_readonly = value;
	g_object_notify ((GObject *) self, "readonly");
}


guint document_get_unsaved_document_n (Document* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_unsaved_document_n;
	return result;
}


void document_set_unsaved_document_n (Document* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_unsaved_document_n = value;
	g_object_notify ((GObject *) self, "unsaved-document-n");
}


gint document_get_project_id (Document* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_project_id;
	return result;
}


void document_set_project_id (Document* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_project_id = value;
	g_object_notify ((GObject *) self, "project-id");
}


static void document_class_init (DocumentClass * klass) {
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = document_get_property;
	G_OBJECT_CLASS (klass)->set_property = document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY, g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_UNSAVED_DOCUMENT_N, g_param_spec_uint ("unsaved-document-n", "unsaved-document-n", "unsaved-document-n", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID, g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("search_info_updated", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("cursor_moved", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_instance_init (Document * self) {
	self->priv = DOCUMENT_GET_PRIVATE (self);
	self->priv->_readonly = FALSE;
	self->priv->_project_id = -1;
	self->priv->backup_made = FALSE;
	self->priv->encoding = NULL;
	self->priv->new_file = TRUE;
	self->priv->stop_cursor_moved_emission = FALSE;
}


static void document_finalize (GObject* obj) {
	Document * self;
	self = DOCUMENT (obj);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->tab);
	_g_free0 (self->priv->_etag);
	_g_free0 (self->priv->encoding);
	_g_object_unref0 (self->priv->found_tag);
	_g_object_unref0 (self->priv->found_tag_selected);
	_g_free0 (self->priv->search_text);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}


GType document_get_type (void) {
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (GTK_TYPE_SOURCE_BUFFER, "Document", &g_define_type_info, 0);
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}


static void document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Document * self;
	self = DOCUMENT (object);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		g_value_set_object (value, document_get_location (self));
		break;
		case DOCUMENT_READONLY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		case DOCUMENT_UNSAVED_DOCUMENT_N:
		g_value_set_uint (value, document_get_unsaved_document_n (self));
		break;
		case DOCUMENT_PROJECT_ID:
		g_value_set_int (value, document_get_project_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Document * self;
	self = DOCUMENT (object);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		document_set_location (self, g_value_get_object (value));
		break;
		case DOCUMENT_READONLY:
		document_set_readonly (self, g_value_get_boolean (value));
		break;
		case DOCUMENT_UNSAVED_DOCUMENT_N:
		document_set_unsaved_document_n (self, g_value_get_uint (value));
		break;
		case DOCUMENT_PROJECT_ID:
		document_set_project_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_UINT_UINT) (gpointer data1, gboolean arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}



