/* tab_info_bar.c generated by valac 0.10.2, the Vala compiler
 * generated from tab_info_bar.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
typedef struct _TabInfoBarPrivate TabInfoBarPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TabInfoBar {
	GtkInfoBar parent_instance;
	TabInfoBarPrivate * priv;
};

struct _TabInfoBarClass {
	GtkInfoBarClass parent_class;
};


static gpointer tab_info_bar_parent_class = NULL;

GType tab_info_bar_get_type (void) G_GNUC_CONST;
enum  {
	TAB_INFO_BAR_DUMMY_PROPERTY
};
TabInfoBar* tab_info_bar_new (const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
TabInfoBar* tab_info_bar_construct (GType object_type, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
void tab_info_bar_add_ok_button (TabInfoBar* self);
static void _lambda11_ (gint response_id, TabInfoBar* self);
static void __lambda11__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const char* text, const char* stock_id, gint response_id);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TabInfoBar* tab_info_bar_construct (GType object_type, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type) {
	TabInfoBar * self;
	GtkHBox* content_area;
	char* stock_id;
	GtkImage* image;
	GtkVBox* vbox;
	char* _tmp4_;
	char* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* primary_label;
	char* _tmp7_;
	char* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* secondary_label;
	g_return_val_if_fail (primary_msg != NULL, NULL);
	g_return_val_if_fail (secondary_msg != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	content_area = _g_object_ref0 (GTK_HBOX (gtk_info_bar_get_content_area ((GtkInfoBar*) self)));
	stock_id = NULL;
	switch (msg_type) {
		case GTK_MESSAGE_ERROR:
		{
			char* _tmp0_;
			stock_id = (_tmp0_ = g_strdup (GTK_STOCK_DIALOG_ERROR), _g_free0 (stock_id), _tmp0_);
			break;
		}
		case GTK_MESSAGE_QUESTION:
		{
			char* _tmp1_;
			stock_id = (_tmp1_ = g_strdup (GTK_STOCK_DIALOG_QUESTION), _g_free0 (stock_id), _tmp1_);
			break;
		}
		case GTK_MESSAGE_WARNING:
		{
			char* _tmp2_;
			stock_id = (_tmp2_ = g_strdup (GTK_STOCK_DIALOG_WARNING), _g_free0 (stock_id), _tmp2_);
			break;
		}
		default:
		{
			char* _tmp3_;
			stock_id = (_tmp3_ = g_strdup (GTK_STOCK_DIALOG_INFO), _g_free0 (stock_id), _tmp3_);
			break;
		}
	}
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (stock_id, GTK_ICON_SIZE_DIALOG));
	gtk_misc_set_alignment ((GtkMisc*) image, (float) 0.5, (float) 0.0);
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 10));
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	primary_label = (_tmp6_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat ("<b>", primary_msg, NULL), "</b>", NULL))), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) primary_label, FALSE, FALSE, (guint) 0);
	gtk_misc_set_alignment ((GtkMisc*) primary_label, (float) 0.0, (float) 0.5);
	gtk_label_set_selectable (primary_label, TRUE);
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	secondary_label = (_tmp9_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat ("<small>", secondary_msg, NULL), "</small>", NULL))), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _tmp9_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) secondary_label, FALSE, FALSE, (guint) 0);
	gtk_misc_set_alignment ((GtkMisc*) secondary_label, (float) 0.0, (float) 0.5);
	gtk_label_set_selectable (secondary_label, TRUE);
	gtk_label_set_line_wrap (secondary_label, TRUE);
	gtk_label_set_use_markup (secondary_label, TRUE);
	gtk_info_bar_set_message_type ((GtkInfoBar*) self, msg_type);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (secondary_label);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_free0 (stock_id);
	_g_object_unref0 (content_area);
	return self;
}


TabInfoBar* tab_info_bar_new (const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type) {
	return tab_info_bar_construct (TYPE_TAB_INFO_BAR, primary_msg, secondary_msg, msg_type);
}


static void _lambda11_ (gint response_id, TabInfoBar* self) {
	if (response_id == GTK_RESPONSE_OK) {
		gtk_object_destroy ((GtkObject*) self);
	}
}


static void __lambda11__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda11_ (response_id, self);
}


void tab_info_bar_add_ok_button (TabInfoBar* self) {
	g_return_if_fail (self != NULL);
	gtk_info_bar_add_button ((GtkInfoBar*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK);
	g_signal_connect_object ((GtkInfoBar*) self, "response", (GCallback) __lambda11__gtk_info_bar_response, self, 0);
}


void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const char* text, const char* stock_id, gint response_id) {
	GtkButton* button;
	GtkImage* image;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (stock_id != NULL);
	button = _g_object_ref0 (GTK_BUTTON (gtk_info_bar_add_button ((GtkInfoBar*) self, text, response_id)));
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (stock_id, GTK_ICON_SIZE_BUTTON));
	gtk_button_set_image (button, (GtkWidget*) image);
	_g_object_unref0 (image);
	_g_object_unref0 (button);
}


static void tab_info_bar_class_init (TabInfoBarClass * klass) {
	tab_info_bar_parent_class = g_type_class_peek_parent (klass);
}


static void tab_info_bar_instance_init (TabInfoBar * self) {
}


GType tab_info_bar_get_type (void) {
	static volatile gsize tab_info_bar_type_id__volatile = 0;
	if (g_once_init_enter (&tab_info_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TabInfoBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_info_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabInfoBar), 0, (GInstanceInitFunc) tab_info_bar_instance_init, NULL };
		GType tab_info_bar_type_id;
		tab_info_bar_type_id = g_type_register_static (GTK_TYPE_INFO_BAR, "TabInfoBar", &g_define_type_info, 0);
		g_once_init_leave (&tab_info_bar_type_id__volatile, tab_info_bar_type_id);
	}
	return tab_info_bar_type_id__volatile;
}




