/* build_tool_dialog.c generated by valac 0.10.3, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())
typedef struct _BuildToolDialogIconColumn BuildToolDialogIconColumn;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

struct _BuildToolDialog {
	GtkDialog parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GtkDialogClass parent_class;
};

struct _BuildToolDialogPrivate {
	GtkEntry* entry_label;
	GtkEntry* entry_desc;
	GtkEntry* entry_extensions;
	GtkComboBox* combobox_icon;
	GtkEntry* entry_command;
	GtkButton* button_add;
	GtkTreeView* treeview_jobs;
	GtkButton* button_delete;
	GtkButton* button_up;
	GtkButton* button_down;
	GtkListStore* jobs_store;
};

typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

struct _BuildToolDialogIconColumn {
	char* stock_id;
	char* label;
};

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};


static BuildToolDialog* build_tool_dialog_instance;
static BuildToolDialog* build_tool_dialog_instance = NULL;
static gpointer build_tool_dialog_parent_class = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogPrivate))
enum  {
	BUILD_TOOL_DIALOG_DUMMY_PROPERTY
};
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_UNUSED;
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest);
static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self);
static BuildToolDialog* build_tool_dialog_new (void);
static BuildToolDialog* build_tool_dialog_construct (GType object_type);
static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_actions (BuildToolDialog* self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num);
static void _lambda101_ (void);
static void __lambda101__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void build_tool_dialog_init (BuildToolDialog* self, gint num);
static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint num);
static void _lambda95_ (const char* path_string, const char* new_text, BuildToolDialog* self);
static void __lambda95__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const char* path, const char* new_text, gpointer self);
static void _lambda96_ (const char* path_string, BuildToolDialog* self);
static void __lambda96__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const char* path, gpointer self);
static void _lambda97_ (const char* path_string, const char* new_text, BuildToolDialog* self);
static void __lambda97__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const char* path, const char* new_text, gpointer self);
static void build_tool_dialog_on_command_add (BuildToolDialog* self);
static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda98_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter_to_set);
static void __lambda98__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda99_ (BuildToolDialog* self);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void __lambda99__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda100_ (BuildToolDialog* self);
static void __lambda100__gtk_button_clicked (GtkButton* _sender, gpointer self);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeLinkedList* app_settings_get_build_tools (AppSettings* self);
static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool);
void app_settings_append_build_tool (AppSettings* self, BuildTool* tool);
void app_settings_update_build_tool (AppSettings* self, gint num, BuildTool* tool);
static void build_tool_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const BuildToolDialogIconColumn BUILD_TOOL_DIALOG_icons[9] = {{GTK_STOCK_EXECUTE, N_ ("Execute")}, {"compile_dvi", "LaTeX → DVI"}, {"compile_pdf", "LaTeX → PDF"}, {"compile_ps", "LaTeX → PS"}, {GTK_STOCK_CONVERT, N_ ("Convert")}, {GTK_STOCK_FILE, N_ ("View File")}, {"view_dvi", N_ ("View DVI")}, {"view_pdf", N_ ("View PDF")}, {"view_ps", N_ ("View PS")}};


static GType build_tool_dialog_job_column_get_type (void) {
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, "BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED", "must-succeed"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static BuildToolDialog* build_tool_dialog_construct (GType object_type) {
	BuildToolDialog * self;
	GError * _inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK);
	gtk_window_set_title ((GtkWindow*) self, _ ("Build Tool"));
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	{
		char* path;
		GtkBuilder* builder;
		GtkVBox* main_vbox;
		GtkEntry* _tmp0_;
		GtkEntry* _tmp1_;
		GtkEntry* _tmp2_;
		GtkComboBox* _tmp3_;
		GtkEntry* _tmp4_;
		GtkButton* _tmp5_;
		GtkTreeView* _tmp6_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		GtkBox* content_area;
		path = g_build_filename (DATA_DIR, "ui", "build_tool.ui", NULL);
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			_g_free0 (path);
			goto __catch43_g_error;
		}
		main_vbox = _g_object_ref0 (GTK_VBOX (gtk_builder_get_object (builder, "main_vbox")));
		gtk_widget_unparent ((GtkWidget*) main_vbox);
		self->priv->entry_label = (_tmp0_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry_label"))), _g_object_unref0 (self->priv->entry_label), _tmp0_);
		self->priv->entry_desc = (_tmp1_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry_desc"))), _g_object_unref0 (self->priv->entry_desc), _tmp1_);
		self->priv->entry_extensions = (_tmp2_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry_extensions"))), _g_object_unref0 (self->priv->entry_extensions), _tmp2_);
		self->priv->combobox_icon = (_tmp3_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (builder, "combobox_icon"))), _g_object_unref0 (self->priv->combobox_icon), _tmp3_);
		self->priv->entry_command = (_tmp4_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry_command"))), _g_object_unref0 (self->priv->entry_command), _tmp4_);
		self->priv->button_add = (_tmp5_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_add"))), _g_object_unref0 (self->priv->button_add), _tmp5_);
		self->priv->treeview_jobs = (_tmp6_ = _g_object_ref0 (GTK_TREE_VIEW (gtk_builder_get_object (builder, "treeview_jobs"))), _g_object_unref0 (self->priv->treeview_jobs), _tmp6_);
		self->priv->button_delete = (_tmp7_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_delete"))), _g_object_unref0 (self->priv->button_delete), _tmp7_);
		self->priv->button_up = (_tmp8_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_up"))), _g_object_unref0 (self->priv->button_up), _tmp8_);
		self->priv->button_down = (_tmp9_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_down"))), _g_object_unref0 (self->priv->button_down), _tmp9_);
		content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area ((GtkDialog*) self)));
		gtk_box_pack_start (content_area, (GtkWidget*) main_vbox, TRUE, TRUE, (guint) 0);
		gtk_widget_show_all ((GtkWidget*) content_area);
		build_tool_dialog_init_icon_treeview (self);
		build_tool_dialog_init_jobs_treeview (self);
		build_tool_dialog_init_actions (self);
		_g_object_unref0 (content_area);
		_g_object_unref0 (main_vbox);
		_g_object_unref0 (builder);
		_g_free0 (path);
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* message;
			GtkLabel* label_error;
			GtkBox* content_area;
			message = g_strdup_printf ("Error: %s", e->message);
			fprintf (stderr, "%s\n", message);
			label_error = g_object_ref_sink ((GtkLabel*) gtk_label_new (message));
			gtk_label_set_line_wrap (label_error, TRUE);
			content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area ((GtkDialog*) self)));
			gtk_box_pack_start (content_area, (GtkWidget*) label_error, TRUE, TRUE, (guint) 0);
			gtk_widget_show_all ((GtkWidget*) content_area);
			_g_object_unref0 (content_area);
			_g_object_unref0 (label_error);
			_g_free0 (message);
			_g_error_free0 (e);
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static BuildToolDialog* build_tool_dialog_new (void) {
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG);
}


static void _lambda101_ (void) {
	if (build_tool_dialog_instance != NULL) {
		BuildToolDialog* _tmp0_;
		build_tool_dialog_instance = (_tmp0_ = NULL, _g_object_unref0 (build_tool_dialog_instance), _tmp0_);
	}
}


static void __lambda101__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda101_ ();
}


gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num) {
	gboolean result = FALSE;
	g_return_val_if_fail (parent != NULL, FALSE);
	if (build_tool_dialog_instance == NULL) {
		BuildToolDialog* _tmp0_;
		build_tool_dialog_instance = (_tmp0_ = g_object_ref_sink (build_tool_dialog_new ()), _g_object_unref0 (build_tool_dialog_instance), _tmp0_);
		g_signal_connect ((GtkObject*) build_tool_dialog_instance, "destroy", (GCallback) __lambda101__gtk_object_destroy, NULL);
	}
	if (parent != gtk_window_get_transient_for ((GtkWindow*) build_tool_dialog_instance)) {
		gtk_window_set_transient_for ((GtkWindow*) build_tool_dialog_instance, parent);
	}
	gtk_window_present ((GtkWindow*) build_tool_dialog_instance);
	build_tool_dialog_init (build_tool_dialog_instance, num);
	result = build_tool_dialog_run_me (build_tool_dialog_instance, num);
	return result;
}


static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self) {
	GtkListStore* icon_store;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* text_renderer;
	g_return_if_fail (self != NULL);
	icon_store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	{
		BuildToolDialogIconColumn* icon_collection;
		int icon_collection_length1;
		int icon_it;
		icon_collection = BUILD_TOOL_DIALOG_icons;
		icon_collection_length1 = G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons);
		for (icon_it = 0; icon_it < G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons); icon_it = icon_it + 1) {
			BuildToolDialogIconColumn _tmp0_ = {0};
			BuildToolDialogIconColumn icon;
			icon = (build_tool_dialog_icon_column_copy (&icon_collection[icon_it], &_tmp0_), _tmp0_);
			{
				GtkTreeIter iter = {0};
				gtk_list_store_append (icon_store, &iter);
				gtk_list_store_set (icon_store, &iter, 0, icon.stock_id, 1, _ (icon.label), -1, -1);
				build_tool_dialog_icon_column_destroy (&icon);
			}
		}
	}
	gtk_combo_box_set_model (self->priv->combobox_icon, (GtkTreeModel*) icon_store);
	pixbuf_renderer = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) pixbuf_renderer, "stock-id", 0, NULL, NULL);
	text_renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) text_renderer, "text", 1, NULL, NULL);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (icon_store);
}


static void _lambda95_ (const char* path_string, const char* new_text, BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->jobs_store, &iter, path_string);
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, new_text, -1, -1);
}


static void __lambda95__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const char* path, const char* new_text, gpointer self) {
	_lambda95_ (path, new_text, self);
}


static void _lambda96_ (const char* path_string, BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	gboolean val = FALSE;
	GtkTreeModel* model;
	g_return_if_fail (path_string != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->jobs_store, &iter, path_string);
	model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->jobs_store));
	gtk_tree_model_get (model, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &val, -1, -1);
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, !val, -1, -1);
	_g_object_unref0 (model);
}


static void __lambda96__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const char* path, gpointer self) {
	_lambda96_ (path, self);
}


static void _lambda97_ (const char* path_string, const char* new_text, BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->jobs_store, &iter, path_string);
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, new_text, -1, -1);
}


static void __lambda97__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const char* path, const char* new_text, gpointer self) {
	_lambda97_ (path, new_text, self);
}


static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_;
	GtkListStore* post_processor_store;
	gint post_processors_length1;
	gint _post_processors_size_;
	char** _tmp2_;
	char** _tmp1_ = NULL;
	char** post_processors;
	GtkCellRendererText* text_renderer;
	GtkCellRendererToggle* toggle_renderer;
	GtkCellRendererCombo* combo_renderer;
	g_return_if_fail (self != NULL);
	self->priv->jobs_store = (_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING), _g_object_unref0 (self->priv->jobs_store), _tmp0_);
	gtk_tree_view_set_model (self->priv->treeview_jobs, (GtkTreeModel*) self->priv->jobs_store);
	post_processor_store = gtk_list_store_new (1, G_TYPE_STRING);
	post_processors = (_tmp2_ = (_tmp1_ = g_new0 (char*, 3 + 1), _tmp1_[0] = g_strdup ("no-output"), _tmp1_[1] = g_strdup ("all-output"), _tmp1_[2] = g_strdup ("rubber"), _tmp1_), post_processors_length1 = 3, _post_processors_size_ = post_processors_length1, _tmp2_);
	{
		char** post_processor_collection;
		int post_processor_collection_length1;
		int post_processor_it;
		post_processor_collection = post_processors;
		post_processor_collection_length1 = post_processors_length1;
		for (post_processor_it = 0; post_processor_it < post_processors_length1; post_processor_it = post_processor_it + 1) {
			char* post_processor;
			post_processor = g_strdup (post_processor_collection[post_processor_it]);
			{
				GtkTreeIter iterpp = {0};
				gtk_list_store_append (post_processor_store, &iterpp);
				gtk_list_store_set (post_processor_store, &iterpp, 0, post_processor, -1, -1);
				_g_free0 (post_processor);
			}
		}
	}
	text_renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	g_object_set (text_renderer, "editable", TRUE, NULL);
	gtk_tree_view_insert_column_with_attributes (self->priv->treeview_jobs, -1, _ ("Commands"), (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL, NULL);
	toggle_renderer = g_object_ref_sink ((GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ());
	gtk_cell_renderer_toggle_set_activatable (toggle_renderer, TRUE);
	gtk_tree_view_insert_column_with_attributes (self->priv->treeview_jobs, -1, _ ("Must Succeed"), (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, NULL, NULL);
	combo_renderer = g_object_ref_sink ((GtkCellRendererCombo*) gtk_cell_renderer_combo_new ());
	g_object_set ((GtkCellRendererText*) combo_renderer, "editable", TRUE, NULL);
	g_object_set (combo_renderer, "model", (GtkTreeModel*) post_processor_store, NULL);
	g_object_set (combo_renderer, "text-column", 0, NULL);
	g_object_set (combo_renderer, "has-entry", FALSE, NULL);
	gtk_tree_view_insert_column_with_attributes (self->priv->treeview_jobs, -1, _ ("Post Processor"), (GtkCellRenderer*) combo_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL, NULL);
	g_signal_connect_object (text_renderer, "edited", (GCallback) __lambda95__gtk_cell_renderer_text_edited, self, 0);
	g_signal_connect_object (toggle_renderer, "toggled", (GCallback) __lambda96__gtk_cell_renderer_toggle_toggled, self, 0);
	g_signal_connect_object ((GtkCellRendererText*) combo_renderer, "edited", (GCallback) __lambda97__gtk_cell_renderer_text_edited, self, 0);
	_g_object_unref0 (combo_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (text_renderer);
	post_processors = (_vala_array_free (post_processors, post_processors_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (post_processor_store);
}


static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void _lambda98_ (BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	gint i;
	i = utils_get_selected_row (self->priv->treeview_jobs, &iter);
	if (i != (-1)) {
		gtk_list_store_remove (self->priv->jobs_store, &iter);
	}
}


static void __lambda98__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda98_ (self);
}


static void _lambda99_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	gint i;
	gboolean _tmp0_ = FALSE;
	i = utils_get_selected_row (self->priv->treeview_jobs, &iter1);
	if (i != (-1)) {
		_tmp0_ = i > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		iter2 = iter1;
		if (utils_tree_model_iter_prev ((GtkTreeModel*) self->priv->jobs_store, &iter2)) {
			gtk_list_store_swap (self->priv->jobs_store, &iter1, &iter2);
		}
	}
}


static void __lambda99__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda99_ (self);
}


static void _lambda100_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	gint i;
	i = utils_get_selected_row (self->priv->treeview_jobs, &iter1);
	if (i != (-1)) {
		iter2 = iter1;
		if (gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->jobs_store, &iter2)) {
			gtk_list_store_swap (self->priv->jobs_store, &iter1, &iter2);
		}
	}
}


static void __lambda100__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda100_ (self);
}


static void build_tool_dialog_init_actions (BuildToolDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->priv->button_add, "clicked", (GCallback) _build_tool_dialog_on_command_add_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->entry_command, "activate", (GCallback) _build_tool_dialog_on_command_add_gtk_entry_activate, self, 0);
	g_signal_connect_object (self->priv->button_delete, "clicked", (GCallback) __lambda98__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_up, "clicked", (GCallback) __lambda99__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_down, "clicked", (GCallback) __lambda100__gtk_button_clicked, self, 0);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void build_tool_dialog_on_command_add (BuildToolDialog* self) {
	char* _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	if ((_tmp1_ = _vala_strcmp0 (_tmp0_ = string_strip (gtk_entry_get_text (self->priv->entry_command)), "") == 0, _g_free0 (_tmp0_), _tmp1_)) {
		return;
	}
	gtk_list_store_append (self->priv->jobs_store, &iter);
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, gtk_entry_get_text (self->priv->entry_command), BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, TRUE, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "no-output", -1, -1);
	gtk_entry_set_text (self->priv->entry_command, "");
}


static void build_tool_dialog_init (BuildToolDialog* self, gint num) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry_command, "");
	gtk_list_store_clear (self->priv->jobs_store);
	utils_set_entry_error ((GtkWidget*) self->priv->entry_label, FALSE);
	utils_set_entry_error ((GtkWidget*) self->priv->entry_command, FALSE);
	if (num == (-1)) {
		build_tool_dialog_init_new_build_tool (build_tool_dialog_instance);
	} else {
		AppSettings* _tmp0_;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* tools;
		BuildTool* _tmp2_;
		tools = (_tmp1_ = app_settings_get_build_tools (_tmp0_ = app_settings_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		build_tool_dialog_init_with_build_tool (build_tool_dialog_instance, _tmp2_ = (BuildTool*) gee_abstract_list_get ((GeeAbstractList*) tools, num));
		_build_tool_free0 (_tmp2_);
	}
	gtk_tree_view_columns_autosize (self->priv->treeview_jobs);
}


static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry_label, "");
	gtk_entry_set_text (self->priv->entry_desc, "");
	gtk_entry_set_text (self->priv->entry_extensions, ".tex");
	gtk_combo_box_set_active (self->priv->combobox_icon, 0);
}


static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry_label, (*tool).label);
	gtk_entry_set_text (self->priv->entry_desc, (*tool).description);
	gtk_entry_set_text (self->priv->entry_extensions, (*tool).extensions);
	gtk_combo_box_set_active (self->priv->combobox_icon, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons))) {
					break;
				}
				if (_vala_strcmp0 (BUILD_TOOL_DIALOG_icons[i].stock_id, (*tool).icon) == 0) {
					gtk_combo_box_set_active (self->priv->combobox_icon, i);
					break;
				}
			}
		}
	}
	gtk_list_store_clear (self->priv->jobs_store);
	{
		GList* job_collection;
		GList* job_it;
		job_collection = (*tool).jobs;
		for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
			BuildJob _tmp1_ = {0};
			BuildJob job;
			job = (build_job_copy ((BuildJob*) job_it->data, &_tmp1_), _tmp1_);
			{
				GtkTreeIter iter = {0};
				gtk_list_store_append (self->priv->jobs_store, &iter);
				gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, job.command, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, job.must_succeed, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, job.post_processor, -1, -1);
				build_job_destroy (&job);
			}
		}
	}
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint num) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		gboolean ok;
		char* _tmp0_;
		gboolean _tmp1_;
		GtkTreeIter iter = {0};
		BuildTool tool = {0};
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		gboolean _tmp5_;
		char* _tmp8_;
		char* _tmp9_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp10_;
		gboolean valid;
		if (!(gtk_dialog_run ((GtkDialog*) self) == GTK_RESPONSE_OK)) {
			break;
		}
		ok = TRUE;
		if ((_tmp1_ = _vala_strcmp0 (_tmp0_ = string_strip (gtk_entry_get_text (self->priv->entry_label)), "") == 0, _g_free0 (_tmp0_), _tmp1_)) {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_label, TRUE);
			ok = FALSE;
		} else {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_label, FALSE);
		}
		if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->jobs_store, &iter)) {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_command, TRUE);
			ok = FALSE;
		} else {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_command, FALSE);
		}
		if (!ok) {
			continue;
		}
		memset (&tool, 0, sizeof (BuildTool));
		tool.label = (_tmp2_ = string_strip (gtk_entry_get_text (self->priv->entry_label)), _g_free0 (tool.label), _tmp2_);
		_tmp3_ = NULL;
		if ((_tmp5_ = _vala_strcmp0 (_tmp4_ = string_strip (gtk_entry_get_text (self->priv->entry_desc)), "") == 0, _g_free0 (_tmp4_), _tmp5_)) {
			char* _tmp6_;
			_tmp3_ = (_tmp6_ = g_strdup (tool.label), _g_free0 (_tmp3_), _tmp6_);
		} else {
			char* _tmp7_;
			_tmp3_ = (_tmp7_ = string_strip (gtk_entry_get_text (self->priv->entry_desc)), _g_free0 (_tmp3_), _tmp7_);
		}
		tool.description = (_tmp8_ = g_strdup (_tmp3_), _g_free0 (tool.description), _tmp8_);
		tool.extensions = (_tmp9_ = string_strip (gtk_entry_get_text (self->priv->entry_extensions)), _g_free0 (tool.extensions), _tmp9_);
		gtk_combo_box_get_active_iter (self->priv->combobox_icon, &iter);
		model = _g_object_ref0 (gtk_combo_box_get_model (self->priv->combobox_icon));
		gtk_tree_model_get (model, &iter, 0, &tool.icon, -1, -1);
		model = (_tmp10_ = _g_object_ref0 (gtk_tree_view_get_model (self->priv->treeview_jobs)), _g_object_unref0 (model), _tmp10_);
		valid = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->jobs_store, &iter);
		while (TRUE) {
			BuildJob job = {0};
			char* command;
			char* _tmp11_;
			if (!valid) {
				break;
			}
			memset (&job, 0, sizeof (BuildJob));
			command = NULL;
			gtk_tree_model_get (model, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &command, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &job.must_succeed, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &job.post_processor, -1, -1);
			job.command = (_tmp11_ = string_strip (command), _g_free0 (job.command), _tmp11_);
			tool.jobs = g_list_append (tool.jobs, _build_job_dup0 (&job));
			valid = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->jobs_store, &iter);
			_g_free0 (command);
			build_job_destroy (&job);
		}
		if (num == (-1)) {
			AppSettings* _tmp12_;
			app_settings_append_build_tool (_tmp12_ = app_settings_get_default (), &tool);
			_g_object_unref0 (_tmp12_);
		} else {
			AppSettings* _tmp13_;
			app_settings_update_build_tool (_tmp13_ = app_settings_get_default (), num, &tool);
			_g_object_unref0 (_tmp13_);
		}
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (model);
		_g_free0 (_tmp3_);
		build_tool_destroy (&tool);
		return result;
	}
	gtk_widget_hide ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest) {
	dest->stock_id = g_strdup (self->stock_id);
	dest->label = g_strdup (self->label);
}


static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self) {
	_g_free0 (self->stock_id);
	_g_free0 (self->label);
}


static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self) {
	BuildToolDialogIconColumn* dup;
	dup = g_new0 (BuildToolDialogIconColumn, 1);
	build_tool_dialog_icon_column_copy (self, dup);
	return dup;
}


static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self) {
	build_tool_dialog_icon_column_destroy (self);
	g_free (self);
}


static GType build_tool_dialog_icon_column_get_type (void) {
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = g_boxed_type_register_static ("BuildToolDialogIconColumn", (GBoxedCopyFunc) build_tool_dialog_icon_column_dup, (GBoxedFreeFunc) build_tool_dialog_icon_column_free);
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}


static void build_tool_dialog_class_init (BuildToolDialogClass * klass) {
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
}


static void build_tool_dialog_instance_init (BuildToolDialog * self) {
	self->priv = BUILD_TOOL_DIALOG_GET_PRIVATE (self);
}


static void build_tool_dialog_finalize (GObject* obj) {
	BuildToolDialog * self;
	self = BUILD_TOOL_DIALOG (obj);
	_g_object_unref0 (self->priv->entry_label);
	_g_object_unref0 (self->priv->entry_desc);
	_g_object_unref0 (self->priv->entry_extensions);
	_g_object_unref0 (self->priv->combobox_icon);
	_g_object_unref0 (self->priv->entry_command);
	_g_object_unref0 (self->priv->button_add);
	_g_object_unref0 (self->priv->treeview_jobs);
	_g_object_unref0 (self->priv->button_delete);
	_g_object_unref0 (self->priv->button_up);
	_g_object_unref0 (self->priv->button_down);
	_g_object_unref0 (self->priv->jobs_store);
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
}


GType build_tool_dialog_get_type (void) {
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "BuildToolDialog", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




