/* file_browser.c generated by valac 0.10.3, the Vala compiler
 * generated from file_browser.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksourceview.h>
#include <pango/pango.h>
#include <stdio.h>


#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;
typedef struct _FileBrowserPrivate FileBrowserPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define FILE_BROWSER_TYPE_PARENT_DIR_COLUMN (file_browser_parent_dir_column_get_type ())

#define FILE_BROWSER_TYPE_FILE_COLUMN (file_browser_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block11Data Block11Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

struct _FileBrowser {
	GtkVBox parent_instance;
	FileBrowserPrivate * priv;
};

struct _FileBrowserClass {
	GtkVBoxClass parent_class;
};

struct _FileBrowserPrivate {
	MainWindow* main_window;
	BuildView* build_view;
	GtkListStore* parent_dir_store;
	GtkListStore* list_store;
	GtkComboBox* combo_box;
	GFile* current_directory;
	GtkButton* parent_button;
	GSettings* settings;
	GSettings* latex_settings;
	guint timeout_id;
};

typedef enum  {
	FILE_BROWSER_PARENT_DIR_COLUMN_INDENT,
	FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF,
	FILE_BROWSER_PARENT_DIR_COLUMN_NAME,
	FILE_BROWSER_PARENT_DIR_COLUMN_FILE,
	FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS
} FileBrowserParentDirColumn;

typedef enum  {
	FILE_BROWSER_FILE_COLUMN_PIXBUF,
	FILE_BROWSER_FILE_COLUMN_NAME,
	FILE_BROWSER_FILE_COLUMN_IS_DIR,
	FILE_BROWSER_FILE_COLUMN_N_COLUMNS
} FileBrowserFileColumn;

struct _Block11Data {
	int _ref_count_;
	FileBrowser * self;
	GtkButton* jump_button;
};

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};


static gpointer file_browser_parent_class = NULL;

GType file_browser_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
#define FILE_BROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILE_BROWSER, FileBrowserPrivate))
enum  {
	FILE_BROWSER_DUMMY_PROPERTY
};
static GType file_browser_parent_dir_column_get_type (void) G_GNUC_UNUSED;
static GType file_browser_file_column_get_type (void) G_GNUC_UNUSED;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
BuildView* main_window_get_build_view (MainWindow* self);
static void file_browser_init_toolbar (FileBrowser* self);
static void file_browser_init_combo_box (FileBrowser* self);
static void file_browser_init_list (FileBrowser* self);
static void file_browser_init_settings (FileBrowser* self);
static void file_browser_fill_stores_with_dir (FileBrowser* self, GFile* dir);
void file_browser_refresh (FileBrowser* self);
static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void file_browser_on_refresh (FileBrowser* self);
static void _file_browser_on_refresh_g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static gboolean _lambda58_ (FileBrowser* self);
static gboolean __lambda58__gsource_func (gpointer self);
static GtkButton* file_browser_get_toolbar_button (FileBrowser* self, const char* stock_id);
static void _lambda51_ (FileBrowser* self);
static void __lambda51__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda52_ (FileBrowser* self);
static void __lambda52__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda53_ (FileBrowser* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void __lambda53__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda54_ (Block11Data* _data11_);
static void __lambda54__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _file_browser_refresh_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void _lambda55_ (FileBrowser* self);
static void __lambda55__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void _lambda56_ (GtkTreePath* path, FileBrowser* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
char* utils_get_extension (const char* path);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
void app_settings_get_build_tool_view_dvi (AppSettings* self, BuildTool* result);
GtkAction* main_window_get_action_stop_exec (MainWindow* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
GType build_tool_runner_get_type (void) G_GNUC_CONST;
void app_settings_get_build_tool_view_pdf (AppSettings* self, BuildTool* result);
void app_settings_get_build_tool_view_ps (AppSettings* self, BuildTool* result);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location);
static void __lambda56__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
void file_browser_refresh_if_in_dir (FileBrowser* self, GFile* dir);
static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const char* pixbuf, const char* basename);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
static void _g_list_free_g_object_unref (GList* self);
static void file_browser_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GType file_browser_parent_dir_column_get_type (void) {
	static volatile gsize file_browser_parent_dir_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_parent_dir_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_PARENT_DIR_COLUMN_INDENT, "FILE_BROWSER_PARENT_DIR_COLUMN_INDENT", "indent"}, {FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, "FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_PARENT_DIR_COLUMN_NAME, "FILE_BROWSER_PARENT_DIR_COLUMN_NAME", "name"}, {FILE_BROWSER_PARENT_DIR_COLUMN_FILE, "FILE_BROWSER_PARENT_DIR_COLUMN_FILE", "file"}, {FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, "FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_parent_dir_column_type_id;
		file_browser_parent_dir_column_type_id = g_enum_register_static ("FileBrowserParentDirColumn", values);
		g_once_init_leave (&file_browser_parent_dir_column_type_id__volatile, file_browser_parent_dir_column_type_id);
	}
	return file_browser_parent_dir_column_type_id__volatile;
}


static GType file_browser_file_column_get_type (void) {
	static volatile gsize file_browser_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_FILE_COLUMN_PIXBUF, "FILE_BROWSER_FILE_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_FILE_COLUMN_NAME, "FILE_BROWSER_FILE_COLUMN_NAME", "name"}, {FILE_BROWSER_FILE_COLUMN_IS_DIR, "FILE_BROWSER_FILE_COLUMN_IS_DIR", "is-dir"}, {FILE_BROWSER_FILE_COLUMN_N_COLUMNS, "FILE_BROWSER_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_file_column_type_id;
		file_browser_file_column_type_id = g_enum_register_static ("FileBrowserFileColumn", values);
		g_once_init_leave (&file_browser_file_column_type_id__volatile, file_browser_file_column_type_id);
	}
	return file_browser_file_column_type_id__volatile;
}


FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window) {
	FileBrowser * self = NULL;
	BuildView* _tmp0_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (FileBrowser*) g_object_new (object_type, "spacing", 3, NULL);
	self->priv->main_window = main_window;
	self->priv->build_view = (_tmp0_ = main_window_get_build_view (main_window), _g_object_unref0 (self->priv->build_view), _tmp0_);
	file_browser_init_toolbar (self);
	file_browser_init_combo_box (self);
	file_browser_init_list (self);
	file_browser_init_settings (self);
	gtk_widget_show_all ((GtkWidget*) self);
	file_browser_fill_stores_with_dir (self, NULL);
	return self;
}


FileBrowser* file_browser_new (MainWindow* main_window) {
	return file_browser_construct (TYPE_FILE_BROWSER, main_window);
}


static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	file_browser_refresh (self);
}


static void _file_browser_on_refresh_g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	file_browser_on_refresh (self);
}


static void file_browser_init_settings (FileBrowser* self) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->settings = (_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.file-browser"), _g_object_unref0 (self->priv->settings), _tmp0_);
	g_signal_connect_object (self->priv->settings, "changed::show-all-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->settings, "changed::show-all-files-except", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->settings, "changed::show-hidden-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->settings, "changed::file-extensions", (GCallback) _file_browser_on_refresh_g_settings_changed, self, 0);
	self->priv->latex_settings = (_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.latex"), _g_object_unref0 (self->priv->latex_settings), _tmp1_);
	g_signal_connect_object (self->priv->latex_settings, "changed::clean-extensions", (GCallback) _file_browser_on_refresh_g_settings_changed, self, 0);
}


static gboolean _lambda58_ (FileBrowser* self) {
	gboolean result = FALSE;
	self->priv->timeout_id = (guint) 0;
	file_browser_refresh (self);
	result = FALSE;
	return result;
}


static gboolean __lambda58__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda58_ (self);
	return result;
}


static void file_browser_on_refresh (FileBrowser* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != 0) {
		g_source_remove (self->priv->timeout_id);
	}
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, __lambda58__gsource_func, g_object_ref (self), g_object_unref);
}


static void _lambda51_ (FileBrowser* self) {
	GFile* home_dir;
	home_dir = g_file_new_for_path (g_get_home_dir ());
	file_browser_fill_stores_with_dir (self, home_dir);
	_g_object_unref0 (home_dir);
}


static void __lambda51__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda51_ (self);
}


static void _lambda52_ (FileBrowser* self) {
	GFile* parent;
	parent = g_file_get_parent (self->priv->current_directory);
	g_return_if_fail (parent != NULL);
	file_browser_fill_stores_with_dir (self, parent);
	_g_object_unref0 (parent);
}


static void __lambda52__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda52_ (self);
}


static void _lambda53_ (FileBrowser* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	if (main_window_get_active_tab (self->priv->main_window) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = document_get_location (main_window_get_active_document (self->priv->main_window)) == NULL;
	}
	if (_tmp0_) {
		return;
	}
	file_browser_fill_stores_with_dir (self, _tmp1_ = g_file_get_parent (document_get_location (main_window_get_active_document (self->priv->main_window))));
	_g_object_unref0 (_tmp1_);
}


static void __lambda53__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda53_ (self);
}


static void _lambda54_ (Block11Data* _data11_) {
	FileBrowser * self;
	gboolean _tmp0_ = FALSE;
	self = _data11_->self;
	if (main_window_get_active_tab (self->priv->main_window) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = document_get_location (main_window_get_active_document (self->priv->main_window)) == NULL;
	}
	if (_tmp0_) {
		gtk_widget_set_sensitive ((GtkWidget*) _data11_->jump_button, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) _data11_->jump_button, TRUE);
	}
}


static void __lambda54__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda54_ (self);
}


static void _file_browser_refresh_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	file_browser_refresh (self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->jump_button);
		g_slice_free (Block11Data, _data11_);
	}
}


static void file_browser_init_toolbar (FileBrowser* self) {
	Block11Data* _data11_;
	GtkHBox* hbox;
	GtkButton* home_button;
	GtkButton* _tmp0_;
	GtkButton* refresh_button;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (TRUE, 0));
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, 0);
	home_button = file_browser_get_toolbar_button (self, GTK_STOCK_HOME);
	self->priv->parent_button = (_tmp0_ = file_browser_get_toolbar_button (self, GTK_STOCK_GO_UP), _g_object_unref0 (self->priv->parent_button), _tmp0_);
	_data11_->jump_button = file_browser_get_toolbar_button (self, GTK_STOCK_JUMP_TO);
	refresh_button = file_browser_get_toolbar_button (self, GTK_STOCK_REFRESH);
	gtk_widget_set_tooltip_text ((GtkWidget*) home_button, _ ("Go to the home directory"));
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->parent_button, _ ("Go to the parent directory"));
	gtk_widget_set_tooltip_text ((GtkWidget*) _data11_->jump_button, _ ("Go to the active document directory"));
	gtk_widget_set_tooltip_text ((GtkWidget*) refresh_button, _ ("Refresh"));
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) home_button, TRUE, TRUE, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->parent_button, TRUE, TRUE, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) _data11_->jump_button, TRUE, TRUE, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) refresh_button, TRUE, TRUE, 0);
	g_signal_connect_object (home_button, "clicked", (GCallback) __lambda51__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->parent_button, "clicked", (GCallback) __lambda52__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data11_->jump_button, "clicked", (GCallback) __lambda53__gtk_button_clicked, self, 0);
	g_signal_connect_data ((GObject*) self->priv->main_window, "notify::active-document", (GCallback) __lambda54__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	g_signal_connect_object (refresh_button, "clicked", (GCallback) _file_browser_refresh_gtk_button_clicked, self, 0);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (home_button);
	_g_object_unref0 (hbox);
	block11_data_unref (_data11_);
}


static GtkButton* file_browser_get_toolbar_button (FileBrowser* self, const char* stock_id) {
	GtkButton* result = NULL;
	GtkButton* button;
	GtkImage* image;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stock_id != NULL, NULL);
	button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (stock_id, GTK_ICON_SIZE_MENU));
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	result = button;
	_g_object_unref0 (image);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda55_ (FileBrowser* self) {
	GtkTreeIter iter = {0};
	if (gtk_combo_box_get_active_iter (self->priv->combo_box, &iter)) {
		GtkTreeModel* model;
		GFile* file;
		model = _g_object_ref0 (gtk_combo_box_get_model (self->priv->combo_box));
		file = NULL;
		gtk_tree_model_get (model, &iter, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, &file, -1, -1);
		if (!g_file_equal (file, self->priv->current_directory)) {
			file_browser_fill_stores_with_dir (self, file);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (model);
	}
}


static void __lambda55__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda55_ (self);
}


static void file_browser_init_combo_box (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkCellRendererText* text_renderer;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->parent_dir_store = (_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE), _g_object_unref0 (self->priv->parent_dir_store), _tmp0_);
	self->priv->combo_box = (_tmp1_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->parent_dir_store)), _g_object_unref0 (self->priv->combo_box), _tmp1_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->combo_box, FALSE, FALSE, 0);
	text_renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_INDENT, NULL, NULL);
	pixbuf_renderer = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, NULL, NULL);
	text_renderer = (_tmp2_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (text_renderer), _tmp2_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_NAME, NULL, NULL);
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	g_signal_connect_object (self->priv->combo_box, "changed", (GCallback) __lambda55__gtk_combo_box_changed, self, 0);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (text_renderer);
}


static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = file_browser_on_sort (self, model, a, b);
	return result;
}


static void _lambda56_ (GtkTreePath* path, FileBrowser* self) {
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	char* basename;
	gboolean is_dir = FALSE;
	GFile* file;
	AppSettings* app_settings;
	char* extension;
	const char* _tmp13_;
	GQuark _tmp14_;
	static GQuark _tmp14__label0 = 0;
	static GQuark _tmp14__label1 = 0;
	static GQuark _tmp14__label2 = 0;
	g_return_if_fail (path != NULL);
	model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->list_store));
	if (!gtk_tree_model_get_iter (model, &iter, path)) {
		_g_object_unref0 (model);
		return;
	}
	basename = NULL;
	gtk_tree_model_get (model, &iter, FILE_BROWSER_FILE_COLUMN_NAME, &basename, FILE_BROWSER_FILE_COLUMN_IS_DIR, &is_dir, -1, -1);
	file = g_file_get_child (self->priv->current_directory, basename);
	if (is_dir) {
		file_browser_fill_stores_with_dir (self, file);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	app_settings = app_settings_get_default ();
	extension = utils_get_extension (basename);
	_tmp13_ = extension;
	_tmp14_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
	if (_tmp14_ == ((0 != _tmp14__label0) ? _tmp14__label0 : (_tmp14__label0 = g_quark_from_static_string (".dvi"))))
	switch (0) {
		default:
		{
			BuildTool _tmp0_ = {0};
			GtkAction* _tmp1_;
			BuildTool _tmp2_;
			BuildToolRunner* _tmp3_;
			_tmp3_ = build_tool_runner_new (file, (_tmp2_ = (app_settings_get_build_tool_view_dvi (app_settings, &_tmp0_), _tmp0_), &_tmp2_), self->priv->build_view, _tmp1_ = main_window_get_action_stop_exec (self->priv->main_window));
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (_tmp1_);
			break;
		}
	} else if (_tmp14_ == ((0 != _tmp14__label1) ? _tmp14__label1 : (_tmp14__label1 = g_quark_from_static_string (".pdf"))))
	switch (0) {
		default:
		{
			BuildTool _tmp4_ = {0};
			GtkAction* _tmp5_;
			BuildTool _tmp6_;
			BuildToolRunner* _tmp7_;
			_tmp7_ = build_tool_runner_new (file, (_tmp6_ = (app_settings_get_build_tool_view_pdf (app_settings, &_tmp4_), _tmp4_), &_tmp6_), self->priv->build_view, _tmp5_ = main_window_get_action_stop_exec (self->priv->main_window));
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp5_);
			break;
		}
	} else if (_tmp14_ == ((0 != _tmp14__label2) ? _tmp14__label2 : (_tmp14__label2 = g_quark_from_static_string (".ps"))))
	switch (0) {
		default:
		{
			BuildTool _tmp8_ = {0};
			GtkAction* _tmp9_;
			BuildTool _tmp10_;
			BuildToolRunner* _tmp11_;
			_tmp11_ = build_tool_runner_new (file, (_tmp10_ = (app_settings_get_build_tool_view_ps (app_settings, &_tmp8_), _tmp8_), &_tmp10_), self->priv->build_view, _tmp9_ = main_window_get_action_stop_exec (self->priv->main_window));
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
			break;
		}
	} else
	switch (0) {
		default:
		{
			DocumentTab* _tmp12_;
			_tmp12_ = main_window_open_document (self->priv->main_window, file);
			_g_object_unref0 (_tmp12_);
			break;
		}
	}
	_g_free0 (extension);
	_g_object_unref0 (app_settings);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (model);
}


static void __lambda56__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	_lambda56_ (path, self);
}


static void file_browser_init_list (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkTreeView* tree_view;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* text_renderer;
	GtkWidget* sw;
	g_return_if_fail (self != NULL);
	self->priv->list_store = (_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_FILE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN), _g_object_unref0 (self->priv->list_store), _tmp0_);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->list_store, 0, _file_browser_on_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->list_store, 0, GTK_SORT_ASCENDING);
	tree_view = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->list_store));
	gtk_tree_view_set_headers_visible (tree_view, FALSE);
	column = g_object_ref_sink (gtk_tree_view_column_new ());
	gtk_tree_view_append_column (tree_view, column);
	pixbuf_renderer = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_FILE_COLUMN_PIXBUF, NULL, NULL);
	text_renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_FILE_COLUMN_NAME, NULL, NULL);
	sw = utils_add_scrollbar ((GtkWidget*) tree_view);
	gtk_box_pack_start ((GtkBox*) self, sw, TRUE, TRUE, 0);
	g_signal_connect_object (tree_view, "row-activated", (GCallback) __lambda56__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (sw);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (tree_view);
}


void file_browser_refresh (FileBrowser* self) {
	g_return_if_fail (self != NULL);
	file_browser_fill_stores_with_dir (self, self->priv->current_directory);
}


void file_browser_refresh_if_in_dir (FileBrowser* self, GFile* dir) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	if (g_file_equal (dir, self->priv->current_directory)) {
		file_browser_refresh (self);
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void file_browser_fill_stores_with_dir (FileBrowser* self, GFile* dir) {
	GFile* directory;
	GList* parent_dirs;
	GFile* current_dir;
	GtkTreeIter _tmp27_ = {0};
	GtkTreeIter iter;
	gint i;
	GFile* _tmp35_;
	char* _tmp36_;
	GFile* _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->list_store);
	gtk_list_store_clear (self->priv->parent_dir_store);
	directory = _g_object_ref0 (dir);
	if (directory == NULL) {
		char* uri;
		gboolean _tmp0_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		uri = g_settings_get_string (self->priv->settings, "current-directory");
		if (uri != NULL) {
			_tmp0_ = string_get_length (uri) > 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GFile* _tmp1_;
			directory = (_tmp1_ = g_file_new_for_uri (uri), _g_object_unref0 (directory), _tmp1_);
		}
		if (uri == NULL) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = string_get_length (uri) == 0;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = !g_file_query_exists (directory, NULL);
		}
		if (_tmp2_) {
			GFile* _tmp4_;
			directory = (_tmp4_ = g_file_new_for_path (g_get_home_dir ()), _g_object_unref0 (directory), _tmp4_);
		}
		_g_free0 (uri);
	}
	{
		GFileEnumerator* enumerator;
		gboolean show_all;
		gboolean show_all_except;
		gboolean _tmp5_ = FALSE;
		gboolean show_hidden;
		char* exts;
		gint extensions_length1;
		gint _extensions_size_;
		char** _tmp7_;
		char** _tmp6_;
		char** extensions;
		char* _tmp8_;
		gint clean_extensions_length1;
		gint _clean_extensions_size_;
		char** _tmp10_;
		char** _tmp9_;
		char** clean_extensions;
		enumerator = g_file_enumerate_children (directory, "standard::type,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		show_all = g_settings_get_boolean (self->priv->settings, "show-all-files");
		show_all_except = g_settings_get_boolean (self->priv->settings, "show-all-files-except");
		if (show_all) {
			_tmp5_ = g_settings_get_boolean (self->priv->settings, "show-hidden-files");
		} else {
			_tmp5_ = FALSE;
		}
		show_hidden = _tmp5_;
		exts = g_settings_get_string (self->priv->settings, "file-extensions");
		extensions = (_tmp7_ = _tmp6_ = g_strsplit (exts, " ", 0), extensions_length1 = _vala_array_length (_tmp6_), _extensions_size_ = extensions_length1, _tmp7_);
		exts = (_tmp8_ = g_settings_get_string (self->priv->latex_settings, "clean-extensions"), _g_free0 (exts), _tmp8_);
		clean_extensions = (_tmp10_ = _tmp9_ = g_strsplit (exts, " ", 0), clean_extensions_length1 = _vala_array_length (_tmp9_), _clean_extensions_size_ = clean_extensions_length1, _tmp10_);
		{
			GFileInfo* info;
			info = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
				extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (exts);
				_g_object_unref0 (enumerator);
				goto __catch28_g_error;
			}
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					char* basename;
					gboolean _tmp14_ = FALSE;
					GFileType type;
					char* extension;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					if (!_tmp11_) {
						GFileInfo* _tmp12_;
						GFileInfo* _tmp13_;
						_tmp12_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (info);
							clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
							extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (exts);
							_g_object_unref0 (enumerator);
							goto __catch28_g_error;
						}
						info = (_tmp13_ = _tmp12_, _g_object_unref0 (info), _tmp13_);
					}
					_tmp11_ = FALSE;
					if (!(info != NULL)) {
						break;
					}
					basename = g_strdup (g_file_info_get_display_name (info));
					if (g_utf8_get_char (g_utf8_offset_to_pointer (basename, 0)) == '.') {
						_tmp14_ = !show_hidden;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						_g_free0 (basename);
						continue;
					}
					type = g_file_info_get_file_type (info);
					if (type == G_FILE_TYPE_DIRECTORY) {
						file_browser_insert_file (self, TRUE, GTK_STOCK_DIRECTORY, basename);
						_g_free0 (basename);
						continue;
					}
					extension = utils_get_extension (basename);
					if (show_all) {
						_tmp17_ = !show_all_except;
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						_tmp16_ = TRUE;
					} else {
						gboolean _tmp18_ = FALSE;
						if (show_all) {
							_tmp18_ = !_vala_string_array_contains (clean_extensions, clean_extensions_length1, extension);
						} else {
							_tmp18_ = FALSE;
						}
						_tmp16_ = _tmp18_;
					}
					if (_tmp16_) {
						_tmp15_ = TRUE;
					} else {
						_tmp15_ = _vala_string_array_contains (extensions, extensions_length1, extension);
					}
					if (_tmp15_) {
						char* pixbuf;
						const char* _tmp24_;
						GQuark _tmp25_;
						static GQuark _tmp25__label0 = 0;
						static GQuark _tmp25__label1 = 0;
						static GQuark _tmp25__label2 = 0;
						static GQuark _tmp25__label3 = 0;
						pixbuf = NULL;
						_tmp24_ = extension;
						_tmp25_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
						if (_tmp25_ == ((0 != _tmp25__label0) ? _tmp25__label0 : (_tmp25__label0 = g_quark_from_static_string (".tex"))))
						switch (0) {
							default:
							{
								char* _tmp19_;
								pixbuf = (_tmp19_ = g_strdup (GTK_STOCK_EDIT), _g_free0 (pixbuf), _tmp19_);
								break;
							}
						} else if (_tmp25_ == ((0 != _tmp25__label1) ? _tmp25__label1 : (_tmp25__label1 = g_quark_from_static_string (".pdf"))))
						switch (0) {
							default:
							{
								char* _tmp20_;
								pixbuf = (_tmp20_ = g_strdup ("view_pdf"), _g_free0 (pixbuf), _tmp20_);
								break;
							}
						} else if (_tmp25_ == ((0 != _tmp25__label2) ? _tmp25__label2 : (_tmp25__label2 = g_quark_from_static_string (".dvi"))))
						switch (0) {
							default:
							{
								char* _tmp21_;
								pixbuf = (_tmp21_ = g_strdup ("view_dvi"), _g_free0 (pixbuf), _tmp21_);
								break;
							}
						} else if (_tmp25_ == ((0 != _tmp25__label3) ? _tmp25__label3 : (_tmp25__label3 = g_quark_from_static_string (".ps"))))
						switch (0) {
							default:
							{
								char* _tmp22_;
								pixbuf = (_tmp22_ = g_strdup ("view_ps"), _g_free0 (pixbuf), _tmp22_);
								break;
							}
						} else
						switch (0) {
							default:
							{
								char* _tmp23_;
								pixbuf = (_tmp23_ = g_strdup (GTK_STOCK_FILE), _g_free0 (pixbuf), _tmp23_);
								break;
							}
						}
						file_browser_insert_file (self, FALSE, pixbuf, basename);
						_g_free0 (pixbuf);
					}
					_g_free0 (extension);
					_g_free0 (basename);
				}
			}
			_g_object_unref0 (info);
		}
		gtk_tree_sortable_sort_column_changed ((GtkTreeSortable*) self->priv->list_store);
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		_g_object_unref0 (enumerator);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* dialog;
			fprintf (stderr, "Error: %s\n", e->message);
			dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self->priv->main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, _ ("File Browser")));
			gtk_message_dialog_format_secondary_text (dialog, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dialog);
			gtk_object_destroy ((GtkObject*) dialog);
			_g_object_unref0 (dialog);
			_g_error_free0 (e);
			_g_object_unref0 (directory);
			return;
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	parent_dirs = NULL;
	parent_dirs = g_list_prepend (parent_dirs, _g_object_ref0 (directory));
	current_dir = _g_object_ref0 (directory);
	while (TRUE) {
		GFile* parent;
		GFile* _tmp26_;
		parent = g_file_get_parent (current_dir);
		if (parent == NULL) {
			_g_object_unref0 (parent);
			break;
		}
		parent_dirs = g_list_prepend (parent_dirs, _g_object_ref0 (parent));
		current_dir = (_tmp26_ = _g_object_ref0 (parent), _g_object_unref0 (current_dir), _tmp26_);
		_g_object_unref0 (parent);
	}
	iter = (_tmp27_);
	i = 0;
	{
		GList* current_collection;
		GList* current_it;
		current_collection = parent_dirs;
		for (current_it = current_collection; current_it != NULL; current_it = current_it->next) {
			GFile* current;
			current = _g_object_ref0 ((GFile*) current_it->data);
			{
				char* basename;
				char* indent;
				char* pixbuf;
				basename = NULL;
				if (i == 0) {
					char* _tmp28_;
					basename = (_tmp28_ = g_strdup (_ ("File System")), _g_free0 (basename), _tmp28_);
				} else {
					char* _tmp29_;
					basename = (_tmp29_ = g_file_get_basename (current), _g_free0 (basename), _tmp29_);
				}
				indent = g_strnfill ((gsize) (i * 2), ' ');
				pixbuf = NULL;
				if (i == 0) {
					char* _tmp30_;
					pixbuf = (_tmp30_ = g_strdup (GTK_STOCK_HARDDISK), _g_free0 (pixbuf), _tmp30_);
				} else {
					char* _tmp31_;
					gboolean _tmp32_;
					if ((_tmp32_ = _vala_strcmp0 (g_get_home_dir (), _tmp31_ = g_file_get_path (current)) == 0, _g_free0 (_tmp31_), _tmp32_)) {
						char* _tmp33_;
						pixbuf = (_tmp33_ = g_strdup (GTK_STOCK_HOME), _g_free0 (pixbuf), _tmp33_);
					} else {
						char* _tmp34_;
						pixbuf = (_tmp34_ = g_strdup (GTK_STOCK_DIRECTORY), _g_free0 (pixbuf), _tmp34_);
					}
				}
				gtk_list_store_append (self->priv->parent_dir_store, &iter);
				gtk_list_store_set (self->priv->parent_dir_store, &iter, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, current, FILE_BROWSER_PARENT_DIR_COLUMN_INDENT, indent, FILE_BROWSER_PARENT_DIR_COLUMN_NAME, basename, FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, pixbuf, -1, -1);
				i++;
				_g_free0 (pixbuf);
				_g_free0 (indent);
				_g_free0 (basename);
				_g_object_unref0 (current);
			}
		}
	}
	self->priv->current_directory = (_tmp35_ = _g_object_ref0 (directory), _g_object_unref0 (self->priv->current_directory), _tmp35_);
	g_settings_set_string (self->priv->settings, "current-directory", _tmp36_ = g_file_get_uri (directory));
	_g_free0 (_tmp36_);
	gtk_combo_box_set_active_iter (self->priv->combo_box, &iter);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->parent_button, (_tmp37_ = g_file_get_parent (directory)) != NULL);
	_g_object_unref0 (_tmp37_);
	_g_object_unref0 (current_dir);
	__g_list_free_g_object_unref0 (parent_dirs);
	_g_object_unref0 (directory);
}


static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const char* pixbuf, const char* basename) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (basename != NULL);
	gtk_list_store_append (self->priv->list_store, &iter);
	gtk_list_store_set (self->priv->list_store, &iter, FILE_BROWSER_FILE_COLUMN_IS_DIR, is_dir, FILE_BROWSER_FILE_COLUMN_PIXBUF, pixbuf, FILE_BROWSER_FILE_COLUMN_NAME, basename, -1, -1);
}


static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gboolean a_is_dir = FALSE;
	gboolean b_is_dir = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	gtk_tree_model_get (model, a, FILE_BROWSER_FILE_COLUMN_IS_DIR, &a_is_dir, -1, -1);
	gtk_tree_model_get (model, b, FILE_BROWSER_FILE_COLUMN_IS_DIR, &b_is_dir, -1, -1);
	if (a_is_dir == b_is_dir) {
		char* a_name;
		char* b_name;
		a_name = NULL;
		b_name = NULL;
		gtk_tree_model_get (model, a, FILE_BROWSER_FILE_COLUMN_NAME, &a_name, -1, -1);
		gtk_tree_model_get (model, b, FILE_BROWSER_FILE_COLUMN_NAME, &b_name, -1, -1);
		result = g_utf8_collate (a_name, b_name);
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	if (a_is_dir) {
		_tmp0_ = -1;
	} else {
		_tmp0_ = +1;
	}
	result = _tmp0_;
	return result;
}


static void file_browser_class_init (FileBrowserClass * klass) {
	file_browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FileBrowserPrivate));
	G_OBJECT_CLASS (klass)->finalize = file_browser_finalize;
}


static void file_browser_instance_init (FileBrowser * self) {
	self->priv = FILE_BROWSER_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
}


static void file_browser_finalize (GObject* obj) {
	FileBrowser * self;
	self = FILE_BROWSER (obj);
	_g_object_unref0 (self->priv->build_view);
	_g_object_unref0 (self->priv->parent_dir_store);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->combo_box);
	_g_object_unref0 (self->priv->current_directory);
	_g_object_unref0 (self->priv->parent_button);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->latex_settings);
	G_OBJECT_CLASS (file_browser_parent_class)->finalize (obj);
}


GType file_browser_get_type (void) {
	static volatile gsize file_browser_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FileBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileBrowser), 0, (GInstanceInitFunc) file_browser_instance_init, NULL };
		GType file_browser_type_id;
		file_browser_type_id = g_type_register_static (GTK_TYPE_VBOX, "FileBrowser", &g_define_type_info, 0);
		g_once_init_leave (&file_browser_type_id__volatile, file_browser_type_id);
	}
	return file_browser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




