/* app_settings.c generated by valac 0.10.3, the Vala compiler
 * generated from app_settings.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <config.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_MOST_USED_SYMBOL (most_used_symbol_get_type ())
typedef struct _MostUsedSymbol MostUsedSymbol;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _AppSettingsPrivate AppSettingsPrivate;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _most_used_symbol_free0(var) ((var == NULL) ? NULL : (var = (most_used_symbol_free (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
	char** command_args;
	gint command_args_length1;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};

struct _MostUsedSymbol {
	char* id;
	char* latex_command;
	char* package_required;
	guint num;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _AppSettings {
	GSettings parent_instance;
	AppSettingsPrivate * priv;
};

struct _AppSettingsClass {
	GSettingsClass parent_class;
};

struct _AppSettingsPrivate {
	GSettings* editor;
	GSettings* desktop_interface;
	guint timeout_id;
	char* _system_font;
	GeeLinkedList* most_used_symbols;
	gboolean mus_modified;
	GeeLinkedList* build_tools;
	BuildTool current_build_tool;
	BuildJob current_build_job;
	BuildTool _build_tool_view_dvi;
	BuildTool _build_tool_view_pdf;
	BuildTool _build_tool_view_ps;
	gboolean current_tool_is_view_dvi;
	gboolean current_tool_is_view_pdf;
	gboolean current_tool_is_view_ps;
	gboolean build_tools_modified;
	GeeLinkedList* projects;
	gboolean projects_modified;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};


static AppSettings* app_settings_instance;
static AppSettings* app_settings_instance = NULL;
static gpointer app_settings_parent_class = NULL;

GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
static char** _vala_array_dup3 (char** self, int length);
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GType most_used_symbol_get_type (void) G_GNUC_CONST;
MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self);
void most_used_symbol_free (MostUsedSymbol* self);
void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest);
void most_used_symbol_destroy (MostUsedSymbol* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
GType app_settings_get_type (void) G_GNUC_CONST;
#define APP_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APP_SETTINGS, AppSettingsPrivate))
enum  {
	APP_SETTINGS_DUMMY_PROPERTY,
	APP_SETTINGS_SYSTEM_FONT,
	APP_SETTINGS_BUILD_TOOL_VIEW_DVI,
	APP_SETTINGS_BUILD_TOOL_VIEW_PDF,
	APP_SETTINGS_BUILD_TOOL_VIEW_PS
};
static AppSettings* app_settings_new (void);
static AppSettings* app_settings_construct (GType object_type);
static void app_settings_initialize (AppSettings* self);
static void app_settings_load_build_tools (AppSettings* self);
static void app_settings_load_most_used_symbols (AppSettings* self);
static void app_settings_load_projects (AppSettings* self);
AppSettings* app_settings_get_default (void);
static void app_settings_set_system_font (AppSettings* self, const char* value);
static void _lambda6_ (GSettings* setting, const char* key, AppSettings* self);
static void app_settings_set_font (AppSettings* self, const char* font);
const char* app_settings_get_system_font (AppSettings* self);
static void __lambda6__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda81_ (GSettings* setting, const char* key, AppSettings* self);
static void __lambda81__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda82_ (GSettings* setting, const char* key, AppSettings* self);
static void __lambda82__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda83_ (GSettings* setting, const char* key, AppSettings* self);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GType document_get_type (void) G_GNUC_CONST;
GList* application_get_documents (Application* self);
static void _g_list_free_g_object_unref (GList* self);
static void __lambda83__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda84_ (GSettings* setting, const char* key, AppSettings* self);
GType document_view_get_type (void) G_GNUC_CONST;
GList* application_get_views (Application* self);
static void __lambda84__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda85_ (GSettings* setting, const char* key, AppSettings* self);
static void __lambda85__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda86_ (GSettings* setting, const char* key, AppSettings* self);
static void __lambda86__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda87_ (GSettings* setting, const char* key, AppSettings* self);
static void __lambda87__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda88_ (GSettings* setting, const char* key, AppSettings* self);
static void __lambda88__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda89_ (GSettings* setting, const char* key, AppSettings* self);
GType document_tab_get_type (void) G_GNUC_CONST;
void document_tab_set_auto_save (DocumentTab* self, gboolean value);
static void __lambda89__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda90_ (GSettings* setting, const char* key, AppSettings* self);
void document_tab_set_auto_save_interval (DocumentTab* self, guint value);
static void __lambda90__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda91_ (GSettings* setting, const char* key, AppSettings* self);
static gboolean _lambda92_ (AppSettings* self);
void symbols_reload_most_used_symbols (void);
static gboolean __lambda92__gsource_func (gpointer self);
static void __lambda91__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
void document_view_set_font_from_string (DocumentView* self, const char* font);
GeeList* app_settings_get_most_used_symbols (AppSettings* self);
void app_settings_clear_most_used_symbols (AppSettings* self);
void app_settings_add_symbol (AppSettings* self, const char* id, const char* command, const char* package);
static gint app_settings_sort_most_used_symbol (AppSettings* self, gint index, MostUsedSymbol* mus);
void symbols_remove_most_used_symbol (gint index);
void symbols_insert_most_used_symbol (gint index, MostUsedSymbol* symbol);
void symbols_swap_most_used_symbol (gint current_index, gint new_index);
static GFile* app_settings_get_file_most_used_symbols (AppSettings* self);
static void app_settings_mus_parser_start (AppSettings* self, GMarkupParseContext* context, const char* name, char** attr_names, int attr_names_length1, char** attr_values, int attr_values_length1, GError** error);
static void _app_settings_mus_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error);
void app_settings_save_most_used_symbols (AppSettings* self);
void utils_delete_file (GFile* file);
GeeLinkedList* app_settings_get_build_tools (AppSettings* self);
void app_settings_move_build_tool_up (AppSettings* self, gint num);
static void app_settings_swap_build_tools (AppSettings* self, gint num1, gint num2);
void app_settings_move_build_tool_down (AppSettings* self, gint num);
static void app_settings_update_all_build_tools_menu (AppSettings* self);
void app_settings_delete_build_tool (AppSettings* self, gint num);
void app_settings_append_build_tool (AppSettings* self, BuildTool* tool);
static gboolean app_settings_is_compilation (AppSettings* self, const char* icon);
void app_settings_update_build_tool (AppSettings* self, gint num, BuildTool* tool);
static gboolean app_settings_is_build_tools_equal (AppSettings* self, BuildTool* tool1, BuildTool* tool2);
void app_settings_reset_all_build_tools (AppSettings* self);
static GFile* app_settings_get_user_config_build_tools_file (AppSettings* self);
GType main_window_get_type (void) G_GNUC_CONST;
GList* application_get_windows (Application* self);
void main_window_update_build_tools_menu (MainWindow* self);
static void _vala_array_add9 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_add10 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_add11 (GFile*** array, int* length, int* size, GFile* value);
static void app_settings_parser_start (AppSettings* self, GMarkupParseContext* context, const char* name, char** attr_names, int attr_names_length1, char** attr_values, int attr_values_length1, GError** error);
static void _app_settings_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error);
static void app_settings_parser_end (AppSettings* self, GMarkupParseContext* context, const char* name, GError** error);
static void _app_settings_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const char* element_name, gpointer self, GError** error);
static void app_settings_parser_text (AppSettings* self, GMarkupParseContext* context, const char* text, gsize text_len, GError** error);
static void _app_settings_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const char* text, gsize text_len, gpointer self, GError** error);
static void app_settings_set_build_tool_view_dvi (AppSettings* self, BuildTool* value);
static void app_settings_set_build_tool_view_pdf (AppSettings* self, BuildTool* value);
static void app_settings_set_build_tool_view_ps (AppSettings* self, BuildTool* value);
void app_settings_save_build_tools (AppSettings* self);
Project* app_settings_get_project (AppSettings* self, gint id);
GeeLinkedList* app_settings_get_projects (AppSettings* self);
static void app_settings_update_projects_menus (AppSettings* self);
void main_window_update_config_project_sensitivity (MainWindow* self);
gboolean app_settings_add_project (AppSettings* self, Project* new_project, GFile** conflict);
static gboolean app_settings_projects_conflict (AppSettings* self, GFile* dir1, GFile* dir2);
gint document_get_project_id (Document* self);
GFile* document_get_location (Document* self);
void document_set_project_id (Document* self, gint value);
gboolean app_settings_project_change_main_file (AppSettings* self, gint num, GFile* new_main_file);
void app_settings_delete_project (AppSettings* self, gint num);
void app_settings_clear_all_projects (AppSettings* self);
static void app_settings_update_all_documents (AppSettings* self);
static GFile* app_settings_get_file_projects (AppSettings* self);
static void app_settings_projects_parser_start (AppSettings* self, GMarkupParseContext* context, const char* name, char** attr_names, int attr_names_length1, char** attr_values, int attr_values_length1, GError** error);
static void _app_settings_projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error);
void app_settings_save_projects (AppSettings* self);
void app_settings_get_build_tool_view_dvi (AppSettings* self, BuildTool* result);
void app_settings_get_build_tool_view_pdf (AppSettings* self, BuildTool* result);
void app_settings_get_build_tool_view_ps (AppSettings* self, BuildTool* result);
static void app_settings_finalize (GObject* obj);
static void app_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void app_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static char** _vala_array_dup3 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void build_job_copy (const BuildJob* self, BuildJob* dest) {
	char** _tmp0_;
	dest->must_succeed = self->must_succeed;
	dest->post_processor = g_strdup (self->post_processor);
	dest->command = g_strdup (self->command);
	dest->command_args = (_tmp0_ = self->command_args, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup3 (_tmp0_, (*self).command_args_length1));
	dest->command_args_length1 = self->command_args_length1;
}


void build_job_destroy (BuildJob* self) {
	_g_free0 (self->post_processor);
	_g_free0 (self->command);
	self->command_args = (_vala_array_free (self->command_args, (*self).command_args_length1, (GDestroyNotify) g_free), NULL);
}


BuildJob* build_job_dup (const BuildJob* self) {
	BuildJob* dup;
	dup = g_new0 (BuildJob, 1);
	build_job_copy (self, dup);
	return dup;
}


void build_job_free (BuildJob* self) {
	build_job_destroy (self);
	g_free (self);
}


GType build_job_get_type (void) {
	static volatile gsize build_job_type_id__volatile = 0;
	if (g_once_init_enter (&build_job_type_id__volatile)) {
		GType build_job_type_id;
		build_job_type_id = g_boxed_type_register_static ("BuildJob", (GBoxedCopyFunc) build_job_dup, (GBoxedFreeFunc) build_job_free);
		g_once_init_leave (&build_job_type_id__volatile, build_job_type_id);
	}
	return build_job_type_id__volatile;
}


void build_tool_copy (const BuildTool* self, BuildTool* dest) {
	dest->description = g_strdup (self->description);
	dest->extensions = g_strdup (self->extensions);
	dest->label = g_strdup (self->label);
	dest->icon = g_strdup (self->icon);
	dest->compilation = self->compilation;
	dest->jobs = self->jobs;
}


void build_tool_destroy (BuildTool* self) {
	_g_free0 (self->description);
	_g_free0 (self->extensions);
	_g_free0 (self->label);
	_g_free0 (self->icon);
}


BuildTool* build_tool_dup (const BuildTool* self) {
	BuildTool* dup;
	dup = g_new0 (BuildTool, 1);
	build_tool_copy (self, dup);
	return dup;
}


void build_tool_free (BuildTool* self) {
	build_tool_destroy (self);
	g_free (self);
}


GType build_tool_get_type (void) {
	static volatile gsize build_tool_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_type_id__volatile)) {
		GType build_tool_type_id;
		build_tool_type_id = g_boxed_type_register_static ("BuildTool", (GBoxedCopyFunc) build_tool_dup, (GBoxedFreeFunc) build_tool_free);
		g_once_init_leave (&build_tool_type_id__volatile, build_tool_type_id);
	}
	return build_tool_type_id__volatile;
}


void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest) {
	dest->id = g_strdup (self->id);
	dest->latex_command = g_strdup (self->latex_command);
	dest->package_required = g_strdup (self->package_required);
	dest->num = self->num;
}


void most_used_symbol_destroy (MostUsedSymbol* self) {
	_g_free0 (self->id);
	_g_free0 (self->latex_command);
	_g_free0 (self->package_required);
}


MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self) {
	MostUsedSymbol* dup;
	dup = g_new0 (MostUsedSymbol, 1);
	most_used_symbol_copy (self, dup);
	return dup;
}


void most_used_symbol_free (MostUsedSymbol* self) {
	most_used_symbol_destroy (self);
	g_free (self);
}


GType most_used_symbol_get_type (void) {
	static volatile gsize most_used_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbol_type_id__volatile)) {
		GType most_used_symbol_type_id;
		most_used_symbol_type_id = g_boxed_type_register_static ("MostUsedSymbol", (GBoxedCopyFunc) most_used_symbol_dup, (GBoxedFreeFunc) most_used_symbol_free);
		g_once_init_leave (&most_used_symbol_type_id__volatile, most_used_symbol_type_id);
	}
	return most_used_symbol_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void project_copy (const Project* self, Project* dest) {
	dest->directory = _g_object_ref0 (self->directory);
	dest->main_file = _g_object_ref0 (self->main_file);
}


void project_destroy (Project* self) {
	_g_object_unref0 (self->directory);
	_g_object_unref0 (self->main_file);
}


Project* project_dup (const Project* self) {
	Project* dup;
	dup = g_new0 (Project, 1);
	project_copy (self, dup);
	return dup;
}


void project_free (Project* self) {
	project_destroy (self);
	g_free (self);
}


GType project_get_type (void) {
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		GType project_type_id;
		project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}


static AppSettings* app_settings_construct (GType object_type) {
	AppSettings * self = NULL;
	self = (AppSettings*) g_object_new (object_type, "schema", "org.gnome.latexila", NULL);
	app_settings_initialize (self);
	app_settings_load_build_tools (self);
	app_settings_load_most_used_symbols (self);
	app_settings_load_projects (self);
	return self;
}


static AppSettings* app_settings_new (void) {
	return app_settings_construct (TYPE_APP_SETTINGS);
}


AppSettings* app_settings_get_default (void) {
	AppSettings* result = NULL;
	if (app_settings_instance == NULL) {
		AppSettings* _tmp0_;
		app_settings_instance = (_tmp0_ = app_settings_new (), _g_object_unref0 (app_settings_instance), _tmp0_);
	}
	result = _g_object_ref0 (app_settings_instance);
	return result;
}


static void _lambda6_ (GSettings* setting, const char* key, AppSettings* self) {
	char* _tmp0_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	app_settings_set_system_font (self, _tmp0_ = g_settings_get_string (setting, key));
	_g_free0 (_tmp0_);
	if (g_settings_get_boolean (self->priv->editor, "use-default-font")) {
		app_settings_set_font (self, self->priv->_system_font);
	}
}


static void __lambda6__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda6_ (_sender, key, self);
}


static void _lambda81_ (GSettings* setting, const char* key, AppSettings* self) {
	gboolean val;
	char* _tmp0_;
	char* font;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	_tmp0_ = NULL;
	if (val) {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = g_strdup (self->priv->_system_font), _g_free0 (_tmp0_), _tmp1_);
	} else {
		char* _tmp2_;
		_tmp0_ = (_tmp2_ = g_settings_get_string (self->priv->editor, "editor-font"), _g_free0 (_tmp0_), _tmp2_);
	}
	font = g_strdup (_tmp0_);
	app_settings_set_font (self, font);
	_g_free0 (font);
	_g_free0 (_tmp0_);
}


static void __lambda81__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda81_ (_sender, key, self);
}


static void _lambda82_ (GSettings* setting, const char* key, AppSettings* self) {
	char* _tmp0_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	if (g_settings_get_boolean (self->priv->editor, "use-default-font")) {
		return;
	}
	app_settings_set_font (self, _tmp0_ = g_settings_get_string (setting, key));
	_g_free0 (_tmp0_);
}


static void __lambda82__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda82_ (_sender, key, self);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _lambda83_ (GSettings* setting, const char* key, AppSettings* self) {
	char* scheme_id;
	GtkSourceStyleSchemeManager* manager;
	GtkSourceStyleScheme* scheme;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	scheme_id = g_settings_get_string (setting, key);
	manager = _g_object_ref0 (gtk_source_style_scheme_manager_get_default ());
	scheme = _g_object_ref0 (gtk_source_style_scheme_manager_get_scheme (manager, scheme_id));
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (_tmp1_ = application_get_documents (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) doc, scheme);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
	_g_object_unref0 (scheme);
	_g_object_unref0 (manager);
	_g_free0 (scheme_id);
}


static void __lambda83__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda83_ (_sender, key, self);
}


static void _lambda84_ (GSettings* setting, const char* key, AppSettings* self) {
	guint val = 0U;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &val);
	val = CLAMP (val, (guint) 1, (guint) 24);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* view_collection;
		GList* view_it;
		view_collection = (_tmp1_ = application_get_views (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* view;
			view = _g_object_ref0 ((DocumentView*) view_it->data);
			{
				gtk_source_view_set_tab_width ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free_g_object_unref0 (view_collection);
	}
}


static void __lambda84__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda84_ (_sender, key, self);
}


static void _lambda85_ (GSettings* setting, const char* key, AppSettings* self) {
	gboolean val;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* view_collection;
		GList* view_it;
		view_collection = (_tmp1_ = application_get_views (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* view;
			view = _g_object_ref0 ((DocumentView*) view_it->data);
			{
				gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free_g_object_unref0 (view_collection);
	}
}


static void __lambda85__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda85_ (_sender, key, self);
}


static void _lambda86_ (GSettings* setting, const char* key, AppSettings* self) {
	gboolean val;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* view_collection;
		GList* view_it;
		view_collection = (_tmp1_ = application_get_views (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* view;
			view = _g_object_ref0 ((DocumentView*) view_it->data);
			{
				gtk_source_view_set_show_line_numbers ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free_g_object_unref0 (view_collection);
	}
}


static void __lambda86__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda86_ (_sender, key, self);
}


static void _lambda87_ (GSettings* setting, const char* key, AppSettings* self) {
	gboolean val;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* view_collection;
		GList* view_it;
		view_collection = (_tmp1_ = application_get_views (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* view;
			view = _g_object_ref0 ((DocumentView*) view_it->data);
			{
				gtk_source_view_set_highlight_current_line ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free_g_object_unref0 (view_collection);
	}
}


static void __lambda87__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda87_ (_sender, key, self);
}


static void _lambda88_ (GSettings* setting, const char* key, AppSettings* self) {
	gboolean val;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (_tmp1_ = application_get_documents (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) doc, val);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
}


static void __lambda88__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda88_ (_sender, key, self);
}


static void _lambda89_ (GSettings* setting, const char* key, AppSettings* self) {
	gboolean val;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_boolean (setting, key);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (_tmp1_ = application_get_documents (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				document_tab_set_auto_save (doc->tab, val);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
}


static void __lambda89__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda89_ (_sender, key, self);
}


static void _lambda90_ (GSettings* setting, const char* key, AppSettings* self) {
	guint val = 0U;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &val);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (_tmp1_ = application_get_documents (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				document_tab_set_auto_save_interval (doc->tab, val);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free_g_object_unref0 (doc_collection);
	}
}


static void __lambda90__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda90_ (_sender, key, self);
}


static gboolean _lambda92_ (AppSettings* self) {
	gboolean result = FALSE;
	self->priv->timeout_id = (guint) 0;
	symbols_reload_most_used_symbols ();
	result = FALSE;
	return result;
}


static gboolean __lambda92__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda92_ (self);
	return result;
}


static void _lambda91_ (GSettings* setting, const char* key, AppSettings* self) {
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	if (self->priv->timeout_id != 0) {
		g_source_remove (self->priv->timeout_id);
	}
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda92__gsource_func, g_object_ref (self), g_object_unref);
}


static void __lambda91__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda91_ (_sender, key, self);
}


static void app_settings_initialize (AppSettings* self) {
	GSettings* prefs;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	prefs = _g_object_ref0 (g_settings_get_child ((GSettings*) self, "preferences"));
	self->priv->editor = (_tmp0_ = _g_object_ref0 (g_settings_get_child (prefs, "editor")), _g_object_unref0 (self->priv->editor), _tmp0_);
	if (!DESKTOP_SCHEMAS) {
		app_settings_set_system_font (self, "Monospace 10");
	} else {
		GSettings* _tmp1_;
		char* _tmp2_;
		self->priv->desktop_interface = (_tmp1_ = g_settings_new ("org.gnome.desktop.interface"), _g_object_unref0 (self->priv->desktop_interface), _tmp1_);
		app_settings_set_system_font (self, _tmp2_ = g_settings_get_string (self->priv->desktop_interface, "monospace-font-name"));
		_g_free0 (_tmp2_);
		g_signal_connect_object (self->priv->desktop_interface, "changed::monospace-font-name", (GCallback) __lambda6__g_settings_changed, self, 0);
	}
	g_signal_connect_object (self->priv->editor, "changed::use-default-font", (GCallback) __lambda81__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::editor-font", (GCallback) __lambda82__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::scheme", (GCallback) __lambda83__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::tabs-size", (GCallback) __lambda84__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::insert-spaces", (GCallback) __lambda85__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::display-line-numbers", (GCallback) __lambda86__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::highlight-current-line", (GCallback) __lambda87__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::bracket-matching", (GCallback) __lambda88__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::auto-save", (GCallback) __lambda89__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::auto-save-interval", (GCallback) __lambda90__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::nb-most-used-symbols", (GCallback) __lambda91__g_settings_changed, self, 0);
	_g_object_unref0 (prefs);
}


static void app_settings_set_font (AppSettings* self, const char* font) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* view_collection;
		GList* view_it;
		view_collection = (_tmp1_ = application_get_views (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* view;
			view = _g_object_ref0 ((DocumentView*) view_it->data);
			{
				document_view_set_font_from_string (view, font);
				_g_object_unref0 (view);
			}
		}
		__g_list_free_g_object_unref0 (view_collection);
	}
}


GeeList* app_settings_get_most_used_symbols (AppSettings* self) {
	GeeList* result = NULL;
	gint max;
	g_return_val_if_fail (self != NULL, NULL);
	max = g_settings_get_int (self->priv->editor, "nb-most-used-symbols");
	result = gee_abstract_list_slice ((GeeAbstractList*) self->priv->most_used_symbols, 0, MIN (max, gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols)));
	return result;
}


void app_settings_clear_most_used_symbols (AppSettings* self) {
	g_return_if_fail (self != NULL);
	self->priv->mus_modified = TRUE;
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->most_used_symbols);
}


void app_settings_add_symbol (AppSettings* self, const char* id, const char* command, const char* package) {
	gint max;
	gint i;
	MostUsedSymbol new_symbol = {0};
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (command != NULL);
	self->priv->mus_modified = TRUE;
	max = g_settings_get_int (self->priv->editor, "nb-most-used-symbols");
	i = 0;
	{
		GeeIterator* _mus_it;
		_mus_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->most_used_symbols);
		while (TRUE) {
			MostUsedSymbol* _tmp0_;
			MostUsedSymbol _tmp1_ = {0};
			MostUsedSymbol _tmp2_;
			MostUsedSymbol mus;
			if (!gee_iterator_next (_mus_it)) {
				break;
			}
			mus = (_tmp2_ = (most_used_symbol_copy (_tmp0_ = (MostUsedSymbol*) gee_iterator_get (_mus_it), &_tmp1_), _tmp1_), _most_used_symbol_free0 (_tmp0_), _tmp2_);
			if (_vala_strcmp0 (mus.id, id) == 0) {
				gint new_i;
				gboolean _tmp3_ = FALSE;
				mus.num++;
				new_i = app_settings_sort_most_used_symbol (self, i, &mus);
				if (new_i != i) {
					_tmp3_ = new_i < max;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					if (i >= max) {
						symbols_remove_most_used_symbol (max - 1);
						symbols_insert_most_used_symbol (new_i, &mus);
					} else {
						symbols_swap_most_used_symbol (i, new_i);
					}
				}
				most_used_symbol_destroy (&mus);
				_g_object_unref0 (_mus_it);
				return;
			}
			i++;
			most_used_symbol_destroy (&mus);
		}
		_g_object_unref0 (_mus_it);
	}
	memset (&new_symbol, 0, sizeof (MostUsedSymbol));
	new_symbol.id = (_tmp4_ = g_strdup (id), _g_free0 (new_symbol.id), _tmp4_);
	new_symbol.latex_command = (_tmp5_ = g_strdup (command), _g_free0 (new_symbol.latex_command), _tmp5_);
	new_symbol.package_required = (_tmp6_ = g_strdup (package), _g_free0 (new_symbol.package_required), _tmp6_);
	new_symbol.num = (guint) 1;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->most_used_symbols, &new_symbol);
	if (gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols) <= max) {
		symbols_insert_most_used_symbol (gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols) - 1, &new_symbol);
	}
	most_used_symbol_destroy (&new_symbol);
}


static gint app_settings_sort_most_used_symbol (AppSettings* self, gint index, MostUsedSymbol* mus) {
	gint result = 0;
	gint new_index = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (index == 0) {
		gee_abstract_list_set ((GeeAbstractList*) self->priv->most_used_symbols, index, mus);
		result = 0;
		return result;
	}
	{
		gboolean _tmp0_;
		new_index = index - 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			MostUsedSymbol* _tmp1_;
			MostUsedSymbol _tmp2_ = {0};
			MostUsedSymbol _tmp3_;
			MostUsedSymbol symbol;
			if (!_tmp0_) {
				new_index--;
			}
			_tmp0_ = FALSE;
			if (!(new_index >= 0)) {
				break;
			}
			symbol = (_tmp3_ = (most_used_symbol_copy (_tmp1_ = (MostUsedSymbol*) gee_abstract_list_get ((GeeAbstractList*) self->priv->most_used_symbols, new_index), &_tmp2_), _tmp2_), _most_used_symbol_free0 (_tmp1_), _tmp3_);
			if (symbol.num >= (*mus).num) {
				new_index++;
				most_used_symbol_destroy (&symbol);
				break;
			}
			most_used_symbol_destroy (&symbol);
		}
	}
	if (new_index < 0) {
		new_index = 0;
	}
	if (new_index < index) {
		MostUsedSymbol* _tmp4_;
		_tmp4_ = (MostUsedSymbol*) gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->most_used_symbols, index);
		_most_used_symbol_free0 (_tmp4_);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->most_used_symbols, new_index, mus);
	} else {
		gee_abstract_list_set ((GeeAbstractList*) self->priv->most_used_symbols, index, mus);
	}
	result = new_index;
	return result;
}


static void _app_settings_mus_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error) {
	app_settings_mus_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void app_settings_load_most_used_symbols (AppSettings* self) {
	GeeLinkedList* _tmp0_;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->most_used_symbols = (_tmp0_ = gee_linked_list_new (TYPE_MOST_USED_SYMBOL, (GBoxedCopyFunc) most_used_symbol_dup, most_used_symbol_free, NULL), _g_object_unref0 (self->priv->most_used_symbols), _tmp0_);
	file = app_settings_get_file_most_used_symbols (self);
	if (!g_file_query_exists (file, NULL)) {
		_g_object_unref0 (file);
		return;
	}
	{
		char* contents;
		char* _tmp1_ = NULL;
		char* _tmp2_;
		GMarkupParser _tmp3_ = {0};
		GMarkupParser parser;
		GMarkupParseContext* context;
		contents = NULL;
		g_file_load_contents (file, NULL, &_tmp1_, NULL, NULL, &_inner_error_);
		contents = (_tmp2_ = _tmp1_, _g_free0 (contents), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			goto __catch19_g_error;
		}
		parser = (_tmp3_.start_element = _app_settings_mus_parser_start_gmarkup_parser_start_element_func, _tmp3_.end_element = NULL, _tmp3_.text = NULL, _tmp3_.passthrough = NULL, _tmp3_.error = NULL, _tmp3_);
		context = g_markup_parse_context_new (&parser, 0, self, NULL);
		g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			_g_free0 (contents);
			goto __catch19_g_error;
		}
		_g_markup_parse_context_free0 (context);
		_g_free0 (contents);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to load most used symbols: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static void app_settings_mus_parser_start (AppSettings* self, GMarkupParseContext* context, const char* name, char** attr_names, int attr_names_length1, char** attr_values, int attr_values_length1, GError** error) {
	const char* _tmp13_;
	GQuark _tmp14_;
	static GQuark _tmp14__label0 = 0;
	static GQuark _tmp14__label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp13_ = name;
	_tmp14_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
	if (_tmp14_ == ((0 != _tmp14__label0) ? _tmp14__label0 : (_tmp14__label0 = g_quark_from_static_string ("symbols"))))
	switch (0) {
		default:
		{
			return;
		}
	} else if (_tmp14_ == ((0 != _tmp14__label1) ? _tmp14__label1 : (_tmp14__label1 = g_quark_from_static_string ("symbol"))))
	switch (0) {
		default:
		{
			MostUsedSymbol symbol = {0};
			memset (&symbol, 0, sizeof (MostUsedSymbol));
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						const char* _tmp8_;
						GQuark _tmp9_;
						static GQuark _tmp9__label0 = 0;
						static GQuark _tmp9__label1 = 0;
						static GQuark _tmp9__label2 = 0;
						static GQuark _tmp9__label3 = 0;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < attr_names_length1)) {
							break;
						}
						_tmp8_ = attr_names[i];
						_tmp9_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
						if (_tmp9_ == ((0 != _tmp9__label0) ? _tmp9__label0 : (_tmp9__label0 = g_quark_from_static_string ("id"))))
						switch (0) {
							default:
							{
								char* _tmp1_;
								symbol.id = (_tmp1_ = g_strdup (attr_values[i]), _g_free0 (symbol.id), _tmp1_);
								break;
							}
						} else if (_tmp9_ == ((0 != _tmp9__label1) ? _tmp9__label1 : (_tmp9__label1 = g_quark_from_static_string ("command"))))
						switch (0) {
							default:
							{
								char* _tmp2_;
								symbol.latex_command = (_tmp2_ = g_strdup (attr_values[i]), _g_free0 (symbol.latex_command), _tmp2_);
								break;
							}
						} else if (_tmp9_ == ((0 != _tmp9__label2) ? _tmp9__label2 : (_tmp9__label2 = g_quark_from_static_string ("package"))))
						switch (0) {
							default:
							{
								const char* _tmp3_;
								char* _tmp4_;
								_tmp3_ = NULL;
								if (_vala_strcmp0 (attr_values[i], "") != 0) {
									_tmp3_ = attr_values[i];
								} else {
									_tmp3_ = NULL;
								}
								symbol.package_required = (_tmp4_ = g_strdup (_tmp3_), _g_free0 (symbol.package_required), _tmp4_);
								break;
							}
						} else if (_tmp9_ == ((0 != _tmp9__label3) ? _tmp9__label3 : (_tmp9__label3 = g_quark_from_static_string ("num"))))
						switch (0) {
							default:
							{
								symbol.num = (guint) atoi (attr_values[i]);
								break;
							}
						} else
						switch (0) {
							default:
							{
								char* _tmp5_;
								char* _tmp6_;
								GError* _tmp7_;
								_inner_error_ = (_tmp7_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp6_ = g_strconcat (_tmp5_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL), "\"", NULL)), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_);
								{
									if (_inner_error_->domain == G_MARKUP_ERROR) {
										g_propagate_error (error, _inner_error_);
										most_used_symbol_destroy (&symbol);
										return;
									} else {
										most_used_symbol_destroy (&symbol);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->most_used_symbols, &symbol);
			most_used_symbol_destroy (&symbol);
			break;
		}
	} else
	switch (0) {
		default:
		{
			char* _tmp10_;
			char* _tmp11_;
			GError* _tmp12_;
			_inner_error_ = (_tmp12_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp11_ = g_strconcat (_tmp10_ = g_strconcat ("unknown element \"", name, NULL), "\"", NULL)), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _tmp12_);
			{
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* app_settings_get_file_most_used_symbols (AppSettings* self) {
	GFile* result = NULL;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	path = g_build_filename (g_get_user_data_dir (), "latexila", "most_used_symbols.xml", NULL, NULL);
	result = g_file_new_for_path (path);
	_g_free0 (path);
	return result;
}


void app_settings_save_most_used_symbols (AppSettings* self) {
	GFile* file;
	char* content;
	char* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->mus_modified) {
		return;
	}
	file = app_settings_get_file_most_used_symbols (self);
	if (gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols) == 0) {
		utils_delete_file (file);
		_g_object_unref0 (file);
		return;
	}
	content = g_strdup ("<symbols>\n");
	{
		GeeIterator* _symbol_it;
		_symbol_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->most_used_symbols);
		while (TRUE) {
			MostUsedSymbol* _tmp0_;
			MostUsedSymbol _tmp1_ = {0};
			MostUsedSymbol _tmp2_;
			MostUsedSymbol symbol;
			char* _tmp3_;
			char* _tmp5_;
			char* _tmp6_;
			if (!gee_iterator_next (_symbol_it)) {
				break;
			}
			symbol = (_tmp2_ = (most_used_symbol_copy (_tmp0_ = (MostUsedSymbol*) gee_iterator_get (_symbol_it), &_tmp1_), _tmp1_), _most_used_symbol_free0 (_tmp0_), _tmp2_);
			_tmp3_ = g_strdup (symbol.package_required);
			if (_tmp3_ == NULL) {
				char* _tmp4_;
				_tmp3_ = (_tmp4_ = g_strdup (""), _g_free0 (_tmp3_), _tmp4_);
			}
			content = (_tmp6_ = g_strconcat (content, _tmp5_ = g_strdup_printf ("  <symbol id=\"%s\" command=\"%s\" package=\"%s\" num=\"%u\" />\n", symbol.id, symbol.latex_command, _tmp3_, symbol.num), NULL), _g_free0 (content), _tmp6_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp3_);
			most_used_symbol_destroy (&symbol);
		}
		_g_object_unref0 (_symbol_it);
	}
	content = (_tmp7_ = g_strconcat (content, "</symbols>\n", NULL), _g_free0 (content), _tmp7_);
	{
		GFile* parent;
		gboolean _tmp8_ = FALSE;
		parent = g_file_get_parent (file);
		if (parent != NULL) {
			_tmp8_ = !g_file_query_exists (parent, NULL);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch20_g_error;
			}
		}
		g_file_replace_contents (file, content, strlen (content), NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch20_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to save most used symbols: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_object_unref0 (file);
}


GeeLinkedList* app_settings_get_build_tools (AppSettings* self) {
	GeeLinkedList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->build_tools;
	return result;
}


void app_settings_move_build_tool_up (AppSettings* self, gint num) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (num > 0);
	app_settings_swap_build_tools (self, num, num - 1);
}


void app_settings_move_build_tool_down (AppSettings* self, gint num) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (num < (gee_collection_get_size ((GeeCollection*) self->priv->build_tools) - 1));
	app_settings_swap_build_tools (self, num, num + 1);
}


static void app_settings_swap_build_tools (AppSettings* self, gint num1, gint num2) {
	BuildTool* _tmp0_;
	BuildTool _tmp1_ = {0};
	BuildTool _tmp2_;
	BuildTool tool;
	BuildTool* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	tool = (_tmp2_ = (build_tool_copy (_tmp0_ = (BuildTool*) gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, num1), &_tmp1_), _tmp1_), _build_tool_free0 (_tmp0_), _tmp2_);
	_tmp3_ = (BuildTool*) gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num1);
	_build_tool_free0 (_tmp3_);
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, num2, &tool);
	app_settings_update_all_build_tools_menu (self);
	build_tool_destroy (&tool);
}


void app_settings_delete_build_tool (AppSettings* self, gint num) {
	gboolean _tmp0_ = FALSE;
	BuildTool* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (num >= 0) {
		_tmp0_ = num < gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp1_ = (BuildTool*) gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num);
	_build_tool_free0 (_tmp1_);
	app_settings_update_all_build_tools_menu (self);
}


void app_settings_append_build_tool (AppSettings* self, BuildTool* tool) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	(*tool).compilation = app_settings_is_compilation (self, (*tool).icon);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->build_tools, tool);
	app_settings_update_all_build_tools_menu (self);
}


void app_settings_update_build_tool (AppSettings* self, gint num, BuildTool* tool) {
	gboolean _tmp0_ = FALSE;
	BuildTool* _tmp1_;
	BuildTool _tmp2_ = {0};
	BuildTool _tmp3_;
	BuildTool current_tool;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (num >= 0) {
		_tmp0_ = num < gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	current_tool = (_tmp3_ = (build_tool_copy (_tmp1_ = (BuildTool*) gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, num), &_tmp2_), _tmp2_), _build_tool_free0 (_tmp1_), _tmp3_);
	if (!app_settings_is_build_tools_equal (self, &current_tool, tool)) {
		BuildTool* _tmp4_;
		(*tool).compilation = app_settings_is_compilation (self, (*tool).icon);
		_tmp4_ = (BuildTool*) gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num);
		_build_tool_free0 (_tmp4_);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, num, tool);
		app_settings_update_all_build_tools_menu (self);
	}
	build_tool_destroy (&current_tool);
}


void app_settings_reset_all_build_tools (AppSettings* self) {
	GFile* file;
	g_return_if_fail (self != NULL);
	file = app_settings_get_user_config_build_tools_file (self);
	if (g_file_query_exists (file, NULL)) {
		utils_delete_file (file);
	}
	app_settings_load_build_tools (self);
	app_settings_update_all_build_tools_menu (self);
	_g_object_unref0 (file);
}


static gboolean app_settings_is_build_tools_equal (AppSettings* self, BuildTool* tool1, BuildTool* tool2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (_vala_strcmp0 ((*tool1).label, (*tool2).label) != 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = _vala_strcmp0 ((*tool1).description, (*tool2).description) != 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = _vala_strcmp0 ((*tool1).extensions, (*tool2).extensions) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 ((*tool1).icon, (*tool2).icon) != 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_list_length ((*tool1).jobs) != g_list_length ((*tool2).jobs);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				BuildJob _tmp5_ = {0};
				BuildJob job1;
				BuildJob _tmp6_ = {0};
				BuildJob job2;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < g_list_length ((*tool1).jobs))) {
					break;
				}
				job1 = (build_job_copy ((BuildJob*) g_list_nth_data ((*tool1).jobs, i), &_tmp5_), _tmp5_);
				job2 = (build_job_copy ((BuildJob*) g_list_nth_data ((*tool2).jobs, i), &_tmp6_), _tmp6_);
				if (_vala_strcmp0 (job1.command, job2.command) != 0) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = job1.must_succeed != job2.must_succeed;
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = _vala_strcmp0 (job1.post_processor, job2.post_processor) != 0;
				}
				if (_tmp7_) {
					result = FALSE;
					build_job_destroy (&job2);
					build_job_destroy (&job1);
					return result;
				}
				build_job_destroy (&job2);
				build_job_destroy (&job1);
			}
		}
	}
	result = TRUE;
	return result;
}


static void app_settings_update_all_build_tools_menu (AppSettings* self) {
	g_return_if_fail (self != NULL);
	self->priv->build_tools_modified = TRUE;
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* window_collection;
		GList* window_it;
		window_collection = (_tmp1_ = application_get_windows (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MainWindow* window;
			window = _g_object_ref0 ((MainWindow*) window_it->data);
			{
				main_window_update_build_tools_menu (window);
				_g_object_unref0 (window);
			}
		}
	}
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static gboolean app_settings_is_compilation (AppSettings* self, const char* icon) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (icon != NULL, FALSE);
	if (string_contains (icon, "compile")) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 (icon, GTK_STOCK_EXECUTE) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (icon, GTK_STOCK_CONVERT) == 0;
	}
	result = _tmp0_;
	return result;
}


static void _vala_array_add9 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _app_settings_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error) {
	app_settings_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _app_settings_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const char* element_name, gpointer self, GError** error) {
	app_settings_parser_end (self, context, element_name, error);
}


static void _app_settings_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const char* text, gsize text_len, gpointer self, GError** error) {
	app_settings_parser_text (self, context, text, text_len, error);
}


static void app_settings_load_build_tools (AppSettings* self) {
	GeeLinkedList* _tmp0_;
	gint files_length1;
	gint _files_size_;
	GFile** _tmp2_;
	GFile** _tmp1_ = NULL;
	GFile** files;
	char* _tmp3_;
	char* _tmp4_;
	GFile* _tmp5_;
	GFile* default_file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->build_tools = (_tmp0_ = gee_linked_list_new (TYPE_BUILD_TOOL, (GBoxedCopyFunc) build_tool_dup, build_tool_free, NULL), _g_object_unref0 (self->priv->build_tools), _tmp0_);
	files = (_tmp2_ = (_tmp1_ = g_new0 (GFile*, 0 + 1), _tmp1_), files_length1 = 0, _files_size_ = files_length1, _tmp2_);
	_vala_array_add9 (&files, &files_length1, &_files_size_, app_settings_get_user_config_build_tools_file (self));
	_vala_array_add10 (&files, &files_length1, &_files_size_, g_file_new_for_path (_tmp3_ = g_build_filename (DATA_DIR, "build_tools", _ ("build_tools-en.xml"), NULL, NULL)));
	_g_free0 (_tmp3_);
	default_file = (_tmp5_ = g_file_new_for_path (_tmp4_ = g_build_filename (DATA_DIR, "build_tools", "build_tools-en.xml", NULL, NULL)), _g_free0 (_tmp4_), _tmp5_);
	if (!g_file_equal (default_file, files[1])) {
		_vala_array_add11 (&files, &files_length1, &_files_size_, _g_object_ref0 (default_file));
	}
	{
		GFile** file_collection;
		int file_collection_length1;
		int file_it;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < files_length1; file_it = file_it + 1) {
			GFile* file;
			file = _g_object_ref0 (file_collection[file_it]);
			{
				{
					char* contents;
					char* _tmp6_ = NULL;
					char* _tmp7_;
					GMarkupParser _tmp8_ = {0};
					GMarkupParser parser;
					GMarkupParseContext* context;
					if (!g_file_query_exists (file, NULL)) {
						_g_object_unref0 (file);
						continue;
					}
					contents = NULL;
					g_file_load_contents (file, NULL, &_tmp6_, NULL, NULL, &_inner_error_);
					contents = (_tmp7_ = _tmp6_, _g_free0 (contents), _tmp7_);
					if (_inner_error_ != NULL) {
						_g_free0 (contents);
						goto __catch21_g_error;
					}
					parser = (_tmp8_.start_element = _app_settings_parser_start_gmarkup_parser_start_element_func, _tmp8_.end_element = _app_settings_parser_end_gmarkup_parser_end_element_func, _tmp8_.text = _app_settings_parser_text_gmarkup_parser_text_func, _tmp8_.passthrough = NULL, _tmp8_.error = NULL, _tmp8_);
					context = g_markup_parse_context_new (&parser, 0, self, NULL);
					g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_markup_parse_context_free0 (context);
						_g_free0 (contents);
						goto __catch21_g_error;
					}
					_g_markup_parse_context_free0 (context);
					_g_free0 (contents);
					_g_object_unref0 (file);
					break;
				}
				goto __finally21;
				__catch21_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stderr, "Warning: impossible to load build tools: %s\n", e->message);
						_g_error_free0 (e);
					}
				}
				__finally21:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					_g_object_unref0 (default_file);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (file);
			}
		}
	}
	_g_object_unref0 (default_file);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}


static gboolean string_to_bool (const char* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (_vala_strcmp0 (self, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void app_settings_parser_start (AppSettings* self, GMarkupParseContext* context, const char* name, char** attr_names, int attr_names_length1, char** attr_values, int attr_values_length1, GError** error) {
	const char* _tmp26_;
	GQuark _tmp27_;
	static GQuark _tmp27__label0 = 0;
	static GQuark _tmp27__label1 = 0;
	static GQuark _tmp27__label2 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp26_ = name;
	_tmp27_ = (NULL == _tmp26_) ? 0 : g_quark_from_string (_tmp26_);
	if (_tmp27_ == ((0 != _tmp27__label0) ? _tmp27__label0 : (_tmp27__label0 = g_quark_from_static_string ("tools"))))
	switch (0) {
		default:
		{
			return;
		}
	} else if (_tmp27_ == ((0 != _tmp27__label1) ? _tmp27__label1 : (_tmp27__label1 = g_quark_from_static_string ("tool"))))
	switch (0) {
		default:
		{
			BuildTool _tmp0_ = {0};
			BuildTool _tmp1_;
			self->priv->current_build_tool = (_tmp1_ = (memset (&_tmp0_, 0, sizeof (BuildTool)), _tmp0_), build_tool_destroy (&self->priv->current_build_tool), _tmp1_);
			self->priv->current_build_tool.compilation = FALSE;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						const char* _tmp12_;
						GQuark _tmp13_;
						static GQuark _tmp13__label0 = 0;
						static GQuark _tmp13__label1 = 0;
						static GQuark _tmp13__label2 = 0;
						static GQuark _tmp13__label3 = 0;
						if (!_tmp2_) {
							i++;
						}
						_tmp2_ = FALSE;
						if (!(i < attr_names_length1)) {
							break;
						}
						_tmp12_ = attr_names[i];
						_tmp13_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
						if (_tmp13_ == ((0 != _tmp13__label0) ? _tmp13__label0 : (_tmp13__label0 = g_quark_from_static_string ("description"))))
						switch (0) {
							default:
							{
								char* _tmp3_;
								self->priv->current_build_tool.description = (_tmp3_ = g_strdup (attr_values[i]), _g_free0 (self->priv->current_build_tool.description), _tmp3_);
								break;
							}
						} else if (_tmp13_ == ((0 != _tmp13__label1) ? _tmp13__label1 : (_tmp13__label1 = g_quark_from_static_string ("extensions"))))
						switch (0) {
							default:
							{
								char* _tmp4_;
								self->priv->current_build_tool.extensions = (_tmp4_ = g_strdup (attr_values[i]), _g_free0 (self->priv->current_build_tool.extensions), _tmp4_);
								break;
							}
						} else if (_tmp13_ == ((0 != _tmp13__label2) ? _tmp13__label2 : (_tmp13__label2 = g_quark_from_static_string ("label"))))
						switch (0) {
							default:
							{
								char* _tmp5_;
								self->priv->current_build_tool.label = (_tmp5_ = g_strdup (attr_values[i]), _g_free0 (self->priv->current_build_tool.label), _tmp5_);
								break;
							}
						} else if (_tmp13_ == ((0 != _tmp13__label3) ? _tmp13__label3 : (_tmp13__label3 = g_quark_from_static_string ("icon"))))
						switch (0) {
							default:
							{
								char* icon;
								char* _tmp6_;
								const char* _tmp7_;
								GQuark _tmp8_;
								static GQuark _tmp8__label0 = 0;
								static GQuark _tmp8__label1 = 0;
								static GQuark _tmp8__label2 = 0;
								icon = g_strdup (attr_values[i]);
								self->priv->current_build_tool.icon = (_tmp6_ = g_strdup (icon), _g_free0 (self->priv->current_build_tool.icon), _tmp6_);
								_tmp7_ = icon;
								_tmp8_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
								if (_tmp8_ == ((0 != _tmp8__label0) ? _tmp8__label0 : (_tmp8__label0 = g_quark_from_static_string ("view_dvi"))))
								switch (0) {
									default:
									{
										self->priv->current_tool_is_view_dvi = TRUE;
										break;
									}
								} else if (_tmp8_ == ((0 != _tmp8__label1) ? _tmp8__label1 : (_tmp8__label1 = g_quark_from_static_string ("view_pdf"))))
								switch (0) {
									default:
									{
										self->priv->current_tool_is_view_pdf = TRUE;
										break;
									}
								} else if (_tmp8_ == ((0 != _tmp8__label2) ? _tmp8__label2 : (_tmp8__label2 = g_quark_from_static_string ("view_ps"))))
								switch (0) {
									default:
									{
										self->priv->current_tool_is_view_ps = TRUE;
										break;
									}
								}
								self->priv->current_build_tool.compilation = app_settings_is_compilation (self, icon);
								_g_free0 (icon);
								break;
							}
						} else
						switch (0) {
							default:
							{
								char* _tmp9_;
								char* _tmp10_;
								GError* _tmp11_;
								_inner_error_ = (_tmp11_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp10_ = g_strconcat (_tmp9_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL), "\"", NULL)), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp11_);
								{
									if (_inner_error_->domain == G_MARKUP_ERROR) {
										g_propagate_error (error, _inner_error_);
										return;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
			}
			break;
		}
	} else if (_tmp27_ == ((0 != _tmp27__label2) ? _tmp27__label2 : (_tmp27__label2 = g_quark_from_static_string ("job"))))
	switch (0) {
		default:
		{
			BuildJob _tmp14_ = {0};
			BuildJob _tmp15_;
			self->priv->current_build_job = (_tmp15_ = (memset (&_tmp14_, 0, sizeof (BuildJob)), _tmp14_), build_job_destroy (&self->priv->current_build_job), _tmp15_);
			{
				gint i;
				i = 0;
				{
					gboolean _tmp16_;
					_tmp16_ = TRUE;
					while (TRUE) {
						const char* _tmp21_;
						GQuark _tmp22_;
						static GQuark _tmp22__label0 = 0;
						static GQuark _tmp22__label1 = 0;
						if (!_tmp16_) {
							i++;
						}
						_tmp16_ = FALSE;
						if (!(i < attr_names_length1)) {
							break;
						}
						_tmp21_ = attr_names[i];
						_tmp22_ = (NULL == _tmp21_) ? 0 : g_quark_from_string (_tmp21_);
						if (_tmp22_ == ((0 != _tmp22__label0) ? _tmp22__label0 : (_tmp22__label0 = g_quark_from_static_string ("mustSucceed"))))
						switch (0) {
							default:
							{
								self->priv->current_build_job.must_succeed = string_to_bool (attr_values[i]);
								break;
							}
						} else if (_tmp22_ == ((0 != _tmp22__label1) ? _tmp22__label1 : (_tmp22__label1 = g_quark_from_static_string ("postProcessor"))))
						switch (0) {
							default:
							{
								char* _tmp17_;
								self->priv->current_build_job.post_processor = (_tmp17_ = g_strdup (attr_values[i]), _g_free0 (self->priv->current_build_job.post_processor), _tmp17_);
								break;
							}
						} else
						switch (0) {
							default:
							{
								char* _tmp18_;
								char* _tmp19_;
								GError* _tmp20_;
								_inner_error_ = (_tmp20_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp19_ = g_strconcat (_tmp18_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL), "\"", NULL)), _g_free0 (_tmp19_), _g_free0 (_tmp18_), _tmp20_);
								{
									if (_inner_error_->domain == G_MARKUP_ERROR) {
										g_propagate_error (error, _inner_error_);
										return;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
			}
			break;
		}
	} else
	switch (0) {
		default:
		{
			char* _tmp23_;
			char* _tmp24_;
			GError* _tmp25_;
			_inner_error_ = (_tmp25_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp24_ = g_strconcat (_tmp23_ = g_strconcat ("unknown element \"", name, NULL), "\"", NULL)), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _tmp25_);
			{
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


static void app_settings_parser_end (AppSettings* self, GMarkupParseContext* context, const char* name, GError** error) {
	const char* _tmp3_;
	GQuark _tmp4_;
	static GQuark _tmp4__label0 = 0;
	static GQuark _tmp4__label1 = 0;
	static GQuark _tmp4__label2 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp3_ = name;
	_tmp4_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp4_ == ((0 != _tmp4__label0) ? _tmp4__label0 : (_tmp4__label0 = g_quark_from_static_string ("tools"))))
	switch (0) {
		default:
		{
			return;
		}
	} else if (_tmp4_ == ((0 != _tmp4__label1) ? _tmp4__label1 : (_tmp4__label1 = g_quark_from_static_string ("tool"))))
	switch (0) {
		default:
		{
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->build_tools, &self->priv->current_build_tool);
			if (self->priv->current_tool_is_view_dvi) {
				app_settings_set_build_tool_view_dvi (self, &self->priv->current_build_tool);
				self->priv->current_tool_is_view_dvi = FALSE;
			} else {
				if (self->priv->current_tool_is_view_pdf) {
					app_settings_set_build_tool_view_pdf (self, &self->priv->current_build_tool);
					self->priv->current_tool_is_view_pdf = FALSE;
				} else {
					if (self->priv->current_tool_is_view_ps) {
						app_settings_set_build_tool_view_ps (self, &self->priv->current_build_tool);
						self->priv->current_tool_is_view_ps = FALSE;
					}
				}
			}
			break;
		}
	} else if (_tmp4_ == ((0 != _tmp4__label2) ? _tmp4__label2 : (_tmp4__label2 = g_quark_from_static_string ("job"))))
	switch (0) {
		default:
		{
			self->priv->current_build_tool.jobs = g_list_append (self->priv->current_build_tool.jobs, _build_job_dup0 (&self->priv->current_build_job));
			break;
		}
	} else
	switch (0) {
		default:
		{
			char* _tmp0_;
			char* _tmp1_;
			GError* _tmp2_;
			_inner_error_ = (_tmp2_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("unknown element \"", name, NULL), "\"", NULL)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
			{
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void app_settings_parser_text (AppSettings* self, GMarkupParseContext* context, const char* text, gsize text_len, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	if (_vala_strcmp0 (g_markup_parse_context_get_element (context), "job") == 0) {
		char* _tmp0_;
		self->priv->current_build_job.command = (_tmp0_ = g_strdup (text), _g_free0 (self->priv->current_build_job.command), _tmp0_);
	}
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


void app_settings_save_build_tools (AppSettings* self) {
	char* content;
	char* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (!self->priv->build_tools_modified) {
		return;
	}
	content = g_strdup ("<tools>\n");
	{
		GeeIterator* _tool_it;
		_tool_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->build_tools);
		while (TRUE) {
			BuildTool* _tmp0_;
			BuildTool _tmp1_ = {0};
			BuildTool _tmp2_;
			BuildTool tool;
			char* _tmp3_;
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp13_;
			if (!gee_iterator_next (_tool_it)) {
				break;
			}
			tool = (_tmp2_ = (build_tool_copy (_tmp0_ = (BuildTool*) gee_iterator_get (_tool_it), &_tmp1_), _tmp1_), _build_tool_free0 (_tmp0_), _tmp2_);
			content = (_tmp6_ = g_strconcat (content, _tmp5_ = g_strdup_printf ("  <tool description=\"%s\" extensions=\"%s\" label=\"%s\" icon=\"%s\">" \
"\n", _tmp3_ = g_markup_escape_text (tool.description, -1), tool.extensions, _tmp4_ = g_markup_escape_text (tool.label, -1), tool.icon), NULL), _g_free0 (content), _tmp6_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
			{
				GList* job_collection;
				GList* job_it;
				job_collection = tool.jobs;
				for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
					BuildJob _tmp12_ = {0};
					BuildJob job;
					job = (build_job_copy ((BuildJob*) job_it->data, &_tmp12_), _tmp12_);
					{
						char* _tmp7_;
						char* _tmp8_;
						char* _tmp9_;
						char* _tmp10_;
						char* _tmp11_;
						content = (_tmp9_ = g_strconcat (content, _tmp8_ = g_strdup_printf ("    <job mustSucceed=\"%s\" postProcessor=\"%s\">", _tmp7_ = bool_to_string (job.must_succeed), job.post_processor), NULL), _g_free0 (content), _tmp9_);
						_g_free0 (_tmp8_);
						_g_free0 (_tmp7_);
						content = (_tmp11_ = g_strconcat (content, _tmp10_ = g_markup_printf_escaped ("%s</job>\n", job.command), NULL), _g_free0 (content), _tmp11_);
						_g_free0 (_tmp10_);
						build_job_destroy (&job);
					}
				}
			}
			content = (_tmp13_ = g_strconcat (content, "  </tool>\n", NULL), _g_free0 (content), _tmp13_);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	content = (_tmp14_ = g_strconcat (content, "</tools>\n", NULL), _g_free0 (content), _tmp14_);
	{
		GFile* file;
		GFile* parent;
		gboolean _tmp15_ = FALSE;
		file = app_settings_get_user_config_build_tools_file (self);
		parent = g_file_get_parent (file);
		if (parent != NULL) {
			_tmp15_ = !g_file_query_exists (parent, NULL);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				goto __catch22_g_error;
			}
		}
		g_file_replace_contents (file, content, strlen (content), NULL, TRUE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			goto __catch22_g_error;
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to save build tools: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
}


static GFile* app_settings_get_user_config_build_tools_file (AppSettings* self) {
	GFile* result = NULL;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	path = g_build_filename (g_get_user_config_dir (), "latexila", "build_tools.xml", NULL, NULL);
	result = g_file_new_for_path (path);
	_g_free0 (path);
	return result;
}


Project* app_settings_get_project (AppSettings* self, gint id) {
	Project* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (id >= 0) {
		_tmp0_ = id < gee_collection_get_size ((GeeCollection*) self->priv->projects);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	result = (Project*) gee_abstract_list_get ((GeeAbstractList*) self->priv->projects, id);
	return result;
}


GeeLinkedList* app_settings_get_projects (AppSettings* self) {
	GeeLinkedList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->projects;
	return result;
}


static void app_settings_update_projects_menus (AppSettings* self) {
	g_return_if_fail (self != NULL);
	{
		Application* _tmp0_;
		GList* _tmp1_;
		GList* window_collection;
		GList* window_it;
		window_collection = (_tmp1_ = application_get_windows (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MainWindow* window;
			window = _g_object_ref0 ((MainWindow*) window_it->data);
			{
				main_window_update_config_project_sensitivity (window);
				_g_object_unref0 (window);
			}
		}
	}
}


gboolean app_settings_add_project (AppSettings* self, Project* new_project, GFile** conflict) {
	gboolean result = FALSE;
	Application* _tmp4_;
	GList* _tmp5_;
	GList* docs;
	g_return_val_if_fail (self != NULL, FALSE);
	if (conflict != NULL) {
		*conflict = NULL;
	}
	{
		GeeIterator* _project_it;
		_project_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->projects);
		while (TRUE) {
			Project* _tmp0_;
			Project _tmp1_ = {0};
			Project _tmp2_;
			Project project;
			if (!gee_iterator_next (_project_it)) {
				break;
			}
			project = (_tmp2_ = (project_copy (_tmp0_ = (Project*) gee_iterator_get (_project_it), &_tmp1_), _tmp1_), _project_free0 (_tmp0_), _tmp2_);
			if (app_settings_projects_conflict (self, project.directory, (*new_project).directory)) {
				GFile* _tmp3_;
				*conflict = (_tmp3_ = _g_object_ref0 (project.directory), _g_object_unref0 (*conflict), _tmp3_);
				result = FALSE;
				project_destroy (&project);
				_g_object_unref0 (_project_it);
				return result;
			}
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->projects, new_project);
	self->priv->projects_modified = TRUE;
	docs = (_tmp5_ = application_get_documents (_tmp4_ = application_get_default ()), _g_object_unref0 (_tmp4_), _tmp5_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = docs;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (document_get_project_id (doc) != (-1)) {
					_g_object_unref0 (doc);
					continue;
				}
				if (g_file_has_prefix (document_get_location (doc), (*new_project).directory)) {
					document_set_project_id (doc, gee_collection_get_size ((GeeCollection*) self->priv->projects) - 1);
				}
				_g_object_unref0 (doc);
			}
		}
	}
	app_settings_update_projects_menus (self);
	result = TRUE;
	__g_list_free_g_object_unref0 (docs);
	return result;
}


gboolean app_settings_project_change_main_file (AppSettings* self, gint num, GFile* new_main_file) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Project* _tmp1_;
	Project _tmp2_ = {0};
	Project _tmp3_;
	Project project;
	GFile* _tmp4_;
	Application* _tmp5_;
	GList* _tmp6_;
	GList* docs;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_main_file != NULL, FALSE);
	if (num >= 0) {
		_tmp0_ = num < gee_collection_get_size ((GeeCollection*) self->priv->projects);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, FALSE);
	project = (_tmp3_ = (project_copy (_tmp1_ = (Project*) gee_abstract_list_get ((GeeAbstractList*) self->priv->projects, num), &_tmp2_), _tmp2_), _project_free0 (_tmp1_), _tmp3_);
	if (g_file_equal (new_main_file, project.main_file)) {
		result = FALSE;
		project_destroy (&project);
		return result;
	}
	g_return_if_fail (g_file_has_prefix (new_main_file, project.directory));
	project.main_file = (_tmp4_ = _g_object_ref0 (new_main_file), _g_object_unref0 (project.main_file), _tmp4_);
	gee_abstract_list_set ((GeeAbstractList*) self->priv->projects, num, &project);
	self->priv->projects_modified = TRUE;
	docs = (_tmp6_ = application_get_documents (_tmp5_ = application_get_default ()), _g_object_unref0 (_tmp5_), _tmp6_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = docs;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (document_get_project_id (doc) == num) {
					document_set_project_id (doc, num);
				}
				_g_object_unref0 (doc);
			}
		}
	}
	result = TRUE;
	__g_list_free_g_object_unref0 (docs);
	project_destroy (&project);
	return result;
}


void app_settings_delete_project (AppSettings* self, gint num) {
	gboolean _tmp0_ = FALSE;
	Project* _tmp1_;
	Application* _tmp2_;
	GList* _tmp3_;
	GList* docs;
	g_return_if_fail (self != NULL);
	if (num >= 0) {
		_tmp0_ = num < gee_collection_get_size ((GeeCollection*) self->priv->projects);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp1_ = (Project*) gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->projects, num);
	_project_free0 (_tmp1_);
	docs = (_tmp3_ = application_get_documents (_tmp2_ = application_get_default ()), _g_object_unref0 (_tmp2_), _tmp3_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = docs;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				if (document_get_project_id (doc) == num) {
					document_set_project_id (doc, -1);
				} else {
					if (document_get_project_id (doc) > num) {
						gint _tmp4_;
						_tmp4_ = document_get_project_id (doc);
						document_set_project_id (doc, _tmp4_ - 1);
						_tmp4_;
					}
				}
				_g_object_unref0 (doc);
			}
		}
	}
	app_settings_update_projects_menus (self);
	__g_list_free_g_object_unref0 (docs);
}


void app_settings_clear_all_projects (AppSettings* self) {
	g_return_if_fail (self != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->projects);
	app_settings_update_all_documents (self);
	app_settings_update_projects_menus (self);
}


static void app_settings_update_all_documents (AppSettings* self) {
	Application* _tmp0_;
	GList* _tmp1_;
	GList* docs;
	g_return_if_fail (self != NULL);
	docs = (_tmp1_ = application_get_documents (_tmp0_ = application_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = docs;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* doc;
			doc = _g_object_ref0 ((Document*) doc_it->data);
			{
				document_set_project_id (doc, -1);
				{
					gint i;
					i = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							Project* _tmp3_;
							gboolean _tmp4_;
							if (!_tmp2_) {
								i++;
							}
							_tmp2_ = FALSE;
							if (!(i < gee_collection_get_size ((GeeCollection*) self->priv->projects))) {
								break;
							}
							if ((_tmp4_ = g_file_has_prefix (document_get_location (doc), (*(_tmp3_ = (Project*) gee_abstract_list_get ((GeeAbstractList*) self->priv->projects, i))).directory), _project_free0 (_tmp3_), _tmp4_)) {
								document_set_project_id (doc, i);
								break;
							}
						}
					}
				}
				_g_object_unref0 (doc);
			}
		}
	}
	__g_list_free_g_object_unref0 (docs);
}


static void _app_settings_projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const char* element_name, char** attribute_names, char** attribute_values, gpointer self, GError** error) {
	app_settings_projects_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void app_settings_load_projects (AppSettings* self) {
	GeeLinkedList* _tmp0_;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->projects = (_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, project_free, NULL), _g_object_unref0 (self->priv->projects), _tmp0_);
	file = app_settings_get_file_projects (self);
	if (!g_file_query_exists (file, NULL)) {
		_g_object_unref0 (file);
		return;
	}
	{
		char* contents;
		char* _tmp1_ = NULL;
		char* _tmp2_;
		GMarkupParser _tmp3_ = {0};
		GMarkupParser parser;
		GMarkupParseContext* context;
		contents = NULL;
		g_file_load_contents (file, NULL, &_tmp1_, NULL, NULL, &_inner_error_);
		contents = (_tmp2_ = _tmp1_, _g_free0 (contents), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			goto __catch23_g_error;
		}
		parser = (_tmp3_.start_element = _app_settings_projects_parser_start_gmarkup_parser_start_element_func, _tmp3_.end_element = NULL, _tmp3_.text = NULL, _tmp3_.passthrough = NULL, _tmp3_.error = NULL, _tmp3_);
		context = g_markup_parse_context_new (&parser, 0, self, NULL);
		g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			_g_free0 (contents);
			goto __catch23_g_error;
		}
		app_settings_update_all_documents (self);
		app_settings_update_projects_menus (self);
		_g_markup_parse_context_free0 (context);
		_g_free0 (contents);
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to load projects: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static void app_settings_projects_parser_start (AppSettings* self, GMarkupParseContext* context, const char* name, char** attr_names, int attr_names_length1, char** attr_values, int attr_values_length1, GError** error) {
	const char* _tmp11_;
	GQuark _tmp12_;
	static GQuark _tmp12__label0 = 0;
	static GQuark _tmp12__label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp11_ = name;
	_tmp12_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
	if (_tmp12_ == ((0 != _tmp12__label0) ? _tmp12__label0 : (_tmp12__label0 = g_quark_from_static_string ("projects"))))
	switch (0) {
		default:
		{
			return;
		}
	} else if (_tmp12_ == ((0 != _tmp12__label1) ? _tmp12__label1 : (_tmp12__label1 = g_quark_from_static_string ("project"))))
	switch (0) {
		default:
		{
			Project project = {0};
			memset (&project, 0, sizeof (Project));
			{
				gint i;
				i = 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						const char* _tmp6_;
						GQuark _tmp7_;
						static GQuark _tmp7__label0 = 0;
						static GQuark _tmp7__label1 = 0;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < attr_names_length1)) {
							break;
						}
						_tmp6_ = attr_names[i];
						_tmp7_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
						if (_tmp7_ == ((0 != _tmp7__label0) ? _tmp7__label0 : (_tmp7__label0 = g_quark_from_static_string ("directory"))))
						switch (0) {
							default:
							{
								GFile* _tmp1_;
								project.directory = (_tmp1_ = g_file_new_for_uri (attr_values[i]), _g_object_unref0 (project.directory), _tmp1_);
								break;
							}
						} else if (_tmp7_ == ((0 != _tmp7__label1) ? _tmp7__label1 : (_tmp7__label1 = g_quark_from_static_string ("main_file"))))
						switch (0) {
							default:
							{
								GFile* _tmp2_;
								project.main_file = (_tmp2_ = g_file_new_for_uri (attr_values[i]), _g_object_unref0 (project.main_file), _tmp2_);
								break;
							}
						} else
						switch (0) {
							default:
							{
								char* _tmp3_;
								char* _tmp4_;
								GError* _tmp5_;
								_inner_error_ = (_tmp5_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL), "\"", NULL)), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
								{
									if (_inner_error_->domain == G_MARKUP_ERROR) {
										g_propagate_error (error, _inner_error_);
										project_destroy (&project);
										return;
									} else {
										project_destroy (&project);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->projects, &project);
			project_destroy (&project);
			break;
		}
	} else
	switch (0) {
		default:
		{
			char* _tmp8_;
			char* _tmp9_;
			GError* _tmp10_;
			_inner_error_ = (_tmp10_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp9_ = g_strconcat (_tmp8_ = g_strconcat ("unknown element \"", name, NULL), "\"", NULL)), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
			{
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* app_settings_get_file_projects (AppSettings* self) {
	GFile* result = NULL;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	path = g_build_filename (g_get_user_data_dir (), "latexila", "projects.xml", NULL, NULL);
	result = g_file_new_for_path (path);
	_g_free0 (path);
	return result;
}


void app_settings_save_projects (AppSettings* self) {
	GFile* file;
	char* content;
	char* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->projects_modified) {
		return;
	}
	file = app_settings_get_file_projects (self);
	if (gee_collection_get_size ((GeeCollection*) self->priv->projects) == 0) {
		utils_delete_file (file);
		_g_object_unref0 (file);
		return;
	}
	content = g_strdup ("<projects>\n");
	{
		GeeIterator* _project_it;
		_project_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->projects);
		while (TRUE) {
			Project* _tmp0_;
			Project _tmp1_ = {0};
			Project _tmp2_;
			Project project;
			char* _tmp3_;
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			if (!gee_iterator_next (_project_it)) {
				break;
			}
			project = (_tmp2_ = (project_copy (_tmp0_ = (Project*) gee_iterator_get (_project_it), &_tmp1_), _tmp1_), _project_free0 (_tmp0_), _tmp2_);
			content = (_tmp6_ = g_strconcat (content, _tmp5_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp3_ = g_file_get_uri (project.directory), _tmp4_ = g_file_get_uri (project.main_file)), NULL), _g_free0 (content), _tmp6_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	content = (_tmp7_ = g_strconcat (content, "</projects>\n", NULL), _g_free0 (content), _tmp7_);
	{
		GFile* parent;
		gboolean _tmp8_ = FALSE;
		parent = g_file_get_parent (file);
		if (parent != NULL) {
			_tmp8_ = !g_file_query_exists (parent, NULL);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch24_g_error;
			}
		}
		g_file_replace_contents (file, content, strlen (content), NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch24_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to save projects: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_object_unref0 (file);
}


static gboolean app_settings_projects_conflict (AppSettings* self, GFile* dir1, GFile* dir2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir1 != NULL, FALSE);
	g_return_val_if_fail (dir2 != NULL, FALSE);
	if (g_file_has_prefix (dir1, dir2)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_file_has_prefix (dir2, dir1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_file_equal (dir1, dir2);
	}
	result = _tmp0_;
	return result;
}


const char* app_settings_get_system_font (AppSettings* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_system_font;
	return result;
}


static void app_settings_set_system_font (AppSettings* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_system_font = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_system_font), _tmp0_);
	g_object_notify ((GObject *) self, "system-font");
}


void app_settings_get_build_tool_view_dvi (AppSettings* self, BuildTool* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_build_tool_view_dvi;
	return;
}


static void app_settings_set_build_tool_view_dvi (AppSettings* self, BuildTool* value) {
	BuildTool _tmp0_ = {0};
	BuildTool _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_build_tool_view_dvi = (_tmp1_ = (build_tool_copy (value, &_tmp0_), _tmp0_), build_tool_destroy (&self->priv->_build_tool_view_dvi), _tmp1_);
	g_object_notify ((GObject *) self, "build-tool-view-dvi");
}


void app_settings_get_build_tool_view_pdf (AppSettings* self, BuildTool* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_build_tool_view_pdf;
	return;
}


static void app_settings_set_build_tool_view_pdf (AppSettings* self, BuildTool* value) {
	BuildTool _tmp0_ = {0};
	BuildTool _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_build_tool_view_pdf = (_tmp1_ = (build_tool_copy (value, &_tmp0_), _tmp0_), build_tool_destroy (&self->priv->_build_tool_view_pdf), _tmp1_);
	g_object_notify ((GObject *) self, "build-tool-view-pdf");
}


void app_settings_get_build_tool_view_ps (AppSettings* self, BuildTool* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_build_tool_view_ps;
	return;
}


static void app_settings_set_build_tool_view_ps (AppSettings* self, BuildTool* value) {
	BuildTool _tmp0_ = {0};
	BuildTool _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_build_tool_view_ps = (_tmp1_ = (build_tool_copy (value, &_tmp0_), _tmp0_), build_tool_destroy (&self->priv->_build_tool_view_ps), _tmp1_);
	g_object_notify ((GObject *) self, "build-tool-view-ps");
}


static void app_settings_class_init (AppSettingsClass * klass) {
	app_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AppSettingsPrivate));
	G_OBJECT_CLASS (klass)->get_property = app_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = app_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = app_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_SYSTEM_FONT, g_param_spec_string ("system-font", "system-font", "system-font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_BUILD_TOOL_VIEW_DVI, g_param_spec_boxed ("build-tool-view-dvi", "build-tool-view-dvi", "build-tool-view-dvi", TYPE_BUILD_TOOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_BUILD_TOOL_VIEW_PDF, g_param_spec_boxed ("build-tool-view-pdf", "build-tool-view-pdf", "build-tool-view-pdf", TYPE_BUILD_TOOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_BUILD_TOOL_VIEW_PS, g_param_spec_boxed ("build-tool-view-ps", "build-tool-view-ps", "build-tool-view-ps", TYPE_BUILD_TOOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void app_settings_instance_init (AppSettings * self) {
	self->priv = APP_SETTINGS_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
	self->priv->mus_modified = FALSE;
	self->priv->current_tool_is_view_dvi = FALSE;
	self->priv->current_tool_is_view_pdf = FALSE;
	self->priv->current_tool_is_view_ps = FALSE;
	self->priv->build_tools_modified = FALSE;
	self->priv->projects_modified = FALSE;
}


static void app_settings_finalize (GObject* obj) {
	AppSettings * self;
	self = APP_SETTINGS (obj);
	_g_object_unref0 (self->priv->editor);
	_g_object_unref0 (self->priv->desktop_interface);
	_g_free0 (self->priv->_system_font);
	_g_object_unref0 (self->priv->most_used_symbols);
	_g_object_unref0 (self->priv->build_tools);
	build_tool_destroy (&self->priv->current_build_tool);
	build_job_destroy (&self->priv->current_build_job);
	build_tool_destroy (&self->priv->_build_tool_view_dvi);
	build_tool_destroy (&self->priv->_build_tool_view_pdf);
	build_tool_destroy (&self->priv->_build_tool_view_ps);
	_g_object_unref0 (self->priv->projects);
	G_OBJECT_CLASS (app_settings_parent_class)->finalize (obj);
}


GType app_settings_get_type (void) {
	static volatile gsize app_settings_type_id__volatile = 0;
	if (g_once_init_enter (&app_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AppSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppSettings), 0, (GInstanceInitFunc) app_settings_instance_init, NULL };
		GType app_settings_type_id;
		app_settings_type_id = g_type_register_static (G_TYPE_SETTINGS, "AppSettings", &g_define_type_info, 0);
		g_once_init_leave (&app_settings_type_id__volatile, app_settings_type_id);
	}
	return app_settings_type_id__volatile;
}


static void app_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AppSettings * self;
	BuildTool boxed0;
	BuildTool boxed1;
	BuildTool boxed2;
	self = APP_SETTINGS (object);
	switch (property_id) {
		case APP_SETTINGS_SYSTEM_FONT:
		g_value_set_string (value, app_settings_get_system_font (self));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_DVI:
		app_settings_get_build_tool_view_dvi (self, &boxed0);
		g_value_set_boxed (value, &boxed0);
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PDF:
		app_settings_get_build_tool_view_pdf (self, &boxed1);
		g_value_set_boxed (value, &boxed1);
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PS:
		app_settings_get_build_tool_view_ps (self, &boxed2);
		g_value_set_boxed (value, &boxed2);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void app_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AppSettings * self;
	self = APP_SETTINGS (object);
	switch (property_id) {
		case APP_SETTINGS_SYSTEM_FONT:
		app_settings_set_system_font (self, g_value_get_string (value));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_DVI:
		app_settings_set_build_tool_view_dvi (self, g_value_get_boxed (value));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PDF:
		app_settings_set_build_tool_view_pdf (self, g_value_get_boxed (value));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PS:
		app_settings_set_build_tool_view_ps (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




