/* document_tab.c generated by valac 0.12.1, the Vala compiler
 * generated from document_tab.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentTabPrivate DocumentTabPrivate;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block20Data Block20Data;

struct _DocumentTab {
	GtkVBox parent_instance;
	DocumentTabPrivate * priv;
};

struct _DocumentTabClass {
	GtkVBoxClass parent_class;
};

struct _DocumentTabPrivate {
	DocumentView* _view;
	Document* _document;
	gboolean ask_if_externally_modified;
	GtkHBox* _label;
	GtkLabel* _label_text;
	GtkLabel* _label_mark;
	guint auto_save_timeout;
	guint _auto_save_interval;
	gboolean _auto_save;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block20Data {
	int _ref_count_;
	DocumentTab * self;
	TabInfoBar* infobar;
};


static gpointer document_tab_parent_class = NULL;

GType document_tab_get_type (void) G_GNUC_CONST;
GType document_view_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
#define DOCUMENT_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_TAB, DocumentTabPrivate))
enum  {
	DOCUMENT_TAB_DUMMY_PROPERTY,
	DOCUMENT_TAB_VIEW,
	DOCUMENT_TAB_DOCUMENT,
	DOCUMENT_TAB_LABEL,
	DOCUMENT_TAB_LABEL_TEXT,
	DOCUMENT_TAB_AUTO_SAVE_INTERVAL,
	DOCUMENT_TAB_AUTO_SAVE
};
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
Document* document_new (void);
Document* document_construct (GType object_type);
static void document_tab_set_document (DocumentTab* self, Document* value);
Document* document_tab_get_document (DocumentTab* self);
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void document_tab_set_view (DocumentTab* self, DocumentView* value);
static void document_tab_initialize (DocumentTab* self);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location);
void document_load (Document* self, GFile* location);
DocumentTab* document_tab_new_with_view (DocumentView* view);
DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view);
static void _lambda16_ (DocumentTab* self);
static void document_tab_update_label_text (DocumentTab* self);
static void document_tab_update_label_tooltip (DocumentTab* self);
static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _document_tab_update_label_tooltip_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _document_tab_update_label_text_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda17_ (GtkTextBuffer* s, DocumentTab* self);
gboolean document_get_modified (Document* self);
static void __lambda17__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean document_tab_view_focused_in (DocumentTab* self);
static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _lambda19_ (DocumentTab* self);
static void __lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
void document_tab_set_auto_save (DocumentTab* self, gboolean value);
void document_tab_set_auto_save_interval (DocumentTab* self, guint value);
static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self);
static void _lambda20_ (DocumentTab* self);
static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
TabInfoBar* tab_info_bar_new (const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
TabInfoBar* tab_info_bar_construct (GType object_type, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
gchar* utils_str_middle_truncate (const gchar* str, guint max_length);
gchar* document_get_short_name_for_display (Document* self);
static void document_tab_set_label_text (DocumentTab* self, const gchar* value);
GFile* document_get_location (Document* self);
gchar* document_get_uri_for_display (Document* self);
gint document_get_project_id (Document* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* projects_get (Projects* self, gint id);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gchar* document_tab_get_name (DocumentTab* self);
const gchar* document_tab_get_label_text (DocumentTab* self);
gchar* document_tab_get_menu_tip (DocumentTab* self);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const gchar* text, const gchar* stock_id, gint response_id);
static void _lambda18_ (gint response_id, Block20Data* _data20_);
static void __lambda18__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void document_tab_install_auto_save_timeout (DocumentTab* self);
gboolean document_tab_get_auto_save (DocumentTab* self);
guint document_tab_get_auto_save_interval (DocumentTab* self);
static gboolean document_tab_on_auto_save (DocumentTab* self);
static gboolean _document_tab_on_auto_save_gsource_func (gpointer self);
gboolean document_get_readonly (Document* self);
static void document_tab_remove_auto_save_timeout (DocumentTab* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GtkHBox* document_tab_get_label (DocumentTab* self);
static void document_tab_finalize (GObject* obj);
static void _vala_document_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DocumentTab* document_tab_construct (GType object_type) {
	DocumentTab * self = NULL;
	Document* _tmp0_ = NULL;
	Document* _tmp1_;
	DocumentView* _tmp2_ = NULL;
	DocumentView* _tmp3_;
	self = (DocumentTab*) g_object_new (object_type, NULL);
	_tmp0_ = document_new ();
	_tmp1_ = _tmp0_;
	document_tab_set_document (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = document_view_new (self->priv->_document);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	document_tab_set_view (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	document_tab_initialize (self);
	return self;
}


DocumentTab* document_tab_new (void) {
	return document_tab_construct (TYPE_DOCUMENT_TAB);
}


DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location) {
	DocumentTab * self = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	self = (DocumentTab*) document_tab_construct (object_type);
	document_load (self->priv->_document, location);
	return self;
}


DocumentTab* document_tab_new_from_location (GFile* location) {
	return document_tab_construct_from_location (TYPE_DOCUMENT_TAB, location);
}


DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view) {
	DocumentTab * self = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (DocumentTab*) g_object_new (object_type, NULL);
	document_tab_set_view (self, view);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) view);
	document_tab_set_document (self, DOCUMENT (_tmp0_));
	document_tab_initialize (self);
	return self;
}


DocumentTab* document_tab_new_with_view (DocumentView* view) {
	return document_tab_construct_with_view (TYPE_DOCUMENT_TAB, view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda16_ (DocumentTab* self) {
	document_tab_update_label_text (self);
	document_tab_update_label_tooltip (self);
}


static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda16_ (self);
}


static void _document_tab_update_label_tooltip_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_tab_update_label_tooltip (self);
}


static void _document_tab_update_label_text_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_tab_update_label_text (self);
}


static void _lambda17_ (GtkTextBuffer* s, DocumentTab* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	_tmp1_ = document_get_modified (self->priv->_document);
	if (_tmp1_) {
		_tmp0_ = "*";
	} else {
		_tmp0_ = "";
	}
	gtk_label_set_label (self->priv->_label_mark, _tmp0_);
}


static void __lambda17__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda17_ (_sender, self);
}


static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = document_tab_view_focused_in (self);
	return result;
}


static void _lambda19_ (DocumentTab* self) {
	g_signal_emit_by_name (self, "close-document");
}


static void __lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda19_ (self);
}


static void _lambda20_ (DocumentTab* self) {
	if (self->priv->auto_save_timeout <= 0) {
		document_tab_install_auto_save_timeout_if_needed (self);
	}
}


static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda20_ (self);
}


static void document_tab_initialize (DocumentTab* self) {
	gboolean reparent;
	DocumentTab* _tmp0_;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkScrolledWindow* sw;
	GtkButton* _tmp2_ = NULL;
	GtkButton* close_button;
	const gchar* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkImage* _tmp5_;
	GtkHBox* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* settings;
	gboolean _tmp8_;
	guint tmp = 0U;
	g_return_if_fail (self != NULL);
	reparent = self->priv->_document->tab != NULL;
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (self->priv->_document->tab);
	self->priv->_document->tab = _tmp0_;
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::location", (GCallback) __lambda16__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::project-id", (GCallback) _document_tab_update_label_tooltip_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::unsaved-document-n", (GCallback) _document_tab_update_label_text_g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self->priv->_document, "modified-changed", (GCallback) __lambda17__gtk_text_buffer_modified_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_view, "focus-in-event", (GCallback) _document_tab_view_focused_in_gtk_widget_focus_in_event, self, 0);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	sw = g_object_ref_sink (_tmp1_);
	gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	if (reparent) {
		gtk_widget_reparent ((GtkWidget*) self->priv->_view, (GtkWidget*) sw);
	} else {
		gtk_container_add ((GtkContainer*) sw, (GtkWidget*) self->priv->_view);
	}
	gtk_widget_show_all ((GtkWidget*) sw);
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	document_tab_update_label_text (self);
	_tmp2_ = (GtkButton*) gtk_button_new ();
	close_button = g_object_ref_sink (_tmp2_);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click (close_button, FALSE);
	gtk_widget_set_name ((GtkWidget*) close_button, "my-close-button");
	_tmp3_ = _ ("Close document");
	gtk_widget_set_tooltip_text ((GtkWidget*) close_button, _tmp3_);
	_tmp4_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda19__gtk_button_clicked, self, 0);
	_tmp6_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->_label);
	self->priv->_label = g_object_ref_sink (_tmp6_);
	gtk_box_pack_start ((GtkBox*) self->priv->_label, (GtkWidget*) self->priv->_label_mark, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_label, (GtkWidget*) self->priv->_label_text, TRUE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_label, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	document_tab_update_label_tooltip (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->_label);
	_tmp7_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp7_;
	_tmp8_ = g_settings_get_boolean (settings, "auto-save");
	document_tab_set_auto_save (self, _tmp8_);
	g_settings_get (settings, "auto-save-interval", "u", &tmp);
	document_tab_set_auto_save_interval (self, tmp);
	document_tab_install_auto_save_timeout_if_needed (self);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::location", (GCallback) __lambda20__g_object_notify, self, 0);
	_g_object_unref0 (settings);
	_g_object_unref0 (close_button);
	_g_object_unref0 (sw);
}


TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type) {
	TabInfoBar* result = NULL;
	TabInfoBar* _tmp0_ = NULL;
	TabInfoBar* infobar;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (primary_msg != NULL, NULL);
	g_return_val_if_fail (secondary_msg != NULL, NULL);
	_tmp0_ = tab_info_bar_new (primary_msg, secondary_msg, msg_type);
	infobar = g_object_ref_sink (_tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) infobar, FALSE, FALSE, (guint) 0);
	result = infobar;
	return result;
}


static void document_tab_update_label_text (DocumentTab* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = document_get_short_name_for_display (self->priv->_document);
	_tmp1_ = _tmp0_;
	_tmp2_ = utils_str_middle_truncate (_tmp1_, (guint) 42);
	_tmp3_ = _tmp2_;
	document_tab_set_label_text (self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


static void document_tab_update_label_tooltip (DocumentTab* self) {
	GFile* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = document_get_location (self->priv->_document);
	if (_tmp0_ == NULL) {
		gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, "");
	} else {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gint _tmp3_;
		_tmp1_ = document_get_uri_for_display (self->priv->_document);
		_tmp2_ = _tmp1_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, _tmp2_);
		_g_free0 (_tmp2_);
		_tmp3_ = document_get_project_id (self->priv->_document);
		if (_tmp3_ != (-1)) {
			Projects* _tmp4_ = NULL;
			Projects* _tmp5_;
			gint _tmp6_;
			Project* _tmp7_ = NULL;
			Project* _tmp8_;
			Project* project;
			GFile* _tmp9_ = NULL;
			gboolean _tmp10_;
			_tmp4_ = projects_get_default ();
			_tmp5_ = _tmp4_;
			_tmp6_ = document_get_project_id (self->priv->_document);
			_tmp7_ = projects_get (_tmp5_, _tmp6_);
			_tmp8_ = _tmp7_;
			_projects_unref0 (_tmp5_);
			project = _tmp8_;
			if (project == NULL) {
				_project_free0 (project);
				return;
			}
			_tmp9_ = document_get_location (self->priv->_document);
			_tmp10_ = g_file_equal ((*project).main_file, _tmp9_);
			if (_tmp10_) {
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp11_ = gtk_widget_get_tooltip_markup ((GtkWidget*) self->priv->_label);
				_tmp12_ = _ ("Main File");
				_tmp13_ = g_strconcat ("\n<b>", _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp14_, "</b>", NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp11_, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
			} else {
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp19_ = gtk_widget_get_tooltip_markup ((GtkWidget*) self->priv->_label);
				_tmp20_ = _ ("Main File:");
				_tmp21_ = g_strconcat ("\n<b>", _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strconcat (_tmp22_, "</b> ", NULL);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_file_get_parse_name ((*project).main_file);
				_tmp26_ = _tmp25_;
				_tmp27_ = utils_replace_home_dir_with_tilde (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp19_, _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
			}
			_project_free0 (project);
		}
	}
}


gchar* document_tab_get_name (DocumentTab* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_label_get_label (self->priv->_label_mark);
	_tmp1_ = document_tab_get_label_text (self);
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	result = _tmp2_;
	return result;
}


gchar* document_tab_get_menu_tip (DocumentTab* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Activate '%s'");
	_tmp1_ = document_get_uri_for_display (self->priv->_document);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->self);
		_g_object_unref0 (_data20_->infobar);
		g_slice_free (Block20Data, _data20_);
	}
}


static void _lambda18_ (gint response_id, Block20Data* _data20_) {
	DocumentTab * self;
	self = _data20_->self;
	if (response_id == GTK_RESPONSE_OK) {
		GFile* _tmp0_ = NULL;
		_tmp0_ = document_get_location (self->priv->_document);
		document_load (self->priv->_document, _tmp0_);
		self->priv->ask_if_externally_modified = FALSE;
	}
	gtk_object_destroy ((GtkObject*) _data20_->infobar);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->_view);
}


static void __lambda18__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda18_ (response_id, self);
}


static gboolean document_tab_view_focused_in (DocumentTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->ask_if_externally_modified) {
		result = FALSE;
		return result;
	}
	_tmp0_ = document_is_local (self->priv->_document);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = document_is_externally_modified (self->priv->_document);
	if (_tmp1_) {
		Block20Data* _data20_;
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* primary_msg;
		gchar* secondary_msg = NULL;
		gboolean _tmp8_;
		TabInfoBar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		_data20_->self = g_object_ref (self);
		self->priv->ask_if_externally_modified = TRUE;
		_tmp2_ = _ ("The file %s changed on disk.");
		_tmp3_ = document_get_location (self->priv->_document);
		_tmp4_ = g_file_get_parse_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf (_tmp2_, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		primary_msg = _tmp7_;
		_tmp8_ = document_get_modified (self->priv->_document);
		if (_tmp8_) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = _ ("Do you want to drop your changes and reload the file?");
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (secondary_msg);
			secondary_msg = _tmp10_;
		} else {
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = _ ("Do you want to reload the file?");
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (secondary_msg);
			secondary_msg = _tmp12_;
		}
		_tmp13_ = document_tab_add_message (self, primary_msg, secondary_msg, GTK_MESSAGE_WARNING);
		_data20_->infobar = _tmp13_;
		_tmp14_ = _ ("Reload");
		tab_info_bar_add_stock_button_with_text (_data20_->infobar, _tmp14_, GTK_STOCK_REFRESH, (gint) GTK_RESPONSE_OK);
		gtk_info_bar_add_button ((GtkInfoBar*) _data20_->infobar, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
		g_signal_connect_data ((GtkInfoBar*) _data20_->infobar, "response", (GCallback) __lambda18__gtk_info_bar_response, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
		_g_free0 (secondary_msg);
		_g_free0 (primary_msg);
		block20_data_unref (_data20_);
		_data20_ = NULL;
	}
	result = FALSE;
	return result;
}


static gboolean _document_tab_on_auto_save_gsource_func (gpointer self) {
	gboolean result;
	result = document_tab_on_auto_save (self);
	return result;
}


static void document_tab_install_auto_save_timeout (DocumentTab* self) {
	gboolean _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->auto_save_timeout <= 0);
	_tmp0_ = document_tab_get_auto_save (self);
	g_return_if_fail (_tmp0_);
	_tmp1_ = document_tab_get_auto_save_interval (self);
	g_return_if_fail (_tmp1_ > 0);
	_tmp2_ = document_tab_get_auto_save_interval (self);
	_tmp3_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp2_ * 60, _document_tab_on_auto_save_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->auto_save_timeout = _tmp3_;
}


static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->auto_save_timeout <= 0, FALSE);
	_tmp2_ = document_tab_get_auto_save (self);
	if (_tmp2_) {
		GFile* _tmp3_ = NULL;
		_tmp3_ = document_get_location (self->priv->_document);
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		_tmp4_ = document_get_readonly (self->priv->_document);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_tab_install_auto_save_timeout (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void document_tab_remove_auto_save_timeout (DocumentTab* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->auto_save_timeout > 0);
	g_source_remove (self->priv->auto_save_timeout);
	self->priv->auto_save_timeout = (guint) 0;
}


static gboolean document_tab_on_auto_save (DocumentTab* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_get_location (self->priv->_document);
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = document_get_readonly (self->priv->_document);
	g_return_val_if_fail (!_tmp1_, FALSE);
	g_return_val_if_fail (self->priv->auto_save_timeout > 0, FALSE);
	_tmp2_ = document_tab_get_auto_save (self);
	g_return_val_if_fail (_tmp2_, FALSE);
	_tmp3_ = document_tab_get_auto_save_interval (self);
	g_return_val_if_fail (_tmp3_ > 0, FALSE);
	_tmp4_ = document_get_modified (self->priv->_document);
	if (_tmp4_) {
		document_save (self->priv->_document, TRUE, FALSE);
	}
	result = TRUE;
	return result;
}


DocumentView* document_tab_get_view (DocumentTab* self) {
	DocumentView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_view;
	return result;
}


static void document_tab_set_view (DocumentTab* self, DocumentView* value) {
	DocumentView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = _tmp0_;
	g_object_notify ((GObject *) self, "view");
}


Document* document_tab_get_document (DocumentTab* self) {
	Document* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_document;
	return result;
}


static void document_tab_set_document (DocumentTab* self, Document* value) {
	Document* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_document);
	self->priv->_document = _tmp0_;
	g_object_notify ((GObject *) self, "document");
}


GtkHBox* document_tab_get_label (DocumentTab* self) {
	GtkHBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label;
	return result;
}


const gchar* document_tab_get_label_text (DocumentTab* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_label_get_label (self->priv->_label_text);
	result = _tmp0_;
	return result;
}


static void document_tab_set_label_text (DocumentTab* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	gtk_label_set_label (self->priv->_label_text, value);
	g_object_notify ((GObject *) self, "label-text");
}


guint document_tab_get_auto_save_interval (DocumentTab* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_auto_save_interval;
	return result;
}


void document_tab_set_auto_save_interval (DocumentTab* self, guint value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (value > 0);
	if (self->priv->_auto_save_interval == value) {
		return;
	}
	self->priv->_auto_save_interval = value;
	if (!self->priv->_auto_save) {
		return;
	}
	if (self->priv->auto_save_timeout > 0) {
		GFile* _tmp0_ = NULL;
		gboolean _tmp1_;
		_tmp0_ = document_get_location (self->priv->_document);
		g_return_if_fail (_tmp0_ != NULL);
		_tmp1_ = document_get_readonly (self->priv->_document);
		g_return_if_fail (!_tmp1_);
		document_tab_remove_auto_save_timeout (self);
		document_tab_install_auto_save_timeout (self);
	}
	g_object_notify ((GObject *) self, "auto-save-interval");
}


gboolean document_tab_get_auto_save (DocumentTab* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_auto_save;
	return result;
}


void document_tab_set_auto_save (DocumentTab* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value == self->priv->_auto_save) {
		return;
	}
	self->priv->_auto_save = value;
	if (self->priv->_auto_save) {
		_tmp2_ = self->priv->auto_save_timeout <= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* _tmp3_ = NULL;
		_tmp3_ = document_get_location (self->priv->_document);
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		_tmp4_ = document_get_readonly (self->priv->_document);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_tab_install_auto_save_timeout (self);
		return;
	}
	if (!self->priv->_auto_save) {
		_tmp5_ = self->priv->auto_save_timeout > 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		document_tab_remove_auto_save_timeout (self);
		return;
	}
	if (!self->priv->_auto_save) {
		_tmp8_ = self->priv->auto_save_timeout <= 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		GFile* _tmp9_ = NULL;
		_tmp9_ = document_get_location (self->priv->_document);
		_tmp7_ = _tmp9_ == NULL;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp10_;
		_tmp10_ = document_get_readonly (self->priv->_document);
		_tmp6_ = _tmp10_;
	}
	g_return_if_fail (_tmp6_);
	g_object_notify ((GObject *) self, "auto-save");
}


static void document_tab_class_init (DocumentTabClass * klass) {
	document_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentTabPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_tab_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_tab_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_tab_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_VIEW, g_param_spec_object ("view", "view", "view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT, g_param_spec_object ("document", "document", "document", TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_LABEL, g_param_spec_object ("label", "label", "label", GTK_TYPE_HBOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_LABEL_TEXT, g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_INTERVAL, g_param_spec_uint ("auto-save-interval", "auto-save-interval", "auto-save-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE, g_param_spec_boolean ("auto-save", "auto-save", "auto-save", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("close_document", TYPE_DOCUMENT_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_tab_instance_init (DocumentTab * self) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	self->priv = DOCUMENT_TAB_GET_PRIVATE (self);
	self->priv->ask_if_externally_modified = FALSE;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	self->priv->_label_text = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	self->priv->_label_mark = g_object_ref_sink (_tmp1_);
}


static void document_tab_finalize (GObject* obj) {
	DocumentTab * self;
	self = DOCUMENT_TAB (obj);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_document);
	_g_object_unref0 (self->priv->_label);
	_g_object_unref0 (self->priv->_label_text);
	_g_object_unref0 (self->priv->_label_mark);
	G_OBJECT_CLASS (document_tab_parent_class)->finalize (obj);
}


GType document_tab_get_type (void) {
	static volatile gsize document_tab_type_id__volatile = 0;
	if (g_once_init_enter (&document_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentTab), 0, (GInstanceInitFunc) document_tab_instance_init, NULL };
		GType document_tab_type_id;
		document_tab_type_id = g_type_register_static (GTK_TYPE_VBOX, "DocumentTab", &g_define_type_info, 0);
		g_once_init_leave (&document_tab_type_id__volatile, document_tab_type_id);
	}
	return document_tab_type_id__volatile;
}


static void _vala_document_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DocumentTab * self;
	self = DOCUMENT_TAB (object);
	switch (property_id) {
		case DOCUMENT_TAB_VIEW:
		g_value_set_object (value, document_tab_get_view (self));
		break;
		case DOCUMENT_TAB_DOCUMENT:
		g_value_set_object (value, document_tab_get_document (self));
		break;
		case DOCUMENT_TAB_LABEL:
		g_value_set_object (value, document_tab_get_label (self));
		break;
		case DOCUMENT_TAB_LABEL_TEXT:
		g_value_set_string (value, document_tab_get_label_text (self));
		break;
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL:
		g_value_set_uint (value, document_tab_get_auto_save_interval (self));
		break;
		case DOCUMENT_TAB_AUTO_SAVE:
		g_value_set_boolean (value, document_tab_get_auto_save (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DocumentTab * self;
	self = DOCUMENT_TAB (object);
	switch (property_id) {
		case DOCUMENT_TAB_VIEW:
		document_tab_set_view (self, g_value_get_object (value));
		break;
		case DOCUMENT_TAB_DOCUMENT:
		document_tab_set_document (self, g_value_get_object (value));
		break;
		case DOCUMENT_TAB_LABEL_TEXT:
		document_tab_set_label_text (self, g_value_get_string (value));
		break;
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL:
		document_tab_set_auto_save_interval (self, g_value_get_uint (value));
		break;
		case DOCUMENT_TAB_AUTO_SAVE:
		document_tab_set_auto_save (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



