/* structure.c generated by valac 0.12.0, the Vala compiler
 * generated from structure.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define TYPE_STRUCT_ITEM (struct_item_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;
typedef struct _StructurePrivate StructurePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define STRUCTURE_TYPE_MIN_LEVEL_COLUMN (structure_min_level_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block13Data Block13Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _Block15Data Block15Data;

typedef enum  {
	STRUCT_ITEM_PIXBUF,
	STRUCT_ITEM_TYPE,
	STRUCT_ITEM_TEXT,
	STRUCT_ITEM_TOOLTIP,
	STRUCT_ITEM_MARK,
	STRUCT_ITEM_N_COLUMNS
} StructItem;

typedef enum  {
	STRUCT_TYPE_PART = 0,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_N_TYPES
} StructType;

struct _Structure {
	GtkVBox parent_instance;
	StructurePrivate * priv;
};

struct _StructureClass {
	GtkVBoxClass parent_class;
};

struct _StructurePrivate {
	MainWindow* _main_window;
	GSettings* _settings;
	GtkTreeStore* _tree_store;
	GtkTreeModelFilter* _tree_filter;
	GtkTreeView* _tree_view;
	gboolean* _visible_types;
	gint _visible_types_length1;
	gint __visible_types_size_;
};

typedef enum  {
	STRUCTURE_MIN_LEVEL_COLUMN_PIXBUF,
	STRUCTURE_MIN_LEVEL_COLUMN_NAME,
	STRUCTURE_MIN_LEVEL_COLUMN_TYPE,
	STRUCTURE_MIN_LEVEL_COLUMN_N_COLUMNS
} StructureMinLevelColumn;

struct _Block13Data {
	int _ref_count_;
	Structure * self;
	GtkToggleButton* button;
	StructType* types;
	gint types_length1;
};

struct _Block14Data {
	int _ref_count_;
	Structure * self;
	GtkListStore* list_store;
	GtkComboBox* combo_box;
};

struct _Block15Data {
	int _ref_count_;
	Structure * self;
	DocumentStructure* doc_struct;
};


static gpointer structure_parent_class = NULL;

GType struct_item_get_type (void) G_GNUC_CONST;
GType struct_type_get_type (void) G_GNUC_CONST;
GType structure_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STRUCTURE, StructurePrivate))
enum  {
	STRUCTURE_DUMMY_PROPERTY
};
static GType structure_min_level_column_get_type (void) G_GNUC_UNUSED;
Structure* structure_new (MainWindow* main_window);
Structure* structure_construct (GType object_type, MainWindow* main_window);
static void structure_init_visible_types (Structure* self);
static void structure_init_toolbar (Structure* self);
static void structure_init_choose_min_level (Structure* self);
static void structure_init_tree_view (Structure* self);
void structure_connect_parsing (Structure* self);
static void _structure_connect_parsing_gtk_widget_show (GtkWidget* _sender, gpointer self);
void structure_disconnect_parsing (Structure* self);
static void _structure_disconnect_parsing_gtk_widget_hide (GtkWidget* _sender, gpointer self);
void structure_save_state (Structure* self);
GtkButton* utils_get_toolbar_button (const gchar* stock_id);
static void _lambda5_ (Structure* self);
GType document_get_type (void) G_GNUC_CONST;
static void structure_parse_document (Structure* self, Document* doc);
Document* main_window_get_active_document (MainWindow* self);
static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda7_ (Structure* self);
static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda8_ (Structure* self);
static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkToggleButton* structure_create_show_hide_button (Structure* self, StructType* types, int types_length1, const gchar* tooltip);
static StructType* _vala_array_dup3 (StructType* self, int length);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
GtkToggleButton* utils_get_toolbar_toggle_button (const gchar* stock_id);
gchar* structure_get_icon_from_type (StructType type);
static void _lambda9_ (Block13Data* _data13_);
static void __lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static gboolean _lambda11_ (GtkTreeModel* model, GtkTreeIter* iter, Structure* self);
static gboolean __lambda11__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static gboolean structure_on_row_selection (Structure* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected);
static gboolean _structure_on_row_selection_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
gchar* structure_get_type_name (StructType type);
static void _lambda10_ (Block14Data* _data14_);
static void __lambda10__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
static void structure_clear (Structure* self);
GType document_structure_get_type (void) G_GNUC_CONST;
DocumentStructure* document_get_structure (Document* self);
void document_structure_parse (DocumentStructure* self);
static void structure_populate (Structure* self, DocumentStructure* doc_struct);
static void structure_populate_active_document (Structure* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
static gboolean _lambda6_ (Block15Data* _data15_);
void document_structure_populate_tree_store (DocumentStructure* self, GtkTreeStore* store);
static gboolean __lambda6__gsource_func (gpointer self);
static void _structure_populate_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void structure_finalize (GObject* obj);


GType struct_item_get_type (void) {
	static volatile gsize struct_item_type_id__volatile = 0;
	if (g_once_init_enter (&struct_item_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_ITEM_PIXBUF, "STRUCT_ITEM_PIXBUF", "pixbuf"}, {STRUCT_ITEM_TYPE, "STRUCT_ITEM_TYPE", "type"}, {STRUCT_ITEM_TEXT, "STRUCT_ITEM_TEXT", "text"}, {STRUCT_ITEM_TOOLTIP, "STRUCT_ITEM_TOOLTIP", "tooltip"}, {STRUCT_ITEM_MARK, "STRUCT_ITEM_MARK", "mark"}, {STRUCT_ITEM_N_COLUMNS, "STRUCT_ITEM_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_item_type_id;
		struct_item_type_id = g_enum_register_static ("StructItem", values);
		g_once_init_leave (&struct_item_type_id__volatile, struct_item_type_id);
	}
	return struct_item_type_id__volatile;
}


GType struct_type_get_type (void) {
	static volatile gsize struct_type_type_id__volatile = 0;
	if (g_once_init_enter (&struct_type_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_TYPE_PART, "STRUCT_TYPE_PART", "part"}, {STRUCT_TYPE_CHAPTER, "STRUCT_TYPE_CHAPTER", "chapter"}, {STRUCT_TYPE_SECTION, "STRUCT_TYPE_SECTION", "section"}, {STRUCT_TYPE_SUBSECTION, "STRUCT_TYPE_SUBSECTION", "subsection"}, {STRUCT_TYPE_SUBSUBSECTION, "STRUCT_TYPE_SUBSUBSECTION", "subsubsection"}, {STRUCT_TYPE_PARAGRAPH, "STRUCT_TYPE_PARAGRAPH", "paragraph"}, {STRUCT_TYPE_SUBPARAGRAPH, "STRUCT_TYPE_SUBPARAGRAPH", "subparagraph"}, {STRUCT_TYPE_LABEL, "STRUCT_TYPE_LABEL", "label"}, {STRUCT_TYPE_INCLUDE, "STRUCT_TYPE_INCLUDE", "include"}, {STRUCT_TYPE_TABLE, "STRUCT_TYPE_TABLE", "table"}, {STRUCT_TYPE_FIGURE, "STRUCT_TYPE_FIGURE", "figure"}, {STRUCT_TYPE_TODO, "STRUCT_TYPE_TODO", "todo"}, {STRUCT_TYPE_FIXME, "STRUCT_TYPE_FIXME", "fixme"}, {STRUCT_TYPE_N_TYPES, "STRUCT_TYPE_N_TYPES", "n-types"}, {0, NULL, NULL}};
		GType struct_type_type_id;
		struct_type_type_id = g_enum_register_static ("StructType", values);
		g_once_init_leave (&struct_type_type_id__volatile, struct_type_type_id);
	}
	return struct_type_type_id__volatile;
}


static GType structure_min_level_column_get_type (void) {
	static volatile gsize structure_min_level_column_type_id__volatile = 0;
	if (g_once_init_enter (&structure_min_level_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCTURE_MIN_LEVEL_COLUMN_PIXBUF, "STRUCTURE_MIN_LEVEL_COLUMN_PIXBUF", "pixbuf"}, {STRUCTURE_MIN_LEVEL_COLUMN_NAME, "STRUCTURE_MIN_LEVEL_COLUMN_NAME", "name"}, {STRUCTURE_MIN_LEVEL_COLUMN_TYPE, "STRUCTURE_MIN_LEVEL_COLUMN_TYPE", "type"}, {STRUCTURE_MIN_LEVEL_COLUMN_N_COLUMNS, "STRUCTURE_MIN_LEVEL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType structure_min_level_column_type_id;
		structure_min_level_column_type_id = g_enum_register_static ("StructureMinLevelColumn", values);
		g_once_init_leave (&structure_min_level_column_type_id__volatile, structure_min_level_column_type_id);
	}
	return structure_min_level_column_type_id__volatile;
}


static void _structure_connect_parsing_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	structure_connect_parsing (self);
}


static void _structure_disconnect_parsing_gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	structure_disconnect_parsing (self);
}


Structure* structure_construct (GType object_type, MainWindow* main_window) {
	Structure * self = NULL;
	GSettings* _tmp0_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (Structure*) g_object_new (object_type, "spacing", 3, NULL);
	self->priv->_main_window = main_window;
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	structure_init_visible_types (self);
	structure_init_toolbar (self);
	structure_init_choose_min_level (self);
	structure_init_tree_view (self);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _structure_connect_parsing_gtk_widget_show, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _structure_disconnect_parsing_gtk_widget_hide, self, 0);
	return self;
}


Structure* structure_new (MainWindow* main_window) {
	return structure_construct (TYPE_STRUCTURE, main_window);
}


static void structure_init_visible_types (Structure* self) {
	gboolean* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gboolean, STRUCT_TYPE_N_TYPES);
	self->priv->_visible_types = (g_free (self->priv->_visible_types), NULL);
	self->priv->_visible_types = _tmp0_;
	self->priv->_visible_types_length1 = STRUCT_TYPE_N_TYPES;
	self->priv->__visible_types_size_ = STRUCT_TYPE_N_TYPES;
	_tmp1_ = g_settings_get_boolean (self->priv->_settings, "structure-show-label");
	self->priv->_visible_types[STRUCT_TYPE_LABEL] = _tmp1_;
	_tmp2_ = g_settings_get_boolean (self->priv->_settings, "structure-show-include");
	self->priv->_visible_types[STRUCT_TYPE_INCLUDE] = _tmp2_;
	_tmp3_ = g_settings_get_boolean (self->priv->_settings, "structure-show-table");
	self->priv->_visible_types[STRUCT_TYPE_TABLE] = _tmp3_;
	_tmp4_ = g_settings_get_boolean (self->priv->_settings, "structure-show-figure");
	self->priv->_visible_types[STRUCT_TYPE_FIGURE] = _tmp4_;
	_tmp5_ = g_settings_get_boolean (self->priv->_settings, "structure-show-todo");
	self->priv->_visible_types[STRUCT_TYPE_TODO] = _tmp5_;
	_tmp6_ = g_settings_get_boolean (self->priv->_settings, "structure-show-fixme");
	self->priv->_visible_types[STRUCT_TYPE_FIXME] = _tmp6_;
}


void structure_save_state (Structure* self) {
	gint min_level;
	g_return_if_fail (self != NULL);
	g_settings_set_boolean (self->priv->_settings, "structure-show-label", self->priv->_visible_types[STRUCT_TYPE_LABEL]);
	g_settings_set_boolean (self->priv->_settings, "structure-show-include", self->priv->_visible_types[STRUCT_TYPE_INCLUDE]);
	g_settings_set_boolean (self->priv->_settings, "structure-show-table", self->priv->_visible_types[STRUCT_TYPE_TABLE]);
	g_settings_set_boolean (self->priv->_settings, "structure-show-figure", self->priv->_visible_types[STRUCT_TYPE_FIGURE]);
	g_settings_set_boolean (self->priv->_settings, "structure-show-todo", self->priv->_visible_types[STRUCT_TYPE_TODO]);
	g_settings_set_boolean (self->priv->_settings, "structure-show-fixme", self->priv->_visible_types[STRUCT_TYPE_FIXME]);
	min_level = (gint) STRUCT_TYPE_PART;
	{
		gint level;
		level = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					level++;
				}
				_tmp0_ = FALSE;
				if (!(level <= STRUCT_TYPE_SUBPARAGRAPH)) {
					break;
				}
				if (!self->priv->_visible_types[level]) {
					break;
				}
				min_level = level;
			}
		}
	}
	g_settings_set_int (self->priv->_settings, "structure-min-level", min_level);
}


static void _lambda5_ (Structure* self) {
	Document* _tmp0_ = NULL;
	_tmp0_ = main_window_get_active_document (self->priv->_main_window);
	structure_parse_document (self, _tmp0_);
}


static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda5_ (self);
}


static void _lambda7_ (Structure* self) {
	gtk_tree_view_expand_all (self->priv->_tree_view);
}


static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda7_ (self);
}


static void _lambda8_ (Structure* self) {
	gtk_tree_view_collapse_all (self->priv->_tree_view);
}


static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda8_ (self);
}


static void structure_init_toolbar (Structure* self) {
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* hbox;
	GtkButton* _tmp1_ = NULL;
	GtkButton* refresh_button;
	GtkButton* _tmp2_ = NULL;
	GtkButton* expand_button;
	const gchar* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* collapse_button;
	const gchar* _tmp5_ = NULL;
	StructType* _tmp6_ = NULL;
	StructType* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_ = NULL;
	GtkToggleButton* _tmp9_ = NULL;
	GtkToggleButton* _tmp10_;
	GtkToggleButton* toggle_button;
	StructType* _tmp11_ = NULL;
	StructType* _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_ = NULL;
	GtkToggleButton* _tmp14_ = NULL;
	StructType* _tmp15_ = NULL;
	StructType* _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_ = NULL;
	GtkToggleButton* _tmp18_ = NULL;
	StructType* _tmp19_ = NULL;
	StructType* _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_ = NULL;
	GtkToggleButton* _tmp22_ = NULL;
	StructType* _tmp23_ = NULL;
	StructType* _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_ = NULL;
	GtkToggleButton* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (TRUE, 0);
	hbox = g_object_ref_sink (_tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp1_ = utils_get_toolbar_button (GTK_STOCK_REFRESH);
	refresh_button = _tmp1_;
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) refresh_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (refresh_button, "clicked", (GCallback) __lambda5__gtk_button_clicked, self, 0);
	_tmp2_ = utils_get_toolbar_button (GTK_STOCK_ZOOM_IN);
	expand_button = _tmp2_;
	_tmp3_ = _ ("Expand All");
	gtk_widget_set_tooltip_text ((GtkWidget*) expand_button, _tmp3_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) expand_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (expand_button, "clicked", (GCallback) __lambda7__gtk_button_clicked, self, 0);
	_tmp4_ = utils_get_toolbar_button (GTK_STOCK_ZOOM_OUT);
	collapse_button = _tmp4_;
	_tmp5_ = _ ("Collapse All");
	gtk_widget_set_tooltip_text ((GtkWidget*) collapse_button, _tmp5_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) collapse_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (collapse_button, "clicked", (GCallback) __lambda8__gtk_button_clicked, self, 0);
	_tmp6_ = g_new0 (StructType, 1);
	_tmp6_[0] = STRUCT_TYPE_LABEL;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	_tmp8_ = _ ("Show labels");
	_tmp9_ = structure_create_show_hide_button (self, _tmp7_, 1, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	toggle_button = _tmp10_;
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp11_ = g_new0 (StructType, 1);
	_tmp11_[0] = STRUCT_TYPE_INCLUDE;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	_tmp13_ = _ ("Show files included");
	_tmp14_ = structure_create_show_hide_button (self, _tmp12_, 1, _tmp13_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp14_;
	_tmp12_ = (g_free (_tmp12_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp15_ = g_new0 (StructType, 1);
	_tmp15_[0] = STRUCT_TYPE_TABLE;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	_tmp17_ = _ ("Show tables");
	_tmp18_ = structure_create_show_hide_button (self, _tmp16_, 1, _tmp17_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp18_;
	_tmp16_ = (g_free (_tmp16_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp19_ = g_new0 (StructType, 1);
	_tmp19_[0] = STRUCT_TYPE_FIGURE;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	_tmp21_ = _ ("Show figures");
	_tmp22_ = structure_create_show_hide_button (self, _tmp20_, 1, _tmp21_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp22_;
	_tmp20_ = (g_free (_tmp20_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp23_ = g_new0 (StructType, 2);
	_tmp23_[0] = STRUCT_TYPE_TODO;
	_tmp23_[1] = STRUCT_TYPE_FIXME;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 2;
	_tmp25_ = _ ("Show TODOs and FIXMEs");
	_tmp26_ = structure_create_show_hide_button (self, _tmp24_, 2, _tmp25_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp26_;
	_tmp24_ = (g_free (_tmp24_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (toggle_button);
	_g_object_unref0 (collapse_button);
	_g_object_unref0 (expand_button);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (hbox);
}


static StructType* _vala_array_dup3 (StructType* self, int length) {
	return g_memdup (self, length * sizeof (StructType));
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->button);
		_data13_->types = (g_free (_data13_->types), NULL);
		g_slice_free (Block13Data, _data13_);
	}
}


static void _lambda9_ (Block13Data* _data13_) {
	Structure * self;
	self = _data13_->self;
	{
		StructType* type_collection;
		int type_collection_length1;
		int type_it;
		type_collection = _data13_->types;
		type_collection_length1 = _data13_->types_length1;
		for (type_it = 0; type_it < _data13_->types_length1; type_it = type_it + 1) {
			StructType type;
			type = type_collection[type_it];
			{
				gboolean _tmp0_;
				_tmp0_ = gtk_toggle_button_get_active (_data13_->button);
				self->priv->_visible_types[type] = _tmp0_;
			}
		}
	}
	if (self->priv->_tree_filter != NULL) {
		gtk_tree_model_filter_refilter (self->priv->_tree_filter);
	}
}


static void __lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda9_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkToggleButton* structure_create_show_hide_button (Structure* self, StructType* types, int types_length1, const gchar* tooltip) {
	GtkToggleButton* result = NULL;
	Block13Data* _data13_;
	StructType* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GtkToggleButton* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_;
	GtkToggleButton* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->types = (_tmp0_ = types, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup3 (_tmp0_, types_length1));
	_data13_->types_length1 = types_length1;
	g_return_val_if_fail (_data13_->types_length1 > 0, NULL);
	_tmp1_ = structure_get_icon_from_type (_data13_->types[0]);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_get_toolbar_toggle_button (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_data13_->button = _tmp4_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _data13_->button, tooltip);
	gtk_toggle_button_set_active (_data13_->button, self->priv->_visible_types[_data13_->types[0]]);
	g_signal_connect_data (_data13_->button, "toggled", (GCallback) __lambda9__gtk_toggle_button_toggled, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp5_ = _g_object_ref0 (_data13_->button);
	result = _tmp5_;
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}


static gboolean _lambda11_ (GtkTreeModel* model, GtkTreeIter* iter, Structure* self) {
	gboolean result = FALSE;
	StructType type = 0;
	g_return_val_if_fail (model != NULL, FALSE);
	gtk_tree_model_get (model, iter, STRUCT_ITEM_TYPE, &type, -1, -1);
	result = self->priv->_visible_types[type];
	return result;
}


static gboolean __lambda11__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = _lambda11_ (model, iter, self);
	return result;
}


static gboolean _structure_on_row_selection_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = structure_on_row_selection (self, selection, model, path, path_currently_selected);
	return result;
}


static void structure_init_tree_view (Structure* self) {
	GtkTreeStore* _tmp0_ = NULL;
	GtkTreeModelFilter* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* _tmp4_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp5_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkTreeSelection* _tmp6_ = NULL;
	GtkTreeSelection* _tmp7_;
	GtkTreeSelection* select;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* sw;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_store_new ((gint) STRUCT_ITEM_N_COLUMNS, G_TYPE_STRING, TYPE_STRUCT_TYPE, G_TYPE_STRING, G_TYPE_STRING, GTK_TYPE_TEXT_MARK);
	_g_object_unref0 (self->priv->_tree_store);
	self->priv->_tree_store = _tmp0_;
	_tmp1_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) self->priv->_tree_store, NULL);
	_g_object_unref0 (self->priv->_tree_filter);
	self->priv->_tree_filter = _tmp1_;
	gtk_tree_model_filter_set_visible_func (self->priv->_tree_filter, __lambda11__gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->_tree_filter);
	_g_object_unref0 (self->priv->_tree_view);
	self->priv->_tree_view = g_object_ref_sink (_tmp2_);
	gtk_tree_view_set_headers_visible (self->priv->_tree_view, FALSE);
	_tmp3_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp3_);
	gtk_tree_view_append_column (self->priv->_tree_view, column);
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp4_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", STRUCT_ITEM_PIXBUF, NULL, NULL);
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp5_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", STRUCT_ITEM_TEXT, NULL, NULL);
	gtk_tree_view_set_tooltip_column (self->priv->_tree_view, (gint) STRUCT_ITEM_TOOLTIP);
	_tmp6_ = gtk_tree_view_get_selection (self->priv->_tree_view);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	select = _tmp7_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	gtk_tree_selection_set_select_function (select, _structure_on_row_selection_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	_tmp8_ = utils_add_scrollbar ((GtkWidget*) self->priv->_tree_view);
	sw = _tmp8_;
	gtk_box_pack_start ((GtkBox*) self, sw, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->combo_box);
		_g_object_unref0 (_data14_->list_store);
		g_slice_free (Block14Data, _data14_);
	}
}


static void _lambda10_ (Block14Data* _data14_) {
	Structure * self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	StructType selected_type = 0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	self = _data14_->self;
	_tmp1_ = gtk_combo_box_get_active_iter (_data14_->combo_box, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL (_data14_->list_store));
	model = _tmp2_;
	gtk_tree_model_get (model, &iter, STRUCTURE_MIN_LEVEL_COLUMN_TYPE, &selected_type, -1, -1);
	{
		gint type;
		type = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					type++;
				}
				_tmp3_ = FALSE;
				if (!(type <= STRUCT_TYPE_SUBPARAGRAPH)) {
					break;
				}
				self->priv->_visible_types[type] = type <= selected_type;
			}
		}
	}
	if (self->priv->_tree_filter != NULL) {
		gtk_tree_model_filter_refilter (self->priv->_tree_filter);
	}
	if (self->priv->_tree_view != NULL) {
		gtk_tree_view_expand_all (self->priv->_tree_view);
	}
	_g_object_unref0 (model);
}


static void __lambda10__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda10_ (self);
}


static void structure_init_choose_min_level (Structure* self) {
	Block14Data* _data14_;
	GtkListStore* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkCellRendererPixbuf* _tmp3_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* text_renderer;
	gint _tmp11_;
	gint min_level;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = gtk_list_store_new ((gint) STRUCTURE_MIN_LEVEL_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, TYPE_STRUCT_TYPE);
	_data14_->list_store = _tmp0_;
	_tmp1_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _data14_->list_store);
	_data14_->combo_box = g_object_ref_sink (_tmp1_);
	_tmp2_ = _ ("Minimum level");
	gtk_widget_set_tooltip_text ((GtkWidget*) _data14_->combo_box, _tmp2_);
	_tmp3_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data14_->combo_box, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _data14_->combo_box, (GtkCellRenderer*) pixbuf_renderer, "stock-id", STRUCTURE_MIN_LEVEL_COLUMN_PIXBUF, NULL, NULL);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp4_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data14_->combo_box, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _data14_->combo_box, (GtkCellRenderer*) text_renderer, "text", STRUCTURE_MIN_LEVEL_COLUMN_NAME, NULL, NULL);
	{
		gint type;
		type = (gint) STRUCT_TYPE_PART;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp6_ = {0};
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				if (!_tmp5_) {
					type++;
				}
				_tmp5_ = FALSE;
				if (!(type <= STRUCT_TYPE_SUBPARAGRAPH)) {
					break;
				}
				gtk_list_store_append (_data14_->list_store, &_tmp6_);
				iter = _tmp6_;
				_tmp7_ = structure_get_icon_from_type ((StructType) type);
				_tmp8_ = _tmp7_;
				_tmp9_ = structure_get_type_name ((StructType) type);
				_tmp10_ = _tmp9_;
				gtk_list_store_set (_data14_->list_store, &iter, STRUCTURE_MIN_LEVEL_COLUMN_PIXBUF, _tmp8_, STRUCTURE_MIN_LEVEL_COLUMN_NAME, _tmp10_, STRUCTURE_MIN_LEVEL_COLUMN_TYPE, type, -1, -1);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp8_);
			}
		}
	}
	g_signal_connect_data (_data14_->combo_box, "changed", (GCallback) __lambda10__gtk_combo_box_changed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp11_ = g_settings_get_int (self->priv->_settings, "structure-min-level");
	min_level = _tmp11_;
	_tmp12_ = CLAMP (min_level, (gint) STRUCT_TYPE_PART, (gint) STRUCT_TYPE_SUBPARAGRAPH);
	min_level = _tmp12_;
	gtk_combo_box_set_active (_data14_->combo_box, min_level);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _data14_->combo_box, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


static gboolean structure_on_row_selection (Structure* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected) {
	gboolean result = FALSE;
	GtkTreeIter tree_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextMark* mark = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* doc;
	Document* _tmp4_ = NULL;
	GtkTextIter text_iter = {0};
	GtkTextIter _tmp5_ = {0};
	DocumentView* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = gtk_tree_model_get_iter (model, &_tmp0_, path);
	tree_iter = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	gtk_tree_model_get (model, &tree_iter, STRUCT_ITEM_MARK, &mark, -1, -1);
	_tmp2_ = gtk_text_mark_get_buffer (mark);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = main_window_get_active_document (self->priv->_main_window);
	g_return_val_if_fail (doc == GTK_TEXT_BUFFER (_tmp4_), FALSE);
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp5_, mark);
	text_iter = _tmp5_;
	gtk_text_buffer_place_cursor (doc, &text_iter);
	_tmp6_ = main_window_get_active_view (self->priv->_main_window);
	document_view_scroll_to_cursor (_tmp6_, 0.25);
	result = TRUE;
	_g_object_unref0 (doc);
	_g_object_unref0 (mark);
	return result;
}


static void structure_parse_document (Structure* self, Document* doc) {
	DocumentStructure* _tmp0_ = NULL;
	DocumentStructure* doc_struct;
	g_return_if_fail (self != NULL);
	structure_clear (self);
	if (doc == NULL) {
		return;
	}
	_tmp0_ = document_get_structure (doc);
	doc_struct = _tmp0_;
	document_structure_parse (doc_struct);
	structure_populate (self, doc_struct);
	_g_object_unref0 (doc_struct);
}


static void structure_populate_active_document (Structure* self) {
	Document* _tmp0_ = NULL;
	Document* _tmp1_;
	Document* doc;
	DocumentStructure* _tmp2_ = NULL;
	DocumentStructure* _tmp3_;
	g_return_if_fail (self != NULL);
	structure_clear (self);
	_tmp0_ = main_window_get_active_document (self->priv->_main_window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	if (doc == NULL) {
		_g_object_unref0 (doc);
		return;
	}
	_tmp2_ = document_get_structure (doc);
	_tmp3_ = _tmp2_;
	structure_populate (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (doc);
}


static void structure_clear (Structure* self) {
	g_return_if_fail (self != NULL);
	gtk_tree_store_clear (self->priv->_tree_store);
	gtk_tree_view_columns_autosize (self->priv->_tree_view);
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->self);
		_g_object_unref0 (_data15_->doc_struct);
		g_slice_free (Block15Data, _data15_);
	}
}


static gboolean _lambda6_ (Block15Data* _data15_) {
	Structure * self;
	gboolean result = FALSE;
	self = _data15_->self;
	document_structure_populate_tree_store (_data15_->doc_struct, self->priv->_tree_store);
	gtk_tree_view_expand_all (self->priv->_tree_view);
	result = FALSE;
	return result;
}


static gboolean __lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda6_ (self);
	return result;
}


static void structure_populate (Structure* self, DocumentStructure* doc_struct) {
	Block15Data* _data15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc_struct != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_data15_->doc_struct = _g_object_ref0 (doc_struct);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda6__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


static void _structure_populate_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	structure_populate_active_document (self);
}


void structure_connect_parsing (Structure* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GObject*) self->priv->_main_window, "notify::active-document", (GCallback) _structure_populate_active_document_g_object_notify, self, 0);
	structure_populate_active_document (self);
}


void structure_disconnect_parsing (Structure* self) {
	guint _tmp0_;
	GQuark _tmp1_;
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->_main_window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _structure_populate_active_document_g_object_notify, self);
}


gchar* structure_get_icon_from_type (StructType type) {
	gchar* result = NULL;
	switch (type) {
		case STRUCT_TYPE_PART:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("tree_part");
			result = _tmp0_;
			return result;
		}
		case STRUCT_TYPE_CHAPTER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("tree_chapter");
			result = _tmp1_;
			return result;
		}
		case STRUCT_TYPE_SECTION:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("tree_section");
			result = _tmp2_;
			return result;
		}
		case STRUCT_TYPE_SUBSECTION:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("tree_subsection");
			result = _tmp3_;
			return result;
		}
		case STRUCT_TYPE_SUBSUBSECTION:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("tree_subsubsection");
			result = _tmp4_;
			return result;
		}
		case STRUCT_TYPE_PARAGRAPH:
		case STRUCT_TYPE_SUBPARAGRAPH:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("tree_paragraph");
			result = _tmp5_;
			return result;
		}
		case STRUCT_TYPE_LABEL:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("tree_label");
			result = _tmp6_;
			return result;
		}
		case STRUCT_TYPE_TODO:
		case STRUCT_TYPE_FIXME:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("tree_todo");
			result = _tmp7_;
			return result;
		}
		case STRUCT_TYPE_TABLE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("table");
			result = _tmp8_;
			return result;
		}
		case STRUCT_TYPE_FIGURE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("image");
			result = _tmp9_;
			return result;
		}
		case STRUCT_TYPE_INCLUDE:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("tree_include");
			result = _tmp10_;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


gchar* structure_get_type_name (StructType type) {
	gchar* result = NULL;
	switch (type) {
		case STRUCT_TYPE_PART:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = _ ("Part");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case STRUCT_TYPE_CHAPTER:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = _ ("Chapter");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case STRUCT_TYPE_SECTION:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = _ ("Section");
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case STRUCT_TYPE_SUBSECTION:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("Sub-section");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case STRUCT_TYPE_SUBSUBSECTION:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("Sub-sub-section");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case STRUCT_TYPE_PARAGRAPH:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("Paragraph");
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case STRUCT_TYPE_SUBPARAGRAPH:
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = _ ("Sub-paragraph");
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
		case STRUCT_TYPE_LABEL:
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp14_ = _ ("Label");
			_tmp15_ = g_strdup (_tmp14_);
			result = _tmp15_;
			return result;
		}
		case STRUCT_TYPE_TODO:
		{
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("TODO");
			result = _tmp16_;
			return result;
		}
		case STRUCT_TYPE_FIXME:
		{
			gchar* _tmp17_;
			_tmp17_ = g_strdup ("FIXME");
			result = _tmp17_;
			return result;
		}
		case STRUCT_TYPE_TABLE:
		{
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp18_ = _ ("Table");
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			return result;
		}
		case STRUCT_TYPE_FIGURE:
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp20_ = _ ("Figure");
			_tmp21_ = g_strdup (_tmp20_);
			result = _tmp21_;
			return result;
		}
		case STRUCT_TYPE_INCLUDE:
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			_tmp22_ = _ ("File included");
			_tmp23_ = g_strdup (_tmp22_);
			result = _tmp23_;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


static void structure_class_init (StructureClass * klass) {
	structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StructurePrivate));
	G_OBJECT_CLASS (klass)->finalize = structure_finalize;
}


static void structure_instance_init (Structure * self) {
	self->priv = STRUCTURE_GET_PRIVATE (self);
}


static void structure_finalize (GObject* obj) {
	Structure * self;
	self = STRUCTURE (obj);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_tree_store);
	_g_object_unref0 (self->priv->_tree_filter);
	_g_object_unref0 (self->priv->_tree_view);
	self->priv->_visible_types = (g_free (self->priv->_visible_types), NULL);
	G_OBJECT_CLASS (structure_parent_class)->finalize (obj);
}


GType structure_get_type (void) {
	static volatile gsize structure_type_id__volatile = 0;
	if (g_once_init_enter (&structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Structure), 0, (GInstanceInitFunc) structure_instance_init, NULL };
		GType structure_type_id;
		structure_type_id = g_type_register_static (GTK_TYPE_VBOX, "Structure", &g_define_type_info, 0);
		g_once_init_leave (&structure_type_id__volatile, structure_type_id);
	}
	return structure_type_id__volatile;
}



