/* main.c generated by valac 0.12.1, the Vala compiler
 * generated from main.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <unique/unique.h>
#include <gio/gio.h>

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _unique_message_data_free0(var) ((var == NULL) ? NULL : (var = (unique_message_data_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;


extern gboolean option_version;
gboolean option_version = FALSE;
extern gboolean option_new_document;
gboolean option_new_document = FALSE;
extern gboolean option_new_window;
gboolean option_new_window = FALSE;
extern gchar** remaining_args;
gchar** remaining_args = NULL;
extern gint application_NEW_WINDOW;

gint _vala_main (gchar** args, int args_length1);
static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
void application_open_documents (Application* self, gchar** uris);
void application_create_document (Application* self);
UniqueResponse application_message (Application* self, UniqueApp* sender, gint command, UniqueMessageData* data, guint time);
static UniqueResponse _application_message_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[5] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &option_version, "Show the application's version", NULL}, {"new-document", 'n', 0, G_OPTION_ARG_NONE, &option_new_document, "Create new document", NULL}, {"new-window", '\0', 0, G_OPTION_ARG_NONE, &option_new_window, "Create a new top-level window in an existing instance of LaTeXila", NULL}, {"", '\0', 0, G_OPTION_ARG_FILENAME_ARRAY, &remaining_args, NULL, "[FILE...]"}, {NULL}};

static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static UniqueResponse _application_message_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self) {
	UniqueResponse result;
	result = application_message (self, _sender, command, message_data, time_);
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* context;
	GOptionGroup* _tmp3_ = NULL;
	gboolean command_open;
	UniqueMessageData* _tmp5_ = NULL;
	UniqueMessageData* data;
	UniqueApp* _tmp11_ = NULL;
	UniqueApp* app;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	if (g_strcmp0 (SCHEMA_DIR, "/usr/local/share") != 0) {
		_tmp0_ = g_strcmp0 (SCHEMA_DIR, "/usr/share") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_setenv ("XDG_DATA_DIRS", "/usr/local/share:/usr/share:" SCHEMA_DIR, TRUE);
	}
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp1_ = _ ("- Integrated LaTeX Environment for GNOME");
	_tmp2_ = g_option_context_new (_tmp1_);
	context = _tmp2_;
	g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
	_tmp3_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (context, _tmp3_);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch60_g_option_error;
		}
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	goto __finally60;
	__catch60_g_option_error:
	{
		GError * e;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_tmp4_ = _ ("Run '%s --help' to see a full list of available command line options.\n");
		fprintf (stderr, _tmp4_, args[0]);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally60:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (option_version) {
		fprintf (stdout, "%s %s\n", APP_NAME, APP_VERSION);
		result = 0;
		_g_option_context_free0 (context);
		return result;
	}
	command_open = FALSE;
	_tmp5_ = unique_message_data_new ();
	data = _tmp5_;
	if (_vala_array_length (remaining_args) != 0) {
		gchar** _tmp6_ = NULL;
		gchar** uris;
		gint uris_length1;
		gint _uris_size_;
		command_open = TRUE;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		uris = _tmp6_;
		uris_length1 = 0;
		_uris_size_ = 0;
		{
			gchar** arg_collection;
			int arg_collection_length1;
			int arg_it;
			arg_collection = remaining_args;
			arg_collection_length1 = _vala_array_length (remaining_args);
			for (arg_it = 0; arg_it < _vala_array_length (remaining_args); arg_it = arg_it + 1) {
				gchar* _tmp7_;
				gchar* arg;
				_tmp7_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp7_;
				{
					GFile* _tmp8_ = NULL;
					GFile* _tmp9_;
					gchar* _tmp10_ = NULL;
					_tmp8_ = g_file_new_for_path (arg);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_file_get_uri (_tmp9_);
					_vala_array_add19 (&uris, &uris_length1, &_uris_size_, _tmp10_);
					_g_object_unref0 (_tmp9_);
					_g_free0 (arg);
				}
			}
		}
		unique_message_data_set_uris (data, uris);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = unique_app_new ("org.gnome.latexila", NULL);
	app = _tmp11_;
	unique_app_add_command (app, "new_window", application_NEW_WINDOW);
	g_object_get (app, "is-running", &_tmp12_, NULL);
	if (_tmp12_) {
		gboolean ok;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		ok = TRUE;
		if (option_new_window) {
			UniqueResponse _tmp13_;
			UniqueResponse resp;
			_tmp13_ = unique_app_send_message (app, application_NEW_WINDOW, NULL);
			resp = _tmp13_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (ok) {
			_tmp14_ = command_open;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			UniqueResponse _tmp15_;
			UniqueResponse resp;
			_tmp15_ = unique_app_send_message (app, (gint) UNIQUE_OPEN, data);
			resp = _tmp15_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (ok) {
			_tmp16_ = option_new_document;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			UniqueResponse _tmp17_;
			UniqueResponse resp;
			_tmp17_ = unique_app_send_message (app, (gint) UNIQUE_NEW, NULL);
			resp = _tmp17_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (!option_new_window) {
			_tmp19_ = !command_open;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = !option_new_document;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			UniqueResponse _tmp20_;
			UniqueResponse resp;
			_tmp20_ = unique_app_send_message (app, (gint) UNIQUE_ACTIVATE, NULL);
			resp = _tmp20_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (!ok) {
			g_error ("main.vala:134: Error: communication with first instance of LaTeXila fa" \
"iled\n");
		}
		result = 0;
		_g_object_unref0 (app);
		_unique_message_data_free0 (data);
		_g_option_context_free0 (context);
		return result;
	} else {
		Application* _tmp21_ = NULL;
		Application* latexila;
		GSettings* _tmp22_ = NULL;
		GSettings* editor_settings;
		gboolean _tmp23_;
		_tmp21_ = application_get_default ();
		latexila = _tmp21_;
		_tmp22_ = g_settings_new ("org.gnome.latexila.preferences.editor");
		editor_settings = _tmp22_;
		_tmp23_ = g_settings_get_boolean (editor_settings, "reopen-files");
		if (_tmp23_) {
			GSettings* _tmp24_ = NULL;
			GSettings* window_settings;
			gchar** _tmp25_;
			gchar** _tmp26_ = NULL;
			gchar** uris;
			gint uris_length1;
			gint _uris_size_;
			_tmp24_ = g_settings_new ("org.gnome.latexila.state.window");
			window_settings = _tmp24_;
			_tmp26_ = _tmp25_ = g_settings_get_strv (window_settings, "documents");
			uris = _tmp26_;
			uris_length1 = _vala_array_length (_tmp25_);
			_uris_size_ = _vala_array_length (_tmp25_);
			application_open_documents (latexila, uris);
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (window_settings);
		}
		if (command_open) {
			gchar** _tmp27_ = NULL;
			gchar** _tmp28_;
			gint _tmp28__length1;
			_tmp27_ = unique_message_data_get_uris (data);
			_tmp28_ = _tmp27_;
			_tmp28__length1 = -1;
			application_open_documents (latexila, _tmp28_);
			_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
		}
		if (option_new_document) {
			application_create_document (latexila);
		}
		g_signal_connect_object (app, "message-received", (GCallback) _application_message_unique_app_message_received, latexila, 0);
		gtk_main ();
		_g_object_unref0 (editor_settings);
		_g_object_unref0 (latexila);
	}
	result = 0;
	_g_object_unref0 (app);
	_unique_message_data_free0 (data);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



