/* structure.c generated by valac 0.12.1, the Vala compiler
 * generated from structure.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_STRUCT_TYPE (struct_type_get_type ())

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;
typedef struct _StructurePrivate StructurePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block13Data Block13Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_NB_COMMON_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_NB_TYPES
} StructType;

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

struct _Structure {
	GtkVBox parent_instance;
	StructurePrivate * priv;
};

struct _StructureClass {
	GtkVBoxClass parent_class;
};

struct _StructurePrivate {
	MainWindow* _main_window;
	GtkMenu* _popup_menu;
	GtkAction* _action_all_menu;
	GtkAction* _action_cut;
	GtkAction* _action_copy;
	GtkAction* _action_delete;
	GtkAction* _action_select;
	GtkAction* _action_comment;
	GtkAction* _action_shift_left;
	GtkAction* _action_shift_right;
	GtkToggleButton** _simple_list_buttons;
	gint _simple_list_buttons_length1;
	gint __simple_list_buttons_size_;
	GtkVPaned* _vpaned;
	GtkTreeView* _tree_view;
	DocumentStructure* _document_structure;
	StructureModel* _model;
	GtkTreeView* _list_view;
	GtkWidget* _list_view_sw;
	GtkListStore* _list_store;
	StructType* _current_list_types;
	gint _current_list_types_length1;
	gint __current_list_types_size_;
	gboolean _list_is_hidden;
	gboolean _first_select;
};

struct _Block13Data {
	int _ref_count_;
	Structure * self;
	StructType main_type;
	GtkToggleButton* button;
	StructType* types;
	gint types_length1;
};

typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()

static gpointer structure_parent_class = NULL;
static gchar** structure__icons;
static gint structure__icons_length1;
static gchar** structure__icons = NULL;
static gint structure__icons_length1 = 0;
static gint _structure__icons_size_ = 0;
static gchar** structure__names;
static gint structure__names_length1;
static gchar** structure__names = NULL;
static gint structure__names_length1 = 0;
static gint _structure__names_size_ = 0;
static gchar** structure__action_names;
static gint structure__action_names_length1;
static gchar** structure__action_names = NULL;
static gint structure__action_names_length1 = 0;
static gint _structure__action_names_size_ = 0;

GType struct_type_get_type (void) G_GNUC_CONST;
GType struct_action_get_type (void) G_GNUC_CONST;
GType structure_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
#define STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STRUCTURE, StructurePrivate))
enum  {
	STRUCTURE_DUMMY_PROPERTY
};
Structure* structure_new (MainWindow* main_window, GtkUIManager* ui_manager);
Structure* structure_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
static void structure_init_toolbar (Structure* self);
static void structure_init_vpaned (Structure* self);
static void structure_init_list_view (Structure* self);
static void structure_init_tree_view (Structure* self);
void structure_connect_parsing (Structure* self);
static void _structure_connect_parsing_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _lambda16_ (Structure* self);
void structure_disconnect_parsing (Structure* self);
static void __lambda16__gtk_widget_hide (GtkWidget* _sender, gpointer self);
GtkButton* utils_get_toolbar_button (const gchar* stock_id);
static void _lambda4_ (Structure* self);
GType document_get_type (void) G_GNUC_CONST;
static void structure_show_document (Structure* self, Document* doc, gboolean force_parse);
Document* main_window_get_active_document (MainWindow* self);
static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda7_ (Structure* self);
static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda8_ (Structure* self);
static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkToggleButton* structure_create_simple_list_button (Structure* self, StructType* types, int types_length1, const gchar* tooltip);
static StructType* _vala_array_dup3 (StructType* self, int length);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
GtkToggleButton* utils_get_toolbar_toggle_button (const gchar* stock_id);
gchar* structure_get_icon_from_type (StructType type);
static void _vala_array_add9 (GtkToggleButton*** array, int* length, int* size, GtkToggleButton* value);
static void _lambda9_ (Block13Data* _data13_);
static gboolean _vala_struct_type_array_contains (StructType* stack, int stack_length, StructType needle);
static StructType* _vala_array_dup4 (StructType* self, int length);
static void structure_populate_simple_list (Structure* self);
static void __lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
void structure_model_populate_list (StructureModel* self, GtkListStore* store, StructType type);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void structure_select_simple_list_item (Structure* self, GtkTreeIter* tree_iter);
void structure_save_state (Structure* self);
static GtkTreeView* structure_get_new_tree_view (Structure* self, gint pixbuf_col, gint text_col, gint tooltip_col);
GType struct_list_column_get_type (void) G_GNUC_CONST;
static gboolean _lambda10_ (GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, Structure* self);
static gboolean structure_select_list_row (Structure* self, GtkTreePath* list_path);
static gboolean __lambda10__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void _lambda11_ (GtkTreePath* path, Structure* self);
static void __lambda11__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
GType struct_column_get_type (void) G_GNUC_CONST;
static gboolean _lambda12_ (GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, Structure* self);
static gboolean structure_select_tree_row (Structure* self, GtkTreePath* tree_path);
static gboolean __lambda12__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void _lambda13_ (GtkTreePath* path, Structure* self);
static void __lambda13__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean _lambda14_ (GdkEventButton* event, Structure* self);
static void structure_show_popup_menu (Structure* self, GdkEventButton* event);
static gboolean __lambda14__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda15_ (Structure* self);
static gboolean __lambda15__gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self, StructType list_type, gint num);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
static void structure_set_actions_sensitivity (Structure* self, StructType type);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self, GtkTreeIter* tree_iter);
static void structure_show_active_document (Structure* self);
static void structure_set_model (Structure* self, StructureModel* model);
DocumentStructure* document_get_structure (Document* self);
void document_structure_parse (DocumentStructure* self);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static void _lambda6_ (Structure* self);
static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _structure_show_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean structure_is_section (StructType type);
void structure_do_action (Structure* self, StructAction action_type);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error);
static gchar* structure_get_action_name (StructAction action_type);
gchar* structure_get_type_name (StructType type);
static void structure_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType struct_type_get_type (void) {
	static volatile gsize struct_type_type_id__volatile = 0;
	if (g_once_init_enter (&struct_type_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_TYPE_PART, "STRUCT_TYPE_PART", "part"}, {STRUCT_TYPE_CHAPTER, "STRUCT_TYPE_CHAPTER", "chapter"}, {STRUCT_TYPE_SECTION, "STRUCT_TYPE_SECTION", "section"}, {STRUCT_TYPE_SUBSECTION, "STRUCT_TYPE_SUBSECTION", "subsection"}, {STRUCT_TYPE_SUBSUBSECTION, "STRUCT_TYPE_SUBSUBSECTION", "subsubsection"}, {STRUCT_TYPE_PARAGRAPH, "STRUCT_TYPE_PARAGRAPH", "paragraph"}, {STRUCT_TYPE_SUBPARAGRAPH, "STRUCT_TYPE_SUBPARAGRAPH", "subparagraph"}, {STRUCT_TYPE_LABEL, "STRUCT_TYPE_LABEL", "label"}, {STRUCT_TYPE_INCLUDE, "STRUCT_TYPE_INCLUDE", "include"}, {STRUCT_TYPE_IMAGE, "STRUCT_TYPE_IMAGE", "image"}, {STRUCT_TYPE_TODO, "STRUCT_TYPE_TODO", "todo"}, {STRUCT_TYPE_FIXME, "STRUCT_TYPE_FIXME", "fixme"}, {STRUCT_TYPE_NB_COMMON_TYPES, "STRUCT_TYPE_NB_COMMON_TYPES", "nb-common-types"}, {STRUCT_TYPE_TABLE, "STRUCT_TYPE_TABLE", "table"}, {STRUCT_TYPE_FIGURE, "STRUCT_TYPE_FIGURE", "figure"}, {STRUCT_TYPE_NB_TYPES, "STRUCT_TYPE_NB_TYPES", "nb-types"}, {0, NULL, NULL}};
		GType struct_type_type_id;
		struct_type_type_id = g_enum_register_static ("StructType", values);
		g_once_init_leave (&struct_type_type_id__volatile, struct_type_type_id);
	}
	return struct_type_type_id__volatile;
}


GType struct_action_get_type (void) {
	static volatile gsize struct_action_type_id__volatile = 0;
	if (g_once_init_enter (&struct_action_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_ACTION_CUT, "STRUCT_ACTION_CUT", "cut"}, {STRUCT_ACTION_COPY, "STRUCT_ACTION_COPY", "copy"}, {STRUCT_ACTION_DELETE, "STRUCT_ACTION_DELETE", "delete"}, {STRUCT_ACTION_SELECT, "STRUCT_ACTION_SELECT", "select"}, {STRUCT_ACTION_COMMENT, "STRUCT_ACTION_COMMENT", "comment"}, {STRUCT_ACTION_SHIFT_LEFT, "STRUCT_ACTION_SHIFT_LEFT", "shift-left"}, {STRUCT_ACTION_SHIFT_RIGHT, "STRUCT_ACTION_SHIFT_RIGHT", "shift-right"}, {STRUCT_ACTION_NB_ACTIONS, "STRUCT_ACTION_NB_ACTIONS", "nb-actions"}, {0, NULL, NULL}};
		GType struct_action_type_id;
		struct_action_type_id = g_enum_register_static ("StructAction", values);
		g_once_init_leave (&struct_action_type_id__volatile, struct_action_type_id);
	}
	return struct_action_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _structure_connect_parsing_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	structure_connect_parsing (self);
}


static void _lambda16_ (Structure* self) {
	structure_disconnect_parsing (self);
	gtk_action_set_sensitive (self->priv->_action_all_menu, FALSE);
}


static void __lambda16__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	_lambda16_ (self);
}


Structure* structure_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager) {
	Structure * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkMenu* _tmp1_;
	GtkAction* _tmp2_ = NULL;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_ = NULL;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_ = NULL;
	GtkAction* _tmp7_;
	GtkAction* _tmp8_ = NULL;
	GtkAction* _tmp9_;
	GtkAction* _tmp10_ = NULL;
	GtkAction* _tmp11_;
	GtkAction* _tmp12_ = NULL;
	GtkAction* _tmp13_;
	GtkAction* _tmp14_ = NULL;
	GtkAction* _tmp15_;
	GtkAction* _tmp16_ = NULL;
	GtkAction* _tmp17_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (Structure*) g_object_new (object_type, "spacing", 3, NULL);
	self->priv->_main_window = main_window;
	_tmp0_ = gtk_ui_manager_get_widget (ui_manager, "/StructurePopup");
	_tmp1_ = _g_object_ref0 (GTK_MENU (_tmp0_));
	_g_object_unref0 (self->priv->_popup_menu);
	self->priv->_popup_menu = _tmp1_;
	_tmp2_ = gtk_ui_manager_get_action (ui_manager, "/MainMenu/Structure");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_action_all_menu);
	self->priv->_action_all_menu = _tmp3_;
	_tmp4_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureCut");
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_action_cut);
	self->priv->_action_cut = _tmp5_;
	_tmp6_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureCopy");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->_action_copy);
	self->priv->_action_copy = _tmp7_;
	_tmp8_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureDelete");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->_action_delete);
	self->priv->_action_delete = _tmp9_;
	_tmp10_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureSelect");
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->_action_select);
	self->priv->_action_select = _tmp11_;
	_tmp12_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureComment");
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->_action_comment);
	self->priv->_action_comment = _tmp13_;
	_tmp14_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureShiftLeft");
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->_action_shift_left);
	self->priv->_action_shift_left = _tmp15_;
	_tmp16_ = gtk_ui_manager_get_action (ui_manager, "/StructurePopup/StructureShiftRight");
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->_action_shift_right);
	self->priv->_action_shift_right = _tmp17_;
	structure_init_toolbar (self);
	structure_init_vpaned (self);
	structure_init_list_view (self);
	structure_init_tree_view (self);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_hide (self->priv->_list_view_sw);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _structure_connect_parsing_gtk_widget_show, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) __lambda16__gtk_widget_hide, self, 0);
	return self;
}


Structure* structure_new (MainWindow* main_window, GtkUIManager* ui_manager) {
	return structure_construct (TYPE_STRUCTURE, main_window, ui_manager);
}


static void _lambda4_ (Structure* self) {
	Document* _tmp0_ = NULL;
	_tmp0_ = main_window_get_active_document (self->priv->_main_window);
	structure_show_document (self, _tmp0_, TRUE);
}


static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda4_ (self);
}


static void _lambda7_ (Structure* self) {
	gtk_tree_view_expand_all (self->priv->_tree_view);
}


static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda7_ (self);
}


static void _lambda8_ (Structure* self) {
	gtk_tree_view_collapse_all (self->priv->_tree_view);
}


static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda8_ (self);
}


static void structure_init_toolbar (Structure* self) {
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* hbox;
	GtkButton* _tmp1_ = NULL;
	GtkButton* refresh_button;
	const gchar* _tmp2_ = NULL;
	GtkSeparatorToolItem* _tmp3_ = NULL;
	GtkSeparatorToolItem* sep;
	GtkButton* _tmp4_ = NULL;
	GtkButton* expand_button;
	const gchar* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* collapse_button;
	const gchar* _tmp7_ = NULL;
	GtkSeparatorToolItem* _tmp8_ = NULL;
	StructType* _tmp9_ = NULL;
	StructType* _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_ = NULL;
	GtkToggleButton* _tmp12_ = NULL;
	GtkToggleButton* _tmp13_;
	GtkToggleButton* toggle_button;
	StructType* _tmp14_ = NULL;
	StructType* _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_ = NULL;
	GtkToggleButton* _tmp17_ = NULL;
	StructType* _tmp18_ = NULL;
	StructType* _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_ = NULL;
	GtkToggleButton* _tmp21_ = NULL;
	StructType* _tmp22_ = NULL;
	StructType* _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_ = NULL;
	GtkToggleButton* _tmp25_ = NULL;
	StructType* _tmp26_ = NULL;
	StructType* _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_ = NULL;
	GtkToggleButton* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	hbox = g_object_ref_sink (_tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp1_ = utils_get_toolbar_button (GTK_STOCK_REFRESH);
	refresh_button = _tmp1_;
	_tmp2_ = _ ("Refresh");
	gtk_widget_set_tooltip_text ((GtkWidget*) refresh_button, _tmp2_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) refresh_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (refresh_button, "clicked", (GCallback) __lambda4__gtk_button_clicked, self, 0);
	_tmp3_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	sep = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) sep, FALSE, TRUE, (guint) 0);
	_tmp4_ = utils_get_toolbar_button (GTK_STOCK_ZOOM_IN);
	expand_button = _tmp4_;
	_tmp5_ = _ ("Expand All");
	gtk_widget_set_tooltip_text ((GtkWidget*) expand_button, _tmp5_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) expand_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (expand_button, "clicked", (GCallback) __lambda7__gtk_button_clicked, self, 0);
	_tmp6_ = utils_get_toolbar_button (GTK_STOCK_ZOOM_OUT);
	collapse_button = _tmp6_;
	_tmp7_ = _ ("Collapse All");
	gtk_widget_set_tooltip_text ((GtkWidget*) collapse_button, _tmp7_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) collapse_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (collapse_button, "clicked", (GCallback) __lambda8__gtk_button_clicked, self, 0);
	_tmp8_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	_g_object_unref0 (sep);
	sep = g_object_ref_sink (_tmp8_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) sep, FALSE, TRUE, (guint) 0);
	_tmp9_ = g_new0 (StructType, 1);
	_tmp9_[0] = STRUCT_TYPE_LABEL;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 1;
	_tmp11_ = _ ("Show labels");
	_tmp12_ = structure_create_simple_list_button (self, _tmp10_, 1, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp10_ = (g_free (_tmp10_), NULL);
	toggle_button = _tmp13_;
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp14_ = g_new0 (StructType, 1);
	_tmp14_[0] = STRUCT_TYPE_INCLUDE;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	_tmp16_ = _ ("Show files included");
	_tmp17_ = structure_create_simple_list_button (self, _tmp15_, 1, _tmp16_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp17_;
	_tmp15_ = (g_free (_tmp15_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp18_ = g_new0 (StructType, 1);
	_tmp18_[0] = STRUCT_TYPE_TABLE;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	_tmp20_ = _ ("Show tables");
	_tmp21_ = structure_create_simple_list_button (self, _tmp19_, 1, _tmp20_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp21_;
	_tmp19_ = (g_free (_tmp19_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp22_ = g_new0 (StructType, 2);
	_tmp22_[0] = STRUCT_TYPE_FIGURE;
	_tmp22_[1] = STRUCT_TYPE_IMAGE;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 2;
	_tmp24_ = _ ("Show figures and images");
	_tmp25_ = structure_create_simple_list_button (self, _tmp23_, 2, _tmp24_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp25_;
	_tmp23_ = (g_free (_tmp23_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_tmp26_ = g_new0 (StructType, 2);
	_tmp26_[0] = STRUCT_TYPE_TODO;
	_tmp26_[1] = STRUCT_TYPE_FIXME;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	_tmp28_ = _ ("Show TODOs and FIXMEs");
	_tmp29_ = structure_create_simple_list_button (self, _tmp27_, 2, _tmp28_);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp29_;
	_tmp27_ = (g_free (_tmp27_), NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) toggle_button, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (toggle_button);
	_g_object_unref0 (collapse_button);
	_g_object_unref0 (expand_button);
	_g_object_unref0 (sep);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (hbox);
}


static StructType* _vala_array_dup3 (StructType* self, int length) {
	return g_memdup (self, length * sizeof (StructType));
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->button);
		_data13_->types = (g_free (_data13_->types), NULL);
		g_slice_free (Block13Data, _data13_);
	}
}


static void _vala_array_add9 (GtkToggleButton*** array, int* length, int* size, GtkToggleButton* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkToggleButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _vala_struct_type_array_contains (StructType* stack, int stack_length, StructType needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static StructType* _vala_array_dup4 (StructType* self, int length) {
	return g_memdup (self, length * sizeof (StructType));
}


static void _lambda9_ (Block13Data* _data13_) {
	Structure * self;
	gboolean _tmp0_;
	StructType* _tmp2_;
	StructType* _tmp3_;
	self = _data13_->self;
	_tmp0_ = gtk_toggle_button_get_active (_data13_->button);
	if (!_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (!self->priv->_list_is_hidden) {
			_tmp1_ = _vala_struct_type_array_contains (self->priv->_current_list_types, self->priv->_current_list_types_length1, _data13_->main_type);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			self->priv->_list_is_hidden = TRUE;
			gtk_widget_hide (self->priv->_list_view_sw);
		}
		return;
	}
	_tmp2_ = (_tmp3_ = _data13_->types, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup4 (_tmp3_, _data13_->types_length1));
	self->priv->_current_list_types = (g_free (self->priv->_current_list_types), NULL);
	self->priv->_current_list_types = _tmp2_;
	self->priv->_current_list_types_length1 = _data13_->types_length1;
	self->priv->__current_list_types_size_ = _data13_->types_length1;
	self->priv->_list_is_hidden = FALSE;
	gtk_widget_show_all (self->priv->_list_view_sw);
	structure_populate_simple_list (self);
	{
		GtkToggleButton** simple_list_button_collection;
		int simple_list_button_collection_length1;
		int simple_list_button_it;
		simple_list_button_collection = self->priv->_simple_list_buttons;
		simple_list_button_collection_length1 = self->priv->_simple_list_buttons_length1;
		for (simple_list_button_it = 0; simple_list_button_it < self->priv->_simple_list_buttons_length1; simple_list_button_it = simple_list_button_it + 1) {
			GtkToggleButton* _tmp4_;
			GtkToggleButton* simple_list_button;
			_tmp4_ = _g_object_ref0 (simple_list_button_collection[simple_list_button_it]);
			simple_list_button = _tmp4_;
			{
				if (simple_list_button == _data13_->button) {
					_g_object_unref0 (simple_list_button);
					continue;
				}
				gtk_toggle_button_set_active (simple_list_button, FALSE);
				_g_object_unref0 (simple_list_button);
			}
		}
	}
}


static void __lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda9_ (self);
}


static GtkToggleButton* structure_create_simple_list_button (Structure* self, StructType* types, int types_length1, const gchar* tooltip) {
	GtkToggleButton* result = NULL;
	Block13Data* _data13_;
	StructType* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GtkToggleButton* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->types = (_tmp0_ = types, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup3 (_tmp0_, types_length1));
	_data13_->types_length1 = types_length1;
	g_return_val_if_fail (_data13_->types_length1 > 0, NULL);
	_data13_->main_type = _data13_->types[0];
	_tmp1_ = structure_get_icon_from_type (_data13_->main_type);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_get_toolbar_toggle_button (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_data13_->button = _tmp4_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _data13_->button, tooltip);
	_tmp5_ = _g_object_ref0 (_data13_->button);
	_vala_array_add9 (&self->priv->_simple_list_buttons, &self->priv->_simple_list_buttons_length1, &self->priv->__simple_list_buttons_size_, _tmp5_);
	g_signal_connect_data ((GtkButton*) _data13_->button, "clicked", (GCallback) __lambda9__gtk_button_clicked, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp6_ = _g_object_ref0 (_data13_->button);
	result = _tmp6_;
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void structure_populate_simple_list (Structure* self) {
	gboolean _tmp0_ = FALSE;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* tree_select;
	GList* _tmp3_ = NULL;
	GList* selected_rows;
	guint _tmp4_;
	gconstpointer _tmp5_ = NULL;
	GtkTreePath* _tmp6_;
	GtkTreePath* tree_path;
	GtkTreeIter tree_iter = {0};
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->_list_store);
	if (self->priv->_model == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_list_is_hidden;
	}
	if (_tmp0_) {
		return;
	}
	structure_model_populate_list (self->priv->_model, self->priv->_list_store, self->priv->_current_list_types[0]);
	_tmp1_ = gtk_tree_view_get_selection (self->priv->_tree_view);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	tree_select = _tmp2_;
	_tmp3_ = gtk_tree_selection_get_selected_rows (tree_select, NULL);
	selected_rows = _tmp3_;
	_tmp4_ = g_list_length (selected_rows);
	if (_tmp4_ != 1) {
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		_g_object_unref0 (tree_select);
		return;
	}
	_tmp5_ = g_list_nth_data (selected_rows, (guint) 0);
	_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp5_);
	tree_path = _tmp6_;
	_tmp8_ = gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_model, &_tmp7_, tree_path);
	tree_iter = _tmp7_;
	if (!_tmp8_) {
		g_return_if_reached ();
	}
	structure_select_simple_list_item (self, &tree_iter);
	_gtk_tree_path_free0 (tree_path);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
	_g_object_unref0 (tree_select);
}


static void structure_init_vpaned (Structure* self) {
	GtkVPaned* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* settings;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkVPaned*) gtk_vpaned_new ();
	_g_object_unref0 (self->priv->_vpaned);
	self->priv->_vpaned = g_object_ref_sink (_tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->_vpaned, TRUE, TRUE, (guint) 0);
	_tmp1_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp1_;
	_tmp2_ = g_settings_get_int (settings, "structure-paned-position");
	gtk_paned_set_position ((GtkPaned*) self->priv->_vpaned, _tmp2_);
	_g_object_unref0 (settings);
}


void structure_save_state (Structure* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp0_;
	_tmp1_ = gtk_paned_get_position ((GtkPaned*) self->priv->_vpaned);
	g_settings_set_int (settings, "structure-paned-position", _tmp1_);
	_g_object_unref0 (settings);
}


static gboolean _lambda10_ (GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, Structure* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (path_currently_selected) {
		result = TRUE;
		return result;
	}
	_tmp0_ = structure_select_list_row (self, path);
	result = _tmp0_;
	return result;
}


static gboolean __lambda10__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = _lambda10_ (selection, model, path, path_currently_selected, self);
	return result;
}


static void _lambda11_ (GtkTreePath* path, Structure* self) {
	g_return_if_fail (path != NULL);
	structure_select_list_row (self, path);
}


static void __lambda11__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	_lambda11_ (path, self);
}


static void structure_init_list_view (Structure* self) {
	GtkTreeView* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* list_select;
	GtkWidget* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_get_new_tree_view (self, (gint) STRUCT_LIST_COLUMN_PIXBUF, (gint) STRUCT_LIST_COLUMN_TEXT, (gint) STRUCT_LIST_COLUMN_TOOLTIP);
	_g_object_unref0 (self->priv->_list_view);
	self->priv->_list_view = _tmp0_;
	_tmp1_ = gtk_list_store_new ((gint) STRUCT_LIST_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->_list_store);
	self->priv->_list_store = _tmp1_;
	gtk_tree_view_set_model (self->priv->_list_view, (GtkTreeModel*) self->priv->_list_store);
	_tmp2_ = gtk_tree_view_get_selection (self->priv->_list_view);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	list_select = _tmp3_;
	gtk_tree_selection_set_select_function (list_select, __lambda10__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self->priv->_list_view, "row-activated", (GCallback) __lambda11__gtk_tree_view_row_activated, self, 0);
	_tmp4_ = utils_add_scrollbar ((GtkWidget*) self->priv->_list_view);
	_g_object_unref0 (self->priv->_list_view_sw);
	self->priv->_list_view_sw = _tmp4_;
	gtk_paned_add1 ((GtkPaned*) self->priv->_vpaned, self->priv->_list_view_sw);
	_g_object_unref0 (list_select);
}


static gboolean _lambda12_ (GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, Structure* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (path_currently_selected) {
		result = TRUE;
		return result;
	}
	_tmp0_ = structure_select_tree_row (self, path);
	result = _tmp0_;
	return result;
}


static gboolean __lambda12__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = _lambda12_ (selection, model, path, path_currently_selected, self);
	return result;
}


static void _lambda13_ (GtkTreePath* path, Structure* self) {
	g_return_if_fail (path != NULL);
	structure_select_tree_row (self, path);
}


static void __lambda13__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	_lambda13_ (path, self);
}


static gboolean _lambda14_ (GdkEventButton* event, Structure* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if ((*event).button == 3) {
		_tmp0_ = (*event).type == GDK_BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		structure_show_popup_menu (self, event);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda14__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda14_ (event, self);
	return result;
}


static gboolean _lambda15_ (Structure* self) {
	gboolean result = FALSE;
	structure_show_popup_menu (self, NULL);
	result = TRUE;
	return result;
}


static gboolean __lambda15__gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = _lambda15_ (self);
	return result;
}


static void structure_init_tree_view (Structure* self) {
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* tree_select;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* sw;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_get_new_tree_view (self, (gint) STRUCT_COLUMN_PIXBUF, (gint) STRUCT_COLUMN_TEXT, (gint) STRUCT_COLUMN_TOOLTIP);
	_g_object_unref0 (self->priv->_tree_view);
	self->priv->_tree_view = _tmp0_;
	gtk_tree_view_set_enable_tree_lines (self->priv->_tree_view, TRUE);
	_tmp1_ = gtk_tree_view_get_selection (self->priv->_tree_view);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	tree_select = _tmp2_;
	gtk_tree_selection_set_select_function (tree_select, __lambda12__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self->priv->_tree_view, "row-activated", (GCallback) __lambda13__gtk_tree_view_row_activated, self, 0);
	gtk_menu_attach_to_widget (self->priv->_popup_menu, (GtkWidget*) self->priv->_tree_view, NULL);
	g_signal_connect_object ((GtkWidget*) self->priv->_tree_view, "button-press-event", (GCallback) __lambda14__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_tree_view, "popup-menu", (GCallback) __lambda15__gtk_widget_popup_menu, self, 0);
	_tmp3_ = utils_add_scrollbar ((GtkWidget*) self->priv->_tree_view);
	sw = _tmp3_;
	gtk_paned_add2 ((GtkPaned*) self->priv->_vpaned, sw);
	_g_object_unref0 (sw);
	_g_object_unref0 (tree_select);
}


static GtkTreeView* structure_get_new_tree_view (Structure* self, gint pixbuf_col, gint text_col, gint tooltip_col) {
	GtkTreeView* result = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* tree_view;
	GtkTreeViewColumn* _tmp1_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* _tmp2_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp3_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeSelection* _tmp5_;
	GtkTreeSelection* select;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	tree_view = g_object_ref_sink (_tmp0_);
	gtk_tree_view_set_headers_visible (tree_view, FALSE);
	_tmp1_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp1_);
	gtk_tree_view_append_column (tree_view, column);
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp2_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", pixbuf_col, NULL, NULL);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", text_col, NULL, NULL);
	gtk_tree_view_set_tooltip_column (tree_view, tooltip_col);
	_tmp4_ = gtk_tree_view_get_selection (tree_view);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	select = _tmp5_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	result = tree_view;
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	return result;
}


static gboolean structure_select_list_row (Structure* self, GtkTreePath* list_path) {
	gboolean result = FALSE;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* tree_select;
	gint* _tmp2_ = NULL;
	gint row_num;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* tree_path;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (list_path != NULL, FALSE);
	if (!self->priv->_first_select) {
		self->priv->_first_select = TRUE;
		result = TRUE;
		return result;
	}
	g_return_val_if_fail (self->priv->_model != NULL, FALSE);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->_tree_view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tree_select = _tmp1_;
	gtk_tree_selection_unselect_all (tree_select);
	_tmp2_ = gtk_tree_path_get_indices (list_path);
	row_num = _tmp2_[0];
	_tmp3_ = structure_model_get_tree_path_from_list_num (self->priv->_model, self->priv->_current_list_types[0], row_num);
	tree_path = _tmp3_;
	g_return_val_if_fail (tree_path != NULL, FALSE);
	gtk_tree_view_expand_to_path (self->priv->_tree_view, tree_path);
	self->priv->_first_select = FALSE;
	gtk_tree_selection_select_path (tree_select, tree_path);
	gtk_tree_view_scroll_to_cell (self->priv->_tree_view, tree_path, NULL, TRUE, (gfloat) 0.5, (gfloat) 0);
	result = TRUE;
	_gtk_tree_path_free0 (tree_path);
	_g_object_unref0 (tree_select);
	return result;
}


static gboolean structure_select_tree_row (Structure* self, GtkTreePath* tree_path) {
	gboolean result = FALSE;
	gboolean first_select;
	GtkTreeIter tree_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextMark* mark = NULL;
	StructType type = 0;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* doc;
	Document* _tmp4_ = NULL;
	GtkTextIter text_iter = {0};
	GtkTextIter _tmp5_ = {0};
	DocumentView* _tmp6_ = NULL;
	GtkTextMark* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_path != NULL, FALSE);
	first_select = self->priv->_first_select;
	self->priv->_first_select = TRUE;
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_model, &_tmp0_, tree_path);
	tree_iter = _tmp0_;
	if (!_tmp1_) {
		g_return_val_if_reached (FALSE);
	}
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, &tree_iter, STRUCT_COLUMN_START_MARK, &mark, STRUCT_COLUMN_TYPE, &type, -1, -1);
	_tmp2_ = gtk_text_mark_get_buffer (mark);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = main_window_get_active_document (self->priv->_main_window);
	g_return_val_if_fail (doc == GTK_TEXT_BUFFER (_tmp4_), FALSE);
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp5_, mark);
	text_iter = _tmp5_;
	gtk_text_buffer_place_cursor (doc, &text_iter);
	_tmp6_ = main_window_get_active_view (self->priv->_main_window);
	_tmp7_ = gtk_text_buffer_get_insert (doc);
	gtk_text_view_scroll_to_mark ((GtkTextView*) _tmp6_, _tmp7_, (gdouble) 0, TRUE, (gdouble) 1, (gdouble) 0);
	structure_set_actions_sensitivity (self, type);
	if (!first_select) {
		result = TRUE;
		_g_object_unref0 (doc);
		_g_object_unref0 (mark);
		return result;
	}
	structure_select_simple_list_item (self, &tree_iter);
	result = TRUE;
	_g_object_unref0 (doc);
	_g_object_unref0 (mark);
	return result;
}


static void structure_select_simple_list_item (Structure* self, GtkTreeIter* tree_iter) {
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* list_select;
	StructType type = 0;
	gint _tmp2_;
	gint row_num;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* list_path;
	g_return_if_fail (self != NULL);
	if (self->priv->_list_is_hidden) {
		return;
	}
	_tmp0_ = gtk_tree_view_get_selection (self->priv->_list_view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	list_select = _tmp1_;
	gtk_tree_selection_unselect_all (list_select);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, tree_iter, STRUCT_COLUMN_TYPE, &type, -1, -1);
	if (!_vala_struct_type_array_contains (self->priv->_current_list_types, self->priv->_current_list_types_length1, type)) {
		_g_object_unref0 (list_select);
		return;
	}
	_tmp2_ = structure_model_get_list_num_from_tree_iter (self->priv->_model, tree_iter);
	row_num = _tmp2_;
	if (row_num == (-1)) {
		_g_object_unref0 (list_select);
		return;
	}
	_tmp3_ = gtk_tree_path_new_from_indices (row_num, -1, -1);
	list_path = _tmp3_;
	self->priv->_first_select = FALSE;
	gtk_tree_selection_select_path (list_select, list_path);
	gtk_tree_view_scroll_to_cell (self->priv->_list_view, list_path, NULL, FALSE, (gfloat) 0, (gfloat) 0);
	_gtk_tree_path_free0 (list_path);
	_g_object_unref0 (list_select);
}


static void structure_show_active_document (Structure* self) {
	Document* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_document (self->priv->_main_window);
	structure_show_document (self, _tmp0_, FALSE);
}


static void _lambda6_ (Structure* self) {
	gboolean _tmp0_;
	_tmp0_ = document_structure_get_parsing_done (self->priv->_document_structure);
	if (_tmp0_) {
		StructureModel* _tmp1_ = NULL;
		StructureModel* _tmp2_;
		_tmp1_ = document_structure_get_model (self->priv->_document_structure);
		_tmp2_ = _tmp1_;
		structure_set_model (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
}


static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda6_ (self);
}


static void structure_show_document (Structure* self, Document* doc, gboolean force_parse) {
	DocumentStructure* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	structure_set_model (self, NULL);
	gtk_tree_view_columns_autosize (self->priv->_tree_view);
	if (doc == NULL) {
		return;
	}
	_tmp0_ = document_get_structure (doc);
	_g_object_unref0 (self->priv->_document_structure);
	self->priv->_document_structure = _tmp0_;
	if (force_parse) {
		document_structure_parse (self->priv->_document_structure);
	}
	_tmp1_ = document_structure_get_parsing_done (self->priv->_document_structure);
	if (_tmp1_) {
		StructureModel* _tmp2_ = NULL;
		StructureModel* _tmp3_;
		_tmp2_ = document_structure_get_model (self->priv->_document_structure);
		_tmp3_ = _tmp2_;
		structure_set_model (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	g_signal_connect_object ((GObject*) self->priv->_document_structure, "notify::parsing-done", (GCallback) __lambda6__g_object_notify, self, 0);
}


static void structure_set_model (Structure* self, StructureModel* model) {
	StructureModel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (model);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	gtk_tree_view_set_model (self->priv->_tree_view, (GtkTreeModel*) model);
	gtk_tree_view_expand_all (self->priv->_tree_view);
	structure_populate_simple_list (self);
}


static void _structure_show_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	structure_show_active_document (self);
}


void structure_connect_parsing (Structure* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GObject*) self->priv->_main_window, "notify::active-document", (GCallback) _structure_show_active_document_g_object_notify, self, 0);
	structure_show_active_document (self);
}


void structure_disconnect_parsing (Structure* self) {
	guint _tmp0_;
	GQuark _tmp1_;
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->_main_window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _structure_show_active_document_g_object_notify, self);
}


gboolean structure_is_section (StructType type) {
	gboolean result = FALSE;
	result = type <= STRUCT_TYPE_SUBPARAGRAPH;
	return result;
}


/*************************************************************************/
static void structure_show_popup_menu (Structure* self, GdkEventButton* event) {
	g_return_if_fail (self != NULL);
	if (event != NULL) {
		gtk_menu_popup (self->priv->_popup_menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
	} else {
		guint32 _tmp0_;
		_tmp0_ = gtk_get_current_event_time ();
		gtk_menu_popup (self->priv->_popup_menu, NULL, NULL, NULL, NULL, (guint) 0, _tmp0_);
	}
}


static void structure_set_actions_sensitivity (Structure* self, StructType type) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	gtk_action_set_sensitive (self->priv->_action_all_menu, TRUE);
	gtk_action_set_sensitive (self->priv->_action_cut, TRUE);
	gtk_action_set_sensitive (self->priv->_action_copy, TRUE);
	gtk_action_set_sensitive (self->priv->_action_delete, TRUE);
	gtk_action_set_sensitive (self->priv->_action_select, TRUE);
	gtk_action_set_sensitive (self->priv->_action_comment, TRUE);
	if (STRUCT_TYPE_PART < type) {
		_tmp0_ = type <= STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp0_ = FALSE;
	}
	gtk_action_set_sensitive (self->priv->_action_shift_left, _tmp0_);
	gtk_action_set_sensitive (self->priv->_action_shift_right, type < STRUCT_TYPE_SUBPARAGRAPH);
}


void structure_do_action (Structure* self, StructAction action_type) {
	GtkTreeIter selected_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint selected_row;
	gboolean refresh_simple_list;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = utils_get_selected_row (self->priv->_tree_view, &_tmp0_);
	selected_iter = _tmp0_;
	selected_row = _tmp1_;
	g_return_if_fail (selected_row != (-1));
	refresh_simple_list = FALSE;
	document_structure_do_action (self->priv->_document_structure, action_type, &selected_iter, &_tmp2_, &_inner_error_);
	refresh_simple_list = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == STRUCT_ERROR) {
			goto __catch27_struct_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally27;
	__catch27_struct_error:
	{
		GError * e;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GtkMessageDialog* _tmp6_ = NULL;
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* dialog;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Structure action error: %s");
		_tmp4_ = structure_get_action_name (action_type);
		_tmp5_ = _tmp4_;
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self->priv->_main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp3_, _tmp5_);
		_tmp7_ = g_object_ref_sink (_tmp6_);
		_g_free0 (_tmp5_);
		dialog = _tmp7_;
		if (g_error_matches (e, STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED)) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = _ ("The structure data seems outdated. Please refresh the structure.");
			g_object_set (dialog, "secondary-text", _tmp8_, NULL);
		} else {
			g_object_set (dialog, "secondary-text", e->message, NULL);
		}
		gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		return;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (refresh_simple_list) {
		structure_populate_simple_list (self);
	}
}


static gchar* structure_get_action_name (StructAction action_type) {
	gchar* result = NULL;
	gchar* _tmp22_;
	if (structure__action_names == NULL) {
		gchar** _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp0_ = g_new0 (gchar*, STRUCT_ACTION_NB_ACTIONS + 1);
		structure__action_names = (_vala_array_free (structure__action_names, structure__action_names_length1, (GDestroyNotify) g_free), NULL);
		structure__action_names = _tmp0_;
		structure__action_names_length1 = STRUCT_ACTION_NB_ACTIONS;
		_structure__action_names_size_ = STRUCT_ACTION_NB_ACTIONS;
		_tmp1_ = _ ("cut");
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (structure__action_names[STRUCT_ACTION_CUT]);
		structure__action_names[STRUCT_ACTION_CUT] = _tmp3_;
		_tmp4_ = _ ("copy");
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (structure__action_names[STRUCT_ACTION_COPY]);
		structure__action_names[STRUCT_ACTION_COPY] = _tmp6_;
		_tmp7_ = _ ("delete");
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (structure__action_names[STRUCT_ACTION_DELETE]);
		structure__action_names[STRUCT_ACTION_DELETE] = _tmp9_;
		_tmp10_ = _ ("select");
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (structure__action_names[STRUCT_ACTION_SELECT]);
		structure__action_names[STRUCT_ACTION_SELECT] = _tmp12_;
		_tmp13_ = _ ("comment");
		_tmp14_ = g_strdup (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (structure__action_names[STRUCT_ACTION_COMMENT]);
		structure__action_names[STRUCT_ACTION_COMMENT] = _tmp15_;
		_tmp16_ = _ ("shift left");
		_tmp17_ = g_strdup (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (structure__action_names[STRUCT_ACTION_SHIFT_LEFT]);
		structure__action_names[STRUCT_ACTION_SHIFT_LEFT] = _tmp18_;
		_tmp19_ = _ ("shift right");
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (structure__action_names[STRUCT_ACTION_SHIFT_RIGHT]);
		structure__action_names[STRUCT_ACTION_SHIFT_RIGHT] = _tmp21_;
	}
	_tmp22_ = g_strdup (structure__action_names[action_type]);
	result = _tmp22_;
	return result;
}


gchar* structure_get_icon_from_type (StructType type) {
	gchar* result = NULL;
	gchar* _tmp29_;
	if (structure__icons == NULL) {
		gchar** _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp0_ = g_new0 (gchar*, STRUCT_TYPE_NB_TYPES + 1);
		structure__icons = (_vala_array_free (structure__icons, structure__icons_length1, (GDestroyNotify) g_free), NULL);
		structure__icons = _tmp0_;
		structure__icons_length1 = STRUCT_TYPE_NB_TYPES;
		_structure__icons_size_ = STRUCT_TYPE_NB_TYPES;
		_tmp1_ = g_strdup ("tree_part");
		_tmp2_ = _tmp1_;
		_g_free0 (structure__icons[STRUCT_TYPE_PART]);
		structure__icons[STRUCT_TYPE_PART] = _tmp2_;
		_tmp3_ = g_strdup ("tree_chapter");
		_tmp4_ = _tmp3_;
		_g_free0 (structure__icons[STRUCT_TYPE_CHAPTER]);
		structure__icons[STRUCT_TYPE_CHAPTER] = _tmp4_;
		_tmp5_ = g_strdup ("tree_section");
		_tmp6_ = _tmp5_;
		_g_free0 (structure__icons[STRUCT_TYPE_SECTION]);
		structure__icons[STRUCT_TYPE_SECTION] = _tmp6_;
		_tmp7_ = g_strdup ("tree_subsection");
		_tmp8_ = _tmp7_;
		_g_free0 (structure__icons[STRUCT_TYPE_SUBSECTION]);
		structure__icons[STRUCT_TYPE_SUBSECTION] = _tmp8_;
		_tmp9_ = g_strdup ("tree_subsubsection");
		_tmp10_ = _tmp9_;
		_g_free0 (structure__icons[STRUCT_TYPE_SUBSUBSECTION]);
		structure__icons[STRUCT_TYPE_SUBSUBSECTION] = _tmp10_;
		_tmp11_ = g_strdup ("tree_paragraph");
		_tmp12_ = _tmp11_;
		_g_free0 (structure__icons[STRUCT_TYPE_PARAGRAPH]);
		structure__icons[STRUCT_TYPE_PARAGRAPH] = _tmp12_;
		_tmp13_ = g_strdup ("tree_paragraph");
		_tmp14_ = _tmp13_;
		_g_free0 (structure__icons[STRUCT_TYPE_SUBPARAGRAPH]);
		structure__icons[STRUCT_TYPE_SUBPARAGRAPH] = _tmp14_;
		_tmp15_ = g_strdup ("tree_label");
		_tmp16_ = _tmp15_;
		_g_free0 (structure__icons[STRUCT_TYPE_LABEL]);
		structure__icons[STRUCT_TYPE_LABEL] = _tmp16_;
		_tmp17_ = g_strdup ("tree_todo");
		_tmp18_ = _tmp17_;
		_g_free0 (structure__icons[STRUCT_TYPE_TODO]);
		structure__icons[STRUCT_TYPE_TODO] = _tmp18_;
		_tmp19_ = g_strdup ("tree_todo");
		_tmp20_ = _tmp19_;
		_g_free0 (structure__icons[STRUCT_TYPE_FIXME]);
		structure__icons[STRUCT_TYPE_FIXME] = _tmp20_;
		_tmp21_ = g_strdup ("table");
		_tmp22_ = _tmp21_;
		_g_free0 (structure__icons[STRUCT_TYPE_TABLE]);
		structure__icons[STRUCT_TYPE_TABLE] = _tmp22_;
		_tmp23_ = g_strdup ("image");
		_tmp24_ = _tmp23_;
		_g_free0 (structure__icons[STRUCT_TYPE_FIGURE]);
		structure__icons[STRUCT_TYPE_FIGURE] = _tmp24_;
		_tmp25_ = g_strdup ("image");
		_tmp26_ = _tmp25_;
		_g_free0 (structure__icons[STRUCT_TYPE_IMAGE]);
		structure__icons[STRUCT_TYPE_IMAGE] = _tmp26_;
		_tmp27_ = g_strdup ("tree_include");
		_tmp28_ = _tmp27_;
		_g_free0 (structure__icons[STRUCT_TYPE_INCLUDE]);
		structure__icons[STRUCT_TYPE_INCLUDE] = _tmp28_;
	}
	_tmp29_ = g_strdup (structure__icons[type]);
	result = _tmp29_;
	return result;
}


gchar* structure_get_type_name (StructType type) {
	gchar* result = NULL;
	gchar* _tmp41_;
	if (structure__names == NULL) {
		gchar** _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp0_ = g_new0 (gchar*, STRUCT_TYPE_NB_TYPES + 1);
		structure__names = (_vala_array_free (structure__names, structure__names_length1, (GDestroyNotify) g_free), NULL);
		structure__names = _tmp0_;
		structure__names_length1 = STRUCT_TYPE_NB_TYPES;
		_structure__names_size_ = STRUCT_TYPE_NB_TYPES;
		_tmp1_ = _ ("Part");
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (structure__names[STRUCT_TYPE_PART]);
		structure__names[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = _ ("Chapter");
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (structure__names[STRUCT_TYPE_CHAPTER]);
		structure__names[STRUCT_TYPE_CHAPTER] = _tmp6_;
		_tmp7_ = _ ("Section");
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (structure__names[STRUCT_TYPE_SECTION]);
		structure__names[STRUCT_TYPE_SECTION] = _tmp9_;
		_tmp10_ = _ ("Sub-section");
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (structure__names[STRUCT_TYPE_SUBSECTION]);
		structure__names[STRUCT_TYPE_SUBSECTION] = _tmp12_;
		_tmp13_ = _ ("Sub-sub-section");
		_tmp14_ = g_strdup (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (structure__names[STRUCT_TYPE_SUBSUBSECTION]);
		structure__names[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
		_tmp16_ = _ ("Paragraph");
		_tmp17_ = g_strdup (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (structure__names[STRUCT_TYPE_PARAGRAPH]);
		structure__names[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
		_tmp19_ = _ ("Sub-paragraph");
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (structure__names[STRUCT_TYPE_SUBPARAGRAPH]);
		structure__names[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
		_tmp22_ = _ ("Label");
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (structure__names[STRUCT_TYPE_LABEL]);
		structure__names[STRUCT_TYPE_LABEL] = _tmp24_;
		_tmp25_ = g_strdup ("TODO");
		_tmp26_ = _tmp25_;
		_g_free0 (structure__names[STRUCT_TYPE_TODO]);
		structure__names[STRUCT_TYPE_TODO] = _tmp26_;
		_tmp27_ = g_strdup ("FIXME");
		_tmp28_ = _tmp27_;
		_g_free0 (structure__names[STRUCT_TYPE_FIXME]);
		structure__names[STRUCT_TYPE_FIXME] = _tmp28_;
		_tmp29_ = _ ("Table");
		_tmp30_ = g_strdup (_tmp29_);
		_tmp31_ = _tmp30_;
		_g_free0 (structure__names[STRUCT_TYPE_TABLE]);
		structure__names[STRUCT_TYPE_TABLE] = _tmp31_;
		_tmp32_ = _ ("Figure");
		_tmp33_ = g_strdup (_tmp32_);
		_tmp34_ = _tmp33_;
		_g_free0 (structure__names[STRUCT_TYPE_FIGURE]);
		structure__names[STRUCT_TYPE_FIGURE] = _tmp34_;
		_tmp35_ = _ ("Image");
		_tmp36_ = g_strdup (_tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (structure__names[STRUCT_TYPE_IMAGE]);
		structure__names[STRUCT_TYPE_IMAGE] = _tmp37_;
		_tmp38_ = _ ("File included");
		_tmp39_ = g_strdup (_tmp38_);
		_tmp40_ = _tmp39_;
		_g_free0 (structure__names[STRUCT_TYPE_INCLUDE]);
		structure__names[STRUCT_TYPE_INCLUDE] = _tmp40_;
	}
	_tmp41_ = g_strdup (structure__names[type]);
	result = _tmp41_;
	return result;
}


static void structure_class_init (StructureClass * klass) {
	structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StructurePrivate));
	G_OBJECT_CLASS (klass)->finalize = structure_finalize;
}


static void structure_instance_init (Structure * self) {
	GtkToggleButton** _tmp0_ = NULL;
	self->priv = STRUCTURE_GET_PRIVATE (self);
	_tmp0_ = g_new0 (GtkToggleButton*, 0 + 1);
	self->priv->_simple_list_buttons = _tmp0_;
	self->priv->_simple_list_buttons_length1 = 0;
	self->priv->__simple_list_buttons_size_ = self->priv->_simple_list_buttons_length1;
	self->priv->_document_structure = NULL;
	self->priv->_model = NULL;
	self->priv->_list_is_hidden = TRUE;
	self->priv->_first_select = TRUE;
}


static void structure_finalize (GObject* obj) {
	Structure * self;
	self = STRUCTURE (obj);
	_g_object_unref0 (self->priv->_popup_menu);
	_g_object_unref0 (self->priv->_action_all_menu);
	_g_object_unref0 (self->priv->_action_cut);
	_g_object_unref0 (self->priv->_action_copy);
	_g_object_unref0 (self->priv->_action_delete);
	_g_object_unref0 (self->priv->_action_select);
	_g_object_unref0 (self->priv->_action_comment);
	_g_object_unref0 (self->priv->_action_shift_left);
	_g_object_unref0 (self->priv->_action_shift_right);
	self->priv->_simple_list_buttons = (_vala_array_free (self->priv->_simple_list_buttons, self->priv->_simple_list_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_vpaned);
	_g_object_unref0 (self->priv->_tree_view);
	_g_object_unref0 (self->priv->_document_structure);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_list_view);
	_g_object_unref0 (self->priv->_list_view_sw);
	_g_object_unref0 (self->priv->_list_store);
	self->priv->_current_list_types = (g_free (self->priv->_current_list_types), NULL);
	G_OBJECT_CLASS (structure_parent_class)->finalize (obj);
}


GType structure_get_type (void) {
	static volatile gsize structure_type_id__volatile = 0;
	if (g_once_init_enter (&structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Structure), 0, (GInstanceInitFunc) structure_instance_init, NULL };
		GType structure_type_id;
		structure_type_id = g_type_register_static (GTK_TYPE_VBOX, "Structure", &g_define_type_info, 0);
		g_once_init_leave (&structure_type_id__volatile, structure_type_id);
	}
	return structure_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



