/* main_window.c generated by valac 0.12.1, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksourceview.h>
#include <config.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_CUSTOM_STATUSBAR (custom_statusbar_get_type ())
#define CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbar))
#define CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))
#define IS_CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_STATUSBAR))
#define IS_CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_STATUSBAR))
#define CUSTOM_STATUSBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))

typedef struct _CustomStatusbar CustomStatusbar;
typedef struct _CustomStatusbarClass CustomStatusbarClass;

#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_SIDE_PANEL (side_panel_get_type ())
#define SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIDE_PANEL, SidePanel))
#define SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIDE_PANEL, SidePanelClass))
#define IS_SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIDE_PANEL))
#define IS_SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIDE_PANEL))
#define SIDE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIDE_PANEL, SidePanelClass))

typedef struct _SidePanel SidePanel;
typedef struct _SidePanelClass SidePanelClass;

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _Block6Data Block6Data;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
typedef struct _Block7Data Block7Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))

#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _MainWindowPrivate {
	gchar* file_chooser_current_folder;
	DocumentsPanel* documents_panel;
	CustomStatusbar* statusbar;
	GotoLine* goto_line;
	SearchAndReplace* search_and_replace;
	BuildView* build_view;
	GtkToolbar* main_toolbar;
	GtkToolbar* edit_toolbar;
	SidePanel* side_panel;
	Symbols* symbols;
	FileBrowser* file_browser;
	Structure* _structure;
	GtkHPaned* main_hpaned;
	GtkVPaned* vpaned;
	GtkUIManager* ui_manager;
	GtkActionGroup* action_group;
	GtkActionGroup* latex_action_group;
	GtkActionGroup* documents_list_action_group;
	GtkActionGroup* build_tools_action_group;
	guint documents_list_menu_ui_id;
	guint build_tools_menu_ui_id;
	BuildToolRunner* build_tool_runner;
	GtkAction* action_stop_exec;
	guint tip_message_cid;
};

struct _Block6Data {
	int _ref_count_;
	MainWindow * self;
	DocumentTab* tab;
	GtkInfoBar* infobar;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	MainWindow * self;
	DocumentTab* tab;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GList* jobs;
};

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;


static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType documents_panel_get_type (void) G_GNUC_CONST;
GType custom_statusbar_get_type (void) G_GNUC_CONST;
GType goto_line_get_type (void) G_GNUC_CONST;
GType search_and_replace_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType side_panel_get_type (void) G_GNUC_CONST;
GType symbols_get_type (void) G_GNUC_CONST;
GType file_browser_get_type (void) G_GNUC_CONST;
GType structure_get_type (void) G_GNUC_CONST;
GType build_tool_runner_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB,
	MAIN_WINDOW_ACTIVE_VIEW,
	MAIN_WINDOW_ACTIVE_DOCUMENT
};
void main_window_on_file_new (MainWindow* self);
static void _main_window_on_file_new_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_new_window (MainWindow* self);
static void _main_window_on_new_window_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_open (MainWindow* self);
static void _main_window_on_file_open_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_save (MainWindow* self);
static void _main_window_on_file_save_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_save_as (MainWindow* self);
static void _main_window_on_file_save_as_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_create_template (MainWindow* self);
static void _main_window_on_create_template_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_delete_template (MainWindow* self);
static void _main_window_on_delete_template_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_file_close (MainWindow* self);
static void _main_window_on_file_close_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_quit (MainWindow* self);
static void _main_window_on_quit_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_undo (MainWindow* self);
static void _main_window_on_edit_undo_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_redo (MainWindow* self);
static void _main_window_on_edit_redo_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_cut (MainWindow* self);
static void _main_window_on_edit_cut_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_copy (MainWindow* self);
static void _main_window_on_edit_copy_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_paste (MainWindow* self);
static void _main_window_on_edit_paste_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_delete (MainWindow* self);
static void _main_window_on_edit_delete_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_select_all (MainWindow* self);
static void _main_window_on_edit_select_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_comment (MainWindow* self);
static void _main_window_on_edit_comment_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_edit_uncomment (MainWindow* self);
static void _main_window_on_edit_uncomment_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_open_preferences (MainWindow* self);
static void _main_window_on_open_preferences_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_goto_line (MainWindow* self);
static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_clean (MainWindow* self);
static void _main_window_on_build_clean_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_stop_execution (MainWindow* self);
static void _main_window_on_build_stop_execution_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_view_log (MainWindow* self);
static void _main_window_on_build_view_log_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_save_all (MainWindow* self);
static void _main_window_on_documents_save_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_close_all (MainWindow* self);
static void _main_window_on_documents_close_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_previous (MainWindow* self);
static void _main_window_on_documents_previous_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_next (MainWindow* self);
static void _main_window_on_documents_next_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_documents_move_to_new_window (MainWindow* self);
static void _main_window_on_documents_move_to_new_window_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_cut (MainWindow* self);
static void _main_window_on_structure_cut_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_copy (MainWindow* self);
static void _main_window_on_structure_copy_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_delete (MainWindow* self);
static void _main_window_on_structure_delete_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_select (MainWindow* self);
static void _main_window_on_structure_select_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_comment (MainWindow* self);
static void _main_window_on_structure_comment_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_shift_left (MainWindow* self);
static void _main_window_on_structure_shift_left_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_structure_shift_right (MainWindow* self);
static void _main_window_on_structure_shift_right_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_help_contents (MainWindow* self);
static void _main_window_on_help_contents_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_about_dialog (MainWindow* self);
static void _main_window_on_about_dialog_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_main_toolbar (MainWindow* self, GtkAction* action);
static void _main_window_on_show_main_toolbar_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_edit_toolbar (MainWindow* self, GtkAction* action);
static void _main_window_on_show_edit_toolbar_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_side_panel (MainWindow* self, GtkAction* action);
static void _main_window_on_show_side_panel_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_show_bottom_panel (MainWindow* self, GtkAction* action);
static void _main_window_on_show_bottom_panel_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_show_errors (MainWindow* self, GtkAction* action);
static void _main_window_on_build_show_errors_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_show_warnings (MainWindow* self, GtkAction* action);
static void _main_window_on_build_show_warnings_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_build_show_badboxes (MainWindow* self, GtkAction* action);
static void _main_window_on_build_show_badboxes_gtk_action_callback (GtkAction* action, gpointer self);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static void main_window_initialize_menubar_and_toolbar (MainWindow* self);
static void main_window_setup_toolbar_open_button (MainWindow* self, GtkToolbar* toolbar);
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type, MainWindow* main_window);
static void _lambda108_ (GdkEventButton* event, MainWindow* self);
static void __lambda108__documents_panel_right_click (DocumentsPanel* _sender, GdkEventButton* event, gpointer self);
CustomStatusbar* custom_statusbar_new (void);
CustomStatusbar* custom_statusbar_construct (GType object_type);
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
SidePanel* side_panel_new (MainWindow* main_window, GtkToggleAction* action_view_side_panel);
SidePanel* side_panel_construct (GType object_type, MainWindow* main_window, GtkToggleAction* action_view_side_panel);
Symbols* symbols_new (MainWindow* main_window);
Symbols* symbols_construct (GType object_type, MainWindow* main_window);
void side_panel_add_component (SidePanel* self, const gchar* name, const gchar* stock_id, GtkVBox* component);
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
Structure* structure_new (MainWindow* main_window, GtkUIManager* ui_manager);
Structure* structure_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
void side_panel_restore_state (SidePanel* self);
static gboolean _lambda109_ (MainWindow* self);
static gboolean __lambda109__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _lambda110_ (MainWindow* self);
static void main_window_set_file_actions_sensitivity (MainWindow* self, gboolean sensitive);
static void main_window_set_documents_move_to_new_window_sensitivity (MainWindow* self, gboolean sensitive);
static void main_window_update_documents_list_menu (MainWindow* self);
static void __lambda110__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda111_ (MainWindow* self);
void custom_statusbar_set_cursor_position (CustomStatusbar* self, gint line, gint col);
void search_and_replace_hide (SearchAndReplace* self);
static void main_window_my_set_title (MainWindow* self);
static void __lambda111__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda112_ (GtkNotebookPage* pg, guint page_num, MainWindow* self);
static void main_window_set_undo_sensitivity (MainWindow* self);
static void main_window_set_redo_sensitivity (MainWindow* self);
static void main_window_update_next_prev_doc_sensitivity (MainWindow* self);
static void main_window_update_build_tools_sensitivity (MainWindow* self);
void main_window_update_config_project_sensitivity (MainWindow* self);
static void main_window_update_cursor_position_statusbar (MainWindow* self);
static void main_window_documents_list_menu_activate (MainWindow* self, GtkAction* action);
static void _main_window_documents_list_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self);
static void __lambda112__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self);
static void _lambda113_ (MainWindow* self);
static void __lambda113__gtk_notebook_page_reordered (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda114_ (MainWindow* self);
GType completion_provider_get_type (void) G_GNUC_CONST;
CompletionProvider* completion_provider_get_default (void);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void __lambda114__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda115_ (MainWindow* self);
static gboolean __lambda115__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
static void main_window_show_or_hide_build_messages (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
GList* main_window_get_documents (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GList* main_window_get_unsaved_documents (MainWindow* self);
gboolean document_get_modified (Document* self);
GType document_view_get_type (void) G_GNUC_CONST;
GList* main_window_get_views (MainWindow* self);
DocumentView* document_tab_get_view (DocumentTab* self);
static void main_window_configure_recent_chooser (MainWindow* self, GtkRecentChooser* recent_chooser);
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type, MainWindow* main_window);
GType latex_menu_get_type (void) G_GNUC_CONST;
static void _lambda106_ (GtkAction* action, GtkWidget* p, MainWindow* self);
static void main_window_on_menu_item_select (MainWindow* self, GtkItem* proxy);
static void _main_window_on_menu_item_select_gtk_item_select (GtkItem* _sender, gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self, GtkItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_item_deselect (GtkItem* _sender, gpointer self);
static void __lambda106__gtk_ui_manager_connect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self);
static void _lambda107_ (GtkAction* action, GtkWidget* p, MainWindow* self);
static void __lambda107__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self);
void main_window_update_build_tools_menu (MainWindow* self);
void build_view_set_show_errors (BuildView* self, gboolean value);
void build_view_set_show_warnings (BuildView* self, gboolean value);
void build_view_set_show_badboxes (BuildView* self, gboolean value);
BuildView* main_window_get_build_view (MainWindow* self);
CustomStatusbar* main_window_get_statusbar (MainWindow* self);
Symbols* main_window_get_symbols (MainWindow* self);
FileBrowser* main_window_get_file_browser (MainWindow* self);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GList* application_get_windows (Application* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
GFile* document_get_location (Document* self);
void main_window_set_active_tab (MainWindow* self, DocumentTab* value);
DocumentTab* main_window_create_tab_from_location (MainWindow* self, GFile* location, gboolean jump_to);
void document_set_readonly (Document* self, gboolean value);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
static void _lambda35_ (gint response_id, Block6Data* _data6_);
static void __lambda35__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
static DocumentTab* main_window_process_create_tab (MainWindow* self, DocumentTab* tab, gboolean jump_to);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location);
void main_window_create_tab_with_view (MainWindow* self, DocumentView* view);
DocumentTab* document_tab_new_with_view (DocumentView* view);
DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void _lambda27_ (Block7Data* _data7_);
gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close);
static void __lambda27__document_tab_close_document (DocumentTab* _sender, gpointer self);
static void _lambda28_ (Block7Data* _data7_);
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void __lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda29_ (Block7Data* _data7_);
static void __lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda30_ (Block7Data* _data7_);
static void main_window_selection_changed (MainWindow* self);
static void __lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda31_ (Block7Data* _data7_);
static void main_window_sync_name (MainWindow* self, DocumentTab* tab);
static void __lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda32_ (MainWindow* self);
static void __lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda33_ (Block7Data* _data7_);
static void __lambda33__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void _lambda34_ (Block7Data* _data7_);
static void __lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _main_window_update_cursor_position_statusbar_document_cursor_moved (Document* _sender, gpointer self);
void documents_panel_add_tab (DocumentsPanel* self, DocumentTab* tab, gint position, gboolean jump_to);
const gchar* document_tab_get_label_text (DocumentTab* self);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
void documents_panel_remove_tab (DocumentsPanel* self, DocumentTab* tab);
DocumentTab* main_window_get_tab_from_location (MainWindow* self, GFile* location);
gboolean main_window_is_on_workspace_screen (MainWindow* self, GdkScreen* screen, guint workspace);
guint utils_get_window_workspace (GtkWindow* gtkwindow);
#define UTILS_ALL_WORKSPACES ((guint) 0xffffff)
gchar* document_tab_get_name (DocumentTab* self);
gchar* document_tab_get_menu_tip (DocumentTab* self);
Document* main_window_get_active_document (MainWindow* self);
gchar* document_get_short_name_for_display (Document* self);
gchar* utils_str_middle_truncate (const gchar* str, guint max_length);
gchar* utils_get_dirname_for_display (GFile* location);
gboolean document_get_readonly (Document* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
void document_set_location (Document* self, GFile* value);
static gboolean main_window_close_all_documents (MainWindow* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
void dialogs_close_several_unsaved_documents (MainWindow* window, GList* unsaved_docs);
void main_window_remove_all_tabs (MainWindow* self);
DocumentView* main_window_get_active_view (MainWindow* self);
guint document_view_my_get_visual_column (DocumentView* self, GtkTextIter* iter);
static void _lambda105_ (GtkRecentChooser* chooser, MainWindow* self);
static void __lambda105__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender, gpointer self);
void main_window_save_state (MainWindow* self, gboolean sync);
void structure_save_state (Structure* self);
gint side_panel_get_active_component (SidePanel* self);
static void main_window_move_tab_to_new_window (MainWindow* self, DocumentTab* tab);
MainWindow* application_create_window (Application* self, GdkScreen* screen);
static void main_window_build_tools_menu_activate (MainWindow* self, GtkAction* action);
static void _main_window_build_tools_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
gboolean build_tools_is_empty (BuildTools* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeIterator* build_tools_iterator (BuildTools* self);
BuildTool* build_tools_get (BuildTools* self, gint id);
void build_view_show (BuildView* self);
gint document_get_project_id (Document* self);
GList* application_get_documents (Application* self);
GFile* document_get_main_file (Document* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
static void _lambda39_ (MainWindow* self);
void file_browser_refresh_for_document (FileBrowser* self, Document* doc);
static void __lambda39__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self);
GtkAction* main_window_get_action_stop_exec (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
GType templates_get_type (void) G_GNUC_CONST;
Templates* templates_get_default (void);
void templates_show_dialog_new (Templates* self, MainWindow* parent);
static void _g_slist_free__g_object_unref0_ (GSList* self);
void templates_show_dialog_create (Templates* self, MainWindow* parent);
void templates_show_dialog_delete (Templates* self, MainWindow* parent);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
void document_view_cut_selection (DocumentView* self);
void document_view_copy_selection (DocumentView* self);
void document_view_my_paste_clipboard (DocumentView* self);
void document_view_delete_selection (DocumentView* self);
void document_view_my_select_all (DocumentView* self);
void document_comment_selected_lines (Document* self);
void document_uncomment_selected_lines (Document* self);
void preferences_dialog_show_me (MainWindow* parent);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
void document_view_set_font_from_settings (DocumentView* self);
void search_and_replace_show_search (SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
void goto_line_show (GotoLine* self);
void build_tool_runner_abort (BuildToolRunner* self);
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc);
GType clean_build_files_get_type (void) G_GNUC_CONST;
gboolean clean_build_files_clean (CleanBuildFiles* self);
gchar* utils_get_shortname (const gchar* path);
void project_dialogs_new_project (MainWindow* main_window);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
void project_dialogs_manage_projects (MainWindow* main_window);
GType struct_action_get_type (void) G_GNUC_CONST;
void structure_do_action (Structure* self, StructAction action_type);
DocumentTab* documents_panel_get_active_tab (DocumentsPanel* self);
static void main_window_finalize (GObject* obj);
static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_action_entries[55] = {{"File", NULL, "_File"}, {"FileNew", GTK_STOCK_NEW, NULL, NULL, "New file", (GCallback) _main_window_on_file_new_gtk_action_callback}, {"FileNewWindow", NULL, "New _Window", NULL, "Create a new window", (GCallback) _main_window_on_new_window_gtk_action_callback}, {"FileOpen", GTK_STOCK_OPEN, NULL, NULL, "Open a file", (GCallback) _main_window_on_file_open_gtk_action_callback}, {"FileSave", GTK_STOCK_SAVE, NULL, NULL, "Save the current file", (GCallback) _main_window_on_file_save_gtk_action_callback}, {"FileSaveAs", GTK_STOCK_SAVE_AS, NULL, NULL, "Save the current file with a different name", (GCallback) _main_window_on_file_save_as_gtk_action_callback}, {"FileCreateTemplate", NULL, "Create _Template From Document...", NULL, "Create a new template from the current document", (GCallback) _main_window_on_create_template_gtk_action_callback}, {"FileDeleteTemplate", NULL, "_Delete Template...", NULL, "Delete personal template(s)", (GCallback) _main_window_on_delete_template_gtk_action_callback}, {"FileClose", GTK_STOCK_CLOSE, NULL, NULL, "Close the current file", (GCallback) _main_window_on_file_close_gtk_action_callback}, {"FileQuit", GTK_STOCK_QUIT, NULL, NULL, "Quit the program", (GCallback) _main_window_on_quit_gtk_action_callback}, {"Edit", NULL, "_Edit"}, {"EditUndo", GTK_STOCK_UNDO, NULL, "<Control>Z", "Undo the last action", (GCallback) _main_window_on_edit_undo_gtk_action_callback}, {"EditRedo", GTK_STOCK_REDO, NULL, "<Shift><Control>Z", "Redo the last undone action", (GCallback) _main_window_on_edit_redo_gtk_action_callback}, {"EditCut", GTK_STOCK_CUT, NULL, NULL, "Cut the selection", (GCallback) _main_window_on_edit_cut_gtk_action_callback}, {"EditCopy", GTK_STOCK_COPY, NULL, NULL, "Copy the selection", (GCallback) _main_window_on_edit_copy_gtk_action_callback}, {"EditPaste", GTK_STOCK_PASTE, NULL, "", "Paste the clipboard", (GCallback) _main_window_on_edit_paste_gtk_action_callback}, {"EditDelete", GTK_STOCK_DELETE, NULL, NULL, "Delete the selected text", (GCallback) _main_window_on_edit_delete_gtk_action_callback}, {"EditSelectAll", GTK_STOCK_SELECT_ALL, NULL, "<Control>A", "Select the entire document", (GCallback) _main_window_on_edit_select_all_gtk_action_callback}, {"EditComment", NULL, "_Comment", "<Control>M", "Comment the selected lines (add the character \"%\")", (GCallback) _main_window_on_edit_comment_gtk_action_callback}, {"EditUncomment", NULL, "_Uncomment", "<Shift><Control>M", "Uncomment the selected lines (remove the character \"%\")", (GCallback) _main_window_on_edit_uncomment_gtk_action_callback}, {"EditPreferences", GTK_STOCK_PREFERENCES, NULL, NULL, "Configure the application", (GCallback) _main_window_on_open_preferences_gtk_action_callback}, {"View", NULL, "_View"}, {"ViewZoomIn", GTK_STOCK_ZOOM_IN, "Zoom _In", "<Control>plus", "Enlarge the font", (GCallback) _main_window_on_view_zoom_in_gtk_action_callback}, {"ViewZoomOut", GTK_STOCK_ZOOM_OUT, "Zoom _Out", "<Control>minus", "Shrink the font", (GCallback) _main_window_on_view_zoom_out_gtk_action_callback}, {"ViewZoomReset", GTK_STOCK_ZOOM_100, "_Reset Zoom", "<Control>0", "Reset the size of the font", (GCallback) _main_window_on_view_zoom_reset_gtk_action_callback}, {"Search", NULL, "_Search"}, {"SearchFind", GTK_STOCK_FIND, NULL, NULL, "Search for text", (GCallback) _main_window_on_search_find_gtk_action_callback}, {"SearchReplace", GTK_STOCK_FIND_AND_REPLACE, NULL, NULL, "Search for and replace text", (GCallback) _main_window_on_search_replace_gtk_action_callback}, {"SearchGoToLine", GTK_STOCK_JUMP_TO, "_Go to Line...", "<Control>G", "Go to a specific line", (GCallback) _main_window_on_search_goto_line_gtk_action_callback}, {"Build", NULL, "_Build"}, {"BuildClean", GTK_STOCK_CLEAR, "Cleanup Build _Files", NULL, "Clean-up build files (*.aux, *.log, *.out, *.toc, etc)", (GCallback) _main_window_on_build_clean_gtk_action_callback}, {"BuildStopExecution", GTK_STOCK_STOP, "_Stop Execution", "<Release>F12", "Stop Execution", (GCallback) _main_window_on_build_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", "View _Log", NULL, "View Log", (GCallback) _main_window_on_build_view_log_gtk_action_callback}, {"Documents", NULL, "_Documents"}, {"DocumentsSaveAll", GTK_STOCK_SAVE, "_Save All", "<Shift><Control>L", "Save all open files", (GCallback) _main_window_on_documents_save_all_gtk_action_callback}, {"DocumentsCloseAll", GTK_STOCK_CLOSE, "_Close All", "<Shift><Control>W", "Close all open files", (GCallback) _main_window_on_documents_close_all_gtk_action_callback}, {"DocumentsPrevious", GTK_STOCK_GO_BACK, "_Previous Document", "<Control><Alt>Page_Up", "Activate previous document", (GCallback) _main_window_on_documents_previous_gtk_action_callback}, {"DocumentsNext", GTK_STOCK_GO_FORWARD, "_Next Document", "<Control><Alt>Page_Down", "Activate next document", (GCallback) _main_window_on_documents_next_gtk_action_callback}, {"DocumentsMoveToNewWindow", NULL, "_Move to New Window", NULL, "Move the current document to a new window", (GCallback) _main_window_on_documents_move_to_new_window_gtk_action_callback}, {"Projects", NULL, "_Projects"}, {"ProjectsNew", GTK_STOCK_NEW, "_New Project", NULL, "Create a new project", (GCallback) _main_window_on_projects_new_gtk_action_callback}, {"ProjectsConfigCurrent", GTK_STOCK_PROPERTIES, "_Configure Current Project", NULL, "Change the main file of the current project", (GCallback) _main_window_on_projects_config_current_gtk_action_callback}, {"ProjectsManage", GTK_STOCK_PREFERENCES, "_Manage Projects", NULL, "Manage Projects", (GCallback) _main_window_on_projects_manage_gtk_action_callback}, {"Structure", NULL, "S_tructure"}, {"StructureCut", GTK_STOCK_CUT, NULL, "", "Cut the selected structure item", (GCallback) _main_window_on_structure_cut_gtk_action_callback}, {"StructureCopy", GTK_STOCK_COPY, NULL, "", "Copy the selected structure item", (GCallback) _main_window_on_structure_copy_gtk_action_callback}, {"StructureDelete", GTK_STOCK_DELETE, NULL, "", "Delete the selected structure item", (GCallback) _main_window_on_structure_delete_gtk_action_callback}, {"StructureSelect", GTK_STOCK_SELECT_ALL, "_Select", "", "Select the contents of the selected structure item", (GCallback) _main_window_on_structure_select_gtk_action_callback}, {"StructureComment", NULL, "_Comment", NULL, "Comment the selected structure item", (GCallback) _main_window_on_structure_comment_gtk_action_callback}, {"StructureShiftLeft", GTK_STOCK_GO_BACK, "Shift _Left", "", "Shift the selected structure item to the left (e.g. section → chapter)", (GCallback) _main_window_on_structure_shift_left_gtk_action_callback}, {"StructureShiftRight", GTK_STOCK_GO_FORWARD, "Shift _Right", "", "Shift the selected structure item to the right (e.g. chapter → section" \
")", (GCallback) _main_window_on_structure_shift_right_gtk_action_callback}, {"Help", NULL, "_Help"}, {"HelpContents", GTK_STOCK_HELP, "_Contents", "<Release>F1", "Open the LaTeXila documentation", (GCallback) _main_window_on_help_contents_gtk_action_callback}, {"HelpLatexReference", NULL, "_LaTeX Reference", NULL, "The Kile LaTeX Reference", (GCallback) _main_window_on_help_latex_reference_gtk_action_callback}, {"HelpAbout", GTK_STOCK_ABOUT, NULL, NULL, "About LaTeXila", (GCallback) _main_window_on_about_dialog_gtk_action_callback}};
static const GtkToggleActionEntry MAIN_WINDOW_toggle_action_entries[7] = {{"ViewMainToolbar", NULL, "_Main Toolbar", NULL, "Show or hide the main toolbar", (GCallback) _main_window_on_show_main_toolbar_gtk_action_callback}, {"ViewEditToolbar", NULL, "_Edit Toolbar", NULL, "Show or hide the edit toolbar", (GCallback) _main_window_on_show_edit_toolbar_gtk_action_callback}, {"ViewSidePanel", NULL, "_Side panel", NULL, "Show or hide the side panel", (GCallback) _main_window_on_show_side_panel_gtk_action_callback}, {"ViewBottomPanel", NULL, "_Bottom panel", NULL, "Show or hide the bottom panel", (GCallback) _main_window_on_show_bottom_panel_gtk_action_callback}, {"BuildShowErrors", GTK_STOCK_DIALOG_ERROR, "Show _Errors", NULL, "Show Errors", (GCallback) _main_window_on_build_show_errors_gtk_action_callback}, {"BuildShowWarnings", GTK_STOCK_DIALOG_WARNING, "Show _Warnings", NULL, "Show Warnings", (GCallback) _main_window_on_build_show_warnings_gtk_action_callback}, {"BuildShowBadBoxes", "badbox", "Show _Bad Boxes", NULL, "Show Bad Boxes", (GCallback) _main_window_on_build_show_badboxes_gtk_action_callback}};

static void _main_window_on_file_new_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_new (self);
}


static void _main_window_on_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_new_window (self);
}


static void _main_window_on_file_open_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_open (self);
}


static void _main_window_on_file_save_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_save (self);
}


static void _main_window_on_file_save_as_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_save_as (self);
}


static void _main_window_on_create_template_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_create_template (self);
}


static void _main_window_on_delete_template_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_delete_template (self);
}


static void _main_window_on_file_close_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_file_close (self);
}


static void _main_window_on_quit_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_quit (self);
}


static void _main_window_on_edit_undo_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_undo (self);
}


static void _main_window_on_edit_redo_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_redo (self);
}


static void _main_window_on_edit_cut_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_cut (self);
}


static void _main_window_on_edit_copy_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_copy (self);
}


static void _main_window_on_edit_paste_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_paste (self);
}


static void _main_window_on_edit_delete_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_delete (self);
}


static void _main_window_on_edit_select_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_select_all (self);
}


static void _main_window_on_edit_comment_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_comment (self);
}


static void _main_window_on_edit_uncomment_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_edit_uncomment (self);
}


static void _main_window_on_open_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_open_preferences (self);
}


static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_in (self);
}


static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_out (self);
}


static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_reset (self);
}


static void _main_window_on_search_find_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_find (self);
}


static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_replace (self);
}


static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_goto_line (self);
}


static void _main_window_on_build_clean_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_clean (self);
}


static void _main_window_on_build_stop_execution_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_stop_execution (self);
}


static void _main_window_on_build_view_log_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_view_log (self);
}


static void _main_window_on_documents_save_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_save_all (self);
}


static void _main_window_on_documents_close_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_close_all (self);
}


static void _main_window_on_documents_previous_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_previous (self);
}


static void _main_window_on_documents_next_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_next (self);
}


static void _main_window_on_documents_move_to_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_documents_move_to_new_window (self);
}


static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_new (self);
}


static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_config_current (self);
}


static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_manage (self);
}


static void _main_window_on_structure_cut_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_cut (self);
}


static void _main_window_on_structure_copy_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_copy (self);
}


static void _main_window_on_structure_delete_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_delete (self);
}


static void _main_window_on_structure_select_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_select (self);
}


static void _main_window_on_structure_comment_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_comment (self);
}


static void _main_window_on_structure_shift_left_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_shift_left (self);
}


static void _main_window_on_structure_shift_right_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_structure_shift_right (self);
}


static void _main_window_on_help_contents_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_help_contents (self);
}


static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_help_latex_reference (self);
}


static void _main_window_on_about_dialog_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_about_dialog (self);
}


static void _main_window_on_show_main_toolbar_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_main_toolbar (self, action);
}


static void _main_window_on_show_edit_toolbar_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_edit_toolbar (self, action);
}


static void _main_window_on_show_side_panel_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_side_panel (self, action);
}


static void _main_window_on_show_bottom_panel_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_show_bottom_panel (self, action);
}


static void _main_window_on_build_show_errors_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_show_errors (self, action);
}


static void _main_window_on_build_show_warnings_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_show_warnings (self, action);
}


static void _main_window_on_build_show_badboxes_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_build_show_badboxes (self, action);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda108_ (GdkEventButton* event, MainWindow* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkMenu* _tmp1_;
	GtkMenu* popup_menu;
	_tmp0_ = gtk_ui_manager_get_widget (self->priv->ui_manager, "/NotebookPopup");
	_tmp1_ = _g_object_ref0 (GTK_MENU (_tmp0_));
	popup_menu = _tmp1_;
	gtk_menu_popup (popup_menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
	_g_object_unref0 (popup_menu);
}


static void __lambda108__documents_panel_right_click (DocumentsPanel* _sender, GdkEventButton* event, gpointer self) {
	_lambda108_ (event, self);
}


static gboolean _lambda109_ (MainWindow* self) {
	gboolean result = FALSE;
	main_window_on_quit (self);
	result = TRUE;
	return result;
}


static gboolean __lambda109__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = _lambda109_ (self);
	return result;
}


static void _lambda110_ (MainWindow* self) {
	gint _tmp0_;
	gint nb_pages;
	_tmp0_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	nb_pages = _tmp0_;
	if (nb_pages == 1) {
		main_window_set_file_actions_sensitivity (self, TRUE);
	} else {
		if (nb_pages == 2) {
			main_window_set_documents_move_to_new_window_sensitivity (self, TRUE);
		}
	}
	main_window_update_documents_list_menu (self);
}


static void __lambda110__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda110_ (self);
}


static void _lambda111_ (MainWindow* self) {
	gint _tmp0_;
	gint nb_pages;
	_tmp0_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	nb_pages = _tmp0_;
	if (nb_pages == 0) {
		custom_statusbar_set_cursor_position (self->priv->statusbar, -1, -1);
		main_window_set_file_actions_sensitivity (self, FALSE);
		gtk_widget_hide ((GtkWidget*) self->priv->goto_line);
		search_and_replace_hide (self->priv->search_and_replace);
		g_object_notify ((GObject*) self, "active-tab");
		g_object_notify ((GObject*) self, "active-document");
		g_object_notify ((GObject*) self, "active-view");
	} else {
		if (nb_pages == 1) {
			main_window_set_documents_move_to_new_window_sensitivity (self, FALSE);
		}
	}
	main_window_my_set_title (self);
	main_window_update_documents_list_menu (self);
}


static void __lambda111__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda111_ (self);
}


static void _main_window_documents_list_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_documents_list_menu_activate (self, _sender);
}


static void _lambda112_ (GtkNotebookPage* pg, guint page_num, MainWindow* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* action_name;
	GtkAction* _tmp4_ = NULL;
	GtkRadioAction* _tmp5_;
	GtkRadioAction* action;
	g_return_if_fail (pg != NULL);
	main_window_set_undo_sensitivity (self);
	main_window_set_redo_sensitivity (self);
	main_window_update_next_prev_doc_sensitivity (self);
	main_window_update_build_tools_sensitivity (self);
	main_window_update_config_project_sensitivity (self);
	main_window_my_set_title (self);
	main_window_update_cursor_position_statusbar (self);
	_tmp0_ = g_strdup_printf ("%u", page_num);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Tab_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	action_name = _tmp3_;
	_tmp4_ = gtk_action_group_get_action (self->priv->documents_list_action_group, action_name);
	_tmp5_ = _g_object_ref0 (GTK_RADIO_ACTION (_tmp4_));
	action = _tmp5_;
	if (action != NULL) {
		guint _tmp6_;
		g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkAction*) action, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _main_window_documents_list_menu_activate_gtk_action_activate, self);
		gtk_toggle_action_set_active ((GtkToggleAction*) action, TRUE);
		g_signal_connect_object ((GtkAction*) action, "activate", (GCallback) _main_window_documents_list_menu_activate_gtk_action_activate, self, 0);
	}
	g_object_notify ((GObject*) self, "active-tab");
	g_object_notify ((GObject*) self, "active-document");
	g_object_notify ((GObject*) self, "active-view");
	_g_object_unref0 (action);
	_g_free0 (action_name);
}


static void __lambda112__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self) {
	_lambda112_ (page, page_num, self);
}


static void _lambda113_ (MainWindow* self) {
	main_window_update_next_prev_doc_sensitivity (self);
	main_window_update_documents_list_menu (self);
}


static void __lambda113__gtk_notebook_page_reordered (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda113_ (self);
}


static void _lambda114_ (MainWindow* self) {
	CompletionProvider* _tmp0_ = NULL;
	CompletionProvider* provider;
	_tmp0_ = completion_provider_get_default ();
	provider = _tmp0_;
	completion_provider_hide_calltip_window (provider);
	_g_object_unref0 (provider);
}


static void __lambda114__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda114_ (self);
}


static gboolean _lambda115_ (MainWindow* self) {
	gboolean result = FALSE;
	CompletionProvider* _tmp0_ = NULL;
	CompletionProvider* provider;
	_tmp0_ = completion_provider_get_default ();
	provider = _tmp0_;
	completion_provider_hide_calltip_window (provider);
	result = FALSE;
	_g_object_unref0 (provider);
	return result;
}


static gboolean __lambda115__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda115_ (self);
	return result;
}


MainWindow* main_window_construct (GType object_type) {
	MainWindow * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	gint w = 0;
	gint h = 0;
	gint _tmp1_;
	GdkWindowState state;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GtkWidget* menu;
	GtkWidget* _tmp4_ = NULL;
	GtkToolbar* _tmp5_;
	GtkWidget* _tmp6_ = NULL;
	GtkToolbar* _tmp7_;
	GtkWidget* _tmp8_ = NULL;
	GtkToolbar* _tmp9_;
	GtkToolbar* build_toolbar;
	DocumentsPanel* _tmp10_ = NULL;
	CustomStatusbar* _tmp11_ = NULL;
	guint _tmp12_;
	GotoLine* _tmp13_ = NULL;
	SearchAndReplace* _tmp14_ = NULL;
	GtkAction* _tmp15_ = NULL;
	GtkAction* _tmp16_;
	GtkAction* _tmp17_ = NULL;
	GtkToggleAction* _tmp18_;
	GtkToggleAction* action_view_bottom_panel;
	BuildView* _tmp19_ = NULL;
	GtkAction* _tmp20_ = NULL;
	GtkToggleAction* _tmp21_;
	GtkToggleAction* action_view_side_panel;
	SidePanel* _tmp22_ = NULL;
	Symbols* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	FileBrowser* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	Structure* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GtkVBox* _tmp29_ = NULL;
	GtkVBox* main_vbox;
	GtkHPaned* _tmp30_ = NULL;
	gint _tmp31_;
	GtkVBox* _tmp32_ = NULL;
	GtkVBox* vbox_source_view;
	GtkWidget* _tmp33_ = NULL;
	GtkWidget* _tmp34_;
	GtkVPaned* _tmp35_ = NULL;
	gint _tmp36_;
	self = (MainWindow*) g_object_new (object_type, NULL);
	gtk_window_set_title ((GtkWindow*) self, "LaTeXila");
	_tmp0_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp0_;
	g_settings_get (settings, "size", "(ii)", &w, &h);
	gtk_window_set_default_size ((GtkWindow*) self, w, h);
	_tmp1_ = g_settings_get_int (settings, "state");
	state = (GdkWindowState) _tmp1_;
	if ((state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gtk_window_unmaximize ((GtkWindow*) self);
	}
	if ((state & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	main_window_initialize_menubar_and_toolbar (self);
	_tmp2_ = gtk_ui_manager_get_widget (self->priv->ui_manager, "/MainMenu");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	menu = _tmp3_;
	_tmp4_ = gtk_ui_manager_get_widget (self->priv->ui_manager, "/MainToolbar");
	_tmp5_ = _g_object_ref0 (GTK_TOOLBAR (_tmp4_));
	_g_object_unref0 (self->priv->main_toolbar);
	self->priv->main_toolbar = _tmp5_;
	gtk_toolbar_set_style (self->priv->main_toolbar, GTK_TOOLBAR_ICONS);
	main_window_setup_toolbar_open_button (self, self->priv->main_toolbar);
	_tmp6_ = gtk_ui_manager_get_widget (self->priv->ui_manager, "/EditToolbar");
	_tmp7_ = _g_object_ref0 (GTK_TOOLBAR (_tmp6_));
	_g_object_unref0 (self->priv->edit_toolbar);
	self->priv->edit_toolbar = _tmp7_;
	gtk_toolbar_set_style (self->priv->edit_toolbar, GTK_TOOLBAR_ICONS);
	_tmp8_ = gtk_ui_manager_get_widget (self->priv->ui_manager, "/BuildToolbar");
	_tmp9_ = _g_object_ref0 (GTK_TOOLBAR (_tmp8_));
	build_toolbar = _tmp9_;
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
	_tmp10_ = documents_panel_new (self);
	_g_object_unref0 (self->priv->documents_panel);
	self->priv->documents_panel = g_object_ref_sink (_tmp10_);
	g_signal_connect_object (self->priv->documents_panel, "right-click", (GCallback) __lambda108__documents_panel_right_click, self, 0);
	_tmp11_ = custom_statusbar_new ();
	_g_object_unref0 (self->priv->statusbar);
	self->priv->statusbar = g_object_ref_sink (_tmp11_);
	_tmp12_ = gtk_statusbar_get_context_id ((GtkStatusbar*) self->priv->statusbar, "tip_message");
	self->priv->tip_message_cid = _tmp12_;
	_tmp13_ = goto_line_new (self);
	_g_object_unref0 (self->priv->goto_line);
	self->priv->goto_line = g_object_ref_sink (_tmp13_);
	_tmp14_ = search_and_replace_new (self);
	_g_object_unref0 (self->priv->search_and_replace);
	self->priv->search_and_replace = _tmp14_;
	_tmp15_ = gtk_action_group_get_action (self->priv->action_group, "BuildStopExecution");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->action_stop_exec);
	self->priv->action_stop_exec = _tmp16_;
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
	_tmp17_ = gtk_action_group_get_action (self->priv->action_group, "ViewBottomPanel");
	_tmp18_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp17_));
	action_view_bottom_panel = _tmp18_;
	_tmp19_ = build_view_new (self, build_toolbar, action_view_bottom_panel);
	_g_object_unref0 (self->priv->build_view);
	self->priv->build_view = g_object_ref_sink (_tmp19_);
	_tmp20_ = gtk_action_group_get_action (self->priv->action_group, "ViewSidePanel");
	_tmp21_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp20_));
	action_view_side_panel = _tmp21_;
	_tmp22_ = side_panel_new (self, action_view_side_panel);
	_g_object_unref0 (self->priv->side_panel);
	self->priv->side_panel = g_object_ref_sink (_tmp22_);
	_tmp23_ = symbols_new (self);
	_g_object_unref0 (self->priv->symbols);
	self->priv->symbols = g_object_ref_sink (_tmp23_);
	_tmp24_ = _ ("Symbols");
	side_panel_add_component (self->priv->side_panel, _tmp24_, "symbol_alpha", (GtkVBox*) self->priv->symbols);
	_tmp25_ = file_browser_new (self);
	_g_object_unref0 (self->priv->file_browser);
	self->priv->file_browser = g_object_ref_sink (_tmp25_);
	_tmp26_ = _ ("File Browser");
	side_panel_add_component (self->priv->side_panel, _tmp26_, GTK_STOCK_OPEN, (GtkVBox*) self->priv->file_browser);
	_tmp27_ = structure_new (self, self->priv->ui_manager);
	_g_object_unref0 (self->priv->_structure);
	self->priv->_structure = g_object_ref_sink (_tmp27_);
	_tmp28_ = _ ("Structure");
	side_panel_add_component (self->priv->side_panel, _tmp28_, GTK_STOCK_INDEX, (GtkVBox*) self->priv->_structure);
	side_panel_restore_state (self->priv->side_panel);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda109__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "page-added", (GCallback) __lambda110__gtk_notebook_page_added, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "page-removed", (GCallback) __lambda111__gtk_notebook_page_removed, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "switch-page", (GCallback) __lambda112__gtk_notebook_switch_page, self, 0);
	g_signal_connect_object ((GtkNotebook*) self->priv->documents_panel, "page-reordered", (GCallback) __lambda113__gtk_notebook_page_reordered, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::active-tab", (GCallback) __lambda114__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __lambda115__gtk_widget_focus_out_event, self, 0);
	main_window_set_file_actions_sensitivity (self, FALSE);
	main_window_set_documents_move_to_new_window_sensitivity (self, FALSE);
	_tmp29_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	main_vbox = g_object_ref_sink (_tmp29_);
	gtk_box_pack_start ((GtkBox*) main_vbox, menu, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) self->priv->main_toolbar, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) self->priv->edit_toolbar, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) main_vbox);
	gtk_widget_show_all (menu);
	gtk_widget_show_all ((GtkWidget*) self->priv->main_toolbar);
	_tmp30_ = (GtkHPaned*) gtk_hpaned_new ();
	_g_object_unref0 (self->priv->main_hpaned);
	self->priv->main_hpaned = g_object_ref_sink (_tmp30_);
	_tmp31_ = g_settings_get_int (settings, "side-panel-size");
	gtk_paned_set_position ((GtkPaned*) self->priv->main_hpaned, _tmp31_);
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) self->priv->main_hpaned, TRUE, TRUE, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->main_hpaned);
	_tmp32_ = (GtkVBox*) gtk_vbox_new (FALSE, 2);
	vbox_source_view = g_object_ref_sink (_tmp32_);
	gtk_box_pack_start ((GtkBox*) vbox_source_view, (GtkWidget*) self->priv->documents_panel, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox_source_view, (GtkWidget*) self->priv->goto_line, FALSE, FALSE, (guint) 0);
	_tmp33_ = search_and_replace_get_widget (self->priv->search_and_replace);
	_tmp34_ = _tmp33_;
	gtk_box_pack_start ((GtkBox*) vbox_source_view, _tmp34_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp34_);
	gtk_widget_show ((GtkWidget*) vbox_source_view);
	gtk_widget_show_all ((GtkWidget*) self->priv->documents_panel);
	_tmp35_ = (GtkVPaned*) gtk_vpaned_new ();
	_g_object_unref0 (self->priv->vpaned);
	self->priv->vpaned = g_object_ref_sink (_tmp35_);
	_tmp36_ = g_settings_get_int (settings, "vertical-paned-position");
	gtk_paned_set_position ((GtkPaned*) self->priv->vpaned, _tmp36_);
	gtk_paned_pack1 ((GtkPaned*) self->priv->vpaned, (GtkWidget*) vbox_source_view, TRUE, TRUE);
	gtk_paned_pack2 ((GtkPaned*) self->priv->vpaned, (GtkWidget*) self->priv->build_view, FALSE, TRUE);
	gtk_paned_add1 ((GtkPaned*) self->priv->main_hpaned, (GtkWidget*) self->priv->side_panel);
	gtk_paned_add2 ((GtkPaned*) self->priv->main_hpaned, (GtkWidget*) self->priv->vpaned);
	gtk_widget_show ((GtkWidget*) self->priv->side_panel);
	gtk_widget_show ((GtkWidget*) self->priv->vpaned);
	gtk_box_pack_end ((GtkBox*) main_vbox, (GtkWidget*) self->priv->statusbar, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->statusbar);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vbox);
	gtk_widget_show ((GtkWidget*) self);
	main_window_show_or_hide_widgets (self);
	main_window_show_or_hide_build_messages (self);
	_g_object_unref0 (vbox_source_view);
	_g_object_unref0 (main_vbox);
	_g_object_unref0 (action_view_side_panel);
	_g_object_unref0 (action_view_bottom_panel);
	_g_object_unref0 (build_toolbar);
	_g_object_unref0 (menu);
	_g_object_unref0 (settings);
	return self;
}


MainWindow* main_window_new (void) {
	return main_window_construct (TYPE_MAIN_WINDOW);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* main_window_get_documents (MainWindow* self) {
	GList* result = NULL;
	GList* res;
	gint _tmp0_;
	gint nb;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	_tmp0_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	nb = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp2_ = NULL;
				DocumentTab* _tmp3_;
				DocumentTab* tab;
				Document* _tmp4_ = NULL;
				Document* _tmp5_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < nb)) {
					break;
				}
				_tmp2_ = gtk_notebook_get_nth_page ((GtkNotebook*) self->priv->documents_panel, i);
				_tmp3_ = _g_object_ref0 (DOCUMENT_TAB (_tmp2_));
				tab = _tmp3_;
				_tmp4_ = document_tab_get_document (tab);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				res = g_list_append (res, _tmp5_);
				_g_object_unref0 (tab);
			}
		}
	}
	result = res;
	return result;
}


GList* main_window_get_unsaved_documents (MainWindow* self) {
	GList* result = NULL;
	GList* list;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	_tmp0_ = main_window_get_documents (self);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp0_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp1_;
			Document* doc;
			_tmp1_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp1_;
			{
				gboolean _tmp2_;
				_tmp2_ = document_get_modified (doc);
				if (_tmp2_) {
					Document* _tmp3_;
					_tmp3_ = _g_object_ref0 (doc);
					list = g_list_append (list, _tmp3_);
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
	result = list;
	return result;
}


GList* main_window_get_views (MainWindow* self) {
	GList* result = NULL;
	GList* res;
	gint _tmp0_;
	gint nb;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	_tmp0_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	nb = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp2_ = NULL;
				DocumentTab* _tmp3_;
				DocumentTab* tab;
				DocumentView* _tmp4_ = NULL;
				DocumentView* _tmp5_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < nb)) {
					break;
				}
				_tmp2_ = gtk_notebook_get_nth_page ((GtkNotebook*) self->priv->documents_panel, i);
				_tmp3_ = _g_object_ref0 (DOCUMENT_TAB (_tmp2_));
				tab = _tmp3_;
				_tmp4_ = document_tab_get_view (tab);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				res = g_list_append (res, _tmp5_);
				_g_object_unref0 (tab);
			}
		}
	}
	result = res;
	return result;
}


static void _main_window_on_menu_item_select_gtk_item_select (GtkItem* _sender, gpointer self) {
	main_window_on_menu_item_select (self, _sender);
}


static void _main_window_on_menu_item_deselect_gtk_item_deselect (GtkItem* _sender, gpointer self) {
	main_window_on_menu_item_deselect (self, _sender);
}


static void _lambda106_ (GtkAction* action, GtkWidget* p, MainWindow* self) {
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	if (GTK_IS_MENU_ITEM (p)) {
		GtkMenuItem* _tmp0_;
		GtkMenuItem* proxy;
		_tmp0_ = _g_object_ref0 (GTK_MENU_ITEM (p));
		proxy = _tmp0_;
		g_signal_connect_object ((GtkItem*) proxy, "select", (GCallback) _main_window_on_menu_item_select_gtk_item_select, self, 0);
		g_signal_connect_object ((GtkItem*) proxy, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_item_deselect, self, 0);
		_g_object_unref0 (proxy);
	}
}


static void __lambda106__gtk_ui_manager_connect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self) {
	_lambda106_ (action, proxy, self);
}


static void _lambda107_ (GtkAction* action, GtkWidget* p, MainWindow* self) {
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	if (GTK_IS_MENU_ITEM (p)) {
		GtkMenuItem* _tmp0_;
		GtkMenuItem* proxy;
		guint _tmp1_;
		guint _tmp2_;
		_tmp0_ = _g_object_ref0 (GTK_MENU_ITEM (p));
		proxy = _tmp0_;
		g_signal_parse_name ("select", GTK_TYPE_ITEM, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkItem*) proxy, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_item_select, self);
		g_signal_parse_name ("deselect", GTK_TYPE_ITEM, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkItem*) proxy, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_item_deselect, self);
		_g_object_unref0 (proxy);
	}
}


static void __lambda107__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self) {
	_lambda107_ (action, proxy, self);
}


static void main_window_initialize_menubar_and_toolbar (MainWindow* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRecentAction* _tmp2_ = NULL;
	GtkAction* recent_action;
	GtkActionGroup* _tmp3_ = NULL;
	LatexMenu* _tmp4_ = NULL;
	GtkUIManager* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* path;
	GtkAccelGroup* _tmp7_ = NULL;
	GtkActionGroup* _tmp8_ = NULL;
	GtkActionGroup* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Open _Recent");
	_tmp1_ = _ ("Open recently used files");
	_tmp2_ = (GtkRecentAction*) gtk_recent_action_new ("FileOpenRecent", _tmp0_, _tmp1_, "");
	recent_action = (GtkAction*) _tmp2_;
	main_window_configure_recent_chooser (self, GTK_RECENT_CHOOSER (recent_action));
	_tmp3_ = gtk_action_group_new ("ActionGroup");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp3_;
	gtk_action_group_set_translation_domain (self->priv->action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (self->priv->action_group, MAIN_WINDOW_action_entries, G_N_ELEMENTS (MAIN_WINDOW_action_entries), self);
	gtk_action_group_add_action (self->priv->action_group, recent_action);
	gtk_action_group_add_toggle_actions (self->priv->action_group, MAIN_WINDOW_toggle_action_entries, G_N_ELEMENTS (MAIN_WINDOW_toggle_action_entries), self);
	_tmp4_ = latex_menu_new (self);
	_g_object_unref0 (self->priv->latex_action_group);
	self->priv->latex_action_group = (GtkActionGroup*) _tmp4_;
	_tmp5_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui_manager);
	self->priv->ui_manager = _tmp5_;
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->action_group, 0);
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->latex_action_group, 0);
	_tmp6_ = g_build_filename (DATA_DIR, "ui", "ui.xml", NULL);
	path = _tmp6_;
	gtk_ui_manager_add_ui_from_file (self->priv->ui_manager, path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		goto __catch17_g_error;
	}
	_g_free0 (path);
	goto __finally17;
	__catch17_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_error ("main_window.vala:541: %s", err->message);
		_g_error_free0 (err);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (recent_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = gtk_ui_manager_get_accel_group (self->priv->ui_manager);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp7_);
	g_signal_connect_object (self->priv->ui_manager, "connect-proxy", (GCallback) __lambda106__gtk_ui_manager_connect_proxy, self, 0);
	g_signal_connect_object (self->priv->ui_manager, "disconnect-proxy", (GCallback) __lambda107__gtk_ui_manager_disconnect_proxy, self, 0);
	_tmp8_ = gtk_action_group_new ("DocumentsListActions");
	_g_object_unref0 (self->priv->documents_list_action_group);
	self->priv->documents_list_action_group = _tmp8_;
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->documents_list_action_group, 0);
	_tmp9_ = gtk_action_group_new ("BuildToolsActions");
	_g_object_unref0 (self->priv->build_tools_action_group);
	self->priv->build_tools_action_group = _tmp9_;
	gtk_ui_manager_insert_action_group (self->priv->ui_manager, self->priv->build_tools_action_group, 0);
	main_window_update_build_tools_menu (self);
	_g_object_unref0 (recent_action);
}


static void main_window_on_menu_item_select (MainWindow* self, GtkItem* proxy) {
	GtkAction* _tmp0_ = NULL;
	GtkAction* _tmp1_;
	GtkAction* action;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	_tmp0_ = gtk_activatable_get_related_action ((GtkActivatable*) GTK_MENU_ITEM (proxy));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	action = _tmp1_;
	g_return_if_fail (action != NULL);
	_tmp2_ = gtk_action_get_tooltip (action);
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = gtk_action_get_tooltip (action);
		gtk_statusbar_push ((GtkStatusbar*) self->priv->statusbar, self->priv->tip_message_cid, _tmp3_);
	}
	_g_object_unref0 (action);
}


static void main_window_on_menu_item_deselect (MainWindow* self, GtkItem* proxy) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	gtk_statusbar_pop ((GtkStatusbar*) self->priv->statusbar, self->priv->tip_message_cid);
}


static void main_window_show_or_hide_widgets (MainWindow* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	gboolean _tmp1_;
	gboolean show;
	GtkAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* action;
	gboolean _tmp4_;
	GtkAction* _tmp5_ = NULL;
	GtkToggleAction* _tmp6_;
	gboolean _tmp7_;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_;
	gboolean _tmp10_;
	GtkAction* _tmp11_ = NULL;
	GtkToggleAction* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = g_settings_get_boolean (settings, "main-toolbar-visible");
	show = _tmp1_;
	gtk_widget_set_visible ((GtkWidget*) self->priv->main_toolbar, show);
	_tmp2_ = gtk_action_group_get_action (self->priv->action_group, "ViewMainToolbar");
	_tmp3_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp2_));
	action = _tmp3_;
	gtk_toggle_action_set_active (action, show);
	_tmp4_ = g_settings_get_boolean (settings, "edit-toolbar-visible");
	show = _tmp4_;
	if (!show) {
		gtk_widget_hide ((GtkWidget*) self->priv->edit_toolbar);
	}
	_tmp5_ = gtk_action_group_get_action (self->priv->action_group, "ViewEditToolbar");
	_tmp6_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp5_));
	_g_object_unref0 (action);
	action = _tmp6_;
	gtk_toggle_action_set_active (action, show);
	_tmp7_ = g_settings_get_boolean (settings, "side-panel-visible");
	show = _tmp7_;
	if (!show) {
		gtk_widget_hide ((GtkWidget*) self->priv->side_panel);
	}
	_tmp8_ = gtk_action_group_get_action (self->priv->action_group, "ViewSidePanel");
	_tmp9_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp8_));
	_g_object_unref0 (action);
	action = _tmp9_;
	gtk_toggle_action_set_active (action, show);
	_tmp10_ = g_settings_get_boolean (settings, "bottom-panel-visible");
	show = _tmp10_;
	if (!show) {
		gtk_widget_hide ((GtkWidget*) self->priv->build_view);
	}
	_tmp11_ = gtk_action_group_get_action (self->priv->action_group, "ViewBottomPanel");
	_tmp12_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp11_));
	_g_object_unref0 (action);
	action = _tmp12_;
	gtk_toggle_action_set_active (action, show);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


static void main_window_show_or_hide_build_messages (MainWindow* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	gboolean _tmp1_;
	gboolean show_errors;
	gboolean _tmp2_;
	gboolean show_warnings;
	gboolean _tmp3_;
	gboolean show_badboxes;
	GtkAction* _tmp4_ = NULL;
	GtkToggleAction* _tmp5_;
	GtkToggleAction* action;
	GtkAction* _tmp6_ = NULL;
	GtkToggleAction* _tmp7_;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = g_settings_get_boolean (settings, "show-build-errors");
	show_errors = _tmp1_;
	_tmp2_ = g_settings_get_boolean (settings, "show-build-warnings");
	show_warnings = _tmp2_;
	_tmp3_ = g_settings_get_boolean (settings, "show-build-badboxes");
	show_badboxes = _tmp3_;
	build_view_set_show_errors (self->priv->build_view, show_errors);
	build_view_set_show_warnings (self->priv->build_view, show_warnings);
	build_view_set_show_badboxes (self->priv->build_view, show_badboxes);
	_tmp4_ = gtk_action_group_get_action (self->priv->action_group, "BuildShowErrors");
	_tmp5_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp4_));
	action = _tmp5_;
	gtk_toggle_action_set_active (action, show_errors);
	_tmp6_ = gtk_action_group_get_action (self->priv->action_group, "BuildShowWarnings");
	_tmp7_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp6_));
	_g_object_unref0 (action);
	action = _tmp7_;
	gtk_toggle_action_set_active (action, show_warnings);
	_tmp8_ = gtk_action_group_get_action (self->priv->action_group, "BuildShowBadBoxes");
	_tmp9_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp8_));
	_g_object_unref0 (action);
	action = _tmp9_;
	gtk_toggle_action_set_active (action, show_badboxes);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


BuildView* main_window_get_build_view (MainWindow* self) {
	BuildView* result = NULL;
	BuildView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->build_view);
	result = _tmp0_;
	return result;
}


CustomStatusbar* main_window_get_statusbar (MainWindow* self) {
	CustomStatusbar* result = NULL;
	CustomStatusbar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->statusbar);
	result = _tmp0_;
	return result;
}


Symbols* main_window_get_symbols (MainWindow* self) {
	Symbols* result = NULL;
	Symbols* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->symbols);
	result = _tmp0_;
	return result;
}


FileBrowser* main_window_get_file_browser (MainWindow* self) {
	FileBrowser* result = NULL;
	FileBrowser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->file_browser);
	result = _tmp0_;
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->infobar);
		_g_object_unref0 (_data6_->tab);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda35_ (gint response_id, Block6Data* _data6_) {
	MainWindow * self;
	DocumentView* _tmp1_ = NULL;
	self = _data6_->self;
	if (response_id == GTK_RESPONSE_YES) {
		Document* _tmp0_ = NULL;
		_tmp0_ = document_tab_get_document (_data6_->tab);
		document_set_readonly (_tmp0_, FALSE);
	}
	gtk_object_destroy ((GtkObject*) _data6_->infobar);
	_tmp1_ = document_tab_get_view (_data6_->tab);
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


static void __lambda35__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda35_ (response_id, self);
}


DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to) {
	DocumentTab* result = NULL;
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	DocumentTab* _tmp25_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_windows (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* w_collection;
		GList* w_it;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MainWindow* _tmp4_;
			MainWindow* w;
			_tmp4_ = _g_object_ref0 ((MainWindow*) w_it->data);
			w = _tmp4_;
			{
				GList* _tmp5_ = NULL;
				_tmp5_ = main_window_get_documents (w);
				{
					GList* doc_collection;
					GList* doc_it;
					doc_collection = _tmp5_;
					for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
						Document* _tmp6_;
						Document* doc;
						_tmp6_ = _g_object_ref0 ((Document*) doc_it->data);
						doc = _tmp6_;
						{
							Block6Data* _data6_;
							gboolean _tmp7_ = FALSE;
							GFile* _tmp8_ = NULL;
							DocumentTab* _tmp12_ = NULL;
							Document* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							gchar* _tmp15_ = NULL;
							gchar* _tmp16_;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_;
							gchar* primary_msg;
							const gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* secondary_msg;
							TabInfoBar* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							const gchar* _tmp23_ = NULL;
							DocumentTab* _tmp24_;
							_data6_ = g_slice_new0 (Block6Data);
							_data6_->_ref_count_ = 1;
							_data6_->self = g_object_ref (self);
							_tmp8_ = document_get_location (doc);
							if (_tmp8_ == NULL) {
								_tmp7_ = TRUE;
							} else {
								GFile* _tmp9_ = NULL;
								gboolean _tmp10_;
								_tmp9_ = document_get_location (doc);
								_tmp10_ = g_file_equal (location, _tmp9_);
								_tmp7_ = !_tmp10_;
							}
							if (_tmp7_) {
								_g_object_unref0 (doc);
								block6_data_unref (_data6_);
								_data6_ = NULL;
								continue;
							}
							if (self == w) {
								DocumentTab* _tmp11_;
								if (jump_to) {
									main_window_set_active_tab (self, doc->tab);
								}
								_tmp11_ = _g_object_ref0 (doc->tab);
								result = _tmp11_;
								_g_object_unref0 (doc);
								block6_data_unref (_data6_);
								_data6_ = NULL;
								__g_list_free__g_object_unref0_0 (doc_collection);
								_g_object_unref0 (w);
								return result;
							}
							_tmp12_ = main_window_create_tab_from_location (self, location, jump_to);
							_data6_->tab = _tmp12_;
							_tmp13_ = document_tab_get_document (_data6_->tab);
							document_set_readonly (_tmp13_, TRUE);
							_tmp14_ = _ ("This file (%s) is already opened in another LaTeXila window.");
							_tmp15_ = g_file_get_parse_name (location);
							_tmp16_ = _tmp15_;
							_tmp17_ = g_strdup_printf (_tmp14_, _tmp16_);
							_tmp18_ = _tmp17_;
							_g_free0 (_tmp16_);
							primary_msg = _tmp18_;
							_tmp19_ = _ ("LaTeXila opened this instance of the file in a non-editable way. Do yo" \
"u want to edit it anyway?");
							_tmp20_ = g_strdup (_tmp19_);
							secondary_msg = _tmp20_;
							_tmp21_ = document_tab_add_message (_data6_->tab, primary_msg, secondary_msg, GTK_MESSAGE_WARNING);
							_data6_->infobar = (GtkInfoBar*) _tmp21_;
							_tmp22_ = _ ("Edit Anyway");
							gtk_info_bar_add_button (_data6_->infobar, _tmp22_, (gint) GTK_RESPONSE_YES);
							_tmp23_ = _ ("Don't Edit");
							gtk_info_bar_add_button (_data6_->infobar, _tmp23_, (gint) GTK_RESPONSE_NO);
							g_signal_connect_data (_data6_->infobar, "response", (GCallback) __lambda35__gtk_info_bar_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							_tmp24_ = _g_object_ref0 (_data6_->tab);
							result = _tmp24_;
							_g_free0 (secondary_msg);
							_g_free0 (primary_msg);
							_g_object_unref0 (doc);
							block6_data_unref (_data6_);
							_data6_ = NULL;
							__g_list_free__g_object_unref0_0 (doc_collection);
							_g_object_unref0 (w);
							return result;
						}
					}
					__g_list_free__g_object_unref0_0 (doc_collection);
				}
				_g_object_unref0 (w);
			}
		}
	}
	_tmp25_ = main_window_create_tab_from_location (self, location, jump_to);
	result = _tmp25_;
	return result;
}


DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to) {
	DocumentTab* result = NULL;
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* tab;
	DocumentTab* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_tab_new ();
	tab = g_object_ref_sink (_tmp0_);
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
	result = _tmp1_;
	_g_object_unref0 (tab);
	return result;
}


DocumentTab* main_window_create_tab_from_location (MainWindow* self, GFile* location, gboolean jump_to) {
	DocumentTab* result = NULL;
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* tab;
	DocumentTab* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = document_tab_new_from_location (location);
	tab = g_object_ref_sink (_tmp0_);
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
	result = _tmp1_;
	_g_object_unref0 (tab);
	return result;
}


void main_window_create_tab_with_view (MainWindow* self, DocumentView* view) {
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* tab;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = document_tab_new_with_view (view);
	tab = g_object_ref_sink (_tmp0_);
	_tmp1_ = main_window_process_create_tab (self, tab, TRUE);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (tab);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->tab);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _lambda27_ (Block7Data* _data7_) {
	MainWindow * self;
	self = _data7_->self;
	main_window_close_tab (self, _data7_->tab, FALSE);
}


static void __lambda27__document_tab_close_document (DocumentTab* _sender, gpointer self) {
	_lambda27_ (self);
}


static void _lambda28_ (Block7Data* _data7_) {
	MainWindow * self;
	DocumentTab* _tmp0_ = NULL;
	self = _data7_->self;
	_tmp0_ = main_window_get_active_tab (self);
	if (_data7_->tab != _tmp0_) {
		return;
	}
	main_window_set_undo_sensitivity (self);
}


static void __lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda28_ (self);
}


static void _lambda29_ (Block7Data* _data7_) {
	MainWindow * self;
	DocumentTab* _tmp0_ = NULL;
	self = _data7_->self;
	_tmp0_ = main_window_get_active_tab (self);
	if (_data7_->tab != _tmp0_) {
		return;
	}
	main_window_set_redo_sensitivity (self);
}


static void __lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda29_ (self);
}


static void _lambda30_ (Block7Data* _data7_) {
	MainWindow * self;
	DocumentTab* _tmp0_ = NULL;
	self = _data7_->self;
	_tmp0_ = main_window_get_active_tab (self);
	if (_data7_->tab != _tmp0_) {
		return;
	}
	main_window_selection_changed (self);
}


static void __lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda30_ (self);
}


static void _lambda31_ (Block7Data* _data7_) {
	MainWindow * self;
	self = _data7_->self;
	main_window_sync_name (self, _data7_->tab);
	main_window_update_build_tools_sensitivity (self);
}


static void __lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda31_ (self);
}


static void _lambda32_ (MainWindow* self) {
	main_window_update_build_tools_sensitivity (self);
}


static void __lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda32_ (self);
}


static void _lambda33_ (Block7Data* _data7_) {
	MainWindow * self;
	self = _data7_->self;
	main_window_sync_name (self, _data7_->tab);
}


static void __lambda33__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda33_ (self);
}


static void _lambda34_ (Block7Data* _data7_) {
	MainWindow * self;
	self = _data7_->self;
	main_window_sync_name (self, _data7_->tab);
}


static void __lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda34_ (self);
}


static void _main_window_update_cursor_position_statusbar_document_cursor_moved (Document* _sender, gpointer self) {
	main_window_update_cursor_position_statusbar (self);
}


static DocumentTab* main_window_process_create_tab (MainWindow* self, DocumentTab* tab, gboolean jump_to) {
	DocumentTab* result = NULL;
	Block7Data* _data7_;
	Document* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	Document* _tmp2_ = NULL;
	Document* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	Document* _tmp7_ = NULL;
	gboolean _tmp8_;
	DocumentTab* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->tab = _g_object_ref0 (tab);
	if (_data7_->tab == NULL) {
		result = NULL;
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return result;
	}
	g_signal_connect_data (_data7_->tab, "close-document", (GCallback) __lambda27__document_tab_close_document, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp0_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_data ((GObject*) _tmp0_, "notify::can-undo", (GCallback) __lambda28__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp1_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_data ((GObject*) _tmp1_, "notify::can-redo", (GCallback) __lambda29__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp2_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_data ((GObject*) _tmp2_, "notify::has-selection", (GCallback) __lambda30__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp3_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_data ((GObject*) _tmp3_, "notify::location", (GCallback) __lambda31__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp4_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_object ((GObject*) _tmp4_, "notify::project-id", (GCallback) __lambda32__g_object_notify, self, 0);
	_tmp5_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_data ((GtkTextBuffer*) _tmp5_, "modified-changed", (GCallback) __lambda33__gtk_text_buffer_modified_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp6_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_data ((GObject*) _tmp6_, "notify::readonly", (GCallback) __lambda34__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp7_ = document_tab_get_document (_data7_->tab);
	g_signal_connect_object (_tmp7_, "cursor-moved", (GCallback) _main_window_update_cursor_position_statusbar_document_cursor_moved, self, 0);
	gtk_widget_show ((GtkWidget*) _data7_->tab);
	documents_panel_add_tab (self->priv->documents_panel, _data7_->tab, -1, jump_to);
	main_window_set_undo_sensitivity (self);
	main_window_set_redo_sensitivity (self);
	main_window_selection_changed (self);
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp8_) {
		gtk_window_present ((GtkWindow*) self);
	}
	_tmp9_ = _g_object_ref0 (_data7_->tab);
	result = _tmp9_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tab != NULL, FALSE);
	if (!force_close) {
		Document* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp1_ = document_tab_get_document (tab);
		_tmp2_ = document_get_modified (_tmp1_);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GtkMessageDialog* _tmp5_ = NULL;
		GtkDialog* dialog;
		const gchar* _tmp6_ = NULL;
		Document* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		_tmp3_ = _ ("Save changes to document \"%s\" before closing?");
		_tmp4_ = document_tab_get_label_text (tab);
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp3_, _tmp4_);
		dialog = (GtkDialog*) g_object_ref_sink (_tmp5_);
		_tmp6_ = _ ("Close without Saving");
		gtk_dialog_add_buttons (dialog, _tmp6_, GTK_RESPONSE_CLOSE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
		_tmp7_ = document_tab_get_document (tab);
		_tmp8_ = document_get_location (_tmp7_);
		if (_tmp8_ == NULL) {
			gtk_dialog_add_button (dialog, GTK_STOCK_SAVE_AS, (gint) GTK_RESPONSE_ACCEPT);
		} else {
			gtk_dialog_add_button (dialog, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_ACCEPT);
		}
		while (TRUE) {
			gint _tmp9_;
			gint res;
			_tmp9_ = gtk_dialog_run (dialog);
			res = _tmp9_;
			if (res == GTK_RESPONSE_CLOSE) {
				break;
			} else {
				if (res == GTK_RESPONSE_ACCEPT) {
					Document* _tmp10_ = NULL;
					gboolean _tmp11_;
					_tmp10_ = document_tab_get_document (tab);
					_tmp11_ = main_window_save_document (self, _tmp10_, FALSE);
					if (_tmp11_) {
						break;
					}
					continue;
				} else {
					gtk_object_destroy ((GtkObject*) dialog);
					result = FALSE;
					_g_object_unref0 (dialog);
					return result;
				}
			}
		}
		gtk_object_destroy ((GtkObject*) dialog);
		_g_object_unref0 (dialog);
	}
	documents_panel_remove_tab (self->priv->documents_panel, tab);
	result = TRUE;
	return result;
}


DocumentTab* main_window_get_tab_from_location (MainWindow* self, GFile* location) {
	DocumentTab* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = main_window_get_documents (self);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp0_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp1_;
			Document* doc;
			_tmp1_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp1_;
			{
				GFile* _tmp2_ = NULL;
				gboolean _tmp3_;
				_tmp2_ = document_get_location (doc);
				_tmp3_ = g_file_equal (location, _tmp2_);
				if (_tmp3_) {
					DocumentTab* _tmp4_;
					_tmp4_ = _g_object_ref0 (doc->tab);
					result = _tmp4_;
					_g_object_unref0 (doc);
					__g_list_free__g_object_unref0_0 (doc_collection);
					return result;
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
	result = NULL;
	return result;
}


gboolean main_window_is_on_workspace_screen (MainWindow* self, GdkScreen* screen, guint workspace) {
	gboolean result = FALSE;
	gboolean _tmp11_;
	guint _tmp12_;
	guint ws;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (screen != NULL) {
		GdkDisplay* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* cur_name;
		gint _tmp3_;
		gint cur_n;
		GdkScreen* _tmp4_ = NULL;
		GdkScreen* _tmp5_;
		GdkScreen* s;
		GdkDisplay* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* name;
		gint _tmp9_;
		gint n;
		gboolean _tmp10_ = FALSE;
		_tmp0_ = gdk_screen_get_display (screen);
		_tmp1_ = gdk_display_get_name (_tmp0_);
		_tmp2_ = g_strdup (_tmp1_);
		cur_name = _tmp2_;
		_tmp3_ = gdk_screen_get_number (screen);
		cur_n = _tmp3_;
		_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		s = _tmp5_;
		_tmp6_ = gdk_screen_get_display (s);
		_tmp7_ = gdk_display_get_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		name = _tmp8_;
		_tmp9_ = gdk_screen_get_number (s);
		n = _tmp9_;
		if (g_strcmp0 (cur_name, name) != 0) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = cur_n != n;
		}
		if (_tmp10_) {
			result = FALSE;
			_g_free0 (name);
			_g_object_unref0 (s);
			_g_free0 (cur_name);
			return result;
		}
		_g_free0 (name);
		_g_object_unref0 (s);
		_g_free0 (cur_name);
	}
	_tmp11_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp11_) {
		gtk_widget_realize ((GtkWidget*) self);
	}
	_tmp12_ = utils_get_window_workspace ((GtkWindow*) self);
	ws = _tmp12_;
	if (ws == workspace) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = ws == UTILS_ALL_WORKSPACES;
	}
	result = _tmp13_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch18_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch18_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void main_window_sync_name (MainWindow* self, DocumentTab* tab) {
	DocumentTab* _tmp0_ = NULL;
	gint _tmp1_;
	gint page_num;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* action_name;
	GtkAction* _tmp6_ = NULL;
	GtkAction* _tmp7_;
	GtkAction* action;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (tab == _tmp0_) {
		main_window_my_set_title (self);
	}
	_tmp1_ = gtk_notebook_page_num ((GtkNotebook*) self->priv->documents_panel, (GtkWidget*) tab);
	page_num = _tmp1_;
	_tmp2_ = g_strdup_printf ("%i", page_num);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Tab_", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	action_name = _tmp5_;
	_tmp6_ = gtk_action_group_get_action (self->priv->documents_list_action_group, action_name);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	action = _tmp7_;
	g_return_if_fail (action != NULL);
	_tmp8_ = document_tab_get_name (tab);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_replace (_tmp9_, "_", "__");
	_tmp11_ = _tmp10_;
	gtk_action_set_label (action, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = document_tab_get_menu_tip (tab);
	_tmp13_ = _tmp12_;
	gtk_action_set_tooltip (action, _tmp13_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (action);
	_g_free0 (action_name);
}


static void main_window_my_set_title (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	guint max_title_length;
	gchar* title;
	gchar* dirname;
	Document* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFile* loc;
	const gchar* _tmp15_ = NULL;
	Document* _tmp16_ = NULL;
	gboolean _tmp17_;
	gchar* _tmp18_ = NULL;
	Document* _tmp19_ = NULL;
	gboolean _tmp20_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ == NULL) {
		gtk_window_set_title ((GtkWindow*) self, "LaTeXila");
		return;
	}
	max_title_length = (guint) 100;
	title = NULL;
	dirname = NULL;
	_tmp1_ = main_window_get_active_document (self);
	_tmp2_ = document_get_location (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	loc = _tmp3_;
	if (loc == NULL) {
		Document* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = main_window_get_active_document (self);
		_tmp5_ = document_get_short_name_for_display (_tmp4_);
		_g_free0 (title);
		title = _tmp5_;
	} else {
		gchar* _tmp6_ = NULL;
		gchar* basename;
		gint _tmp7_;
		_tmp6_ = g_file_get_basename (loc);
		basename = _tmp6_;
		_tmp7_ = strlen (basename);
		if (_tmp7_ > max_title_length) {
			gchar* _tmp8_ = NULL;
			_tmp8_ = utils_str_middle_truncate (basename, max_title_length);
			_g_free0 (title);
			title = _tmp8_;
		} else {
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gint _tmp12_;
			glong _tmp13_;
			gchar* _tmp14_ = NULL;
			_tmp9_ = g_strdup (basename);
			_g_free0 (title);
			title = _tmp9_;
			_tmp10_ = utils_get_dirname_for_display (loc);
			_tmp11_ = _tmp10_;
			_tmp12_ = strlen (basename);
			_tmp13_ = MAX ((glong) 20, (glong) (max_title_length - _tmp12_));
			_tmp14_ = utils_str_middle_truncate (_tmp11_, (guint) _tmp13_);
			_g_free0 (dirname);
			dirname = _tmp14_;
			_g_free0 (_tmp11_);
		}
		_g_free0 (basename);
	}
	_tmp16_ = main_window_get_active_document (self);
	_tmp17_ = document_get_modified (_tmp16_);
	if (_tmp17_) {
		_tmp15_ = "*";
	} else {
		_tmp15_ = "";
	}
	_tmp19_ = main_window_get_active_document (self);
	_tmp20_ = document_get_readonly (_tmp19_);
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = _ ("Read-Only");
		_tmp22_ = g_strconcat (" [", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "]", NULL);
		_g_free0 (_tmp18_);
		_tmp18_ = _tmp24_;
		_g_free0 (_tmp23_);
	} else {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("");
		_g_free0 (_tmp18_);
		_tmp18_ = _tmp25_;
	}
	if (dirname != NULL) {
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp27_ = g_strconcat (" (", dirname, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp28_, ")", NULL);
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp29_;
		_g_free0 (_tmp28_);
	} else {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("");
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp30_;
	}
	_tmp31_ = g_strconcat (_tmp15_, title, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat (_tmp32_, _tmp18_, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp34_, _tmp26_, NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp36_, " - LaTeXila", NULL);
	_tmp38_ = _tmp37_;
	gtk_window_set_title ((GtkWindow*) self, _tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp18_);
	_g_object_unref0 (loc);
	_g_free0 (dirname);
	_g_free0 (title);
}


gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileChooserDialog* file_chooser;
	GFile* _tmp4_ = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp24_ = NULL;
	GFile* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (doc != NULL, FALSE);
	if (!force_save_as) {
		GFile* _tmp1_ = NULL;
		_tmp1_ = document_get_location (doc);
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_save (doc, TRUE, FALSE);
		result = TRUE;
		return result;
	}
	_tmp2_ = _ ("Save File");
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	file_chooser = g_object_ref_sink (_tmp3_);
	_tmp4_ = document_get_location (doc);
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = document_tab_get_label_text (doc->tab);
		_tmp6_ = g_strconcat (_tmp5_, ".tex", NULL);
		_tmp7_ = _tmp6_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) file_chooser, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = document_tab_get_label_text (doc->tab);
		gtk_file_chooser_set_current_name ((GtkFileChooser*) file_chooser, _tmp8_);
	}
	if (self->priv->file_chooser_current_folder != NULL) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) file_chooser, self->priv->file_chooser_current_folder);
	}
	_tmp9_ = document_get_location (doc);
	if (_tmp9_ != NULL) {
		GFile* _tmp10_ = NULL;
		_tmp10_ = document_get_location (doc);
		gtk_file_chooser_set_file ((GtkFileChooser*) file_chooser, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_chooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	while (TRUE) {
		gint _tmp11_;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_;
		GFile* file;
		gboolean _tmp14_;
		_tmp11_ = gtk_dialog_run ((GtkDialog*) file_chooser);
		if (!(_tmp11_ == GTK_RESPONSE_ACCEPT)) {
			break;
		}
		_tmp12_ = gtk_file_chooser_get_file ((GtkFileChooser*) file_chooser);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		file = _tmp13_;
		_tmp14_ = g_file_query_exists (file, NULL);
		if (_tmp14_) {
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			GtkMessageDialog* _tmp18_ = NULL;
			GtkMessageDialog* _tmp19_;
			GtkMessageDialog* confirmation;
			const gchar* _tmp20_ = NULL;
			GtkButton* _tmp21_ = NULL;
			GtkButton* button_replace;
			GtkImage* _tmp22_ = NULL;
			GtkImage* icon;
			gint _tmp23_;
			gint response;
			_tmp15_ = _ ("A file named \"%s\" already exists. Do you want to replace it?");
			_tmp16_ = g_file_get_basename (file);
			_tmp17_ = _tmp16_;
			_tmp18_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp15_, _tmp17_);
			_tmp19_ = g_object_ref_sink (_tmp18_);
			_g_free0 (_tmp17_);
			confirmation = _tmp19_;
			gtk_dialog_add_button ((GtkDialog*) confirmation, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
			_tmp20_ = _ ("Replace");
			_tmp21_ = (GtkButton*) gtk_button_new_with_label (_tmp20_);
			button_replace = g_object_ref_sink (_tmp21_);
			_tmp22_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_SAVE_AS, GTK_ICON_SIZE_BUTTON);
			icon = g_object_ref_sink (_tmp22_);
			gtk_button_set_image (button_replace, (GtkWidget*) icon);
			gtk_dialog_add_action_widget ((GtkDialog*) confirmation, (GtkWidget*) button_replace, (gint) GTK_RESPONSE_YES);
			gtk_widget_show ((GtkWidget*) button_replace);
			_tmp23_ = gtk_dialog_run ((GtkDialog*) confirmation);
			response = _tmp23_;
			gtk_object_destroy ((GtkObject*) confirmation);
			if (response != GTK_RESPONSE_YES) {
				_g_object_unref0 (icon);
				_g_object_unref0 (button_replace);
				_g_object_unref0 (confirmation);
				_g_object_unref0 (file);
				continue;
			}
			_g_object_unref0 (icon);
			_g_object_unref0 (button_replace);
			_g_object_unref0 (confirmation);
		}
		document_set_location (doc, file);
		_g_object_unref0 (file);
		break;
	}
	_tmp24_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) file_chooser);
	_g_free0 (self->priv->file_chooser_current_folder);
	self->priv->file_chooser_current_folder = _tmp24_;
	gtk_object_destroy ((GtkObject*) file_chooser);
	_tmp25_ = document_get_location (doc);
	if (_tmp25_ != NULL) {
		document_save (doc, FALSE, TRUE);
		result = TRUE;
		_g_object_unref0 (file_chooser);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (file_chooser);
	return result;
}


static gboolean main_window_close_all_documents (MainWindow* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	GList* unsaved_documents;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = main_window_get_unsaved_documents (self);
	unsaved_documents = _tmp0_;
	if (unsaved_documents == NULL) {
		documents_panel_remove_all_tabs (self->priv->documents_panel);
		result = TRUE;
		__g_list_free__g_object_unref0_0 (unsaved_documents);
		return result;
	} else {
		if (unsaved_documents->next == NULL) {
			Document* _tmp1_;
			Document* doc;
			gboolean _tmp2_;
			_tmp1_ = _g_object_ref0 ((Document*) unsaved_documents->data);
			doc = _tmp1_;
			main_window_set_active_tab (self, doc->tab);
			_tmp2_ = main_window_close_tab (self, doc->tab, FALSE);
			if (_tmp2_) {
				documents_panel_remove_all_tabs (self->priv->documents_panel);
				result = TRUE;
				_g_object_unref0 (doc);
				__g_list_free__g_object_unref0_0 (unsaved_documents);
				return result;
			}
			_g_object_unref0 (doc);
		} else {
			gint _tmp3_;
			dialogs_close_several_unsaved_documents (self, unsaved_documents);
			_tmp3_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
			if (_tmp3_ == 0) {
				result = TRUE;
				__g_list_free__g_object_unref0_0 (unsaved_documents);
				return result;
			}
		}
	}
	result = FALSE;
	__g_list_free__g_object_unref0_0 (unsaved_documents);
	return result;
}


void main_window_remove_all_tabs (MainWindow* self) {
	g_return_if_fail (self != NULL);
	documents_panel_remove_all_tabs (self->priv->documents_panel);
}


static void main_window_update_cursor_position_statusbar (MainWindow* self) {
	GtkTextIter iter = {0};
	Document* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_;
	gint row;
	DocumentView* _tmp5_ = NULL;
	guint _tmp6_;
	gint col;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_document (self);
	_tmp1_ = main_window_get_active_document (self);
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp1_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp0_, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line (&iter);
	row = (gint) _tmp4_;
	_tmp5_ = main_window_get_active_view (self);
	_tmp6_ = document_view_my_get_visual_column (_tmp5_, &iter);
	col = (gint) _tmp6_;
	custom_statusbar_set_cursor_position (self->priv->statusbar, row + 1, col + 1);
}


static void main_window_setup_toolbar_open_button (MainWindow* self, GtkToolbar* toolbar) {
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_;
	GtkRecentManager* recent_manager;
	GtkRecentChooserMenu* _tmp2_ = NULL;
	GtkWidget* toolbar_recent_menu;
	GtkMenuToolButton* _tmp3_ = NULL;
	GtkMenuToolButton* open_button;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkAction* _tmp6_ = NULL;
	GtkAction* _tmp7_;
	GtkAction* action;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toolbar != NULL);
	_tmp0_ = gtk_recent_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	recent_manager = _tmp1_;
	_tmp2_ = (GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recent_manager);
	toolbar_recent_menu = (GtkWidget*) g_object_ref_sink (_tmp2_);
	main_window_configure_recent_chooser (self, GTK_RECENT_CHOOSER (toolbar_recent_menu));
	_tmp3_ = (GtkMenuToolButton*) gtk_menu_tool_button_new_from_stock (GTK_STOCK_OPEN);
	open_button = g_object_ref_sink (_tmp3_);
	gtk_menu_tool_button_set_menu (open_button, toolbar_recent_menu);
	_tmp4_ = _ ("Open a file");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) open_button, _tmp4_);
	_tmp5_ = _ ("Open a recently used file");
	gtk_menu_tool_button_set_arrow_tooltip_text (open_button, _tmp5_);
	_tmp6_ = gtk_action_group_get_action (self->priv->action_group, "FileOpen");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	action = _tmp7_;
	gtk_activatable_set_related_action ((GtkActivatable*) open_button, action);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) open_button, 1);
	_g_object_unref0 (action);
	_g_object_unref0 (open_button);
	_g_object_unref0 (toolbar_recent_menu);
	_g_object_unref0 (recent_manager);
}


static void _lambda105_ (GtkRecentChooser* chooser, MainWindow* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* uri;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	DocumentTab* _tmp4_ = NULL;
	DocumentTab* _tmp5_;
	g_return_if_fail (chooser != NULL);
	_tmp0_ = gtk_recent_chooser_get_current_uri (chooser);
	_tmp1_ = g_strdup (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = g_file_new_for_uri (uri);
	_tmp3_ = _tmp2_;
	_tmp4_ = main_window_open_document (self, _tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (uri);
}


static void __lambda105__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender, gpointer self) {
	_lambda105_ (_sender, self);
}


static void main_window_configure_recent_chooser (MainWindow* self, GtkRecentChooser* recent_chooser) {
	GtkRecentFilter* _tmp0_ = NULL;
	GtkRecentFilter* filter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recent_chooser != NULL);
	gtk_recent_chooser_set_local_only (recent_chooser, FALSE);
	gtk_recent_chooser_set_sort_type (recent_chooser, GTK_RECENT_SORT_MRU);
	_tmp0_ = gtk_recent_filter_new ();
	filter = g_object_ref_sink (_tmp0_);
	gtk_recent_filter_add_application (filter, "latexila");
	gtk_recent_chooser_set_filter (recent_chooser, filter);
	g_signal_connect_object (recent_chooser, "item-activated", (GCallback) __lambda105__gtk_recent_chooser_item_activated, self, 0);
	_g_object_unref0 (filter);
}


void main_window_save_state (MainWindow* self, gboolean sync) {
	GSettings* _tmp0_ = NULL;
	GSettings* settings_window;
	GdkWindow* _tmp1_ = NULL;
	GdkWindowState _tmp2_;
	GdkWindowState state;
	gint w = 0;
	gint h = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GSettings* _tmp7_ = NULL;
	GSettings* settings_ui;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_;
	GtkToggleAction* action;
	gboolean _tmp10_;
	GtkAction* _tmp11_ = NULL;
	GtkToggleAction* _tmp12_;
	gboolean _tmp13_;
	GtkAction* _tmp14_ = NULL;
	GtkToggleAction* _tmp15_;
	gboolean _tmp16_;
	GtkAction* _tmp17_ = NULL;
	GtkToggleAction* _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	GtkAction* _tmp21_ = NULL;
	GtkToggleAction* _tmp22_;
	gboolean _tmp23_;
	GtkAction* _tmp24_ = NULL;
	GtkToggleAction* _tmp25_;
	gboolean _tmp26_;
	GtkAction* _tmp27_ = NULL;
	GtkToggleAction* _tmp28_;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.state.window");
	settings_window = _tmp0_;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_window_get_state (_tmp1_);
	state = _tmp2_;
	g_settings_set_int (settings_window, "state", (gint) state);
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	w = _tmp3_;
	h = _tmp4_;
	if ((state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		w = w - 100;
		h = h - 100;
	}
	g_settings_set (settings_window, "size", "(ii)", w, h);
	_tmp5_ = gtk_paned_get_position ((GtkPaned*) self->priv->main_hpaned);
	g_settings_set_int (settings_window, "side-panel-size", _tmp5_);
	_tmp6_ = gtk_paned_get_position ((GtkPaned*) self->priv->vpaned);
	g_settings_set_int (settings_window, "vertical-paned-position", _tmp6_);
	structure_save_state (self->priv->_structure);
	_tmp7_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings_ui = _tmp7_;
	_tmp8_ = gtk_action_group_get_action (self->priv->action_group, "ViewMainToolbar");
	_tmp9_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp8_));
	action = _tmp9_;
	_tmp10_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "main-toolbar-visible", _tmp10_);
	_tmp11_ = gtk_action_group_get_action (self->priv->action_group, "ViewEditToolbar");
	_tmp12_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp11_));
	_g_object_unref0 (action);
	action = _tmp12_;
	_tmp13_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", _tmp13_);
	_tmp14_ = gtk_action_group_get_action (self->priv->action_group, "ViewSidePanel");
	_tmp15_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp14_));
	_g_object_unref0 (action);
	action = _tmp15_;
	_tmp16_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "side-panel-visible", _tmp16_);
	_tmp17_ = gtk_action_group_get_action (self->priv->action_group, "ViewBottomPanel");
	_tmp18_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp17_));
	_g_object_unref0 (action);
	action = _tmp18_;
	_tmp19_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", _tmp19_);
	_tmp20_ = side_panel_get_active_component (self->priv->side_panel);
	g_settings_set_int (settings_ui, "side-panel-component", _tmp20_);
	_tmp21_ = gtk_action_group_get_action (self->priv->action_group, "BuildShowErrors");
	_tmp22_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp21_));
	_g_object_unref0 (action);
	action = _tmp22_;
	_tmp23_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "show-build-errors", _tmp23_);
	_tmp24_ = gtk_action_group_get_action (self->priv->action_group, "BuildShowWarnings");
	_tmp25_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp24_));
	_g_object_unref0 (action);
	action = _tmp25_;
	_tmp26_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "show-build-warnings", _tmp26_);
	_tmp27_ = gtk_action_group_get_action (self->priv->action_group, "BuildShowBadBoxes");
	_tmp28_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp27_));
	_g_object_unref0 (action);
	action = _tmp28_;
	_tmp29_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (settings_ui, "show-build-badboxes", _tmp29_);
	if (sync) {
		g_settings_sync ();
		g_settings_sync ();
	}
	_g_object_unref0 (action);
	_g_object_unref0 (settings_ui);
	_g_object_unref0 (settings_window);
}


static void main_window_move_tab_to_new_window (MainWindow* self, DocumentTab* tab) {
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	MainWindow* _tmp2_ = NULL;
	MainWindow* _tmp3_;
	MainWindow* new_window;
	DocumentView* _tmp4_ = NULL;
	DocumentView* _tmp5_;
	DocumentView* view;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_create_window (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	new_window = _tmp3_;
	_tmp4_ = document_tab_get_view (tab);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	view = _tmp5_;
	documents_panel_remove_tab (self->priv->documents_panel, tab);
	main_window_create_tab_with_view (new_window, view);
	_g_object_unref0 (view);
	_g_object_unref0 (new_window);
}


static void _main_window_build_tools_menu_activate_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_build_tools_menu_activate (self, _sender);
}


void main_window_update_build_tools_menu (MainWindow* self) {
	GList* _tmp0_ = NULL;
	BuildTools* _tmp3_ = NULL;
	BuildTools* build_tools;
	guint _tmp4_ = 0U;
	gboolean _tmp5_;
	guint id;
	gint i;
	gint j;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools_action_group != NULL);
	if (self->priv->build_tools_menu_ui_id != 0) {
		gtk_ui_manager_remove_ui (self->priv->ui_manager, self->priv->build_tools_menu_ui_id);
	}
	_tmp0_ = gtk_action_group_list_actions (self->priv->build_tools_action_group);
	{
		GList* action_collection;
		GList* action_it;
		action_collection = _tmp0_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp1_;
			GtkAction* action;
			_tmp1_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp1_;
			{
				guint _tmp2_;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp2_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (action, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_build_tools_menu_activate_gtk_action_activate, self);
				gtk_action_group_remove_action (self->priv->build_tools_action_group, action);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	_tmp3_ = build_tools_get_default ();
	build_tools = _tmp3_;
	_tmp5_ = build_tools_is_empty (build_tools);
	if (_tmp5_) {
		_tmp4_ = (guint) 0;
	} else {
		guint _tmp6_;
		_tmp6_ = gtk_ui_manager_new_merge_id (self->priv->ui_manager);
		_tmp4_ = _tmp6_;
	}
	id = _tmp4_;
	i = 0;
	j = 0;
	{
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _build_tool_it;
		_tmp7_ = build_tools_iterator (build_tools);
		_build_tool_it = _tmp7_;
		while (TRUE) {
			gboolean _tmp8_;
			gpointer _tmp9_ = NULL;
			BuildTool* _tmp10_;
			BuildTool _tmp11_;
			BuildTool _tmp12_ = {0};
			BuildTool _tmp13_;
			BuildTool build_tool;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* action_name;
			GtkAction* _tmp18_ = NULL;
			GtkAction* action;
			gchar* _tmp19_ = NULL;
			gchar* _tmp21_;
			gchar* accel;
			_tmp8_ = gee_iterator_next (_build_tool_it);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = gee_iterator_get (_build_tool_it);
			_tmp10_ = (BuildTool*) _tmp9_;
			build_tool_copy (_tmp10_, &_tmp12_);
			_tmp11_ = _tmp12_;
			_tmp13_ = _tmp11_;
			_build_tool_free0 (_tmp10_);
			build_tool = _tmp13_;
			if (!build_tool.show) {
				i++;
				build_tool_destroy (&build_tool);
				continue;
			}
			_tmp14_ = g_strdup_printf ("%i", i);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat ("BuildTool_", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			action_name = _tmp17_;
			_tmp18_ = gtk_action_new (action_name, build_tool.label, build_tool.description, build_tool.icon);
			action = _tmp18_;
			if (j < 10) {
				gchar* _tmp20_ = NULL;
				_tmp20_ = g_strdup_printf ("<Release>F%d", j + 2);
				_g_free0 (_tmp19_);
				_tmp19_ = _tmp20_;
			} else {
				_g_free0 (_tmp19_);
				_tmp19_ = NULL;
			}
			_tmp21_ = g_strdup (_tmp19_);
			accel = _tmp21_;
			gtk_action_group_add_action_with_accel (self->priv->build_tools_action_group, action, accel);
			g_signal_connect_object (action, "activate", (GCallback) _main_window_build_tools_menu_activate_gtk_action_activate, self, 0);
			gtk_ui_manager_add_ui (self->priv->ui_manager, id, "/MainMenu/BuildMenu/BuildToolsPlaceholder", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
			gtk_ui_manager_add_ui (self->priv->ui_manager, id, "/MainToolbar/BuildToolsPlaceholder2", action_name, action_name, GTK_UI_MANAGER_TOOLITEM, FALSE);
			i++;
			j++;
			_g_free0 (accel);
			_g_free0 (_tmp19_);
			_g_object_unref0 (action);
			_g_free0 (action_name);
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_it);
	}
	self->priv->build_tools_menu_ui_id = id;
	_build_tools_unref0 (build_tools);
}


static void _lambda39_ (MainWindow* self) {
	Document* _tmp0_ = NULL;
	_tmp0_ = main_window_get_active_document (self);
	file_browser_refresh_for_document (self->priv->file_browser, _tmp0_);
}


static void __lambda39__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self) {
	_lambda39_ (self);
}


static void main_window_build_tools_menu_activate (MainWindow* self, GtkAction* action) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** _name;
	gint _name_length1;
	gint __name_size_;
	gint _tmp6_;
	gint tool_index;
	BuildTools* _tmp7_ = NULL;
	BuildTools* _tmp8_;
	BuildTool* _tmp9_ = NULL;
	BuildTool* _tmp10_;
	BuildTool* tool;
	Document* _tmp20_ = NULL;
	GFile* _tmp21_ = NULL;
	GFile* main_file;
	BuildToolRunner* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	_tmp2_ = document_get_location (_tmp1_);
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = gtk_action_get_name (action);
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "_", 0);
	_name = _tmp5_;
	_name_length1 = _vala_array_length (_tmp4_);
	__name_size_ = _vala_array_length (_tmp4_);
	_tmp6_ = atoi (_name[1]);
	tool_index = _tmp6_;
	_tmp7_ = build_tools_get_default ();
	_tmp8_ = _tmp7_;
	_tmp9_ = build_tools_get (_tmp8_, tool_index);
	_tmp10_ = _tmp9_;
	_build_tools_unref0 (_tmp8_);
	tool = _tmp10_;
	g_return_if_fail (tool != NULL);
	build_view_show (self->priv->build_view);
	if ((*tool).compilation) {
		Document* _tmp11_ = NULL;
		gint _tmp12_;
		gint project_id;
		_tmp11_ = main_window_get_active_document (self);
		_tmp12_ = document_get_project_id (_tmp11_);
		project_id = _tmp12_;
		if (project_id == (-1)) {
			Document* _tmp13_ = NULL;
			_tmp13_ = main_window_get_active_document (self);
			document_save (_tmp13_, TRUE, FALSE);
		} else {
			Application* _tmp14_ = NULL;
			Application* _tmp15_;
			GList* _tmp16_ = NULL;
			GList* _tmp17_;
			GList* docs;
			_tmp14_ = application_get_default ();
			_tmp15_ = _tmp14_;
			_tmp16_ = application_get_documents (_tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp15_);
			docs = _tmp17_;
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = docs;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* _tmp18_;
					Document* doc;
					_tmp18_ = _g_object_ref0 ((Document*) doc_it->data);
					doc = _tmp18_;
					{
						gint _tmp19_;
						_tmp19_ = document_get_project_id (doc);
						if (_tmp19_ == project_id) {
							document_save (doc, TRUE, FALSE);
						}
						_g_object_unref0 (doc);
					}
				}
			}
			__g_list_free__g_object_unref0_0 (docs);
		}
	}
	_tmp20_ = main_window_get_active_document (self);
	_tmp21_ = document_get_main_file (_tmp20_);
	main_file = _tmp21_;
	_tmp22_ = build_tool_runner_new (main_file, tool, self->priv->build_view, self->priv->action_stop_exec);
	_g_object_unref0 (self->priv->build_tool_runner);
	self->priv->build_tool_runner = _tmp22_;
	if ((*tool).compilation) {
		g_signal_connect_object (self->priv->build_tool_runner, "finished", (GCallback) __lambda39__build_tool_runner_finished, self, 0);
	}
	_g_object_unref0 (main_file);
	_build_tool_free0 (tool);
	_name = (_vala_array_free (_name, _name_length1, (GDestroyNotify) g_free), NULL);
}


GtkAction* main_window_get_action_stop_exec (MainWindow* self) {
	GtkAction* result = NULL;
	GtkAction* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->action_stop_exec);
	result = _tmp0_;
	return result;
}


static void main_window_update_documents_list_menu (MainWindow* self) {
	GList* _tmp0_ = NULL;
	gint _tmp3_;
	gint n;
	guint _tmp4_ = 0U;
	guint id;
	GSList* group;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->documents_list_action_group != NULL);
	if (self->priv->documents_list_menu_ui_id != 0) {
		gtk_ui_manager_remove_ui (self->priv->ui_manager, self->priv->documents_list_menu_ui_id);
	}
	_tmp0_ = gtk_action_group_list_actions (self->priv->documents_list_action_group);
	{
		GList* action_collection;
		GList* action_it;
		action_collection = _tmp0_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp1_;
			GtkAction* action;
			_tmp1_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp1_;
			{
				guint _tmp2_;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp2_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (action, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_documents_list_menu_activate_gtk_action_activate, self);
				gtk_action_group_remove_action (self->priv->documents_list_action_group, action);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	_tmp3_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	n = _tmp3_;
	if (n > 0) {
		guint _tmp5_;
		_tmp5_ = gtk_ui_manager_new_merge_id (self->priv->ui_manager);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = (guint) 0;
	}
	id = _tmp4_;
	group = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp7_ = NULL;
				DocumentTab* _tmp8_;
				DocumentTab* tab;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* action_name;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* name;
				gchar* _tmp17_ = NULL;
				gchar* tip;
				gchar* _tmp18_ = NULL;
				gchar* _tmp20_;
				gchar* accel;
				GtkRadioAction* _tmp21_ = NULL;
				GtkRadioAction* action;
				GSList* _tmp22_ = NULL;
				DocumentTab* _tmp23_ = NULL;
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				if (!(i < n)) {
					break;
				}
				_tmp7_ = gtk_notebook_get_nth_page ((GtkNotebook*) self->priv->documents_panel, i);
				_tmp8_ = _g_object_ref0 (DOCUMENT_TAB (_tmp7_));
				tab = _tmp8_;
				_tmp9_ = g_strdup_printf ("%i", i);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat ("Tab_", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp10_);
				action_name = _tmp12_;
				_tmp13_ = document_tab_get_name (tab);
				_tmp14_ = _tmp13_;
				_tmp15_ = string_replace (_tmp14_, "_", "__");
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				name = _tmp16_;
				_tmp17_ = document_tab_get_menu_tip (tab);
				tip = _tmp17_;
				if (i < 10) {
					gchar* _tmp19_ = NULL;
					_tmp19_ = g_strdup_printf ("<alt>%d", (i + 1) % 10);
					_g_free0 (_tmp18_);
					_tmp18_ = _tmp19_;
				} else {
					_g_free0 (_tmp18_);
					_tmp18_ = NULL;
				}
				_tmp20_ = g_strdup (_tmp18_);
				accel = _tmp20_;
				_tmp21_ = gtk_radio_action_new (action_name, name, tip, NULL, i);
				action = _tmp21_;
				if (group != NULL) {
					gtk_radio_action_set_group (action, group);
				}
				_tmp22_ = gtk_radio_action_get_group (action);
				group = _tmp22_;
				gtk_action_group_add_action_with_accel (self->priv->documents_list_action_group, (GtkAction*) action, accel);
				g_signal_connect_object ((GtkAction*) action, "activate", (GCallback) _main_window_documents_list_menu_activate_gtk_action_activate, self, 0);
				gtk_ui_manager_add_ui (self->priv->ui_manager, id, "/MainMenu/DocumentsMenu/DocumentsListPlaceholder", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
				_tmp23_ = main_window_get_active_tab (self);
				if (tab == _tmp23_) {
					gtk_toggle_action_set_active ((GtkToggleAction*) action, TRUE);
				}
				_g_object_unref0 (action);
				_g_free0 (accel);
				_g_free0 (_tmp18_);
				_g_free0 (tip);
				_g_free0 (name);
				_g_free0 (action_name);
				_g_object_unref0 (tab);
			}
		}
	}
	self->priv->documents_list_menu_ui_id = id;
}


static void main_window_documents_list_menu_activate (MainWindow* self, GtkAction* action) {
	GtkRadioAction* _tmp0_;
	GtkRadioAction* radio_action;
	gboolean _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = _g_object_ref0 (GTK_RADIO_ACTION (action));
	radio_action = _tmp0_;
	_tmp1_ = gtk_toggle_action_get_active ((GtkToggleAction*) radio_action);
	if (!_tmp1_) {
		_g_object_unref0 (radio_action);
		return;
	}
	_tmp2_ = gtk_radio_action_get_current_value (radio_action);
	gtk_notebook_set_current_page ((GtkNotebook*) self->priv->documents_panel, _tmp2_);
	_g_object_unref0 (radio_action);
}


/*****************************
     *    ACTIONS SENSITIVITY    *
     *****************************/
static void main_window_set_file_actions_sensitivity (MainWindow* self, gboolean sensitive) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_ = NULL;
	gchar** file_actions;
	gint file_actions_length1;
	gint _file_actions_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("FileSave");
	_tmp1_ = g_strdup ("FileSaveAs");
	_tmp2_ = g_strdup ("FileClose");
	_tmp3_ = g_strdup ("EditUndo");
	_tmp4_ = g_strdup ("EditRedo");
	_tmp5_ = g_strdup ("EditCut");
	_tmp6_ = g_strdup ("EditCopy");
	_tmp7_ = g_strdup ("EditPaste");
	_tmp8_ = g_strdup ("EditDelete");
	_tmp9_ = g_strdup ("EditSelectAll");
	_tmp10_ = g_strdup ("EditComment");
	_tmp11_ = g_strdup ("EditUncomment");
	_tmp12_ = g_strdup ("ViewZoomIn");
	_tmp13_ = g_strdup ("ViewZoomOut");
	_tmp14_ = g_strdup ("ViewZoomReset");
	_tmp15_ = g_strdup ("DocumentsSaveAll");
	_tmp16_ = g_strdup ("DocumentsCloseAll");
	_tmp17_ = g_strdup ("DocumentsPrevious");
	_tmp18_ = g_strdup ("DocumentsNext");
	_tmp19_ = g_strdup ("SearchFind");
	_tmp20_ = g_strdup ("SearchReplace");
	_tmp21_ = g_strdup ("SearchGoToLine");
	_tmp22_ = g_strdup ("BuildClean");
	_tmp23_ = g_strdup ("BuildViewLog");
	_tmp24_ = g_strdup ("ProjectsConfigCurrent");
	_tmp25_ = g_strdup ("FileCreateTemplate");
	_tmp26_ = g_new0 (gchar*, 26 + 1);
	_tmp26_[0] = _tmp0_;
	_tmp26_[1] = _tmp1_;
	_tmp26_[2] = _tmp2_;
	_tmp26_[3] = _tmp3_;
	_tmp26_[4] = _tmp4_;
	_tmp26_[5] = _tmp5_;
	_tmp26_[6] = _tmp6_;
	_tmp26_[7] = _tmp7_;
	_tmp26_[8] = _tmp8_;
	_tmp26_[9] = _tmp9_;
	_tmp26_[10] = _tmp10_;
	_tmp26_[11] = _tmp11_;
	_tmp26_[12] = _tmp12_;
	_tmp26_[13] = _tmp13_;
	_tmp26_[14] = _tmp14_;
	_tmp26_[15] = _tmp15_;
	_tmp26_[16] = _tmp16_;
	_tmp26_[17] = _tmp17_;
	_tmp26_[18] = _tmp18_;
	_tmp26_[19] = _tmp19_;
	_tmp26_[20] = _tmp20_;
	_tmp26_[21] = _tmp21_;
	_tmp26_[22] = _tmp22_;
	_tmp26_[23] = _tmp23_;
	_tmp26_[24] = _tmp24_;
	_tmp26_[25] = _tmp25_;
	file_actions = _tmp26_;
	file_actions_length1 = 26;
	_file_actions_size_ = 26;
	{
		gchar** file_action_collection;
		int file_action_collection_length1;
		int file_action_it;
		file_action_collection = file_actions;
		file_action_collection_length1 = file_actions_length1;
		for (file_action_it = 0; file_action_it < file_actions_length1; file_action_it = file_action_it + 1) {
			gchar* _tmp27_;
			gchar* file_action;
			_tmp27_ = g_strdup (file_action_collection[file_action_it]);
			file_action = _tmp27_;
			{
				GtkAction* _tmp28_ = NULL;
				GtkAction* _tmp29_;
				GtkAction* action;
				_tmp28_ = gtk_action_group_get_action (self->priv->action_group, file_action);
				_tmp29_ = _g_object_ref0 (_tmp28_);
				action = _tmp29_;
				gtk_action_set_sensitive (action, sensitive);
				_g_object_unref0 (action);
				_g_free0 (file_action);
			}
		}
	}
	gtk_action_group_set_sensitive (self->priv->latex_action_group, sensitive);
	gtk_action_group_set_sensitive (self->priv->build_tools_action_group, sensitive);
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
}


static void main_window_set_undo_sensitivity (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ != NULL) {
		GtkAction* _tmp1_ = NULL;
		GtkAction* _tmp2_;
		GtkAction* action;
		Document* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp1_ = gtk_action_group_get_action (self->priv->action_group, "EditUndo");
		_tmp2_ = _g_object_ref0 (_tmp1_);
		action = _tmp2_;
		_tmp3_ = main_window_get_active_document (self);
		g_object_get ((GtkSourceBuffer*) _tmp3_, "can-undo", &_tmp4_, NULL);
		gtk_action_set_sensitive (action, _tmp4_);
		_g_object_unref0 (action);
	}
}


static void main_window_set_redo_sensitivity (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_;
	GtkAction* action;
	Document* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_action_group_get_action (self->priv->action_group, "EditRedo");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	_tmp3_ = main_window_get_active_document (self);
	g_object_get ((GtkSourceBuffer*) _tmp3_, "can-redo", &_tmp4_, NULL);
	gtk_action_set_sensitive (action, _tmp4_);
	_g_object_unref0 (action);
}


static void main_window_set_documents_move_to_new_window_sensitivity (MainWindow* self, gboolean sensitive) {
	GtkAction* _tmp0_ = NULL;
	GtkAction* _tmp1_;
	GtkAction* action;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_action_group_get_action (self->priv->action_group, "DocumentsMoveToNewWindow");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	action = _tmp1_;
	gtk_action_set_sensitive (action, sensitive);
	_g_object_unref0 (action);
}


static void main_window_update_next_prev_doc_sensitivity (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_;
	GtkAction* action_previous;
	GtkAction* _tmp3_ = NULL;
	GtkAction* _tmp4_;
	GtkAction* action_next;
	DocumentTab* _tmp5_ = NULL;
	gint _tmp6_;
	gint current_page;
	gint _tmp7_;
	gint nb_pages;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_action_group_get_action (self->priv->action_group, "DocumentsPrevious");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action_previous = _tmp2_;
	_tmp3_ = gtk_action_group_get_action (self->priv->action_group, "DocumentsNext");
	_tmp4_ = _g_object_ref0 (_tmp3_);
	action_next = _tmp4_;
	_tmp5_ = main_window_get_active_tab (self);
	_tmp6_ = gtk_notebook_page_num ((GtkNotebook*) self->priv->documents_panel, (GtkWidget*) _tmp5_);
	current_page = _tmp6_;
	gtk_action_set_sensitive (action_previous, current_page > 0);
	_tmp7_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	nb_pages = _tmp7_;
	gtk_action_set_sensitive (action_next, current_page < (nb_pages - 1));
	_g_object_unref0 (action_next);
	_g_object_unref0 (action_previous);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void main_window_update_build_tools_sensitivity (MainWindow* self) {
	GtkAction* _tmp0_ = NULL;
	GtkAction* _tmp1_;
	GtkAction* clean_action;
	GtkAction* _tmp2_ = NULL;
	GtkAction* _tmp3_;
	GtkAction* view_log_action;
	gboolean _tmp4_ = FALSE;
	DocumentTab* _tmp5_ = NULL;
	Document* _tmp9_ = NULL;
	gboolean _tmp10_;
	gboolean is_tex;
	Document* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* path;
	gchar* _tmp16_ = NULL;
	gchar* ext;
	gint i;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_action_group_get_action (self->priv->action_group, "BuildClean");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	clean_action = _tmp1_;
	_tmp2_ = gtk_action_group_get_action (self->priv->action_group, "BuildViewLog");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	view_log_action = _tmp3_;
	_tmp5_ = main_window_get_active_tab (self);
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Document* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_;
		_tmp6_ = main_window_get_active_document (self);
		_tmp7_ = document_get_main_file (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == NULL;
		_g_object_unref0 (_tmp8_);
	}
	if (_tmp4_) {
		gtk_action_group_set_sensitive (self->priv->build_tools_action_group, FALSE);
		gtk_action_set_sensitive (clean_action, FALSE);
		gtk_action_set_sensitive (view_log_action, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		return;
	}
	gtk_action_group_set_sensitive (self->priv->build_tools_action_group, TRUE);
	_tmp9_ = main_window_get_active_document (self);
	_tmp10_ = document_is_main_file_a_tex_file (_tmp9_);
	is_tex = _tmp10_;
	gtk_action_set_sensitive (clean_action, is_tex);
	gtk_action_set_sensitive (view_log_action, is_tex);
	_tmp11_ = main_window_get_active_document (self);
	_tmp12_ = document_get_main_file (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_parse_name (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp13_);
	path = _tmp15_;
	_tmp16_ = utils_get_extension (path);
	ext = _tmp16_;
	i = 0;
	{
		BuildTools* _tmp17_ = NULL;
		BuildTools* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _tool_it;
		_tmp17_ = build_tools_get_default ();
		_tmp18_ = _tmp17_;
		_tmp19_ = build_tools_iterator (_tmp18_);
		_tmp20_ = _tmp19_;
		_build_tools_unref0 (_tmp18_);
		_tool_it = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_;
			gpointer _tmp22_ = NULL;
			BuildTool* _tmp23_;
			BuildTool _tmp24_;
			BuildTool _tmp25_ = {0};
			BuildTool _tmp26_;
			BuildTool tool;
			gchar** _tmp27_;
			gchar** _tmp28_ = NULL;
			gchar** extensions;
			gint extensions_length1;
			gint _extensions_size_;
			gboolean _tmp29_ = FALSE;
			gint _tmp30_;
			gboolean sensitive;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			GtkAction* _tmp35_ = NULL;
			GtkAction* _tmp36_;
			GtkAction* _tmp37_;
			GtkAction* action;
			_tmp21_ = gee_iterator_next (_tool_it);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = gee_iterator_get (_tool_it);
			_tmp23_ = (BuildTool*) _tmp22_;
			build_tool_copy (_tmp23_, &_tmp25_);
			_tmp24_ = _tmp25_;
			_tmp26_ = _tmp24_;
			_build_tool_free0 (_tmp23_);
			tool = _tmp26_;
			if (!tool.show) {
				i++;
				build_tool_destroy (&tool);
				continue;
			}
			_tmp28_ = _tmp27_ = g_strsplit (tool.extensions, " ", 0);
			extensions = _tmp28_;
			extensions_length1 = _vala_array_length (_tmp27_);
			_extensions_size_ = _vala_array_length (_tmp27_);
			_tmp30_ = strlen (tool.extensions);
			if (_tmp30_ == 0) {
				_tmp29_ = TRUE;
			} else {
				_tmp29_ = _vala_string_array_contains (extensions, extensions_length1, ext);
			}
			sensitive = _tmp29_;
			_tmp31_ = g_strdup_printf ("%i", i);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat ("BuildTool_", _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = gtk_action_group_get_action (self->priv->build_tools_action_group, _tmp34_);
			_tmp36_ = _g_object_ref0 (_tmp35_);
			_tmp37_ = _tmp36_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			action = _tmp37_;
			gtk_action_set_sensitive (action, sensitive);
			i++;
			_g_object_unref0 (action);
			extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	_g_free0 (ext);
	_g_free0 (path);
	_g_object_unref0 (view_log_action);
	_g_object_unref0 (clean_action);
}


void main_window_update_config_project_sensitivity (MainWindow* self) {
	GtkAction* _tmp0_ = NULL;
	GtkAction* _tmp1_;
	GtkAction* action;
	gboolean _tmp2_ = FALSE;
	DocumentTab* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_action_group_get_action (self->priv->action_group, "ProjectsConfigCurrent");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	action = _tmp1_;
	_tmp3_ = main_window_get_active_tab (self);
	if (_tmp3_ != NULL) {
		Document* _tmp4_ = NULL;
		gint _tmp5_;
		_tmp4_ = main_window_get_active_document (self);
		_tmp5_ = document_get_project_id (_tmp4_);
		_tmp2_ = _tmp5_ != (-1);
	} else {
		_tmp2_ = FALSE;
	}
	gtk_action_set_sensitive (action, _tmp2_);
	_g_object_unref0 (action);
}


static void main_window_selection_changed (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ != NULL) {
		Document* _tmp1_ = NULL;
		gboolean _tmp2_;
		gboolean has_selection;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_ = NULL;
		gchar** selection_actions;
		gint selection_actions_length1;
		gint _selection_actions_size_;
		_tmp1_ = main_window_get_active_document (self);
		_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp1_);
		has_selection = _tmp2_;
		_tmp3_ = g_strdup ("EditCut");
		_tmp4_ = g_strdup ("EditCopy");
		_tmp5_ = g_strdup ("EditDelete");
		_tmp6_ = g_new0 (gchar*, 3 + 1);
		_tmp6_[0] = _tmp3_;
		_tmp6_[1] = _tmp4_;
		_tmp6_[2] = _tmp5_;
		selection_actions = _tmp6_;
		selection_actions_length1 = 3;
		_selection_actions_size_ = 3;
		{
			gchar** selection_action_collection;
			int selection_action_collection_length1;
			int selection_action_it;
			selection_action_collection = selection_actions;
			selection_action_collection_length1 = selection_actions_length1;
			for (selection_action_it = 0; selection_action_it < selection_actions_length1; selection_action_it = selection_action_it + 1) {
				gchar* _tmp7_;
				gchar* selection_action;
				_tmp7_ = g_strdup (selection_action_collection[selection_action_it]);
				selection_action = _tmp7_;
				{
					GtkAction* _tmp8_ = NULL;
					GtkAction* _tmp9_;
					GtkAction* action;
					_tmp8_ = gtk_action_group_get_action (self->priv->action_group, selection_action);
					_tmp9_ = _g_object_ref0 (_tmp8_);
					action = _tmp9_;
					gtk_action_set_sensitive (action, has_selection);
					_g_object_unref0 (action);
					_g_free0 (selection_action);
				}
			}
		}
		selection_actions = (_vala_array_free (selection_actions, selection_actions_length1, (GDestroyNotify) g_free), NULL);
	}
}


/*******************
     *    CALLBACKS
     ******************/
void main_window_on_file_new (MainWindow* self) {
	Templates* _tmp0_ = NULL;
	Templates* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = templates_get_default ();
	_tmp1_ = _tmp0_;
	templates_show_dialog_new (_tmp1_, self);
	_g_object_unref0 (_tmp1_);
}


void main_window_on_new_window (MainWindow* self) {
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	MainWindow* _tmp2_ = NULL;
	MainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_create_window (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


void main_window_on_file_open (MainWindow* self) {
	const gchar* _tmp0_ = NULL;
	GtkFileChooserDialog* _tmp1_ = NULL;
	GtkFileChooserDialog* file_chooser;
	GtkFileFilter* _tmp2_ = NULL;
	GtkFileFilter* latex_filter;
	GtkFileFilter* _tmp3_ = NULL;
	GtkFileFilter* all_files_filter;
	const gchar* _tmp4_ = NULL;
	GSList* files_to_open;
	gint _tmp5_;
	gchar* _tmp7_ = NULL;
	gboolean jump_to;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Open Files");
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL);
	file_chooser = g_object_ref_sink (_tmp1_);
	if (self->priv->file_chooser_current_folder != NULL) {
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) file_chooser, self->priv->file_chooser_current_folder);
	}
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) file_chooser, TRUE);
	_tmp2_ = gtk_file_filter_new ();
	latex_filter = g_object_ref_sink (_tmp2_);
	gtk_file_filter_set_name (latex_filter, "*.tex, *.bib");
	gtk_file_filter_add_pattern (latex_filter, "*.tex");
	gtk_file_filter_add_pattern (latex_filter, "*.bib");
	gtk_file_chooser_add_filter ((GtkFileChooser*) file_chooser, latex_filter);
	_tmp3_ = gtk_file_filter_new ();
	all_files_filter = g_object_ref_sink (_tmp3_);
	_tmp4_ = _ ("All Files");
	gtk_file_filter_set_name (all_files_filter, _tmp4_);
	gtk_file_filter_add_pattern (all_files_filter, "*");
	gtk_file_chooser_add_filter ((GtkFileChooser*) file_chooser, all_files_filter);
	files_to_open = NULL;
	_tmp5_ = gtk_dialog_run ((GtkDialog*) file_chooser);
	if (_tmp5_ == GTK_RESPONSE_ACCEPT) {
		GSList* _tmp6_ = NULL;
		_tmp6_ = gtk_file_chooser_get_files ((GtkFileChooser*) file_chooser);
		__g_slist_free__g_object_unref0_0 (files_to_open);
		files_to_open = _tmp6_;
	}
	_tmp7_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) file_chooser);
	_g_free0 (self->priv->file_chooser_current_folder);
	self->priv->file_chooser_current_folder = _tmp7_;
	gtk_object_destroy ((GtkObject*) file_chooser);
	jump_to = TRUE;
	{
		GSList* file_collection;
		GSList* file_it;
		file_collection = files_to_open;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp8_;
			GFile* file;
			_tmp8_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp8_;
			{
				DocumentTab* _tmp9_ = NULL;
				DocumentTab* _tmp10_;
				_tmp9_ = main_window_open_document (self, file, jump_to);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp10_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
	__g_slist_free__g_object_unref0_0 (files_to_open);
	_g_object_unref0 (all_files_filter);
	_g_object_unref0 (latex_filter);
	_g_object_unref0 (file_chooser);
}


void main_window_on_file_save (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	main_window_save_document (self, _tmp1_, FALSE);
}


void main_window_on_file_save_as (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	main_window_save_document (self, _tmp1_, TRUE);
}


void main_window_on_create_template (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Templates* _tmp1_ = NULL;
	Templates* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = templates_get_default ();
	_tmp2_ = _tmp1_;
	templates_show_dialog_create (_tmp2_, self);
	_g_object_unref0 (_tmp2_);
}


void main_window_on_delete_template (MainWindow* self) {
	Templates* _tmp0_ = NULL;
	Templates* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = templates_get_default ();
	_tmp1_ = _tmp0_;
	templates_show_dialog_delete (_tmp1_, self);
	_g_object_unref0 (_tmp1_);
}


void main_window_on_file_close (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_tab (self);
	main_window_close_tab (self, _tmp1_, FALSE);
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void main_window_on_quit (MainWindow* self) {
	gchar** _tmp0_ = NULL;
	gchar** list_uris;
	gint list_uris_length1;
	gint _list_uris_size_;
	GList* _tmp1_ = NULL;
	GSettings* _tmp6_ = NULL;
	GSettings* settings;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	list_uris = _tmp0_;
	list_uris_length1 = 0;
	_list_uris_size_ = 0;
	_tmp1_ = main_window_get_documents (self);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp1_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp2_;
			Document* doc;
			_tmp2_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp2_;
			{
				GFile* _tmp3_ = NULL;
				_tmp3_ = document_get_location (doc);
				if (_tmp3_ != NULL) {
					GFile* _tmp4_ = NULL;
					gchar* _tmp5_ = NULL;
					_tmp4_ = document_get_location (doc);
					_tmp5_ = g_file_get_uri (_tmp4_);
					_vala_array_add6 (&list_uris, &list_uris_length1, &_list_uris_size_, _tmp5_);
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
	_tmp6_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp6_;
	g_settings_set_strv (settings, "documents", list_uris);
	_tmp7_ = main_window_close_all_documents (self);
	if (_tmp7_) {
		main_window_save_state (self, FALSE);
		gtk_object_destroy ((GtkObject*) self);
	}
	_g_object_unref0 (settings);
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
}


void main_window_on_edit_undo (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	g_object_get ((GtkSourceBuffer*) _tmp1_, "can-undo", &_tmp2_, NULL);
	if (_tmp2_) {
		Document* _tmp3_ = NULL;
		DocumentView* _tmp4_ = NULL;
		DocumentView* _tmp5_ = NULL;
		_tmp3_ = main_window_get_active_document (self);
		gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp3_);
		_tmp4_ = main_window_get_active_view (self);
		document_view_scroll_to_cursor (_tmp4_, 0.25);
		_tmp5_ = main_window_get_active_view (self);
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
}


void main_window_on_edit_redo (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	g_object_get ((GtkSourceBuffer*) _tmp1_, "can-redo", &_tmp2_, NULL);
	if (_tmp2_) {
		Document* _tmp3_ = NULL;
		DocumentView* _tmp4_ = NULL;
		DocumentView* _tmp5_ = NULL;
		_tmp3_ = main_window_get_active_document (self);
		gtk_source_buffer_redo ((GtkSourceBuffer*) _tmp3_);
		_tmp4_ = main_window_get_active_view (self);
		document_view_scroll_to_cursor (_tmp4_, 0.25);
		_tmp5_ = main_window_get_active_view (self);
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
}


void main_window_on_edit_cut (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_cut_selection (_tmp1_);
}


void main_window_on_edit_copy (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_copy_selection (_tmp1_);
}


void main_window_on_edit_paste (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_my_paste_clipboard (_tmp1_);
}


void main_window_on_edit_delete (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_delete_selection (_tmp1_);
}


void main_window_on_edit_select_all (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_my_select_all (_tmp1_);
}


void main_window_on_edit_comment (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	document_comment_selected_lines (_tmp1_);
}


void main_window_on_edit_uncomment (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	document_uncomment_selected_lines (_tmp1_);
}


void main_window_on_open_preferences (MainWindow* self) {
	g_return_if_fail (self != NULL);
	preferences_dialog_show_me (self);
}


void main_window_on_show_side_panel (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean _tmp1_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL);
	show = _tmp1_;
	if (show) {
		gtk_widget_show ((GtkWidget*) self->priv->side_panel);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->side_panel);
	}
}


void main_window_on_show_bottom_panel (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean _tmp1_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL);
	show = _tmp1_;
	if (show) {
		gtk_widget_show_all ((GtkWidget*) self->priv->build_view);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->build_view);
	}
}


void main_window_on_show_main_toolbar (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean _tmp1_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL);
	show = _tmp1_;
	if (show) {
		gtk_widget_show_all ((GtkWidget*) self->priv->main_toolbar);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->main_toolbar);
	}
}


void main_window_on_show_edit_toolbar (MainWindow* self, GtkAction* action) {
	GtkAction* _tmp0_;
	gboolean _tmp1_;
	gboolean show;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (GTK_IS_TOGGLE_ACTION (_tmp0_) ? ((GtkToggleAction*) _tmp0_) : NULL);
	show = _tmp1_;
	if (show) {
		gtk_widget_show_all ((GtkWidget*) self->priv->edit_toolbar);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->edit_toolbar);
	}
}


void main_window_on_view_zoom_in (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_enlarge_font (_tmp1_);
}


void main_window_on_view_zoom_out (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_shrink_font (_tmp1_);
}


void main_window_on_view_zoom_reset (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_view (self);
	document_view_set_font_from_settings (_tmp1_);
}


void main_window_on_search_find (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	search_and_replace_show_search (self->priv->search_and_replace);
}


void main_window_on_search_replace (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	search_and_replace_show_search_and_replace (self->priv->search_and_replace);
}


void main_window_on_search_goto_line (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	goto_line_show (self->priv->goto_line);
}


void main_window_on_build_stop_execution (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tool_runner != NULL);
	build_tool_runner_abort (self->priv->build_tool_runner);
	build_view_show (self->priv->build_view);
}


void main_window_on_build_clean (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	CleanBuildFiles* _tmp2_ = NULL;
	CleanBuildFiles* build_files;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	_tmp2_ = clean_build_files_new (self, _tmp1_);
	build_files = _tmp2_;
	_tmp3_ = clean_build_files_clean (build_files);
	if (_tmp3_) {
		Document* _tmp4_ = NULL;
		_tmp4_ = main_window_get_active_document (self);
		file_browser_refresh_for_document (self->priv->file_browser, _tmp4_);
	}
	_g_object_unref0 (build_files);
}


void main_window_on_build_view_log (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gboolean _tmp2_;
	Document* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* mainfile;
	GFile* _tmp5_ = NULL;
	GFile* directory;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* basename;
	GFile* _tmp12_ = NULL;
	GFile* file;
	DocumentTab* _tmp13_ = NULL;
	DocumentTab* tab;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	_tmp2_ = document_is_main_file_a_tex_file (_tmp1_);
	g_return_if_fail (_tmp2_);
	_tmp3_ = main_window_get_active_document (self);
	_tmp4_ = document_get_main_file (_tmp3_);
	mainfile = _tmp4_;
	_tmp5_ = g_file_get_parent (mainfile);
	directory = _tmp5_;
	_tmp6_ = g_file_get_basename (mainfile);
	_tmp7_ = _tmp6_;
	_tmp8_ = utils_get_shortname (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ".log", NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	basename = _tmp11_;
	_tmp12_ = g_file_get_child (directory, basename);
	file = _tmp12_;
	_tmp13_ = main_window_open_document (self, file, TRUE);
	tab = _tmp13_;
	if (tab == NULL) {
		g_warning ("main_window.vala:1744: Impossible to view log");
	} else {
		Document* _tmp14_ = NULL;
		_tmp14_ = document_tab_get_document (tab);
		document_set_readonly (_tmp14_, TRUE);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
}


void main_window_on_build_show_errors (MainWindow* self, GtkAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_toggle_action_get_active (GTK_TOGGLE_ACTION (action));
	build_view_set_show_errors (self->priv->build_view, _tmp0_);
}


void main_window_on_build_show_warnings (MainWindow* self, GtkAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_toggle_action_get_active (GTK_TOGGLE_ACTION (action));
	build_view_set_show_warnings (self->priv->build_view, _tmp0_);
}


void main_window_on_build_show_badboxes (MainWindow* self, GtkAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_toggle_action_get_active (GTK_TOGGLE_ACTION (action));
	build_view_set_show_badboxes (self->priv->build_view, _tmp0_);
}


void main_window_on_documents_save_all (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_unsaved_documents (self);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp1_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp2_;
			Document* doc;
			_tmp2_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp2_;
			{
				document_save (doc, TRUE, FALSE);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
}


void main_window_on_documents_close_all (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	main_window_close_all_documents (self);
}


void main_window_on_documents_previous (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	gtk_notebook_prev_page ((GtkNotebook*) self->priv->documents_panel);
}


void main_window_on_documents_next (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	gtk_notebook_next_page ((GtkNotebook*) self->priv->documents_panel);
}


void main_window_on_documents_move_to_new_window (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_tab (self);
	main_window_move_tab_to_new_window (self, _tmp1_);
}


void main_window_on_projects_new (MainWindow* self) {
	g_return_if_fail (self != NULL);
	project_dialogs_new_project (self);
}


void main_window_on_projects_config_current (MainWindow* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gint _tmp2_;
	Document* _tmp3_ = NULL;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = main_window_get_active_document (self);
	_tmp2_ = document_get_project_id (_tmp1_);
	g_return_if_fail (_tmp2_ != (-1));
	_tmp3_ = main_window_get_active_document (self);
	_tmp4_ = document_get_project_id (_tmp3_);
	project_dialogs_configure_project ((GtkWindow*) self, _tmp4_);
}


void main_window_on_projects_manage (MainWindow* self) {
	g_return_if_fail (self != NULL);
	project_dialogs_manage_projects (self);
}


void main_window_on_structure_cut (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_CUT);
}


void main_window_on_structure_copy (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_COPY);
}


void main_window_on_structure_delete (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_DELETE);
}


void main_window_on_structure_select (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_SELECT);
}


void main_window_on_structure_comment (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_COMMENT);
}


void main_window_on_structure_shift_left (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_SHIFT_LEFT);
}


void main_window_on_structure_shift_right (MainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_structure != NULL);
	structure_do_action (self->priv->_structure, STRUCT_ACTION_SHIFT_RIGHT);
}


void main_window_on_help_contents (MainWindow* self) {
	GdkScreen* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	gtk_show_uri (_tmp0_, "ghelp:latexila", (guint32) GDK_CURRENT_TIME, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("main_window.vala:1870: Impossible to open the documentation: %s", e->message);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void main_window_on_help_latex_reference (MainWindow* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* uri;
	GdkScreen* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_build_filename (DATA_DIR, "latexhelp.html", NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_filename_to_uri (_tmp1_, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	uri = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch21_g_error;
	}
	_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
	gtk_show_uri (_tmp4_, uri, (guint32) GDK_CURRENT_TIME, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (uri);
		goto __catch21_g_error;
	}
	_g_free0 (uri);
	goto __finally21;
	__catch21_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("main_window.vala:1884: Impossible to open the LaTeX reference: %s", e->message);
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void main_window_on_about_dialog (MainWindow* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* comments;
	gchar* _tmp2_;
	gchar* copyright;
	gchar* _tmp3_;
	gchar* licence;
	gchar* _tmp4_;
	gchar* website;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_ = NULL;
	gchar** artists;
	gint artists_length1;
	gint _artists_size_;
	GdkPixbuf* logo;
	GdkPixbuf* _tmp13_ = NULL;
	GdkPixbuf* _tmp14_;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("LaTeXila is an Integrated LaTeX Environment for the GNOME Desktop");
	_tmp1_ = g_strdup (_tmp0_);
	comments = _tmp1_;
	_tmp2_ = g_strdup ("Copyright (C) 2009-2011 Sébastien Wilmet");
	copyright = _tmp2_;
	_tmp3_ = g_strdup ("LaTeXila is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"LaTeXila is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.");
	licence = _tmp3_;
	_tmp4_ = g_strdup ("http://projects.gnome.org/latexila/");
	website = _tmp4_;
	_tmp5_ = g_strdup ("Sébastien Wilmet <sebastien.wilmet@gmail.com>");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp6_[1] = NULL;
	authors = _tmp6_;
	authors_length1 = 2;
	_authors_size_ = 2;
	_tmp7_ = g_strdup ("Ann Melnichuk <melnichu@qtp.ufl.edu>");
	_tmp8_ = g_strdup ("Eric Forgeot <e.forgeot@laposte.net>");
	_tmp9_ = g_strdup ("Sébastien Wilmet <sebastien.wilmet@gmail.com>");
	_tmp10_ = g_strdup ("The Kile Team: http://kile.sourceforge.net/");
	_tmp11_ = g_strdup ("Gedit LaTeX Plugin: http://www.michaels-website.de/gedit-latex-plugin/");
	_tmp12_ = g_new0 (gchar*, 6 + 1);
	_tmp12_[0] = _tmp7_;
	_tmp12_[1] = _tmp8_;
	_tmp12_[2] = _tmp9_;
	_tmp12_[3] = _tmp10_;
	_tmp12_[4] = _tmp11_;
	_tmp12_[5] = NULL;
	artists = _tmp12_;
	artists_length1 = 6;
	_artists_size_ = 6;
	logo = NULL;
	_tmp13_ = gdk_pixbuf_new_from_file (DATA_DIR "/images/app/logo.png", &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_g_object_unref0 (logo);
	logo = _tmp14_;
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("main_window.vala:1932: Logo: %s", e->message);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (logo);
		artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
		authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (website);
		_g_free0 (licence);
		_g_free0 (copyright);
		_g_free0 (comments);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = _ ("About LaTeXila");
	_tmp16_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", "LaTeXila", "version", APP_VERSION, "authors", authors, "artists", artists, "comments", comments, "copyright", copyright, "license", licence, "title", _tmp15_, "translator-credits", _tmp16_, "website", website, "logo", logo, NULL, NULL);
	_g_object_unref0 (logo);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (website);
	_g_free0 (licence);
	_g_free0 (copyright);
	_g_free0 (comments);
}


DocumentTab* main_window_get_active_tab (MainWindow* self) {
	DocumentTab* result;
	gint _tmp0_;
	DocumentTab* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_notebook_get_n_pages ((GtkNotebook*) self->priv->documents_panel);
	if (_tmp0_ == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = documents_panel_get_active_tab (self->priv->documents_panel);
	result = _tmp1_;
	return result;
}


void main_window_set_active_tab (MainWindow* self, DocumentTab* value) {
	gint _tmp0_;
	gint n;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_notebook_page_num ((GtkNotebook*) self->priv->documents_panel, (GtkWidget*) value);
	n = _tmp0_;
	if (n != (-1)) {
		gtk_notebook_set_current_page ((GtkNotebook*) self->priv->documents_panel, n);
	}
	g_object_notify ((GObject *) self, "active-tab");
}


DocumentView* main_window_get_active_view (MainWindow* self) {
	DocumentView* result;
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentView* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = main_window_get_active_tab (self);
	_tmp2_ = document_tab_get_view (_tmp1_);
	result = _tmp2_;
	return result;
}


Document* main_window_get_active_document (MainWindow* self) {
	Document* result;
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	Document* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_window_get_active_tab (self);
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = main_window_get_active_tab (self);
	_tmp2_ = document_tab_get_document (_tmp1_);
	result = _tmp2_;
	return result;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB, g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW, g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT, g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void main_window_instance_init (MainWindow * self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	self->priv->file_chooser_current_folder = _tmp1_;
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = MAIN_WINDOW (obj);
	_g_free0 (self->priv->file_chooser_current_folder);
	_g_object_unref0 (self->priv->documents_panel);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->goto_line);
	_g_object_unref0 (self->priv->search_and_replace);
	_g_object_unref0 (self->priv->build_view);
	_g_object_unref0 (self->priv->main_toolbar);
	_g_object_unref0 (self->priv->edit_toolbar);
	_g_object_unref0 (self->priv->side_panel);
	_g_object_unref0 (self->priv->symbols);
	_g_object_unref0 (self->priv->file_browser);
	_g_object_unref0 (self->priv->_structure);
	_g_object_unref0 (self->priv->main_hpaned);
	_g_object_unref0 (self->priv->vpaned);
	_g_object_unref0 (self->priv->ui_manager);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->latex_action_group);
	_g_object_unref0 (self->priv->documents_list_action_group);
	_g_object_unref0 (self->priv->build_tools_action_group);
	_g_object_unref0 (self->priv->build_tool_runner);
	_g_object_unref0 (self->priv->action_stop_exec);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = MAIN_WINDOW (object);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB:
		g_value_set_object (value, main_window_get_active_tab (self));
		break;
		case MAIN_WINDOW_ACTIVE_VIEW:
		g_value_set_object (value, main_window_get_active_view (self));
		break;
		case MAIN_WINDOW_ACTIVE_DOCUMENT:
		g_value_set_object (value, main_window_get_active_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = MAIN_WINDOW (object);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB:
		main_window_set_active_tab (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



