/* main.c generated by valac 0.12.1, the Vala compiler
 * generated from main.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <unique/unique.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unique_message_data_free0(var) ((var == NULL) ? NULL : (var = (unique_message_data_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;


extern gboolean option_version;
gboolean option_version = FALSE;
extern gboolean option_new_document;
gboolean option_new_document = FALSE;
extern gboolean option_new_window;
gboolean option_new_window = FALSE;
extern gchar** remaining_args;
gchar** remaining_args = NULL;
extern gint application_NEW_WINDOW;

gint _vala_main (gchar** args, int args_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
void application_open_documents (Application* self, gchar** uris);
void application_create_document (Application* self);
UniqueResponse application_message (Application* self, UniqueApp* sender, gint command, UniqueMessageData* data, guint time);
static UniqueResponse _application_message_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[5] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &option_version, "Show the application's version", NULL}, {"new-document", 'n', 0, G_OPTION_ARG_NONE, &option_new_document, "Create new document", NULL}, {"new-window", '\0', 0, G_OPTION_ARG_NONE, &option_new_window, "Create a new top-level window in an existing instance of LaTeXila", NULL}, {"", '\0', 0, G_OPTION_ARG_FILENAME_ARRAY, &remaining_args, NULL, "[FILE...]"}, {NULL}};

static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static UniqueResponse _application_message_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self) {
	UniqueResponse result;
	result = application_message (self, _sender, command, message_data, time_);
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* data_dirs_env;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** data_dirs;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp7_ = NULL;
	GOptionContext* _tmp8_ = NULL;
	GOptionContext* context;
	GOptionGroup* _tmp9_ = NULL;
	gboolean command_open;
	UniqueMessageData* _tmp11_ = NULL;
	UniqueMessageData* data;
	UniqueApp* _tmp17_ = NULL;
	UniqueApp* app;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_getenv ("XDG_DATA_DIRS");
	_tmp1_ = g_strdup (_tmp0_);
	data_dirs_env = _tmp1_;
	if (data_dirs_env == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("/usr/local/share:/usr/share");
		_g_free0 (data_dirs_env);
		data_dirs_env = _tmp2_;
	}
	_tmp4_ = _tmp3_ = g_strsplit (data_dirs_env, ":", 0);
	data_dirs = _tmp4_;
	data_dirs_length1 = _vala_array_length (_tmp3_);
	_data_dirs_size_ = _vala_array_length (_tmp3_);
	if (!_vala_string_array_contains (data_dirs, data_dirs_length1, SCHEMA_DIR)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strconcat (SCHEMA_DIR ":", data_dirs_env, NULL);
		_tmp6_ = _tmp5_;
		g_setenv ("XDG_DATA_DIRS", _tmp6_, TRUE);
		_g_free0 (_tmp6_);
	}
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp7_ = _ ("- Integrated LaTeX Environment for GNOME");
	_tmp8_ = g_option_context_new (_tmp7_);
	context = _tmp8_;
	g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
	_tmp9_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (context, _tmp9_);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch57_g_option_error;
		}
		_g_option_context_free0 (context);
		data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data_dirs_env);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	goto __finally57;
	__catch57_g_option_error:
	{
		GError * e;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("main.vala:83: %s", e->message);
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.\n");
		fprintf (stderr, _tmp10_, args[0]);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data_dirs_env);
		return result;
	}
	__finally57:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data_dirs_env);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (option_version) {
		fprintf (stdout, "%s %s\n", APP_NAME, APP_VERSION);
		result = 0;
		_g_option_context_free0 (context);
		data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data_dirs_env);
		return result;
	}
	command_open = FALSE;
	_tmp11_ = unique_message_data_new ();
	data = _tmp11_;
	if (_vala_array_length (remaining_args) != 0) {
		gchar** _tmp12_ = NULL;
		gchar** uris;
		gint uris_length1;
		gint _uris_size_;
		command_open = TRUE;
		_tmp12_ = g_new0 (gchar*, 0 + 1);
		uris = _tmp12_;
		uris_length1 = 0;
		_uris_size_ = 0;
		{
			gchar** arg_collection;
			int arg_collection_length1;
			int arg_it;
			arg_collection = remaining_args;
			arg_collection_length1 = _vala_array_length (remaining_args);
			for (arg_it = 0; arg_it < _vala_array_length (remaining_args); arg_it = arg_it + 1) {
				gchar* _tmp13_;
				gchar* arg;
				_tmp13_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp13_;
				{
					GFile* _tmp14_ = NULL;
					GFile* _tmp15_;
					gchar* _tmp16_ = NULL;
					_tmp14_ = g_file_new_for_path (arg);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_file_get_uri (_tmp15_);
					_vala_array_add14 (&uris, &uris_length1, &_uris_size_, _tmp16_);
					_g_object_unref0 (_tmp15_);
					_g_free0 (arg);
				}
			}
		}
		unique_message_data_set_uris (data, uris);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp17_ = unique_app_new ("org.gnome.latexila", NULL);
	app = _tmp17_;
	unique_app_add_command (app, "new_window", application_NEW_WINDOW);
	g_object_get (app, "is-running", &_tmp18_, NULL);
	if (_tmp18_) {
		gboolean ok;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ok = TRUE;
		if (option_new_window) {
			UniqueResponse _tmp19_;
			UniqueResponse resp;
			_tmp19_ = unique_app_send_message (app, application_NEW_WINDOW, NULL);
			resp = _tmp19_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (ok) {
			_tmp20_ = command_open;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			UniqueResponse _tmp21_;
			UniqueResponse resp;
			_tmp21_ = unique_app_send_message (app, (gint) UNIQUE_OPEN, data);
			resp = _tmp21_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (ok) {
			_tmp22_ = option_new_document;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			UniqueResponse _tmp23_;
			UniqueResponse resp;
			_tmp23_ = unique_app_send_message (app, (gint) UNIQUE_NEW, NULL);
			resp = _tmp23_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (!option_new_window) {
			_tmp25_ = !command_open;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			_tmp24_ = !option_new_document;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			UniqueResponse _tmp26_;
			UniqueResponse resp;
			_tmp26_ = unique_app_send_message (app, (gint) UNIQUE_ACTIVATE, NULL);
			resp = _tmp26_;
			ok = resp == UNIQUE_RESPONSE_OK;
		}
		if (!ok) {
			g_error ("main.vala:142: Error: communication with first instance of LaTeXila fa" \
"iled\n");
		}
		result = 0;
		_g_object_unref0 (app);
		_unique_message_data_free0 (data);
		_g_option_context_free0 (context);
		data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data_dirs_env);
		return result;
	} else {
		Application* _tmp27_ = NULL;
		Application* latexila;
		GSettings* _tmp28_ = NULL;
		GSettings* editor_settings;
		gboolean _tmp29_;
		_tmp27_ = application_get_default ();
		latexila = _tmp27_;
		_tmp28_ = g_settings_new ("org.gnome.latexila.preferences.editor");
		editor_settings = _tmp28_;
		_tmp29_ = g_settings_get_boolean (editor_settings, "reopen-files");
		if (_tmp29_) {
			GSettings* _tmp30_ = NULL;
			GSettings* window_settings;
			gchar** _tmp31_;
			gchar** _tmp32_ = NULL;
			gchar** uris;
			gint uris_length1;
			gint _uris_size_;
			_tmp30_ = g_settings_new ("org.gnome.latexila.state.window");
			window_settings = _tmp30_;
			_tmp32_ = _tmp31_ = g_settings_get_strv (window_settings, "documents");
			uris = _tmp32_;
			uris_length1 = _vala_array_length (_tmp31_);
			_uris_size_ = _vala_array_length (_tmp31_);
			application_open_documents (latexila, uris);
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (window_settings);
		}
		if (command_open) {
			gchar** _tmp33_ = NULL;
			gchar** _tmp34_;
			gint _tmp34__length1;
			_tmp33_ = unique_message_data_get_uris (data);
			_tmp34_ = _tmp33_;
			_tmp34__length1 = -1;
			application_open_documents (latexila, _tmp34_);
			_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
		}
		if (option_new_document) {
			application_create_document (latexila);
		}
		g_signal_connect_object (app, "message-received", (GCallback) _application_message_unique_app_message_received, latexila, 0);
		gtk_main ();
		_g_object_unref0 (editor_settings);
		_g_object_unref0 (latexila);
	}
	result = 0;
	_g_object_unref0 (app);
	_unique_message_data_free0 (data);
	_g_option_context_free0 (context);
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data_dirs_env);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



