/* search.c generated by valac 0.12.1, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>
#include <config.h>


#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;
typedef struct _Block11Data Block11Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_SELECTION_TYPE (selection_type_get_type ())

struct _GotoLine {
	GtkHBox parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkHBoxClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	GtkEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* main_window;
	Document* working_document;
	GtkWidget* widget;
	GtkButton* button_arrow;
	GtkArrow* arrow;
	GtkEntry* entry_find;
	GtkLabel* label_find_normal;
	GtkLabel* label_find_error;
	GtkEntry* entry_replace;
	GtkFrame* frame_replace;
	GtkHBox* hbox_replace;
	GtkCheckMenuItem* check_case_sensitive;
	GtkCheckMenuItem* check_entire_word;
	gint min_nb_chars_for_incremental_search;
};

struct _Block11Data {
	int _ref_count_;
	SearchAndReplace * self;
	GtkButton* button_clear_find;
	GtkButton* button_clear_replace;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkMenu* menu;
};

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;


static gpointer goto_line_parent_class = NULL;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define GOTO_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GOTO_LINE, GotoLinePrivate))
enum  {
	GOTO_LINE_DUMMY_PROPERTY
};
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
static void _lambda50_ (GotoLine* self);
static void __lambda50__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda51_ (GotoLine* self);
static void __lambda51__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda52_ (GotoLine* self);
static void __lambda52__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void goto_line_show (GotoLine* self);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_goto_line (Document* self, gint line);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
static void goto_line_finalize (GObject* obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
#define SEARCH_AND_REPLACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_AND_REPLACE, SearchAndReplacePrivate))
enum  {
	SEARCH_AND_REPLACE_DUMMY_PROPERTY
};
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void _lambda53_ (GtkEntryIconPosition icon_pos, GdkEvent* event, Block11Data* _data11_);
static void __lambda53__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _lambda54_ (SearchAndReplace* self);
static gboolean search_and_replace_get_search_and_replace_mode (SearchAndReplace* self);
static void __lambda54__gtk_button_clicked (GtkButton* _sender, gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda55_ (SearchAndReplace* self);
static void __lambda55__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda56_ (SearchAndReplace* self);
static void __lambda56__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda57_ (SearchAndReplace* self);
static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select);
void document_search_backward (Document* self);
static void __lambda57__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda58_ (Block11Data* _data11_);
static void search_and_replace_clear_search (SearchAndReplace* self);
static void __lambda58__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda59_ (Block11Data* _data11_);
static void __lambda59__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda60_ (SearchAndReplace* self);
static void __lambda60__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda61_ (SearchAndReplace* self);
static void __lambda61__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda63_ (SearchAndReplace* self);
void document_replace_all (Document* self, const gchar* text);
static void __lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _lambda64_ (GdkEventKey* event, SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static void search_and_replace_select_selected_search_text (SearchAndReplace* self);
static gboolean __lambda64__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self);
GType selection_type_get_type (void) G_GNUC_CONST;
SelectionType document_get_selection_type (Document* self);
static void search_and_replace_active_document_changed (SearchAndReplace* self);
static void _search_and_replace_active_document_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void search_and_replace_set_label_text (SearchAndReplace* self, const gchar* text, gboolean _error_);
static void search_and_replace_on_search_info_updated (SearchAndReplace* self, gboolean selected, guint nb_matches, guint num_match);
static void _search_and_replace_on_search_info_updated_document_search_info_updated (Document* _sender, gboolean selected, guint nb_matches, guint num_match, gpointer self);
void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self);
static gboolean search_and_replace_get_entire_word (SearchAndReplace* self);
void document_select_selected_search_text (Document* self);
void document_search_forward (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
gboolean document_get_readonly (Document* self);
void document_replace (Document* self, const gchar* text);
static void search_and_replace_finalize (GObject* obj);
static void _vala_search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _lambda50_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda50__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda50_ (self);
}


static void _lambda51_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda51__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	_lambda51_ (self);
}


static void _lambda52_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda52__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda52_ (self);
}


static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	goto_line_on_changed (self);
}


GotoLine* goto_line_construct (GType object_type, MainWindow* main_window) {
	GotoLine * self = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* close_button;
	GtkImage* _tmp1_ = NULL;
	GtkImage* img;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* label;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (GotoLine*) g_object_new (object_type, NULL);
	self->priv->main_window = main_window;
	gtk_box_set_spacing ((GtkBox*) self, 3);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	close_button = g_object_ref_sink (_tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	_tmp1_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	img = g_object_ref_sink (_tmp1_);
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda50__gtk_button_clicked, self, 0);
	_tmp2_ = _ ("Go to Line:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	label = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 2);
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->entry, FALSE, FALSE, (guint) 0);
	gtk_entry_set_icon_from_stock (self->priv->entry, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_JUMP_TO);
	gtk_entry_set_icon_activatable (self->priv->entry, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp5_ = _ ("Line you want to move the cursor to");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->entry, _tmp5_);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->entry, 100, -1);
	g_signal_connect_object (self->priv->entry, "activate", (GCallback) __lambda51__gtk_entry_activate, self, 0);
	g_signal_connect_object (self->priv->entry, "icon-press", (GCallback) __lambda52__gtk_entry_icon_press, self, 0);
	g_signal_connect_object ((GtkEditable*) self->priv->entry, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	_g_object_unref0 (close_button);
	return self;
}


GotoLine* goto_line_new (MainWindow* main_window) {
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
}


void goto_line_show (GotoLine* self) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry, "");
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void goto_line_on_changed (GotoLine* self) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* text;
	gint _tmp7_;
	gint line;
	Document* _tmp8_ = NULL;
	gboolean _tmp9_;
	gboolean _error_;
	DocumentView* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text_length (self->priv->entry);
	if (_tmp0_ == 0) {
		utils_set_entry_error ((GtkWidget*) self->priv->entry, FALSE);
		return;
	}
	_tmp1_ = gtk_entry_get_text (self->priv->entry);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gchar _tmp5_;
				gunichar c;
				gboolean _tmp6_;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				_tmp4_ = strlen (text);
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = string_get (text, (glong) i);
				c = (gunichar) _tmp5_;
				_tmp6_ = g_unichar_isdigit (c);
				if (!_tmp6_) {
					utils_set_entry_error ((GtkWidget*) self->priv->entry, TRUE);
					_g_free0 (text);
					return;
				}
			}
		}
	}
	_tmp7_ = atoi (text);
	line = _tmp7_;
	_tmp8_ = main_window_get_active_document (self->priv->main_window);
	line = line - 1;
	_tmp9_ = document_goto_line (_tmp8_, line);
	_error_ = !_tmp9_;
	utils_set_entry_error ((GtkWidget*) self->priv->entry, _error_);
	_tmp10_ = main_window_get_active_view (self->priv->main_window);
	document_view_scroll_to_cursor (_tmp10_, 0.25);
	_g_free0 (text);
}


static void goto_line_class_init (GotoLineClass * klass) {
	goto_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GotoLinePrivate));
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
}


static void goto_line_instance_init (GotoLine * self) {
	self->priv = GOTO_LINE_GET_PRIVATE (self);
}


static void goto_line_finalize (GObject* obj) {
	GotoLine * self;
	self = GOTO_LINE (obj);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
}


GType goto_line_get_type (void) {
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (GTK_TYPE_HBOX, "GotoLine", &g_define_type_info, 0);
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->menu);
		_g_object_unref0 (_data11_->button_next);
		_g_object_unref0 (_data11_->button_previous);
		_g_object_unref0 (_data11_->button_replace_all);
		_g_object_unref0 (_data11_->button_replace);
		_g_object_unref0 (_data11_->button_clear_replace);
		_g_object_unref0 (_data11_->button_clear_find);
		g_slice_free (Block11Data, _data11_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda53_ (GtkEntryIconPosition icon_pos, GdkEvent* event, Block11Data* _data11_) {
	SearchAndReplace * self;
	self = _data11_->self;
	g_return_if_fail (event != NULL);
	if (icon_pos == GTK_ENTRY_ICON_PRIMARY) {
		gtk_menu_popup (_data11_->menu, NULL, NULL, NULL, NULL, event->button.button, event->button.time);
	}
}


static void __lambda53__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda53_ (p0, p1, self);
}


static void _lambda54_ (SearchAndReplace* self) {
	gboolean _tmp0_;
	_tmp0_ = search_and_replace_get_search_and_replace_mode (self);
	if (_tmp0_) {
		g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_DOWN, NULL);
		gtk_widget_hide ((GtkWidget*) self->priv->frame_replace);
		gtk_widget_hide ((GtkWidget*) self->priv->hbox_replace);
	} else {
		g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_UP, NULL);
		gtk_widget_show ((GtkWidget*) self->priv->frame_replace);
		gtk_widget_show ((GtkWidget*) self->priv->hbox_replace);
	}
}


static void __lambda54__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda54_ (self);
}


static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_hide (self);
}


static void _lambda55_ (SearchAndReplace* self) {
	gtk_entry_set_text (self->priv->entry_find, "");
}


static void __lambda55__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda55_ (self);
}


static void _lambda56_ (SearchAndReplace* self) {
	gtk_entry_set_text (self->priv->entry_replace, "");
}


static void __lambda56__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda56_ (self);
}


static void _lambda57_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, FALSE);
	g_return_if_fail (self->priv->working_document != NULL);
	document_search_backward (self->priv->working_document);
}


static void __lambda57__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda57_ (self);
}


static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void _lambda58_ (Block11Data* _data11_) {
	SearchAndReplace * self;
	guint _tmp0_;
	gboolean sensitive;
	guint _tmp1_;
	self = _data11_->self;
	_tmp0_ = gtk_entry_get_text_length (self->priv->entry_find);
	sensitive = _tmp0_ > 0;
	gtk_widget_set_sensitive ((GtkWidget*) _data11_->button_clear_find, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data11_->button_previous, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data11_->button_next, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data11_->button_replace, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data11_->button_replace_all, sensitive);
	_tmp1_ = gtk_entry_get_text_length (self->priv->entry_find);
	if (_tmp1_ == 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
		search_and_replace_clear_search (self);
	} else {
		guint _tmp2_;
		_tmp2_ = gtk_entry_get_text_length (self->priv->entry_find);
		if (_tmp2_ >= self->priv->min_nb_chars_for_incremental_search) {
			search_and_replace_set_search_text (self, TRUE);
		}
	}
}


static void __lambda58__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda58_ (self);
}


static void _lambda59_ (Block11Data* _data11_) {
	SearchAndReplace * self;
	guint _tmp0_;
	self = _data11_->self;
	_tmp0_ = gtk_entry_get_text_length (self->priv->entry_replace);
	gtk_widget_set_sensitive ((GtkWidget*) _data11_->button_clear_replace, _tmp0_ > 0);
}


static void __lambda59__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda59_ (self);
}


static void _lambda60_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void __lambda60__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda60_ (self);
}


static void _lambda61_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void __lambda61__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda61_ (self);
}


static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void _lambda63_ (SearchAndReplace* self) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = gtk_entry_get_text_length (self->priv->entry_find);
	g_return_if_fail (_tmp0_ != 0);
	search_and_replace_set_search_text (self, TRUE);
	_tmp1_ = gtk_entry_get_text (self->priv->entry_replace);
	document_replace_all (self->priv->working_document, _tmp1_);
}


static void __lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda63_ (self);
}


static gboolean _lambda64_ (GdkEventKey* event, SearchAndReplace* self) {
	gboolean result = FALSE;
	switch ((*event).keyval) {
		case 0xff09:
		{
			search_and_replace_show_search_and_replace (self);
			gtk_widget_grab_focus ((GtkWidget*) self->priv->entry_replace);
			result = TRUE;
			return result;
		}
		case 0xff1b:
		{
			search_and_replace_select_selected_search_text (self);
			search_and_replace_hide (self);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean __lambda64__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _lambda64_ (event, self);
	return result;
}


SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window) {
	SearchAndReplace * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* path;
	Block11Data* _data11_;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GObject* _tmp6_ = NULL;
	GtkArrow* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkEntry* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkLabel* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkLabel* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkEventBox* _tmp15_;
	GtkEventBox* eventbox_label1;
	GObject* _tmp16_ = NULL;
	GtkEventBox* _tmp17_;
	GtkEventBox* eventbox_label2;
	GObject* _tmp18_ = NULL;
	GtkButton* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkEntry* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkFrame* _tmp23_;
	GObject* _tmp24_ = NULL;
	GtkButton* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkButton* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkButton* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkHBox* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkButton* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkButton* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkButton* _tmp37_;
	GtkButton* button_close;
	GdkColor white = {0};
	GdkColor _tmp38_ = {0};
	GtkMenu* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkCheckMenuItem* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GtkCheckMenuItem* _tmp43_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	self->priv->main_window = main_window;
	_tmp0_ = g_build_filename (DATA_DIR, "ui", "search_and_replace.ui", NULL);
	path = _tmp0_;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	gtk_builder_add_from_file (builder, path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block11_data_unref (_data11_);
		_data11_ = NULL;
		goto __catch32_g_error;
	}
	_tmp2_ = gtk_builder_get_object (builder, "search_and_replace");
	_tmp3_ = _g_object_ref0 (GTK_WIDGET (_tmp2_));
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp3_;
	gtk_widget_unparent (self->priv->widget);
	_tmp4_ = gtk_builder_get_object (builder, "button_arrow");
	_tmp5_ = _g_object_ref0 (GTK_BUTTON (_tmp4_));
	_g_object_unref0 (self->priv->button_arrow);
	self->priv->button_arrow = _tmp5_;
	_tmp6_ = gtk_builder_get_object (builder, "arrow");
	_tmp7_ = _g_object_ref0 (GTK_ARROW (_tmp6_));
	_g_object_unref0 (self->priv->arrow);
	self->priv->arrow = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "entry_find");
	_tmp9_ = _g_object_ref0 (GTK_ENTRY (_tmp8_));
	_g_object_unref0 (self->priv->entry_find);
	self->priv->entry_find = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "label_find_normal");
	_tmp11_ = _g_object_ref0 (GTK_LABEL (_tmp10_));
	_g_object_unref0 (self->priv->label_find_normal);
	self->priv->label_find_normal = _tmp11_;
	_tmp12_ = gtk_builder_get_object (builder, "label_find_error");
	_tmp13_ = _g_object_ref0 (GTK_LABEL (_tmp12_));
	_g_object_unref0 (self->priv->label_find_error);
	self->priv->label_find_error = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "eventbox_label1");
	_tmp15_ = _g_object_ref0 (GTK_EVENT_BOX (_tmp14_));
	eventbox_label1 = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "eventbox_label2");
	_tmp17_ = _g_object_ref0 (GTK_EVENT_BOX (_tmp16_));
	eventbox_label2 = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "button_clear_find");
	_tmp19_ = _g_object_ref0 (GTK_BUTTON (_tmp18_));
	_data11_->button_clear_find = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "entry_replace");
	_tmp21_ = _g_object_ref0 (GTK_ENTRY (_tmp20_));
	_g_object_unref0 (self->priv->entry_replace);
	self->priv->entry_replace = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "frame_replace");
	_tmp23_ = _g_object_ref0 (GTK_FRAME (_tmp22_));
	_g_object_unref0 (self->priv->frame_replace);
	self->priv->frame_replace = _tmp23_;
	_tmp24_ = gtk_builder_get_object (builder, "button_clear_replace");
	_tmp25_ = _g_object_ref0 (GTK_BUTTON (_tmp24_));
	_data11_->button_clear_replace = _tmp25_;
	_tmp26_ = gtk_builder_get_object (builder, "button_replace");
	_tmp27_ = _g_object_ref0 (GTK_BUTTON (_tmp26_));
	_data11_->button_replace = _tmp27_;
	_tmp28_ = gtk_builder_get_object (builder, "button_replace_all");
	_tmp29_ = _g_object_ref0 (GTK_BUTTON (_tmp28_));
	_data11_->button_replace_all = _tmp29_;
	_tmp30_ = gtk_builder_get_object (builder, "hbox_replace");
	_tmp31_ = _g_object_ref0 (GTK_HBOX (_tmp30_));
	_g_object_unref0 (self->priv->hbox_replace);
	self->priv->hbox_replace = _tmp31_;
	_tmp32_ = gtk_builder_get_object (builder, "button_previous");
	_tmp33_ = _g_object_ref0 (GTK_BUTTON (_tmp32_));
	_data11_->button_previous = _tmp33_;
	_tmp34_ = gtk_builder_get_object (builder, "button_next");
	_tmp35_ = _g_object_ref0 (GTK_BUTTON (_tmp34_));
	_data11_->button_next = _tmp35_;
	_tmp36_ = gtk_builder_get_object (builder, "button_close");
	_tmp37_ = _g_object_ref0 (GTK_BUTTON (_tmp36_));
	button_close = _tmp37_;
	gdk_color_parse ("white", &_tmp38_);
	white = _tmp38_;
	gtk_widget_modify_bg ((GtkWidget*) eventbox_label1, GTK_STATE_NORMAL, &white);
	gtk_widget_modify_bg ((GtkWidget*) eventbox_label2, GTK_STATE_NORMAL, &white);
	_tmp39_ = (GtkMenu*) gtk_menu_new ();
	_data11_->menu = g_object_ref_sink (_tmp39_);
	_tmp40_ = _ ("Case sensitive");
	_tmp41_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp40_);
	_g_object_unref0 (self->priv->check_case_sensitive);
	self->priv->check_case_sensitive = g_object_ref_sink (_tmp41_);
	_tmp42_ = _ ("Entire words only");
	_tmp43_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp42_);
	_g_object_unref0 (self->priv->check_entire_word);
	self->priv->check_entire_word = g_object_ref_sink (_tmp43_);
	gtk_menu_shell_append ((GtkMenuShell*) _data11_->menu, (GtkWidget*) ((GtkMenuItem*) self->priv->check_case_sensitive));
	gtk_menu_shell_append ((GtkMenuShell*) _data11_->menu, (GtkWidget*) ((GtkMenuItem*) self->priv->check_entire_word));
	gtk_widget_show_all ((GtkWidget*) _data11_->menu);
	g_signal_connect_data (self->priv->entry_find, "icon-press", (GCallback) __lambda53__gtk_entry_icon_press, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	g_signal_connect_object (self->priv->button_arrow, "clicked", (GCallback) __lambda54__gtk_button_clicked, self, 0);
	g_signal_connect_object (button_close, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
	g_signal_connect_object (_data11_->button_clear_find, "clicked", (GCallback) __lambda55__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data11_->button_clear_replace, "clicked", (GCallback) __lambda56__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data11_->button_previous, "clicked", (GCallback) __lambda57__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data11_->button_next, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->entry_find, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
	g_signal_connect_data ((GtkEditable*) self->priv->entry_find, "changed", (GCallback) __lambda58__gtk_editable_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	g_signal_connect_data ((GtkEditable*) self->priv->entry_replace, "changed", (GCallback) __lambda59__gtk_editable_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	g_signal_connect_object (self->priv->check_case_sensitive, "toggled", (GCallback) __lambda60__gtk_check_menu_item_toggled, self, 0);
	g_signal_connect_object (self->priv->check_entire_word, "toggled", (GCallback) __lambda61__gtk_check_menu_item_toggled, self, 0);
	g_signal_connect_object (_data11_->button_replace, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->entry_replace, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
	g_signal_connect_object (_data11_->button_replace_all, "clicked", (GCallback) __lambda63__gtk_button_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->entry_find, "key-press-event", (GCallback) __lambda64__gtk_widget_key_press_event, self, 0);
	_g_object_unref0 (button_close);
	_g_object_unref0 (eventbox_label2);
	_g_object_unref0 (eventbox_label1);
	_g_object_unref0 (builder);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	goto __finally32;
	__catch32_g_error:
	{
		GError * e;
		GtkLabel* _tmp44_ = NULL;
		GtkLabel* label;
		GtkWidget* _tmp45_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("search.vala:288: Search and replace: %s", e->message);
		_tmp44_ = (GtkLabel*) gtk_label_new (e->message);
		label = g_object_ref_sink (_tmp44_);
		gtk_label_set_line_wrap (label, TRUE);
		_tmp45_ = _g_object_ref0 ((GtkWidget*) label);
		_g_object_unref0 (self->priv->widget);
		self->priv->widget = _tmp45_;
		_g_object_unref0 (label);
		_g_error_free0 (e);
	}
	__finally32:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_widget_hide (self->priv->widget);
	_g_free0 (path);
	return self;
}


SearchAndReplace* search_and_replace_new (MainWindow* main_window) {
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}


GtkWidget* search_and_replace_get_widget (SearchAndReplace* self) {
	GtkWidget* result = NULL;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->widget);
	result = _tmp0_;
	return result;
}


void search_and_replace_show_search (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_DOWN, NULL);
	search_and_replace_show (self);
	gtk_widget_hide ((GtkWidget*) self->priv->frame_replace);
	gtk_widget_hide ((GtkWidget*) self->priv->hbox_replace);
}


void search_and_replace_show_search_and_replace (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_UP, NULL);
	search_and_replace_show (self);
}


static void _search_and_replace_active_document_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	search_and_replace_active_document_changed (self);
}


static void search_and_replace_show (SearchAndReplace* self) {
	DocumentTab* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	Document* _tmp2_;
	Document* doc;
	SelectionType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self->priv->main_window);
	g_return_if_fail (_tmp0_ != NULL);
	gtk_widget_show_all (self->priv->widget);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->entry_find);
	search_and_replace_set_replace_sensitivity (self);
	_tmp1_ = main_window_get_active_document (self->priv->main_window);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	_tmp3_ = document_get_selection_type (doc);
	if (_tmp3_ == SELECTION_TYPE_ONE_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) doc, &_tmp4_, &_tmp5_);
		start = _tmp4_;
		end = _tmp5_;
		_tmp6_ = gtk_text_buffer_get_text ((GtkTextBuffer*) doc, &start, &end, FALSE);
		_tmp7_ = _tmp6_;
		gtk_entry_set_text (self->priv->entry_find, _tmp7_);
		_g_free0 (_tmp7_);
	}
	g_signal_connect_object ((GObject*) self->priv->main_window, "notify::active-document", (GCallback) _search_and_replace_active_document_changed_g_object_notify, self, 0);
	_g_object_unref0 (doc);
}


void search_and_replace_hide (SearchAndReplace* self) {
	DocumentView* _tmp0_ = NULL;
	guint _tmp2_;
	GQuark _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide (self->priv->widget);
	if (self->priv->working_document != NULL) {
		search_and_replace_clear_search (self);
	}
	_tmp0_ = main_window_get_active_view (self->priv->main_window);
	if (_tmp0_ != NULL) {
		DocumentView* _tmp1_ = NULL;
		_tmp1_ = main_window_get_active_view (self->priv->main_window);
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	}
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->main_window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _search_and_replace_active_document_changed_g_object_notify, self);
}


static void search_and_replace_set_label_text (SearchAndReplace* self, const gchar* text, gboolean _error_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (_error_) {
		gtk_label_set_text (self->priv->label_find_error, text);
		gtk_widget_show ((GtkWidget*) self->priv->label_find_error);
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
	} else {
		gtk_label_set_text (self->priv->label_find_normal, text);
		gtk_widget_show ((GtkWidget*) self->priv->label_find_normal);
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
	}
}


static void _search_and_replace_on_search_info_updated_document_search_info_updated (Document* _sender, gboolean selected, guint nb_matches, guint num_match, gpointer self) {
	search_and_replace_on_search_info_updated (self, selected, nb_matches, num_match);
}


static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select) {
	Document* _tmp0_ = NULL;
	guint _tmp1_;
	Document* _tmp2_ = NULL;
	guint nb_matches = 0U;
	guint num_match = 0U;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_document (self->priv->main_window);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = gtk_entry_get_text_length (self->priv->entry_find);
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = main_window_get_active_document (self->priv->main_window);
	if (_tmp2_ != self->priv->working_document) {
		Document* _tmp3_ = NULL;
		Document* _tmp4_;
		if (self->priv->working_document != NULL) {
			search_and_replace_clear_search (self);
		}
		_tmp3_ = main_window_get_active_document (self->priv->main_window);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->working_document);
		self->priv->working_document = _tmp4_;
		g_signal_connect_object (self->priv->working_document, "search-info-updated", (GCallback) _search_and_replace_on_search_info_updated_document_search_info_updated, self, 0);
	}
	_tmp5_ = gtk_entry_get_text (self->priv->entry_find);
	_tmp6_ = search_and_replace_get_case_sensitive (self);
	_tmp7_ = search_and_replace_get_entire_word (self);
	document_set_search_text (self->priv->working_document, _tmp5_, _tmp6_, _tmp7_, &_tmp8_, &_tmp9_, select);
	nb_matches = _tmp8_;
	num_match = _tmp9_;
	search_and_replace_on_search_info_updated (self, nb_matches != 0, nb_matches, num_match);
}


static void search_and_replace_select_selected_search_text (SearchAndReplace* self) {
	Document* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_document (self->priv->main_window);
	g_return_if_fail (_tmp0_ != NULL);
	if (self->priv->working_document != NULL) {
	}
	document_select_selected_search_text (self->priv->working_document);
}


static void search_and_replace_search_forward (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	search_and_replace_set_search_text (self, FALSE);
	g_return_if_fail (self->priv->working_document != NULL);
	document_search_forward (self->priv->working_document);
}


static void search_and_replace_on_search_info_updated (SearchAndReplace* self, gboolean selected, guint nb_matches, guint num_match) {
	g_return_if_fail (self != NULL);
	if (selected) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = _ ("%u of %u");
		_tmp1_ = g_strdup_printf (_tmp0_, num_match, nb_matches);
		_tmp2_ = _tmp1_;
		search_and_replace_set_label_text (self, _tmp2_, FALSE);
		_g_free0 (_tmp2_);
	} else {
		if (nb_matches == 0) {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = _ ("Not found");
			search_and_replace_set_label_text (self, _tmp3_, TRUE);
		} else {
			if (nb_matches == 1) {
				const gchar* _tmp4_ = NULL;
				_tmp4_ = _ ("One match");
				search_and_replace_set_label_text (self, _tmp4_, FALSE);
			} else {
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				_tmp5_ = _ ("%u matches");
				_tmp6_ = g_strdup_printf (_tmp5_, nb_matches);
				_tmp7_ = _tmp6_;
				search_and_replace_set_label_text (self, _tmp7_, FALSE);
				_g_free0 (_tmp7_);
			}
		}
	}
}


static void search_and_replace_clear_search (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->working_document != NULL) {
		guint _tmp0_;
		document_clear_search (self->priv->working_document, TRUE);
		g_signal_parse_name ("search-info-updated", TYPE_DOCUMENT, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->working_document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _search_and_replace_on_search_info_updated_document_search_info_updated, self);
		_g_object_unref0 (self->priv->working_document);
		self->priv->working_document = NULL;
	}
}


static void search_and_replace_active_document_changed (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
	search_and_replace_set_replace_sensitivity (self);
}


static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self) {
	Document* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean readonly;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_document (self->priv->main_window);
	_tmp1_ = document_get_readonly (_tmp0_);
	readonly = _tmp1_;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->frame_replace, !readonly);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->hbox_replace, !readonly);
}


static void search_and_replace_replace (SearchAndReplace* self) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text_length (self->priv->entry_find);
	g_return_if_fail (_tmp0_ != 0);
	search_and_replace_set_search_text (self, TRUE);
	_tmp1_ = gtk_entry_get_text (self->priv->entry_replace);
	document_replace (self->priv->working_document, _tmp1_);
}


static gboolean search_and_replace_get_search_and_replace_mode (SearchAndReplace* self) {
	gboolean result;
	GtkArrowType _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_object_get (self->priv->arrow, "arrow-type", &_tmp0_, NULL);
	result = _tmp0_ == GTK_ARROW_UP;
	return result;
}


static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_check_menu_item_get_active (self->priv->check_case_sensitive);
	result = _tmp0_;
	return result;
}


static gboolean search_and_replace_get_entire_word (SearchAndReplace* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_check_menu_item_get_active (self->priv->check_entire_word);
	result = _tmp0_;
	return result;
}


static void search_and_replace_class_init (SearchAndReplaceClass * klass) {
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchAndReplacePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_search_and_replace_get_property;
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}


static void search_and_replace_instance_init (SearchAndReplace * self) {
	self->priv = SEARCH_AND_REPLACE_GET_PRIVATE (self);
	self->priv->min_nb_chars_for_incremental_search = 3;
}


static void search_and_replace_finalize (GObject* obj) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (obj);
	_g_object_unref0 (self->priv->working_document);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->button_arrow);
	_g_object_unref0 (self->priv->arrow);
	_g_object_unref0 (self->priv->entry_find);
	_g_object_unref0 (self->priv->label_find_normal);
	_g_object_unref0 (self->priv->label_find_error);
	_g_object_unref0 (self->priv->entry_replace);
	_g_object_unref0 (self->priv->frame_replace);
	_g_object_unref0 (self->priv->hbox_replace);
	_g_object_unref0 (self->priv->check_case_sensitive);
	_g_object_unref0 (self->priv->check_entire_word);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}


GType search_and_replace_get_type (void) {
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}


static void _vala_search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



