/* main.c generated by valac 0.16.0, the Vala compiler
 * generated from main.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <gio/gio.h>


#define TYPE_CMD_LINE_DATA (cmd_line_data_get_type ())
typedef struct _CmdLineData CmdLineData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

struct _CmdLineData {
	gboolean new_document;
	gboolean new_window;
	GVariant* files_to_open;
};


extern gchar** files_list;
gchar** files_list = NULL;

GType cmd_line_data_get_type (void) G_GNUC_CONST;
CmdLineData* cmd_line_data_dup (const CmdLineData* self);
void cmd_line_data_free (CmdLineData* self);
void cmd_line_data_copy (const CmdLineData* self, CmdLineData* dest);
void cmd_line_data_destroy (CmdLineData* self);
void check_xdg_data_dirs (void);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void init_i18n (void);
void parse_cmd_line_options (gchar** args, int args_length1, CmdLineData* result);
static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value);
gint _vala_main (gchar** args, int args_length1);
Latexila* latexila_new (void);
Latexila* latexila_construct (GType object_type);
GType latexila_get_type (void) G_GNUC_CONST;
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


void cmd_line_data_copy (const CmdLineData* self, CmdLineData* dest) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	_tmp0_ = (*self).new_document;
	(*dest).new_document = _tmp0_;
	_tmp1_ = (*self).new_window;
	(*dest).new_window = _tmp1_;
	_tmp2_ = (*self).files_to_open;
	_tmp3_ = _g_variant_ref0 (_tmp2_);
	_g_variant_unref0 ((*dest).files_to_open);
	(*dest).files_to_open = _tmp3_;
}


void cmd_line_data_destroy (CmdLineData* self) {
	_g_variant_unref0 ((*self).files_to_open);
}


CmdLineData* cmd_line_data_dup (const CmdLineData* self) {
	CmdLineData* dup;
	dup = g_new0 (CmdLineData, 1);
	cmd_line_data_copy (self, dup);
	return dup;
}


void cmd_line_data_free (CmdLineData* self) {
	cmd_line_data_destroy (self);
	g_free (self);
}


GType cmd_line_data_get_type (void) {
	static volatile gsize cmd_line_data_type_id__volatile = 0;
	if (g_once_init_enter (&cmd_line_data_type_id__volatile)) {
		GType cmd_line_data_type_id;
		cmd_line_data_type_id = g_boxed_type_register_static ("CmdLineData", (GBoxedCopyFunc) cmd_line_data_dup, (GBoxedFreeFunc) cmd_line_data_free);
		g_once_init_leave (&cmd_line_data_type_id__volatile, cmd_line_data_type_id);
	}
	return cmd_line_data_type_id__volatile;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void check_xdg_data_dirs (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* data_dirs_env;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** data_dirs;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	_tmp0_ = g_getenv ("XDG_DATA_DIRS");
	_tmp1_ = g_strdup (_tmp0_);
	data_dirs_env = _tmp1_;
	_tmp2_ = data_dirs_env;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("/usr/local/share:/usr/share");
		_g_free0 (data_dirs_env);
		data_dirs_env = _tmp3_;
	}
	_tmp4_ = data_dirs_env;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
	data_dirs = _tmp6_;
	data_dirs_length1 = _vala_array_length (_tmp5_);
	_data_dirs_size_ = data_dirs_length1;
	_tmp7_ = data_dirs;
	_tmp7__length1 = data_dirs_length1;
	if (!_vala_string_array_contains (_tmp7_, _tmp7__length1, SCHEMA_DIR)) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = data_dirs_env;
		_tmp9_ = g_strconcat (SCHEMA_DIR ":", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_setenv ("XDG_DATA_DIRS", _tmp10_, TRUE);
		_g_free0 (_tmp10_);
	}
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data_dirs_env);
}


void init_i18n (void) {
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
}


static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void parse_cmd_line_options (gchar** args, int args_length1, CmdLineData* result) {
	gboolean show_version;
	CmdLineData data = {0};
	GOptionEntry* _tmp0_ = NULL;
	GOptionEntry* options;
	gint options_length1;
	gint _options_size_;
	GOptionEntry _tmp1_ = {0};
	GOptionEntry _tmp2_;
	GOptionEntry _tmp3_ = {0};
	GOptionEntry _tmp4_;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_;
	GOptionEntry _tmp7_ = {0};
	GOptionEntry _tmp8_;
	GOptionEntry _tmp9_ = {0};
	GOptionEntry _tmp10_;
	const gchar* _tmp11_ = NULL;
	GOptionContext* _tmp12_;
	GOptionContext* context;
	GOptionGroup* _tmp13_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GError * _inner_error_ = NULL;
	show_version = FALSE;
	memset (&data, 0, sizeof (CmdLineData));
	_tmp0_ = g_new0 (GOptionEntry, 5);
	options = _tmp0_;
	options_length1 = 5;
	_options_size_ = options_length1;
	_tmp1_.long_name = "version";
	_tmp1_.short_name = 'V';
	_tmp1_.flags = 0;
	_tmp1_.arg = G_OPTION_ARG_NONE;
	_tmp1_.arg_data = &show_version;
	_tmp1_.description = "Show the application's version";
	_tmp1_.arg_description = NULL;
	options[0] = _tmp1_;
	_tmp2_ = options[0];
	_tmp3_.long_name = "new-document";
	_tmp3_.short_name = 'n';
	_tmp3_.flags = 0;
	_tmp3_.arg = G_OPTION_ARG_NONE;
	_tmp3_.arg_data = &data.new_document;
	_tmp3_.description = "Create new document";
	_tmp3_.arg_description = NULL;
	options[1] = _tmp3_;
	_tmp4_ = options[1];
	_tmp5_.long_name = "new-window";
	_tmp5_.short_name = (gchar) 0;
	_tmp5_.flags = 0;
	_tmp5_.arg = G_OPTION_ARG_NONE;
	_tmp5_.arg_data = &data.new_window;
	_tmp5_.description = "Create a new top-level window in an existing instance of LaTeXila";
	_tmp5_.arg_description = NULL;
	options[2] = _tmp5_;
	_tmp6_ = options[2];
	_tmp7_.long_name = "";
	_tmp7_.short_name = (gchar) 0;
	_tmp7_.flags = 0;
	_tmp7_.arg = G_OPTION_ARG_FILENAME_ARRAY;
	_tmp7_.arg_data = &files_list;
	_tmp7_.description = NULL;
	_tmp7_.arg_description = "[FILE...]";
	options[3] = _tmp7_;
	_tmp8_ = options[3];
	_tmp9_.long_name = NULL;
	options[4] = _tmp9_;
	_tmp10_ = options[4];
	_tmp11_ = _ ("- Integrated LaTeX Environment for GNOME");
	_tmp12_ = g_option_context_new (_tmp11_);
	context = _tmp12_;
	g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
	_tmp13_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (context, _tmp13_);
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch53_g_option_error;
			}
			_g_option_context_free0 (context);
			options = (g_free (options), NULL);
			cmd_line_data_destroy (&data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally53;
	__catch53_g_option_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
		FILE* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e->message;
		g_warning ("main.vala:96: %s", _tmp14_);
		_tmp15_ = stderr;
		_tmp16_ = _ ("Run '%s --help' to see a full list of available command line options.\n");
		_tmp17_ = args;
		_tmp17__length1 = args_length1;
		_tmp18_ = _tmp17_[0];
		fprintf (_tmp15_, _tmp16_, _tmp18_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally53:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		options = (g_free (options), NULL);
		cmd_line_data_destroy (&data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (show_version) {
		FILE* _tmp19_;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "%s %s\n", APP_NAME, APP_VERSION);
		exit (0);
	}
	_tmp20_ = files_list;
	_tmp20__length1 = _vala_array_length (files_list);
	if (_tmp20__length1 == 0) {
		_g_variant_unref0 (data.files_to_open);
		data.files_to_open = NULL;
	} else {
		gchar** _tmp21_ = NULL;
		gchar** uris;
		gint uris_length1;
		gint _uris_size_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar** _tmp29_;
		gint _tmp29__length1;
		GVariant* _tmp30_;
		GVariant* _tmp31_;
		_tmp21_ = g_new0 (gchar*, 0 + 1);
		uris = _tmp21_;
		uris_length1 = 0;
		_uris_size_ = uris_length1;
		_tmp22_ = files_list;
		_tmp22__length1 = _vala_array_length (files_list);
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it = 0;
			filename_collection = _tmp22_;
			filename_collection_length1 = _tmp22__length1;
			for (filename_it = 0; filename_it < _tmp22__length1; filename_it = filename_it + 1) {
				gchar* _tmp23_;
				gchar* filename = NULL;
				_tmp23_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp23_;
				{
					const gchar* _tmp24_;
					GFile* _tmp25_ = NULL;
					GFile* file;
					gchar** _tmp26_;
					gint _tmp26__length1;
					GFile* _tmp27_;
					gchar* _tmp28_ = NULL;
					_tmp24_ = filename;
					_tmp25_ = g_file_new_for_commandline_arg (_tmp24_);
					file = _tmp25_;
					_tmp26_ = uris;
					_tmp26__length1 = uris_length1;
					_tmp27_ = file;
					_tmp28_ = g_file_get_uri (_tmp27_);
					_vala_array_add16 (&uris, &uris_length1, &_uris_size_, _tmp28_);
					_g_object_unref0 (file);
					_g_free0 (filename);
				}
			}
		}
		_tmp29_ = uris;
		_tmp29__length1 = uris_length1;
		_tmp30_ = g_variant_new_strv (_tmp29_, _tmp29__length1);
		_tmp31_ = g_variant_ref_sink (_tmp30_);
		_g_variant_unref0 (data.files_to_open);
		data.files_to_open = _tmp31_;
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	*result = data;
	_g_option_context_free0 (context);
	options = (g_free (options), NULL);
	return;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	CmdLineData _tmp1_ = {0};
	CmdLineData data;
	Latexila* _tmp2_;
	Latexila* app;
	CmdLineData _tmp4_;
	gboolean _tmp5_;
	CmdLineData _tmp6_;
	GVariant* _tmp7_;
	CmdLineData _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_ = 0;
	GError * _inner_error_ = NULL;
	check_xdg_data_dirs ();
	init_i18n ();
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	parse_cmd_line_options (_tmp0_, _tmp0__length1, &_tmp1_);
	data = _tmp1_;
	_tmp2_ = latexila_new ();
	app = _tmp2_;
	{
		g_application_register ((GApplication*) app, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch54_g_error;
		}
	}
	goto __finally54;
	__catch54_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("main.vala:145: Failed to register the application: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally54:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		cmd_line_data_destroy (&data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp4_ = data;
	_tmp5_ = _tmp4_.new_window;
	if (_tmp5_) {
		g_action_group_activate_action ((GActionGroup*) app, "new-window", NULL);
	}
	_tmp6_ = data;
	_tmp7_ = _tmp6_.files_to_open;
	if (_tmp7_ != NULL) {
		CmdLineData _tmp8_;
		GVariant* _tmp9_;
		_tmp8_ = data;
		_tmp9_ = _tmp8_.files_to_open;
		g_action_group_activate_action ((GActionGroup*) app, "open-files", _tmp9_);
	}
	_tmp10_ = data;
	_tmp11_ = _tmp10_.new_document;
	if (_tmp11_) {
		g_action_group_activate_action ((GActionGroup*) app, "new-document", NULL);
	}
	_tmp12_ = g_application_run ((GApplication*) app, 0, NULL);
	result = _tmp12_;
	_g_object_unref0 (app);
	cmd_line_data_destroy (&data);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



