/* project_dialogs.c generated by valac 0.16.0, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtksourceview/gtksource.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block10Data Block10Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block11Data Block11Data;

struct _Block10Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block11Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static void __lambda109_ (Block10Data* _data10_);
static void ___lambda109__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void __lambda110_ (Block11Data* _data11_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda110__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda111_ (Block11Data* _data11_);
void projects_delete (Projects* self, gint num);
static void ___lambda111__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda112_ (Block11Data* _data11_);
void projects_clear_all (Projects* self);
static void ___lambda112__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->main_file_chooser);
		_g_object_unref0 (_data10_->directory_chooser);
		g_slice_free (Block10Data, _data10_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda109_ (Block10Data* _data10_) {
	GtkFileChooserButton* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* dir;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data10_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	dir = _tmp2_;
	{
		GtkFileChooserButton* _tmp3_;
		_tmp3_ = _data10_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp3_, dir, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void ___lambda109__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	__lambda109_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block10Data* _data10_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* dialog;
	GtkDialog* _tmp4_;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_;
	GtkBox* content_area;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserButton* _tmp8_;
	GtkFileChooserButton* _tmp9_;
	GtkFileChooserButton* _tmp10_;
	GtkFileChooserButton* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkFileChooserButton* _tmp13_;
	GtkGrid* _tmp14_ = NULL;
	GtkWidget* component;
	GtkBox* _tmp15_;
	GtkWidget* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GtkFileChooserButton* _tmp18_;
	GtkFileChooserButton* _tmp19_;
	GtkFileChooserButton* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GtkFileChooserButton* _tmp22_;
	GtkGrid* _tmp23_ = NULL;
	GtkBox* _tmp24_;
	GtkWidget* _tmp25_;
	GtkBox* _tmp26_;
	GtkFileChooserButton* _tmp27_;
	MainWindow* _tmp28_;
	Document* _tmp29_;
	Document* _tmp30_;
	Document* _tmp31_;
	Document* doc;
	gboolean _tmp32_ = FALSE;
	Document* _tmp33_;
	gboolean _tmp37_;
	GtkDialog* _tmp88_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_tmp0_ = _ ("New Project");
	_tmp1_ = main_window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_NEW, GTK_RESPONSE_OK, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = gtk_dialog_get_content_area (_tmp4_);
	_tmp6_ = _g_object_ref0 (GTK_IS_BOX (_tmp5_) ? ((GtkBox*) _tmp5_) : NULL);
	content_area = _tmp6_;
	_tmp7_ = _ ("Directory");
	_tmp8_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp7_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_data10_->directory_chooser = _tmp9_;
	_tmp10_ = _data10_->directory_chooser;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, 250, -1);
	_tmp11_ = _data10_->directory_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = _ ("Directory");
	_tmp13_ = _data10_->directory_chooser;
	_tmp14_ = utils_get_dialog_component (_tmp12_, (GtkWidget*) _tmp13_);
	component = (GtkWidget*) _tmp14_;
	_tmp15_ = content_area;
	_tmp16_ = component;
	gtk_box_pack_start (_tmp15_, _tmp16_, FALSE, TRUE, (guint) 0);
	_tmp17_ = _ ("Main File");
	_tmp18_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp17_, GTK_FILE_CHOOSER_ACTION_OPEN);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	_data10_->main_file_chooser = _tmp19_;
	_tmp20_ = _data10_->main_file_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	_tmp21_ = _ ("Main File");
	_tmp22_ = _data10_->main_file_chooser;
	_tmp23_ = utils_get_dialog_component (_tmp21_, (GtkWidget*) _tmp22_);
	_g_object_unref0 (component);
	component = (GtkWidget*) _tmp23_;
	_tmp24_ = content_area;
	_tmp25_ = component;
	gtk_box_pack_start (_tmp24_, _tmp25_, FALSE, TRUE, (guint) 0);
	_tmp26_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = _data10_->directory_chooser;
	g_signal_connect_data (_tmp27_, "file-set", (GCallback) ___lambda109__gtk_file_chooser_button_file_set, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp28_ = main_window;
	_tmp29_ = main_window_get_active_document (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	doc = _tmp31_;
	_tmp33_ = doc;
	if (_tmp33_ != NULL) {
		Document* _tmp34_;
		GFile* _tmp35_;
		GFile* _tmp36_;
		_tmp34_ = doc;
		_tmp35_ = document_get_location (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp32_ = _tmp36_ != NULL;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp37_ = _tmp32_;
	if (_tmp37_) {
		{
			GtkFileChooserButton* _tmp38_;
			Document* _tmp39_;
			GFile* _tmp40_;
			GFile* _tmp41_;
			GFile* _tmp42_ = NULL;
			GFile* _tmp43_;
			GtkFileChooserButton* _tmp44_;
			Document* _tmp45_;
			GFile* _tmp46_;
			GFile* _tmp47_;
			_tmp38_ = _data10_->directory_chooser;
			_tmp39_ = doc;
			_tmp40_ = document_get_location (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_file_get_parent (_tmp41_);
			_tmp43_ = _tmp42_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp38_, _tmp43_, &_inner_error_);
			_g_object_unref0 (_tmp43_);
			if (_inner_error_ != NULL) {
				goto __catch29_g_error;
			}
			_tmp44_ = _data10_->main_file_chooser;
			_tmp45_ = doc;
			_tmp46_ = document_get_location (_tmp45_);
			_tmp47_ = _tmp46_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp44_, _tmp47_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch29_g_error;
			}
		}
		goto __finally29;
		__catch29_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally29:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block10_data_unref (_data10_);
			_data10_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp48_;
		gint _tmp49_ = 0;
		GtkFileChooserButton* _tmp50_;
		GFile* _tmp51_ = NULL;
		GFile* _tmp52_;
		GFile* directory;
		GtkFileChooserButton* _tmp53_;
		GFile* _tmp54_ = NULL;
		GFile* _tmp55_;
		GFile* main_file;
		gboolean _tmp56_ = FALSE;
		GFile* _tmp57_;
		gboolean _tmp59_;
		GtkDialog* _tmp60_;
		GFile* _tmp61_;
		GFile* _tmp62_;
		gboolean _tmp63_ = FALSE;
		Project project = {0};
		GFile* _tmp64_;
		GFile* _tmp65_;
		GFile* _tmp66_;
		GFile* _tmp67_;
		GFile* conflict = NULL;
		Projects* _tmp68_ = NULL;
		Projects* _tmp69_;
		Project _tmp70_;
		GFile* _tmp71_ = NULL;
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_;
		GtkDialog* _tmp74_;
		const gchar* _tmp75_ = NULL;
		GFile* _tmp76_;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		GtkMessageDialog* _tmp83_;
		GtkDialog* _tmp84_;
		GtkDialog* _tmp85_;
		GtkDialog* error_dialog;
		GtkDialog* _tmp86_;
		GtkDialog* _tmp87_;
		_tmp48_ = dialog;
		_tmp49_ = gtk_dialog_run (_tmp48_);
		if (!(_tmp49_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp50_ = _data10_->directory_chooser;
		_tmp51_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp50_);
		_tmp52_ = _g_object_ref0 (_tmp51_);
		directory = _tmp52_;
		_tmp53_ = _data10_->main_file_chooser;
		_tmp54_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp53_);
		_tmp55_ = _g_object_ref0 (_tmp54_);
		main_file = _tmp55_;
		_tmp57_ = directory;
		if (_tmp57_ == NULL) {
			_tmp56_ = TRUE;
		} else {
			GFile* _tmp58_;
			_tmp58_ = main_file;
			_tmp56_ = _tmp58_ == NULL;
		}
		_tmp59_ = _tmp56_;
		if (_tmp59_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp60_ = dialog;
		_tmp61_ = main_file;
		_tmp62_ = directory;
		_tmp63_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp60_, _tmp61_, _tmp62_);
		if (!_tmp63_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp64_ = directory;
		_tmp65_ = _g_object_ref0 (_tmp64_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp65_;
		_tmp66_ = main_file;
		_tmp67_ = _g_object_ref0 (_tmp66_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp67_;
		_tmp68_ = projects_get_default ();
		_tmp69_ = _tmp68_;
		_tmp70_ = project;
		_tmp72_ = projects_add (_tmp69_, &_tmp70_, &_tmp71_);
		_g_object_unref0 (conflict);
		conflict = _tmp71_;
		_tmp73_ = _tmp72_;
		_projects_unref0 (_tmp69_);
		if (_tmp73_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp74_ = dialog;
		_tmp75_ = _ ("There is a conflict with the project \"%s\".");
		_tmp76_ = conflict;
		_tmp77_ = g_file_get_parse_name (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = utils_replace_home_dir_with_tilde (_tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat (_tmp80_, "/", NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp74_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp75_, _tmp82_);
		_tmp84_ = (GtkDialog*) g_object_ref_sink (_tmp83_);
		_tmp85_ = _tmp84_;
		_g_free0 (_tmp82_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
		error_dialog = _tmp85_;
		_tmp86_ = error_dialog;
		gtk_dialog_run (_tmp86_);
		_tmp87_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp87_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp88_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp88_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_;
	gint _tmp2_;
	Project* _tmp3_ = NULL;
	Project* _tmp4_;
	Project* project;
	Project* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkWindow* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* dialog;
	GtkDialog* _tmp10_;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_;
	GtkBox* content_area;
	Project* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* project_dir;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* location;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_;
	GtkGrid* _tmp28_ = NULL;
	GtkWidget* component;
	GtkBox* _tmp29_;
	GtkWidget* _tmp30_;
	const gchar* _tmp31_ = NULL;
	GtkFileChooserButton* _tmp32_;
	GtkFileChooserButton* _tmp33_;
	GtkFileChooserButton* main_file_chooser;
	GtkFileChooserButton* _tmp34_;
	const gchar* _tmp35_ = NULL;
	GtkFileChooserButton* _tmp36_;
	GtkGrid* _tmp37_ = NULL;
	GtkBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkBox* _tmp40_;
	gboolean ret;
	GtkDialog* _tmp60_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = project_id;
	_tmp3_ = projects_get (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_projects_unref0 (_tmp1_);
	project = _tmp4_;
	_tmp5_ = project;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = _ ("Configure Project");
	_tmp7_ = main_window;
	_tmp8_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp6_, _tmp7_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL, NULL);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	dialog = _tmp9_;
	_tmp10_ = dialog;
	_tmp11_ = gtk_dialog_get_content_area (_tmp10_);
	_tmp12_ = _g_object_ref0 (GTK_IS_BOX (_tmp11_) ? ((GtkBox*) _tmp11_) : NULL);
	content_area = _tmp12_;
	_tmp13_ = project;
	_tmp14_ = (*_tmp13_).directory;
	_tmp15_ = g_file_get_parse_name (_tmp14_);
	project_dir = _tmp15_;
	_tmp16_ = project_dir;
	_tmp17_ = utils_replace_home_dir_with_tilde (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp19_;
	_g_free0 (_tmp18_);
	_tmp20_ = project_dir;
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	location = _tmp22_;
	_tmp23_ = location;
	gtk_label_set_line_wrap (_tmp23_, TRUE);
	_tmp24_ = location;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
	_tmp25_ = location;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	_tmp26_ = _ ("Location of the project");
	_tmp27_ = location;
	_tmp28_ = utils_get_dialog_component (_tmp26_, (GtkWidget*) _tmp27_);
	component = (GtkWidget*) _tmp28_;
	_tmp29_ = content_area;
	_tmp30_ = component;
	gtk_box_pack_start (_tmp29_, _tmp30_, FALSE, TRUE, (guint) 0);
	_tmp31_ = _ ("Main File");
	_tmp32_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp31_, GTK_FILE_CHOOSER_ACTION_OPEN);
	_tmp33_ = g_object_ref_sink (_tmp32_);
	main_file_chooser = _tmp33_;
	_tmp34_ = main_file_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp34_, TRUE);
	_tmp35_ = _ ("Main File");
	_tmp36_ = main_file_chooser;
	_tmp37_ = utils_get_dialog_component (_tmp35_, (GtkWidget*) _tmp36_);
	_g_object_unref0 (component);
	component = (GtkWidget*) _tmp37_;
	_tmp38_ = content_area;
	_tmp39_ = component;
	gtk_box_pack_start (_tmp38_, _tmp39_, FALSE, TRUE, (guint) 0);
	_tmp40_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
	{
		GtkFileChooserButton* _tmp41_;
		Project* _tmp42_;
		GFile* _tmp43_;
		_tmp41_ = main_file_chooser;
		_tmp42_ = project;
		_tmp43_ = (*_tmp42_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp41_, _tmp43_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally30:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp44_;
		gint _tmp45_ = 0;
		GtkFileChooserButton* _tmp46_;
		GFile* _tmp47_ = NULL;
		GFile* _tmp48_;
		GFile* main_file;
		GFile* _tmp49_;
		GtkDialog* _tmp50_;
		GFile* _tmp51_;
		Project* _tmp52_;
		GFile* _tmp53_;
		gboolean _tmp54_ = FALSE;
		Projects* _tmp55_ = NULL;
		Projects* _tmp56_;
		gint _tmp57_;
		GFile* _tmp58_;
		gboolean _tmp59_ = FALSE;
		_tmp44_ = dialog;
		_tmp45_ = gtk_dialog_run (_tmp44_);
		if (!(_tmp45_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp46_ = main_file_chooser;
		_tmp47_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp46_);
		_tmp48_ = _g_object_ref0 (_tmp47_);
		main_file = _tmp48_;
		_tmp49_ = main_file;
		if (_tmp49_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp50_ = dialog;
		_tmp51_ = main_file;
		_tmp52_ = project;
		_tmp53_ = (*_tmp52_).directory;
		_tmp54_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp50_, _tmp51_, _tmp53_);
		if (!_tmp54_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp55_ = projects_get_default ();
		_tmp56_ = _tmp55_;
		_tmp57_ = project_id;
		_tmp58_ = main_file;
		_tmp59_ = projects_change_main_file (_tmp56_, _tmp57_, _tmp58_);
		ret = _tmp59_;
		_projects_unref0 (_tmp56_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp60_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp60_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->treeview);
		_g_object_unref0 (_data11_->store);
		_g_object_unref0 (_data11_->dialog);
		g_slice_free (Block11Data, _data11_);
	}
}


static void __lambda110_ (Block11Data* _data11_) {
	gint _tmp0_ = 0;
	gint i;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp5_;
	_tmp0_ = utils_get_selected_row (_data11_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != (-1)) {
		gint _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = i;
		_tmp4_ = project_dialogs_configure_project ((GtkWindow*) _data11_->dialog, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		project_dialogs_update_model (_data11_->store);
	}
}


static void ___lambda110__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda110_ (self);
}


static void __lambda111_ (Block11Data* _data11_) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint i;
	gint _tmp2_;
	gchar* directory = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	GtkMessageDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* delete_dialog;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	gint _tmp12_ = 0;
	GtkDialog* _tmp17_;
	_tmp1_ = utils_get_selected_row (_data11_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = _g_object_ref0 (GTK_TREE_MODEL (_data11_->store));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = _ ("Do you really want to delete the project \"%s\"?");
	_tmp7_ = directory;
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data11_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp6_, _tmp7_);
	_tmp9_ = (GtkDialog*) g_object_ref_sink (_tmp8_);
	delete_dialog = _tmp9_;
	_tmp10_ = delete_dialog;
	gtk_dialog_add_buttons (_tmp10_, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp11_ = delete_dialog;
	_tmp12_ = gtk_dialog_run (_tmp11_);
	if (_tmp12_ == ((gint) GTK_RESPONSE_YES)) {
		GtkTreeIter _tmp13_;
		Projects* _tmp14_ = NULL;
		Projects* _tmp15_;
		gint _tmp16_;
		_tmp13_ = iter;
		gtk_list_store_remove (_data11_->store, &_tmp13_);
		_tmp14_ = projects_get_default ();
		_tmp15_ = _tmp14_;
		_tmp16_ = i;
		projects_delete (_tmp15_, _tmp16_);
		_projects_unref0 (_tmp15_);
	}
	_tmp17_ = delete_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void ___lambda111__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda111_ (self);
}


static void __lambda112_ (Block11Data* _data11_) {
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* clear_dialog;
	GtkDialog* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* button;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* img;
	GtkButton* _tmp9_;
	GtkImage* _tmp10_;
	GtkButton* _tmp11_;
	GtkDialog* _tmp12_;
	GtkButton* _tmp13_;
	GtkDialog* _tmp14_;
	gint _tmp15_ = 0;
	GtkDialog* _tmp18_;
	_tmp0_ = _ ("Do you really want to clear all projects?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data11_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	_tmp2_ = (GtkDialog*) g_object_ref_sink (_tmp1_);
	clear_dialog = _tmp2_;
	_tmp3_ = clear_dialog;
	gtk_dialog_add_button (_tmp3_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp4_ = _ ("Clear All");
	_tmp5_ = (GtkButton*) gtk_button_new_with_label (_tmp4_);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	button = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	img = _tmp8_;
	_tmp9_ = button;
	_tmp10_ = img;
	gtk_button_set_image (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = button;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = clear_dialog;
	_tmp13_ = button;
	gtk_dialog_add_action_widget (_tmp12_, (GtkWidget*) _tmp13_, (gint) GTK_RESPONSE_YES);
	_tmp14_ = clear_dialog;
	_tmp15_ = gtk_dialog_run (_tmp14_);
	if (_tmp15_ == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp16_ = NULL;
		Projects* _tmp17_;
		_tmp16_ = projects_get_default ();
		_tmp17_ = _tmp16_;
		projects_clear_all (_tmp17_);
		_projects_unref0 (_tmp17_);
		gtk_list_store_clear (_data11_->store);
	}
	_tmp18_ = clear_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
	_g_object_unref0 (img);
	_g_object_unref0 (button);
	_g_object_unref0 (clear_dialog);
}


static void ___lambda112__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda112_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block11Data* _data11_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_;
	GtkBox* content_area;
	GtkListStore* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* column;
	GtkTreeViewColumn* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererPixbuf* _tmp15_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererPixbuf* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkCellRendererPixbuf* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp21_;
	GtkCellRendererText* _tmp22_;
	GtkTreeViewColumn* _tmp23_;
	GtkCellRendererText* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkTreeViewColumn* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GtkCellRendererPixbuf* _tmp30_;
	GtkCellRendererPixbuf* _tmp31_;
	GtkCellRendererPixbuf* _tmp32_;
	GtkTreeViewColumn* _tmp33_;
	GtkCellRendererPixbuf* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkCellRendererText* _tmp36_;
	GtkTreeViewColumn* _tmp37_;
	GtkCellRendererText* _tmp38_;
	GtkTreeViewColumn* _tmp39_;
	GtkCellRendererText* _tmp40_;
	GtkTreeSelection* _tmp41_ = NULL;
	GtkTreeSelection* _tmp42_;
	GtkTreeSelection* select;
	GtkWidget* _tmp43_ = NULL;
	GtkWidget* sw;
	GtkGrid* _tmp44_;
	GtkGrid* _tmp45_;
	GtkGrid* grid;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* edit_button;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* delete_button;
	const gchar* _tmp50_ = NULL;
	GtkButton* _tmp51_;
	GtkButton* _tmp52_;
	GtkButton* clear_all_button;
	GtkImage* _tmp53_;
	GtkImage* _tmp54_;
	GtkImage* image;
	g_return_if_fail (main_window != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_tmp0_ = _ ("Manage Projects");
	_tmp1_ = main_window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_OK, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_data11_->dialog = _tmp3_;
	_tmp4_ = gtk_dialog_get_content_area (_data11_->dialog);
	_tmp5_ = _g_object_ref0 (GTK_IS_BOX (_tmp4_) ? ((GtkBox*) _tmp4_) : NULL);
	content_area = _tmp5_;
	gtk_widget_set_size_request ((GtkWidget*) content_area, 400, 250);
	_tmp6_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	_data11_->store = _tmp6_;
	project_dialogs_update_model (_data11_->store);
	_tmp7_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data11_->store);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_data11_->treeview = _tmp8_;
	gtk_tree_view_set_rules_hint (_data11_->treeview, TRUE);
	_tmp9_ = gtk_tree_view_column_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	column = _tmp10_;
	_tmp11_ = column;
	gtk_tree_view_append_column (_data11_->treeview, _tmp11_);
	_tmp12_ = column;
	_tmp13_ = _ ("Directory");
	gtk_tree_view_column_set_title (_tmp12_, _tmp13_);
	_tmp14_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp15_ = g_object_ref_sink (_tmp14_);
	pixbuf_renderer = _tmp15_;
	_tmp16_ = pixbuf_renderer;
	g_object_set (_tmp16_, "stock-id", GTK_STOCK_DIRECTORY, NULL);
	_tmp17_ = column;
	_tmp18_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, FALSE);
	_tmp19_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp20_ = g_object_ref_sink (_tmp19_);
	text_renderer = _tmp20_;
	_tmp21_ = column;
	_tmp22_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp21_, (GtkCellRenderer*) _tmp22_, TRUE);
	_tmp23_ = column;
	_tmp24_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp23_, (GtkCellRenderer*) _tmp24_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp25_ = gtk_tree_view_column_new ();
	_tmp26_ = g_object_ref_sink (_tmp25_);
	_g_object_unref0 (column);
	column = _tmp26_;
	_tmp27_ = column;
	gtk_tree_view_append_column (_data11_->treeview, _tmp27_);
	_tmp28_ = column;
	_tmp29_ = _ ("Main File");
	gtk_tree_view_column_set_title (_tmp28_, _tmp29_);
	_tmp30_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp31_ = g_object_ref_sink (_tmp30_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp31_;
	_tmp32_ = pixbuf_renderer;
	g_object_set (_tmp32_, "stock-id", GTK_STOCK_FILE, NULL);
	_tmp33_ = column;
	_tmp34_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, FALSE);
	_tmp35_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp36_ = g_object_ref_sink (_tmp35_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp36_;
	_tmp37_ = column;
	_tmp38_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp37_, (GtkCellRenderer*) _tmp38_, TRUE);
	_tmp39_ = column;
	_tmp40_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp39_, (GtkCellRenderer*) _tmp40_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp41_ = gtk_tree_view_get_selection (_data11_->treeview);
	_tmp42_ = _g_object_ref0 (_tmp41_);
	select = _tmp42_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp43_ = utils_add_scrollbar ((GtkWidget*) _data11_->treeview);
	sw = _tmp43_;
	gtk_box_pack_start (content_area, sw, TRUE, TRUE, (guint) 0);
	_tmp44_ = (GtkGrid*) gtk_grid_new ();
	_tmp45_ = g_object_ref_sink (_tmp44_);
	grid = _tmp45_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (grid, (guint) 5);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
	_tmp46_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);
	_tmp47_ = g_object_ref_sink (_tmp46_);
	edit_button = _tmp47_;
	_tmp48_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_DELETE);
	_tmp49_ = g_object_ref_sink (_tmp48_);
	delete_button = _tmp49_;
	_tmp50_ = _ ("Clear All");
	_tmp51_ = (GtkButton*) gtk_button_new_with_label (_tmp50_);
	_tmp52_ = g_object_ref_sink (_tmp51_);
	clear_all_button = _tmp52_;
	_tmp53_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	_tmp54_ = g_object_ref_sink (_tmp53_);
	image = _tmp54_;
	gtk_button_set_image (clear_all_button, (GtkWidget*) image);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda110__gtk_button_clicked, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda111__gtk_button_clicked, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda112__gtk_button_clicked, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_dialog_run (_data11_->dialog);
	gtk_widget_destroy ((GtkWidget*) _data11_->dialog);
	_g_object_unref0 (image);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWindow* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* error_dialog;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = main_file;
	_tmp1_ = directory;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = window;
	_tmp4_ = _ ("The Main File is not in the directory.");
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp4_);
	_tmp6_ = (GtkDialog*) g_object_ref_sink (_tmp5_);
	error_dialog = _tmp6_;
	_tmp7_ = error_dialog;
	gtk_dialog_run (_tmp7_);
	_tmp8_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp8_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	GtkListStore* _tmp0_;
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	gtk_list_store_clear (_tmp0_);
	{
		Projects* _tmp1_ = NULL;
		Projects* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _project_it;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = projects_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_projects_unref0 (_tmp2_);
		_project_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			Project* _tmp9_;
			Project _tmp10_ = {0};
			Project _tmp11_;
			Project project;
			Project _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* uri_directory;
			Project _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* uri_main_file;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* dir;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* main_file;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_ = {0};
			GtkListStore* _tmp33_;
			GtkTreeIter _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _project_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Project*) _tmp8_;
			project_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp9_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_get_parse_name (_tmp13_);
			uri_directory = _tmp14_;
			_tmp15_ = project;
			_tmp16_ = _tmp15_.main_file;
			_tmp17_ = g_file_get_parse_name (_tmp16_);
			uri_main_file = _tmp17_;
			_tmp18_ = uri_directory;
			_tmp19_ = utils_replace_home_dir_with_tilde (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp20_);
			dir = _tmp22_;
			_tmp23_ = uri_main_file;
			_tmp24_ = uri_directory;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = uri_main_file;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
			main_file = _tmp30_;
			_tmp31_ = model;
			gtk_list_store_append (_tmp31_, &_tmp32_);
			iter = _tmp32_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dir;
			_tmp36_ = main_file;
			gtk_list_store_set (_tmp33_, &_tmp34_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp35_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp36_, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



