/* project_dialogs.c generated by valac 0.35.2.3-28fcae, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011, 2015 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <gio/gio.h>
#include <gtef/gtef.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block29Data Block29Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block30Data Block30Data;

struct _Block29Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block30Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda68_ (Block29Data* _data29_);
static void ___lambda68__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile* * conflict_file);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda69_ (Block30Data* _data30_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda69__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda70_ (Block30Data* _data30_);
void projects_delete (Projects* self, gint num);
static void ___lambda70__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda71_ (Block30Data* _data30_);
void projects_clear_all (Projects* self);
static void ___lambda71__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		_g_object_unref0 (_data29_->main_file_chooser);
		_g_object_unref0 (_data29_->directory_chooser);
		g_slice_free (Block29Data, _data29_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda68_ (Block29Data* _data29_) {
	GFile* dir;
	GtkFileChooserButton* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data29_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	dir = _tmp1_;
	{
		GtkFileChooserButton* _tmp2_;
		_tmp2_ = _data29_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp2_, dir, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch39_g_error;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void ___lambda68__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	__lambda68_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block29Data* _data29_;
	GtkDialog* dialog;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	MainWindow* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkBox* content_area;
	GtkDialog* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkFileChooserButton* _tmp14_;
	GtkWidget* component;
	GtkFileChooserButton* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkBox* _tmp18_;
	GtkWidget* _tmp19_;
	GtkFileChooserButton* _tmp20_;
	GtkFileChooserButton* _tmp21_;
	GtkWidget* _tmp22_;
	GtkWidget* _tmp23_;
	GtkBox* _tmp24_;
	GtkWidget* _tmp25_;
	GtkBox* _tmp26_;
	GtkFileChooserButton* _tmp27_;
	Document* doc;
	MainWindow* _tmp28_;
	Document* _tmp29_;
	Document* _tmp30_;
	Document* _tmp31_;
	gboolean _tmp32_ = FALSE;
	Document* _tmp33_;
	GtkDialog* _tmp82_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	dialog = _tmp2_;
	_tmp3_ = dialog;
	gtk_window_set_title ((GtkWindow*) _tmp3_, _ ("New Project"));
	_tmp4_ = dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp4_, TRUE);
	_tmp5_ = dialog;
	_tmp6_ = main_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp6_);
	_tmp7_ = dialog;
	gtk_dialog_add_button (_tmp7_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp8_ = dialog;
	gtk_dialog_add_button (_tmp8_, _ ("Crea_te"), (gint) GTK_RESPONSE_OK);
	_tmp9_ = dialog;
	gtk_dialog_set_default_response (_tmp9_, (gint) GTK_RESPONSE_OK);
	_tmp10_ = dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, 450, -1);
	_tmp11_ = dialog;
	_tmp12_ = (GtkBox*) gtk_dialog_get_content_area (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_box_get_type ()) ? ((GtkBox*) _tmp12_) : NULL);
	content_area = _tmp13_;
	_tmp14_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp14_);
	_data29_->directory_chooser = _tmp14_;
	_tmp15_ = _data29_->directory_chooser;
	_tmp16_ = latexila_utils_get_dialog_component (_ ("Directory"), (GtkWidget*) _tmp15_);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	component = _tmp17_;
	_tmp18_ = content_area;
	_tmp19_ = component;
	gtk_box_pack_start (_tmp18_, _tmp19_, FALSE, TRUE, (guint) 0);
	_tmp20_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Main File"), GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp20_);
	_data29_->main_file_chooser = _tmp20_;
	_tmp21_ = _data29_->main_file_chooser;
	_tmp22_ = latexila_utils_get_dialog_component (_ ("Main File"), (GtkWidget*) _tmp21_);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (component);
	component = _tmp23_;
	_tmp24_ = content_area;
	_tmp25_ = component;
	gtk_box_pack_start (_tmp24_, _tmp25_, FALSE, TRUE, (guint) 0);
	_tmp26_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = _data29_->directory_chooser;
	g_signal_connect_data (_tmp27_, "file-set", (GCallback) ___lambda68__gtk_file_chooser_button_file_set, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_tmp28_ = main_window;
	_tmp29_ = main_window_get_active_document (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	doc = _tmp31_;
	_tmp33_ = doc;
	if (_tmp33_ != NULL) {
		Document* _tmp34_;
		GFile* _tmp35_;
		GFile* _tmp36_;
		_tmp34_ = doc;
		_tmp35_ = document_get_location (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp32_ = _tmp36_ != NULL;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		{
			GtkFileChooserButton* _tmp37_;
			Document* _tmp38_;
			GFile* _tmp39_;
			GFile* _tmp40_;
			GFile* _tmp41_;
			GFile* _tmp42_;
			GtkFileChooserButton* _tmp43_;
			Document* _tmp44_;
			GFile* _tmp45_;
			GFile* _tmp46_;
			_tmp37_ = _data29_->directory_chooser;
			_tmp38_ = doc;
			_tmp39_ = document_get_location (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_file_get_parent (_tmp40_);
			_tmp42_ = _tmp41_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp37_, _tmp42_, &_inner_error_);
			_g_object_unref0 (_tmp42_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch40_g_error;
			}
			_tmp43_ = _data29_->main_file_chooser;
			_tmp44_ = doc;
			_tmp45_ = document_get_location (_tmp44_);
			_tmp46_ = _tmp45_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp43_, _tmp46_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch40_g_error;
			}
		}
		goto __finally40;
		__catch40_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally40:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block29_data_unref (_data29_);
			_data29_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp47_;
		gint _tmp48_;
		GFile* directory;
		GtkFileChooserButton* _tmp49_;
		GFile* _tmp50_;
		GFile* main_file;
		GtkFileChooserButton* _tmp51_;
		GFile* _tmp52_;
		gboolean _tmp53_ = FALSE;
		GFile* _tmp54_;
		GtkDialog* _tmp56_;
		GFile* _tmp57_;
		GFile* _tmp58_;
		gboolean _tmp59_;
		Project project;
		GFile* _tmp60_;
		GFile* _tmp61_;
		GFile* _tmp62_;
		GFile* _tmp63_;
		GFile* conflict = NULL;
		Projects* _tmp64_;
		Projects* _tmp65_;
		Project _tmp66_;
		GFile* _tmp67_ = NULL;
		gboolean _tmp68_;
		gboolean _tmp69_;
		GtkDialog* error_dialog;
		GtkDialog* _tmp70_;
		GFile* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		GtkMessageDialog* _tmp78_;
		GtkDialog* _tmp79_;
		GtkDialog* _tmp80_;
		GtkDialog* _tmp81_;
		_tmp47_ = dialog;
		_tmp48_ = gtk_dialog_run (_tmp47_);
		if (!(_tmp48_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp49_ = _data29_->directory_chooser;
		_tmp50_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp49_);
		directory = _tmp50_;
		_tmp51_ = _data29_->main_file_chooser;
		_tmp52_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp51_);
		main_file = _tmp52_;
		_tmp54_ = directory;
		if (_tmp54_ == NULL) {
			_tmp53_ = TRUE;
		} else {
			GFile* _tmp55_;
			_tmp55_ = main_file;
			_tmp53_ = _tmp55_ == NULL;
		}
		if (_tmp53_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp56_ = dialog;
		_tmp57_ = main_file;
		_tmp58_ = directory;
		_tmp59_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp56_, _tmp57_, _tmp58_);
		if (!_tmp59_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp60_ = directory;
		_tmp61_ = _g_object_ref0 (_tmp60_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp61_;
		_tmp62_ = main_file;
		_tmp63_ = _g_object_ref0 (_tmp62_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp63_;
		_tmp64_ = projects_get_default ();
		_tmp65_ = _tmp64_;
		_tmp66_ = project;
		_tmp68_ = projects_add (_tmp65_, &_tmp66_, &_tmp67_);
		_g_object_unref0 (conflict);
		conflict = _tmp67_;
		_tmp69_ = _tmp68_;
		_projects_unref0 (_tmp65_);
		if (_tmp69_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp70_ = dialog;
		_tmp71_ = conflict;
		_tmp72_ = g_file_get_parse_name (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = latexila_utils_replace_home_dir_with_tilde (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strconcat (_tmp75_, "/", NULL);
		_tmp77_ = _tmp76_;
		_tmp78_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp70_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("There is a conflict with the project \"%s\"."), _tmp77_);
		g_object_ref_sink (_tmp78_);
		_tmp79_ = (GtkDialog*) _tmp78_;
		g_free (_tmp77_);
		g_free (_tmp75_);
		g_free (_tmp73_);
		error_dialog = _tmp79_;
		_tmp80_ = error_dialog;
		gtk_dialog_run (_tmp80_);
		_tmp81_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp81_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp82_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp82_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Project* project;
	Projects* _tmp0_;
	Projects* _tmp1_;
	gint _tmp2_;
	Project* _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
	GtkDialog* dialog;
	GObject* _tmp6_;
	GObject* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkWindow* _tmp12_;
	GtkDialog* _tmp13_;
	GtkDialog* _tmp14_;
	GtkDialog* _tmp15_;
	GtkDialog* _tmp16_;
	GtkBox* content_area;
	GtkDialog* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	gchar* project_dir;
	Project* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GtkLabel* location;
	const gchar* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkWidget* component;
	GtkLabel* _tmp31_;
	GtkWidget* _tmp32_;
	GtkWidget* _tmp33_;
	GtkBox* _tmp34_;
	GtkWidget* _tmp35_;
	GtkFileChooserButton* main_file_chooser;
	GtkFileChooserButton* _tmp36_;
	GtkFileChooserButton* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	GtkBox* _tmp40_;
	GtkWidget* _tmp41_;
	GtkBox* _tmp42_;
	gboolean ret;
	GtkDialog* _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = project_id;
	_tmp3_ = projects_get (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_projects_unref0 (_tmp1_);
	project = _tmp4_;
	_tmp5_ = project;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp7_ = G_IS_INITIALLY_UNOWNED (_tmp6_) ? g_object_ref_sink (_tmp6_) : _tmp6_;
	_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp7_) : NULL;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (_tmp7_);
	}
	dialog = _tmp8_;
	_tmp9_ = dialog;
	gtk_window_set_title ((GtkWindow*) _tmp9_, _ ("Configure Project"));
	_tmp10_ = dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp10_, TRUE);
	_tmp11_ = dialog;
	_tmp12_ = main_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp12_);
	_tmp13_ = dialog;
	gtk_dialog_add_button (_tmp13_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp14_ = dialog;
	gtk_dialog_add_button (_tmp14_, _ ("_Apply"), (gint) GTK_RESPONSE_APPLY);
	_tmp15_ = dialog;
	gtk_dialog_set_default_response (_tmp15_, (gint) GTK_RESPONSE_APPLY);
	_tmp16_ = dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp16_, 450, -1);
	_tmp17_ = dialog;
	_tmp18_ = (GtkBox*) gtk_dialog_get_content_area (_tmp17_);
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_box_get_type ()) ? ((GtkBox*) _tmp18_) : NULL);
	content_area = _tmp19_;
	_tmp20_ = project;
	_tmp21_ = (*_tmp20_).directory;
	_tmp22_ = g_file_get_parse_name (_tmp21_);
	project_dir = _tmp22_;
	_tmp23_ = project_dir;
	_tmp24_ = latexila_utils_replace_home_dir_with_tilde (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, "/", NULL);
	g_free (project_dir);
	project_dir = _tmp26_;
	g_free (_tmp25_);
	_tmp27_ = project_dir;
	_tmp28_ = (GtkLabel*) gtk_label_new (_tmp27_);
	g_object_ref_sink (_tmp28_);
	location = _tmp28_;
	_tmp29_ = location;
	gtk_label_set_line_wrap (_tmp29_, TRUE);
	_tmp30_ = location;
	gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_START);
	_tmp31_ = location;
	_tmp32_ = latexila_utils_get_dialog_component (_ ("Location of the project"), (GtkWidget*) _tmp31_);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	component = _tmp33_;
	_tmp34_ = content_area;
	_tmp35_ = component;
	gtk_box_pack_start (_tmp34_, _tmp35_, FALSE, TRUE, (guint) 0);
	_tmp36_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Main File"), GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp36_);
	main_file_chooser = _tmp36_;
	_tmp37_ = main_file_chooser;
	_tmp38_ = latexila_utils_get_dialog_component (_ ("Main File"), (GtkWidget*) _tmp37_);
	_tmp39_ = _g_object_ref0 (_tmp38_);
	_g_object_unref0 (component);
	component = _tmp39_;
	_tmp40_ = content_area;
	_tmp41_ = component;
	gtk_box_pack_start (_tmp40_, _tmp41_, FALSE, TRUE, (guint) 0);
	_tmp42_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp42_);
	{
		GtkFileChooserButton* _tmp43_;
		Project* _tmp44_;
		GFile* _tmp45_;
		_tmp43_ = main_file_chooser;
		_tmp44_ = project;
		_tmp45_ = (*_tmp44_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp43_, _tmp45_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch41_g_error;
		}
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally41:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		g_free (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp46_;
		gint _tmp47_;
		GFile* main_file;
		GtkFileChooserButton* _tmp48_;
		GFile* _tmp49_;
		GFile* _tmp50_;
		GtkDialog* _tmp51_;
		GFile* _tmp52_;
		Project* _tmp53_;
		GFile* _tmp54_;
		gboolean _tmp55_;
		Projects* _tmp56_;
		Projects* _tmp57_;
		gint _tmp58_;
		GFile* _tmp59_;
		gboolean _tmp60_;
		_tmp46_ = dialog;
		_tmp47_ = gtk_dialog_run (_tmp46_);
		if (!(_tmp47_ == ((gint) GTK_RESPONSE_APPLY))) {
			break;
		}
		_tmp48_ = main_file_chooser;
		_tmp49_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp48_);
		main_file = _tmp49_;
		_tmp50_ = main_file;
		if (_tmp50_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp51_ = dialog;
		_tmp52_ = main_file;
		_tmp53_ = project;
		_tmp54_ = (*_tmp53_).directory;
		_tmp55_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp51_, _tmp52_, _tmp54_);
		if (!_tmp55_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp56_ = projects_get_default ();
		_tmp57_ = _tmp56_;
		_tmp58_ = project_id;
		_tmp59_ = main_file;
		_tmp60_ = projects_change_main_file (_tmp57_, _tmp58_, _tmp59_);
		ret = _tmp60_;
		_projects_unref0 (_tmp57_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp61_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp61_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	g_free (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		_g_object_unref0 (_data30_->treeview);
		_g_object_unref0 (_data30_->store);
		_g_object_unref0 (_data30_->dialog);
		g_slice_free (Block30Data, _data30_);
	}
}


static void __lambda69_ (Block30Data* _data30_) {
	gint i;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	_tmp0_ = utils_get_selected_row (_data30_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != -1) {
		gint _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = i;
		_tmp4_ = project_dialogs_configure_project ((GtkWindow*) _data30_->dialog, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		project_dialogs_update_model (_data30_->store);
	}
}


static void ___lambda69__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda69_ (self);
}


static void __lambda70_ (Block30Data* _data30_) {
	GtkTreeIter iter = {0};
	gint i;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	gchar* directory = NULL;
	GtkTreeModel* model;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GtkDialog* delete_dialog;
	const gchar* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	gint _tmp10_;
	GtkDialog* _tmp15_;
	_tmp1_ = utils_get_selected_row (_data30_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == -1) {
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data30_->store, GTK_TYPE_TREE_MODEL, GtkTreeModel));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = directory;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data30_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the project \"%s\"?"), _tmp6_);
	g_object_ref_sink (_tmp7_);
	delete_dialog = (GtkDialog*) _tmp7_;
	_tmp8_ = delete_dialog;
	gtk_dialog_add_buttons (_tmp8_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_YES, NULL);
	_tmp9_ = delete_dialog;
	_tmp10_ = gtk_dialog_run (_tmp9_);
	if (_tmp10_ == ((gint) GTK_RESPONSE_YES)) {
		GtkTreeIter _tmp11_;
		Projects* _tmp12_;
		Projects* _tmp13_;
		gint _tmp14_;
		_tmp11_ = iter;
		gtk_list_store_remove (_data30_->store, &_tmp11_);
		_tmp12_ = projects_get_default ();
		_tmp13_ = _tmp12_;
		_tmp14_ = i;
		projects_delete (_tmp13_, _tmp14_);
		_projects_unref0 (_tmp13_);
	}
	_tmp15_ = delete_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	g_free (directory);
}


static void ___lambda70__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda70_ (self);
}


static void __lambda71_ (Block30Data* _data30_) {
	GtkDialog* clear_dialog;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	gint _tmp4_;
	GtkDialog* _tmp7_;
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data30_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to clear all projects?"));
	g_object_ref_sink (_tmp0_);
	clear_dialog = (GtkDialog*) _tmp0_;
	_tmp1_ = clear_dialog;
	gtk_dialog_add_button (_tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = clear_dialog;
	gtk_dialog_add_button (_tmp2_, _ ("Clear _All"), (gint) GTK_RESPONSE_YES);
	_tmp3_ = clear_dialog;
	_tmp4_ = gtk_dialog_run (_tmp3_);
	if (_tmp4_ == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp5_;
		Projects* _tmp6_;
		_tmp5_ = projects_get_default ();
		_tmp6_ = _tmp5_;
		projects_clear_all (_tmp6_);
		_projects_unref0 (_tmp6_);
		gtk_list_store_clear (_data30_->store);
	}
	_tmp7_ = clear_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	_g_object_unref0 (clear_dialog);
}


static void ___lambda71__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda71_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block30Data* _data30_;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	MainWindow* _tmp3_;
	GtkBox* content_area;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeViewColumn* column;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererPixbuf* _tmp11_;
	GtkCellRendererPixbuf* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererText* text_renderer;
	GtkCellRendererText* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkTreeViewColumn* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkTreeViewColumn* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkTreeViewColumn* _tmp22_;
	GtkCellRendererPixbuf* _tmp23_;
	GtkCellRendererPixbuf* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	GtkCellRendererPixbuf* _tmp26_;
	GtkCellRendererText* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	GtkCellRendererText* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkCellRendererText* _tmp31_;
	GtkTreeSelection* select;
	GtkTreeSelection* _tmp32_;
	GtkTreeSelection* _tmp33_;
	GtkScrolledWindow* sw;
	GtkScrolledWindow* _tmp34_;
	GtkGrid* grid;
	GtkGrid* _tmp35_;
	GtkButton* edit_button;
	GtkButton* _tmp36_;
	GtkButton* delete_button;
	GtkButton* _tmp37_;
	GtkButton* clear_all_button;
	GtkButton* _tmp38_;
	g_return_if_fail (main_window != NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_data30_->dialog = _tmp2_;
	gtk_window_set_title ((GtkWindow*) _data30_->dialog, _ ("Manage Projects"));
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data30_->dialog, TRUE);
	_tmp3_ = main_window;
	gtk_window_set_transient_for ((GtkWindow*) _data30_->dialog, (GtkWindow*) _tmp3_);
	_tmp4_ = (GtkBox*) gtk_dialog_get_content_area (_data30_->dialog);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_box_get_type ()) ? ((GtkBox*) _tmp4_) : NULL);
	content_area = _tmp5_;
	gtk_widget_set_size_request ((GtkWidget*) content_area, 450, 250);
	_tmp6_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_data30_->store = _tmp6_;
	project_dialogs_update_model (_data30_->store);
	_tmp7_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data30_->store);
	g_object_ref_sink (_tmp7_);
	_data30_->treeview = _tmp7_;
	_tmp8_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp8_);
	column = _tmp8_;
	_tmp9_ = column;
	gtk_tree_view_append_column (_data30_->treeview, _tmp9_);
	_tmp10_ = column;
	gtk_tree_view_column_set_title (_tmp10_, _ ("Directory"));
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp11_);
	pixbuf_renderer = _tmp11_;
	_tmp12_ = pixbuf_renderer;
	g_object_set (_tmp12_, "icon-name", "folder", NULL);
	_tmp13_ = column;
	_tmp14_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) _tmp14_, FALSE);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp15_);
	text_renderer = _tmp15_;
	_tmp16_ = column;
	_tmp17_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) _tmp17_, TRUE);
	_tmp18_ = column;
	_tmp19_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp18_, (GtkCellRenderer*) _tmp19_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp20_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (column);
	column = _tmp20_;
	_tmp21_ = column;
	gtk_tree_view_append_column (_data30_->treeview, _tmp21_);
	_tmp22_ = column;
	gtk_tree_view_column_set_title (_tmp22_, _ ("Main File"));
	_tmp23_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp23_;
	_tmp24_ = pixbuf_renderer;
	g_object_set (_tmp24_, "icon-name", "text-x-generic", NULL);
	_tmp25_ = column;
	_tmp26_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp25_, (GtkCellRenderer*) _tmp26_, FALSE);
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp27_;
	_tmp28_ = column;
	_tmp29_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp28_, (GtkCellRenderer*) _tmp29_, TRUE);
	_tmp30_ = column;
	_tmp31_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp30_, (GtkCellRenderer*) _tmp31_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp32_ = gtk_tree_view_get_selection (_data30_->treeview);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	select = _tmp33_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp34_ = utils_add_scrollbar ((GtkWidget*) _data30_->treeview);
	sw = _tmp34_;
	gtk_box_pack_start (content_area, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp35_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp35_);
	grid = _tmp35_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (grid, (guint) 5);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
	_tmp36_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Properties"));
	g_object_ref_sink (_tmp36_);
	edit_button = _tmp36_;
	_tmp37_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Delete"));
	g_object_ref_sink (_tmp37_);
	delete_button = _tmp37_;
	_tmp38_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Clear All"));
	g_object_ref_sink (_tmp38_);
	clear_all_button = _tmp38_;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda69__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda70__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda71__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	gtk_dialog_run (_data30_->dialog);
	gtk_widget_destroy ((GtkWidget*) _data30_->dialog);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GtkDialog* error_dialog;
	GtkWindow* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = main_file;
	_tmp1_ = directory;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = window;
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _ ("The Main File is not in the directory."));
	g_object_ref_sink (_tmp4_);
	error_dialog = (GtkDialog*) _tmp4_;
	_tmp5_ = error_dialog;
	gtk_dialog_run (_tmp5_);
	_tmp6_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	GtkListStore* _tmp0_;
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	gtk_list_store_clear (_tmp0_);
	{
		GeeIterator* _project_it;
		Projects* _tmp1_;
		Projects* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = projects_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_projects_unref0 (_tmp2_);
		_project_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			Project project;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			Project* _tmp9_;
			Project _tmp10_ = {0};
			Project _tmp11_;
			gchar* uri_directory;
			Project _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* uri_main_file;
			Project _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_;
			gchar* dir;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* main_file;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_ = {0};
			GtkListStore* _tmp33_;
			GtkTreeIter _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _project_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Project*) _tmp8_;
			project_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp9_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_get_parse_name (_tmp13_);
			uri_directory = _tmp14_;
			_tmp15_ = project;
			_tmp16_ = _tmp15_.main_file;
			_tmp17_ = g_file_get_parse_name (_tmp16_);
			uri_main_file = _tmp17_;
			_tmp18_ = uri_directory;
			_tmp19_ = latexila_utils_replace_home_dir_with_tilde (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_tmp22_ = _tmp21_;
			g_free (_tmp20_);
			dir = _tmp22_;
			_tmp23_ = uri_main_file;
			_tmp24_ = uri_directory;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = uri_main_file;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
			main_file = _tmp30_;
			_tmp31_ = model;
			gtk_list_store_append (_tmp31_, &_tmp32_);
			iter = _tmp32_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dir;
			_tmp36_ = main_file;
			gtk_list_store_set (_tmp33_, &_tmp34_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp35_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp36_, -1, -1);
			g_free (main_file);
			g_free (dir);
			g_free (uri_main_file);
			g_free (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



