/* champlain-0.10.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Champlain", lower_case_cprefix = "champlain_", gir_namespace = "Champlain", gir_version = "0.10")]
namespace Champlain {
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Adjustment : GLib.Object {
		public Champlain.AdjustmentPrivate priv;
		[CCode (has_construct_function = false)]
		public Adjustment (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public bool clamp (bool interpolate, uint n_frames, uint fps);
		public bool get_elastic ();
		public double get_value ();
		public void get_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public void interpolate (double value, uint n_frames, uint fps);
		public void interpolate_stop ();
		public void set_elastic (bool elastic);
		public void set_value (double value);
		public void set_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public bool elastic { get; set; }
		[NoAccessorMethod]
		public double lower { get; set; }
		[NoAccessorMethod]
		public double page_increment { get; set; }
		[NoAccessorMethod]
		public double page_size { get; set; }
		[NoAccessorMethod]
		public double step_increment { get; set; }
		[NoAccessorMethod]
		public double upper { get; set; }
		public double value { get; set; }
		public virtual signal void changed ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "champlain_bounding_box_get_type ()", cheader_filename = "champlain/champlain.h")]
	public class BoundingBox {
		public double bottom;
		public double left;
		public double right;
		public double top;
		public void compose (Champlain.BoundingBox other);
		public Champlain.BoundingBox copy ();
		public void extend (double latitude, double longitude);
		public void free ();
		public void get_center (out double latitude, out double longitude);
		public bool is_valid ();
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Coordinate : GLib.InitiallyUnowned, Champlain.Location {
		public Champlain.CoordinatePrivate priv;
		[CCode (has_construct_function = false)]
		public Coordinate ();
		[CCode (has_construct_function = false)]
		public Coordinate.full (double latitude, double longitude);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class CustomMarker : Champlain.Marker, Atk.Implementor, Champlain.Location, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		public Champlain.CustomMarkerPrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public CustomMarker ();
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class ErrorTileRenderer : Champlain.Renderer {
		public Champlain.ErrorTileRendererPrivate priv;
		[CCode (has_construct_function = false)]
		public ErrorTileRenderer (uint tile_size);
		public uint get_tile_size ();
		public void set_tile_size (uint size);
		public uint tile_size { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class FileCache : Champlain.TileCache {
		public Champlain.FileCachePrivate priv;
		[CCode (has_construct_function = false)]
		public FileCache.full (uint size_limit, string? cache_dir, Champlain.Renderer renderer);
		public unowned string get_cache_dir ();
		public uint get_size_limit ();
		public void purge ();
		public void purge_on_idle ();
		public void set_size_limit (uint size_limit);
		public string cache_dir { get; construct; }
		public uint size_limit { get; set construct; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class FileTileSource : Champlain.TileSource {
		[CCode (has_construct_function = false)]
		public FileTileSource.full (string id, string name, string license, string license_uri, uint min_zoom, uint max_zoom, uint tile_size, Champlain.MapProjection projection, Champlain.Renderer renderer);
		public void load_map_data (string map_path);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class ImageRenderer : Champlain.Renderer {
		public Champlain.ImageRendererPrivate priv;
		[CCode (has_construct_function = false)]
		public ImageRenderer ();
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class KineticScrollView : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		public Champlain.KineticScrollViewPrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public KineticScrollView (bool kinetic);
		public void stop ();
		[NoAccessorMethod]
		public double decel_rate { get; set; }
		[NoAccessorMethod]
		public bool mode { get; set; }
		[NoAccessorMethod]
		public uint motion_buffer { get; set; }
		public signal void panning_completed ();
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Label : Champlain.Marker, Atk.Implementor, Champlain.Location, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.LabelPrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label.from_file (string filename) throws GLib.Error;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label.full (string text, Clutter.Actor actor);
		public Pango.Alignment get_alignment ();
		public Pango.AttrList get_attributes ();
		public Clutter.Color get_color ();
		public bool get_draw_background ();
		public Pango.EllipsizeMode get_ellipsize ();
		public unowned string get_font_name ();
		public unowned Clutter.Actor get_image ();
		public bool get_single_line_mode ();
		public unowned string get_text ();
		public Clutter.Color get_text_color ();
		public bool get_use_markup ();
		public bool get_wrap ();
		public Pango.WrapMode get_wrap_mode ();
		public void set_alignment (Pango.Alignment alignment);
		public void set_attributes (Pango.AttrList list);
		public void set_color (Clutter.Color? color);
		public void set_draw_background (bool background);
		public void set_ellipsize (Pango.EllipsizeMode mode);
		public void set_font_name (string? font_name);
		public void set_image (Clutter.Actor? image);
		public void set_single_line_mode (bool mode);
		public void set_text (string text);
		public void set_text_color (Clutter.Color? color);
		public void set_use_markup (bool use_markup);
		public void set_wrap (bool wrap);
		public void set_wrap_mode (Pango.WrapMode wrap_mode);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label.with_image (Clutter.Actor actor);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label.with_text (string text, string? font, Clutter.Color? text_color, Clutter.Color? label_color);
		public Pango.Alignment alignment { get; set; }
		public Clutter.Color color { get; set; }
		public bool draw_background { get; set; }
		public Pango.EllipsizeMode ellipsize { get; set; }
		public string font_name { get; set; }
		public Clutter.Actor image { get; set; }
		public bool single_line_mode { get; set; }
		public string text { get; set; }
		public Clutter.Color text_color { get; set; }
		public bool use_markup { get; set; }
		public bool wrap { get; set; }
		public Pango.WrapMode wrap_mode { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Layer : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public virtual Champlain.BoundingBox get_bounding_box ();
		public virtual void set_view (Champlain.View view);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class License : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.LicensePrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public License ();
		public void connect_view (Champlain.View view);
		public void disconnect_view ();
		public Pango.Alignment get_alignment ();
		public unowned string get_extra_text ();
		public void set_alignment (Pango.Alignment alignment);
		public void set_extra_text (string text);
		public Pango.Alignment alignment { get; set; }
		public string extra_text { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MapSource : GLib.InitiallyUnowned {
		public Champlain.MapSourcePrivate priv;
		public virtual void fill_tile (Champlain.Tile tile);
		public uint get_column_count (uint zoom_level);
		public virtual unowned string get_id ();
		public double get_latitude (uint zoom_level, double y);
		public virtual unowned string get_license ();
		public virtual unowned string get_license_uri ();
		public double get_longitude (uint zoom_level, double x);
		public virtual uint get_max_zoom_level ();
		public double get_meters_per_pixel (uint zoom_level, double latitude, double longitude);
		public virtual uint get_min_zoom_level ();
		public virtual unowned string get_name ();
		public unowned Champlain.MapSource get_next_source ();
		public virtual Champlain.MapProjection get_projection ();
		public unowned Champlain.Renderer get_renderer ();
		public uint get_row_count (uint zoom_level);
		public virtual uint get_tile_size ();
		public double get_x (uint zoom_level, double longitude);
		public double get_y (uint zoom_level, double latitude);
		public void set_next_source (Champlain.MapSource next_source);
		public void set_renderer (Champlain.Renderer renderer);
		public Champlain.MapSource next_source { get; set; }
		public Champlain.Renderer renderer { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MapSourceChain : Champlain.MapSource {
		public Champlain.MapSourceChainPrivate priv;
		[CCode (has_construct_function = false)]
		public MapSourceChain ();
		public void pop ();
		public void push (Champlain.MapSource map_source);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MapSourceDesc : GLib.Object {
		public Champlain.MapSourceDescPrivate priv;
		public void* get_data ();
		public unowned string get_id ();
		public unowned string get_license ();
		public unowned string get_license_uri ();
		public uint get_max_zoom_level ();
		public uint get_min_zoom_level ();
		public unowned string get_name ();
		public Champlain.MapProjection get_projection ();
		public uint get_tile_size ();
		public unowned string get_uri_format ();
		[NoAccessorMethod]
		public void* constructor { get; construct; }
		public void* data { get; construct; }
		public string id { get; construct; }
		public string license { get; construct; }
		public string license_uri { get; construct; }
		public uint max_zoom_level { get; construct; }
		public uint min_zoom_level { get; construct; }
		public string name { get; construct; }
		public uint tile_size { get; construct; }
		public string uri_format { get; construct; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MapSourceFactory : GLib.Object {
		public Champlain.MapSourceFactoryPrivate priv;
		public Champlain.MapSource create (string id);
		public Champlain.MapSource create_cached_source (string id);
		public Champlain.MapSource create_error_source (uint tile_size);
		public static Champlain.MapSourceFactory dup_default ();
		public GLib.SList<weak Champlain.MapSourceDesc> get_registered ();
		public bool register (Champlain.MapSourceDesc desc);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Marker : Clutter.Actor, Atk.Implementor, Champlain.Location, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.MarkerPrivate priv;
		public void animate_in ();
		public void animate_in_with_delay (uint delay);
		public void animate_out ();
		public void animate_out_with_delay (uint delay);
		public bool get_draggable ();
		public bool get_selectable ();
		public bool get_selected ();
		public static Clutter.Color get_selection_color ();
		public static Clutter.Color get_selection_text_color ();
		public void set_draggable (bool value);
		public void set_selectable (bool value);
		public void set_selected (bool value);
		public static void set_selection_color (Clutter.Color color);
		public static void set_selection_text_color (Clutter.Color color);
		public bool draggable { get; set; }
		public bool selectable { get; set; }
		public bool selected { get; set; }
		public signal void button_press (Clutter.Event since);
		public signal void button_release (Clutter.Event since);
		public signal void drag_finish (Clutter.Event since);
		public signal void drag_motion (double dy, double event, Clutter.Event since);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MarkerLayer : Champlain.Layer, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.MarkerLayerPrivate priv;
		[CCode (has_construct_function = false)]
		public MarkerLayer ();
		public void add_marker (Champlain.Marker marker);
		public void animate_in_all_markers ();
		public void animate_out_all_markers ();
		[CCode (has_construct_function = false)]
		public MarkerLayer.full (Champlain.SelectionMode mode);
		public GLib.List<weak Champlain.Marker> get_markers ();
		public GLib.List<weak Champlain.Marker> get_selected ();
		public Champlain.SelectionMode get_selection_mode ();
		public void hide_all_markers ();
		public void remove_all ();
		public void remove_marker (Champlain.Marker marker);
		public void select_all_markers ();
		public void set_all_markers_draggable ();
		public void set_all_markers_undraggable ();
		public void set_selection_mode (Champlain.SelectionMode mode);
		public void show_all_markers ();
		public void unselect_all_markers ();
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MemoryCache : Champlain.TileCache {
		public Champlain.MemoryCachePrivate priv;
		public void clean ();
		[CCode (has_construct_function = false)]
		public MemoryCache.full (uint size_limit, Champlain.Renderer renderer);
		public uint get_size_limit ();
		public void set_size_limit (uint size_limit);
		public uint size_limit { get; set construct; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class MemphisRenderer : Champlain.Renderer {
		public Champlain.MemphisRendererPrivate priv;
		[CCode (has_construct_function = false)]
		public MemphisRenderer.full (uint tile_size);
		public Clutter.Color get_background_color ();
		public Champlain.BoundingBox get_bounding_box ();
		public GLib.List<string> get_rule_ids ();
		public uint get_tile_size ();
		public void load_rules (string rules_path);
		public void remove_rule (string id);
		public void set_background_color (Clutter.Color color);
		public void set_rule (Champlain.MemphisRule rule);
		public void set_tile_size (uint size);
		public Champlain.BoundingBox bounding_box { get; set; }
		public uint tile_size { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class NetworkBboxTileSource : Champlain.TileSource {
		public Champlain.NetworkBboxTileSourcePrivate priv;
		[CCode (has_construct_function = false)]
		public NetworkBboxTileSource.full (string id, string name, string license, string license_uri, uint min_zoom, uint max_zoom, uint tile_size, Champlain.MapProjection projection, Champlain.Renderer renderer);
		public unowned string get_api_uri ();
		public void load_map_data (Champlain.BoundingBox bbox);
		public void set_api_uri (string api_uri);
		public string api_uri { get; set; }
		[NoAccessorMethod]
		public string proxy_uri { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class NetworkTileSource : Champlain.TileSource {
		public Champlain.NetworkTileSourcePrivate priv;
		[CCode (has_construct_function = false)]
		public NetworkTileSource.full (string id, string name, string license, string license_uri, uint min_zoom, uint max_zoom, uint tile_size, Champlain.MapProjection projection, string uri_format, Champlain.Renderer renderer);
		public bool get_offline ();
		public unowned string get_proxy_uri ();
		public unowned string get_uri_format ();
		public void set_offline (bool offline);
		public void set_proxy_uri (string proxy_uri);
		public void set_uri_format (string uri_format);
		public bool offline { get; set; }
		public string proxy_uri { get; set; }
		public string uri_format { get; set construct; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class NullTileSource : Champlain.TileSource {
		[CCode (has_construct_function = false)]
		public NullTileSource.full (Champlain.Renderer renderer);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class PathLayer : Champlain.Layer, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.PathLayerPrivate priv;
		[CCode (has_construct_function = false)]
		public PathLayer ();
		public void add_node (Champlain.Location location);
		public bool get_closed ();
		public bool get_fill ();
		public Clutter.Color get_fill_color ();
		public GLib.List<weak Champlain.Location> get_nodes ();
		public bool get_stroke ();
		public Clutter.Color get_stroke_color ();
		public double get_stroke_width ();
		public bool get_visible ();
		public void insert_node (Champlain.Location location, uint position);
		public void remove_all ();
		public void remove_node (Champlain.Location location);
		public void set_closed (bool value);
		public void set_fill (bool value);
		public void set_fill_color (Clutter.Color? color);
		public void set_stroke (bool value);
		public void set_stroke_color (Clutter.Color? color);
		public void set_stroke_width (double value);
		public void set_visible (bool value);
		public bool closed { get; set; }
		public bool fill { get; set; }
		public Clutter.Color fill_color { get; set; }
		public bool stroke { get; set; }
		public Clutter.Color stroke_color { get; set; }
		public double stroke_width { get; set; }
		public bool visible { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Point : Champlain.Marker, Atk.Implementor, Champlain.Location, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.PointPrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Point ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Point.full (double size, Clutter.Color color);
		public Clutter.Color get_color ();
		public double get_size ();
		public void set_color (Clutter.Color? color);
		public void set_size (double size);
		public Clutter.Color color { get; set; }
		public double size { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Renderer : GLib.InitiallyUnowned {
		public virtual void render (Champlain.Tile tile);
		public virtual void set_data (string data, uint size);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Scale : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.ScalePrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Scale ();
		public void connect_view (Champlain.View view);
		public void disconnect_view ();
		public uint get_max_width ();
		public Champlain.Unit get_unit ();
		public void set_max_width (uint value);
		public void set_unit (Champlain.Unit unit);
		public uint max_width { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Tile : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.TilePrivate priv;
		[CCode (has_construct_function = false)]
		public Tile ();
		public void display_content ();
		[CCode (has_construct_function = false)]
		public Tile.full (uint x, uint y, uint size, uint zoom_level);
		public unowned Clutter.Actor get_content ();
		public unowned string get_etag ();
		public bool get_fade_in ();
		public GLib.TimeVal get_modified_time ();
		public uint get_size ();
		public Champlain.State get_state ();
		public uint get_x ();
		public uint get_y ();
		public uint get_zoom_level ();
		public void set_content (Clutter.Actor actor);
		public void set_etag (string etag);
		public void set_fade_in (bool fade_in);
		public void set_modified_time (GLib.TimeVal time);
		public void set_size (uint size);
		public void set_state (Champlain.State state);
		public void set_x (uint x);
		public void set_y (uint y);
		public void set_zoom_level (uint zoom_level);
		public Clutter.Actor content { get; set; }
		public string etag { get; set; }
		public bool fade_in { get; set; }
		public uint size { get; set; }
		public uint x { get; set; }
		public uint y { get; set; }
		public uint zoom_level { get; set; }
		public signal void render_complete (void* data, uint size, bool error);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class TileCache : Champlain.MapSource {
		public Champlain.TileCachePrivate priv;
		public virtual void on_tile_filled (Champlain.Tile tile);
		public virtual void refresh_tile_time (Champlain.Tile tile);
		public virtual void store_tile (Champlain.Tile tile, string contents, size_t size);
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class TileSource : Champlain.MapSource {
		public Champlain.TileSourcePrivate priv;
		public unowned Champlain.TileCache get_cache ();
		public void set_cache (Champlain.TileCache cache);
		public void set_id (string id);
		public void set_license (string license);
		public void set_license_uri (string license_uri);
		public void set_max_zoom_level (uint zoom_level);
		public void set_min_zoom_level (uint zoom_level);
		public void set_name (string name);
		public void set_projection (Champlain.MapProjection projection);
		public void set_tile_size (uint tile_size);
		public Champlain.TileCache cache { get; set; }
		[NoAccessorMethod]
		public string id { get; set construct; }
		[NoAccessorMethod]
		public string license { get; set construct; }
		[NoAccessorMethod]
		public string license_uri { get; set construct; }
		[NoAccessorMethod]
		public uint max_zoom_level { get; set construct; }
		[NoAccessorMethod]
		public uint min_zoom_level { get; set construct; }
		[NoAccessorMethod]
		public string name { get; set construct; }
		[NoAccessorMethod]
		public uint tile_size { get; set construct; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class View : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.ViewPrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public View ();
		public void add_layer (Champlain.Layer layer);
		public void bin_layout_add (Clutter.Actor child, Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		public void center_on (double latitude, double longitude);
		public void ensure_layers_visible (bool animate);
		public void ensure_visible (Champlain.BoundingBox bbox, bool animate);
		public double get_center_latitude ();
		public double get_center_longitude ();
		public double get_deceleration ();
		public bool get_keep_center_on_resize ();
		public bool get_kinetic_mode ();
		public unowned Champlain.License get_license_actor ();
		public unowned Champlain.MapSource get_map_source ();
		public uint get_max_zoom_level ();
		public uint get_min_zoom_level ();
		public Champlain.State get_state ();
		public void get_viewport_origin (out int x, out int y);
		public uint get_zoom_level ();
		public bool get_zoom_on_double_click ();
		public void go_to (double latitude, double longitude);
		public double latitude_to_y (double latitude);
		public double longitude_to_x (double longitude);
		public void reload_tiles ();
		public void remove_layer (Champlain.Layer layer);
		public void set_deceleration (double rate);
		public void set_keep_center_on_resize (bool value);
		public void set_kinetic_mode (bool kinetic);
		public void set_map_source (Champlain.MapSource map_source);
		public void set_max_zoom_level (uint zoom_level);
		public void set_min_zoom_level (uint zoom_level);
		public void set_zoom_level (uint zoom_level);
		public void set_zoom_on_double_click (bool value);
		public void stop_go_to ();
		public double x_to_longitude (double x);
		public double y_to_latitude (double y);
		public void zoom_in ();
		public void zoom_out ();
		public double deceleration { get; set; }
		public bool keep_center_on_resize { get; set; }
		public bool kinetic_mode { get; set; }
		[NoAccessorMethod]
		public double latitude { get; set; }
		[NoAccessorMethod]
		public double longitude { get; set; }
		public Champlain.MapSource map_source { get; set; }
		public uint max_zoom_level { get; set; }
		public uint min_zoom_level { get; set; }
		public uint zoom_level { get; set; }
		public bool zoom_on_double_click { get; set; }
		public signal void animation_completed ();
		public signal void layer_relocated ();
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public class Viewport : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public Champlain.ViewportPrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Viewport ();
		public void get_adjustments (Champlain.Adjustment hadjustment, Champlain.Adjustment vadjustment);
		public void get_origin (float x, float y);
		public void set_adjustments (Champlain.Adjustment hadjustment, Champlain.Adjustment vadjustment);
		public void set_child (Clutter.Actor child);
		public void set_origin (float x, float y);
		public void stop ();
		[NoAccessorMethod]
		public Champlain.Adjustment hadjustment { get; set; }
		[NoAccessorMethod]
		public bool sync_adjustments { get; set; }
		[NoAccessorMethod]
		public Champlain.Adjustment vadjustment { get; set; }
		[NoAccessorMethod]
		public int x_origin { get; set; }
		[NoAccessorMethod]
		public int y_origin { get; set; }
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public interface Location : GLib.Object {
		public abstract double get_latitude ();
		public abstract double get_longitude ();
		public abstract void set_location (double latitude, double longitude);
		public double latitude { get; set; }
		public double longitude { get; set; }
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_ADJUSTMENT_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct AdjustmentPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_COORDINATE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct CoordinatePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_CUSTOM_MARKER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct CustomMarkerPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_ERROR_TILE_RENDERER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct ErrorTileRendererPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_FILE_CACHE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct FileCachePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_FILE_TILE_SOURCE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct FileTileSourcePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_IMAGE_RENDERER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct ImageRendererPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_KINETIC_SCROLL_VIEW_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct KineticScrollViewPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_LABEL_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct LabelPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_LICENSE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct LicensePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MAP_SOURCE_CHAIN_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MapSourceChainPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MAP_SOURCE_DESC_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MapSourceDescPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MAP_SOURCE_FACTORY_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MapSourceFactoryPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MAP_SOURCE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MapSourcePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MARKER_LAYER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MarkerLayerPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MARKER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MarkerPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MEMORY_CACHE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MemoryCachePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MEMPHIS_RENDERER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct MemphisRendererPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MEMPHIS_RULE", cheader_filename = "champlain/champlain.h")]
	public struct MemphisRule {
		public weak string keys;
		public weak string values;
		public Champlain.MemphisRuleType type;
		public Champlain.MemphisRuleAttr polygon;
		public Champlain.MemphisRuleAttr line;
		public Champlain.MemphisRuleAttr border;
		public Champlain.MemphisRuleAttr text;
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_MEMPHIS_RULE_ATTR", cheader_filename = "champlain/champlain.h")]
	public struct MemphisRuleAttr {
		public uint8 z_min;
		public uint8 z_max;
		public uint8 color_red;
		public uint8 color_green;
		public uint8 color_blue;
		public uint8 color_alpha;
		public weak string style;
		public double size;
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_NETWORK_BBOX_TILE_SOURCE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct NetworkBboxTileSourcePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_NETWORK_TILE_SOURCE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct NetworkTileSourcePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_NULL_TILE_SOURCE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct NullTileSourcePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_PATH_LAYER_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct PathLayerPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_POINT_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct PointPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_SCALE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct ScalePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_TILE_CACHE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct TileCachePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_TILE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct TilePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_TILE_SOURCE_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct TileSourcePrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_VIEW_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct ViewPrivate {
	}
	[CCode (type_id = "CHAMPLAIN_TYPE_VIEWPORT_PRIVATE", cheader_filename = "champlain/champlain.h")]
	public struct ViewportPrivate {
	}
	[CCode (cprefix = "CHAMPLAIN_MAP_PROJECTION_", cheader_filename = "champlain/champlain.h")]
	public enum MapProjection {
		[CCode (cname = "CHAMPLAIN_MAP_PROJECTION_MERCATOR")]
		MAP_PROJECTION_MERCATOR
	}
	[CCode (cprefix = "CHAMPLAIN_MEMPHIS_RULE_TYPE_", cheader_filename = "champlain/champlain.h")]
	public enum MemphisRuleType {
		UNKNOWN,
		NODE,
		WAY,
		RELATION
	}
	[CCode (cprefix = "CHAMPLAIN_SELECTION_", cheader_filename = "champlain/champlain.h")]
	public enum SelectionMode {
		NONE,
		SINGLE,
		MULTIPLE
	}
	[CCode (cprefix = "CHAMPLAIN_STATE_", cheader_filename = "champlain/champlain.h")]
	public enum State {
		NONE,
		LOADING,
		LOADED,
		DONE
	}
	[CCode (cprefix = "CHAMPLAIN_UNIT_", cheader_filename = "champlain/champlain.h")]
	public enum Unit {
		KM,
		MILES
	}
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_MEMPHIS_LOCAL;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_MEMPHIS_NETWORK;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_MFF_RELIEF;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_OAM;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_OSM_CYCLE_MAP;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_OSM_MAPNIK;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_OSM_MAPQUEST;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_OSM_OSMARENDER;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string MAP_SOURCE_OSM_TRANSPORT_MAP;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const double MAX_LATITUDE;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const double MAX_LONGITUDE;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const double MIN_LATITUDE;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const double MIN_LONGITUDE;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const double VERSION;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const int VERSION_HEX;
	[CCode (cheader_filename = "champlain/champlain.h")]
	public const string VERSION_S;
}
