/*
 * Copyright (C) 2008 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#if !defined (__CHAMPLAIN_CHAMPLAIN_H_INSIDE__) && !defined (CHAMPLAIN_COMPILATION)
#error "Only <champlain/champlain.h> can be included directly."
#endif

#ifndef CHAMPLAIN_DEFINES_H
#define CHAMPLAIN_DEFINES_H

#define CHAMPLAIN_API __attribute__((visibility("default")))
#define CHAMPLAIN_OBSOLETE_API CHAMPLAIN_API __attribute__((deprecated))

typedef struct _ChamplainView ChamplainView;
typedef struct _ChamplainViewClass ChamplainViewClass;

typedef struct _ChamplainMapSource ChamplainMapSource;

#define CHAMPLAIN_PARAM_READABLE     \
        (G_PARAM_READABLE |     \
         G_PARAM_STATIC_NICK | G_PARAM_STATIC_NAME | G_PARAM_STATIC_BLURB)

#define CHAMPLAIN_PARAM_READWRITE    \
        (G_PARAM_READABLE | G_PARAM_WRITABLE | \
         G_PARAM_STATIC_NICK | G_PARAM_STATIC_NAME | G_PARAM_STATIC_BLURB)

typedef enum
{
  CHAMPLAIN_STATE_NONE,
  CHAMPLAIN_STATE_INIT,
  CHAMPLAIN_STATE_LOADING,
  CHAMPLAIN_STATE_DONE
} ChamplainState;

typedef enum
{
  CHAMPLAIN_UNIT_KM,
  CHAMPLAIN_UNIT_MILES,
} ChamplainUnit;

#endif
