package org.gnu.libebook;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.libedataserver.EDSMemStruct;

public class EContactAddress extends EDSMemStruct
{
    public EContactAddress(Handle handle)
    {
        super(handle);
    }

    public static EContactAddress getEContactAddress(Handle handle)
    {
        if (handle == null)
            return null;

        EContactAddress obj = (EContactAddress) MemStruct.getMemStructFromHandle(handle);
        return obj == null ? new EContactAddress(handle) : obj;
    }

    public String getAddressFormat()
    {
        return e_contact_address_get_address_format(getHandle());
    }

    public String getPO()
    {
        return e_contact_address_get_po(getHandle());
    }

    public String getExt()
    {
        return e_contact_address_get_ext(getHandle());
    }

    public String getStreet()
    {
        return e_contact_address_get_street(getHandle());
    }

    public String getLocality()
    {
        return e_contact_address_get_locality(getHandle());
    }

    public String getRegion()
    {
        return e_contact_address_get_region(getHandle());
    }

    public String getCode()
    {
        return e_contact_address_get_code(getHandle());
    }

    public String getCountry()
    {
        return e_contact_address_get_country(getHandle());
    }

    public void setAddressFormat(String addressFormat)
    {
        e_contact_address_set_address_format(getHandle(), addressFormat);
    }

    public void setPO(String po)
    {
        e_contact_address_set_po(getHandle(), po);
    }

    public void setExt(String ext)
    {
        e_contact_address_set_ext(getHandle(), ext);
    }

    public void setStreet(String street)
    {
        e_contact_address_set_street(getHandle(), street);
    }

    public void setLocality(String locality)
    {
        e_contact_address_set_locality(getHandle(), locality);
    }

    public void setRegion(String region)
    {
        e_contact_address_set_region(getHandle(), region);
    }

    public void setCode(String code)
    {
        e_contact_address_set_code(getHandle(), code);
    }

    public void setCountry(String country)
    {
        e_contact_address_set_country(getHandle(), country);
    }

    public static EContactAddress createNewContactAddress()
    {
        return getEContactAddress(e_contact_address_new());
    }

    native static private String e_contact_address_get_address_format(Handle handle);

    native static private String e_contact_address_get_po(Handle handle);

    native static private String e_contact_address_get_ext(Handle handle);

    native static private String e_contact_address_get_street(Handle handle);

    native static private String e_contact_address_get_locality(Handle handle);

    native static private String e_contact_address_get_region(Handle handle);

    native static private String e_contact_address_get_code(Handle handle);

    native static private String e_contact_address_get_country(Handle handle);

    native static private void e_contact_address_set_address_format(Handle handle, String value);

    native static private void e_contact_address_set_po(Handle handle, String value);

    native static private void e_contact_address_set_ext(Handle handle, String value);

    native static private void e_contact_address_set_street(Handle handle, String value);

    native static private void e_contact_address_set_locality(Handle handle, String value);

    native static private void e_contact_address_set_region(Handle handle, String value);

    native static private void e_contact_address_set_code(Handle handle, String value);

    native static private void e_contact_address_set_country(Handle handle, String value);

    native static private Handle e_contact_address_new();
}
