// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_RAWGRID_H
#define _LIBGDA_UIMM_RAWGRID_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treeview.h>
#include <libgda-uimm/dataselector.h>
#include <libgda-uimm/dataproxy.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiRawGrid GdauiRawGrid;
typedef struct _GdauiRawGridClass GdauiRawGridClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class RawGrid_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataModel;

}

namespace GdaUI
{

/** RawGrid - Grid widget to manipulate data in a Gnome::Gda::DataModel.
 */

class RawGrid :
  public Gtk::TreeView,
  public DataSelector,
  public DataProxy
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef RawGrid CppObjectType;
  typedef RawGrid_Class CppClassType;
  typedef GdauiRawGrid BaseObjectType;
  typedef GdauiRawGridClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~RawGrid();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class RawGrid_Class;
  static CppClassType rawgrid_class_;

  // noncopyable
  RawGrid(const RawGrid&);
  RawGrid& operator=(const RawGrid&);

protected:
  explicit RawGrid(const Glib::ConstructParams& construct_params);
  explicit RawGrid(GdauiRawGrid* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdauiRawGrid*       gobj()       { return reinterpret_cast<GdauiRawGrid*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdauiRawGrid* gobj() const { return reinterpret_cast<GdauiRawGrid*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_double_clicked(int row);
  virtual void on_populate_popup(Gtk::Menu* menu);


private:

  
public:
  
  /** Creates a new Gdaui::RawGrid widget suitable to display the data in @a model
   * 
   * @newin{4,2}
   * @param model A Gda::DataModel.
   * @return The new widget.
   */

    explicit RawGrid(const Glib::RefPtr<Gnome::Gda::DataModel>& model);


public:
  
  /** Sets the size of each chunk of data to display: the maximum number of rows which
   * can be displayed at a time. See Gdaui::Grid::set_sample_size() and gda_data_proxy_set_sample_size()
   * 
   * @newin{4,2}
   * @param sample_size The size of the sample displayed in @a grid.
   */
  void set_sample_size(int sample_size);
  
  /** @newin{4,2}
   */
  void set_sample_start(int sample_start);
  
  /** Sets a grid's columns layout according an XML description contained in @a file_name, for the grid identified
   * by the @a grid_name name (as an XML layout file can contain the descriptions of several forms and grids).
   * 
   * @newin{4,2}
   * @param file_name XML file name to use.
   * @param grid_name The name of the grid to use, in @a file_name.
   */
  void set_layout_from_file(const std::string& file_name, const Glib::ustring& grid_name);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%double_clicked(int row)</tt>
   */

  Glib::SignalProxy1< void,int > signal_double_clicked();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%populate_popup(Gtk::Menu* menu)</tt>
   */

  Glib::SignalProxy1< void,Gtk::Menu* > signal_populate_popup();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Global Actions visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_global_actions_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Global Actions visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_global_actions_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Info cell visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_info_cell_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Info cell visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_info_cell_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //TODO: _WRAP_PROPERTY("xml-layout", gpointer)


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::RawGrid
   */
  Gnome::GdaUI::RawGrid* wrap(GdauiRawGrid* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGDA_UIMM_RAWGRID_H */

