// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_XMLSTORAGE_H
#define _LIBGDAMM_XMLSTORAGE_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* xmlstorage.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <libgda/gda-xml-storage.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaXmlStorage GdaXmlStorage;
typedef struct _GdaXmlStorageClass GdaXmlStorageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class XmlStorage_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Base class which provides saving and loading using XML structures.
 * Any object which implements this interface can be streamed and restored to and from an XML file.
 * @ingroup Miscellaneous
 */

class XmlStorage : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef XmlStorage CppObjectType;
  typedef XmlStorage_Class CppClassType;
  typedef GdaXmlStorage BaseObjectType;
  typedef GdaXmlStorageIface BaseClassType;

private:
  friend class XmlStorage_Class;
  static CppClassType xmlstorage_class_;

  // noncopyable
  XmlStorage(const XmlStorage&);
  XmlStorage& operator=(const XmlStorage&);

protected:
  XmlStorage(); // you must derive from this class

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit XmlStorage(GdaXmlStorage* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~XmlStorage();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaXmlStorage*       gobj()       { return reinterpret_cast<GdaXmlStorage*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdaXmlStorage* gobj() const { return reinterpret_cast<GdaXmlStorage*>(gobject_); }

private:

public:

  
  /** Fetch the xml id string of the object, it's up to the caller to
   * free the string.
   * @return The xml id.
   */
  Glib::ustring get_xml_id() const;
  
  /** Creates a new xmlNodePtr structure and fills it with data representing the
   * object given as argument.
   * @param error Location to store error, or <tt>0</tt>.
   * @return The new XML node, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  xmlNodePtr save_to_xml() const;
#else
  xmlNodePtr save_to_xml(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Updates the object with data stored in the XML node. The object MUST already
   * exist and be of the correct type before calling this function. 
   * This is a virtual function.
   * @param node An XML node from an XML structure.
   * @param error Location to store error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool load_from_xml(xmlNodePtr node);
#else
  bool load_from_xml(xmlNodePtr node, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::XmlStorage
   */
  Glib::RefPtr<Gnome::Gda::XmlStorage> wrap(GdaXmlStorage* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDAMM_XMLSTORAGE_H */

