
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgdamm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "blob.h"
#include "blobop.h"
#include "client.h"
#include "column.h"
#include "columnindex.h"
#include "command.h"
#include "connection.h"
#include "connectionevent.h"
#include "datahandler.h"
#include "datamodel.h"
#include "datamodelarray.h"
#include "datamodelfiltersql.h"
#include "datamodelhash.h"
#include "datamodelimport.h"
#include "datamodelindex.h"
#include "datamodeliter.h"
#include "datamodelquery.h"
#include "datamodelrow.h"
#include "dataproxy.h"
#include "datasourceinfo.h"
#include "dict.h"
#include "dictaggregate.h"
#include "dictconstraint.h"
#include "dictdatabase.h"
#include "dictfield.h"
#include "dicttable.h"
#include "dicttype.h"
#include "dictfunction.h"
#include "entity.h"
#include "entityfield.h"
#include "handlerstring.h"
#include "handlerboolean.h"
#include "handlertime.h"
#include "handlernumerical.h"
#include "handlerbin.h"
#include "handlertype.h"
#include "object.h"
#include "parameter.h"
#include "parameterlist.h"
#include "providerinfo.h"
#include "query.h"
#include "querycondition.h"
#include "queryfield.h"
#include "queryfieldfunc.h"
#include "queryfieldagg.h"
#include "queryfieldall.h"
#include "queryfieldfield.h"
#include "queryfieldvalue.h"
#include "queryjoin.h"
#include "queryobject.h"
#include "querytarget.h"
#include "referer.h"
#include "renderer.h"
#include "row.h"
#include "serverprovider.h"
#include "serveroperation.h"
#include "transactionstatus.h"
#include "xmlstorage.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gda_blob_op_get_type(void);
GType gda_client_get_type(void);
GType gda_column_get_type(void);
GType gda_column_index_get_type(void);
GType gda_connection_get_type(void);
GType gda_connection_event_get_type(void);
GType gda_data_model_array_get_type(void);
GType gda_data_model_filter_sql_get_type(void);
GType gda_data_model_hash_get_type(void);
GType gda_data_model_import_get_type(void);
GType gda_data_model_iter_get_type(void);
GType gda_data_model_query_get_type(void);
GType gda_data_model_row_get_type(void);
GType gda_data_proxy_get_type(void);
GType gda_dict_get_type(void);
GType gda_dict_aggregate_get_type(void);
GType gda_dict_constraint_get_type(void);
GType gda_dict_database_get_type(void);
GType gda_dict_field_get_type(void);
GType gda_dict_function_get_type(void);
GType gda_dict_table_get_type(void);
GType gda_dict_type_get_type(void);
GType gda_handler_bin_get_type(void);
GType gda_handler_boolean_get_type(void);
GType gda_handler_numerical_get_type(void);
GType gda_handler_string_get_type(void);
GType gda_handler_time_get_type(void);
GType gda_handler_type_get_type(void);
GType gda_object_get_type(void);
GType gda_parameter_get_type(void);
GType gda_parameter_list_get_type(void);
GType gda_query_get_type(void);
GType gda_query_condition_get_type(void);
GType gda_query_field_get_type(void);
GType gda_query_field_agg_get_type(void);
GType gda_query_field_all_get_type(void);
GType gda_query_field_field_get_type(void);
GType gda_query_field_func_get_type(void);
GType gda_query_field_value_get_type(void);
GType gda_query_join_get_type(void);
GType gda_query_object_get_type(void);
GType gda_query_target_get_type(void);
GType gda_row_get_type(void);
GType gda_server_operation_get_type(void);
GType gda_server_provider_get_type(void);
GType gda_transaction_status_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark gda_client_error_quark(void);
GQuark gda_connection_error_quark(void);
GQuark gda_data_model_iter_error_quark(void);
GQuark gda_data_model_query_error_quark(void);
GQuark gda_dict_error_quark(void);
GQuark gda_general_error_quark(void);
GQuark gda_parameter_error_quark(void);
GQuark gda_parameter_list_error_quark(void);
GQuark gda_query_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Gda {  class BlobOp_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Client_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Column_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ColumnIndex_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Connection_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ConnectionEvent_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelArray_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelFilterSQL_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelHash_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelImport_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelIter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelQuery_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelRow_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataProxy_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Dict_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictAggregate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictConstraint_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictDatabase_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictField_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictFunction_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictTable_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DictType_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerBin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerBoolean_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerNumerical_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerString_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerTime_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerType_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Object_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Parameter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ParameterList_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Query_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryCondition_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryField_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryFieldAgg_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryFieldAll_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryFieldField_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryFieldFunc_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryFieldValue_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryJoin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryObject_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class QueryTarget_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Row_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ServerOperation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ServerProvider_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class TransactionStatus_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Gda { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(gda_client_error_quark(), &Gnome::Gda::ClientError::throw_func);
  Glib::Error::register_domain(gda_connection_error_quark(), &Gnome::Gda::ConnectionError::throw_func);
  Glib::Error::register_domain(gda_data_model_iter_error_quark(), &Gnome::Gda::DataModelIterError::throw_func);
  Glib::Error::register_domain(gda_data_model_query_error_quark(), &Gnome::Gda::DataModelQueryError::throw_func);
  Glib::Error::register_domain(gda_dict_error_quark(), &Gnome::Gda::DictError::throw_func);
  Glib::Error::register_domain(gda_general_error_quark(), &Gnome::Gda::GeneralError::throw_func);
  Glib::Error::register_domain(gda_parameter_error_quark(), &Gnome::Gda::ParameterError::throw_func);
  Glib::Error::register_domain(gda_parameter_list_error_quark(), &Gnome::Gda::ParameterListError::throw_func);
  Glib::Error::register_domain(gda_query_error_quark(), &Gnome::Gda::QueryError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gda_blob_op_get_type(), &Gnome::Gda::BlobOp_Class::wrap_new);
  Glib::wrap_register(gda_client_get_type(), &Gnome::Gda::Client_Class::wrap_new);
  Glib::wrap_register(gda_column_get_type(), &Gnome::Gda::Column_Class::wrap_new);
  Glib::wrap_register(gda_column_index_get_type(), &Gnome::Gda::ColumnIndex_Class::wrap_new);
  Glib::wrap_register(gda_connection_get_type(), &Gnome::Gda::Connection_Class::wrap_new);
  Glib::wrap_register(gda_connection_event_get_type(), &Gnome::Gda::ConnectionEvent_Class::wrap_new);
  Glib::wrap_register(gda_data_model_array_get_type(), &Gnome::Gda::DataModelArray_Class::wrap_new);
  Glib::wrap_register(gda_data_model_filter_sql_get_type(), &Gnome::Gda::DataModelFilterSQL_Class::wrap_new);
  Glib::wrap_register(gda_data_model_hash_get_type(), &Gnome::Gda::DataModelHash_Class::wrap_new);
  Glib::wrap_register(gda_data_model_import_get_type(), &Gnome::Gda::DataModelImport_Class::wrap_new);
  Glib::wrap_register(gda_data_model_iter_get_type(), &Gnome::Gda::DataModelIter_Class::wrap_new);
  Glib::wrap_register(gda_data_model_query_get_type(), &Gnome::Gda::DataModelQuery_Class::wrap_new);
  Glib::wrap_register(gda_data_model_row_get_type(), &Gnome::Gda::DataModelRow_Class::wrap_new);
  Glib::wrap_register(gda_data_proxy_get_type(), &Gnome::Gda::DataProxy_Class::wrap_new);
  Glib::wrap_register(gda_dict_get_type(), &Gnome::Gda::Dict_Class::wrap_new);
  Glib::wrap_register(gda_dict_aggregate_get_type(), &Gnome::Gda::DictAggregate_Class::wrap_new);
  Glib::wrap_register(gda_dict_constraint_get_type(), &Gnome::Gda::DictConstraint_Class::wrap_new);
  Glib::wrap_register(gda_dict_database_get_type(), &Gnome::Gda::DictDatabase_Class::wrap_new);
  Glib::wrap_register(gda_dict_field_get_type(), &Gnome::Gda::DictField_Class::wrap_new);
  Glib::wrap_register(gda_dict_function_get_type(), &Gnome::Gda::DictFunction_Class::wrap_new);
  Glib::wrap_register(gda_dict_table_get_type(), &Gnome::Gda::DictTable_Class::wrap_new);
  Glib::wrap_register(gda_dict_type_get_type(), &Gnome::Gda::DictType_Class::wrap_new);
  Glib::wrap_register(gda_handler_bin_get_type(), &Gnome::Gda::HandlerBin_Class::wrap_new);
  Glib::wrap_register(gda_handler_boolean_get_type(), &Gnome::Gda::HandlerBoolean_Class::wrap_new);
  Glib::wrap_register(gda_handler_numerical_get_type(), &Gnome::Gda::HandlerNumerical_Class::wrap_new);
  Glib::wrap_register(gda_handler_string_get_type(), &Gnome::Gda::HandlerString_Class::wrap_new);
  Glib::wrap_register(gda_handler_time_get_type(), &Gnome::Gda::HandlerTime_Class::wrap_new);
  Glib::wrap_register(gda_handler_type_get_type(), &Gnome::Gda::HandlerType_Class::wrap_new);
  Glib::wrap_register(gda_object_get_type(), &Gnome::Gda::Object_Class::wrap_new);
  Glib::wrap_register(gda_parameter_get_type(), &Gnome::Gda::Parameter_Class::wrap_new);
  Glib::wrap_register(gda_parameter_list_get_type(), &Gnome::Gda::ParameterList_Class::wrap_new);
  Glib::wrap_register(gda_query_get_type(), &Gnome::Gda::Query_Class::wrap_new);
  Glib::wrap_register(gda_query_condition_get_type(), &Gnome::Gda::QueryCondition_Class::wrap_new);
  Glib::wrap_register(gda_query_field_get_type(), &Gnome::Gda::QueryField_Class::wrap_new);
  Glib::wrap_register(gda_query_field_agg_get_type(), &Gnome::Gda::QueryFieldAgg_Class::wrap_new);
  Glib::wrap_register(gda_query_field_all_get_type(), &Gnome::Gda::QueryFieldAll_Class::wrap_new);
  Glib::wrap_register(gda_query_field_field_get_type(), &Gnome::Gda::QueryFieldField_Class::wrap_new);
  Glib::wrap_register(gda_query_field_func_get_type(), &Gnome::Gda::QueryFieldFunc_Class::wrap_new);
  Glib::wrap_register(gda_query_field_value_get_type(), &Gnome::Gda::QueryFieldValue_Class::wrap_new);
  Glib::wrap_register(gda_query_join_get_type(), &Gnome::Gda::QueryJoin_Class::wrap_new);
  Glib::wrap_register(gda_query_object_get_type(), &Gnome::Gda::QueryObject_Class::wrap_new);
  Glib::wrap_register(gda_query_target_get_type(), &Gnome::Gda::QueryTarget_Class::wrap_new);
  Glib::wrap_register(gda_row_get_type(), &Gnome::Gda::Row_Class::wrap_new);
  Glib::wrap_register(gda_server_operation_get_type(), &Gnome::Gda::ServerOperation_Class::wrap_new);
  Glib::wrap_register(gda_server_provider_get_type(), &Gnome::Gda::ServerProvider_Class::wrap_new);
  Glib::wrap_register(gda_transaction_status_get_type(), &Gnome::Gda::TransactionStatus_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Gda::BlobOp::get_type();
  Gnome::Gda::Client::get_type();
  Gnome::Gda::Column::get_type();
  Gnome::Gda::ColumnIndex::get_type();
  Gnome::Gda::Connection::get_type();
  Gnome::Gda::ConnectionEvent::get_type();
  Gnome::Gda::DataModelArray::get_type();
  Gnome::Gda::DataModelFilterSQL::get_type();
  Gnome::Gda::DataModelHash::get_type();
  Gnome::Gda::DataModelImport::get_type();
  Gnome::Gda::DataModelIter::get_type();
  Gnome::Gda::DataModelQuery::get_type();
  Gnome::Gda::DataModelRow::get_type();
  Gnome::Gda::DataProxy::get_type();
  Gnome::Gda::Dict::get_type();
  Gnome::Gda::DictAggregate::get_type();
  Gnome::Gda::DictConstraint::get_type();
  Gnome::Gda::DictDatabase::get_type();
  Gnome::Gda::DictField::get_type();
  Gnome::Gda::DictFunction::get_type();
  Gnome::Gda::DictTable::get_type();
  Gnome::Gda::DictType::get_type();
  Gnome::Gda::HandlerBin::get_type();
  Gnome::Gda::HandlerBoolean::get_type();
  Gnome::Gda::HandlerNumerical::get_type();
  Gnome::Gda::HandlerString::get_type();
  Gnome::Gda::HandlerTime::get_type();
  Gnome::Gda::HandlerType::get_type();
  Gnome::Gda::Object::get_type();
  Gnome::Gda::Parameter::get_type();
  Gnome::Gda::ParameterList::get_type();
  Gnome::Gda::Query::get_type();
  Gnome::Gda::QueryCondition::get_type();
  Gnome::Gda::QueryField::get_type();
  Gnome::Gda::QueryFieldAgg::get_type();
  Gnome::Gda::QueryFieldAll::get_type();
  Gnome::Gda::QueryFieldField::get_type();
  Gnome::Gda::QueryFieldFunc::get_type();
  Gnome::Gda::QueryFieldValue::get_type();
  Gnome::Gda::QueryJoin::get_type();
  Gnome::Gda::QueryObject::get_type();
  Gnome::Gda::QueryTarget::get_type();
  Gnome::Gda::Row::get_type();
  Gnome::Gda::ServerOperation::get_type();
  Gnome::Gda::ServerProvider::get_type();
  Gnome::Gda::TransactionStatus::get_type();

} // wrap_init()

} //Gda
} //Gnome


