// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGLADEMM_XML_H
#define _LIBGLADEMM_XML_H

#include <glibmm.h>

/* $Id: xml.hg,v 1.15 2002/12/20 10:45:03 murrayc Exp $ */

/* Copyright (C) 2002 The libglademm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GladeXML GladeXML;
typedef struct _GladeXMLClass GladeXMLClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Glade
{ class Xml_Class; } // namespace Glade

} // namespace Gnome
namespace Gnome
{

namespace Glade
{

class XmlError : public Glib::Exception
{
public:
  explicit XmlError(const Glib::ustring& message);
  virtual ~XmlError() throw();

  XmlError(const XmlError& other);
  XmlError& operator=(const XmlError& other);

  virtual Glib::ustring what() const;

private:
  Glib::ustring message_;
};


class Xml : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Xml CppObjectType;
  typedef Xml_Class CppClassType;
  typedef GladeXML BaseObjectType;
  typedef GladeXMLClass BaseClassType;

private:  friend class Xml_Class;
  static CppClassType xml_class_;

private:
  // noncopyable
  Xml(const Xml&);
  Xml& operator=(const Xml&);

protected:
  explicit Xml(const Glib::ConstructParams& construct_params);
  explicit Xml(GladeXML* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Xml();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GladeXML*       gobj()       { return reinterpret_cast<GladeXML*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GladeXML* gobj() const { return reinterpret_cast<GladeXML*>(gobject_); }

  GladeXML* gobj_copy();

private:

  
   //Ignore private glade_xml functions.

protected:
  /** Loads a glade XML file.
   * @throw XmlError
   */
  Xml(const std::string& filename, const Glib::ustring& root, const Glib::ustring& domain);

  /** Reads glade XML data from memory.
   * @throw XmlError
   */
  Xml(const char* buffer, int size, const Glib::ustring& root, const Glib::ustring& domain);

  Gtk::Widget* get_widget_checked(const Glib::ustring& name, GType type);
  GtkWidget* get_cwidget(const Glib::ustring& name);

public:
  typedef Gnome::Glade::XmlError Error;

  /** Loads a glade XML file.
   * @throw XmlError
   */
  static Glib::RefPtr<Xml> create(const std::string& filename,
                                  const Glib::ustring& root   = Glib::ustring(),
                                  const Glib::ustring& domain = Glib::ustring());

  /** Reads glade XML data from memory.
   * @throw XmlError
   */
  static Glib::RefPtr<Xml> create_from_buffer(const char* buffer, int size,
                                              const Glib::ustring& root   = Glib::ustring(),
                                              const Glib::ustring& domain = Glib::ustring());

  std::string get_filename() const;

//void       glade_xml_signal_connect      (GladeXML *self,
//					  const char *handlername,
//					  GCallback func);
//void       glade_xml_signal_connect_data (GladeXML *self,
//					  const char *handlername,
//					  GCallback func,
//					  gpointer user_data);
//
//void       glade_xml_signal_autoconnect  (GladeXML *self);
//
//
//typedef void (*GladeXMLConnectFunc) (const gchar *handler_name,
//				     GObject *object,
//				     const gchar *signal_name,
//				     const gchar *signal_data,
//				     GObject *connect_object,
//				     gboolean after,
//				     gpointer user_data);
//
//
//void       glade_xml_signal_connect_full     (GladeXML *self,
//					      const gchar *handler_name,
//					      GladeXMLConnectFunc func,
//					      gpointer user_data);
//
//void       glade_xml_signal_autoconnect_full (GladeXML *self,
//					      GladeXMLConnectFunc func,
//					      gpointer user_data);
//
//
  /** Get a widget from the glade file.
   * For instance:
   * @code
   * Gtk::Table* pTable = dynamic_cast<Gtk::Table*>(refXml->get_widget("mytable"));
   * @endcode
   * @param name The name of the widget.
   * @return A pointer to the widget, or <tt>0</tt> on failure.
   */
  
  Gtk::Widget* get_widget(const Glib::ustring& name);

  /** This is for convenience.
   * It allows for a shorter syntax with less repetition. For instance:
   * @code
   * Gtk::Table* pTable = 0;
   * refXml->get_widget("mytable", pTable);
   * @endcode
   * This method prints a warning message to the console if the widget
   * doesn't exist or has the wrong type, so you don't need to check that
   * manually.
   * @param name The name of the widget.
   * @retval widget A pointer to the widget, or <tt>0</tt> on failure.
   * @return The value of @a widget.
   */
  template <class T_Widget> inline
  T_Widget* get_widget(const Glib::ustring& name, T_Widget*& widget)
  {
    // The dynamic_cast<> should never fail if get_widget_checked() succeeded.
    widget = dynamic_cast<T_Widget*>(this->get_widget_checked(name, T_Widget::get_base_type()));

    if(!widget)
      g_critical("Gnome::Glade::Xml::get_widget(): dynamic_cast<> failed.");
      
    return widget;
  }

  /** 
   * @param name The name of the widget.
   * @retval widget A pointer to the widget, or <tt>0</tt> on failure.
   * @return The value of @a widget.
   */
  template <class T_Widget> inline
  T_Widget* get_widget_derived(const Glib::ustring& name, T_Widget*& widget)
  {
     // Get the widget from the glade file.
     typedef  typename T_Widget::BaseObjectType cwidget_type;
     cwidget_type* pCWidget = (cwidget_type*)get_cwidget(name);

     //Set the output variable. We needed to do this because we can not template the return type.
     Glib::RefPtr<Gnome::Glade::Xml> refThis(this);
     refThis->reference(); //take a copy.
     widget = new T_Widget(pCWidget, refThis);

     //We return it too.
     return widget;
  }

  
  Glib::ListHandle<Gtk::Widget*> get_widget_prefix(const Glib::ustring& name);

  ///Take the widget from the glade-generated container and put it in another container.
  void reparent_widget(const Glib::ustring& name, Gtk::Container& container);

  
  std::string relative_file(const std::string& filename) const;

  
  static Glib::ustring get_widget_name(Gtk::Widget& widget);
  
  static Glib::RefPtr<Xml> get_widget_tree(Gtk::Widget& widget);

///* interface for changing the custom widget handling */
//typedef GtkWidget *(* GladeXMLCustomWidgetHandler) (GladeXML *xml,
//						    gchar *func_name,
//						    gchar *name,
//						    gchar *string1,
//						    gchar *string2,
//						    gint int1,
//						    gint int2,
//						    gpointer user_data);

//void glade_set_custom_handler(GladeXMLCustomWidgetHandler handler,
//			      gpointer user_data);


protected:

  
  virtual GType lookup_type_vfunc(const Glib::ustring& classname);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Glade
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Glade::Xml */
  Glib::RefPtr<Gnome::Glade::Xml> wrap(GladeXML* object, bool take_copy = false);
}


#endif /* _LIBGLADEMM_XML_H */

