
#include <libgnomecanvasmm/shape.h>
#include <libgnomecanvasmm/private/shape_p.h>

/* shape.cc
 *
 * Copyright (C) 2002 The libgnomecanvasmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Shape* wrap(GnomeCanvasShape* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Shape *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Shape_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_shape_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Shape_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Shape_Class::wrap_new(GObject* o)
{
  return manage(new Shape((GnomeCanvasShape*)(o)));
}


/* The implementation: */

Shape::Shape(GnomeCanvasShape* castitem)
: Item((GnomeCanvasItem*)(castitem))
{}

Shape::~Shape()
{
  destroy_();
}

Shape::CppClassType Shape::shape_class_; //Initialize static member.

GType Shape::get_type()
{
  return shape_class_.get_type();
}

GType Shape::get_base_type()
{
  return gnome_canvas_shape_get_type();
}


Glib::PropertyProxy_WriteOnly<Glib::ustring> Shape::property_fill_color()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "fill_color");
}

Glib::PropertyProxy<Gdk::Color> Shape::property_fill_color_gdk()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "fill_color_gdk");
}

Glib::PropertyProxy<guint> Shape::property_fill_color_rgba()
{
  return Glib::PropertyProxy<guint>(this, "fill_color_rgba");
}

Glib::PropertyProxy_WriteOnly<Glib::ustring> Shape::property_outline_color()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "outline_color");
}

Glib::PropertyProxy<Gdk::Color> Shape::property_outline_color_gdk()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "outline_color_gdk");
}

Glib::PropertyProxy<guint> Shape::property_outline_color_rgba()
{
  return Glib::PropertyProxy<guint>(this, "outline_color_rgba");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> > Shape::property_fill_stipple()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> >(this, "fill_stipple");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> > Shape::property_outline_stipple()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> >(this, "outline_stipple");
}

Glib::PropertyProxy<guint> Shape::property_width_pixels()
{
  return Glib::PropertyProxy<guint>(this, "width_pixels");
}

Glib::PropertyProxy_WriteOnly<double> Shape::property_width_units()
{
  return Glib::PropertyProxy_WriteOnly<double>(this, "width_units");
}

Glib::PropertyProxy<Gdk::CapStyle> Shape::property_cap_style()
{
  return Glib::PropertyProxy<Gdk::CapStyle>(this, "cap_style");
}

Glib::PropertyProxy<Gdk::JoinStyle> Shape::property_join_style()
{
  return Glib::PropertyProxy<Gdk::JoinStyle>(this, "join_style");
}

Glib::PropertyProxy<guint> Shape::property_wind()
{
  return Glib::PropertyProxy<guint>(this, "wind");
}

Glib::PropertyProxy<double> Shape::property_miterlimit()
{
  return Glib::PropertyProxy<double>(this, "miterlimit");
}

Glib::PropertyProxy<ArtVpathDash*> Shape::property_dash()
{
  return Glib::PropertyProxy<ArtVpathDash*>(this, "dash");
}


} // namespace Canvas

} // namespace Gnome

