/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <bonobo/bonobo-i18n.h>
#include <gtk/gtklabel.h>
#include <gtk/gtknotebook.h>
#include <libgnomedb/gnome-db-browser.h>
#include <libgnomedb/gnome-db-grid.h>
#include <libgnomedb/gnome-db-table-editor.h>
#include <libgnomedb/gnome-db-util.h>
#include "gnome-db-browser-private.h"

typedef struct {
	GtkWidget *container;
	GtkWidget *table_struct;
	GtkWidget *data_grid;
} GnomeDbBrowserTablesPrivate;

/*
 * Private functions
 */

static void
free_private_data (gpointer data)
{
	GnomeDbBrowserTablesPrivate *priv = (GnomeDbBrowserTablesPrivate *) data;

	g_return_if_fail (priv != NULL);

	g_free (priv);
}

/*
 * Public functions
 */

GtkWidget *
gnome_db_browser_tables_new (void)
{
	GtkWidget *box;
	GnomeDbBrowserTablesPrivate *priv;

	priv = g_new0 (GnomeDbBrowserTablesPrivate, 1);
	priv->container = gnome_db_new_notebook_widget ();
	gtk_notebook_popup_disable (GTK_NOTEBOOK (priv->container));
	g_object_set_data_full (G_OBJECT (priv->container), "GnomeDbBrowserTablesPrivate",
				priv, (GDestroyNotify) free_private_data);

	gtk_widget_show (priv->container);

	/* create the 'Structure' tab */
	box = gnome_db_new_vbox_widget (FALSE, 0);
	priv->table_struct = gnome_db_new_grid_widget (NULL);
	gtk_box_pack_start (GTK_BOX (box), priv->table_struct, TRUE, TRUE, 0);
	gtk_notebook_append_page (GTK_NOTEBOOK (priv->container),
				  box,
				  gtk_label_new (_("Structure")));

	/* create 'Data' tab */
	box = gnome_db_new_vbox_widget (FALSE, 0);
	priv->data_grid = gnome_db_new_grid_widget (NULL);
	gtk_box_pack_start (GTK_BOX (box), priv->data_grid, TRUE, TRUE, 0);
	gtk_notebook_append_page (GTK_NOTEBOOK (priv->container),
				  box,
				  gtk_label_new (_("Data")));

	return priv->container;
}

void
gnome_db_browser_tables_show (GtkWidget *widget, GdaConnection *cnc, const gchar *str)
{
	GnomeDbBrowserTablesPrivate *priv;
	GList *reclist;
	GdaCommand *cmd;
	GdaDataModel *fields;
	GdaParameterList *params;

	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_return_if_fail (GDA_IS_CONNECTION (cnc));
	g_return_if_fail (str != NULL);

	priv = g_object_get_data (G_OBJECT (widget), "GnomeDbBrowserTablesPrivate");
	if (!priv)
		return;

	gnome_db_browser_tables_clear (widget);

	/* get table structure */
	params = gda_parameter_list_new ();
	gda_parameter_list_add_parameter (params, gda_parameter_new_string ("name", str));
	fields = gda_connection_get_schema (cnc, GDA_CONNECTION_SCHEMA_FIELDS, params);

	gnome_db_grid_set_model (GNOME_DB_GRID (priv->table_struct), fields);

	gda_parameter_list_free (params);
	g_object_unref (G_OBJECT (fields));
	
	/* get table data */
	cmd = gda_command_new (str, GDA_COMMAND_TYPE_TABLE, 0);
	reclist = gda_connection_execute_command (cnc, cmd, NULL);
	if (reclist) {
		gnome_db_grid_set_model (GNOME_DB_GRID (priv->data_grid),
					 GDA_DATA_MODEL (reclist->data));

		g_list_foreach (reclist, (GFunc) g_object_unref, NULL);
		g_list_free (reclist);
	}

	/* free memory */
	gda_command_free (cmd);
}

void
gnome_db_browser_tables_clear (GtkWidget *widget)
{
	GnomeDbBrowserTablesPrivate *priv;

	priv = g_object_get_data (G_OBJECT (widget), "GnomeDbBrowserTablesPrivate");
	if (!priv)
		return;

	gnome_db_grid_set_model (GNOME_DB_GRID (priv->table_struct), NULL);
	gnome_db_grid_set_model (GNOME_DB_GRID (priv->data_grid), NULL);
}
