/* GNOME DB test program
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this Program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <libgda/libgda.h>
#include <libgnomedb/gnome-db-grid.h>
#include <libgnomedb/gnome-db-window.h>
#include <libgnomeui/gnome-ui-init.h>

static void
window_closed_cb (GnomeDbWindow *window, gpointer user_data)
{
	gda_main_quit ();
}

static GdaDataModel *
create_data_model (void)
{
	gint i;
	GdaDataModel *model;

	model = gda_data_model_array_new (6);

	for (i = 0; i < 50; i++) {
		GList *values = NULL;

		values = g_list_append (values, gda_value_new_string ("This is a string"));
		values = g_list_append (values, gda_value_new_integer (200));
		values = g_list_append (values, gda_value_new_boolean (FALSE));
		values = g_list_append (values, gda_value_new_single (3.1416));
		values = g_list_append (values, gda_value_new_string ("Another string"));
		values = g_list_append (values, gda_value_new_double (4560.45672113323093));

		gda_data_model_array_append_row (GDA_DATA_MODEL_ARRAY (model), values);

		g_list_foreach (values, (GFunc) gda_value_free, NULL);
		g_list_free (values);
	}

	return GDA_DATA_MODEL (model);
}

static void
create_window (gpointer user_data)
{
	GtkWidget *window;
	GtkWidget *grid;
	GdaDataModel *model;

	window = gnome_db_window_new ("test-grid", NULL, NULL, NULL, NULL);
	g_signal_connect (G_OBJECT (window), "close", G_CALLBACK (window_closed_cb), NULL);
	gtk_widget_set_usize (window, 500, 400);
	grid = gnome_db_grid_new ();
	gtk_widget_show (grid);
	gnome_db_window_set_contents (GNOME_DB_WINDOW (window), grid);

	/* create the data model to be shown */
	model = create_data_model ();
	gnome_db_grid_set_model (GNOME_DB_GRID (grid), GDA_DATA_MODEL (model));
	g_object_unref (G_OBJECT (model));
	
	gnome_db_window_show (GNOME_DB_WINDOW (window));
}

int
main (int argc, char *argv[])
{
	gda_init ("test-grid", VERSION, argc, argv);
	gnome_program_init ("test-grid", VERSION,
                            LIBGNOMEUI_MODULE,
                            argc, argv, NULL);

	gda_main_run ((GdaInitFunc) create_window, NULL);
	return 0;
}
