/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_config_h__)
#  define __gnome_db_config_h__

#include <libgda/gda-config.h>

G_BEGIN_DECLS

/*
 * CORBA components configuration
 */

typedef enum {
	GNOME_DB_COMPONENT_TYPE_INVALID = -1,
	GNOME_DB_COMPONENT_TYPE_EXE,
	GNOME_DB_COMPONENT_TYPE_SHLIB,
	GNOME_DB_COMPONENT_TYPE_FACTORY
} GnomeDbComponentType;

typedef struct {
	gchar *id;
	gchar *location;
	GnomeDbComponentType type;
	gchar *description;
	GList *repo_ids;
	gchar *username;
	gchar *hostname;
	gchar *domain;
	GdaParameterList *properties;
} GnomeDbComponentInfo;

GList        *gnome_db_config_get_component_list (const gchar *query);
void          gnome_db_config_free_component_list (GList *list);
GdaDataModel *gnome_db_config_get_component_data_model (const gchar *query);

G_END_DECLS

#endif
