/* libmain.c
 * Copyright (C) 2006 The GNOME Foundation
 *
 * AUTHORS:
 *         Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda/libgda.h>
#include <libgnomedb/libgnomedb.h>
#include <libgnomedb/gnome-db-plugin.h>

#include "gnome-db-entry-filesel.h"
#include "gnome-db-entry-cidr.h"
#include "gnome-db-entry-passmd5.h"
#include "gnome-db-entry-text.h"

static GnomeDbDataEntry *plugin_entry_filesel_create_func (GdaDataHandler *handler, GType type, const gchar *options);
static GnomeDbDataEntry *plugin_entry_cidr_create_func (GdaDataHandler *handler, GType type, const gchar *options);
static GnomeDbDataEntry *plugin_entry_passmd5_create_func (GdaDataHandler *handler, GType type, const gchar *options);
static GnomeDbDataEntry *plugin_entry_text_create_func (GdaDataHandler *handler, GType type, const gchar *options);

GSList *
plugin_init (GError **error)
{
	GnomeDbPlugin *plugin;
	GSList *retlist = NULL;

	plugin = g_new0 (GnomeDbPlugin, 1);
	plugin->plugin_name = "filesel";
	plugin->plugin_descr = "File selection entry";
	plugin->plugin_file = NULL; /* always leave NULL */
	plugin->nb_gda_types = 0;
	plugin->valid_gda_types = NULL;
	plugin->options_xml_spec = NULL;
	plugin->entry_create_func = plugin_entry_filesel_create_func;
	plugin->cell_create_func = NULL;
	retlist = g_slist_append (retlist, plugin);

	plugin = g_new0 (GnomeDbPlugin, 1);
	plugin->plugin_name = "cird";
	plugin->plugin_descr = "Entry to hold an IPv4 network specification";
	plugin->plugin_file = NULL; /* always leave NULL */
	plugin->nb_gda_types = 1;
	plugin->valid_gda_types = g_new (GType, plugin->nb_gda_types);
	plugin->valid_gda_types [0] = G_TYPE_STRING;
	plugin->options_xml_spec = NULL;
	plugin->entry_create_func = plugin_entry_cidr_create_func;
	plugin->cell_create_func = NULL;
	retlist = g_slist_append (retlist, plugin);

	plugin = g_new0 (GnomeDbPlugin, 1);
	plugin->plugin_name = "passmd5";
	plugin->plugin_descr = "MD5 password entry";
	plugin->plugin_file = NULL; /* always leave NULL */
	plugin->nb_gda_types = 0;
	plugin->valid_gda_types = NULL;
	plugin->options_xml_spec = NULL;
	plugin->entry_create_func = plugin_entry_passmd5_create_func;
	plugin->cell_create_func = NULL;
	retlist = g_slist_append (retlist, plugin);
	
	plugin = g_new0 (GnomeDbPlugin, 1);
	plugin->plugin_name = "text";
	plugin->plugin_descr = "Multiline text entry";
	plugin->plugin_file = NULL; /* always leave NULL */
	plugin->nb_gda_types = 0;
	plugin->valid_gda_types = NULL;
	plugin->options_xml_spec = NULL;
	plugin->entry_create_func = plugin_entry_text_create_func;
	plugin->cell_create_func = NULL;
	retlist = g_slist_append (retlist, plugin);

	return retlist;
}

static GnomeDbDataEntry *
plugin_entry_filesel_create_func (GdaDataHandler *handler, GType type, const gchar *options)
{
	return (GnomeDbDataEntry *) gnome_db_entry_filesel_new (handler, type);
}

static GnomeDbDataEntry *
plugin_entry_cidr_create_func (GdaDataHandler *handler, GType type, const gchar *options)
{
	return (GnomeDbDataEntry *) gnome_db_entry_cidr_new (handler, type);
}

static GnomeDbDataEntry *
plugin_entry_passmd5_create_func (GdaDataHandler *handler, GType type, const gchar *options)
{
	return (GnomeDbDataEntry *) gnome_db_entry_passmd5_new (handler, type);
}

static GnomeDbDataEntry *
plugin_entry_text_create_func (GdaDataHandler *handler, GType type, const gchar *options)
{
	return (GnomeDbDataEntry *) gnome_db_entry_text_new (handler, type);
}
