/* Forms/Using the picture plugin
 *
 * A GnomeDbForm widget where the 'picture' plugin is used to display an image
 * internally stored as a BLOB
 */

#include <libgnomedb/libgnomedb.h>

extern GdaDict *demo_dict;
static GtkWidget *window = NULL;

GtkWidget *
do_form_pict (GtkWidget *do_widget)
{  
	if (!window) {
                GdaQuery *query;
		GtkWidget *vbox;
		GtkWidget *label;
		GdaDataModel *model;
		GtkWidget *form;
		GnomeDbRawForm *raw_form;
		GdaParameterList *data_set;
		GdaParameter *param;
		
		window = gtk_dialog_new_with_buttons ("Form with the 'picture' plugin",
						      GTK_WINDOW (do_widget),
						      0,
						      GTK_STOCK_CLOSE,
						      GTK_RESPONSE_NONE,
						      NULL);
		
		g_signal_connect (window, "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
		g_signal_connect (window, "destroy",
				  G_CALLBACK (gtk_widget_destroyed), &window);
		
		vbox = gtk_vbox_new (FALSE, 5);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), vbox, TRUE, TRUE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
		
		label = gtk_label_new ("The following GnomeDbForm widget displays data from the 'pictures' table.\n\n"
				       "The pictures are stored as BLOB inside the database and\n"
				       "are displayed using the 'picture' plugin (right click to \n"
				       "open a menu, or double click to load an image).");
		gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
		
		/* Create the demo widget */
                query = gda_query_new_from_sql (demo_dict, "SELECT id, pict FROM pictures", NULL);
		model = gda_data_model_query_new (query);
		g_object_unref (query);

		gda_data_model_query_set_modification_query (GDA_DATA_MODEL_QUERY (model),
							     "UPDATE pictures set "
							     "pict=##[:name='+1' :type='GdaBinary'] "
							     "WHERE id=##[:name='-0' :type='gint']", NULL);
		gda_data_model_query_set_modification_query (GDA_DATA_MODEL_QUERY (model),
							     "DELETE FROM pictures WHERE id=##[:name='-0' :type='gint']", NULL);
		gda_data_model_query_set_modification_query (GDA_DATA_MODEL_QUERY (model),
							     "INSERT INTO pictures (pict) "
							     "VALUES (##[:name='+1' :type='GdaBinary'])", NULL);

		form = gnome_db_form_new (model);
		g_object_unref (model);

		/* specify that we want to use the 'picture' plugin */
		g_object_get (G_OBJECT (form), "raw_form", &raw_form, NULL);
		data_set = gnome_db_basic_form_get_data_set (GNOME_DB_BASIC_FORM (raw_form));
		param = gda_parameter_list_find_param (data_set, "pict");
		g_object_set (G_OBJECT (param), "entry_plugin", "picture", NULL);

		/* force the GnomeDbBasicForm to re-create its entry widgets */
		g_object_set (G_OBJECT (raw_form), "layout_spec", NULL, NULL); 

		gtk_box_pack_start (GTK_BOX (vbox), form, TRUE, TRUE, 0);
	}

	if (!GTK_WIDGET_VISIBLE (window))
		gtk_widget_show_all (window);
	else
		gtk_widget_destroy (window);

	return window;
}


