/* gnome-db-goo-entity.h
 *
 * Copyright (C) 2007 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GOO_ENTITY__
#define __GNOME_DB_GOO_ENTITY__

#include "gnome-db-goo-item.h"
#include <libgnomedb/gnome-db-decl.h>

G_BEGIN_DECLS

/*
 * 
 * "Drag item" GooCanvas item: a GnomeDbGooItem item which is used to represent
 * an element being dragged, and destroys itself when the mouse button is released
 *
 */

#define GNOME_DB_TYPE_GOO_ENTITY          (gnome_db_goo_entity_get_type())
#define GNOME_DB_GOO_ENTITY(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_goo_entity_get_type(), GnomeDbGooEntity)
#define GNOME_DB_GOO_ENTITY_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_goo_entity_get_type (), GnomeDbGooEntityClass)
#define GNOME_DB_IS_GOO_ENTITY(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_goo_entity_get_type ())


/* struct for the object's data */
struct _GnomeDbGooEntity
{
	GnomeDbGooItem           object;

	GnomeDbGooEntityPrivate *priv;
};

/* struct for the object's class */
struct _GnomeDbGooEntityClass
{
	GnomeDbGooItemClass   parent_class;
};

/* generic widget's functions */
GType            gnome_db_goo_entity_get_type       (void) G_GNUC_CONST;
GooCanvasItem   *gnome_db_goo_entity_new            (GooCanvasItem *parent, GdaEntity *entity, 
						     gdouble x, gdouble y, ...);
GooCanvasItem   *gnome_db_goo_entity_new_target     (GooCanvasItem *parent, GdaQueryTarget *target, 
						     gdouble x, gdouble y, ...);
GnomeDbGooField *gnome_db_goo_entity_get_field_item (GnomeDbGooEntity *ce, GdaEntityField *field);
gdouble          gnome_db_goo_entity_get_field_ypos (GnomeDbGooEntity *ce, GdaEntityField *field);

G_END_DECLS

#endif
