/* gnome-db-entry-shell.h
 *
 * Copyright (C) 1999 - 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_ENTRY_SHELL__
#define __GNOME_DB_ENTRY_SHELL__

#include <gtk/gtk.h>
#include <libgnomedb/gnome-db-data-entry.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_ENTRY_SHELL          (gnome_db_entry_shell_get_type())
#define GNOME_DB_ENTRY_SHELL(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_entry_shell_get_type(), GnomeDbEntryShell)
#define GNOME_DB_ENTRY_SHELL_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_entry_shell_get_type (), GnomeDbEntryShellClass)
#define GNOME_DB_IS_ENTRY_SHELL(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_entry_shell_get_type ())

/*
 * Very simple object wrapper for the widgets that will be used to display
 * the data.
 */

typedef struct _GnomeDbEntryShell      GnomeDbEntryShell;
typedef struct _GnomeDbEntryShellClass GnomeDbEntryShellClass;
typedef struct _GnomeDbEntryShellPriv  GnomeDbEntryShellPriv;

/* struct for the object's data */
struct _GnomeDbEntryShell
{
	GtkViewport         object;

	GnomeDbEntryShellPriv  *priv;
};

/* struct for the object's class */
struct _GnomeDbEntryShellClass
{
	GtkViewportClass    parent_class;
};


GType           gnome_db_entry_shell_get_type      (void) G_GNUC_CONST;
void            gnome_db_entry_shell_pack_entry    (GnomeDbEntryShell *shell, GtkWidget *main_widget);
void            gnome_db_entry_shell_refresh       (GnomeDbEntryShell *shell);

G_END_DECLS

#endif
