// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEDBMM_EDITOR_H
#define _LIBGNOMEDBMM_EDITOR_H


#include <glibmm.h>

// -*- C++ -*- // 

/* editor.hg
 * 
 * Copyright 2006 libgnomedbmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/box.h>
#include <libgdamm/dict.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GnomeDbEditor GnomeDbEditor;
typedef struct _GnomeDbEditorClass GnomeDbEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Db
{ class Editor_Class; } // namespace Db

} // namespace Gnome
namespace Gnome
{

namespace Db
{

/** @defgroup Extras Extras
 */

/** A general purpose SQL editor.
 * 
 * @ingroup Extras
 * @ingroup DbWidgets
 */

class Editor : public Gtk::VBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Editor CppObjectType;
  typedef Editor_Class CppClassType;
  typedef GnomeDbEditor BaseObjectType;
  typedef GnomeDbEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Editor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Editor_Class;
  static CppClassType editor_class_;

  // noncopyable
  Editor(const Editor&);
  Editor& operator=(const Editor&);

protected:
  explicit Editor(const Glib::ConstructParams& construct_params);
  explicit Editor(GnomeDbEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GnomeDbEditor*       gobj()       { return reinterpret_cast<GnomeDbEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GnomeDbEditor* gobj() const { return reinterpret_cast<GnomeDbEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Editor();
  
  
  /** Set the editable state of the given editor widget.
   * @param editable Editable state.
   */
  void set_editable(bool editable = true);
  
  /** Retrieve the editable status of the given editor widget.
   * @return The editable status.
   */
  bool get_editable() const;
  
  
  /** Set the highlighting status on the given editor widget.
   * @param highlight Highlighting status.
   */
  void set_highlight(bool highlight = true);
  
  /** Retrieve the highlighting status of the given editor widget.
   * @return The highlighting status.
   */
  bool get_highlight() const;
  
  
  /** Set the contents of the given editor widget.
   * @param text Text to display in the editor.
   */

  void set_text(const Glib::ustring& text);
  
  /** Retrieve the full contents of the given editor widget.
   * @return The current contents of the editor buffer. You must free
   * the returned value when no longer needed.
   */
  Glib::ustring get_all_text() const;
  
  
  /** Load the given filename into the editor widget.
   * @param filename The file to be loaded.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool load_from_file(const std::string& filename);
  
  /** Save the current editor contents to the given file.
   * @param filename The file to save to.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool save_to_file(const std::string& filename);
  
  
  /** Moves currently selected text in the given editor widget to the clipboard.
   */
  void copy_clipboard();
  
  /** Copy currently selected text in the given editor widget to the clipboard.
   */
  void cut_clipboard();
  
  /** Paste clipboard contents into editor widget, at the current position.
   */
  void paste_clipboard();
   

};

} // namespace Db
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Db::Editor
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gnome::Db::Editor* wrap(GnomeDbEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGNOMEDBMM_EDITOR_H */

