/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __GPA_TRANSPORT_SELECTOR_H__
#define __GPA_TRANSPORT_SELECTOR_H__

/*
 * gpa-trasnport-selector.h: Simple OptionMenu for selecting transports
 *
 * Libgnomeprint is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * Libgnomeprint is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the libgnomeprint; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors :
 *   Lauris Kaplinski <lauris@ximian.com>
 *
 * Copyright (C) 2000-2001 Ximian, Inc. and Jose M. Celorio
 *
 */

#include <glib.h>

G_BEGIN_DECLS

#include "gpa-widget.h"

#define GPA_TYPE_TRANSPORT_SELECTOR (gpa_transport_selector_get_type ())
#define GPA_TRANSPORT_SELECTOR(o)          (G_TYPE_CHECK_INSTANCE_CAST ((o), GPA_TYPE_TRANSPORT_SELECTOR, GPATransportSelector))
#define GPA_TRANSPORT_SELECTOR_CLASS(k)    (G_TYPE_CHECK_CLASS_CAST    ((k), GPA_TYPE_TRANSPORT_SELECTOR, GPATransportSelectorClass))
#define GPA_IS_TRANSPORT_SELECTOR(o)       (G_TYPE_CHECK_INSTANCE_TYPE ((o), GPA_TYPE_TRANSPORT_SELECTOR))
#define GPA_IS_TRANSPORT_SELECTOR_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE    ((k), GPA_TYPE_TRANSPORT_SELECTOR))

typedef struct _GPATransportSelector      GPATransportSelector;
typedef struct _GPATransportSelectorClass GPATransportSelectorClass;

#include <libgnomeprint/private/gpa-node.h>
#include "gpa-widget.h"

struct _GPATransportSelector {
	GPAWidget widget;
	GtkWidget *hbox;
	
	GtkWidget *menu;                 /* Holds the OptionMenu where the user selects the transport to use */
	GtkWidget *filename_entry;       /* Print to file, output filename */
	GtkWidget *custom_command_entry; /* The custom printer command, "lpr -pFOO -#10" */

	/* Printer widgets */
	GtkWidget *printer_hbox;       /* Holds the printer radio_buttons and printer_entry  */
	GtkWidget *default_printer_rb; /* This is a radiobutton to select from the default lpr priter, or specifying one
							  * this is broken because this code is lpr specific but we needed a quick work around
							  * (Chema)
							  */
	GtkWidget *custom_printer_rb; /* This is the radio button used to select a custom printer*/
	GtkWidget *printer_entry;     /* This is where users specify a custom printer to use */
	
	GPANode *printer;
	guint handler; /* The handler of the signal we are listening to */
	GSList *transportlist;
};

struct _GPATransportSelectorClass {
	GPAWidgetClass widget_class;
};

GtkType gpa_transport_selector_get_type (void);

G_END_DECLS

#endif /* __GPA_TRANSPORT_SELECTOR_H__ */
