/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:37 EDT
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
/**
 * You may wish to begin by reading the {@link TextView} overview which gives an
 * overview of all the objects and data types related to the text widget and how
 * they work together.
 * 
 * <p>A TextMark is like a bookmark in a text buffer; it preserves a position in
 * the text. You can convert the mark to an iterator using {@link
 * TextBuffer#getIter(TextMark)}. Unlike iterators, marks remain valid across
 * buffer mutations, because their behavior is defined when text is inserted or
 * deleted. When text containing a mark is deleted, the mark remains in the
 * position originally occupied by the deleted text. When text is inserted at a
 * mark, a mark with left gravity will be moved to the beginning of the
 * newly-inserted text, and a mark with right gravity will be moved to the end.
 *
 * <p>Marks optionally have names; these can be convenient to avoid passing the
 * TextMark object around.
 */
public class TextMark extends GObject 
{
	/**
	 */
	protected TextMark(int handle){
		this.handle = handle;
	}

	/**
	 * Sets the visibility of mark; the insertion point is normally visible,
	 * i.e. you can see it as a vertical bar. Also, the text widget uses a
	 * visible mark to indicate where a drop will occur when
	 * dragging-and-dropping text. Most other marks are not visible. Marks are
	 * not visible by default.  
	 * @param setting Visibility of mark
	 */
	public void setVisibility(boolean setting){
		gtk_text_mark_set_visible(handle, setting);
	}

	/**
	 * Returns TRUE if the mark is visible (i.e. a cursor is displayed for it)
	 * @return true if it is visible
	 */
	public boolean getVisibility(){
		return gtk_text_mark_get_visible(handle);
	}

	/**
	 * Returns TRUE if the mark has been removed from its buffer with
	 * {@link TextBuffer#deleteMark(TextMark)}. Marks can't be used once
	 * deleted.
	 * @return True if deleted
	 */
	public boolean getDeleted(){
		return gtk_text_mark_get_deleted( handle );
	}

	/**
	 * Returns the mark name; returns NULL for anonymous marks.
	 * @return Te name of hte mark
	 */
	public String getName(){
		return gtk_text_mark_get_name(handle);
	}

	/**
	 * Gets the buffer this mark is located inside, or NULL if the mark is deleted.
	 * @return The buffer/
	 */
	public TextBuffer getBuffer(){
		return new TextBuffer( gtk_text_mark_get_buffer(handle) );
	}

	/**
	 * Determines whether the mark has left gravity.
	 * @return TRUE if the mark has left gravity, FALSE otherwise
	 */
	public boolean getLeftGravity(){
		return gtk_text_mark_get_left_gravity(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_text_mark_get_type());
	}

	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_text_mark_get_type ();
    native static final protected void gtk_text_mark_set_visible (int mark, boolean setting);
    native static final protected boolean gtk_text_mark_get_visible (int mark);
    native static final protected String gtk_text_mark_get_name (int mark);
    native static final protected boolean gtk_text_mark_get_deleted (int mark);
    native static final protected int gtk_text_mark_get_buffer (int mark);
    native static final protected boolean gtk_text_mark_get_left_gravity (int mark);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

